/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.AES;
import app.termora.Application;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicIcon;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.OptionsPane;
import app.termora.RSA;
import app.termora.ScopeKt;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountManager;
import app.termora.account.AccountOption;
import app.termora.account.AccountOption$LoginResult$;
import app.termora.account.AccountProperties;
import app.termora.account.LoginServerDialog;
import app.termora.account.PullService;
import app.termora.account.PushService;
import app.termora.account.Server;
import app.termora.account.ServerManager;
import app.termora.account.ServerSignedExtension;
import app.termora.account.Subscription;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.database.DatabaseManager;
import app.termora.plugin.Extension;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.Closeable;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLEncoder;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXHyperlink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002BCB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020*H\u0002J\u0010\u0010,\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020'H\u0002J\b\u00100\u001a\u00020'H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020'H\u0016J\u001e\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u00101\u001a\u0002022\u0006\u0010$\u001a\u00020%H\u0002J\b\u00107\u001a\u00020'H\u0002J\b\u00108\u001a\u00020'H\u0002J\u0010\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020.H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020*H\u0016J\b\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020=H\u0016R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lapp/termora/account/AccountOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "Lapp/termora/Disposable;", "<init>", "()V", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "databaseManager", "Lapp/termora/database/DatabaseManager;", "getDatabaseManager", "()Lapp/termora/database/DatabaseManager;", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "accountProperties", "Lapp/termora/account/AccountProperties;", "getAccountProperties", "()Lapp/termora/account/AccountProperties;", "userInfoPanel", "lastSynchronizationOnLabel", "Ljavax/swing/JLabel;", "serverManager", "Lapp/termora/account/ServerManager;", "getServerManager", "()Lapp/termora/account/ServerManager;", "cardLayout", "Ljava/awt/CardLayout;", "contentPanel", "loginPanel", "busyLabel", "Lorg/jdesktop/swingx/JXBusyLabel;", "httpServer", "Lcom/sun/net/httpserver/HttpServer;", "initView", "", "initEvents", "getCenterComponent", "Ljavax/swing/JComponent;", "getLoginComponent", "createActionPanel", "isFreePlan", "", "showLoginPanel", "onLogin", "server", "Lapp/termora/account/Server;", "dispose", "processLogin", "Ljava/util/concurrent/CompletableFuture;", "Lapp/termora/account/AccountOption$LoginResult;", "refreshUserInfoPanel", "refreshLoginPanel", "getIcon", "Ljavax/swing/Icon;", "isSelected", "getTitle", "", "getJComponent", "getAnchor", "Lapp/termora/OptionsPane$Anchor;", "getIdentifier", "Companion", "LoginResult", "termora"})
@SourceDebugExtension(value={"SMAP\nAccountOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountOption.kt\napp/termora/account/AccountOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,438:1\n1#2:439\n222#3:440\n*S KotlinDebug\n*F\n+ 1 AccountOption.kt\napp/termora/account/AccountOption\n*L\n347#1:440\n*E\n"})
public final class AccountOption
extends JPanel
implements OptionsPane.Option,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JPanel userInfoPanel = new JPanel(new BorderLayout());
    @NotNull
    private final JLabel lastSynchronizationOnLabel = new JLabel();
    @NotNull
    private final CardLayout cardLayout = new CardLayout();
    @NotNull
    private final JPanel contentPanel = new JPanel(this.cardLayout);
    @NotNull
    private final JPanel loginPanel = new JPanel(new BorderLayout());
    @NotNull
    private final JXBusyLabel busyLabel = new JXBusyLabel();
    @Nullable
    private HttpServer httpServer;
    private static final Logger log = LoggerFactory.getLogger(AccountOption.class);

    public AccountOption() {
        super(new BorderLayout());
        this.initView();
        this.initEvents();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final DatabaseManager getDatabaseManager() {
        return DatabaseManager.Companion.getInstance();
    }

    private final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    private final AccountProperties getAccountProperties() {
        return AccountProperties.Companion.getInstance();
    }

    private final ServerManager getServerManager() {
        return ServerManager.Companion.getInstance();
    }

    private final void initView() {
        this.refreshUserInfoPanel();
        this.refreshLoginPanel();
        this.contentPanel.add((Component)this.userInfoPanel, "UserInfo");
        this.contentPanel.add((Component)this.loginPanel, "Login");
        this.cardLayout.show(this.contentPanel, "UserInfo");
        this.add((Component)this.contentPanel, "Center");
    }

    private final void initEvents() {
        Disposable it = DynamicExtensionHandler.Companion.getInstance().register(ServerSignedExtension.class, (Extension)new ServerSignedExtension(this){
            final /* synthetic */ AccountOption this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSignedChanged(boolean oldSigned, boolean newSigned) {
                AccountOption.access$refreshUserInfoPanel(this.this$0);
            }
        });
        boolean bl = false;
        Disposer.register(this, it);
        it = DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new AccountExtension(this){
            final /* synthetic */ AccountOption this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAccountChanged(Account oldAccount, Account newAccount) {
                Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
                Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
                if (!Intrinsics.areEqual((Object)oldAccount.getId(), (Object)newAccount.getId())) {
                    AccountOption.access$refreshUserInfoPanel(this.this$0);
                }
            }
        });
        boolean bl2 = false;
        Disposer.register(this, it);
    }

    private final JComponent getCenterComponent() {
        String string;
        FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
        int rows = 0;
        rows = 1;
        int step = 2;
        Subscription subscription = this.getAccountManager().getSubscription();
        boolean isFreePlan = this.getAccountManager().isFreePlan();
        boolean isLocally = this.getAccountManager().isLocally();
        String validTo = isFreePlan ? "-" : (subscription.getEndAt() >= Long.MAX_VALUE ? I18n.INSTANCE.getString("termora.settings.account.lifetime") : DateFormatUtils.format((Date)new Date(subscription.getEndAt()), (String)I18n.INSTANCE.getString("termora.date-format")));
        String lastSynchronizationOn = isFreePlan ? "-" : DateFormatUtils.format((Date)new Date(this.getAccountManager().getLastSynchronizationOn()), (String)I18n.INSTANCE.getString("termora.date-format"));
        String server = this.getAccountManager().getServer();
        String email = this.getAccountManager().getEmail();
        if (isLocally) {
            server = I18n.INSTANCE.getString("termora.settings.account.locally");
            email = I18n.INSTANCE.getString("termora.settings.account.locally");
        }
        Box planBox = Box.createHorizontalBox();
        planBox.add(new JLabel(isLocally ? "-" : subscription.getPlan().name()));
        if (isFreePlan && !isLocally) {
            planBox.add(Box.createHorizontalStrut(16));
            String string2 = I18n.INSTANCE.getString("termora.settings.account.upgrade");
            JXHyperlink upgrade2 = new JXHyperlink((Action)((Object)new AnAction(this, string2){
                final /* synthetic */ AccountOption this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    URI uRI = URI.create(AccountOption.access$getAccountManager(this.this$0).getServer() + "/v1/client/redirect?to=upgrade&version=" + Application.INSTANCE.getVersion());
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                    Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
                }
            }));
            upgrade2.setFocusable(false);
            planBox.add((Component)upgrade2);
        }
        Box serverBox = Box.createHorizontalBox();
        serverBox.add(new JLabel(server));
        if (!isLocally) {
            serverBox.add(Box.createHorizontalStrut(8));
            if (!this.getAccountManager().isSigned()) {
                string = I18n.INSTANCE.getString("termora.settings.account.verify");
                DynamicIcon dynamicIcon = Icons.INSTANCE.getError();
                JXHyperlink upgrade3 = new JXHyperlink((Action)((Object)new AnAction(string, dynamicIcon){

                    protected void actionPerformed(AnActionEvent evt) {
                        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                        URI uRI = URI.create("https://www.termora.app?version=" + Application.INSTANCE.getVersion());
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
                    }
                }));
                upgrade3.setFocusable(false);
                v0 = serverBox.add((Component)upgrade3);
            } else {
                v0 = serverBox.add(new JLabel((Icon)((Object)Icons.INSTANCE.getSuccess())));
            }
        }
        this.lastSynchronizationOnLabel.setText(lastSynchronizationOn);
        String $this$getCenterComponent_u24lambda_u240 = string = FormBuilder.create().layout(layout).debug(false).add(I18n.INSTANCE.getString("termora.settings.account.server") + ":", new Object[0]).xy(1, rows).add((Component)serverBox).xy(3, rows);
        boolean bl = false;
        String $this$getCenterComponent_u24lambda_u241 = string = string.add(I18n.INSTANCE.getString("termora.settings.account") + ":", new Object[0]).xy(1, rows += step).add(email, new Object[0]).xy(3, rows);
        boolean bl2 = false;
        String $this$getCenterComponent_u24lambda_u242 = string = string.add(I18n.INSTANCE.getString("termora.settings.account.subscription") + ":", new Object[0]).xy(1, rows += step).add((Component)planBox).xy(3, rows);
        boolean bl3 = false;
        String $this$getCenterComponent_u24lambda_u243 = string = string.add(I18n.INSTANCE.getString("termora.settings.account.valid-to") + ":", new Object[0]).xy(1, rows += step).add(validTo, new Object[0]).xy(3, rows);
        boolean bl4 = false;
        String $this$getCenterComponent_u24lambda_u244 = string = string.add(I18n.INSTANCE.getString("termora.settings.account.synchronization-on") + ":", new Object[0]).xy(1, rows += step).add((Component)this.lastSynchronizationOnLabel).xy(3, rows);
        boolean bl5 = false;
        String $this$getCenterComponent_u24lambda_u245 = string = string.add((Component)this.createActionPanel(isFreePlan)).xyw(1, rows += step, 3);
        boolean bl6 = false;
        rows += step;
        JPanel jPanel = string.build();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
        return jPanel;
    }

    private final JComponent getLoginComponent() {
        FormLayout layout = new FormLayout("default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
        String string = I18n.INSTANCE.getString("termora.cancel");
        JXHyperlink cancelBtn2 = new JXHyperlink((Action)((Object)new AnAction(this, string){
            final /* synthetic */ AccountOption this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            protected void actionPerformed(AnActionEvent evt) {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                HttpServer httpServer = AccountOption.access$getHttpServer$p(this.this$0);
                if (httpServer != null) {
                    httpServer.stop(0);
                }
                AccountOption.access$getCardLayout$p(this.this$0).show(AccountOption.access$getContentPanel$p(this.this$0), "UserInfo");
            }
        }));
        JLabel tipLabel = new JLabel(I18n.INSTANCE.getString("termora.settings.account.wait-login"));
        tipLabel.setForeground(UIManager.getColor("TextField.placeholderForeground"));
        JPanel jPanel = FormBuilder.create().layout(layout).debug(false).padding("10dlu,0,0,0", new Object[0]).add((Component)this.busyLabel).xy(1, 1, "center, fill").add((Component)tipLabel).xy(1, 3, "center, fill").add((Component)cancelBtn2).xy(1, 5, "center, fill").build();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createActionPanel(boolean isFreePlan) {
        Box actionBox = Box.createHorizontalBox();
        actionBox.add(Box.createHorizontalGlue());
        Set actions = new LinkedHashSet();
        if (this.getAccountManager().isLocally()) {
            var4_4 = I18n.INSTANCE.getString("termora.settings.account.login") + "...";
            Iterator iterator2 = var4_4 = new JXHyperlink((Action)((Object)new AnAction(this, (String)((Object)var4_4)){
                final /* synthetic */ AccountOption this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    AccountOption.access$onLogin(this.this$0);
                }
            }));
            var7_6 = actions;
            boolean bl = false;
            $this$createActionPanel_u24lambda_u240.setFocusable(false);
            v0 = var7_6.add(var4_4);
        } else {
            void $this$createActionPanel_u24lambda_u242;
            Iterator $this$createActionPanel_u24lambda_u241;
            if (!isFreePlan) {
                var4_4 = I18n.INSTANCE.getString("termora.settings.account.sync-now");
                $this$createActionPanel_u24lambda_u240 = var4_4 = new JXHyperlink((Action)((Object)new AnAction(this, (String)((Object)var4_4)){
                    final /* synthetic */ AccountOption this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    protected void actionPerformed(AnActionEvent evt) {
                        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                        AccountOption.access$getAccountProperties(this.this$0).setNextSynchronizationSince(0L);
                        PullService.Companion.getInstance().trigger();
                        PushService.Companion.getInstance().trigger();
                        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this, null){
                            int label;
                            final /* synthetic */ AccountOption this$0;
                            final /* synthetic */ createActionPanel.3 this$1;
                            {
                                this.this$0 = $receiver;
                                this.this$1 = $receiver2;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountOption.access$getAccountManager(this.this$0).refreshAccount();
                                        this.label = 1;
                                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                            int label;
                                            final /* synthetic */ createActionPanel.3 this$0;
                                            final /* synthetic */ AccountOption this$1;
                                            {
                                                this.this$0 = $receiver;
                                                this.this$1 = $receiver2;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.this$0.setEnabled(false);
                                                        AccountOption.access$getLastSynchronizationOnLabel$p(this.this$1).setText(DateFormatUtils.format((Date)new Date(System.currentTimeMillis()), (String)I18n.INSTANCE.getString("termora.date-format")));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1500, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl23
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl23:
                                        // 2 sources

                                        this.label = 3;
                                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, null){
                                            int label;
                                            final /* synthetic */ createActionPanel.3 this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.this$0.setEnabled(true);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v2 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl31
                                    }
                                    case 3: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl31:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }));
                var7_6 = actions;
                boolean bl = false;
                $this$createActionPanel_u24lambda_u241.setFocusable(false);
                var7_6.add(var4_4);
            }
            var4_4 = I18n.INSTANCE.getString("termora.settings.account.logout");
            $this$createActionPanel_u24lambda_u241 = var4_4 = new JXHyperlink((Action)((Object)new AnAction(this, (String)((Object)var4_4)){
                final /* synthetic */ AccountOption this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    boolean hasUnsyncedData = !((Collection)AccountOption.access$getDatabaseManager(this.this$0).unsyncedData()).isEmpty();
                    String message = hasUnsyncedData ? "termora.settings.account.unsynced-logout-confirm" : "termora.settings.account.logout-confirm";
                    int option = OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, AccountOption.access$getOwner(this.this$0), I18n.INSTANCE.getString(message), null, 2, 3, null, null, null, null, 484, null);
                    if (option != 0) {
                        return;
                    }
                    AccountManager.Companion.getInstance().logout$termora();
                }
            }));
            var7_6 = actions;
            boolean bl = false;
            $this$createActionPanel_u24lambda_u242.setFocusable(false);
            v0 = var7_6.add(var4_4);
        }
        for (JComponent component : actions) {
            actionBox.add(component);
            if (Intrinsics.areEqual((Object)CollectionsKt.last((Iterable)actions), (Object)component)) continue;
            actionBox.add(Box.createHorizontalStrut(8));
        }
        actionBox.add(Box.createHorizontalGlue());
        Intrinsics.checkNotNull((Object)actionBox);
        return actionBox;
    }

    private final void showLoginPanel() {
        this.refreshLoginPanel();
        this.busyLabel.setBusy(true);
        this.cardLayout.show(this.contentPanel, "Login");
    }

    private final void onLogin() {
        HttpServer httpServer = this.httpServer;
        if (httpServer != null) {
            httpServer.stop(0);
        }
        Window window = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"<get-owner>(...)");
        LoginServerDialog dialog2 = new LoginServerDialog(window);
        dialog2.setVisible(true);
        Server server = dialog2.getServer();
        if (server == null) {
            return;
        }
        Server server2 = server;
        this.showLoginPanel();
        this.onLogin(server2);
    }

    private final void onLogin(Server server) {
        HttpServer httpServer;
        HttpServer $this$onLogin_u24lambda_u240 = httpServer = HttpServer.create(new InetSocketAddress("127.0.0.1", 0), 0);
        boolean bl = false;
        this.httpServer = $this$onLogin_u24lambda_u240;
        HttpServer httpServer2 = httpServer;
        Intrinsics.checkNotNull((Object)httpServer2);
        CompletableFuture<LoginResult> future2 = this.processLogin(server, httpServer2);
        Job loginJob2 = BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(future2, this, server, httpServer2, null){
            Object L$0;
            int label;
            final /* synthetic */ CompletableFuture<LoginResult> $future;
            final /* synthetic */ AccountOption this$0;
            final /* synthetic */ Server $server;
            final /* synthetic */ HttpServer $httpServer;
            {
                this.$future = $future;
                this.this$0 = $receiver;
                this.$server = $server;
                this.$httpServer = $httpServer;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        loginResult = this.$future.get(5L, TimeUnit.MINUTES);
                        AccountOption.access$getServerManager(this.this$0).login(this.$server, loginResult.getRefreshToken(), loginResult.getPassword());
                        this.label = 1;
                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ AccountOption this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountOption.access$getCardLayout$p(this.this$0).show(AccountOption.access$getContentPanel$p(this.this$0), "UserInfo");
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        this.$httpServer.stop(0);
                        break;
                    }
                }
                catch (Exception e) {
                    if (AccountOption.access$getLog$cp().isErrorEnabled()) {
                        AccountOption.access$getLog$cp().error(e.getMessage(), (Throwable)e);
                    }
                    this.L$0 = SpillingKt.nullOutSpilledVariable((Object)e);
                    this.label = 2;
                    v1 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, e, null){
                        int label;
                        final /* synthetic */ AccountOption this$0;
                        final /* synthetic */ Exception $e;
                        {
                            this.this$0 = $receiver;
                            this.$e = $e;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Component component = AccountOption.access$getOwner(this.this$0);
                                    String string = this.$e.getMessage();
                                    if (string == null) {
                                        string = "";
                                    }
                                    CharSequence charSequence = StringUtils.defaultIfBlank((CharSequence)string, (CharSequence)I18n.INSTANCE.getString("termora.settings.account.login-failed"));
                                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"defaultIfBlank(...)");
                                    OptionPane.showMessageDialog$default(OptionPane.INSTANCE, component, (String)charSequence, null, 0, null, 20, null);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)((Continuation)this));
                    ** if (v1 != var3_2) goto lbl28
lbl27:
                    // 1 sources

                    return var3_2;
lbl28:
                    // 1 sources

                    ** GOTO lbl35
                }
                {
                    case 2: {
                        e = (Exception)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl35:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 3;
                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v2 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl44
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl44:
                        // 2 sources

                        this.$httpServer.stop(0);
                        break;
                    }
                }
                {
                    catch (Throwable var2_6) {
                        this.L$0 = var2_6;
                        this.label = 4;
                        v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new /* invalid duplicate definition of identical inner class */), (Continuation)((Continuation)this));
                        if (v3 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl57
                    }
                }
                {
                    case 4: {
                        var2_7 = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl57:
                        // 2 sources

                        this.$httpServer.stop(0);
                        throw var2_7;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Disposer.register(this, new Disposable(loginJob2, httpServer2){
            final /* synthetic */ Job $loginJob;
            final /* synthetic */ HttpServer $httpServer;
            {
                this.$loginJob = $loginJob;
                this.$httpServer = $httpServer;
            }

            public void dispose() {
                Job.DefaultImpls.cancel$default((Job)this.$loginJob, null, (int)1, null);
                this.$httpServer.stop(0);
            }
        });
    }

    @Override
    public void dispose() {
        this.busyLabel.setBusy(false);
        Disposable.super.dispose();
    }

    private final CompletableFuture<LoginResult> processLogin(Server server, HttpServer httpServer) {
        KeyPair keypair = RSA.INSTANCE.generateKeyPair(2048);
        CompletableFuture<LoginResult> future2 = new CompletableFuture<LoginResult>();
        httpServer.createContext("/callback", arg_0 -> AccountOption.processLogin$lambda$0(keypair, future2, arg_0));
        httpServer.start();
        StringBuilder sb = new StringBuilder();
        StringBuilder redirect = new StringBuilder();
        redirect.append("/device?callback=").append("http://127.0.0.1:" + httpServer.getAddress().getPort() + "/callback");
        StringBuilder stringBuilder = redirect.append("&from=device&publicKey=");
        byte[] byArray = keypair.getPublic().getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        stringBuilder.append(HexExtensionsKt.toHexString$default((byte[])byArray, null, (int)1, null));
        redirect.append("&format=hex&device=termora&device-version=").append(Application.INSTANCE.getVersion());
        sb.append(server.getServer());
        sb.append("/v1/client/redirect?to=login&from=device");
        sb.append("&redirect=").append(URLEncoder.encode(redirect.toString(), Charsets.UTF_8));
        URI uRI = URI.create(sb.toString());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
        return future2;
    }

    private final void refreshUserInfoPanel() {
        this.userInfoPanel.removeAll();
        this.userInfoPanel.add((Component)this.getCenterComponent(), "Center");
        this.userInfoPanel.revalidate();
        this.userInfoPanel.repaint();
    }

    private final void refreshLoginPanel() {
        this.loginPanel.removeAll();
        this.loginPanel.add((Component)this.getLoginComponent(), "Center");
        this.loginPanel.revalidate();
        this.loginPanel.repaint();
    }

    @Override
    @NotNull
    public Icon getIcon(boolean isSelected) {
        return (Icon)((Object)Icons.INSTANCE.getUser());
    }

    @Override
    @NotNull
    public String getTitle() {
        return I18n.INSTANCE.getString("termora.settings.account");
    }

    @Override
    @NotNull
    public JComponent getJComponent() {
        return this;
    }

    @Override
    @NotNull
    public OptionsPane.Anchor getAnchor() {
        return OptionsPane.Anchor.First.INSTANCE;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "Account";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void processLogin$lambda$0(KeyPair $keypair, CompletableFuture $future, HttpExchange exchange) {
        String method = exchange.getRequestMethod();
        if (StringsKt.equals((String)method, (String)"OPTIONS", (boolean)true)) {
            exchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            exchange.getResponseHeaders().add("Access-Control-Allow-Methods", "POST, OPTIONS");
            exchange.getResponseHeaders().add("Access-Control-Allow-Headers", "Content-Type");
            exchange.sendResponseHeaders(204, -1L);
        } else {
            Object object;
            LoginResult loginResult;
            block11: {
                loginResult = null;
                if (StringsKt.equals((String)method, (String)"POST", (boolean)true)) {
                    try {
                        void this_$iv;
                        byte[] byArray = exchange.getRequestBody().readAllBytes();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                        object = byArray;
                        String text = new String((byte[])object, Charsets.UTF_8);
                        object = Application.INSTANCE.getOhMyJson();
                        String string$iv = text;
                        boolean $i$f$decodeFromString = false;
                        this_$iv.getSerializersModule();
                        loginResult = (LoginResult)this_$iv.decodeFromString((DeserializationStrategy)LoginResult.Companion.serializer(), string$iv);
                        PrivateKey privateKey = $keypair.getPrivate();
                        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"getPrivate(...)");
                        byte[] byArray2 = Hex.decodeHex((String)loginResult.getSecretKey());
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decodeHex(...)");
                        byte[] secretKey = RSA.INSTANCE.decrypt(privateKey, byArray2);
                        PrivateKey privateKey2 = $keypair.getPrivate();
                        Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"getPrivate(...)");
                        byte[] byArray3 = Hex.decodeHex((String)loginResult.getSecretIv());
                        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"decodeHex(...)");
                        byte[] secretIv = RSA.INSTANCE.decrypt(privateKey2, byArray3);
                        byte[] byArray4 = Hex.decodeHex((String)loginResult.getPassword());
                        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"decodeHex(...)");
                        byte[] password = AES.CBC.INSTANCE.decrypt(secretKey, secretIv, byArray4);
                        byte[] byArray5 = Hex.decodeHex((String)loginResult.getRefreshToken());
                        Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"decodeHex(...)");
                        byte[] refreshToken = AES.CBC.INSTANCE.decrypt(secretKey, secretIv, byArray5);
                        loginResult = LoginResult.copy$default(loginResult, new String(password, Charsets.UTF_8), new String(refreshToken, Charsets.UTF_8), null, null, 12, null);
                    }
                    catch (Exception e) {
                        if (!log.isErrorEnabled()) break block11;
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            object = "OK";
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] response = byArray;
            exchange.getResponseHeaders().add("Access-Control-Allow-Origin", "*");
            exchange.sendResponseHeaders(200, response.length);
            object = exchange.getResponseBody();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)object;
                boolean bl = false;
                it.write(response);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            if (loginResult != null) {
                $future.complete(loginResult);
            }
        }
        IOUtils.closeQuietly(() -> AccountOption.processLogin$lambda$0$1(exchange));
    }

    private static final void processLogin$lambda$0$1(HttpExchange $exchange) {
        $exchange.close();
    }

    public static final /* synthetic */ void access$refreshUserInfoPanel(AccountOption $this) {
        $this.refreshUserInfoPanel();
    }

    public static final /* synthetic */ AccountManager access$getAccountManager(AccountOption $this) {
        return $this.getAccountManager();
    }

    public static final /* synthetic */ HttpServer access$getHttpServer$p(AccountOption $this) {
        return $this.httpServer;
    }

    public static final /* synthetic */ CardLayout access$getCardLayout$p(AccountOption $this) {
        return $this.cardLayout;
    }

    public static final /* synthetic */ JPanel access$getContentPanel$p(AccountOption $this) {
        return $this.contentPanel;
    }

    public static final /* synthetic */ void access$onLogin(AccountOption $this) {
        $this.onLogin();
    }

    public static final /* synthetic */ AccountProperties access$getAccountProperties(AccountOption $this) {
        return $this.getAccountProperties();
    }

    public static final /* synthetic */ JLabel access$getLastSynchronizationOnLabel$p(AccountOption $this) {
        return $this.lastSynchronizationOnLabel;
    }

    public static final /* synthetic */ DatabaseManager access$getDatabaseManager(AccountOption $this) {
        return $this.getDatabaseManager();
    }

    public static final /* synthetic */ Window access$getOwner(AccountOption $this) {
        return $this.getOwner();
    }

    public static final /* synthetic */ ServerManager access$getServerManager(AccountOption $this) {
        return $this.getServerManager();
    }

    public static final /* synthetic */ Logger access$getLog$cp() {
        return log;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/AccountOption$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 &2\u00020\u0001:\u0002%&B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bBC\b\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u0007\u0010\rJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0001\u00a2\u0006\u0002\b$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000f\u00a8\u0006'"}, d2={"Lapp/termora/account/AccountOption$LoginResult;", "", "password", "", "refreshToken", "secretKey", "secretIv", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getPassword", "()Ljava/lang/String;", "getRefreshToken", "getSecretKey", "getSecretIv", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    private static final class LoginResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String password;
        @NotNull
        private final String refreshToken;
        @NotNull
        private final String secretKey;
        @NotNull
        private final String secretIv;

        public LoginResult(@NotNull String password, @NotNull String refreshToken, @NotNull String secretKey, @NotNull String secretIv) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)secretIv, (String)"secretIv");
            this.password = password;
            this.refreshToken = refreshToken;
            this.secretKey = secretKey;
            this.secretIv = secretIv;
        }

        @NotNull
        public final String getPassword() {
            return this.password;
        }

        @NotNull
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @NotNull
        public final String getSecretKey() {
            return this.secretKey;
        }

        @NotNull
        public final String getSecretIv() {
            return this.secretIv;
        }

        @NotNull
        public final String component1() {
            return this.password;
        }

        @NotNull
        public final String component2() {
            return this.refreshToken;
        }

        @NotNull
        public final String component3() {
            return this.secretKey;
        }

        @NotNull
        public final String component4() {
            return this.secretIv;
        }

        @NotNull
        public final LoginResult copy(@NotNull String password, @NotNull String refreshToken, @NotNull String secretKey, @NotNull String secretIv) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)secretIv, (String)"secretIv");
            return new LoginResult(password, refreshToken, secretKey, secretIv);
        }

        public static /* synthetic */ LoginResult copy$default(LoginResult loginResult, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = loginResult.password;
            }
            if ((n & 2) != 0) {
                string2 = loginResult.refreshToken;
            }
            if ((n & 4) != 0) {
                string3 = loginResult.secretKey;
            }
            if ((n & 8) != 0) {
                string4 = loginResult.secretIv;
            }
            return loginResult.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "LoginResult(password=" + this.password + ", refreshToken=" + this.refreshToken + ", secretKey=" + this.secretKey + ", secretIv=" + this.secretIv + ")";
        }

        public int hashCode() {
            int result2 = this.password.hashCode();
            result2 = result2 * 31 + this.refreshToken.hashCode();
            result2 = result2 * 31 + this.secretKey.hashCode();
            result2 = result2 * 31 + this.secretIv.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoginResult)) {
                return false;
            }
            LoginResult loginResult = (LoginResult)other;
            if (!Intrinsics.areEqual((Object)this.password, (Object)loginResult.password)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.refreshToken, (Object)loginResult.refreshToken)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.secretKey, (Object)loginResult.secretKey)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.secretIv, (Object)loginResult.secretIv);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(LoginResult self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.password);
            output.encodeStringElement(serialDesc, 1, self.refreshToken);
            output.encodeStringElement(serialDesc, 2, self.secretKey);
            output.encodeStringElement(serialDesc, 3, self.secretIv);
        }

        public /* synthetic */ LoginResult(int seen0, String password, String refreshToken, String secretKey, String secretIv, SerializationConstructorMarker serializationConstructorMarker) {
            if (15 != (0xF & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)LoginResult$$serializer.INSTANCE.getDescriptor());
            }
            this.password = password;
            this.refreshToken = refreshToken;
            this.secretKey = secretKey;
            this.secretIv = secretIv;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/AccountOption$LoginResult$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/AccountOption$LoginResult;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<LoginResult> serializer() {
                return (KSerializer)LoginResult$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

