/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.Application;
import app.termora.ApplicationRunnerExtension;
import app.termora.ApplicationScope;
import app.termora.RSA;
import app.termora.ResponseException;
import app.termora.ScopeKt;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountOwner;
import app.termora.account.AccountProperties;
import app.termora.account.ServerManager;
import app.termora.account.Subscription;
import app.termora.account.SubscriptionPlan;
import app.termora.account.Team;
import app.termora.database.OwnerType;
import app.termora.plugin.ExtensionManager;
import java.io.Closeable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.ByteArraySerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u0000 :2\u00020\u0001:\u0002:;B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0012\u001a\u00020\u0010J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0010J\u0006\u0010$\u001a\u00020\u0010J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100&J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0&J\u0006\u0010)\u001a\u00020\u001fJ\u0006\u0010*\u001a\u00020\u0015J\u0006\u0010+\u001a\u00020\u001fJ\r\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b.J\u0015\u0010/\u001a\u00020-2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b0J\u0018\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\t2\u0006\u00103\u001a\u00020\tH\u0002J\r\u00104\u001a\u00020-H\u0000\u00a2\u0006\u0002\b5J\b\u00106\u001a\u00020\tH\u0002J\b\u00107\u001a\u00020-H\u0016J\u0006\u00108\u001a\u00020-J\u0006\u00109\u001a\u00020-R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006<"}, d2={"Lapp/termora/account/AccountManager;", "Lapp/termora/ApplicationRunnerExtension;", "<init>", "()V", "serverManager", "Lapp/termora/account/ServerManager;", "getServerManager", "()Lapp/termora/account/ServerManager;", "account", "Lapp/termora/account/Account;", "accountProperties", "Lapp/termora/account/AccountProperties;", "getAccountProperties", "()Lapp/termora/account/AccountProperties;", "getAccount", "getAccountId", "", "getServer", "getEmail", "getSubscriptions", "", "Lapp/termora/account/Subscription;", "getTeams", "Lapp/termora/account/Team;", "getSecretKey", "", "getPublicKey", "Ljava/security/PublicKey;", "getPrivateKey", "Ljava/security/PrivateKey;", "isSigned", "", "isLocally", "getLastSynchronizationOn", "", "getAccessToken", "getRefreshToken", "getOwnerIds", "", "getOwners", "Lapp/termora/account/AccountOwner;", "isFreePlan", "getSubscription", "hasTeamFeature", "refreshToken", "", "refreshToken$termora", "login", "login$termora", "notifyAccountChanged", "oldAccount", "newAccount", "logout", "logout$termora", "locally", "ready", "refresh", "refreshAccount", "Companion", "AccountApplicationRunnerExtension", "termora"})
@SourceDebugExtension(value={"SMAP\nAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountManager.kt\napp/termora/account/AccountManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,306:1\n1563#2:307\n1634#2,3:308\n774#2:312\n865#2,2:313\n774#2:315\n865#2,2:316\n774#2:318\n865#2,2:319\n1761#2,3:321\n230#2,2:324\n1761#2,3:326\n230#2,2:329\n1761#2,3:331\n230#2,2:334\n1563#2:341\n1634#2,3:342\n1#3:311\n205#4:336\n222#4:337\n205#4:338\n205#4:339\n205#4:340\n*S KotlinDebug\n*F\n+ 1 AccountManager.kt\napp/termora/account/AccountManager\n*L\n54#1:307\n54#1:308,3\n72#1:312\n72#1:313,2\n73#1:315\n73#1:316,2\n74#1:318\n74#1:319,2\n77#1:321,3\n78#1:324,2\n79#1:326,3\n80#1:329,2\n81#1:331,3\n82#1:334,2\n254#1:341\n254#1:342,3\n100#1:336\n121#1:337\n148#1:338\n149#1:339\n152#1:340\n*E\n"})
public final class AccountManager
implements ApplicationRunnerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Account account = this.locally();
    private static final Logger log = LoggerFactory.getLogger(AccountManager.class);

    private AccountManager() {
    }

    private final ServerManager getServerManager() {
        return ServerManager.Companion.getInstance();
    }

    private final AccountProperties getAccountProperties() {
        return AccountProperties.Companion.getInstance();
    }

    @NotNull
    public final Account getAccount() {
        return this.account;
    }

    @NotNull
    public final String getAccountId() {
        return this.account.getId();
    }

    @NotNull
    public final String getServer() {
        return this.account.getServer();
    }

    @NotNull
    public final String getEmail() {
        return this.account.getEmail();
    }

    @NotNull
    public final List<Subscription> getSubscriptions() {
        return this.account.getSubscriptions();
    }

    @NotNull
    public final List<Team> getTeams() {
        return this.account.getTeams();
    }

    @NotNull
    public final byte[] getSecretKey() {
        return this.account.getSecretKey();
    }

    @NotNull
    public final PublicKey getPublicKey() {
        return this.account.getPublicKey();
    }

    @NotNull
    public final PrivateKey getPrivateKey() {
        return this.account.getPrivateKey();
    }

    public final boolean isSigned() {
        return this.getAccountProperties().getSigned();
    }

    public final boolean isLocally() {
        return this.account.isLocally();
    }

    public final long getLastSynchronizationOn() {
        return this.getAccountProperties().getLastSynchronizationOn();
    }

    @NotNull
    public final String getAccessToken() {
        return this.account.getAccessToken();
    }

    @NotNull
    public final String getRefreshToken() {
        return this.account.getRefreshToken();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<String> getOwnerIds() {
        List list;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.account.getTeams();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Team team = (Team)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List $this$getOwnerIds_u24lambda_u241 = list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        boolean bl = false;
        $this$getOwnerIds_u24lambda_u241.add(this.getAccountId());
        return CollectionsKt.toSet((Iterable)list);
    }

    @NotNull
    public final Set<AccountOwner> getOwners() {
        Set owners = new LinkedHashSet();
        owners.add(new AccountOwner(this.getAccountId(), this.getEmail(), OwnerType.User));
        for (Team team : this.getTeams()) {
            owners.add(new AccountOwner(team.getId(), team.getName(), OwnerType.Team));
        }
        return owners;
    }

    public final boolean isFreePlan() {
        return this.isLocally() || this.getSubscription().getPlan() == SubscriptionPlan.Free;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Subscription getSubscription() {
        if (!this.isLocally()) {
            boolean bl;
            boolean $i$f$first;
            Iterable $this$first$iv;
            Object element$iv2;
            long now;
            List pros;
            block23: {
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                List teams;
                block21: {
                    boolean bl3;
                    List enterprises;
                    block19: {
                        void $this$filterTo$iv$iv;
                        void $this$filterTo$iv$iv2;
                        void $this$filterTo$iv$iv3;
                        List<Subscription> subscriptions = this.getSubscriptions();
                        Iterable $this$filter$iv = this.getSubscriptions();
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Iterable destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                            Subscription it = (Subscription)element$iv$iv;
                            boolean bl4 = false;
                            if (!(it.getPlan() == SubscriptionPlan.Enterprise)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        enterprises = (List)destination$iv$iv;
                        Iterable $this$filter$iv2 = subscriptions;
                        boolean $i$f$filter2 = false;
                        destination$iv$iv = $this$filter$iv2;
                        Iterable destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo2 = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                            Subscription it = (Subscription)element$iv$iv;
                            boolean bl5 = false;
                            if (!(it.getPlan() == SubscriptionPlan.Team)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        teams = (List)destination$iv$iv2;
                        Iterable $this$filter$iv3 = subscriptions;
                        boolean $i$f$filter3 = false;
                        destination$iv$iv2 = $this$filter$iv3;
                        Collection destination$iv$iv3 = new ArrayList();
                        boolean $i$f$filterTo3 = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Subscription it = (Subscription)element$iv$iv;
                            boolean bl6 = false;
                            if (!(it.getPlan() == SubscriptionPlan.Pro)) continue;
                            destination$iv$iv3.add(element$iv$iv);
                        }
                        pros = (List)destination$iv$iv3;
                        now = System.currentTimeMillis();
                        $this$any$iv = enterprises;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv) {
                                Subscription it = (Subscription)element$iv2;
                                boolean bl7 = false;
                                if (!(it.getEndAt() > now)) continue;
                                bl3 = true;
                                break block19;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        block20: {
                            $this$first$iv = enterprises;
                            $i$f$first = false;
                            for (Object element$iv2 : $this$first$iv) {
                                Subscription it = (Subscription)element$iv2;
                                boolean bl8 = false;
                                if (!(it.getEndAt() > now)) continue;
                                break block20;
                            }
                            throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        return (Subscription)element$iv2;
                    }
                    $this$any$iv = teams;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            Subscription it = (Subscription)element$iv2;
                            boolean bl9 = false;
                            if (!(it.getEndAt() > now)) continue;
                            bl2 = true;
                            break block21;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) {
                    block22: {
                        $this$first$iv = teams;
                        $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            Subscription it = (Subscription)element$iv2;
                            boolean bl10 = false;
                            if (!(it.getEndAt() > now)) continue;
                            break block22;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    return (Subscription)element$iv2;
                }
                $this$any$iv = pros;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv2 : $this$any$iv) {
                        Subscription it = (Subscription)element$iv2;
                        boolean bl11 = false;
                        if (!(it.getEndAt() > now)) continue;
                        bl = true;
                        break block23;
                    }
                    bl = false;
                }
            }
            if (bl) {
                block24: {
                    $this$first$iv = pros;
                    $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        Subscription it = (Subscription)element$iv2;
                        boolean bl12 = false;
                        if (!(it.getEndAt() > now)) continue;
                        break block24;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                return (Subscription)element$iv2;
            }
        }
        return new Subscription("0", SubscriptionPlan.Free, 0L, 0L);
    }

    public final boolean hasTeamFeature() {
        if (!this.getAccountProperties().getSigned()) {
            return false;
        }
        SubscriptionPlan plan = this.getSubscription().getPlan();
        return SubscriptionPlan.Team == plan || SubscriptionPlan.Enterprise == plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void refreshToken$termora() {
        String refreshToken;
        void this_$iv;
        Object it;
        void this_$iv2;
        Json json = Application.INSTANCE.getOhMyJson();
        Map value$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"refreshToken", (Object)this.getRefreshToken()));
        boolean $i$f$encodeToString = false;
        this_$iv2.getSerializersModule();
        RequestBody body = RequestBody.Companion.create(this_$iv2.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)StringSerializer.INSTANCE), (Object)value$iv), MediaType.Companion.get("application/json"));
        Request request = new Request.Builder().url(this.getServer() + "/v1/token").header("Authorization", "Bearer " + this.getRefreshToken()).post(body).build();
        Response response = Application.INSTANCE.getHttpClient().newCall(request).execute();
        if (response.code() == 401) {
            IOUtils.closeQuietly((Closeable)((Closeable)response));
            this.logout$termora();
            throw new ResponseException(response.code(), response);
        }
        if (!response.isSuccessful()) {
            IOUtils.closeQuietly((Closeable)((Closeable)response));
            throw new ResponseException(response.code(), response);
        }
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            String string;
            it = (Response)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)response.body();
            Throwable throwable2 = null;
            try {
                ResponseBody it2 = (ResponseBody)closeable2;
                boolean bl2 = false;
                ResponseBody responseBody = it2;
                string = responseBody != null ? responseBody.string() : null;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            it = string;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object text = it;
        if (text == null) {
            throw new ResponseException(response.code(), "response body is empty", response);
        }
        throwable = Application.INSTANCE.getOhMyJson();
        Object string$iv = text;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        JsonObject json2 = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), (String)string$iv);
        JsonElement jsonElement = (JsonElement)json2.get((Object)"accessToken");
        String accessToken = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null;
        JsonElement jsonElement2 = (JsonElement)json2.get((Object)"refreshToken");
        String string = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? jsonElement2.getContent() : (refreshToken = null);
        if (accessToken == null || refreshToken == null) {
            throw new ResponseException(response.code(), "token is empty", response);
        }
        this.login$termora(Account.copy$default(this.account, null, null, null, null, null, accessToken, refreshToken, null, null, null, 927, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void login$termora(@NotNull Account account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        AccountManager accountManager = this;
        synchronized (accountManager) {
            Json this_$iv;
            boolean bl = false;
            Account oldAccount = this.account;
            this.account = account;
            AccountProperties accountProperties = AccountProperties.Companion.getInstance();
            accountProperties.setId(account.getId());
            accountProperties.setServer(account.getServer());
            accountProperties.setEmail(account.getEmail());
            Json json = Application.INSTANCE.getOhMyJson();
            Object value$iv = account.getTeams();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            accountProperties.setTeams(this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(Team.Companion.serializer()), value$iv));
            this_$iv = Application.INSTANCE.getOhMyJson();
            value$iv = account.getSubscriptions();
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            accountProperties.setSubscriptions(this_$iv.encodeToString((SerializationStrategy)new ArrayListSerializer(Subscription.Companion.serializer()), value$iv));
            accountProperties.setAccessToken(account.getAccessToken());
            accountProperties.setRefreshToken(account.getRefreshToken());
            this_$iv = Application.INSTANCE.getOhMyJson();
            value$iv = account.getSecretKey();
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            accountProperties.setSecretKey(this_$iv.encodeToString((SerializationStrategy)ByteArraySerializer.INSTANCE, value$iv));
            if (!Intrinsics.areEqual((Object)oldAccount.getId(), (Object)account.getId())) {
                accountProperties.setNextSynchronizationSince(0L);
            }
            if (!this.isLocally()) {
                String string = Base64.encodeBase64String((byte[])account.getPublicKey().getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64String(...)");
                accountProperties.setPublicKey(string);
                String string2 = Base64.encodeBase64String((byte[])account.getPrivateKey().getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeBase64String(...)");
                accountProperties.setPrivateKey(string2);
            } else {
                accountProperties.setPublicKey("");
                accountProperties.setPrivateKey("");
            }
            this.notifyAccountChanged(oldAccount, account);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void notifyAccountChanged(Account oldAccount, Account newAccount) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (AccountExtension extension : ExtensionManager.Companion.getInstance().getExtensions(AccountExtension.class)) {
                extension.onAccountChanged(oldAccount, newAccount);
            }
        } else {
            SwingUtilities.invokeLater(() -> AccountManager.notifyAccountChanged$lambda$0(this, oldAccount, newAccount));
        }
    }

    public final void logout$termora() {
        if (!this.isLocally()) {
            this.login$termora(this.locally());
        }
    }

    private final Account locally() {
        List list = CollectionsKt.emptyList();
        List list2 = CollectionsKt.emptyList();
        byte[] byArray = new byte[]{};
        PublicKey publicKey = new PublicKey(){

            public String getAlgorithm() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public String getFormat() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public byte[] getEncoded() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        };
        PrivateKey privateKey = new PrivateKey(){

            public String getAlgorithm() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public String getFormat() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }

            public byte[] getEncoded() {
                String string = "Not yet implemented";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
        };
        return new Account("0", "locally", "locally", list, list2, "", "", byArray, publicKey, privateKey);
    }

    @Override
    public void ready() {
        if (!this.isLocally()) {
            BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ AccountManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.this$0.refresh();
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    public final void refresh() {
        block4: {
            Throwable throwable;
            Object $this$refresh_u24lambda_u240;
            Object object = this;
            try {
                $this$refresh_u24lambda_u240 = object;
                boolean bl = false;
                ((AccountManager)$this$refresh_u24lambda_u240).refreshToken$termora();
                $this$refresh_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$refresh_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$refresh_u24lambda_u240;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                this.refreshAccount();
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block4;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            if (log.isErrorEnabled()) {
                log.error(it.getMessage(), it);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshAccount() {
        block3: {
            try {
                void $this$mapTo$iv$iv;
                ServerManager.MeResponse me = this.getServerManager().callMe(this.account.getServer(), this.getAccessToken());
                Iterable $this$map$iv = me.getTeams();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ServerManager.MeTeam meTeam = (ServerManager.MeTeam)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getId();
                    String string2 = it.getName();
                    PrivateKey privateKey = this.getPrivateKey();
                    byte[] byArray = Base64.decodeBase64((String)it.getSecretKey());
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBase64(...)");
                    collection.add(new Team(string, string2, RSA.INSTANCE.decrypt(privateKey, byArray), it.getRole()));
                }
                List teams = (List)destination$iv$iv;
                this.login$termora(Account.copy$default(this.account, null, null, null, teams, me.getSubscriptions(), null, null, null, null, null, 999, null));
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static final void notifyAccountChanged$lambda$0(AccountManager this$0, Account $oldAccount, Account $newAccount) {
        this$0.notifyAccountChanged($oldAccount, $newAccount);
    }

    public /* synthetic */ AccountManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lapp/termora/account/AccountManager$AccountApplicationRunnerExtension;", "Lapp/termora/ApplicationRunnerExtension;", "<init>", "()V", "ready", "", "ordered", "", "Companion", "termora"})
    @SourceDebugExtension(value={"SMAP\nAccountManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountManager.kt\napp/termora/account/AccountManager$AccountApplicationRunnerExtension\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,306:1\n222#2:307\n222#2:308\n222#2:309\n*S KotlinDebug\n*F\n+ 1 AccountManager.kt\napp/termora/account/AccountManager$AccountApplicationRunnerExtension\n*L\n291#1:307\n292#1:308\n293#1:309\n*E\n"})
    public static final class AccountApplicationRunnerExtension
    implements ApplicationRunnerExtension {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Lazy<AccountApplicationRunnerExtension> instance$delegate = LazyKt.lazy(AccountApplicationRunnerExtension::instance_delegate$lambda$0);

        private AccountApplicationRunnerExtension() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void ready() {
            void this_$iv;
            void this_$iv2;
            void this_$iv3;
            AccountManager accountManager = Companion.getInstance();
            AccountProperties accountProperties = AccountProperties.Companion.getInstance();
            String id = accountProperties.getId();
            if (StringsKt.isBlank((CharSequence)id) || Intrinsics.areEqual((Object)id, (Object)accountManager.getAccountId())) {
                return;
            }
            String string = accountProperties.getId();
            String string2 = accountProperties.getServer();
            String string3 = accountProperties.getEmail();
            String string4 = accountProperties.getAccessToken();
            String string5 = accountProperties.getRefreshToken();
            Object object = Application.INSTANCE.getOhMyJson();
            String string$iv = accountProperties.getTeams();
            boolean $i$f$decodeFromString = false;
            this_$iv3.getSerializersModule();
            List list = (List)this_$iv3.decodeFromString((DeserializationStrategy)new ArrayListSerializer(Team.Companion.serializer()), string$iv);
            string$iv = Application.INSTANCE.getOhMyJson();
            String string$iv2 = accountProperties.getSubscriptions();
            boolean $i$f$decodeFromString2 = false;
            this_$iv2.getSerializersModule();
            object = (List)this_$iv2.decodeFromString((DeserializationStrategy)new ArrayListSerializer(Subscription.Companion.serializer()), string$iv2);
            string$iv2 = Application.INSTANCE.getOhMyJson();
            String string$iv3 = accountProperties.getSecretKey();
            boolean $i$f$decodeFromString3 = false;
            this_$iv.getSerializersModule();
            byte[] byArray = (byte[])this_$iv.decodeFromString((DeserializationStrategy)ByteArraySerializer.INSTANCE, string$iv3);
            byte[] byArray2 = Base64.decodeBase64((String)accountProperties.getPublicKey());
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decodeBase64(...)");
            PublicKey publicKey = RSA.INSTANCE.generatePublic(byArray2);
            byte[] byArray3 = Base64.decodeBase64((String)accountProperties.getPrivateKey());
            Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"decodeBase64(...)");
            PrivateKey privateKey = RSA.INSTANCE.generatePrivate(byArray3);
            accountManager.account = new Account(string, string2, string3, list, (List<Subscription>)object, string4, string5, byArray, publicKey, privateKey);
        }

        @Override
        public long ordered() {
            return 0L;
        }

        private static final AccountApplicationRunnerExtension instance_delegate$lambda$0() {
            return new AccountApplicationRunnerExtension();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lapp/termora/account/AccountManager$AccountApplicationRunnerExtension$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/account/AccountManager$AccountApplicationRunnerExtension;", "getInstance", "()Lapp/termora/account/AccountManager$AccountApplicationRunnerExtension;", "instance$delegate", "Lkotlin/Lazy;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final AccountApplicationRunnerExtension getInstance() {
                Lazy lazy = instance$delegate;
                return (AccountApplicationRunnerExtension)lazy.getValue();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lapp/termora/account/AccountManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/account/AccountManager;", "isLocally", "", "id", "", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AccountManager getInstance() {
            return (AccountManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(AccountManager.class), Companion::getInstance$lambda$0);
        }

        public final boolean isLocally(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return StringUtils.isBlank((CharSequence)id) || Intrinsics.areEqual((Object)id, (Object)"0");
        }

        private static final AccountManager getInstance$lambda$0() {
            return new AccountManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

