/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.AntPathMatcher;
import app.termora.Application;
import app.termora.Ed25519;
import app.termora.ResponseException;
import app.termora.account.AccountManager;
import app.termora.account.AccountProperties;
import app.termora.account.ServerSignedExtension;
import app.termora.plugin.ExtensionManager;
import java.io.Closeable;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lapp/termora/account/AccountHttp;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "execute", "", "request", "Lokhttp3/Request;", "SignatureInterceptor", "UserAgentInterceptor", "AccessTokenInterceptor", "termora"})
@SourceDebugExtension(value={"SMAP\nAccountHttp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountHttp.kt\napp/termora/account/AccountHttp\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,218:1\n1#2:219\n*E\n"})
public final class AccountHttp {
    @NotNull
    public static final AccountHttp INSTANCE = new AccountHttp();
    private static final Logger log = LoggerFactory.getLogger(AccountHttp.class);
    @NotNull
    private static final OkHttpClient client = Application.INSTANCE.getHttpClient().newBuilder().addInterceptor((Interceptor)new UserAgentInterceptor()).addInterceptor((Interceptor)new SignatureInterceptor()).addInterceptor((Interceptor)new AccessTokenInterceptor()).build();

    private AccountHttp() {
    }

    @NotNull
    public final OkHttpClient getClient() {
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String execute(@NotNull OkHttpClient client, @NotNull Request request) {
        String string;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Response response = client.newCall(request).execute();
        if (!response.isSuccessful()) {
            IOUtils.closeQuietly((Closeable)((Closeable)response));
            throw new ResponseException(response.code(), response);
        }
        Object object = (Closeable)response;
        Throwable throwable = null;
        try {
            String string2;
            Response it = (Response)object;
            boolean bl = false;
            Closeable closeable = (Closeable)response.body();
            Throwable throwable2 = null;
            try {
                ResponseBody it2 = (ResponseBody)closeable;
                boolean bl2 = false;
                ResponseBody responseBody = it2;
                string2 = responseBody != null ? responseBody.string() : null;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            string = string2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        String text = string;
        object = text;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            throw new ResponseException(response.code(), "response body is empty", response);
        }
        if (log.isDebugEnabled()) {
            log.debug("url: " + request.url() + " response: " + text);
        }
        return text;
    }

    public static /* synthetic */ String execute$default(AccountHttp accountHttp, OkHttpClient okHttpClient, Request request, int n, Object object) {
        if ((n & 1) != 0) {
            okHttpClient = client;
        }
        return accountHttp.execute(okHttpClient, request);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lapp/termora/account/AccountHttp$AccessTokenInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "condition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "isRefreshing", "Ljava/util/concurrent/atomic/AtomicBoolean;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "termora"})
    @SourceDebugExtension(value={"SMAP\nAccountHttp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountHttp.kt\napp/termora/account/AccountHttp$AccessTokenInterceptor\n+ 2 -JvmPlatform.kt\nokio/_JvmPlatformKt\n*L\n1#1,218:1\n40#2:219\n*S KotlinDebug\n*F\n+ 1 AccountHttp.kt\napp/termora/account/AccountHttp$AccessTokenInterceptor\n*L\n190#1:219\n*E\n"})
    private static final class AccessTokenInterceptor
    implements Interceptor {
        @NotNull
        private final ReentrantLock lock = new ReentrantLock();
        private final Condition condition = this.lock.newCondition();
        @NotNull
        private final AtomicBoolean isRefreshing = new AtomicBoolean(false);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Response response;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request.Builder builder2 = chain.request().newBuilder();
            AccountManager accountManager = AccountManager.Companion.getInstance();
            String accessToken = accountManager.getAccessToken();
            if (chain.request().header("Authorization") == null && !StringsKt.isBlank((CharSequence)accessToken)) {
                builder2.header("Authorization", "Bearer " + accessToken);
            }
            if ((response = chain.proceed(builder2.build())).code() == 401 && !accountManager.isLocally()) {
                IOUtils.closeQuietly((Closeable)((Closeable)response));
                if (this.isRefreshing.compareAndSet(false, true)) {
                    try {
                        accountManager.refresh();
                    }
                    finally {
                        ReentrantLock $this$withLock$iv = this.lock;
                        boolean $i$f$withLock = false;
                        Lock lock = $this$withLock$iv;
                        lock.lock();
                        try {
                            boolean bl = false;
                            this.isRefreshing.set(false);
                            this.condition.signalAll();
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                }
                this.lock.lock();
                try {
                    this.condition.await();
                }
                finally {
                    this.lock.unlock();
                }
                String newAccessToken = accountManager.getAccessToken();
                Request newRequest = builder2.removeHeader("Authorization").header("Authorization", "Bearer " + newAccessToken).build();
                return chain.proceed(newRequest);
            }
            return response;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lapp/termora/account/AccountHttp$SignatureInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "accountProperties", "Lapp/termora/account/AccountProperties;", "getAccountProperties", "()Lapp/termora/account/AccountProperties;", "matcher", "Lapp/termora/AntPathMatcher;", "publicKey", "Ljava/security/PublicKey;", "getPublicKey", "()Ljava/security/PublicKey;", "publicKey$delegate", "Lkotlin/Lazy;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "isInRange", "", "request", "Lokhttp3/Request;", "json", "Lkotlinx/serialization/json/JsonObject;", "termora"})
    @SourceDebugExtension(value={"SMAP\nAccountHttp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountHttp.kt\napp/termora/account/AccountHttp$SignatureInterceptor\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,218:1\n222#2:219\n1#3:220\n335#4:221\n*S KotlinDebug\n*F\n+ 1 AccountHttp.kt\napp/termora/account/AccountHttp$SignatureInterceptor\n*L\n74#1:219\n123#1:221\n*E\n"})
    private static final class SignatureInterceptor
    implements Interceptor {
        @NotNull
        private final AntPathMatcher matcher = new AntPathMatcher(".");
        @NotNull
        private final Lazy publicKey$delegate = LazyKt.lazy(SignatureInterceptor::publicKey_delegate$lambda$0);

        private final AccountProperties getAccountProperties() {
            return AccountProperties.Companion.getInstance();
        }

        private final PublicKey getPublicKey() {
            Lazy lazy = this.publicKey$delegate;
            return (PublicKey)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Response response = chain.proceed(chain.request());
            String signatureBase64 = (String)CollectionsKt.firstOrNull((List)response.headers("X-Signature"));
            String dataBase64 = (String)CollectionsKt.firstOrNull((List)response.headers("X-Signature-Data"));
            Ref.ObjectRef signed = new Ref.ObjectRef();
            CharSequence charSequence = signatureBase64;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || (charSequence = (CharSequence)dataBase64) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                signed.element = false;
            } else {
                String subscriptionExpiry;
                void string$iv;
                void this_$iv;
                byte[] signature = Base64.decodeBase64((String)signatureBase64);
                byte[] data = Base64.decodeBase64((String)dataBase64);
                Json json = Application.INSTANCE.getOhMyJson();
                Intrinsics.checkNotNull((Object)data);
                String string = new String(data, Charsets.UTF_8);
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                JsonObject json2 = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), (String)string$iv);
                JsonElement jsonElement = (JsonElement)json2.get((Object)"SubscriptionExpiry");
                String string2 = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : (subscriptionExpiry = null);
                if (subscriptionExpiry == null) {
                    signed.element = false;
                } else {
                    Object object;
                    Object object2 = this;
                    try {
                        SignatureInterceptor $this$intercept_u24lambda_u240 = object2;
                        boolean bl = false;
                        String[] stringArray = new String[]{"yyyy-MM-dd"};
                        object = Result.constructor-impl((Object)DateUtils.parseDate((String)subscriptionExpiry, (String[])stringArray));
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                    }
                    object2 = object;
                    Date date = (Date)(Result.isFailure-impl((Object)object2) ? null : object2);
                    if (date == null) {
                        signed.element = false;
                    } else if (Application.INSTANCE.getReleaseDate().after(date) || date.getTime() < System.currentTimeMillis()) {
                        signed.element = false;
                    }
                }
                if (signed.element == null && !this.isInRange(chain.request(), json2)) {
                    signed.element = false;
                }
                if (signed.element == null) {
                    PublicKey publicKey = this.getPublicKey();
                    Intrinsics.checkNotNull((Object)signature);
                    signed.element = Ed25519.INSTANCE.verify(publicKey, data, signature);
                }
            }
            boolean oldSigned = this.getAccountProperties().getSigned();
            if (!Intrinsics.areEqual((Object)oldSigned, (Object)signed.element)) {
                this.getAccountProperties().setSigned((Boolean)signed.element);
                SwingUtilities.invokeLater(() -> SignatureInterceptor.intercept$lambda$1(oldSigned, signed));
            }
            return response;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isInRange(Request request, JsonObject json) {
            void $this$decodeFromJsonElement$iv;
            JsonElement jsonElement = (JsonElement)json.get((Object)"Hosts");
            Object hostsArray = jsonElement != null ? JsonElementKt.getJsonArray((JsonElement)jsonElement) : null;
            Collection collection = (Collection)hostsArray;
            if (collection == null || collection.isEmpty()) {
                return false;
            }
            String host = request.url().host();
            Json json2 = Application.INSTANCE.getOhMyJson();
            JsonElement json$iv = (JsonElement)hostsArray;
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            List hosts = CollectionsKt.toMutableList((Collection)((Collection)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE), json$iv)));
            hosts.addFirst("127.0.0.1");
            hosts.addFirst("localhost");
            for (String cidr : hosts) {
                try {
                    if (Intrinsics.areEqual((Object)cidr, (Object)host)) {
                        return true;
                    }
                    if (this.matcher.match(cidr, host)) {
                        return true;
                    }
                    SubnetUtils subnet = new SubnetUtils(cidr);
                    if (!subnet.getInfo().isInRange(host)) continue;
                    return true;
                }
                catch (Exception e) {
                    if (Intrinsics.areEqual((Object)cidr, (Object)"localhost") || Intrinsics.areEqual((Object)cidr, (Object)"127.0.0.1") || !log.isDebugEnabled()) continue;
                    log.debug(e.getMessage(), (Throwable)e);
                }
            }
            return false;
        }

        private static final PublicKey publicKey_delegate$lambda$0() {
            byte[] byArray = Base64.decodeBase64((String)"MCowBQYDK2VwAyEADhvgc8vWLXBFB36QtMlCujqdBNDMb2T5qE2V03hJKWA=");
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decodeBase64(...)");
            return Ed25519.INSTANCE.generatePublic(byArray);
        }

        private static final void intercept$lambda$1(boolean $oldSigned, Ref.ObjectRef $signed) {
            for (ServerSignedExtension extension : ExtensionManager.Companion.getInstance().getExtensions(ServerSignedExtension.class)) {
                extension.onSignedChanged($oldSigned, (Boolean)$signed.element);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lapp/termora/account/AccountHttp$UserAgentInterceptor;", "Lokhttp3/Interceptor;", "<init>", "()V", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "termora"})
    private static final class UserAgentInterceptor
    implements Interceptor {
        @NotNull
        public Response intercept(@NotNull Interceptor.Chain chain) {
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Request.Builder builder2 = chain.request().newBuilder();
            if (chain.request().header("User-Agent") == null) {
                builder2.header("User-Agent", Application.INSTANCE.getUserAgent());
            }
            return chain.proceed(builder2.build());
        }
    }
}

