/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.FrameExtension;
import app.termora.I18n;
import app.termora.NativeMacLibrary;
import app.termora.NotifyListener;
import app.termora.OptionPane;
import app.termora.TermoraFrame;
import app.termora.TermoraRestarter;
import app.termora.WindowScope;
import app.termora.database.DatabaseManager;
import app.termora.plugin.ExtensionManager;
import com.formdev.flatlaf.ui.FlatNativeWindowsLibrary;
import com.formdev.flatlaf.util.SystemInfo;
import com.sun.jna.Pointer;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import de.jangassen.jfa.ThreadUtils;
import de.jangassen.jfa.foundation.Foundation;
import de.jangassen.jfa.foundation.ID;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0006J\u0011\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u0006\u0010\u001c\u001a\u00020\u001aJ\b\u0010\u001d\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0002J\u000e\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020%2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lapp/termora/TermoraFrameManager;", "Lapp/termora/Disposable;", "<init>", "()V", "frames", "", "Lapp/termora/TermoraFrame;", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "getProperties", "()Lapp/termora/database/DatabaseManager$Properties;", "isDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isBackgroundRunning", "", "()Z", "frameExtensions", "", "Lapp/termora/FrameExtension;", "getFrameExtensions", "()Ljava/util/List;", "createWindow", "getWindows", "", "()[Lapp/termora/TermoraFrame;", "registerCloseCallback", "", "window", "tick", "dispose", "saveFrameRectangle", "frame", "getFrameRectangle", "Lapp/termora/TermoraFrameManager$FrameRectangle;", "setOpacity", "opacity", "", "Ljava/awt/Window;", "Companion", "FrameRectangle", "termora"})
@SourceDebugExtension(value={"SMAP\nTermoraFrameManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TermoraFrameManager.kt\napp/termora/TermoraFrameManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,241:1\n1#2:242\n37#3,2:243\n*S KotlinDebug\n*F\n+ 1 TermoraFrameManager.kt\napp/termora/TermoraFrameManager\n*L\n87#1:243,2\n*E\n"})
public final class TermoraFrameManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TermoraFrame> frames = new ArrayList();
    @NotNull
    private final AtomicBoolean isDisposed = new AtomicBoolean(false);
    private static final Logger log = LoggerFactory.getLogger(TermoraFrameManager.class);

    private final DatabaseManager.Properties getProperties() {
        return DatabaseManager.Companion.getInstance().getProperties();
    }

    private final boolean isBackgroundRunning() {
        return DatabaseManager.Companion.getInstance().getAppearance().getBackgroundRunning();
    }

    private final List<FrameExtension> getFrameExtensions() {
        return ExtensionManager.Companion.getInstance().getExtensions(FrameExtension.class);
    }

    @NotNull
    public final TermoraFrame createWindow() {
        FrameRectangle rectangle;
        TermoraFrame termoraFrame;
        TermoraFrame $this$createWindow_u24lambda_u240 = termoraFrame = new TermoraFrame();
        boolean bl = false;
        this.registerCloseCallback($this$createWindow_u24lambda_u240);
        TermoraFrame frame = termoraFrame;
        frame.setTitle(Application.INSTANCE.getName());
        frame.setDefaultCloseOperation(0);
        FrameRectangle frameRectangle = this.getFrameRectangle();
        if (frameRectangle == null) {
            frameRectangle = new FrameRectangle(-1, -1, 1280, 800, 0);
        }
        if ((rectangle = frameRectangle).isMaximized()) {
            frame.setSize(1280, 800);
            frame.setLocationRelativeTo(null);
            frame.setExtendedState(rectangle.getS());
        } else {
            frame.setSize(Math.max(rectangle.getW(), UIManager.getInt("Dialog.width") - 150), Math.max(rectangle.getH(), UIManager.getInt("Dialog.height") - 100));
            if (rectangle.getX() == -1 && rectangle.getY() == -1) {
                frame.setLocationRelativeTo(null);
            } else {
                frame.setLocation(Math.max(rectangle.getX(), 0), Math.max(rectangle.getY(), 0));
            }
        }
        frame.addNotifyListener(new NotifyListener(this, frame){
            final /* synthetic */ TermoraFrameManager this$0;
            final /* synthetic */ TermoraFrame $frame;
            {
                this.this$0 = $receiver;
                this.$frame = $frame;
            }

            private final double getOpacity() {
                return DatabaseManager.Companion.getInstance().getAppearance().getOpacity();
            }

            public void addNotify() {
                double opacity = this.getOpacity();
                if (opacity >= 1.0) {
                    return;
                }
                TermoraFrameManager.access$setOpacity(this.this$0, this.$frame, opacity);
            }
        });
        Object object = this.getFrameExtensions().iterator();
        while (object.hasNext()) {
            FrameExtension extension = object.next();
            extension.customize(frame);
        }
        Object $this$createWindow_u24lambda_u241 = object = frame;
        boolean bl2 = false;
        this.frames.add((TermoraFrame)$this$createWindow_u24lambda_u241);
        return object;
    }

    @NotNull
    public final TermoraFrame[] getWindows() {
        Collection $this$toTypedArray$iv = this.frames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new TermoraFrame[0]);
    }

    private final void registerCloseCallback(TermoraFrame window) {
        TermoraFrameManager manager = this;
        window.addWindowListener(new WindowAdapter(window, this, manager){
            final /* synthetic */ TermoraFrame $window;
            final /* synthetic */ TermoraFrameManager this$0;
            final /* synthetic */ TermoraFrameManager $manager;
            {
                this.$window = $window;
                this.this$0 = $receiver;
                this.$manager = $manager;
            }

            public void windowClosed(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TermoraRestarter.Companion.getInstance().disposeChildren(this.$window);
                TermoraFrameManager.access$saveFrameRectangle(this.this$0, this.$window);
                TermoraFrameManager.access$getFrames$p(this.this$0).remove(this.$window);
                Window window = e.getWindow();
                Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
                WindowScope windowScope = ApplicationScope.Companion.forWindowScope(window);
                Disposer.disposeChildren(windowScope, null);
                Disposer.dispose(windowScope);
                List<WindowScope> windowScopes = ApplicationScope.Companion.windowScopes();
                if (!((Collection)windowScopes).isEmpty()) {
                    return;
                }
                if (SystemInfo.isWindows || SystemInfo.isLinux) {
                    Disposer.dispose(this.$manager);
                } else if (SystemInfo.isMacOS) {
                    if (TermoraFrameManager.access$isBackgroundRunning(this.this$0)) {
                        return;
                    }
                    Disposer.dispose(this.$manager);
                }
            }

            public void windowClosing(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (ApplicationScope.Companion.windowScopes().size() != 1) {
                    this.$window.dispose();
                    return;
                }
                if (SystemInfo.isWindows && TermoraFrameManager.access$isBackgroundRunning(this.this$0)) {
                    this.$window.setExtendedState(this.$window.getExtendedState() | 1);
                    this.$window.setVisible(false);
                    return;
                }
                if (SystemInfo.isMacOS && TermoraFrameManager.access$isBackgroundRunning(this.this$0)) {
                    this.$window.dispose();
                    return;
                }
                Object[] objectArray = new Object[]{Application.INSTANCE.getName()};
                int option = OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, this.$window, I18n.INSTANCE.getString("termora.quit-confirm", objectArray), null, 0, 0, null, null, null, null, 500, null);
                if (option == 0) {
                    this.$window.dispose();
                }
            }
        });
    }

    public final void tick() {
        if (SwingUtilities.isEventDispatchThread()) {
            Object[] windows = this.getWindows();
            if (windows.length == 0) {
                return;
            }
            int n = windows.length;
            for (int i = 0; i < n; ++i) {
                Object window = windows[i];
                if ((((Frame)window).getExtendedState() & 1) == 1) {
                    ((Frame)window).setExtendedState(((Frame)window).getExtendedState() & 0xFFFFFFFE);
                }
                ((Window)window).setVisible(true);
            }
            ((TermoraFrame)ArraysKt.last((Object[])windows)).toFront();
        } else {
            SwingUtilities.invokeLater(() -> TermoraFrameManager.tick$lambda$0(this));
        }
    }

    @Override
    public void dispose() {
        block3: {
            if (this.isDisposed.compareAndSet(false, true)) {
                Disposer.dispose(ApplicationScope.Companion.forApplicationScope());
                try {
                    Disposer.getTree().assertIsEmpty(true);
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private final void saveFrameRectangle(TermoraFrame frame) {
        this.getProperties().putString("TermoraFrame.x", String.valueOf(frame.getX()));
        this.getProperties().putString("TermoraFrame.y", String.valueOf(frame.getY()));
        this.getProperties().putString("TermoraFrame.width", String.valueOf(frame.getWidth()));
        this.getProperties().putString("TermoraFrame.height", String.valueOf(frame.getHeight()));
        this.getProperties().putString("TermoraFrame.extendedState", String.valueOf(frame.getExtendedState()));
    }

    private final FrameRectangle getFrameRectangle() {
        Object object = this.getProperties().getString("TermoraFrame.x");
        if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            return null;
        }
        int x = (Integer)object;
        Object object2 = this.getProperties().getString("TermoraFrame.y");
        if (object2 == null || (object2 = StringsKt.toIntOrNull((String)object2)) == null) {
            return null;
        }
        int y = (Integer)object2;
        Object object3 = this.getProperties().getString("TermoraFrame.width");
        if (object3 == null || (object3 = StringsKt.toIntOrNull((String)object3)) == null) {
            return null;
        }
        int w = (Integer)object3;
        Object object4 = this.getProperties().getString("TermoraFrame.height");
        if (object4 == null || (object4 = StringsKt.toIntOrNull((String)object4)) == null) {
            return null;
        }
        int h = (Integer)object4;
        Object object5 = this.getProperties().getString("TermoraFrame.extendedState");
        if (object5 == null || (object5 = StringsKt.toIntOrNull((String)object5)) == null) {
            return null;
        }
        int s = (Integer)object5;
        return new FrameRectangle(x, y, w, h, s);
    }

    public final void setOpacity(double opacity) {
        if (opacity < 0.0 || opacity > 1.0) {
            return;
        }
        for (TermoraFrame window : this.getWindows()) {
            this.setOpacity(window, opacity);
        }
    }

    private final void setOpacity(Window window, double opacity) {
        if (SystemInfo.isMacOS) {
            Long l = NativeMacLibrary.INSTANCE.getNSWindow(window);
            if (l == null) {
                return;
            }
            ID nsWindow = new ID(l.longValue());
            ThreadUtils.dispatch_async(() -> TermoraFrameManager.setOpacity$lambda$0(nsWindow, opacity));
        } else if (SystemInfo.isWindows) {
            byte alpha = (byte)((int)(opacity * (double)255) & 0xFF);
            WinDef.HWND hwnd = new WinDef.HWND(Pointer.createConstant((long)FlatNativeWindowsLibrary.getHWND((Window)window)));
            int exStyle = User32.INSTANCE.GetWindowLong(hwnd, -20);
            if ((exStyle & 0x80000) == 0) {
                User32.INSTANCE.SetWindowLong(hwnd, -20, exStyle | 0x80000);
            }
            User32.INSTANCE.SetLayeredWindowAttributes(hwnd, 0, alpha, 2);
        } else if (SystemInfo.isLinux && WindowUtils.isWindowAlphaSupported()) {
            WindowUtils.setWindowAlpha((Window)window, (float)((float)opacity));
        }
    }

    private static final void tick$lambda$0(TermoraFrameManager this$0) {
        this$0.tick();
    }

    private static final void setOpacity$lambda$0(ID $nsWindow, double $opacity) {
        Object[] objectArray = new Object[]{false};
        Foundation.invoke((ID)$nsWindow, (String)"setOpaque:", (Object[])objectArray);
        objectArray = new Object[]{$opacity};
        Foundation.invoke((ID)$nsWindow, (String)"setAlphaValue:", (Object[])objectArray);
    }

    public static final /* synthetic */ void access$setOpacity(TermoraFrameManager $this, Window window, double opacity) {
        $this.setOpacity(window, opacity);
    }

    public static final /* synthetic */ void access$saveFrameRectangle(TermoraFrameManager $this, TermoraFrame frame) {
        $this.saveFrameRectangle(frame);
    }

    public static final /* synthetic */ List access$getFrames$p(TermoraFrameManager $this) {
        return $this.frames;
    }

    public static final /* synthetic */ boolean access$isBackgroundRunning(TermoraFrameManager $this) {
        return $this.isBackgroundRunning();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/TermoraFrameManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/TermoraFrameManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TermoraFrameManager getInstance() {
            return (TermoraFrameManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(TermoraFrameManager.class), Companion::getInstance$lambda$0);
        }

        private static final TermoraFrameManager getInstance$lambda$0() {
            return new TermoraFrameManager();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00112\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lapp/termora/TermoraFrameManager$FrameRectangle;", "", "x", "", "y", "w", "h", "s", "<init>", "(IIIII)V", "getX", "()I", "getY", "getW", "getH", "getS", "isMaximized", "", "()Z", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "", "termora"})
    private static final class FrameRectangle {
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final int s;

        public FrameRectangle(int x, int y, int w, int h, int s) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.s = s;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getW() {
            return this.w;
        }

        public final int getH() {
            return this.h;
        }

        public final int getS() {
            return this.s;
        }

        public final boolean isMaximized() {
            return (this.s & 6) == 6;
        }

        public final int component1() {
            return this.x;
        }

        public final int component2() {
            return this.y;
        }

        public final int component3() {
            return this.w;
        }

        public final int component4() {
            return this.h;
        }

        public final int component5() {
            return this.s;
        }

        @NotNull
        public final FrameRectangle copy(int x, int y, int w, int h, int s) {
            return new FrameRectangle(x, y, w, h, s);
        }

        public static /* synthetic */ FrameRectangle copy$default(FrameRectangle frameRectangle, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = frameRectangle.x;
            }
            if ((n6 & 2) != 0) {
                n2 = frameRectangle.y;
            }
            if ((n6 & 4) != 0) {
                n3 = frameRectangle.w;
            }
            if ((n6 & 8) != 0) {
                n4 = frameRectangle.h;
            }
            if ((n6 & 0x10) != 0) {
                n5 = frameRectangle.s;
            }
            return frameRectangle.copy(n, n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "FrameRectangle(x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ", s=" + this.s + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.x);
            result2 = result2 * 31 + Integer.hashCode(this.y);
            result2 = result2 * 31 + Integer.hashCode(this.w);
            result2 = result2 * 31 + Integer.hashCode(this.h);
            result2 = result2 * 31 + Integer.hashCode(this.s);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FrameRectangle)) {
                return false;
            }
            FrameRectangle frameRectangle = (FrameRectangle)other;
            if (this.x != frameRectangle.x) {
                return false;
            }
            if (this.y != frameRectangle.y) {
                return false;
            }
            if (this.w != frameRectangle.w) {
                return false;
            }
            if (this.h != frameRectangle.h) {
                return false;
            }
            return this.s == frameRectangle.s;
        }
    }
}

