/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.BannerPanel;
import app.termora.DarkLafTag;
import app.termora.DocumentAdaptor;
import app.termora.FileChooser;
import app.termora.FontComboBox;
import app.termora.Hyperlink;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.IntSpinner;
import app.termora.LightLafTag;
import app.termora.NumberSpinner;
import app.termora.OptionsPane;
import app.termora.OutlineComboBox;
import app.termora.OutlineTextField;
import app.termora.SettingsOptionExtension;
import app.termora.SettingsOptionsPane;
import app.termora.TabOrder;
import app.termora.TerminalFactory;
import app.termora.TerminalPanelFactory;
import app.termora.TerminalTab;
import app.termora.TerminalTabbedManager;
import app.termora.TermoraFrame;
import app.termora.TermoraFrameManager;
import app.termora.TermoraLayout;
import app.termora.TermoraRestarter;
import app.termora.ThemeManager;
import app.termora.YesOrNoComboBox;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.database.DatabaseManager;
import app.termora.keymap.KeymapPanel;
import app.termora.plugin.ExtensionManager;
import app.termora.terminal.CursorStyle;
import app.termora.terminal.DataKey;
import app.termora.terminal.Terminal;
import app.termora.terminal.panel.FloatingToolbarPanel;
import app.termora.terminal.panel.TerminalPanel;
import app.termora.transfer.TransportTerminalTab;
import com.formdev.flatlaf.extras.components.FlatComboBox;
import com.formdev.flatlaf.extras.components.FlatPopupMenu;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jthemedetecor.OsThemeDetector;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.platform.WindowUtils;
import com.sun.jna.platform.win32.Shell32;
import com.sun.jna.platform.win32.ShlObj;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0006\u0015\u0016\u0017\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lapp/termora/SettingsOptionsPane;", "Lapp/termora/OptionsPane;", "<init>", "()V", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "database", "Lapp/termora/database/DatabaseManager;", "getDatabase", "()Lapp/termora/database/DatabaseManager;", "extensionManager", "Lapp/termora/plugin/ExtensionManager;", "getExtensionManager", "()Lapp/termora/plugin/ExtensionManager;", "addOption", "", "option", "Lapp/termora/OptionsPane$Option;", "Companion", "AppearanceOption", "TerminalOption", "SFTPOption", "AboutOption", "KeyShortcutsOption", "termora"})
public final class SettingsOptionsPane
extends OptionsPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<List<String>> localShells$delegate = LazyKt.lazy(SettingsOptionsPane::localShells_delegate$lambda$0);

    public SettingsOptionsPane() {
        List<SettingsOptionExtension> extensions = this.getExtensionManager().getExtensions(SettingsOptionExtension.class);
        List options = new ArrayList();
        options.add(new AppearanceOption());
        options.add(new TerminalOption());
        options.add(new KeyShortcutsOption());
        options.add(new SFTPOption());
        options.add(new AboutOption());
        for (SettingsOptionExtension extension : extensions) {
            options.add(extension.createSettingsOption());
        }
        for (OptionsPane.Option option : options) {
            this.addOption(option);
        }
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final DatabaseManager getDatabase() {
        return DatabaseManager.Companion.getInstance();
    }

    private final ExtensionManager getExtensionManager() {
        return ExtensionManager.Companion.getInstance();
    }

    @Override
    public void addOption(@NotNull OptionsPane.Option option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        super.addOption(option);
    }

    private static final List localShells_delegate$lambda$0() {
        return SettingsOptionsPane.Companion.loadShells();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0001H\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0002J\b\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016\u00a8\u0006\u0018"}, d2={"Lapp/termora/SettingsOptionsPane$AboutOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/SettingsOptionsPane;)V", "initView", "", "p", "createHyperlink", "Lapp/termora/Hyperlink;", "url", "", "text", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "getJComponent", "Ljavax/swing/JComponent;", "getAnchor", "Lapp/termora/OptionsPane$Anchor;", "getIdentifier", "termora"})
    @SourceDebugExtension(value={"SMAP\nSettingsOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$AboutOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1029:1\n1#2:1030\n*E\n"})
    private final class AboutOption
    extends JPanel
    implements OptionsPane.Option {
        public AboutOption() {
            super(new BorderLayout());
            this.initView();
            this.initEvents();
        }

        private final void initView() {
            this.add((Component)new BannerPanel(9, true), "North");
            this.add((Component)this.p(), "Center");
        }

        private final JPanel p() {
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 20dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref, 4dlu, pref");
            int rows = 0;
            rows = 1;
            int step = 2;
            String branch = Application.INSTANCE.isUnknownVersion() ? "main" : Application.INSTANCE.getVersion();
            Object[] objectArray = new Object[]{Application.INSTANCE.getVersion()};
            Object[] $this$p_u24lambda_u240 = objectArray = FormBuilder.create().padding("7dlu, 7dlu, 7dlu, 7dlu", new Object[0]).layout(layout).debug(false).add(I18n.INSTANCE.getString("termora.settings.about.termora", objectArray), new Object[0]).xyw(1, rows, 3, "center, fill");
            boolean bl = false;
            Object[] $this$p_u24lambda_u241 = objectArray = objectArray.add(I18n.INSTANCE.getString("termora.settings.about.author") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)AboutOption.createHyperlink$default(this, "https://github.com/hstyi", null, 2, null))).xy(3, rows);
            boolean bl2 = false;
            Object[] $this$p_u24lambda_u242 = objectArray = objectArray.add(I18n.INSTANCE.getString("termora.settings.about.source") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.createHyperlink("https://github.com/TermoraDev/termora/tree/" + branch, "https://github.com/TermoraDev/termora"))).xy(3, rows);
            boolean bl3 = false;
            Object[] $this$p_u24lambda_u243 = objectArray = objectArray.add(I18n.INSTANCE.getString("termora.settings.about.issue") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)AboutOption.createHyperlink$default(this, "https://github.com/TermoraDev/termora/issues", null, 2, null))).xy(3, rows);
            boolean bl4 = false;
            Object[] $this$p_u24lambda_u244 = objectArray = objectArray.add(I18n.INSTANCE.getString("termora.settings.about.third-party") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.createHyperlink("https://github.com/TermoraDev/termora/blob/" + branch + "/THIRDPARTY", "Open-source software"))).xy(3, rows);
            boolean bl5 = false;
            rows += step;
            Object[] builder2 = objectArray;
            if (I18n.INSTANCE.isChinaMainland()) {
                Object[] $this$p_u24lambda_u245 = objectArray = builder2.add("\u4ea4\u6d41\u7fa4:", new Object[0]).xy(1, rows).add((Component)((Object)this.createHyperlink("https://www.termora.cn/muted/discussion-group", "Discussion Group"))).xy(3, rows);
                boolean bl6 = false;
                rows += step;
            }
            JPanel jPanel = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
            return jPanel;
        }

        private final Hyperlink createHyperlink(String url, String text) {
            return new Hyperlink(new AnAction(text, url){
                final /* synthetic */ String $url;
                {
                    this.$url = $url;
                    super($text);
                }

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    URI uRI = URI.create(this.$url);
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                    Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
                }
            }, false, 2, null);
        }

        static /* synthetic */ Hyperlink createHyperlink$default(AboutOption aboutOption, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = string;
            }
            return aboutOption.createHyperlink(string, string2);
        }

        private final void initEvents() {
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getInfoOutline());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.settings.about");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        @Override
        @NotNull
        public OptionsPane.Anchor getAnchor() {
            return OptionsPane.Anchor.Last.INSTANCE;
        }

        @Override
        @NotNull
        public String getIdentifier() {
            return "About";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u000bH\u0016J\b\u00104\u001a\u00020\u000bH\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020-H\u0002J\b\u00108\u001a\u00020\u0001H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u00069"}, d2={"Lapp/termora/SettingsOptionsPane$AppearanceOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/SettingsOptionsPane;)V", "themeManager", "Lapp/termora/ThemeManager;", "getThemeManager", "()Lapp/termora/ThemeManager;", "themeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "", "getThemeComboBox", "()Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "layoutComboBox", "Lapp/termora/TermoraLayout;", "getLayoutComboBox", "languageComboBox", "getLanguageComboBox", "backgroundComBoBox", "Lapp/termora/YesOrNoComboBox;", "getBackgroundComBoBox", "()Lapp/termora/YesOrNoComboBox;", "confirmTabCloseComBoBox", "getConfirmTabCloseComBoBox", "tabOrderComboBox", "Lapp/termora/TabOrder;", "getTabOrderComboBox", "followSystemCheckBox", "Ljavax/swing/JCheckBox;", "getFollowSystemCheckBox", "()Ljavax/swing/JCheckBox;", "preferredThemeBtn", "Ljavax/swing/JButton;", "getPreferredThemeBtn", "()Ljavax/swing/JButton;", "opacitySpinner", "Lapp/termora/NumberSpinner;", "getOpacitySpinner", "()Lapp/termora/NumberSpinner;", "appearance", "Lapp/termora/database/DatabaseManager$Appearance;", "getAppearance", "()Lapp/termora/database/DatabaseManager$Appearance;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "getIdentifier", "getJComponent", "Ljavax/swing/JComponent;", "showPreferredThemeContextmenu", "getFormPanel", "termora"})
    @SourceDebugExtension(value={"SMAP\nSettingsOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$AppearanceOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,1029:1\n1#2:1030\n1869#3,2:1031\n216#4,2:1033\n*S KotlinDebug\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$AppearanceOption\n*L\n193#1:1031,2\n196#1:1033,2\n*E\n"})
    private final class AppearanceOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final ThemeManager themeManager;
        @NotNull
        private final FlatComboBox<String> themeComboBox;
        @NotNull
        private final FlatComboBox<TermoraLayout> layoutComboBox;
        @NotNull
        private final FlatComboBox<String> languageComboBox;
        @NotNull
        private final YesOrNoComboBox backgroundComBoBox;
        @NotNull
        private final YesOrNoComboBox confirmTabCloseComBoBox;
        @NotNull
        private final FlatComboBox<TabOrder> tabOrderComboBox;
        @NotNull
        private final JCheckBox followSystemCheckBox;
        @NotNull
        private final JButton preferredThemeBtn;
        @NotNull
        private final NumberSpinner opacitySpinner;

        public AppearanceOption() {
            super(new BorderLayout());
            this.themeManager = ThemeManager.Companion.getInstance();
            this.themeComboBox = new FlatComboBox();
            this.layoutComboBox = new FlatComboBox();
            this.languageComboBox = new FlatComboBox();
            this.backgroundComBoBox = new YesOrNoComboBox();
            this.confirmTabCloseComBoBox = new YesOrNoComboBox();
            this.tabOrderComboBox = new FlatComboBox();
            this.followSystemCheckBox = new JCheckBox(I18n.INSTANCE.getString("termora.settings.appearance.follow-system"));
            this.preferredThemeBtn = new JButton((Icon)((Object)Icons.INSTANCE.getSettings()));
            this.opacitySpinner = new NumberSpinner(100, 0, 100);
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final ThemeManager getThemeManager() {
            return this.themeManager;
        }

        @NotNull
        public final FlatComboBox<String> getThemeComboBox() {
            return this.themeComboBox;
        }

        @NotNull
        public final FlatComboBox<TermoraLayout> getLayoutComboBox() {
            return this.layoutComboBox;
        }

        @NotNull
        public final FlatComboBox<String> getLanguageComboBox() {
            return this.languageComboBox;
        }

        @NotNull
        public final YesOrNoComboBox getBackgroundComBoBox() {
            return this.backgroundComBoBox;
        }

        @NotNull
        public final YesOrNoComboBox getConfirmTabCloseComBoBox() {
            return this.confirmTabCloseComBoBox;
        }

        @NotNull
        public final FlatComboBox<TabOrder> getTabOrderComboBox() {
            return this.tabOrderComboBox;
        }

        @NotNull
        public final JCheckBox getFollowSystemCheckBox() {
            return this.followSystemCheckBox;
        }

        @NotNull
        public final JButton getPreferredThemeBtn() {
            return this.preferredThemeBtn;
        }

        @NotNull
        public final NumberSpinner getOpacitySpinner() {
            return this.opacitySpinner;
        }

        private final DatabaseManager.Appearance getAppearance() {
            return SettingsOptionsPane.this.getDatabase().getAppearance();
        }

        private final void initView() {
            boolean bl;
            Object it;
            Iterator<Object> iterator2;
            Object $this$initView_u24lambda_u240;
            this.tabOrderComboBox.addItem((Object)TabOrder.Hide);
            this.tabOrderComboBox.addItem((Object)TabOrder.AsNeed);
            this.tabOrderComboBox.addItem((Object)TabOrder.Always);
            Object object = this;
            Object object2 = this.tabOrderComboBox;
            try {
                $this$initView_u24lambda_u240 = object;
                boolean bl2 = false;
                $this$initView_u24lambda_u240 = Result.constructor-impl((Object)((Object)TabOrder.valueOf(super.getAppearance().getTabOrder())));
            }
            catch (Throwable throwable) {
                $this$initView_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = $this$initView_u24lambda_u240;
            TabOrder tabOrder = (TabOrder)((Object)(Result.isFailure-impl((Object)object) ? null : object));
            if (tabOrder == null) {
                tabOrder = TabOrder.Hide;
            }
            object2.setSelectedItem((Object)tabOrder);
            this.layoutComboBox.addItem((Object)TermoraLayout.Screen);
            this.layoutComboBox.addItem((Object)TermoraLayout.Fence);
            this.layoutComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object text = value;
                    if (value == TermoraLayout.Screen) {
                        text = I18n.INSTANCE.getString("termora.settings.appearance.layout.screen");
                    } else if (value == TermoraLayout.Fence) {
                        text = I18n.INSTANCE.getString("termora.settings.appearance.layout.fence");
                    }
                    Component c = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    this.setIcon(null);
                    if (value == TermoraLayout.Screen) {
                        this.setIcon(isSelected ? (Icon)((Object)Icons.INSTANCE.getUiForm().getDark()) : (Icon)((Object)Icons.INSTANCE.getUiForm()));
                    } else if (value == TermoraLayout.Fence) {
                        this.setIcon(isSelected ? (Icon)((Object)Icons.INSTANCE.getDataColumn().getDark()) : (Icon)((Object)Icons.INSTANCE.getDataColumn()));
                    }
                    Intrinsics.checkNotNull((Object)c);
                    return c;
                }
            });
            object = this;
            object2 = this.layoutComboBox;
            try {
                AppearanceOption $this$initView_u24lambda_u241 = (AppearanceOption)object;
                boolean bl3 = false;
                iterator2 = Result.constructor-impl((Object)((Object)TermoraLayout.valueOf($this$initView_u24lambda_u241.getAppearance().getLayout())));
            }
            catch (Throwable throwable) {
                iterator2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object = iterator2;
            TermoraLayout termoraLayout = (TermoraLayout)((Object)(Result.isFailure-impl((Object)object) ? null : object));
            if (termoraLayout == null) {
                termoraLayout = TermoraLayout.Companion.getLayout();
            }
            object2.setSelectedItem((Object)termoraLayout);
            this.backgroundComBoBox.setEnabled(SystemInfo.isWindows || SystemInfo.isMacOS);
            this.opacitySpinner.setEnabled(SystemInfo.isMacOS || SystemInfo.isWindows || SystemInfo.isLinux && WindowUtils.isWindowAlphaSupported());
            double d = this.getAppearance().getOpacity();
            this.opacitySpinner.setModel(new SpinnerNumberModel(d){

                public Object getNextValue() {
                    Comparable<?> comparable = super.getNextValue();
                    if (comparable == null) {
                        Comparable<?> comparable2 = this.getMaximum();
                        comparable = comparable2;
                        Intrinsics.checkNotNullExpressionValue(comparable2, (String)"getMaximum(...)");
                    }
                    return comparable;
                }

                public Object getPreviousValue() {
                    Comparable<?> comparable = super.getPreviousValue();
                    if (comparable == null) {
                        Comparable<?> comparable2 = this.getMinimum();
                        comparable = comparable2;
                        Intrinsics.checkNotNullExpressionValue(comparable2, (String)"getMinimum(...)");
                    }
                    return comparable;
                }
            });
            this.opacitySpinner.setEditor(new JSpinner.NumberEditor((JSpinner)((Object)this.opacitySpinner), "#.##"));
            this.opacitySpinner.getModel().setStepSize(0.05);
            this.followSystemCheckBox.setSelected(this.getAppearance().getFollowSystem());
            this.preferredThemeBtn.setEnabled(this.followSystemCheckBox.isSelected());
            this.backgroundComBoBox.setSelectedItem(this.getAppearance().getBackgroundRunning());
            this.confirmTabCloseComBoBox.setSelectedItem(this.getAppearance().getConfirmTabClose());
            this.themeComboBox.setEnabled(!this.followSystemCheckBox.isSelected());
            Object $this$forEach$iv = this.themeManager.getThemes().keySet();
            boolean $i$f$forEach = false;
            iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                it = (String)t;
                bl = false;
                this.themeComboBox.addItem(it);
            }
            this.themeComboBox.setSelectedItem((Object)this.themeManager.getTheme());
            $this$forEach$iv = I18n.INSTANCE.getLanguages();
            $i$f$forEach = false;
            for (Map.Entry entry : $this$forEach$iv.entrySet()) {
                it = entry;
                bl = false;
                this.languageComboBox.addItem(it.getKey());
            }
            this.languageComboBox.setSelectedItem((Object)this.getAppearance().getLanguage());
            this.languageComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Map<String, String> map = I18n.INSTANCE.getLanguages();
                    Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.String");
                    Component component = super.getListCellRendererComponent(list, MapsKt.getValue(map, (Object)((String)value)), index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            });
            this.add((Component)this.getFormPanel(), "Center");
        }

        private final void initEvents() {
            this.themeComboBox.addItemListener(arg_0 -> AppearanceOption.initEvents$lambda$0(this, arg_0));
            this.layoutComboBox.addItemListener(new ItemListener(this, SettingsOptionsPane.this){
                final /* synthetic */ AppearanceOption this$0;
                final /* synthetic */ SettingsOptionsPane this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void itemStateChanged(ItemEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getStateChange() == 1) {
                        Object object = this.this$0.getLayoutComboBox().getSelectedItem();
                        if (object == null || (object = object.toString()) == null) {
                            return;
                        }
                        AppearanceOption.access$getAppearance(this.this$0).setLayout((String)object);
                        if (!Intrinsics.areEqual((Object)TermoraLayout.Companion.getLayout().name(), (Object)AppearanceOption.access$getAppearance(this.this$0).getLayout())) {
                            SwingUtilities.invokeLater(() -> initEvents.2.itemStateChanged$lambda$0(this.this$1));
                        }
                    }
                }

                private static final void itemStateChanged$lambda$0(SettingsOptionsPane this$0) {
                    TermoraRestarter.scheduleRestart$default(TermoraRestarter.Companion.getInstance(), SettingsOptionsPane.access$getOwner(this$0), false, null, 6, null);
                }
            });
            this.tabOrderComboBox.addItemListener(new ItemListener(this){
                final /* synthetic */ AppearanceOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void itemStateChanged(ItemEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getStateChange() == 1) {
                        Object object = this.this$0.getTabOrderComboBox().getSelectedItem();
                        if (object == null || (object = object.toString()) == null) {
                            return;
                        }
                        AppearanceOption.access$getAppearance(this.this$0).setTabOrder((String)object);
                    }
                }
            });
            this.opacitySpinner.addChangeListener(arg_0 -> AppearanceOption.initEvents$lambda$1(this, arg_0));
            this.backgroundComBoBox.addItemListener(arg_0 -> AppearanceOption.initEvents$lambda$2(this, arg_0));
            this.confirmTabCloseComBoBox.addItemListener(arg_0 -> AppearanceOption.initEvents$lambda$3(this, arg_0));
            this.followSystemCheckBox.addActionListener(arg_0 -> AppearanceOption.initEvents$lambda$4(this, arg_0));
            this.languageComboBox.addItemListener(arg_0 -> AppearanceOption.initEvents$lambda$5(this, SettingsOptionsPane.this, arg_0));
            this.preferredThemeBtn.addActionListener(arg_0 -> AppearanceOption.initEvents$lambda$6(this, arg_0));
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getUiForm());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.settings.appearance");
        }

        @Override
        @NotNull
        public String getIdentifier() {
            return "Appearance";
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        private final void showPreferredThemeContextmenu() {
            FlatPopupMenu popupMenu = new FlatPopupMenu();
            JMenu dark = new JMenu("For Dark OS");
            JMenu light = new JMenu("For Light OS");
            String darkTheme = this.getAppearance().getDarkTheme();
            String lightTheme = this.getAppearance().getLightTheme();
            for (Map.Entry<String, String> e : this.themeManager.getThemes().entrySet()) {
                Class<?> clazz = Class.forName(e.getValue());
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(e.getKey());
                item.setSelected(Intrinsics.areEqual((Object)e.getKey(), (Object)lightTheme) || Intrinsics.areEqual((Object)e.getKey(), (Object)darkTheme));
                Class<?>[] classArray = clazz.getInterfaces();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"getInterfaces(...)");
                if (ArraysKt.contains((Object[])classArray, DarkLafTag.class)) {
                    dark.add(item).addActionListener(arg_0 -> AppearanceOption.showPreferredThemeContextmenu$lambda$0(e, darkTheme, this, arg_0));
                    continue;
                }
                Class<?>[] classArray2 = clazz.getInterfaces();
                Intrinsics.checkNotNullExpressionValue(classArray2, (String)"getInterfaces(...)");
                if (!ArraysKt.contains((Object[])classArray2, LightLafTag.class)) continue;
                light.add(item).addActionListener(arg_0 -> AppearanceOption.showPreferredThemeContextmenu$lambda$1(e, lightTheme, this, arg_0));
            }
            popupMenu.add((JMenuItem)dark);
            popupMenu.addSeparator();
            popupMenu.add((JMenuItem)light);
            popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
            popupMenu.show((Component)this.preferredThemeBtn, 0, this.preferredThemeBtn.getHeight() + 2);
        }

        private final JPanel getFormPanel() {
            FormBuilder formBuilder;
            Object object;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, default, default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            FlatToolBar box = new FlatToolBar();
            box.add((Component)this.followSystemCheckBox);
            box.add(Box.createHorizontalStrut(2));
            box.add((Component)this.preferredThemeBtn);
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getFormPanel_u24lambda_u240 = object = FormBuilder.create().layout(layout).debug(false).add(I18n.INSTANCE.getString("termora.settings.appearance.theme") + ":", new Object[0]).xy(1, rows).add((Component)this.themeComboBox).xy(3, rows).add((Component)box).xy(5, rows);
            boolean bl = false;
            FormBuilder formBuilder2 = object.add(I18n.INSTANCE.getString("termora.settings.appearance.language") + ":", new Object[0]).xy(1, rows += step).add((Component)this.languageComboBox).xy(3, rows);
            object = I18n.INSTANCE.getString("termora.settings.appearance.i-want-to-translate");
            Object $this$getFormPanel_u24lambda_u241 = object = formBuilder2.add((Component)((Object)new Hyperlink(new AnAction((String)object){

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    URI uRI = URI.create("https://github.com/TermoraDev/termora/tree/main/src/main/resources/i18n");
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                    Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
                }
            }, false, 2, null))).xy(5, rows);
            boolean bl2 = false;
            Object builder2 = object;
            Object $this$getFormPanel_u24lambda_u242 = object = builder2.add(I18n.INSTANCE.getString("termora.settings.appearance.layout") + ":", new Object[0]).xy(1, rows += step).add((Component)this.layoutComboBox).xy(3, rows);
            boolean bl3 = false;
            Object $this$getFormPanel_u24lambda_u243 = object = builder2.add(I18n.INSTANCE.getString("termora.settings.appearance.opacity") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.opacitySpinner)).xy(3, rows);
            boolean bl4 = false;
            Object $this$getFormPanel_u24lambda_u244 = object = builder2.add(I18n.INSTANCE.getString("termora.settings.appearance.background-running") + ":", new Object[0]).xy(1, rows += step).add((Component)this.backgroundComBoBox).xy(3, rows);
            boolean bl5 = false;
            Object $this$getFormPanel_u24lambda_u245 = object = builder2.add(I18n.INSTANCE.getString("termora.settings.appearance.tab-order") + ":", new Object[0]).xy(1, rows += step).add((Component)this.tabOrderComboBox).xy(3, rows);
            boolean bl6 = false;
            rows += step;
            Box confirmTabCloseBox = Box.createHorizontalBox();
            confirmTabCloseBox.add(new JLabel(I18n.INSTANCE.getString("termora.settings.appearance.confirm-tab-close") + ":"));
            confirmTabCloseBox.add(Box.createHorizontalStrut(8));
            confirmTabCloseBox.add(this.confirmTabCloseComBoBox);
            FormBuilder $this$getFormPanel_u24lambda_u246 = formBuilder = builder2.add((Component)confirmTabCloseBox).xyw(1, rows, 3);
            boolean bl7 = false;
            rows += step;
            JPanel jPanel = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
            return jPanel;
        }

        private static final void initEvents$lambda$0(AppearanceOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Appearance appearance = this$0.getAppearance();
                Object object = this$0.themeComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                appearance.setTheme((String)object);
                SwingUtilities.invokeLater(() -> AppearanceOption.initEvents$lambda$0$0(this$0));
            }
        }

        private static final void initEvents$lambda$0$0(AppearanceOption this$0) {
            ThemeManager themeManager = this$0.themeManager;
            Object object = this$0.themeComboBox.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            ThemeManager.change$default(themeManager, (String)object, false, 2, null);
        }

        private static final void initEvents$lambda$1(AppearanceOption this$0, ChangeEvent it) {
            Object opacity = this$0.opacitySpinner.getValue();
            if (opacity instanceof Double) {
                TermoraFrameManager.Companion.getInstance().setOpacity(((Number)opacity).doubleValue());
                this$0.getAppearance().setOpacity(((Number)opacity).doubleValue());
            }
        }

        private static final void initEvents$lambda$2(AppearanceOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Appearance appearance = this$0.getAppearance();
                Object object = this$0.backgroundComBoBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                appearance.setBackgroundRunning((Boolean)object);
            }
        }

        private static final void initEvents$lambda$3(AppearanceOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Appearance appearance = this$0.getAppearance();
                Object object = this$0.confirmTabCloseComBoBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                appearance.setConfirmTabClose((Boolean)object);
            }
        }

        private static final void initEvents$lambda$4(AppearanceOption this$0, ActionEvent it) {
            this$0.getAppearance().setFollowSystem(this$0.followSystemCheckBox.isSelected());
            this$0.themeComboBox.setEnabled(!this$0.followSystemCheckBox.isSelected());
            this$0.preferredThemeBtn.setEnabled(this$0.followSystemCheckBox.isSelected());
            DatabaseManager.Appearance appearance = this$0.getAppearance();
            Object object = this$0.themeComboBox.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            appearance.setTheme((String)object);
            if (this$0.followSystemCheckBox.isSelected()) {
                SwingUtilities.invokeLater(() -> AppearanceOption.initEvents$lambda$4$0(this$0));
            }
        }

        private static final void initEvents$lambda$4$0(AppearanceOption this$0) {
            if (OsThemeDetector.getDetector().isDark()) {
                ThemeManager.change$default(this$0.themeManager, this$0.getAppearance().getDarkTheme(), false, 2, null);
                this$0.themeComboBox.setSelectedItem((Object)this$0.getAppearance().getDarkTheme());
            } else {
                ThemeManager.change$default(this$0.themeManager, this$0.getAppearance().getLightTheme(), false, 2, null);
                this$0.themeComboBox.setSelectedItem((Object)this$0.getAppearance().getLightTheme());
            }
        }

        private static final void initEvents$lambda$5(AppearanceOption this$0, SettingsOptionsPane this$1, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Appearance appearance = this$0.getAppearance();
                Object object = this$0.languageComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                appearance.setLanguage((String)object);
                SwingUtilities.invokeLater(() -> AppearanceOption.initEvents$lambda$5$0(this$1));
            }
        }

        private static final void initEvents$lambda$5$0(SettingsOptionsPane this$0) {
            TermoraRestarter.scheduleRestart$default(TermoraRestarter.Companion.getInstance(), this$0.getOwner(), false, null, 6, null);
        }

        private static final void initEvents$lambda$6(AppearanceOption this$0, ActionEvent it) {
            this$0.showPreferredThemeContextmenu();
        }

        private static final void showPreferredThemeContextmenu$lambda$0(Map.Entry $e, String $darkTheme, AppearanceOption this$0, ActionEvent it) {
            if (!Intrinsics.areEqual($e.getKey(), (Object)$darkTheme)) {
                this$0.getAppearance().setDarkTheme((String)$e.getKey());
                if (OsThemeDetector.getDetector().isDark()) {
                    this$0.themeComboBox.setSelectedItem($e.getKey());
                }
            }
        }

        private static final void showPreferredThemeContextmenu$lambda$1(Map.Entry $e, String $lightTheme, AppearanceOption this$0, ActionEvent it) {
            if (!Intrinsics.areEqual($e.getKey(), (Object)$lightTheme)) {
                this$0.getAppearance().setLightTheme((String)$e.getKey());
                if (!OsThemeDetector.getDetector().isDark()) {
                    this$0.themeComboBox.setSelectedItem($e.getKey());
                }
            }
        }

        public static final /* synthetic */ DatabaseManager.Appearance access$getAppearance(AppearanceOption $this) {
            return $this.getAppearance();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lapp/termora/SettingsOptionsPane$Companion;", "", "<init>", "()V", "localShells", "", "", "getLocalShells", "()Ljava/util/List;", "localShells$delegate", "Lkotlin/Lazy;", "loadShells", "termora"})
    @SourceDebugExtension(value={"SMAP\nSettingsOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1029:1\n774#2:1030\n865#2,2:1031\n774#2:1033\n865#2,2:1034\n1869#2,2:1036\n*S KotlinDebug\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$Companion\n*L\n66#1:1030\n66#1:1031,2\n67#1:1033\n67#1:1034,2\n68#1:1036,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final List<String> getLocalShells() {
            Lazy lazy = localShells$delegate;
            return (List)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final List<String> loadShells() {
            List shells = new ArrayList();
            if (SystemInfo.isWindows) {
                shells.add("cmd.exe");
                v0 = Boolean.valueOf(shells.add("powershell.exe"));
            } else {
                Object object;
                Object object2;
                try {
                    boolean bl = false;
                    object2 = new String[]{"cat", "/etc/shells"};
                    Process process = new ProcessBuilder((String)object2).start();
                    if (process.waitFor() != 0) {
                        throw new LastErrorException(process.exitValue());
                    }
                    object2 = process.getInputStream();
                    Throwable throwable = null;
                    try {
                        void $this$forEach$iv;
                        String e;
                        Iterable $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        InputStream input2 = (InputStream)object2;
                        boolean bl2 = false;
                        byte[] byArray = input2.readAllBytes();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                        Object object3 = byArray;
                        object3 = StringsKt.lines((CharSequence)new String((byte[])object3, Charsets.UTF_8));
                        boolean $i$f$filter = false;
                        Iterator iterator2 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            e = (String)element$iv$iv;
                            boolean bl3 = false;
                            if (!(!StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)e)).toString(), (char)'#', (boolean)false, (int)2, null))) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        $i$f$filter = false;
                        $this$filterTo$iv$iv = $this$filter$iv;
                        destination$iv$iv = new ArrayList();
                        $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            e = (String)element$iv$iv;
                            boolean bl4 = false;
                            boolean bl5 = !StringsKt.isBlank((CharSequence)e);
                            if (!bl5) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl6 = false;
                            shells.add(((Object)StringsKt.trim((CharSequence)it)).toString());
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                    }
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Throwable throwable = Result.exceptionOrNull-impl((Object)object);
                if (throwable != null) {
                    object2 = throwable;
                    String[] it = object2;
                    boolean bl = false;
                    shells.add("/bin/bash");
                    shells.add("/bin/csh");
                    shells.add("/bin/dash");
                    shells.add("/bin/ksh");
                    shells.add("/bin/sh");
                    shells.add("/bin/tcsh");
                    shells.add("/bin/zsh");
                }
                v0 = Result.box-impl((Object)object);
            }
            return shells;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/termora/SettingsOptionsPane$KeyShortcutsOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/SettingsOptionsPane;)V", "keymapPanel", "Lapp/termora/keymap/KeymapPanel;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "termora"})
    private final class KeyShortcutsOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final KeymapPanel keymapPanel;

        public KeyShortcutsOption() {
            super(new BorderLayout());
            this.keymapPanel = new KeymapPanel();
            this.initView();
            this.initEvents();
        }

        private final void initView() {
            this.add((Component)this.keymapPanel, "Center");
        }

        private final void initEvents() {
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getFitContent());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.settings.keymap");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lapp/termora/SettingsOptionsPane$SFTPOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/SettingsOptionsPane;)V", "editCommandField", "Lapp/termora/OutlineTextField;", "sftpCommandField", "defaultDirectoryField", "browseDirectoryBtn", "Ljavax/swing/JButton;", "browseEditCommandBtn", "pinTabComboBox", "Lapp/termora/YesOrNoComboBox;", "preserveModificationTimeComboBox", "doubleClickComboBox", "Lapp/termora/OutlineComboBox;", "", "sftp", "Lapp/termora/database/DatabaseManager$SFTP;", "getSftp", "()Lapp/termora/database/DatabaseManager$SFTP;", "initEvents", "", "initView", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "termora"})
    @SourceDebugExtension(value={"SMAP\nSettingsOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$SFTPOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1029:1\n1#2:1030\n*E\n"})
    private final class SFTPOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final OutlineTextField editCommandField;
        @NotNull
        private final OutlineTextField sftpCommandField;
        @NotNull
        private final OutlineTextField defaultDirectoryField;
        @NotNull
        private final JButton browseDirectoryBtn;
        @NotNull
        private final JButton browseEditCommandBtn;
        @NotNull
        private final YesOrNoComboBox pinTabComboBox;
        @NotNull
        private final YesOrNoComboBox preserveModificationTimeComboBox;
        @NotNull
        private final OutlineComboBox<String> doubleClickComboBox;

        public SFTPOption() {
            super(new BorderLayout());
            this.editCommandField = new OutlineTextField(255);
            this.sftpCommandField = new OutlineTextField(255);
            this.defaultDirectoryField = new OutlineTextField(255);
            this.browseDirectoryBtn = new JButton((Icon)((Object)Icons.INSTANCE.getFolder()));
            this.browseEditCommandBtn = new JButton((Icon)((Object)Icons.INSTANCE.getFolder()));
            this.pinTabComboBox = new YesOrNoComboBox();
            this.preserveModificationTimeComboBox = new YesOrNoComboBox();
            this.doubleClickComboBox = new OutlineComboBox();
            this.initView();
            this.initEvents();
            this.add((Component)this.getCenterComponent(), "Center");
        }

        private final DatabaseManager.SFTP getSftp() {
            return SettingsOptionsPane.this.getDatabase().getSftp();
        }

        private final void initEvents() {
            this.editCommandField.getDocument().addDocumentListener(new DocumentAdaptor(this){
                final /* synthetic */ SFTPOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void changedUpdate(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    DatabaseManager.SFTP sFTP = SFTPOption.access$getSftp(this.this$0);
                    String string = SFTPOption.access$getEditCommandField$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    sFTP.setEditCommand(string);
                }
            });
            this.sftpCommandField.getDocument().addDocumentListener(new DocumentAdaptor(this){
                final /* synthetic */ SFTPOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void changedUpdate(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    DatabaseManager.SFTP sFTP = SFTPOption.access$getSftp(this.this$0);
                    String string = SFTPOption.access$getSftpCommandField$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    sFTP.setSftpCommand(string);
                }
            });
            this.defaultDirectoryField.getDocument().addDocumentListener(new DocumentAdaptor(this){
                final /* synthetic */ SFTPOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void changedUpdate(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    DatabaseManager.SFTP sFTP = SFTPOption.access$getSftp(this.this$0);
                    String string = SFTPOption.access$getDefaultDirectoryField$p(this.this$0).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    sFTP.setDefaultDirectory(string);
                }
            });
            this.pinTabComboBox.addItemListener(new ItemListener(this){
                final /* synthetic */ SFTPOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void itemStateChanged(ItemEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    DatabaseManager.SFTP sFTP = SFTPOption.access$getSftp(this.this$0);
                    Object object = SFTPOption.access$getPinTabComboBox$p(this.this$0).getSelectedItem();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                    sFTP.setPinTab((Boolean)object);
                    for (TermoraFrame window : TermoraFrameManager.Companion.getInstance().getWindows()) {
                        TerminalTabbedManager manager;
                        AnActionEvent evt = new AnActionEvent((Object)window, "", new EventObject(window));
                        if (evt.getData(DataProviders.INSTANCE.getTerminalTabbedManager()) == null) continue;
                        if (SFTPOption.access$getSftp(this.this$0).getPinTab()) {
                            boolean bl;
                            block7: {
                                Iterable $this$none$iv = manager.getTerminalTabs();
                                boolean $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    bl = true;
                                } else {
                                    for (T element$iv : $this$none$iv) {
                                        TerminalTab it = (TerminalTab)element$iv;
                                        boolean bl2 = false;
                                        if (!(it instanceof TransportTerminalTab)) continue;
                                        bl = false;
                                        break block7;
                                    }
                                    bl = true;
                                }
                            }
                            if (bl) {
                                manager.addTerminalTab(1, new TransportTerminalTab(), false);
                            }
                        }
                        manager.refreshTerminalTabs();
                    }
                }
            });
            this.doubleClickComboBox.addItemListener(new ItemListener(this){
                final /* synthetic */ SFTPOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void itemStateChanged(ItemEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getStateChange() != 1) {
                        return;
                    }
                    DatabaseManager.SFTP sFTP = SFTPOption.access$getSftp(this.this$0);
                    Object object = SFTPOption.access$getDoubleClickComboBox$p(this.this$0).getSelectedItem();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                    sFTP.setDbClickBehavior((String)object);
                }
            });
            this.preserveModificationTimeComboBox.addItemListener(arg_0 -> SFTPOption.initEvents$lambda$0(this, arg_0));
            this.browseDirectoryBtn.addActionListener(new AbstractAction(this, SettingsOptionsPane.this){
                final /* synthetic */ SFTPOption this$0;
                final /* synthetic */ SettingsOptionsPane this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FileChooser chooser = new FileChooser();
                    chooser.setAllowsMultiSelection(false);
                    CharSequence charSequence = StringUtils.defaultIfBlank((CharSequence)SFTPOption.access$getDefaultDirectoryField$p(this.this$0).getText(), (CharSequence)SystemUtils.USER_HOME);
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"defaultIfBlank(...)");
                    chooser.setDefaultDirectory((String)charSequence);
                    chooser.setFileSelectionMode(1);
                    chooser.showOpenDialog(SettingsOptionsPane.access$getOwner(this.this$1)).thenAccept(arg_0 -> initEvents.7.actionPerformed$lambda$1(arg_0 -> initEvents.7.actionPerformed$lambda$0(this.this$0, arg_0), arg_0));
                }

                private static final Unit actionPerformed$lambda$0(SFTPOption this$0, List files) {
                    Intrinsics.checkNotNull((Object)files);
                    if (!((Collection)files).isEmpty()) {
                        SFTPOption.access$getDefaultDirectoryField$p(this$0).setText(((File)CollectionsKt.first((List)files)).getAbsolutePath());
                    }
                    return Unit.INSTANCE;
                }

                private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            });
            this.browseEditCommandBtn.addActionListener(new AbstractAction(SettingsOptionsPane.this, this){
                final /* synthetic */ SettingsOptionsPane this$0;
                final /* synthetic */ SFTPOption this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FileChooser chooser = new FileChooser();
                    chooser.setAllowsMultiSelection(false);
                    chooser.setFileSelectionMode(0);
                    if (SystemInfo.isMacOS) {
                        chooser.setDefaultDirectory("/Applications");
                    } else if (SystemInfo.isWindows) {
                        char[] pszPath = new char[260];
                        Shell32.INSTANCE.SHGetFolderPath(null, 16, null, ShlObj.SHGFP_TYPE_CURRENT, pszPath);
                        String string = Native.toString((char[])pszPath);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                        chooser.setDefaultDirectory(string);
                    } else {
                        String string = SystemUtils.USER_HOME;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"USER_HOME");
                        chooser.setDefaultDirectory(string);
                    }
                    chooser.showOpenDialog(SettingsOptionsPane.access$getOwner(this.this$0)).thenAccept(arg_0 -> initEvents.8.actionPerformed$lambda$1(arg_0 -> initEvents.8.actionPerformed$lambda$0(this.this$1, arg_0), arg_0));
                }

                private static final Unit actionPerformed$lambda$0(SFTPOption this$0, List files) {
                    Intrinsics.checkNotNull((Object)files);
                    if (!((Collection)files).isEmpty()) {
                        File file = (File)CollectionsKt.first((List)files);
                        if (SystemInfo.isMacOS) {
                            SFTPOption.access$getEditCommandField$p(this$0).setText("open -a " + file.getAbsolutePath() + " {0}");
                        } else {
                            SFTPOption.access$getEditCommandField$p(this$0).setText(file.getAbsolutePath() + " {0}");
                        }
                    }
                    return Unit.INSTANCE;
                }

                private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
                    $tmp0.invoke(p0);
                }
            });
        }

        private final void initView() {
            if (SystemInfo.isWindows || SystemInfo.isLinux) {
                this.editCommandField.setPlaceholderText("notepad {0}");
            } else if (SystemInfo.isMacOS) {
                this.editCommandField.setPlaceholderText("open -a TextEdit {0}");
            }
            if (SystemInfo.isWindows) {
                this.sftpCommandField.setPlaceholderText("sftp.exe");
            } else {
                this.sftpCommandField.setPlaceholderText("sftp");
            }
            this.editCommandField.setTrailingComponent(this.browseEditCommandBtn);
            this.defaultDirectoryField.setPlaceholderText(SystemUtils.USER_HOME);
            this.defaultDirectoryField.setTrailingComponent(this.browseDirectoryBtn);
            this.defaultDirectoryField.setText(this.getSftp().getDefaultDirectory());
            this.editCommandField.setText(this.getSftp().getEditCommand());
            this.sftpCommandField.setText(this.getSftp().getSftpCommand());
            this.pinTabComboBox.setSelectedItem(this.getSftp().getPinTab());
            this.preserveModificationTimeComboBox.setSelectedItem(this.getSftp().getPreserveModificationTime());
            this.doubleClickComboBox.setRenderer(new DefaultListCellRenderer(this){
                final /* synthetic */ SFTPOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String text;
                    Object object = value;
                    String string = text = object != null ? object.toString() : null;
                    if (Intrinsics.areEqual((Object)value, (Object)"Edit")) {
                        text = I18n.INSTANCE.getString("termora.keymgr.edit");
                    }
                    if (Intrinsics.areEqual((Object)value, (Object)"Transfer")) {
                        text = this.this$0.getTitle();
                    }
                    return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                }
            });
            this.doubleClickComboBox.addItem("Transfer");
            this.doubleClickComboBox.addItem("Edit");
            this.doubleClickComboBox.setSelectedItem(this.getSftp().getDbClickBehavior());
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getFolder());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.transport.sftp");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        private final JComponent getCenterComponent() {
            FormBuilder formBuilder;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 30dlu", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(I18n.INSTANCE.getString("termora.settings.sftp.preserve-time") + ":"));
            box.add(Box.createHorizontalStrut(8));
            box.add(this.preserveModificationTimeComboBox);
            int rows = 0;
            rows = 1;
            FormBuilder builder2 = FormBuilder.create().layout(layout).debug(false);
            builder2.add(I18n.INSTANCE.getString("termora.settings.sftp.fixed-tab") + ":", new Object[0]).xy(1, rows);
            FormBuilder $this$getCenterComponent_u24lambda_u240 = formBuilder = builder2.add((Component)this.pinTabComboBox).xy(3, rows);
            boolean bl = false;
            builder2.add(I18n.INSTANCE.getString("termora.settings.sftp.edit-command") + ":", new Object[0]).xy(1, rows += 2);
            FormBuilder $this$getCenterComponent_u24lambda_u241 = formBuilder = builder2.add((Component)((Object)this.editCommandField)).xy(3, rows);
            boolean bl2 = false;
            builder2.add(I18n.INSTANCE.getString("termora.tabbed.contextmenu.sftp-command") + ":", new Object[0]).xy(1, rows += 2);
            FormBuilder $this$getCenterComponent_u24lambda_u242 = formBuilder = builder2.add((Component)((Object)this.sftpCommandField)).xy(3, rows);
            boolean bl3 = false;
            builder2.add(I18n.INSTANCE.getString("termora.settings.sftp.db-click-behavior") + ":", new Object[0]).xy(1, rows += 2);
            FormBuilder $this$getCenterComponent_u24lambda_u243 = formBuilder = builder2.add((Component)((Object)this.doubleClickComboBox)).xy(3, rows);
            boolean bl4 = false;
            builder2.add(I18n.INSTANCE.getString("termora.settings.sftp.default-directory") + ":", new Object[0]).xy(1, rows += 2);
            FormBuilder $this$getCenterComponent_u24lambda_u244 = formBuilder = builder2.add((Component)((Object)this.defaultDirectoryField)).xy(3, rows);
            boolean bl5 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u245 = formBuilder = builder2.add((Component)box).xyw(1, rows += 2, 3);
            boolean bl6 = false;
            rows += 2;
            JPanel jPanel = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
            return jPanel;
        }

        private static final void initEvents$lambda$0(SFTPOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.SFTP sFTP = this$0.getSftp();
                Object object = this$0.preserveModificationTimeComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                sFTP.setPreserveModificationTime((Boolean)object);
            }
        }

        public static final /* synthetic */ DatabaseManager.SFTP access$getSftp(SFTPOption $this) {
            return $this.getSftp();
        }

        public static final /* synthetic */ OutlineTextField access$getEditCommandField$p(SFTPOption $this) {
            return $this.editCommandField;
        }

        public static final /* synthetic */ OutlineTextField access$getSftpCommandField$p(SFTPOption $this) {
            return $this.sftpCommandField;
        }

        public static final /* synthetic */ OutlineTextField access$getDefaultDirectoryField$p(SFTPOption $this) {
            return $this.defaultDirectoryField;
        }

        public static final /* synthetic */ YesOrNoComboBox access$getPinTabComboBox$p(SFTPOption $this) {
            return $this.pinTabComboBox;
        }

        public static final /* synthetic */ OutlineComboBox access$getDoubleClickComboBox$p(SFTPOption $this) {
            return $this.doubleClickComboBox;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001fH\u0016J\b\u0010'\u001a\u00020\u0010H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020!H\u0016J\b\u0010+\u001a\u00020)H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lapp/termora/SettingsOptionsPane$TerminalOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/SettingsOptionsPane;)V", "cursorStyleComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "Lapp/termora/terminal/CursorStyle;", "debugComboBox", "Lapp/termora/YesOrNoComboBox;", "beepComboBox", "cursorBlinkComboBox", "fontComboBox", "Lapp/termora/FontComboBox;", "fallbackFontComboBox", "shellComboBox", "", "maxRowsTextField", "Lapp/termora/IntSpinner;", "fontSizeTextField", "terminalSetting", "Lapp/termora/database/DatabaseManager$Terminal;", "getTerminalSetting", "()Lapp/termora/database/DatabaseManager$Terminal;", "selectCopyComboBox", "rightClickComboBox", "Lapp/termora/OutlineComboBox;", "autoCloseTabComboBox", "floatingToolbarComboBox", "hyperlinkComboBox", "isInitialized", "", "initEvents", "", "fireFontChanged", "initView", "getIcon", "Ljavax/swing/Icon;", "isSelected", "getTitle", "getJComponent", "Ljavax/swing/JComponent;", "onSelected", "getCenterComponent", "termora"})
    @SourceDebugExtension(value={"SMAP\nSettingsOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$TerminalOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1029:1\n1#2:1030\n13805#3,2:1031\n1869#4,2:1033\n1869#4,2:1035\n*S KotlinDebug\n*F\n+ 1 SettingsOptionsPane.kt\napp/termora/SettingsOptionsPane$TerminalOption\n*L\n464#1:1031,2\n493#1:1033,2\n503#1:1035,2\n*E\n"})
    private final class TerminalOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final FlatComboBox<CursorStyle> cursorStyleComboBox;
        @NotNull
        private final YesOrNoComboBox debugComboBox;
        @NotNull
        private final YesOrNoComboBox beepComboBox;
        @NotNull
        private final YesOrNoComboBox cursorBlinkComboBox;
        @NotNull
        private final FontComboBox fontComboBox;
        @NotNull
        private final FontComboBox fallbackFontComboBox;
        @NotNull
        private final FlatComboBox<String> shellComboBox;
        @NotNull
        private final IntSpinner maxRowsTextField;
        @NotNull
        private final IntSpinner fontSizeTextField;
        @NotNull
        private final YesOrNoComboBox selectCopyComboBox;
        @NotNull
        private final OutlineComboBox<String> rightClickComboBox;
        @NotNull
        private final YesOrNoComboBox autoCloseTabComboBox;
        @NotNull
        private final YesOrNoComboBox floatingToolbarComboBox;
        @NotNull
        private final YesOrNoComboBox hyperlinkComboBox;
        private boolean isInitialized;

        public TerminalOption() {
            super(new BorderLayout());
            this.cursorStyleComboBox = new FlatComboBox();
            this.debugComboBox = new YesOrNoComboBox();
            this.beepComboBox = new YesOrNoComboBox();
            this.cursorBlinkComboBox = new YesOrNoComboBox();
            this.fontComboBox = new FontComboBox();
            this.fallbackFontComboBox = new FontComboBox();
            this.shellComboBox = new FlatComboBox();
            this.maxRowsTextField = new IntSpinner(0, 0, 0, 4, null);
            this.fontSizeTextField = new IntSpinner(0, 9, 99);
            this.selectCopyComboBox = new YesOrNoComboBox();
            this.rightClickComboBox = new OutlineComboBox();
            this.autoCloseTabComboBox = new YesOrNoComboBox();
            this.floatingToolbarComboBox = new YesOrNoComboBox();
            this.hyperlinkComboBox = new YesOrNoComboBox();
        }

        private final DatabaseManager.Terminal getTerminalSetting() {
            return DatabaseManager.Companion.getInstance().getTerminal();
        }

        private final void initEvents() {
            this.fontComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$0(this, arg_0));
            this.rightClickComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$1(this, arg_0));
            this.fallbackFontComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$2(this, arg_0));
            this.autoCloseTabComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$3(this, arg_0));
            this.autoCloseTabComboBox.setToolTipText(I18n.INSTANCE.getString("termora.settings.terminal.auto-close-tab-description"));
            this.floatingToolbarComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$4(this, arg_0));
            this.selectCopyComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$5(this, arg_0));
            this.fontSizeTextField.addChangeListener(arg_0 -> TerminalOption.initEvents$lambda$6(this, arg_0));
            this.maxRowsTextField.addChangeListener(arg_0 -> TerminalOption.initEvents$lambda$7(this, arg_0));
            this.cursorStyleComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$8(this, arg_0));
            this.debugComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$9(this, arg_0));
            this.beepComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$10(this, arg_0));
            this.hyperlinkComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$11(this, arg_0));
            this.cursorBlinkComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$12(this, arg_0));
            this.shellComboBox.addItemListener(arg_0 -> TerminalOption.initEvents$lambda$13(this, arg_0));
        }

        private final void fireFontChanged() {
            TerminalPanelFactory.Companion.getInstance().fireResize();
        }

        private final void initView() {
            this.fontSizeTextField.setValue(this.getTerminalSetting().getFontSize());
            this.maxRowsTextField.setValue(this.getTerminalSetting().getMaxRows());
            this.rightClickComboBox.addItem("Copy");
            this.rightClickComboBox.addItem("CopyAndPaste");
            this.rightClickComboBox.setSelectedItem(this.getTerminalSetting().getRightClick());
            this.cursorStyleComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String text = value == CursorStyle.Block ? "\u258b" : (value == CursorStyle.Underline ? "\u2581" : "\u258f");
                    Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            });
            this.rightClickComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    String text;
                    Object object = value;
                    String string = text = object != null ? object.toString() : null;
                    if (Intrinsics.areEqual((Object)value, (Object)"Copy")) {
                        text = I18n.INSTANCE.getString("termora.settings.terminal.right-click.copy");
                    } else if (Intrinsics.areEqual((Object)value, (Object)"CopyAndPaste")) {
                        text = I18n.INSTANCE.getString("termora.settings.terminal.right-click.copy-and-paste");
                    }
                    Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            });
            this.cursorStyleComboBox.addItem((Object)CursorStyle.Block);
            this.cursorStyleComboBox.addItem((Object)CursorStyle.Bar);
            this.cursorStyleComboBox.addItem((Object)CursorStyle.Underline);
            this.shellComboBox.setEditable(true);
            for (String localShell : Companion.getLocalShells()) {
                this.shellComboBox.addItem((Object)localShell);
            }
            this.shellComboBox.setSelectedItem((Object)this.getTerminalSetting().getLocalShell());
            this.fontComboBox.addItem(this.getTerminalSetting().getFont());
            Set<String> items = this.fontComboBox.getItems();
            Object[] objectArray = new String[]{"JetBrains Mono", "Source Code Pro", "Monospaced"};
            for (String family : CollectionsKt.listOf((Object[])objectArray)) {
                if (items.contains(family)) continue;
                this.fontComboBox.addItem(family);
            }
            if (!StringsKt.isBlank((CharSequence)this.getTerminalSetting().getFallbackFont())) {
                this.fallbackFontComboBox.addItem("");
            }
            this.fallbackFontComboBox.addItem(this.getTerminalSetting().getFallbackFont());
            this.fontComboBox.setSelectedItem(this.getTerminalSetting().getFont());
            this.fallbackFontComboBox.setSelectedItem(this.getTerminalSetting().getFallbackFont());
            this.debugComboBox.setSelectedItem(this.getTerminalSetting().getDebug());
            this.beepComboBox.setSelectedItem(this.getTerminalSetting().getBeep());
            this.hyperlinkComboBox.setSelectedItem(this.getTerminalSetting().getHyperlink());
            this.cursorBlinkComboBox.setSelectedItem(this.getTerminalSetting().getCursorBlink());
            this.cursorStyleComboBox.setSelectedItem((Object)this.getTerminalSetting().getCursor());
            this.selectCopyComboBox.setSelectedItem(this.getTerminalSetting().getSelectCopy());
            this.autoCloseTabComboBox.setSelectedItem(this.getTerminalSetting().getAutoCloseTabWhenDisconnected());
            this.floatingToolbarComboBox.setSelectedItem(this.getTerminalSetting().getFloatingToolbar());
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getTerminal());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.settings.terminal");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        @Override
        public void onSelected() {
            if (this.isInitialized) {
                return;
            }
            this.initView();
            this.initEvents();
            this.add((Component)this.getCenterComponent(), "Center");
            this.isInitialized = true;
        }

        private final JComponent getCenterComponent() {
            FormBuilder formBuilder;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, left:pref, 7dlu, pref, default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            JButton beepBtn = new JButton((Icon)((Object)Icons.INSTANCE.getRun()));
            beepBtn.setFocusable(false);
            beepBtn.putClientProperty("JButton.buttonType", "toolBarButton");
            beepBtn.addActionListener(TerminalOption::getCenterComponent$lambda$0);
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u241 = formBuilder = FormBuilder.create().layout(layout).debug(false).add(I18n.INSTANCE.getString("termora.settings.terminal.font") + ":", new Object[0]).xy(1, rows).add((Component)((Object)this.fontComboBox)).xy(3, rows).add(I18n.INSTANCE.getString("termora.settings.terminal.size") + ":", new Object[0]).xy(5, rows).add((Component)((Object)this.fontSizeTextField)).xy(7, rows);
            boolean bl = false;
            FormBuilder $this$getCenterComponent_u24lambda_u242 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.fallback-font") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.fallbackFontComboBox)).xy(3, rows);
            boolean bl2 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u243 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.max-rows") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.maxRowsTextField)).xy(3, rows);
            boolean bl3 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u244 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.debug") + ":", new Object[0]).xy(1, rows += step).add((Component)this.debugComboBox).xy(3, rows);
            boolean bl4 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u245 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.beep") + ":", new Object[0]).xy(1, rows += step).add((Component)this.beepComboBox).xy(3, rows).add((Component)beepBtn).xy(5, rows);
            boolean bl5 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u246 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.hyperlink") + ":", new Object[0]).xy(1, rows += step).add((Component)this.hyperlinkComboBox).xy(3, rows);
            boolean bl6 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u247 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.select-copy") + ":", new Object[0]).xy(1, rows += step).add((Component)this.selectCopyComboBox).xy(3, rows);
            boolean bl7 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u248 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.right-click") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.rightClickComboBox)).xy(3, rows);
            boolean bl8 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u249 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.cursor-style") + ":", new Object[0]).xy(1, rows += step).add((Component)this.cursorStyleComboBox).xy(3, rows);
            boolean bl9 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u2410 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.cursor-blink") + ":", new Object[0]).xy(1, rows += step).add((Component)this.cursorBlinkComboBox).xy(3, rows);
            boolean bl10 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u2411 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.floating-toolbar") + ":", new Object[0]).xy(1, rows += step).add((Component)this.floatingToolbarComboBox).xy(3, rows);
            boolean bl11 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u2412 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.auto-close-tab") + ":", new Object[0]).xy(1, rows += step).add((Component)this.autoCloseTabComboBox).xy(3, rows);
            boolean bl12 = false;
            JPanel panel2 = formBuilder.add(I18n.INSTANCE.getString("termora.settings.terminal.local-shell") + ":", new Object[0]).xy(1, rows += step).add((Component)this.shellComboBox).xyw(3, rows, 5).build();
            Intrinsics.checkNotNull((Object)panel2);
            return panel2;
        }

        private static final void initEvents$lambda$0(TerminalOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.fontComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                terminal.setFont((String)object);
                this$0.fireFontChanged();
            }
        }

        private static final void initEvents$lambda$1(TerminalOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.rightClickComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                terminal.setRightClick((String)object);
            }
        }

        private static final void initEvents$lambda$2(TerminalOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.fallbackFontComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                terminal.setFallbackFont((String)object);
                this$0.fireFontChanged();
            }
        }

        private static final void initEvents$lambda$3(TerminalOption this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.autoCloseTabComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                terminal.setAutoCloseTabWhenDisconnected((Boolean)object);
            }
        }

        private static final void initEvents$lambda$4(TerminalOption this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.floatingToolbarComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                terminal.setFloatingToolbar((Boolean)object);
                TerminalPanel[] $this$forEach$iv = TerminalPanelFactory.Companion.getInstance().getTerminalPanels();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    TerminalPanel element$iv;
                    TerminalPanel tp = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (this$0.getTerminalSetting().getFloatingToolbar() && FloatingToolbarPanel.Companion.isPined()) {
                        FloatingToolbarPanel floatingToolbarPanel = tp.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                        if (floatingToolbarPanel != null) {
                            floatingToolbarPanel.triggerShow();
                        }
                        continue;
                    }
                    FloatingToolbarPanel floatingToolbarPanel = tp.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
                    if (floatingToolbarPanel != null) {
                        floatingToolbarPanel.triggerHide();
                    }
                }
            }
        }

        private static final void initEvents$lambda$5(TerminalOption this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.selectCopyComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                terminal.setSelectCopy((Boolean)object);
            }
        }

        private static final void initEvents$lambda$6(TerminalOption this$0, ChangeEvent it) {
            DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
            Object object = this$0.fontSizeTextField.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            terminal.setFontSize((Integer)object);
            this$0.fireFontChanged();
        }

        private static final void initEvents$lambda$7(TerminalOption this$0, ChangeEvent it) {
            DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
            Object object = this$0.maxRowsTextField.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            terminal.setMaxRows((Integer)object);
        }

        private static final void initEvents$lambda$8(TerminalOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                Object object = this$0.cursorStyleComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.terminal.CursorStyle");
                CursorStyle style = (CursorStyle)((Object)object);
                this$0.getTerminalSetting().setCursor(style);
                Iterable $this$forEach$iv = TerminalFactory.Companion.getInstance().getTerminals();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Terminal e = (Terminal)element$iv;
                    boolean bl = false;
                    e.getTerminalModel().setData(DataKey.Companion.getCursorStyle(), style);
                }
            }
        }

        private static final void initEvents$lambda$9(TerminalOption this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.debugComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                terminal.setDebug((Boolean)object);
                Iterable $this$forEach$iv = TerminalFactory.Companion.getInstance().getTerminals();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Terminal it = (Terminal)element$iv;
                    boolean bl = false;
                    it.getTerminalModel().setData(TerminalPanel.Companion.getDebug(), this$0.getTerminalSetting().getDebug());
                }
            }
        }

        private static final void initEvents$lambda$10(TerminalOption this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.beepComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                terminal.setBeep((Boolean)object);
            }
        }

        private static final void initEvents$lambda$11(TerminalOption this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.hyperlinkComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                terminal.setHyperlink((Boolean)object);
                TerminalPanelFactory.Companion.getInstance().repaintAll();
            }
        }

        private static final void initEvents$lambda$12(TerminalOption this$0, ItemEvent e) {
            if (e.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.cursorBlinkComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
                terminal.setCursorBlink((Boolean)object);
            }
        }

        private static final void initEvents$lambda$13(TerminalOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                DatabaseManager.Terminal terminal = this$0.getTerminalSetting();
                Object object = this$0.shellComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                terminal.setLocalShell((String)object);
            }
        }

        private static final void getCenterComponent$lambda$0(ActionEvent it) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

