/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.database.DatabaseManager;
import app.termora.macro.MacroPtyConnector;
import app.termora.terminal.PtyConnector;
import app.termora.terminal.PtyConnectorDelegate;
import app.termora.terminal.PtyProcessConnector;
import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessBuilder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0014\u001a\u00020\u0015JW\u0010\r\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0002\u0010\u0018\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0006R2\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lapp/termora/PtyConnectorFactory;", "Lapp/termora/Disposable;", "<init>", "()V", "ptyConnectors", "", "Lapp/termora/terminal/PtyConnector;", "kotlin.jvm.PlatformType", "", "database", "Lapp/termora/database/DatabaseManager;", "getDatabase", "()Lapp/termora/database/DatabaseManager;", "createPtyConnector", "rows", "", "cols", "env", "", "", "charset", "Ljava/nio/charset/Charset;", "commands", "", "directory", "([Ljava/lang/String;IILjava/util/Map;Ljava/lang/String;Ljava/nio/charset/Charset;)Lapp/termora/terminal/PtyConnector;", "decorate", "ptyConnector", "Companion", "AutoRemovePtyConnector", "termora"})
@SourceDebugExtension(value={"SMAP\nPtyConnectorFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PtyConnectorFactory.kt\napp/termora/PtyConnectorFactory\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,105:1\n37#2,2:106\n*S KotlinDebug\n*F\n+ 1 PtyConnectorFactory.kt\napp/termora/PtyConnectorFactory\n*L\n39#1:106,2\n*E\n"})
public final class PtyConnectorFactory
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final List<PtyConnector> ptyConnectors = Collections.synchronizedList(new ArrayList());
    private static final Logger log = LoggerFactory.getLogger(PtyConnectorFactory.class);

    private final DatabaseManager getDatabase() {
        return DatabaseManager.Companion.getInstance();
    }

    @NotNull
    public final PtyConnector createPtyConnector(int rows, int cols, @NotNull Map<String, String> env, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String command = this.getDatabase().getTerminal().getLocalShell();
        Object[] objectArray = new String[]{command};
        List commands = CollectionsKt.mutableListOf((Object[])objectArray);
        if (SystemUtils.IS_OS_UNIX) {
            commands.add("-l");
        }
        Collection $this$toTypedArray$iv = commands;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return PtyConnectorFactory.createPtyConnector$default(this, thisCollection$iv.toArray(new String[0]), rows, cols, env, null, charset, 16, null);
    }

    public static /* synthetic */ PtyConnector createPtyConnector$default(PtyConnectorFactory ptyConnectorFactory, int n, int n2, Map map, Charset charset, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 24;
        }
        if ((n3 & 2) != 0) {
            n2 = 80;
        }
        if ((n3 & 4) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n3 & 8) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        return ptyConnectorFactory.createPtyConnector(n, n2, map, charset);
    }

    @NotNull
    public final PtyConnector createPtyConnector(@NotNull String[] commands, int rows, int cols, @NotNull Map<String, String> env, @NotNull String directory, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)commands, (String)"commands");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        Map envs = new LinkedHashMap();
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv(...)");
        envs.putAll(map);
        envs.put("TERM", "xterm-256color");
        envs.putAll(env);
        if (SystemUtils.IS_OS_UNIX && !envs.containsKey("LANG")) {
            Locale locale = Locale.getDefault();
            CharSequence[] charSequenceArray = new CharSequence[]{locale.getLanguage(), locale.getCountry()};
            if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
                envs.put("LANG", locale.getLanguage() + "_" + locale.getCountry() + "." + Charset.defaultCharset().name());
            } else {
                envs.put("LANG", "en_US.UTF-8");
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("command: {} , envs: {}", (Object)ArraysKt.joinToString$default((Object[])commands, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (Object)envs);
        }
        PtyProcess ptyProcess = new PtyProcessBuilder(commands).setEnvironment(envs).setInitialRows(Integer.valueOf(rows)).setInitialColumns(Integer.valueOf(cols)).setConsole(false).setDirectory((String)StringUtils.defaultIfBlank((CharSequence)directory, (CharSequence)SystemUtils.USER_HOME)).setCygwin(false).setUseWinConPty(SystemUtils.IS_OS_WINDOWS).setRedirectErrorStream(false).setWindowsAnsiColorEnabled(false).setUnixOpenTtyToPreserveOutputAfterTermination(false).setSpawnProcessUsingJdkOnMacIntel(true).start();
        Intrinsics.checkNotNullExpressionValue((Object)ptyProcess, (String)"start(...)");
        PtyProcess ptyProcess2 = ptyProcess;
        return this.decorate(new PtyProcessConnector(ptyProcess2, charset));
    }

    public static /* synthetic */ PtyConnector createPtyConnector$default(PtyConnectorFactory ptyConnectorFactory, String[] stringArray, int n, int n2, Map map, String string, Charset charset, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 24;
        }
        if ((n3 & 4) != 0) {
            n2 = 80;
        }
        if ((n3 & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n3 & 0x10) != 0) {
            String string2 = SystemUtils.USER_HOME;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"USER_HOME");
            string = string2;
        }
        if ((n3 & 0x20) != 0) {
            Charset charset2 = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        return ptyConnectorFactory.createPtyConnector(stringArray, n, n2, map, string, charset);
    }

    @NotNull
    public final PtyConnector decorate(@NotNull PtyConnector ptyConnector) {
        Intrinsics.checkNotNullParameter((Object)ptyConnector, (String)"ptyConnector");
        MacroPtyConnector macroPtyConnector = new MacroPtyConnector(ptyConnector);
        AutoRemovePtyConnector autoRemovePtyConnector = new AutoRemovePtyConnector(macroPtyConnector);
        this.ptyConnectors.add(autoRemovePtyConnector);
        return autoRemovePtyConnector;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lapp/termora/PtyConnectorFactory$AutoRemovePtyConnector;", "Lapp/termora/terminal/PtyConnectorDelegate;", "connector", "Lapp/termora/terminal/PtyConnector;", "<init>", "(Lapp/termora/PtyConnectorFactory;Lapp/termora/terminal/PtyConnector;)V", "close", "", "termora"})
    private final class AutoRemovePtyConnector
    extends PtyConnectorDelegate {
        public AutoRemovePtyConnector(PtyConnector connector) {
            Intrinsics.checkNotNullParameter((Object)connector, (String)"connector");
            super(connector);
        }

        @Override
        public void close() {
            PtyConnectorFactory.this.ptyConnectors.remove(this);
            super.close();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/PtyConnectorFactory$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/PtyConnectorFactory;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PtyConnectorFactory getInstance() {
            return (PtyConnectorFactory)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(PtyConnectorFactory.class), Companion::getInstance$lambda$0);
        }

        private static final PtyConnectorFactory getInstance$lambda$0() {
            return new PtyConnectorFactory();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

