/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Disposable;
import app.termora.ObjectTree;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectNode {
    private final ObjectTree myTree;
    ObjectNode myParent;
    private final Disposable myObject;
    private List<ObjectNode> myChildren;
    private Throwable myTrace;

    ObjectNode(@NotNull ObjectTree tree, @Nullable ObjectNode parentNode, @NotNull Disposable object) {
        this.myTree = tree;
        this.myParent = parentNode;
        this.myObject = object;
    }

    void addChild(@NotNull ObjectNode child) {
        List<ObjectNode> children = this.myChildren;
        if (children == null) {
            this.myChildren = new ArrayList<ObjectNode>();
            this.myChildren.add(child);
        } else {
            children.add(child);
        }
        child.myParent = this;
    }

    void removeChild(@NotNull ObjectNode child) {
        List<ObjectNode> children = this.myChildren;
        if (children != null) {
            for (int i = children.size() - 1; i >= 0; --i) {
                ObjectNode node2 = children.get(i);
                if (!node2.equals(child)) continue;
                children.remove(i);
                break;
            }
        }
        child.myParent = null;
    }

    ObjectNode getParent() {
        return this.myParent;
    }

    void getAndRemoveRecursively(@NotNull List<? super Disposable> result2) {
        this.getAndRemoveChildrenRecursively(result2, null);
        this.myTree.removeObjectFromTree(this);
        if (this.myTree.rememberDisposedTrace(this.myObject) == null) {
            result2.add(this.myObject);
        }
        this.myChildren = null;
        this.myParent = null;
    }

    void getAndRemoveChildrenRecursively(@NotNull List<? super Disposable> result2, @Nullable Predicate<? super Disposable> predicate) {
        if (this.myChildren != null) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                ObjectNode childNode = this.myChildren.get(i);
                if (predicate != null && !predicate.test(childNode.getObject())) continue;
                childNode.getAndRemoveRecursively(result2);
            }
        }
    }

    @NotNull
    Disposable getObject() {
        return this.myObject;
    }

    @NonNls
    public String toString() {
        return "Node: " + String.valueOf(this.myObject);
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void clearTrace() {
        this.myTrace = null;
    }

    @TestOnly
    void assertNoReferencesKept(@NotNull Disposable aDisposable) {
        assert (this.getObject() != aDisposable);
        if (this.myChildren != null) {
            for (ObjectNode node2 : this.myChildren) {
                node2.assertNoReferencesKept(aDisposable);
            }
        }
    }

    <D extends Disposable> D findChildEqualTo(@NotNull D object) {
        List<ObjectNode> children = this.myChildren;
        if (children != null) {
            for (ObjectNode node2 : children) {
                Disposable nodeObject = node2.getObject();
                if (!nodeObject.equals(object)) continue;
                return (D)nodeObject;
            }
        }
        return null;
    }
}

