/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0005J\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lapp/termora/Ed25519;", "", "<init>", "()V", "sign", "", "privateKey", "Ljava/security/PrivateKey;", "data", "verify", "", "publicKey", "Ljava/security/PublicKey;", "signature", "input", "Ljava/io/InputStream;", "generatePublic", "generatePrivate", "generateKeyPair", "Ljava/security/KeyPair;", "termora"})
@SourceDebugExtension(value={"SMAP\nCrypto.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Crypto.kt\napp/termora/Ed25519\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
public final class Ed25519 {
    @NotNull
    public static final Ed25519 INSTANCE = new Ed25519();

    private Ed25519() {
    }

    @NotNull
    public final byte[] sign(@NotNull PrivateKey privateKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Signature signer = Signature.getInstance("Ed25519");
        signer.initSign(privateKey);
        signer.update(data);
        byte[] byArray = signer.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }

    public final boolean verify(@NotNull PublicKey publicKey, @NotNull byte[] data, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return this.verify(publicKey, new ByteArrayInputStream(data), signature);
    }

    public final boolean verify(@NotNull PublicKey publicKey, @NotNull InputStream input2, @NotNull byte[] signature) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Object object2 = this;
        try {
            Ed25519 $this$verify_u24lambda_u240 = object2;
            boolean bl = false;
            Signature verifier = Signature.getInstance("Ed25519");
            verifier.initVerify(publicKey);
            byte[] buffer = new byte[1024];
            int len = 0;
            while (true) {
                int n;
                int it = n = input2.read(buffer);
                boolean bl2 = false;
                len = it;
                if (n == -1) break;
                verifier.update(buffer, 0, len);
            }
            object = Result.constructor-impl((Object)verifier.verify(signature));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Boolean bl = (Boolean)(Result.isFailure-impl((Object)object2) ? null : object2);
        return bl != null ? bl : false;
    }

    @NotNull
    public final PublicKey generatePublic(@NotNull byte[] publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        PublicKey publicKey2 = KeyFactory.getInstance("Ed25519").generatePublic(new X509EncodedKeySpec(publicKey));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generatePublic(...)");
        return publicKey2;
    }

    @NotNull
    public final PrivateKey generatePrivate(@NotNull byte[] privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        PrivateKey privateKey2 = KeyFactory.getInstance("Ed25519").generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"generatePrivate(...)");
        return privateKey2;
    }

    @NotNull
    public final KeyPair generateKeyPair() {
        KeyPairGenerator generator2 = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = generator2.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }
}

