/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.AppLayout;
import app.termora.ScopeKt;
import com.formdev.flatlaf.util.SystemInfo;
import com.jthemedetecor.util.OsInfo;
import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Date;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonKt;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0011J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0011J\u0006\u0010!\u001a\u00020\u0011J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u001bJ\u0010\u0010'\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u000e\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lapp/termora/Application;", "", "<init>", "()V", "baseDataDir", "Ljava/io/File;", "ohMyJson", "Lkotlinx/serialization/json/Json;", "getOhMyJson", "()Lkotlinx/serialization/json/Json;", "httpClient", "Lokhttp3/OkHttpClient;", "getHttpClient", "()Lokhttp3/OkHttpClient;", "httpClient$delegate", "Lkotlin/Lazy;", "getDefaultShell", "", "getTemporaryDir", "createSubTemporaryDir", "Ljava/nio/file/Path;", "prefix", "getBaseDataDir", "getVersion", "getLayout", "Lapp/termora/AppLayout;", "isUnknownVersion", "", "getUserAgent", "isBetaVersion", "getReleaseDate", "Ljava/util/Date;", "getAppPath", "getName", "browse", "", "uri", "Ljava/net/URI;", "async", "tryBrowse", "browseInFolder", "file", "termora"})
@SourceDebugExtension(value={"SMAP\nApplication.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Application.kt\napp/termora/Application\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,320:1\n1#2:321\n*E\n"})
public final class Application {
    @NotNull
    public static final Application INSTANCE = new Application();
    private static File baseDataDir;
    @NotNull
    private static final Json ohMyJson;
    @NotNull
    private static final Lazy httpClient$delegate;

    private Application() {
    }

    @NotNull
    public final Json getOhMyJson() {
        return ohMyJson;
    }

    @NotNull
    public final OkHttpClient getHttpClient() {
        Lazy lazy = httpClient$delegate;
        return (OkHttpClient)lazy.getValue();
    }

    @NotNull
    public final String getDefaultShell() {
        if (SystemInfo.isWindows) {
            return "cmd.exe";
        }
        String shell = System.getenv("SHELL");
        if (shell != null && !StringsKt.isBlank((CharSequence)shell)) {
            return shell;
        }
        return "/bin/bash";
    }

    @NotNull
    public final File getTemporaryDir() {
        File temporaryDir = new File(this.getBaseDataDir(), "temporary");
        FileUtils.forceMkdir((File)temporaryDir);
        return temporaryDir;
    }

    @NotNull
    public final Path createSubTemporaryDir(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Path path = Files.createTempDirectory(this.getTemporaryDir().toPath(), prefix, new FileAttribute[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(...)");
        return path;
    }

    public static /* synthetic */ Path createSubTemporaryDir$default(Application application, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = application.getName();
        }
        return application.createSubTemporaryDir(string);
    }

    @NotNull
    public final File getBaseDataDir() {
        File file;
        File dataFile;
        File file2;
        String appPath;
        if (baseDataDir != null) {
            File file3 = baseDataDir;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"baseDataDir");
                file3 = null;
            }
            return file3;
        }
        String string = (this.getName() + ".base-data-dir").toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String baseDataDir = System.getProperty(string);
        if (StringUtils.isBlank((CharSequence)baseDataDir)) {
            String string2 = (this.getName() + "_BASE_DATA_DIR").toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            baseDataDir = System.getenv(string2);
        }
        if (SystemInfo.isWindows && this.getLayout() == AppLayout.Zip && StringUtils.isBlank((CharSequence)baseDataDir) && StringUtils.isNotBlank((CharSequence)(appPath = this.getAppPath())) && (file2 = new File(appPath).getParentFile()).exists() && (dataFile = new File(file2, "data")).exists()) {
            baseDataDir = dataFile.getAbsolutePath();
        }
        if (StringUtils.isNotBlank((CharSequence)baseDataDir)) {
            file = new File(baseDataDir);
        } else {
            File file4 = SystemUtils.getUserHome();
            String string3 = ("." + this.getName()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            file = new File(file4, string3);
        }
        File dir = file;
        FileUtils.forceMkdir((File)dir);
        Application.baseDataDir = dir;
        return dir;
    }

    @NotNull
    public final String getVersion() {
        String version = System.getProperty("app-version");
        CharSequence charSequence = version;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            version = System.getProperty("jpackage.app-version");
        }
        if ((charSequence = (CharSequence)version) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            File versionFile;
            if (StringsKt.isBlank((CharSequence)this.getAppPath()) && (versionFile = new File("VERSION")).exists() && versionFile.isFile()) {
                version = ((Object)StringsKt.trim((CharSequence)FilesKt.readText$default((File)versionFile, null, (int)1, null))).toString();
            }
            if ((charSequence = (CharSequence)version) == null || StringsKt.isBlank((CharSequence)charSequence)) {
                version = "unknown";
            }
        }
        return version;
    }

    @NotNull
    public final AppLayout getLayout() {
        if (SystemInfo.isMacOS) {
            return AppLayout.App;
        }
        String layout = System.getProperty("jpackage.app-layout");
        if (SystemInfo.isLinux) {
            if (Intrinsics.areEqual((Object)"deb", (Object)layout)) {
                return AppLayout.Deb;
            }
            if (Intrinsics.areEqual((Object)"tar.gz", (Object)layout)) {
                return AppLayout.TarGz;
            }
        }
        if (SystemInfo.isWindows) {
            if (Intrinsics.areEqual((Object)"exe", (Object)layout)) {
                return AppLayout.Exe;
            }
            if (Intrinsics.areEqual((Object)"zip", (Object)layout)) {
                return AppLayout.Zip;
            }
            if (Intrinsics.areEqual((Object)"appx", (Object)layout)) {
                return AppLayout.Appx;
            }
        }
        return SystemInfo.isWindows ? AppLayout.Exe : AppLayout.AppImage;
    }

    public final boolean isUnknownVersion() {
        return StringsKt.contains$default((CharSequence)this.getVersion(), (CharSequence)"unknown", (boolean)false, (int)2, null);
    }

    @NotNull
    public final String getUserAgent() {
        return this.getName() + "/" + this.getVersion() + "(" + Locale.getDefault() + "); " + SystemUtils.OS_NAME + "/" + SystemUtils.OS_VERSION + "(" + SystemUtils.OS_ARCH + "); " + SystemUtils.JAVA_VM_NAME + "/" + SystemUtils.JAVA_VERSION;
    }

    public final boolean isBetaVersion() {
        return StringsKt.contains$default((CharSequence)this.getVersion(), (CharSequence)"beta", (boolean)false, (int)2, null);
    }

    @NotNull
    public final Date getReleaseDate() {
        Object object;
        String releaseDate = System.getProperty("release-date");
        CharSequence charSequence = releaseDate;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return new Date();
        }
        Object object2 = this;
        try {
            Application $this$getReleaseDate_u24lambda_u240 = object2;
            boolean bl = false;
            String[] stringArray = new String[]{"yyyy-MM-dd"};
            object = Result.constructor-impl((Object)DateUtils.parseDate((String)releaseDate, (String[])stringArray));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        Date date = (Date)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    @NotNull
    public final String getAppPath() {
        String string = StringUtils.defaultString((String)System.getProperty("jpackage.app-path"));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultString(...)");
        return string;
    }

    @NotNull
    public final String getName() {
        return "Termora";
    }

    public final void browse(@NotNull URI uri, boolean async) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (SystemInfo.isWindows && Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
            if (async) {
                BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, null){
                    int label;
                    final /* synthetic */ URI $uri;
                    {
                        this.$uri = $uri;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Application.access$tryBrowse(Application.INSTANCE, this.$uri);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            } else {
                this.tryBrowse(uri);
            }
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(uri);
        } else if (async) {
            BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, null){
                int label;
                final /* synthetic */ URI $uri;
                {
                    this.$uri = $uri;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Application.access$tryBrowse(Application.INSTANCE, this.$uri);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        } else {
            this.tryBrowse(uri);
        }
    }

    public static /* synthetic */ void browse$default(Application application, URI uRI, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        application.browse(uRI, bl);
    }

    private final void tryBrowse(URI uri) {
        if (SystemInfo.isWindows) {
            String[] stringArray = new String[]{"explorer", uri.toString()};
            new ProcessBuilder(stringArray).start();
        } else if (SystemInfo.isMacOS) {
            String[] stringArray = new String[]{"open", uri.toString()};
            new ProcessBuilder(stringArray).start();
        } else if (SystemInfo.isLinux && OsInfo.isGnome()) {
            String[] stringArray = new String[]{"xdg-open", uri.toString()};
            new ProcessBuilder(stringArray).start();
        }
    }

    public final void browseInFolder(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (SystemInfo.isWindows) {
            String[] stringArray = new String[]{"explorer", "/select," + file.getAbsolutePath()};
            new ProcessBuilder(stringArray).start();
        } else if (SystemInfo.isMacOS) {
            String[] stringArray = new String[]{"open", "-R", file.getAbsolutePath()};
            new ProcessBuilder(stringArray).start();
        } else if (Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
            Desktop.getDesktop().browseFileDirectory(file);
        }
    }

    private static final Unit ohMyJson$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setIgnoreUnknownKeys(true);
        $this$Json.setEncodeDefaults(false);
        return Unit.INSTANCE;
    }

    private static final OkHttpClient httpClient_delegate$lambda$0() {
        OkHttpClient.Builder builder2 = new OkHttpClient.Builder();
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder3 = builder2.connectTimeout(duration);
        Duration duration2 = Duration.ofSeconds(60L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder4 = builder3.callTimeout(duration2);
        Duration duration3 = Duration.ofSeconds(60L);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofSeconds(...)");
        OkHttpClient.Builder builder5 = builder4.writeTimeout(duration3);
        Duration duration4 = Duration.ofSeconds(60L);
        Intrinsics.checkNotNullExpressionValue((Object)duration4, (String)"ofSeconds(...)");
        return builder5.readTimeout(duration4).addInterceptor((Interceptor)new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){
            private final Logger log;
            {
                this.log = LoggerFactory.getLogger(HttpLoggingInterceptor.class);
            }

            public void log(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (this.log.isDebugEnabled()) {
                    this.log.debug(message);
                }
            }
        }).setLevel(HttpLoggingInterceptor.Level.BASIC)).build();
    }

    public static final /* synthetic */ void access$tryBrowse(Application $this, URI uri) {
        $this.tryBrowse(uri);
    }

    static {
        ohMyJson = JsonKt.Json$default(null, Application::ohMyJson$lambda$0, (int)1, null);
        httpClient$delegate = LazyKt.lazy(Application::httpClient_delegate$lambda$0);
    }
}

