/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012\"\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0015H$J\b\u0010\u0016\u001a\u00020\u0005H$R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lapp/termora/AbstractI18n;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "substitutor", "Lorg/apache/commons/text/StringSubstitutor;", "getSubstitutor", "()Lorg/apache/commons/text/StringSubstitutor;", "substitutor$delegate", "Lkotlin/Lazy;", "getString", "", "key", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getBundle", "Ljava/util/ResourceBundle;", "getLogger", "termora"})
public abstract class AbstractI18n {
    @NotNull
    private final Lazy substitutor$delegate = LazyKt.lazy(() -> AbstractI18n.substitutor_delegate$lambda$0(this));

    private final Logger getLog() {
        return this.getLogger();
    }

    @NotNull
    protected final StringSubstitutor getSubstitutor() {
        Lazy lazy = this.substitutor$delegate;
        return (StringSubstitutor)lazy.getValue();
    }

    @NotNull
    public String getString(@NotNull String key, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String text = this.getString(key);
        if (!(args.length == 0)) {
            String string = MessageFormat.format(text, Arrays.copyOf(args, args.length));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }
        return text;
    }

    @NotNull
    public String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            String string = this.getSubstitutor().replace(this.getBundle().getString(key));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
            return string;
        }
        catch (MissingResourceException e) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn(e.getMessage(), (Throwable)e);
            }
            return key;
        }
    }

    @NotNull
    protected abstract ResourceBundle getBundle();

    @NotNull
    protected abstract Logger getLogger();

    private static final StringSubstitutor substitutor_delegate$lambda$0(AbstractI18n this$0) {
        return new StringSubstitutor(arg_0 -> AbstractI18n.substitutor_delegate$lambda$0$0(this$0, arg_0));
    }

    private static final String substitutor_delegate$lambda$0$0(AbstractI18n this$0, String key) {
        Intrinsics.checkNotNull((Object)key);
        return this$0.getString(key);
    }
}

