/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.vendors;

import java.util.List;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.Index;
import org.jetbrains.exposed.v1.core.SQLLogKt;
import org.jetbrains.exposed.v1.core.Schema;
import org.jetbrains.exposed.v1.core.Version;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.v1.core.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.VendorDialect;
import org.jetbrains.exposed.v1.exceptions.UnsupportedByDialectException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 52\u00020\u0001:\u00015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\u0014\u0010$\u001a\u00020\u00052\n\u0010%\u001a\u0006\u0012\u0002\b\u00030&H\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005H\u0016J\u0010\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020\f2\u0006\u00100\u001a\u000201H\u0016J\u0018\u00103\u001a\u00020\f2\u0006\u00100\u001a\u0002012\u0006\u00104\u001a\u00020\u0005H\u0016R!\u0010\u0004\u001a\u00020\u00058@X\u0080\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\t\u0010\n\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\u00020\f8@X\u0080\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\n\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0014\u0010\u0015\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR\u0014\u0010\u0019\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR\u001c\u0010\u001b\u001a\u00020\u00058\u0016X\u0097D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\bR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00066"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/v1/core/vendors/VendorDialect;", "<init>", "()V", "isMysql8", "", "isMysql8$exposed_core$annotations", "isMysql8$exposed_core", "()Z", "isMysql8$delegate", "Lkotlin/Lazy;", "fullVersion", "", "getFullVersion$exposed_core$annotations", "getFullVersion$exposed_core", "()Ljava/lang/String;", "fullVersion$delegate", "supportsCreateSequence", "getSupportsCreateSequence", "supportsTernaryAffectedRowValues", "getSupportsTernaryAffectedRowValues", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "supportsOrderByNullsFirstLast", "getSupportsOrderByNullsFirstLast", "supportsSetDefaultReferenceOption", "getSupportsSetDefaultReferenceOption", "supportsSelectForUpdate", "getSupportsSelectForUpdate$annotations", "getSupportsSelectForUpdate", "isFractionDateTimeSupported", "isTimeZoneOffsetSupported", "notAcceptableDefaults", "", "getNotAcceptableDefaults", "()Ljava/util/List;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/v1/core/Expression;", "createIndex", "index", "Lorg/jetbrains/exposed/v1/core/Index;", "dropIndex", "tableName", "indexName", "isUnique", "isPartialOrFunctional", "setSchema", "schema", "Lorg/jetbrains/exposed/v1/core/Schema;", "createSchema", "dropSchema", "cascade", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy(MysqlDialect::isMysql8_delegate$lambda$0);
    @NotNull
    private final Lazy fullVersion$delegate = LazyKt.lazy(MysqlDialect::fullVersion_delegate$lambda$1);
    private final boolean supportsCreateSequence;
    private final boolean supportsTernaryAffectedRowValues;
    private final boolean supportsSubqueryUnions;
    private final boolean supportsOrderByNullsFirstLast;
    private final boolean supportsSetDefaultReferenceOption;
    private final boolean supportsSelectForUpdate;
    @NotNull
    private final List<String> notAcceptableDefaults;

    public MysqlDialect() {
        super(Companion.getDialectName(), MysqlDataTypeProvider.Companion.getINSTANCE$exposed_core(), MysqlFunctionProvider.Companion.getINSTANCE$exposed_core());
        this.supportsTernaryAffectedRowValues = true;
        this.supportsSubqueryUnions = true;
        this.supportsSelectForUpdate = true;
        Object[] objectArray = new String[]{"CURRENT_DATE()", "CURRENT_DATE"};
        this.notAcceptableDefaults = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        return (Boolean)lazy.getValue();
    }

    public static /* synthetic */ void isMysql8$exposed_core$annotations() {
    }

    @NotNull
    public final String getFullVersion$exposed_core() {
        Lazy lazy = this.fullVersion$delegate;
        return (String)lazy.getValue();
    }

    public static /* synthetic */ void getFullVersion$exposed_core$annotations() {
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsTernaryAffectedRowValues() {
        return this.supportsTernaryAffectedRowValues;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    @Override
    public boolean getSupportsOrderByNullsFirstLast() {
        return this.supportsOrderByNullsFirstLast;
    }

    @Override
    public boolean getSupportsSetDefaultReferenceOption() {
        return this.supportsSetDefaultReferenceOption;
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        return this.supportsSelectForUpdate;
    }

    @Deprecated(message="The parameter was moved to JdbcExposedDatabaseMetadata/R2dbcExposedDatabaseMetadata classes", replaceWith=@ReplaceWith(expression="TransactionManager.current().db.supportsSelectForUpdate", imports={}))
    public static /* synthetic */ void getSupportsSelectForUpdate$annotations() {
    }

    public boolean isFractionDateTimeSupported() {
        return Version.covers$default(CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion(), 5, 6, 0, 4, null);
    }

    public boolean isTimeZoneOffsetSupported() {
        return this.isMysql8$exposed_core();
    }

    @NotNull
    protected final List<String> getNotAcceptableDefaults() {
        return this.notAcceptableDefaults;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        if (this.getFullVersion$exposed_core().compareTo("8.0.13") >= 0) {
            return true;
        }
        return !this.notAcceptableDefaults.contains(((Object)StringsKt.trim((CharSequence)e.toString())).toString());
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        if (index.getFunctions() != null && !this.isMysql8$exposed_core()) {
            SQLLogKt.getExposedLogger().warn("Functional index on " + index.getTable().getTableName() + " using " + CollectionsKt.joinToString$default((Iterable)index.getFunctions(), null, null, null, (int)0, null, MysqlDialect::createIndex$lambda$2, (int)31, null) + " can't be created in MySQL prior to 8.0");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName, boolean isUnique, boolean isPartialOrFunctional) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        return "ALTER TABLE " + this.getIdentifierManager().quoteIfNecessary(tableName) + " DROP INDEX " + this.getIdentifierManager().cutIfNecessaryAndQuote(indexName);
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "USE " + schema.getIdentifier();
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        StringBuilder $this$createSchema_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append((StringBuilder)$this$createSchema_u24lambda_u243, (String[])stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(DatabaseDialectKt.getCurrentDialect().getName() + " do not have database owners. You can use GRANT to allow or deny rights on database.", DatabaseDialectKt.getCurrentDialect());
        }
        return stringBuilder.toString();
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return "DROP SCHEMA IF EXISTS " + schema.getIdentifier();
    }

    private static final boolean isMysql8_delegate$lambda$0() {
        return CoreTransactionManager.INSTANCE.currentTransaction().getDb().getVersion().covers("8.0");
    }

    private static final String fullVersion_delegate$lambda$1() {
        return CoreTransactionManager.INSTANCE.currentTransaction().getDb().getFullVersion();
    }

    private static final CharSequence createIndex$lambda$2(ExpressionWithColumnType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MysqlDialect$Companion;", "Lorg/jetbrains/exposed/v1/core/vendors/VendorDialect$DialectNameProvider;", "<init>", "()V", "exposed-core"})
    public static final class Companion
    extends VendorDialect.DialectNameProvider {
        private Companion() {
            super("MySQL");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

