/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.vendors;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.Function;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.LiteralOp;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.MariaDBDialect;
import org.jetbrains.exposed.v1.core.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.v1.exceptions.UnsupportedByDialectException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0014\u0010\u0007\u001a\u00020\u00052\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MariaDBDataTypeProvider;", "Lorg/jetbrains/exposed/v1/core/vendors/MysqlDataTypeProvider;", "<init>", "()V", "timestampType", "", "timestampWithTimeZoneType", "processForDefaultValue", "e", "Lorg/jetbrains/exposed/v1/core/Expression;", "exposed-core"})
public final class MariaDBDataTypeProvider
extends MysqlDataTypeProvider {
    @NotNull
    public static final MariaDBDataTypeProvider INSTANCE = new MariaDBDataTypeProvider();

    private MariaDBDataTypeProvider() {
    }

    @Override
    @NotNull
    public String timestampType() {
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        MariaDBDialect mariaDBDialect = databaseDialect instanceof MariaDBDialect ? (MariaDBDialect)databaseDialect : null;
        return (mariaDBDialect != null ? mariaDBDialect.isFractionDateTimeSupported() : false) ? "TIMESTAMP(6)" : "TIMESTAMP";
    }

    @Override
    @NotNull
    public String timestampWithTimeZoneType() {
        throw new UnsupportedByDialectException("This vendor does not support timestamp with time zone data type", DatabaseDialectKt.getCurrentDialect());
    }

    @Override
    @NotNull
    public String processForDefaultValue(@NotNull Expression<?> e) {
        String string;
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (e instanceof LiteralOp) {
            IColumnType iColumnType = ((LiteralOp)e).getColumnType();
            Intrinsics.checkNotNull(iColumnType, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.IColumnType<kotlin.Any?>");
            string = iColumnType.valueAsDefaultString(((LiteralOp)e).getValue());
        } else {
            string = e instanceof Function || DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect ? String.valueOf(e) : "" + '(' + e + ')';
        }
        return string;
    }
}

