/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ColumnSet;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionKt;
import org.jetbrains.exposed.v1.core.Index;
import org.jetbrains.exposed.v1.core.Join;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.QueryBuilder;
import org.jetbrains.exposed.v1.core.Sequence;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.StatementType;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.FunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.H2Kt;
import org.jetbrains.exposed.v1.exceptions.ExceptionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J=\u0010\u000e\u001a\u00020\t\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0016J:\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016JW\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$2\u001e\u0010%\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001e\u0012\u0006\u0012\u0004\u0018\u00010'0&0\u001d2\b\u0010(\u001a\u0004\u0018\u00010\u00132\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010*2\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010+J,\u0010,\u001a\u00020\t*\u00020\r2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u0002002\u0006\u0010 \u001a\u00020!H\u0002JM\u00101\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001d2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010*2\b\u0010(\u001a\u0004\u0018\u00010\u00132\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u00103J2\u00104\u001a\u00020\t\"\n\b\u0000\u0010\u000f*\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u00105\u001a\u00020\u0018H\u0016J*\u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020\u00052\b\u00108\u001a\u0004\u0018\u00010\u00182\u0006\u00109\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0016J$\u0010:\u001a\u00020\t\"\u0004\b\u0000\u0010\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0015\u001a\u00020\rH\u0016J$\u0010;\u001a\u00020\t\"\u0004\b\u0000\u0010\u000f2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006<"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/H2FunctionProvider;", "Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "<init>", "()V", "isH2Oracle", "", "Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect;", "(Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect;)Z", "nextVal", "", "seq", "Lorg/jetbrains/exposed/v1/core/Sequence;", "builder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "arraySlice", "T", "expression", "Lorg/jetbrains/exposed/v1/core/Expression;", "lower", "", "upper", "queryBuilder", "(Lorg/jetbrains/exposed/v1/core/Expression;Ljava/lang/Integer;Ljava/lang/Integer;Lorg/jetbrains/exposed/v1/core/QueryBuilder;)V", "insert", "", "ignore", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "columns", "", "Lorg/jetbrains/exposed/v1/core/Column;", "expr", "transaction", "Lorg/jetbrains/exposed/v1/core/Transaction;", "update", "targets", "Lorg/jetbrains/exposed/v1/core/Join;", "columnsAndValues", "Lkotlin/Pair;", "", "limit", "where", "Lorg/jetbrains/exposed/v1/core/Op;", "(Lorg/jetbrains/exposed/v1/core/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/v1/core/Op;Lorg/jetbrains/exposed/v1/core/Transaction;)Ljava/lang/String;", "appendMergeIntoUsingJoinClause", "target", "join", "joinPart", "Lorg/jetbrains/exposed/v1/core/Join$JoinPart;", "delete", "targetTables", "(ZLorg/jetbrains/exposed/v1/core/Join;Ljava/util/List;Lorg/jetbrains/exposed/v1/core/Op;Ljava/lang/Integer;Lorg/jetbrains/exposed/v1/core/Transaction;)Ljava/lang/String;", "locate", "substring", "explain", "analyze", "options", "internalStatement", "date", "time", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nH2.kt\nKotlin\n*S Kotlin\n*F\n+ 1 H2.kt\norg/jetbrains/exposed/v1/core/vendors/H2FunctionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n774#2:458\n865#2,2:459\n1460#2,5:461\n1563#2:466\n1634#2,3:467\n1#3:470\n*S KotlinDebug\n*F\n+ 1 H2.kt\norg/jetbrains/exposed/v1/core/vendors/H2FunctionProvider\n*L\n55#1:458\n55#1:459,2\n55#1:461,5\n89#1:466\n89#1:467,3\n*E\n"})
public final class H2FunctionProvider
extends FunctionProvider {
    @NotNull
    public static final H2FunctionProvider INSTANCE = new H2FunctionProvider();

    private H2FunctionProvider() {
    }

    private final boolean isH2Oracle(DatabaseDialect $this$isH2Oracle) {
        return H2Kt.getH2Mode($this$isH2Oracle) == H2Dialect.H2CompatibilityMode.Oracle;
    }

    @Override
    public void nextVal(@NotNull Sequence seq, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DatabaseDialect databaseDialect = CoreTransactionManager.INSTANCE.currentTransaction().getDb().getDialect();
        Intrinsics.checkNotNull((Object)databaseDialect, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.vendors.H2Dialect");
        if (WhenMappings.$EnumSwitchMapping$0[((H2Dialect)databaseDialect).getMajorVersion().ordinal()] != 1) {
            throw new IllegalStateException("Unsupported H2 version".toString());
        }
        builder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> H2FunctionProvider.nextVal$lambda$0(seq, arg_0)));
    }

    @Override
    public <T> void arraySlice(@NotNull Expression<T> expression, @Nullable Integer lower, @Nullable Integer upper, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> H2FunctionProvider.arraySlice$lambda$1(expression, lower, upper, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns, @NotNull String expr, @NotNull Transaction transaction) {
        String string;
        void $this$flatMapTo$iv;
        Iterator $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Set uniqueCols = new LinkedHashSet();
        Iterable $this$filter$iv = table.getIndices();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            Index it = (Index)element$iv$iv;
            boolean bl = false;
            if (!it.getUnique()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Index it = (Index)element$iv;
            boolean bl = false;
            Iterable list$iv = it.getColumns();
            CollectionsKt.addAll((Collection)uniqueCols, (Iterable)list$iv);
        }
        Object[] objectArray = table.getPrimaryKey();
        if (objectArray != null && (objectArray = objectArray.getColumns()) != null) {
            Object[] primaryKeys = objectArray;
            boolean bl = false;
            CollectionsKt.addAll((Collection)uniqueCols, (Object[])primaryKeys);
        }
        DatabaseDialect databaseDialect = transaction.getDb().getDialect();
        Intrinsics.checkNotNull((Object)databaseDialect, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.vendors.H2Dialect");
        H2Dialect h2Dialect = (H2Dialect)databaseDialect;
        String version = h2Dialect.getVersion$exposed_core();
        boolean isMySQLMode = h2Dialect.getH2Mode() == H2Dialect.H2CompatibilityMode.MySQL;
        if (ignore && !((Collection)uniqueCols).isEmpty() && isMySQLMode && version.compareTo("1.4.197") < 0) {
            String def = super.insert(false, table, columns, expr, transaction);
            string = def + " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default((Iterable)uniqueCols, null, null, null, (int)0, null, arg_0 -> H2FunctionProvider.insert$lambda$5(transaction, arg_0), (int)31, null);
        } else if (ignore && !((Collection)uniqueCols).isEmpty() && isMySQLMode) {
            string = StringsKt.replace$default((String)super.insert(false, table, columns, expr, transaction), (String)"INSERT", (String)"INSERT IGNORE", (boolean)false, (int)4, null);
        } else {
            if (ignore) {
                ExceptionsKt.throwUnsupportedException(transaction, "INSERT IGNORE supported only on H2 v1.4.197+ with MODE=MYSQL.");
                throw new KotlinNothingValueException();
            }
            string = super.insert(false, table, columns, expr, transaction);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction) {
        QueryBuilder $this$update_u24lambda_u249;
        block5: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
            Intrinsics.checkNotNullParameter(columnsAndValues, (String)"columnsAndValues");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            $this$update_u24lambda_u249 = new QueryBuilder(true);
            boolean bl = false;
            if (limit != null) {
                ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support LIMIT in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            if (where != null && !INSTANCE.isH2Oracle(transaction.getDb().getDialect())) {
                ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support WHERE in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            Iterable $this$map$iv = columnsAndValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Column)it.getFirst()).getTable());
            }
            Table table = (Table)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
            if (table == null) {
                ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support UPDATE with join clause that uses columns from multiple tables.");
                throw new KotlinNothingValueException();
            }
            Table tableToUpdate = table;
            Join.JoinPart joinPart = (Join.JoinPart)CollectionsKt.singleOrNull(targets.getJoinParts$exposed_core());
            if (joinPart == null) {
                ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support UPDATE with join clause that uses multiple tables to join.");
                throw new KotlinNothingValueException();
            }
            Join.JoinPart joinPart2 = joinPart;
            INSTANCE.checkJoinTypes$exposed_core(targets, StatementType.UPDATE);
            INSTANCE.appendMergeIntoUsingJoinClause($this$update_u24lambda_u249, tableToUpdate, targets, joinPart2, transaction);
            $this$update_u24lambda_u249.unaryPlus(" WHEN MATCHED THEN UPDATE SET ");
            ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u249, null, null, null, (arg_0, arg_1) -> H2FunctionProvider.update$lambda$9$lambda$7(transaction, arg_0, arg_1), 14, null);
            Op<Boolean> op = where;
            if (op == null) break block5;
            Op<Boolean> it = op;
            boolean bl3 = false;
            $this$update_u24lambda_u249.unaryPlus(" WHERE ");
            $this$update_u24lambda_u249.unaryPlus((Expression)it);
        }
        return $this$update_u24lambda_u249.toString();
    }

    private final void appendMergeIntoUsingJoinClause(QueryBuilder $this$appendMergeIntoUsingJoinClause, Table target, Join join, Join.JoinPart joinPart, Transaction transaction) {
        ColumnSet columnSet;
        $this$appendMergeIntoUsingJoinClause.unaryPlus("MERGE INTO ");
        target.describe(transaction, $this$appendMergeIntoUsingJoinClause);
        $this$appendMergeIntoUsingJoinClause.unaryPlus(" USING ");
        ColumnSet it = columnSet = joinPart.getJoinPart();
        boolean bl = false;
        ColumnSet columnSet2 = !Intrinsics.areEqual((Object)it, (Object)target) ? columnSet : null;
        if (columnSet2 == null) {
            columnSet2 = join.getTable();
        }
        columnSet2.describe(transaction, $this$appendMergeIntoUsingJoinClause);
        $this$appendMergeIntoUsingJoinClause.unaryPlus(" ON ");
        joinPart.appendConditions($this$appendMergeIntoUsingJoinClause);
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Join targets, @NotNull List<? extends Table> targetTables, @Nullable Op<Boolean> where, @Nullable Integer limit, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
        Intrinsics.checkNotNullParameter(targetTables, (String)"targetTables");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (ignore) {
            ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support IGNORE in DELETE from join relation");
            throw new KotlinNothingValueException();
        }
        if (limit != null) {
            ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support LIMIT in DELETE from join relation");
            throw new KotlinNothingValueException();
        }
        Table table = (Table)CollectionsKt.singleOrNull(targetTables);
        if (table == null) {
            ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support DELETE from join relation with multiple tables to delete from");
            throw new KotlinNothingValueException();
        }
        Table tableToDelete = table;
        Join.JoinPart joinPart = (Join.JoinPart)CollectionsKt.singleOrNull(targets.getJoinParts$exposed_core());
        if (joinPart == null) {
            ExceptionsKt.throwUnsupportedException(transaction, "H2 doesn't support DELETE from join relation that uses multiple tables to join");
            throw new KotlinNothingValueException();
        }
        Join.JoinPart joinPart2 = joinPart;
        this.checkJoinTypes$exposed_core(targets, StatementType.DELETE);
        QueryBuilder $this$delete_u24lambda_u2412 = new QueryBuilder(true);
        boolean bl = false;
        INSTANCE.appendMergeIntoUsingJoinClause($this$delete_u24lambda_u2412, tableToDelete, targets, joinPart2, transaction);
        $this$delete_u24lambda_u2412.unaryPlus(" WHEN MATCHED");
        Op<Boolean> op = where;
        if (op != null) {
            Op<Boolean> it = op;
            boolean bl2 = false;
            $this$delete_u24lambda_u2412.unaryPlus(" AND ");
            $this$delete_u24lambda_u2412.unaryPlus((Expression)it);
        }
        $this$delete_u24lambda_u2412.unaryPlus(" THEN DELETE");
        return $this$delete_u24lambda_u2412.toString();
    }

    @Override
    public <T extends String> void locate(@NotNull QueryBuilder queryBuilder, @NotNull Expression<T> expr, @NotNull String substring) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> H2FunctionProvider.locate$lambda$13(substring, expr, arg_0)));
    }

    @Override
    @NotNull
    public String explain(boolean analyze, @Nullable String options, @NotNull String internalStatement, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)internalStatement, (String)"internalStatement");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (options != null) {
            ExceptionsKt.throwUnsupportedException(transaction, "H2 does not support options other than ANALYZE in EXPLAIN queries.");
            throw new KotlinNothingValueException();
        }
        return super.explain(analyze, null, internalStatement, transaction);
    }

    @Override
    public <T> void date(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> H2FunctionProvider.date$lambda$14(expr, arg_0)));
    }

    @Override
    public <T> void time(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> H2FunctionProvider.time$lambda$15(expr, arg_0)));
    }

    private static final Unit nextVal$lambda$0(Sequence $seq, QueryBuilder $this$builder) {
        Intrinsics.checkNotNullParameter((Object)$this$builder, (String)"$this$builder");
        $this$builder.append("NEXT VALUE FOR " + $seq.getIdentifier());
        return Unit.INSTANCE;
    }

    private static final Unit arraySlice$lambda$1(Expression $expression, Integer $lower, Integer $upper, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{"ARRAY_SLICE(", $expression, "" + ',' + $lower + ',' + $upper + ')'};
        ExpressionKt.append($this$queryBuilder, objectArray);
        return Unit.INSTANCE;
    }

    private static final CharSequence insert$lambda$5(Transaction $transaction, Column it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $transaction.identity(it) + "=VALUES(" + $transaction.identity(it) + ')';
    }

    private static final Unit update$lambda$9$lambda$7(Transaction $transaction, QueryBuilder $this$appendTo, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"$this$appendTo");
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Column col = (Column)pair.component1();
        Object value = pair.component2();
        $this$appendTo.append($transaction.fullIdentity(col) + '=');
        $this$appendTo.registerArgument(col, value);
        return Unit.INSTANCE;
    }

    private static final Unit locate$lambda$13(String $substring, Expression $expr, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{"LOCATE('", $substring, "',", $expr, ")"};
        ExpressionKt.append($this$queryBuilder, objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit date$lambda$14(Expression $expr, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{"CAST(", $expr, " AS DATE)"};
        ExpressionKt.append($this$queryBuilder, objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit time$lambda$15(Expression $expr, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{"FORMATDATETIME(", $expr, ", 'HH:mm:ss.SSSSSSSSS')"};
        ExpressionKt.append($this$queryBuilder, objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2MajorVersion.values().length];
            try {
                nArray[H2Dialect.H2MajorVersion.Two.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

