/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.transactions;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.DatabaseApi;
import org.jetbrains.exposed.v1.core.InternalApi;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.transactions.NotInitializedTransactionManager;
import org.jetbrains.exposed.v1.core.transactions.TransactionManagerApi;

@InternalApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u0004\u0018\u00010\u0006J\b\u0010\n\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0010J\u0010\u0010\u0018\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/v1/core/transactions/CoreTransactionManager;", "", "<init>", "()V", "databases", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lorg/jetbrains/exposed/v1/core/DatabaseApi;", "currentDefaultDatabase", "Ljava/util/concurrent/atomic/AtomicReference;", "getDefaultDatabase", "getDefaultDatabaseOrFirst", "setDefaultDatabase", "", "db", "registeredDatabases", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "getDatabaseManager", "currentThreadManager", "Lorg/jetbrains/exposed/v1/core/transactions/CoreTransactionManager$TransactionManagerThreadLocal;", "registerDatabaseManager", "manager", "closeAndUnregisterDatabase", "getCurrentThreadManager", "resetCurrentThreadManager", "currentTransactionOrNull", "Lorg/jetbrains/exposed/v1/core/Transaction;", "currentTransaction", "TransactionManagerThreadLocal", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nCoreTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTransactionManager.kt\norg/jetbrains/exposed/v1/core/transactions/CoreTransactionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class CoreTransactionManager {
    @NotNull
    public static final CoreTransactionManager INSTANCE = new CoreTransactionManager();
    @NotNull
    private static final ConcurrentLinkedDeque<DatabaseApi> databases = new ConcurrentLinkedDeque();
    @NotNull
    private static final AtomicReference<DatabaseApi> currentDefaultDatabase = new AtomicReference();
    @NotNull
    private static final ConcurrentHashMap<DatabaseApi, TransactionManagerApi> registeredDatabases = new ConcurrentHashMap();
    @NotNull
    private static final TransactionManagerThreadLocal currentThreadManager = new TransactionManagerThreadLocal();

    private CoreTransactionManager() {
    }

    @Nullable
    public final DatabaseApi getDefaultDatabase() {
        return currentDefaultDatabase.get();
    }

    @Nullable
    public final DatabaseApi getDefaultDatabaseOrFirst() {
        DatabaseApi databaseApi = this.getDefaultDatabase();
        if (databaseApi == null) {
            databaseApi = (DatabaseApi)CollectionsKt.firstOrNull((Iterable)databases);
        }
        return databaseApi;
    }

    public final void setDefaultDatabase(@Nullable DatabaseApi db) {
        currentDefaultDatabase.set(db);
    }

    @Nullable
    public final TransactionManagerApi getDatabaseManager(@NotNull DatabaseApi db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        return registeredDatabases.get(db);
    }

    public final void registerDatabaseManager(@NotNull DatabaseApi db, @NotNull TransactionManagerApi manager) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (this.getDefaultDatabaseOrFirst() == null) {
            currentThreadManager.remove();
        }
        if (!registeredDatabases.containsKey(db)) {
            databases.push(db);
        }
        ((Map)registeredDatabases).put(db, manager);
    }

    public final void closeAndUnregisterDatabase(@NotNull DatabaseApi db) {
        block1: {
            TransactionManagerApi manager;
            Intrinsics.checkNotNullParameter((Object)db, (String)"db");
            TransactionManagerApi transactionManagerApi = manager = this.getDatabaseManager(db);
            if (transactionManagerApi == null) break block1;
            TransactionManagerApi it = transactionManagerApi;
            boolean bl = false;
            registeredDatabases.remove(db);
            databases.remove(db);
            currentDefaultDatabase.compareAndSet(db, null);
            if (currentThreadManager.isInitialized() && Intrinsics.areEqual((Object)INSTANCE.getCurrentThreadManager(), (Object)it)) {
                currentThreadManager.remove();
            }
        }
    }

    @NotNull
    public final TransactionManagerApi getCurrentThreadManager() {
        return currentThreadManager.get();
    }

    public final void resetCurrentThreadManager(@Nullable TransactionManagerApi manager) {
        TransactionManagerApi transactionManagerApi = manager;
        if (transactionManagerApi != null) {
            TransactionManagerApi it = transactionManagerApi;
            boolean bl = false;
            currentThreadManager.set(it);
        } else {
            currentThreadManager.remove();
        }
    }

    @Nullable
    public final Transaction currentTransactionOrNull() {
        return this.getCurrentThreadManager().currentOrNull();
    }

    @NotNull
    public final Transaction currentTransaction() {
        Transaction transaction = this.currentTransactionOrNull();
        if (transaction == null) {
            throw new IllegalStateException("No transaction in context.".toString());
        }
        return transaction;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0002H\u0016J\b\u0010\u000b\u001a\u00020\u0002H\u0014J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/exposed/v1/core/transactions/CoreTransactionManager$TransactionManagerThreadLocal;", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "<init>", "()V", "isInitialized", "", "()Z", "setInitialized", "(Z)V", "get", "initialValue", "set", "", "value", "remove", "exposed-core"})
    @SourceDebugExtension(value={"SMAP\nCoreTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoreTransactionManager.kt\norg/jetbrains/exposed/v1/core/transactions/CoreTransactionManager$TransactionManagerThreadLocal\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
    private static final class TransactionManagerThreadLocal
    extends ThreadLocal<TransactionManagerApi> {
        private boolean isInitialized;

        public final boolean isInitialized() {
            return this.isInitialized;
        }

        public final void setInitialized(boolean bl) {
            this.isInitialized = bl;
        }

        @Override
        @NotNull
        public TransactionManagerApi get() {
            Object t = super.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            return (TransactionManagerApi)t;
        }

        @Override
        @NotNull
        protected TransactionManagerApi initialValue() {
            Object object;
            block3: {
                block2: {
                    this.isInitialized = true;
                    object = INSTANCE.getDefaultDatabaseOrFirst();
                    if (object == null) break block2;
                    DatabaseApi it = object;
                    boolean bl = false;
                    TransactionManagerApi transactionManagerApi = (TransactionManagerApi)MapsKt.getValue((Map)registeredDatabases, (Object)it);
                    object = transactionManagerApi;
                    if (transactionManagerApi != null) break block3;
                }
                object = NotInitializedTransactionManager.INSTANCE;
            }
            return object;
        }

        @Override
        public void set(@Nullable TransactionManagerApi value) {
            this.isInitialized = true;
            super.set(value);
        }

        @Override
        public void remove() {
            this.isInitialized = false;
            super.remove();
        }
    }
}

