/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.functions.array;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.Function;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.QueryBuilder;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.FunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.H2FunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.H2Kt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0010\b\u0001\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00020\u0004B<\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00010\u000b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0013\u0010\u0011\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/v1/core/functions/array/ArraySlice;", "E", "T", "", "Lorg/jetbrains/exposed/v1/core/Function;", "expression", "Lorg/jetbrains/exposed/v1/core/Expression;", "lower", "", "upper", "columnType", "Lorg/jetbrains/exposed/v1/core/IColumnType;", "<init>", "(Lorg/jetbrains/exposed/v1/core/Expression;Ljava/lang/Integer;Ljava/lang/Integer;Lorg/jetbrains/exposed/v1/core/IColumnType;)V", "getExpression", "()Lorg/jetbrains/exposed/v1/core/Expression;", "getLower", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getUpper", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "exposed-core"})
public final class ArraySlice<E, T extends List<? extends E>>
extends Function<T> {
    @NotNull
    private final Expression<T> expression;
    @Nullable
    private final Integer lower;
    @Nullable
    private final Integer upper;

    public ArraySlice(@NotNull Expression<T> expression, @Nullable Integer lower, @Nullable Integer upper, @NotNull IColumnType<T> columnType) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
        super(columnType);
        this.expression = expression;
        this.lower = lower;
        this.upper = upper;
    }

    @NotNull
    public final Expression<T> getExpression() {
        return this.expression;
    }

    @Nullable
    public final Integer getLower() {
        return this.lower;
    }

    @Nullable
    public final Integer getUpper() {
        return this.upper;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        H2Dialect.H2CompatibilityMode h2CompatibilityMode = H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect());
        FunctionProvider functionProvider = (h2CompatibilityMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[h2CompatibilityMode.ordinal()]) == 1 ? (FunctionProvider)H2FunctionProvider.INSTANCE : DatabaseDialectKt.getCurrentDialect().getFunctionProvider();
        functionProvider.arraySlice(this.expression, this.lower, this.upper, queryBuilder);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[H2Dialect.H2CompatibilityMode.values().length];
            try {
                nArray[H2Dialect.H2CompatibilityMode.PostgreSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

