/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.datetime;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.IDateColumnType;
import org.jetbrains.exposed.v1.core.datetime.OffsetDateTimeColumnTypeKt;
import org.jetbrains.exposed.v1.core.statements.api.RowApi;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.OracleDialect;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.v1.core.vendors.SQLiteDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0016H\u0002J\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001a\u0010\u001e\u001a\u00020\u00162\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u001f\u001a\u00020\u00122\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006 "}, d2={"Lorg/jetbrains/exposed/v1/core/datetime/OffsetDateTimeColumnType;", "T", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Lorg/jetbrains/exposed/v1/core/IDateColumnType;", "<init>", "()V", "toOffsetDateTime", "Ljava/time/OffsetDateTime;", "value", "(Ljava/lang/Object;)Ljava/time/OffsetDateTime;", "fromOffsetDateTime", "datetime", "(Ljava/time/OffsetDateTime;)Ljava/lang/Object;", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "offsetDatetimeValueFromDB", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "readObject", "rs", "Lorg/jetbrains/exposed/v1/core/statements/api/RowApi;", "index", "", "notNullValueToDB", "nonNullValueAsDefaultString", "exposed-core"})
public abstract class OffsetDateTimeColumnType<T>
extends ColumnType<T>
implements IDateColumnType {
    private final boolean hasTimePart;

    public OffsetDateTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @NotNull
    public abstract OffsetDateTime toOffsetDateTime(T var1);

    public abstract T fromOffsetDateTime(@NotNull OffsetDateTime var1);

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timestampWithTimeZoneType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        OffsetDateTime datetime = this.toOffsetDateTime(value);
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? '\'' + datetime.format(OffsetDateTimeColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof MysqlDialect ? '\'' + datetime.format(OffsetDateTimeColumnTypeKt.access$getMYSQL_OFFSET_DATE_TIME_FORMATTER()) + '\'' : (databaseDialect instanceof OracleDialect ? OffsetDateTimeColumnTypeKt.access$oracleDateTimeWithTimezoneLiteral(datetime) : '\'' + datetime.format(OffsetDateTimeColumnTypeKt.access$getDEFAULT_OFFSET_DATE_TIME_FORMATTER()) + '\''));
    }

    private final OffsetDateTime offsetDatetimeValueFromDB(Object value) {
        OffsetDateTime offsetDateTime;
        Object object = value;
        if (object instanceof OffsetDateTime) {
            offsetDateTime = (OffsetDateTime)value;
        } else if (object instanceof ZonedDateTime) {
            OffsetDateTime offsetDateTime2 = ((ZonedDateTime)value).toOffsetDateTime();
            offsetDateTime = offsetDateTime2;
            Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime2, (String)"toOffsetDateTime(...)");
        } else if (object instanceof String) {
            TemporalAccessor temporalAccessor;
            OffsetDateTime offsetDateTime3 = DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? ((temporalAccessor = OffsetDateTimeColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER().parse((CharSequence)value)).isSupported(ChronoField.OFFSET_SECONDS) ? OffsetDateTime.from(temporalAccessor) : LocalDateTime.from(temporalAccessor).atOffset(ZoneOffset.UTC)) : OffsetDateTime.parse((CharSequence)value);
            Intrinsics.checkNotNull((Object)offsetDateTime3);
            offsetDateTime = offsetDateTime3;
        } else {
            throw new IllegalStateException(("Unexpected value: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return offsetDateTime;
    }

    @Override
    @Nullable
    public T valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fromOffsetDateTime(this.offsetDatetimeValueFromDB(value));
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? super.readObject(rs, index) : (databaseDialect instanceof OracleDialect ? rs.getObject(index, ZonedDateTime.class, (IColumnType)this) : rs.getObject(index, OffsetDateTime.class, (IColumnType)this));
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        OffsetDateTime offsetDateTime = this.toOffsetDateTime(value);
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof SQLiteDialect ? offsetDateTime.format(OffsetDateTimeColumnTypeKt.access$getSQLITE_OFFSET_DATE_TIME_FORMATTER()) : (databaseDialect instanceof MysqlDialect ? offsetDateTime.format(OffsetDateTimeColumnTypeKt.access$getMYSQL_OFFSET_DATE_TIME_FORMATTER()) : offsetDateTime);
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        OffsetDateTime offsetDateTime = this.toOffsetDateTime(value);
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof PostgreSQLDialect ? '\'' + offsetDateTime.format(OffsetDateTimeColumnTypeKt.access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + "+00'::timestamp with time zone" : (dialect instanceof H2Dialect && ((H2Dialect)dialect).getH2Mode() == H2Dialect.H2CompatibilityMode.Oracle ? '\'' + offsetDateTime.format(OffsetDateTimeColumnTypeKt.access$getPOSTGRESQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + '\'' : (dialect instanceof MysqlDialect ? '\'' + offsetDateTime.format(OffsetDateTimeColumnTypeKt.access$getMYSQL_OFFSET_DATE_TIME_AS_DEFAULT_FORMATTER()) + '\'' : (dialect instanceof OracleDialect ? OffsetDateTimeColumnTypeKt.access$oracleDateTimeWithTimezoneLiteral(offsetDateTime) : super.nonNullValueAsDefaultString(value))));
    }
}

