/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.Statement;
import org.jetbrains.exposed.v1.core.statements.StatementType;
import org.jetbrains.exposed.v1.core.statements.api.ResultApi;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\u000e\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00100\u000f0\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/exposed/v1/core/ExplainQuery;", "Lorg/jetbrains/exposed/v1/core/statements/Statement;", "Lorg/jetbrains/exposed/v1/core/statements/api/ResultApi;", "analyze", "", "options", "", "internalStatement", "<init>", "(ZLjava/lang/String;Lorg/jetbrains/exposed/v1/core/statements/Statement;)V", "getAnalyze", "()Z", "getOptions", "()Ljava/lang/String;", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/v1/core/IColumnType;", "", "prepareSQL", "transaction", "Lorg/jetbrains/exposed/v1/core/Transaction;", "prepared", "exposed-core"})
public class ExplainQuery
extends Statement<ResultApi> {
    private final boolean analyze;
    @Nullable
    private final String options;
    @NotNull
    private final Statement<?> internalStatement;

    public ExplainQuery(boolean analyze, @Nullable String options, @NotNull Statement<?> internalStatement) {
        Intrinsics.checkNotNullParameter(internalStatement, (String)"internalStatement");
        super(StatementType.SHOW, CollectionsKt.emptyList());
        this.analyze = analyze;
        this.options = options;
        this.internalStatement = internalStatement;
    }

    public final boolean getAnalyze() {
        return this.analyze;
    }

    @Nullable
    public final String getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.internalStatement.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String internalSql = this.internalStatement.prepareSQL(transaction, prepared);
        return transaction.getDb().getDialect().getFunctionProvider().explain(this.analyze, this.options, internalSql, transaction);
    }
}

