/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.DdlAware;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.SQLLogKt;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.SQLiteDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/v1/core/CheckConstraint;", "Lorg/jetbrains/exposed/v1/core/DdlAware;", "tableName", "", "checkName", "checkOp", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getTableName", "()Ljava/lang/String;", "getCheckName", "getCheckOp", "checkPart", "getCheckPart$exposed_core", "cannotAlterCheckConstraint", "", "Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect;", "getCannotAlterCheckConstraint", "(Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect;)Z", "createStatement", "", "modifyStatement", "dropStatement", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "exposed-core"})
public final class CheckConstraint
implements DdlAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tableName;
    @NotNull
    private final String checkName;
    @NotNull
    private final String checkOp;
    @NotNull
    private final String checkPart;

    public CheckConstraint(@NotNull String tableName, @NotNull String checkName, @NotNull String checkOp) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)checkOp, (String)"checkOp");
        this.tableName = tableName;
        this.checkName = checkName;
        this.checkOp = checkOp;
        this.checkPart = "CONSTRAINT " + this.checkName + " CHECK (" + this.checkOp + ')';
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    @NotNull
    public final String getCheckName() {
        return this.checkName;
    }

    @NotNull
    public final String getCheckOp() {
        return this.checkOp;
    }

    @NotNull
    public final String getCheckPart$exposed_core() {
        return this.checkPart;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getCannotAlterCheckConstraint(DatabaseDialect $this$cannotAlterCheckConstraint) {
        if ($this$cannotAlterCheckConstraint instanceof SQLiteDialect) return true;
        if (!($this$cannotAlterCheckConstraint instanceof MysqlDialect)) return false;
        MysqlDialect mysqlDialect = (MysqlDialect)$this$cannotAlterCheckConstraint;
        if (mysqlDialect == null) return false;
        if (mysqlDialect.isMysql8$exposed_core()) return false;
        return true;
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        List list;
        if (this.getCannotAlterCheckConstraint(DatabaseDialectKt.getCurrentDialect())) {
            SQLLogKt.getExposedLogger().warn("Creation of CHECK constraints is not currently supported by " + DatabaseDialectKt.getCurrentDialect().getName());
            list = CollectionsKt.emptyList();
        } else {
            list = CollectionsKt.listOf((Object)("ALTER TABLE " + this.tableName + " ADD " + this.checkPart));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        List list;
        if (this.getCannotAlterCheckConstraint(DatabaseDialectKt.getCurrentDialect())) {
            SQLLogKt.getExposedLogger().warn("Deletion of CHECK constraints is not currently supported by " + DatabaseDialectKt.getCurrentDialect().getName());
            list = CollectionsKt.emptyList();
        } else {
            list = CollectionsKt.listOf((Object)("ALTER TABLE " + this.tableName + " DROP CONSTRAINT " + this.checkName));
        }
        return list;
    }

    @NotNull
    public final String component1() {
        return this.tableName;
    }

    @NotNull
    public final String component2() {
        return this.checkName;
    }

    @NotNull
    public final String component3() {
        return this.checkOp;
    }

    @NotNull
    public final CheckConstraint copy(@NotNull String tableName, @NotNull String checkName, @NotNull String checkOp) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)checkOp, (String)"checkOp");
        return new CheckConstraint(tableName, checkName, checkOp);
    }

    public static /* synthetic */ CheckConstraint copy$default(CheckConstraint checkConstraint, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = checkConstraint.tableName;
        }
        if ((n & 2) != 0) {
            string2 = checkConstraint.checkName;
        }
        if ((n & 4) != 0) {
            string3 = checkConstraint.checkOp;
        }
        return checkConstraint.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "CheckConstraint(tableName=" + this.tableName + ", checkName=" + this.checkName + ", checkOp=" + this.checkOp + ')';
    }

    public int hashCode() {
        int result = this.tableName.hashCode();
        result = result * 31 + this.checkName.hashCode();
        result = result * 31 + this.checkOp.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckConstraint)) {
            return false;
        }
        CheckConstraint checkConstraint = (CheckConstraint)other;
        if (!Intrinsics.areEqual((Object)this.tableName, (Object)checkConstraint.tableName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.checkName, (Object)checkConstraint.checkName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.checkOp, (Object)checkConstraint.checkOp);
    }

    @Override
    @NotNull
    public List<String> getDdl() {
        return DdlAware.DefaultImpls.getDdl(this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/exposed/v1/core/CheckConstraint$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/exposed/v1/core/CheckConstraint;", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "name", "", "op", "Lorg/jetbrains/exposed/v1/core/Op;", "", "exposed-core"})
    @SourceDebugExtension(value={"SMAP\nConstraints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Constraints.kt\norg/jetbrains/exposed/v1/core/CheckConstraint$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckConstraint from(@NotNull Table table, @NotNull String name, @NotNull Op<Boolean> op) {
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(op, (String)"op");
            if (!(!StringsKt.isBlank((CharSequence)name))) {
                boolean $i$a$-require-CheckConstraint$Companion$from$22 = false;
                String $i$a$-require-CheckConstraint$Companion$from$22 = "Check constraint name cannot be blank";
                throw new IllegalArgumentException($i$a$-require-CheckConstraint$Companion$from$22.toString());
            }
            Transaction tr = CoreTransactionManager.INSTANCE.currentTransaction();
            IdentifierManagerApi identifierManager = tr.getDb().getIdentifierManager();
            String tableName = tr.identity(table);
            String checkOpSQL = StringsKt.replace$default((String)op.toString(), (String)(tableName + '.'), (String)"", (boolean)false, (int)4, null);
            return new CheckConstraint(tableName, identifierManager.cutIfNecessaryAndQuote(name), checkOpSQL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

