/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.sql.Blob;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.statements.api.ExposedBlob;
import org.jetbrains.exposed.v1.core.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.v1.core.statements.api.RowApi;
import org.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/exposed/v1/core/BlobColumnType;", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Lorg/jetbrains/exposed/v1/core/statements/api/ExposedBlob;", "useObjectIdentifier", "", "<init>", "(Z)V", "getUseObjectIdentifier", "()Z", "sqlType", "", "valueFromDB", "value", "", "nonNullValueToString", "readObject", "rs", "Lorg/jetbrains/exposed/v1/core/statements/api/RowApi;", "index", "", "setParameter", "", "stmt", "Lorg/jetbrains/exposed/v1/core/statements/api/PreparedStatementApi;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/v1/core/BlobColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1449:1\n1#2:1450\n*E\n"})
public final class BlobColumnType
extends ColumnType<ExposedBlob> {
    private final boolean useObjectIdentifier;

    public BlobColumnType(boolean useObjectIdentifier) {
        super(false, 1, null);
        this.useObjectIdentifier = useObjectIdentifier;
    }

    public /* synthetic */ BlobColumnType(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getUseObjectIdentifier() {
        return this.useObjectIdentifier;
    }

    @Override
    @NotNull
    public String sqlType() {
        String string;
        if (this.useObjectIdentifier && DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect) {
            string = "oid";
        } else {
            if (this.useObjectIdentifier) {
                throw new IllegalStateException("Storing BLOBs using OID columns is only supported by PostgreSQL".toString());
            }
            string = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().blobType();
        }
        return string;
    }

    @Override
    @NotNull
    public ExposedBlob valueFromDB(@NotNull Object value) {
        ExposedBlob exposedBlob;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof ExposedBlob) {
            exposedBlob = (ExposedBlob)value;
        } else if (object instanceof InputStream) {
            exposedBlob = new ExposedBlob((InputStream)value);
        } else if (object instanceof byte[]) {
            exposedBlob = new ExposedBlob((byte[])value);
        } else if (object instanceof Blob) {
            InputStream inputStream = ((Blob)value).getBinaryStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getBinaryStream(...)");
            exposedBlob = new ExposedBlob(inputStream);
        } else if (object instanceof ByteBuffer) {
            byte[] byArray = ((ByteBuffer)value).array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            exposedBlob = new ExposedBlob(byArray);
        } else {
            throw new IllegalStateException(("Unexpected value of type Blob: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return exposedBlob;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull ExposedBlob value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Object object = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if (object == null || (object = ((H2Dialect)object).getOriginalDataTypeProvider()) == null) {
            object = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider();
        }
        return ((DataTypeProvider)object).hexToDb(value.hexString());
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (DatabaseDialectKt.getCurrentDialect() instanceof PostgreSQLDialect && this.useObjectIdentifier) {
            Object object2 = rs.getObject(index, Blob.class);
            if (object2 != null && (object2 = object2.getBinaryStream()) != null) {
                Object p0 = object2;
                boolean bl = false;
                object = new ExposedBlob((InputStream)p0);
            } else {
                object = null;
            }
        } else {
            object = rs.getObject(index);
        }
        return object;
    }

    @Override
    public void setParameter(@NotNull PreparedStatementApi stmt, int index, @Nullable Object value) {
        Object toSetValue;
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Object object = value instanceof ExposedBlob ? (ExposedBlob)value : null;
        if (object == null || (object = ((ExposedBlob)object).getInputStream()) == null) {
            object = value;
        }
        if ((toSetValue = object) instanceof InputStream) {
            stmt.setInputStream(index, (InputStream)toSetValue, this.useObjectIdentifier);
        } else if (toSetValue == null || toSetValue instanceof Op.NULL) {
            stmt.setNull(index, this);
        } else {
            super.setParameter(stmt, index, toSetValue);
        }
    }

    public BlobColumnType() {
        this(false, 1, null);
    }
}

