"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SSHAgentStream = void 0;
exports.makeRusshAgentConnection = makeRusshAgentConnection;
const rxjs_1 = require("rxjs");
const helpers_1 = require("./helpers");
const russh = __importStar(require("./native"));
function makeRusshAgentConnection(spec) {
    return russh.AgentConnection.new({
        pageant: 0 /* russh.AgentConnectionKind.Pageant */,
        'named-pipe': 1 /* russh.AgentConnectionKind.Pipe */,
        'unix-socket': 2 /* russh.AgentConnectionKind.Unix */,
    }[spec.kind], spec.kind === 'pageant' ? undefined : spec.path);
}
class SSHAgentStream extends helpers_1.Destructible {
    constructor(inner, data) {
        super();
        this.inner = inner;
        this.data = data;
        this.data$ = this.data.asObservable().pipe((0, rxjs_1.filter)(data => data.length > 0));
        this.data.subscribe(data => {
            if (data.length === 0) {
                this.destruct();
            }
        });
    }
    destruct() {
        super.destruct();
        this.data.complete();
    }
    write(data) {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.write(data);
        });
    }
    close() {
        return __awaiter(this, void 0, void 0, function* () {
            this.assertNotDestructed();
            yield this.inner.close();
            this.destruct();
        });
    }
    static connect(spec) {
        return __awaiter(this, void 0, void 0, function* () {
            let dataSubject = new rxjs_1.Subject();
            return new SSHAgentStream(yield russh.connectAgent(makeRusshAgentConnection(spec), (_, data) => {
                dataSubject.next(data);
            }), dataSubject);
        });
    }
}
exports.SSHAgentStream = SSHAgentStream;
