-- Lua example: display field information

database = sqlitedatabase:new()
database:filename("C:\\ProgramData\\SQLite Expert\\Professional 5 - 32bit\\Data\\dbdemos.db3")
database:connected(true)
query = sqlitequery:new()
query:database(database)
query:sql("select * from customer")
query:active(true)
print("Name                            Declared type    Type              Size    Precision\n")
print("------------------------------------------------------------------------------------\n")
for i=0, query:fieldcount() - 1 do
    if (query:getfield(i):visible()) then 
       print( string.format("%-30s  %-15s  %-15s  %5s  %11s\n",
           query:getfield(i):name(),
           query:getfield(i):fullsqltype(),
           query:getfield(i):sqltype(),
           query:getfield(i):size(),
           query:getfield(i):precision()))
    end
end
query:active(false)
query:free()
database:free()
print("\n")