"use strict";
const DynamicSvg = {
    "About": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><g clip-path="url(#clip0_2872_19390)"><path d="M21.6531 16.8396C23.6296 12.7873 22.9524 7.76926 19.5916 4.40844C16.845 1.66187 12.9879 0.70877 9.46533 1.52842L4.06852 2.3771C1.76769 2.73891 0.769817 5.50932 2.30935 7.23825C0.379288 11.2767 1.06919 16.2522 4.40851 19.5915C7.01243 22.1954 10.6158 23.1877 13.9841 22.5848L19.859 21.6609C22.1422 21.3019 23.1424 18.5709 21.6531 16.8396Z" fill="var(--svg-fill-white)"/><path d="M19.9367 22.1548C22.4923 21.753 23.6778 18.8066 22.2363 16.7745C24.1361 12.5894 23.3844 7.49413 19.9451 4.05489C17.0753 1.18506 13.0478 0.187759 9.36991 1.03728L3.99085 1.88317C1.4155 2.28815 0.231024 5.27793 1.72537 7.31091C-0.125606 11.4796 0.639054 16.5291 4.05496 19.945C6.77869 22.6688 10.5469 23.7062 14.0668 23.0779L19.9367 22.1548Z" stroke="var(--svg-stroke-black)" stroke-opacity="0.12"/><path d="M13.1222 6.32565C14.2066 6.54981 15.2385 7.08165 16.0785 7.9216C18.0433 9.88643 18.3222 12.9019 16.9205 15.1822L16.6248 14.318C16.5676 14.1507 16.473 13.9989 16.3482 13.874C15.6745 13.2 14.5164 13.5821 14.3679 14.5273L13.3731 20.8562L19.7053 19.86C20.6474 19.7117 21.0282 18.5564 20.3565 17.8843C20.2287 17.7565 20.0727 17.6605 19.9009 17.6039L19.2288 17.3826C21.7932 13.8335 21.4914 8.86391 18.3138 5.68631C16.9887 4.36127 15.3521 3.53627 13.6367 3.21064C10.944 2.93528 10.7469 6.0384 13.1443 6.32172L13.1222 6.32565Z" fill="url(#paint0_linear_2872_19390)"/><path d="M9.54073 9.23717L10.5134 3.05157L4.32156 4.02528C3.40031 4.17015 3.02795 5.29935 3.68482 5.95622C3.80974 6.08115 3.9623 6.175 4.13032 6.23029L4.87572 6.47557C2.19928 10.0331 2.46615 15.0935 5.68629 18.3137C6.9939 19.6213 8.60497 20.4419 10.2956 20.7762C12.8342 20.9139 12.9756 17.93 10.627 17.6525L10.7116 17.6374C9.6882 17.3948 8.71848 16.8753 7.92158 16.0784C5.9446 14.1014 5.67447 11.0608 7.10576 8.77557L7.33377 9.44173C7.38973 9.60525 7.48225 9.75366 7.60432 9.87572C8.26305 10.5345 9.39545 10.161 9.54073 9.23717Z" fill="url(#paint1_linear_2872_19390)"/></g><defs><linearGradient id="paint0_linear_2872_19390" x1="16.2109" y1="3.30573" x2="16.2436" y2="19.8887" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-1DC9FF)"/><stop offset="1" stop-color="var(--svg-stop-color-0047FF)"/></linearGradient><linearGradient id="paint1_linear_2872_19390" x1="5.08025" y1="7.83908" x2="12.787" y2="18.0778" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-FF4D4D)"/><stop offset="1" stop-color="var(--svg-stop-color-D4276F)"/></linearGradient><clipPath id="clip0_2872_19390"><rect width="24" height="24" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "account-16": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-6890D9)" stroke="var(--svg-stroke-2D4F97)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H20 C26 19 31 24 31 30 V31 Z" fill="var(--svg-fill-6890D9)" stroke="var(--svg-stroke-2D4F97)" stroke-width="2"/></svg>',
    "account-enc": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-31A629)" stroke="var(--svg-stroke-green)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H20 C26 19 31 24 31 30 V31 Z" fill="var(--svg-fill-31A629)" stroke="var(--svg-stroke-green)" stroke-width="2"/><path d="M16 24 V28" stroke="var(--svg-stroke-000000)" stroke-width="3"  stroke-linecap="round"/><circle cx="16" cy="23.5" r="3" fill="var(--svg-fill-000000)"/></svg>',
    "account-err-enc": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-f55)" stroke="var(--svg-stroke-822)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H20 C26 19 31 24 31 30 V31 Z" fill="var(--svg-fill-f55)" stroke="var(--svg-stroke-822)" stroke-width="2"/><path d="M16 24 V28" stroke="var(--svg-stroke-000000)" stroke-width="3"  stroke-linecap="round"/><circle cx="16" cy="23.5" r="3" fill="var(--svg-fill-000000)"/></svg>',
    "account-err-zip": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-FFFFFF)" stroke="var(--svg-stroke-822)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H20 C26 19 31 24 31 30 V31 Z" fill="var(--svg-fill-822)" stroke="var(--svg-stroke-822)" stroke-width="2"/> <g transform="translate(1, 3) scale(1.9)"> <path d=" M1.5 11 H 6 L 2 14 H6.5 M11 11 H13 C15 11 15 13 13 13 H11 M13 11 C14.25 11 14.25 13 13 13" stroke="var(--svg-stroke-FFFFFF)" stroke-width="1"  stroke-linejoin="round"/><path d="M8.375 10.5 V14.5 M11 10.5 V14.5 " stroke="var(--svg-stroke-FFFFFF)" stroke-width="1.5" /> </g></svg>',
    "account-prob-enc": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-FFDC5B)" stroke="var(--svg-stroke-C89A00)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H20 C26 19 31 24 31 30 V31 Z" fill="var(--svg-fill-FFDC5B)" stroke="var(--svg-stroke-C89A00)" stroke-width="2"/><path d="M16 24 V28" stroke="var(--svg-stroke-000000)" stroke-width="3"  stroke-linecap="round"/><circle cx="16" cy="23.5" r="3" fill="var(--svg-fill-000000)"/></svg>',
    "account-prob-zip": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-FFFFFF)" stroke="var(--svg-stroke-C89A00)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H20 C26 19 31 24 31 30 V31 Z" fill="var(--svg-fill-C89A00)" stroke="var(--svg-stroke-C89A00)" stroke-width="2"/> <g transform="translate(1, 3) scale(1.9)"> <path d=" M1.5 11 H 6 L 2 14 H6.5 M11 11 H13 C15 11 15 13 13 13 H11 M13 11 C14.25 11 14.25 13 13 13" stroke="var(--svg-stroke-FFFFFF)" stroke-width="1"  stroke-linejoin="round"/><path d="M8.375 10.5 V14.5 M11 10.5 V14.5 " stroke="var(--svg-stroke-FFFFFF)" stroke-width="1.5" /> </g></svg>',
    "account-sync-off": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-6890D9)" stroke="var(--svg-stroke-2D4F97)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H15.8 A10 10 0 0 0 16 30 V31 Z" fill="var(--svg-fill-6890D9)"/><path d="M16 31 H1 V30 C1 24 6 19 12 19 H15" stroke="var(--svg-stroke-2D4F97)" stroke-width="2" stroke-linecap="round"/><g transform="translate(17, 16) scale(0.6)"><path d="M1 9 A 11 11 0 0 1 22 8.5 M23 3 V9 H17 M23 15 A 11 11 0 0 1 2 15 M1 21 V15 H7" stroke="var(--svg-stroke-2D4F97)" stroke-width="3" stroke-linecap="round" fill="none" /></g><rect x="18.75" y="20.5" width="11" height="5" fill="var(--svg-fill-f55)" rx="2"/></svg>',
    "account-sync-on": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-6890D9)" stroke="var(--svg-stroke-2D4F97)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H15.8 A10 10 0 0 0 16 30 V31 Z" fill="var(--svg-fill-6890D9)"/><path d="M16 31 H1 V30 C1 24 6 19 12 19 H15" stroke="var(--svg-stroke-2D4F97)" stroke-width="2" stroke-linecap="round"/><g transform="translate(17, 16) scale(0.6)"><path d="M1 9 A 11 11 0 0 1 22 8.5 M23 3 V9 H17 M23 15 A 11 11 0 0 1 2 15 M1 21 V15 H7" stroke="var(--svg-stroke-2D4F97)" stroke-width="3" stroke-linecap="round" fill="none" /></g><circle cx="24.125" cy="23" r="4" fill="var(--svg-fill-31A629)"/></svg>',
    "account-sync-req": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-6890D9)" stroke="var(--svg-stroke-2D4F97)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H15.8 A10 10 0 0 0 16 30 V31 Z" fill="var(--svg-fill-6890D9)"/><path d="M16 31 H1 V30 C1 24 6 19 12 19 H15" stroke="var(--svg-stroke-2D4F97)" stroke-width="2" stroke-linecap="round"/><g transform="translate(17, 16) scale(0.6)"><path d="M1 9 A 11 11 0 0 1 22 8.5 M23 3 V9 H17 M23 15 A 11 11 0 0 1 2 15 M1 21 V15 H7" stroke="var(--svg-stroke-2D4F97)" stroke-width="3" stroke-linecap="round" fill="none" /></g></svg>',
    "account-zip": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-FFFFFF)" stroke="var(--svg-stroke-green)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H20 C26 19 31 24 31 30 V31 Z" fill="var(--svg-fill-green)" stroke="var(--svg-stroke-green)" stroke-width="2"/> <g transform="translate(1, 3) scale(1.9)"> <path d=" M1.5 11 H 6 L 2 14 H6.5 M11 11 H13 C15 11 15 13 13 13 H11 M13 11 C14.25 11 14.25 13 13 13" stroke="var(--svg-stroke-FFFFFF)" stroke-width="1"  stroke-linejoin="round"/><path d="M8.375 10.5 V14.5 M11 10.5 V14.5 " stroke="var(--svg-stroke-FFFFFF)" stroke-width="1.5" /> </g></svg>',
    "analyze": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><g clip-path="url(#clip0_4413_20136)"><rect x="0.5" y="0.5" width="25" height="31" fill="var(--svg-fill-757575)" stroke="var(--svg-stroke-white)"/><rect x="1.5" y="1.5" width="23" height="29" fill="var(--svg-fill-white)" stroke="var(--svg-stroke-757575)"/><rect x="4" y="8" width="18" height="4" fill="var(--svg-fill-757575)"/><rect x="4" y="15" width="18" height="4" fill="var(--svg-fill-757575)"/><rect x="4" y="22" width="18" height="4" fill="var(--svg-fill-757575)"/><rect x="8" y="8" width="14" height="4" fill="var(--svg-fill-AAAAAA)"/><rect x="7" y="15" width="15" height="4" fill="var(--svg-fill-AAAAAA)"/><path d="M10 22H22V26H13L10 22Z" fill="var(--svg-fill-AAAAAA)"/><circle cx="16.5" cy="15.5" r="10" stroke="var(--svg-stroke-5E88D7)" stroke-width="3"/><rect x="23" y="24.8284" width="4" height="7.59014" transform="rotate(-45 23 24.8284)" fill="var(--svg-fill-5E88D7)"/></g><defs><clipPath id="clip0_4413_20136"><rect width="32" height="32" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "analyze_and_sync": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M2 9.5 A 10.5 10.5 0 0 1 22 8.5 M23 3 V9 H20" stroke="var(--svg-stroke-7F848D)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none" /><path d="M22.5 14.5 A 10.5 10.5 0 0 1 21.2 17 M17.5 21.5 A 10.5 10.5 0 0 1 2 15 M1 21 V15 H4" stroke="var(--svg-stroke-F0483F)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none" /><circle cx="12" cy="12" r="6" stroke="var(--svg-stroke-6890D9)" stroke-width="2"/><path d="M17 17 L23 23" stroke="var(--svg-stroke-6890D9)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M13 9 C16 9 16 15 13 15" stroke="var(--svg-stroke-6890D9)" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "apple": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M14.1947 12.4689C13.9527 13.0279 13.6663 13.5424 13.3344 14.0155C12.8821 14.6604 12.5117 15.1068 12.2263 15.3547C11.7839 15.7616 11.3098 15.97 10.8022 15.9818C10.4377 15.9818 9.99825 15.8781 9.48666 15.6678C8.97339 15.4584 8.5017 15.3547 8.0704 15.3547C7.61807 15.3547 7.13295 15.4584 6.61405 15.6678C6.09436 15.8781 5.67571 15.9878 5.35562 15.9986C4.86882 16.0194 4.3836 15.8051 3.89927 15.3547C3.59014 15.0851 3.20349 14.6229 2.74029 13.9681C2.24332 13.2688 1.83474 12.458 1.51465 11.5336C1.17185 10.5351 1 9.5682 1 8.63213C1 7.55987 1.2317 6.63506 1.69578 5.86007C2.06051 5.23757 2.54573 4.74652 3.15302 4.38604C3.76031 4.02556 4.41649 3.84186 5.12313 3.83011C5.50979 3.83011 6.01684 3.94971 6.64694 4.18476C7.27527 4.42061 7.67871 4.54021 7.85559 4.54021C7.98784 4.54021 8.43602 4.40036 9.1958 4.12156C9.9143 3.863 10.5207 3.75594 11.0175 3.79811C12.3636 3.90675 13.3749 4.4374 14.0475 5.39342C12.8436 6.12288 12.2481 7.14458 12.2599 8.45525C12.2708 9.47616 12.6411 10.3257 13.369 11.0003C13.6989 11.3133 14.0673 11.5553 14.4771 11.7272C14.3882 11.9849 14.2944 12.2318 14.1947 12.4689ZM11.1073 0.320091C11.1073 1.12027 10.815 1.8674 10.2323 2.55894C9.52912 3.38103 8.67858 3.85608 7.75624 3.78112C7.74449 3.68512 7.73767 3.58409 7.73767 3.47792C7.73767 2.70975 8.07208 1.88765 8.66594 1.21547C8.96242 0.875136 9.3395 0.592152 9.79677 0.36641C10.2531 0.144037 10.6846 0.0210594 11.0906 0C11.1024 0.106972 11.1073 0.213961 11.1073 0.320091Z" fill="var(--svg-fill-black)"/></svg>',
    "arrow-left-right": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M5.77523 1.55806C6.01931 1.80214 6.01931 2.19786 5.77523 2.44194L4.17567 4.0415H13.3333C13.6785 4.0415 13.9583 4.32133 13.9583 4.6665C13.9583 5.01168 13.6785 5.2915 13.3333 5.2915H4.17535L5.77523 6.89139C6.01931 7.13547 6.01931 7.5312 5.77523 7.77528C5.53116 8.01935 5.13543 8.01935 4.89135 7.77528L2.22468 5.10861C2.14776 5.03168 2.09508 4.93969 2.06664 4.84213C2.05036 4.78642 2.04163 4.72748 2.04163 4.6665C2.04163 4.48959 2.11513 4.32984 2.23327 4.21614L4.89135 1.55806C5.13543 1.31398 5.53116 1.31398 5.77523 1.55806ZM10.2247 8.22456C10.4688 7.98048 10.8645 7.98048 11.1086 8.22456L13.7752 10.8912C13.8672 10.9832 13.9246 11.0968 13.9472 11.2156C13.9546 11.2544 13.9583 11.2938 13.9583 11.3332L13.9583 11.3335C13.9583 11.5122 13.8833 11.6734 13.763 11.7873L11.1086 14.4418C10.8645 14.6859 10.4688 14.6859 10.2247 14.4418C9.98061 14.1977 9.98061 13.802 10.2247 13.5579L11.8241 11.9585H2.66663C2.32145 11.9585 2.04163 11.6787 2.04163 11.3335C2.04163 10.9883 2.32145 10.7085 2.66663 10.7085H11.8247L10.2247 9.10845C9.98061 8.86437 9.98061 8.46864 10.2247 8.22456Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "audio 40": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M9.5 0H3.5C2.675 0 2.0075 0.72 2.0075 1.6L2 14.4C2 15.28 2.6675 16 3.4925 16H12.5C13.325 16 14 15.28 14 14.4V4.8L9.5 0Z" fill="var(--svg-fill-2C98F0)"/><path d="M5.53857 10.1212C5.53857 9.17107 6.33265 8.40407 7.31635 8.40407C7.52376 8.40407 7.72524 8.44414 7.90894 8.5071V4.96973H10.8719V6.11451H9.09413V10.1384C9.08228 11.0771 8.29413 11.8384 7.31635 11.8384C6.33265 11.8384 5.53857 11.0714 5.53857 10.1212Z" fill="var(--svg-fill-BBDEFB)"/></svg>',
    "auto-off": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="16" r="13.5" fill="var(--svg-fill-F0F0F0)" stroke="var(--svg-stroke-5884D0)" stroke-width="3"/><path d="M15 5H17L16 8L15 5Z" fill="var(--svg-fill-A4A4A4)"/><path d="M15 27H17L16 24L15 27Z" fill="var(--svg-fill-A4A4A4)"/><path d="M14.5 16.5L15.5 18.5L23.8995 8.70711L14.5 16.5Z" fill="var(--svg-fill-757575)"/><path d="M15.5 18.5L16.9142 17.0711L9.13604 10.7071L15.5 18.5Z" fill="var(--svg-fill-D3592E)"/><path d="M5 17L5 15L8 16L5 17Z" fill="var(--svg-fill-A4A4A4)"/><path d="M27 17L27 15L24 16L27 17Z" fill="var(--svg-fill-A4A4A4)"/></svg>',
    "auto-on": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="16" r="13.5" fill="var(--svg-fill-F0F0F0)" stroke="var(--svg-stroke-5884D0)" stroke-width="3"/><path d="M15 5H17L16 8L15 5Z" fill="var(--svg-fill-A4A4A4)"/><path d="M15 27H17L16 24L15 27Z" fill="var(--svg-fill-A4A4A4)"/><path d="M14.5 16.5L15.5 18.5L23.8995 8.70711L14.5 16.5Z" fill="var(--svg-fill-757575)"/><path d="M15.5 18.5L16.9142 17.0711L9.13604 10.7071L15.5 18.5Z" fill="var(--svg-fill-D3592E)"/><path d="M5 17L5 15L8 16L5 17Z" fill="var(--svg-fill-A4A4A4)"/><path d="M27 17L27 15L24 16L27 17Z" fill="var(--svg-fill-A4A4A4)"/><circle cx="28" cy="8" r="5" fill="var(--svg-fill-4FB633)" stroke="var(--svg-stroke-white)" stroke-width="2"/></svg>',
    "auto-run-off": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><g clip-path="url(#clip0_4413_20138)"><circle cx="16" cy="16" r="13.5" fill="var(--svg-fill-F0F0F0)" stroke="var(--svg-stroke-5884D0)" stroke-width="3"/><path d="M15 5H17L16 8L15 5Z" fill="var(--svg-fill-A4A4A4)"/><path d="M15 27H17L16 24L15 27Z" fill="var(--svg-fill-A4A4A4)"/><path d="M14.5 16.5L15.5 18.5L23.8995 8.70711L14.5 16.5Z" fill="var(--svg-fill-757575)"/><path d="M15.5 18.5L16.9142 17.0711L9.13604 10.7071L15.5 18.5Z" fill="var(--svg-fill-757575)"/><path d="M5 17L5 15L8 16L5 17Z" fill="var(--svg-fill-A4A4A4)"/><path d="M27 17L27 15L24 16L27 17Z" fill="var(--svg-fill-A4A4A4)"/><rect x="22.5" y="23" width="9" height="9" rx="2" fill="var(--svg-fill-020204)" stroke="var(--svg-stroke-white)"/><rect x="22.5" y="14" width="9" height="9" rx="2" fill="var(--svg-fill-D3592E)" stroke="var(--svg-stroke-white)"/></g><defs><clipPath id="clip0_4413_20138"><rect width="32" height="32" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "auto-run-on": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><g clip-path="url(#clip0_4413_20135)"><circle cx="16" cy="16" r="13.5" fill="var(--svg-fill-F0F0F0)" stroke="var(--svg-stroke-5884D0)" stroke-width="3"/><path d="M15 5H17L16 8L15 5Z" fill="var(--svg-fill-A4A4A4)"/><path d="M15 27H17L16 24L15 27Z" fill="var(--svg-fill-A4A4A4)"/><path d="M14.5 16.5L15.5 18.5L23.8995 8.70711L14.5 16.5Z" fill="var(--svg-fill-757575)"/><path d="M15.5 18.5L16.9142 17.0711L9.13604 10.7071L15.5 18.5Z" fill="var(--svg-fill-D3592E)"/><path d="M5 17L5 15L8 16L5 17Z" fill="var(--svg-fill-A4A4A4)"/><path d="M27 17L27 15L24 16L27 17Z" fill="var(--svg-fill-A4A4A4)"/><rect x="22.5" y="23" width="9" height="9" rx="2" fill="var(--svg-fill-4FB633)" stroke="var(--svg-stroke-white)"/><rect x="22.5" y="14" width="9" height="9" rx="2" fill="var(--svg-fill-020204)" stroke="var(--svg-stroke-white)"/></g><defs><clipPath id="clip0_4413_20135"><rect width="32" height="32" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "bookmark": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M7.07461 2.25944C7.41372 1.43145 8.58628 1.43145 8.92539 2.25944L10.2744 5.55309L13.7801 5.89498C14.6395 5.97878 14.9959 7.03898 14.3616 7.62483L11.68 10.1018L12.4496 13.6922C12.6347 14.5557 11.6913 15.2177 10.9422 14.75L8 12.9131L5.05779 14.75C4.30866 15.2177 3.36531 14.5557 3.55041 13.6922L4.32 10.1018L1.63839 7.62483C1.00415 7.03898 1.36052 5.97878 2.21986 5.89498L5.72564 5.55309L7.07461 2.25944Z" fill="var(--svg-fill-FFB800)"/></svg>',
    "change-account-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.08671 8.99908C8.05788 8.99969 8.02898 9 8 9C5.79086 9 4 7.20914 4 5C4 2.79086 5.79086 1 8 1C10.2091 1 12 2.79086 12 5C12 6.29779 11.3819 7.45123 10.4241 8.18203C9.85511 7.87215 9.12786 7.95792 8.64644 8.43934L8.08671 8.99908ZM7.08578 10H6C3.23858 10 1 12.2386 1 15H10C9.5 15 9 15 8.64644 14.5607L5.58578 11.5L6.64648 10.4393L7.08578 10Z" fill="var(--svg-fill-689DDE)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M8.08671 8.99908C8.05788 8.99969 8.02898 9 8 9C5.79086 9 4 7.20914 4 5C4 2.79086 5.79086 1 8 1C10.2091 1 12 2.79086 12 5C12 6.29779 11.3819 7.45123 10.4241 8.18203C9.85511 7.87215 9.12786 7.95792 8.64644 8.43934L8.08671 8.99908ZM7.08578 10H6C3.58104 10 1.56329 11.7178 1.10002 14C1.03443 14.3231 1 14.6575 1 15H10C9.5 15 9 15 8.64644 14.5607L8.08579 14H2.12602C2.57006 12.2748 4.13616 11 6 11H6.08578L6.64648 10.4393L7.08578 10ZM11 5C11 6.65685 9.65685 8 8 8C6.34315 8 5 6.65685 5 5C5 3.34315 6.34315 2 8 2C9.65685 2 11 3.34315 11 5Z" fill="var(--svg-fill-225BA1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M10.0607 9.14645C9.8654 8.95118 9.54882 8.95118 9.35355 9.14645L7.35355 11.1464L7.35329 11.1467L7 11.5L7.35355 11.8536L7.35388 11.8539L9.35355 13.8536C9.54882 14.0488 9.8654 14.0488 10.0607 13.8536C10.2559 13.6583 10.2559 13.3417 10.0607 13.1464L8.91421 12H11.7071C11.9832 12 12.2071 11.7761 12.2071 11.5C12.2071 11.2239 11.9832 11 11.7071 11H8.91421L10.0607 9.85355C10.2559 9.65829 10.2559 9.34171 10.0607 9.14645ZM12.9393 11.1464C13.1346 10.9512 13.4512 10.9512 13.6464 11.1464L15.6464 13.1464L15.6467 13.1467L16 13.5L15.6464 13.8536L15.6461 13.8539L13.6464 15.8536C13.4512 16.0488 13.1346 16.0488 12.9393 15.8536C12.7441 15.6583 12.7441 15.3417 12.9393 15.1464L14.0858 14H11.2929C11.0168 14 10.7929 13.7761 10.7929 13.5C10.7929 13.2239 11.0168 13 11.2929 13H14.0858L12.9393 11.8536C12.7441 11.6583 12.7441 11.3417 12.9393 11.1464Z" fill="var(--svg-fill-6F6F6F)"/></svg>',
    "changes16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M10.5 11.5518V9.5H5.5V11.552C5.5 12.0865 4.85371 12.3542 4.47574 11.9762L0.924263 8.42475C0.689949 8.19044 0.689949 7.81054 0.924264 7.57622L4.47574 4.02475C4.85372 3.64677 5.5 3.91447 5.5 4.44902V6.5H10.5V4.44886C10.5 3.91432 11.1463 3.64662 11.5243 4.02459L15.0757 7.57607C15.31 7.81038 15.31 8.19028 15.0757 8.42459L11.5243 11.9761C11.1463 12.354 10.5 12.0863 10.5 11.5518Z" fill="var(--svg-fill-31A629)"/><path d="M10.5 9.5V9C10.7761 9 11 9.22386 11 9.5H10.5ZM5.5 9.5H5C5 9.22386 5.22386 9 5.5 9V9.5ZM4.47574 11.9762L4.82929 11.6227L4.47574 11.9762ZM0.924263 8.42475L0.570709 8.77831V8.7783L0.924263 8.42475ZM0.924264 7.57622L1.27782 7.92978V7.92978L0.924264 7.57622ZM4.47574 4.02475L4.12218 3.6712V3.6712L4.47574 4.02475ZM5.5 6.5V7C5.22386 7 5 6.77614 5 6.5H5.5ZM10.5 6.5H11C11 6.77614 10.7761 7 10.5 7V6.5ZM11.5243 4.02459L11.8778 3.67104V3.67104L11.5243 4.02459ZM15.0757 7.57607L14.7222 7.92962L15.0757 7.57607ZM15.0757 8.42459L14.7222 8.07104L15.0757 8.42459ZM11.5243 11.9761L11.8778 12.3296L11.5243 11.9761ZM11 9.5V11.5518H9.99999V9.5H11ZM5.5 9H10.5V10H5.5V9ZM5 11.552V9.5H6V11.552H5ZM4.82929 11.6227C4.85001 11.6434 4.86726 11.6496 4.88058 11.6519C4.89664 11.6547 4.9171 11.6531 4.93827 11.6443C4.95944 11.6356 4.97501 11.6222 4.9844 11.6089C4.99219 11.5978 5 11.5813 5 11.552H6C6 12.532 4.81514 13.0227 4.12218 12.3298L4.82929 11.6227ZM1.27782 8.0712L4.82929 11.6227L4.12218 12.3298L0.570709 8.77831L1.27782 8.0712ZM1.27782 7.92978C1.23876 7.96883 1.23876 8.03215 1.27782 8.0712L0.570709 8.7783C0.141133 8.34873 0.141133 7.65225 0.570711 7.22267L1.27782 7.92978ZM4.82929 4.3783L1.27782 7.92978L0.57071 7.22267L4.12218 3.6712L4.82929 4.3783ZM5 4.44902C5 4.41971 4.99219 4.40313 4.9844 4.39208C4.97501 4.37875 4.95944 4.3654 4.93827 4.35663C4.9171 4.34786 4.89664 4.34629 4.88058 4.34908C4.86726 4.35138 4.85001 4.35758 4.82929 4.37831L4.12218 3.6712C4.81515 2.97824 6 3.46902 6 4.44902H5ZM5 6.5V4.44902H6V6.5H5ZM10.5 7H5.5V6H10.5V7ZM11 4.44886V6.5H9.99999V4.44886H11ZM11.1707 4.37815C11.15 4.35742 11.1327 4.35123 11.1194 4.34892C11.1034 4.34614 11.0829 4.3477 11.0617 4.35647C11.0406 4.36524 11.025 4.3786 11.0156 4.39192C11.0078 4.40298 11 4.41955 11 4.44886H9.99999C9.99999 3.46887 11.1848 2.97808 11.8778 3.67104L11.1707 4.37815ZM14.7222 7.92962L11.1707 4.37815L11.8778 3.67104L15.4293 7.22251L14.7222 7.92962ZM14.7222 8.07104C14.7612 8.03199 14.7612 7.96867 14.7222 7.92962L15.4293 7.22251C15.8589 7.65209 15.8589 8.34857 15.4293 8.77815L14.7222 8.07104ZM11.1707 11.6225L14.7222 8.07104L15.4293 8.77815L11.8778 12.3296L11.1707 11.6225ZM11 11.5518C11 11.5811 11.0078 11.5977 11.0156 11.6087C11.025 11.6221 11.0406 11.6354 11.0617 11.6442C11.0829 11.653 11.1034 11.6545 11.1194 11.6517C11.1327 11.6494 11.15 11.6432 11.1707 11.6225L11.8778 12.3296C11.1848 13.0226 9.99999 12.5318 9.99999 11.5518H11Z" fill="var(--svg-fill-31A629)"/></svg>',
    "checkbox-false": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="4" y="5" width="8" height="8" stroke="var(--svg-stroke-7F848D)" rx="2" ry="2"/></svg>',
    "checkbox-true": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="4" y="5" width="8" height="8" stroke="var(--svg-stroke-7F848D)" rx="2" ry="2"/><path stroke-width="2" stroke="var(--svg-stroke-32A5FF)" d="M2 5 A 12 12 0 0 1 8 11 A 12 12 0 0 1 14 1" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "chevron-down": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M4 6L8 10L12 6" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "chevron-left": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M10 12L6 8L10 4" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "chevron-right": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M6 12L10 8L6 4" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "chevron-up": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M12 10L8 6L4 10" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "circle-green": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.00004 14.6668C11.6819 14.6668 14.6667 11.6821 14.6667 8.00016C14.6667 4.31826 11.6819 1.3335 8.00004 1.3335C4.31814 1.3335 1.33337 4.31826 1.33337 8.00016C1.33337 11.6821 4.31814 14.6668 8.00004 14.6668Z" fill="var(--svg-fill-31A629)"/></svg>',
    "circle-grey": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.00004 14.6668C11.6819 14.6668 14.6667 11.6821 14.6667 8.00016C14.6667 4.31826 11.6819 1.3335 8.00004 1.3335C4.31814 1.3335 1.33337 4.31826 1.33337 8.00016C1.33337 11.6821 4.31814 14.6668 8.00004 14.6668Z" fill="var(--svg-fill-838789)"/></svg>',
    "circle-outline": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6320_365)"><path d="M7.99992 14.6668C11.6818 14.6668 14.6666 11.6821 14.6666 8.00016C14.6666 4.31826 11.6818 1.3335 7.99992 1.3335C4.31802 1.3335 1.33325 4.31826 1.33325 8.00016C1.33325 11.6821 4.31802 14.6668 7.99992 14.6668Z" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></g><defs><clipPath id="clip0_6320_365"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "clear": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M5.20034 14.1087H2.99324L1.72547 12.8409C1.13969 12.2551 1.13969 11.3054 1.72547 10.7196L10.2108 2.23426C10.7966 1.64847 11.7463 1.64847 12.3321 2.23426L13.7463 3.64847C14.3321 4.23426 14.3321 5.18401 13.7463 5.76979L5.55389 13.9622C5.46012 14.056 5.33295 14.1087 5.20034 14.1087Z" stroke="var(--svg-stroke-7F848D)"/><path d="M5.6145 6.12334L9.85714 1.8807C10.6382 1.09966 11.9045 1.09966 12.6856 1.8807L14.0998 3.29492C14.8808 4.07597 14.8808 5.3423 14.0998 6.12334L9.85714 10.3659L5.6145 6.12334Z" fill="var(--svg-fill-7F848D)"/><path d="M9 14H15" stroke="var(--svg-stroke-7F848D)" stroke-linecap="round"/></svg>',
    "clock": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24ZM12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21Z" fill="var(--svg-fill-7F848D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M10 6H13V11.719L17.3602 14.7712L15.6398 17.2288L10 13.281V6Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "Connection": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M1 5H17V16H1V5ZM0 17V4H18V17H10V18H14V19H4V18H8V17H0ZM23 6V18H16V19H23H24V18V6V5H23H19V6H23ZM22 8H19V9H22V8ZM19 10H22V11H19V10Z" fill="var(--svg-fill-7F848D)"/><path d="M1 5H17V16H1V5Z" fill="var(--svg-fill-33D5FF)"/></svg>',
    "copy": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M4.5 3 C4.5 1.5, 5 0.5, 6.5 0.5 H13.5 C15 0.5 15.5 1.5 15.5 3 V11.5 C15.5 13, 14 13.5, 13.5 13.5 H11.5" stroke="var(--svg-stroke-7F848D)" stroke-width="1" /><rect x="0.5" y="2.5" width="11" height="13" rx="2" ry="2" stroke="var(--svg-stroke-6890D9)" stroke-width="1" /></svg>',
    "cut": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="12" cy="13" r="2.5" stroke="var(--svg-stroke-7F848D)"/><circle cx="4" cy="13" r="2.5" stroke="var(--svg-stroke-32A5FF)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M8.55471 6.38929L5.95489 10.8923L5.08887 10.3923L7.97736 5.38929L8.55471 6.38929ZM9.13206 5.38929L11.9549 0.5L11.0889 0L8.55471 4.38929L9.13206 5.38929Z" fill="var(--svg-fill-32A5FF)"/><path d="M4.86597 0L3.99994 0.5L9.99994 10.8923L10.866 10.3923L4.86597 0Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "C_Dis_Cir": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="8" cy="8" r="5.5" stroke="var(--svg-stroke-7F848D)"/></svg>',
    "C_Dis_Cir_Fil": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="8" cy="8" r="6" fill="var(--svg-fill-7F848D)"/></svg>',
    "C_Dis_Eql_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" y="2" width="12" height="5" rx="2" fill="var(--svg-fill-7F848D)"/><rect x="2" y="9" width="12" height="5" rx="2" fill="var(--svg-fill-7F848D)"/></svg>',
    "C_Dis_Nop_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" y="14" width="12" height="5" rx="2" transform="rotate(-90 2 14)" fill="var(--svg-fill-7F848D)"/><rect x="9" y="14" width="12" height="5" rx="2" transform="rotate(-90 9 14)" fill="var(--svg-fill-7F848D)"/></svg>',
    "C_Dis_Que_Fil": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M6.09094 10.3637V10.091C6.09094 9.46595 6.14019 8.96785 6.23867 8.59664C6.33715 8.22542 6.48299 7.92807 6.67617 7.70459C6.86935 7.47732 7.10609 7.27277 7.3864 7.09095C7.62882 6.93186 7.84473 6.77845 8.03412 6.63073C8.22731 6.483 8.37882 6.3258 8.48867 6.15914C8.60231 5.99247 8.65912 5.80308 8.65912 5.59095C8.65912 5.40156 8.61367 5.23489 8.52276 5.09095C8.43185 4.94701 8.30875 4.83527 8.15344 4.75573C7.99814 4.67618 7.82579 4.63641 7.6364 4.63641C7.43185 4.63641 7.24246 4.68376 7.06822 4.77845C6.89776 4.87315 6.7595 5.00383 6.65344 5.1705C6.55117 5.33717 6.50003 5.53035 6.50003 5.75004H3.59094C3.59852 4.91671 3.78791 4.24058 4.15912 3.72164C4.53034 3.19891 5.02276 2.81633 5.6364 2.57391C6.25003 2.3277 6.92428 2.20459 7.65912 2.20459C8.46973 2.20459 9.19322 2.32391 9.82958 2.56254C10.4659 2.79739 10.9678 3.15345 11.3353 3.63073C11.7027 4.10421 11.8864 4.69701 11.8864 5.40914C11.8864 5.86747 11.8069 6.27088 11.6478 6.61936C11.4925 6.96406 11.2747 7.26898 10.9944 7.53414C10.7178 7.7955 10.394 8.03414 10.0228 8.25004C9.75003 8.40914 9.52087 8.57391 9.33526 8.74436C9.14965 8.91103 9.0095 9.10232 8.91481 9.31823C8.82011 9.53035 8.77276 9.78792 8.77276 10.091V10.3637H6.09094ZM7.47731 14.1819C7.03791 14.1819 6.66102 14.0285 6.34662 13.7216C6.03602 13.411 5.88261 13.0341 5.8864 12.591C5.88261 12.1591 6.03602 11.7898 6.34662 11.483C6.66102 11.1762 7.03791 11.0228 7.47731 11.0228C7.89397 11.0228 8.2614 11.1762 8.57958 11.483C8.90155 11.7898 9.06443 12.1591 9.06822 12.591C9.06443 12.8864 8.98678 13.1553 8.83526 13.3978C8.68753 13.6364 8.49435 13.8277 8.25572 13.9716C8.01708 14.1118 7.75761 14.1819 7.47731 14.1819Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "C_Dis_Tsh": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" y="2" width="12" height="5" rx="2" fill="var(--svg-fill-7F848D)"/><rect x="2.5" y="9.5" width="11" height="4" rx="1.5" stroke="var(--svg-stroke-7F848D)"/></svg>',
    "C_Ena_Att_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="8" cy="8" r="7" stroke="var(--svg-stroke-F0483F)" stroke-width="1.5" /><path d="M8 4 V9"  stroke="var(--svg-stroke-F0483F)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><circle cx="8" cy="12" r="1" fill="var(--svg-fill-F0483F)" /></svg>',
    "C_Ena_Att_Fill1": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M9.43189 2.36377L9.13643 10.3638H6.54552L6.25007 2.36377H9.43189ZM7.84098 14.182C7.40158 14.182 7.02469 14.0285 6.7103 13.7217C6.39969 13.4111 6.24628 13.0342 6.25007 12.591C6.24628 12.1592 6.39969 11.7899 6.7103 11.4831C7.02469 11.1763 7.40158 11.0229 7.84098 11.0229C8.25764 11.0229 8.62507 11.1763 8.94325 11.4831C9.26522 11.7899 9.4281 12.1592 9.43189 12.591C9.4281 12.8865 9.35045 13.1554 9.19893 13.3979C9.0512 13.6365 8.85802 13.8278 8.61939 13.9717C8.38075 14.1119 8.12128 14.182 7.84098 14.182Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "C_Ena_Chk": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M7.50011 8.37879L12.2323 3.64656C12.6229 3.25604 13.256 3.25604 13.6466 3.64656L14.3537 4.35367C14.7442 4.74419 14.7442 5.37736 14.3537 5.76788L8.20722 11.9143C7.8167 12.3049 7.18353 12.3049 6.79301 11.9143L2.64656 7.76788C2.25604 7.37736 2.25604 6.74419 2.64656 6.35367L3.35367 5.64656C3.74419 5.25604 4.37736 5.25603 4.76788 5.64656L7.50011 8.37879Z" fill="var(--svg-fill-31A629)"/></svg>',
    "C_Ena_Cir": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="8" cy="8" r="5.25" stroke="var(--svg-stroke-31A629)" stroke-width="1.5"/></svg>',
    "C_Ena_Cir_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="8" cy="8" r="6" fill="var(--svg-fill-31A629)"/></svg>',
    "C_Ena_Eql_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="8" cy="8" r="5.25" stroke="var(--svg-stroke-7F848D)" fill="var(--svg-fill-C5C5C5)" stroke-width="1.5"/></svg>',
    "C_Ena_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" y="2" width="12" height="5" rx="2" fill="var(--svg-fill-31A629)"/><rect x="2.5" y="9.5" width="12" height="5" rx="2" fill="var(--svg-fill-31A629)"/></svg>',
    "C_Ena_Nop_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" y="14" width="12" height="5" rx="2" transform="rotate(-90 2 14)" fill="var(--svg-fill-31A629)"/><rect x="9" y="14" width="12" height="5" rx="2" transform="rotate(-90 9 14)" fill="var(--svg-fill-31A629)"/></svg>',
    "C_Ena_Que_Fil": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><circle cx="8" cy="8" r="7" stroke="var(--svg-stroke-F0483F)" stroke-width="1.5" /><path d="M6 6 C6 3.5 10 3.5 10 6 C10 8 8 7.5 8 9.5"  stroke="var(--svg-stroke-F0483F)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/><circle cx="8" cy="12" r="1" fill="var(--svg-fill-F0483F)" /></svg>',
    "C_Ena_Que_Fil1": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M6.09082 10.3637V10.091C6.09082 9.46595 6.14006 8.96785 6.23855 8.59664C6.33703 8.22542 6.48287 7.92807 6.67605 7.70459C6.86923 7.47732 7.10597 7.27277 7.38628 7.09095C7.6287 6.93186 7.84461 6.77845 8.034 6.63073C8.22718 6.483 8.3787 6.3258 8.48855 6.15914C8.60218 5.99247 8.659 5.80308 8.659 5.59095C8.659 5.40156 8.61355 5.23489 8.52264 5.09095C8.43173 4.94701 8.30862 4.83527 8.15332 4.75573C7.99802 4.67618 7.82567 4.63641 7.63628 4.63641C7.43173 4.63641 7.24234 4.68376 7.06809 4.77845C6.89764 4.87315 6.75938 5.00383 6.65332 5.1705C6.55105 5.33717 6.49991 5.53035 6.49991 5.75004H3.59082C3.5984 4.91671 3.78779 4.24058 4.159 3.72164C4.53021 3.19891 5.02264 2.81633 5.63627 2.57391C6.24991 2.3277 6.92415 2.20459 7.659 2.20459C8.46961 2.20459 9.19309 2.32391 9.82946 2.56254C10.4658 2.79739 10.9677 3.15345 11.3351 3.63073C11.7026 4.10421 11.8863 4.69701 11.8863 5.40914C11.8863 5.86747 11.8067 6.27088 11.6476 6.61936C11.4923 6.96406 11.2745 7.26898 10.9942 7.53414C10.7177 7.7955 10.3939 8.03414 10.0226 8.25004C9.74991 8.40914 9.52074 8.57391 9.33514 8.74436C9.14953 8.91103 9.00938 9.10232 8.91468 9.31823C8.81999 9.53035 8.77264 9.78792 8.77264 10.091V10.3637H6.09082ZM7.47718 14.1819C7.03779 14.1819 6.6609 14.0285 6.3465 13.7216C6.0359 13.411 5.88249 13.0341 5.88627 12.591C5.88249 12.1591 6.0359 11.7898 6.3465 11.483C6.6609 11.1762 7.03779 11.0228 7.47718 11.0228C7.89385 11.0228 8.26128 11.1762 8.57946 11.483C8.90143 11.7898 9.06431 12.1591 9.06809 12.591C9.06431 12.8864 8.98665 13.1553 8.83514 13.3978C8.68741 13.6364 8.49423 13.8277 8.25559 13.9716C8.01696 14.1118 7.75749 14.1819 7.47718 14.1819Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "C_Ena_Tsh": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" y="2" width="12" height="5" rx="2" fill="var(--svg-fill-31A629)"/><rect x="2.5" y="9.5" width="11" height="4" rx="1.5" stroke="var(--svg-stroke-31A629)"/></svg>',
    "C_Syncing": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M4.1993 4.1993C5.20703 3.19157 6.57371 2.62531 7.99882 2.625C9.51276 2.631 10.9659 3.2212 12.0552 4.27242L12.4911 4.70833H10.6667C10.3216 4.70833 10.0417 4.98816 10.0417 5.33333C10.0417 5.67851 10.3216 5.95833 10.6667 5.95833H14H14.0001C14.1031 5.95833 14.2003 5.93342 14.2859 5.88928C14.3131 5.8753 14.3395 5.85918 14.3648 5.84095C14.5224 5.72748 14.6251 5.5424 14.6251 5.33333V2C14.6251 1.65482 14.3453 1.375 14.0001 1.375C13.6549 1.375 13.3751 1.65482 13.3751 2V3.82453L12.9353 3.38472L12.9353 3.38466L12.9277 3.37731C11.6058 2.09936 9.841 1.38192 8.00235 1.375V1.375H8C6.24294 1.375 4.55785 2.07299 3.31542 3.31542C2.07299 4.55785 1.375 6.24294 1.375 8C1.375 8.34518 1.65482 8.625 2 8.625C2.34518 8.625 2.625 8.34518 2.625 8C2.625 6.57446 3.19129 5.20731 4.1993 4.1993ZM14 7.375C14.3452 7.375 14.625 7.65482 14.625 8C14.625 9.75706 13.927 11.4422 12.6846 12.6846C11.4422 13.927 9.75706 14.625 8 14.625H7.99765C6.159 14.6181 4.3942 13.9006 3.07226 12.6227L3.06466 12.6153L3.06473 12.6153L2.625 12.1756V13.9998C2.625 14.345 2.34518 14.6248 2 14.6248C1.65482 14.6248 1.375 14.345 1.375 13.9998V10.6667V10.6665C1.375 10.3213 1.65482 10.0415 2 10.0415H5.33333C5.67851 10.0415 5.95833 10.3213 5.95833 10.6665C5.95833 11.0117 5.67851 11.2915 5.33333 11.2915H3.50872L3.94477 11.7276C5.03408 12.7788 6.48718 13.369 8.00109 13.375C9.42624 13.3747 10.7929 12.8084 11.8007 11.8007C12.8087 10.7927 13.375 9.42554 13.375 8C13.375 7.65482 13.6548 7.375 14 7.375Z" fill="var(--svg-fill-31A629)"/></svg>',
    "delete": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="0" y="0" width="16" height="16" stroke="var(--svg-stroke-green)" stroke-width="0.25"/><path d="M4 3 V13 C4 15 4 15 6 15 H10 C12 15 12 15 12 13 V3" stroke="var(--svg-stroke-7F848D)" stroke-width="1"/><path d="M6.5 5 V13 M9.5 5 V13" stroke="var(--svg-stroke-7F848D)" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 3 H14 M6 3 C6 2 6 1 7 1 H9 C10 1 10 2 10 3" stroke="var(--svg-stroke-6890D9)" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "download": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M2 10V13C2 14.1046 2.89543 15 4 15H12C13.1046 15 14 14.1046 14 13V10" stroke="var(--svg-stroke-7F848D)" stroke-linecap="round"/><rect x="0.5" y="-0.5" width="1" height="7" rx="0.5" transform="matrix(1 0 0 -1 7 9)" fill="var(--svg-fill-31A629)" stroke="var(--svg-stroke-31A629)"/><path d="M4 7L8 11L12 7" stroke="var(--svg-stroke-31A629)" stroke-width="2" stroke-linecap="round"/></svg>',
    "edit-url-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.81501 10.3506L5.8212 13.3444C4.94704 14.2185 3.52976 14.2185 2.65561 13.3444C1.78146 12.4702 1.78146 11.053 2.65561 10.1788L5.64943 7.18499L4.94232 6.47788L1.94851 9.4717C0.683831 10.7364 0.683831 12.7868 1.94851 14.0515C3.21318 15.3162 5.26363 15.3162 6.5283 14.0515L9.52211 11.0577L8.81501 10.3506ZM10.3505 8.81504L11.0576 9.52215L14.0515 6.5283C15.3162 5.26362 15.3162 3.21318 14.0515 1.94851C12.7868 0.68383 10.7364 0.683832 9.4717 1.94851L6.47785 4.94235L7.18496 5.64946L10.1788 2.65561C11.053 1.78146 12.4702 1.78146 13.3444 2.65561C14.2185 3.52976 14.2185 4.94704 13.3444 5.82119L10.3505 8.81504Z" fill="var(--svg-fill-black)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M5 10.3674L10.3674 5L11 5.63256L5.63256 11L5 10.3674Z" fill="var(--svg-fill-black)"/></svg>',
    "error": '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" ><path d="M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18Z" fill="var(--svg-fill-F0483F)"/><path d="M7 7L13 13" stroke="var(--svg-stroke-white)" stroke-width="1.25" stroke-linecap="round"/><path d="M7 13L13 7" stroke="var(--svg-stroke-white)" stroke-width="1.25" stroke-linecap="round"/></svg>',
    "ex4-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-3F3F40)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="url(#paint0_linear_6202_13743)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-white)" fill-opacity="0.3"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-6E747E)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" stroke="var(--svg-stroke-black)"/><rect width="10" height="5" transform="matrix(1 0 0 -1 3 6)" fill="var(--svg-fill-171717)"/><rect width="10" height="5" transform="matrix(1 0 0 -1 3 6)" fill="var(--svg-fill-32353A)"/><rect x="6" y="7" width="2" height="8" fill="var(--svg-fill-999FA9)"/><rect x="4" y="7" width="2" height="8" fill="var(--svg-fill-999FA9)"/><rect x="8" y="7" width="2" height="8" fill="var(--svg-fill-999FA9)"/><rect x="10" y="7" width="2" height="8" fill="var(--svg-fill-999FA9)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 5 12)" fill="var(--svg-fill-393939)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 5 12)" fill="var(--svg-fill-AFB2B9)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 7 12)" fill="var(--svg-fill-393939)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 7 12)" fill="var(--svg-fill-AFB2B9)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 9 12)" fill="var(--svg-fill-393939)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 9 12)" fill="var(--svg-fill-AFB2B9)"/><circle cx="3.5" cy="2.5" r="0.5" fill="var(--svg-fill-2B99CA)"/><rect x="9" y="5" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="7" y="5" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="5" y="5" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="11" y="5" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="5" y="2" width="6" height="2" fill="var(--svg-fill-0066FF)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 11 12)" fill="var(--svg-fill-393939)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 11 12)" fill="var(--svg-fill-AFB2B9)"/><defs><linearGradient id="paint0_linear_6202_13743" x1="2" y1="5.25" x2="14" y2="5.25" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-131313)"/><stop offset="0.182292" stop-color="var(--svg-stop-color-333335)"/><stop offset="0.875" stop-color="var(--svg-stop-color-3D3D3F)"/><stop offset="0.9375" stop-color="var(--svg-stop-color-737375)"/><stop offset="1" stop-color="var(--svg-stop-color-323234)"/></linearGradient></defs></svg>',
    "filter": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M14.6666 2H1.33325L6.66659 8.30667V12.6667L9.33325 14V8.30667L14.6666 2Z" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M4.5 3.5 H11.5 L8 7.5Z" fill="var(--svg-fill-6890D9)"/></svg>',
    "Filters_minus": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M0.766312 1.73695C0.868723 1.51622 1.08993 1.375 1.33326 1.375H14.6666C14.9099 1.375 15.1311 1.51622 15.2335 1.73695C15.336 1.95768 15.3009 2.21778 15.1438 2.40358L9.95826 8.53551V8.78605C9.46026 9.12753 9.03441 9.56656 8.70826 10.0756V8.30667C8.70826 8.1589 8.76061 8.01592 8.85603 7.90309L13.3195 2.625H2.68033L7.14382 7.90309C7.23924 8.01592 7.29159 8.1589 7.29159 8.30667V12.2804L8.002 12.6356C8.01832 13.187 8.13382 13.7134 8.33128 14.1978L6.38708 13.2257C6.17534 13.1198 6.04159 12.9034 6.04159 12.6667V8.53551L0.856029 2.40358C0.698906 2.21778 0.6639 1.95768 0.766312 1.73695ZM12.5 16C14.433 16 16 14.433 16 12.5C16 10.567 14.433 9 12.5 9C10.567 9 9 10.567 9 12.5C9 14.433 10.567 16 12.5 16ZM10.2331 12.5277C10.2331 12.2516 10.457 12.0277 10.7331 12.0277H14.3227C14.5989 12.0277 14.8227 12.2516 14.8227 12.5277C14.8227 12.8039 14.5989 13.0277 14.3227 13.0277H10.7331C10.457 13.0277 10.2331 12.8039 10.2331 12.5277Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "Filters_plus": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M0.766312 1.73695C0.868723 1.51622 1.08993 1.375 1.33326 1.375H14.6666C14.9099 1.375 15.1311 1.51622 15.2335 1.73695C15.336 1.95768 15.3009 2.21778 15.1438 2.40358L9.95826 8.53551V8.78605C9.46026 9.12753 9.03441 9.56656 8.70826 10.0756V8.30667C8.70826 8.1589 8.76061 8.01592 8.85603 7.90309L13.3195 2.625H2.68033L7.14382 7.90309C7.23924 8.01592 7.29159 8.1589 7.29159 8.30667V12.2804L8.002 12.6356C8.01832 13.187 8.13382 13.7134 8.33128 14.1978L6.38708 13.2257C6.17534 13.1198 6.04159 12.9034 6.04159 12.6667V8.53551L0.856029 2.40358C0.698906 2.21778 0.6639 1.95768 0.766312 1.73695ZM12.5 16C14.433 16 16 14.433 16 12.5C16 10.567 14.433 9 12.5 9C10.567 9 9 10.567 9 12.5C9 14.433 10.567 16 12.5 16ZM12.0278 14.3224C12.0278 14.5986 12.2517 14.8224 12.5278 14.8224C12.8039 14.8224 13.0278 14.5986 13.0278 14.3224L13.0278 13.0276H14.3228C14.5989 13.0276 14.8228 12.8038 14.8228 12.5276C14.8228 12.2515 14.5989 12.0276 14.3228 12.0276H13.0278V10.7328C13.0278 10.4567 12.8039 10.2328 12.5278 10.2328C12.2517 10.2328 12.0278 10.4567 12.0278 10.7328V12.0276H10.7332C10.457 12.0276 10.2332 12.2515 10.2332 12.5276C10.2332 12.8038 10.457 13.0276 10.7332 13.0276H12.0278V14.3224Z" fill="var(--svg-fill-31A629)"/></svg>',
    "find": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><g transform="translate(-6 -6) scale(1.2)"><circle cx="12" cy="12" r="6" stroke="var(--svg-stroke-6890D9)" stroke-width="2"/><path d="M17 17 L23 23" stroke="var(--svg-stroke-6890D9)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M13 8.5 C16 9 16 15 13 15.5" stroke="var(--svg-stroke-6890D9)" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/></g></svg>',
    "folder-enc": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M1.5 7 C1.5 5.5, 2 5, 3.5 5 H5 C7 5 6 7 8 7 H12.5 C 14 7 14.5 7.5 14.5 9 V13.5 C14.5 15 14 15.5 12.5 15.5 H3.5 C 2 15.5 1.5 15 1.5 13.5Z" stroke="var(--svg-stroke-green)" stroke-width="1" fill="var(--svg-fill-31A629)"/><path d="M4 5 V5 A 3 3 0 0 1 12 5 V7.5" stroke="var(--svg-stroke-green)" stroke-width="1.5" /><path d="M8 9.5 V13" stroke="var(--svg-stroke-black)" stroke-width="2"  stroke-linecap="round"/><circle cx="8" cy="10" r="2" fill="var(--svg-fill-black)"/></svg>',
    "folder-err-enc": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M1.5 7 C1.5 5.5, 2 5, 3.5 5 H5 C7 5 6 7 8 7 H12.5 C 14 7 14.5 7.5 14.5 9 V13.5 C14.5 15 14 15.5 12.5 15.5 H3.5 C 2 15.5 1.5 15 1.5 13.5Z" stroke="var(--svg-stroke-822)" stroke-width="1" fill="var(--svg-fill-f55)"/><path d="M4 5 V5 A 3 3 0 0 1 12 5 V7.5" stroke="var(--svg-stroke-822)" stroke-width="1.5" /><path d="M8 9.5 V13" stroke="var(--svg-stroke-black)" stroke-width="2"  stroke-linecap="round"/><circle cx="8" cy="10" r="2" fill="var(--svg-fill-black)"/></svg>',
    "folder-left": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6330_252)"><path d="M13.3334 13.3333C13.687 13.3333 14.0261 13.1929 14.2762 12.9428C14.5262 12.6928 14.6667 12.3536 14.6667 12V5.33333C14.6667 4.97971 14.5262 4.64057 14.2762 4.39052C14.0261 4.14048 13.687 4 13.3334 4H8.06671C7.84372 4.00219 7.62374 3.94841 7.42691 3.84359C7.23008 3.73877 7.06268 3.58625 6.94004 3.4L6.40004 2.6C6.27863 2.41565 6.11336 2.26432 5.91904 2.1596C5.72472 2.05488 5.50745 2.00004 5.28671 2H2.66671C2.31309 2 1.97395 2.14048 1.7239 2.39052C1.47385 2.64057 1.33337 2.97971 1.33337 3.33333V12C1.33337 12.3536 1.47385 12.6928 1.7239 12.9428C1.97395 13.1929 2.31309 13.3333 2.66671 13.3333H13.3334Z" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M6.32861 11V5.90909H7.71072V9.88636H9.76895V11H6.32861Z" fill="var(--svg-fill-6890D9)"/></g><defs><clipPath id="clip0_6330_252"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "folder-prob-enc": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M1.5 7 C1.5 5.5, 2 5, 3.5 5 H5 C7 5 6 7 8 7 H12.5 C 14 7 14.5 7.5 14.5 9 V13.5 C14.5 15 14 15.5 12.5 15.5 H3.5 C 2 15.5 1.5 15 1.5 13.5Z" stroke="var(--svg-stroke-C89A00)" stroke-width="1" fill="var(--svg-fill-FFDC5B)"/><path d="M4 5 V5 A 3 3 0 0 1 12 5 V7.5" stroke="var(--svg-stroke-C89A00)" stroke-width="1.5" /><path d="M8 9.5 V13" stroke="var(--svg-stroke-black)" stroke-width="2"  stroke-linecap="round"/><circle cx="8" cy="10" r="2" fill="var(--svg-fill-black)"/></svg>',
    "folder-right": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6330_263)"><path d="M13.3334 13.3333C13.687 13.3333 14.0261 13.1929 14.2762 12.9428C14.5262 12.6928 14.6667 12.3536 14.6667 12V5.33333C14.6667 4.97971 14.5262 4.64057 14.2762 4.39052C14.0261 4.14048 13.687 4 13.3334 4H8.06671C7.84372 4.00219 7.62374 3.94841 7.42691 3.84359C7.23008 3.73877 7.06268 3.58625 6.94004 3.4L6.40004 2.6C6.27863 2.41565 6.11336 2.26432 5.91904 2.1596C5.72472 2.05488 5.50745 2.00004 5.28671 2H2.66671C2.31309 2 1.97395 2.14048 1.7239 2.39052C1.47385 2.64057 1.33337 2.97971 1.33337 3.33333V12C1.33337 12.3536 1.47385 12.6928 1.7239 12.9428C1.97395 13.1929 2.31309 13.3333 2.66671 13.3333H13.3334Z" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M5.99023 11V5.90909H8.18768C8.56552 5.90909 8.89613 5.97786 9.17951 6.11541C9.46289 6.25296 9.6833 6.45099 9.84073 6.70952C9.99817 6.96804 10.0769 7.27794 10.0769 7.6392C10.0769 8.00379 9.99568 8.3112 9.83327 8.56143C9.67253 8.81167 9.44632 9.00059 9.15465 9.1282C8.86464 9.2558 8.52575 9.3196 8.13796 9.3196H6.82546V8.24574H7.85955C8.02196 8.24574 8.16033 8.22585 8.27468 8.18608C8.39068 8.14465 8.47934 8.07919 8.54066 7.9897C8.60363 7.90021 8.63512 7.78338 8.63512 7.6392C8.63512 7.49337 8.60363 7.37488 8.54066 7.28374C8.47934 7.19093 8.39068 7.12299 8.27468 7.0799C8.16033 7.03516 8.02196 7.01278 7.85955 7.01278H7.37234V11H5.99023ZM8.97319 8.66335L10.2459 11H8.7445L7.5016 8.66335H8.97319Z" fill="var(--svg-fill-6890D9)"/></g><defs><clipPath id="clip0_6330_263"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "folder": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M13.6 4H8L5.9 2H2.4C1.63 2 1 2.75 1 3.66667V10H15V5.66667C15 4.75 14.37 4 13.6 4Z" fill="var(--svg-fill-FBBB1A)"/><path d="M13.6 5H8L7 6H2.4C1.63 6 1 6.64286 1 7.42857V12.5714C1 13.3571 1.63 14 2.4 14H13.6C14.37 14 15 13.3571 15 12.5714V6.42857C15 5.64286 14.37 5 13.6 5Z" fill="url(#paint0_linear_6432_1185)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M1 12.0713V12.5714C1 13.3571 1.63 14 2.4 14H13.6C14.37 14 15 13.3571 15 12.5714V12.0713C15 12.857 14.37 13.4999 13.6 13.4999H2.4C1.63 13.4999 1 12.857 1 12.0713Z" fill="var(--svg-fill-F0B938)"/><defs><linearGradient id="paint0_linear_6432_1185" x1="8" y1="5" x2="8" y2="14" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-FFDF84)"/><stop offset="1" stop-color="var(--svg-stop-color-FFCF49)"/></linearGradient></defs></svg>',
    "folder_link": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M13.6 4H8L5.9 2H2.4C1.63 2 1 2.75 1 3.66667V10H15V5.66667C15 4.75 14.37 4 13.6 4Z" fill="var(--svg-fill-FBBB1A)"/><path d="M13.6 5H8L7 6H2.4C1.63 6 1 6.64286 1 7.42857V12.5714C1 13.3571 1.63 14 2.4 14H13.6C14.37 14 15 13.3571 15 12.5714V6.42857C15 5.64286 14.37 5 13.6 5Z" fill="url(#paint0_linear_6433_1221)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M1 12.0713V12.5714C1 13.3571 1.63 14 2.4 14H13.6C14.37 14 15 13.3571 15 12.5714V12.0713C15 12.857 14.37 13.4999 13.6 13.4999H2.4C1.63 13.4999 1 12.857 1 12.0713Z" fill="var(--svg-fill-F0B938)"/><rect x="0.5" y="6.5" width="9" height="9" rx="0.5" fill="var(--svg-fill-white)" stroke="var(--svg-stroke-7F848D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M3 8C2.72386 8 2.5 8.22386 2.5 8.5C2.5 8.77614 2.72386 9 3 9H6.29289L2.14645 13.1464C1.95118 13.3417 1.95118 13.6583 2.14645 13.8536C2.34171 14.0488 2.65829 14.0488 2.85355 13.8536L7 9.70711V13C7 13.2761 7.22386 13.5 7.5 13.5C7.77614 13.5 8 13.2761 8 13V8.5V8H7.5H3Z" fill="var(--svg-fill-1C62D8)"/><defs><linearGradient id="paint0_linear_6433_1221" x1="8" y1="5" x2="8" y2="14" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-FFDF84)"/><stop offset="1" stop-color="var(--svg-stop-color-FFCF49)"/></linearGradient></defs></svg>',
    "folder_with_files": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M13.6 4H8L5.9 2H2.4C1.63 2 1 2.75 1 3.66667V10H15V5.66667C15 4.75 14.37 4 13.6 4Z" fill="var(--svg-fill-FBBB1A)"/><path d="M3.5 6 V2 C3.5 1.5, 4 0.5, 5 0.5 H11 C 12 0.5, 12.5 1, 12.5 2 V6 M5 3 H11 M5 5 H11" stroke="var(--svg-stroke-757575)" stroke-width="1" fill="var(--svg-fill-white)" /><path d="M13.6 5H8L7 6H2.4C1.63 6 1 6.64286 1 7.42857V12.5714C1 13.3571 1.63 14 2.4 14H13.6C14.37 14 15 13.3571 15 12.5714V6.42857C15 5.64286 14.37 5 13.6 5Z" fill="url(#paint0_linear_6432_1185)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M1 12.0713V12.5714C1 13.3571 1.63 14 2.4 14H13.6C14.37 14 15 13.3571 15 12.5714V12.0713C15 12.857 14.37 13.4999 13.6 13.4999H2.4C1.63 13.4999 1 12.857 1 12.0713Z" fill="var(--svg-fill-F0B938)"/><defs><linearGradient id="paint0_linear_6432_1185" x1="8" y1="5" x2="8" y2="14" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-FFDF84)"/><stop offset="1" stop-color="var(--svg-stop-color-FFCF49)"/></linearGradient></defs></svg>',
    "GoodSync Explorer": '<svg width="41" height="41" viewBox="0 0 41 41" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M34.375 31.5295C37.4816 31.5295 40 28.9959 40 25.8705V10.7992C40 7.67379 37.4816 5.14018 34.375 5.14018H20.5509C19.0618 5.14018 17.6334 4.54609 16.5789 3.48818L14.7489 1.65212C13.6944 0.594209 12.266 0.00012207 10.7769 0.00012207H5.625C2.5184 0.00012207 -2.07544e-06 2.53374 0 5.65912L1.34216e-05 25.8705C1.54971e-05 28.9959 2.51841 31.5295 5.62501 31.5295H34.375Z" fill="url(#paint0_linear_202_1616)"/><path d="M38.2398 31.9496C40.8228 26.654 39.9378 20.0963 35.5458 15.7043C31.9565 12.115 26.9161 10.8695 22.3127 11.9406L15.26 13.0497C12.2532 13.5225 10.9492 17.1429 12.9611 19.4023C10.4389 24.6799 11.3404 31.1819 15.7043 35.5458C19.1072 38.9486 23.8161 40.2453 28.2178 39.4575L35.8953 38.2501C38.8791 37.7809 40.1861 34.2121 38.2398 31.9496Z" fill="var(--svg-fill-white)"/><path d="M22.2208 11.4494C26.9786 10.3498 32.1879 11.6391 35.8995 15.3508C40.3687 19.8201 41.3255 26.451 38.8224 31.8791C40.7234 34.4448 39.2308 38.232 35.9728 38.7443L28.295 39.9514L28.2941 39.9504C23.7426 40.7613 18.8717 39.4205 15.3507 35.8996C10.9111 31.46 9.93552 24.8863 12.3761 19.4787C10.409 16.9128 11.9004 13.072 15.1827 12.5558L22.2208 11.4494Z" stroke="var(--svg-stroke-black)" stroke-opacity="0.12"/><path d="M27.0914 18.2097C28.5086 18.5027 29.8571 19.1977 30.9548 20.2953C33.5225 22.863 33.8869 26.8036 32.0551 29.7836L31.6688 28.6543C31.594 28.4357 31.4704 28.2373 31.3072 28.0741C30.4269 27.1933 28.9135 27.6926 28.7194 28.9278L27.4194 37.1985L35.6944 35.8966C36.9256 35.7029 37.4232 34.1931 36.5454 33.3148C36.3784 33.1477 36.1745 33.0223 35.95 32.9483L35.0718 32.6592C38.4229 28.0212 38.0285 21.5268 33.8759 17.3742C32.1443 15.6426 30.0055 14.5645 27.7639 14.139C24.245 13.7791 23.9875 17.8343 27.1203 18.2046L27.0914 18.2097Z" fill="url(#paint1_linear_202_1616)"/><path d="M22.4111 22.0144L23.6823 13.931L15.5906 15.2034C14.3867 15.3927 13.9001 16.8684 14.7585 17.7268C14.9218 17.8901 15.1211 18.0127 15.3407 18.085L16.3148 18.4055C12.8172 23.0545 13.1659 29.6676 17.3741 33.8757C19.0829 35.5845 21.1883 36.6569 23.3976 37.0938C26.715 37.2738 26.8999 33.3744 23.8307 33.0117L23.9413 32.992C22.6039 32.675 21.3366 31.996 20.2952 30.9546C17.7116 28.3711 17.3586 24.3976 19.2291 21.4112L19.527 22.2817C19.6002 22.4954 19.7211 22.6894 19.8806 22.8489C20.7414 23.7097 22.2213 23.2217 22.4111 22.0144Z" fill="url(#paint2_linear_202_1616)"/><defs><linearGradient id="paint0_linear_202_1616" x1="20" y1="-13.4138" x2="20.0559" y2="53.6557" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-1DC9FF)"/><stop offset="1" stop-color="var(--svg-stop-color-0047FF)"/></linearGradient><linearGradient id="paint1_linear_202_1616" x1="31.1278" y1="14.2632" x2="31.1705" y2="35.9341" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-1DC9FF)"/><stop offset="1" stop-color="var(--svg-stop-color-0047FF)"/></linearGradient><linearGradient id="paint2_linear_202_1616" x1="16.5821" y1="20.1874" x2="26.6534" y2="33.5674" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-FF4D4D)"/><stop offset="1" stop-color="var(--svg-stop-color-D4276F)"/></linearGradient></defs></svg>',
    "google-logo": '<svg width="24" height="24" viewBox="0 0 24 24" ><path d="M23.44 12.22c0-.98-.08-1.70-.25-2.45H11.96v4.44h6.59c-.13 1.10-.85 2.76-2.45 3.88l-.02 .15 3.55 2.75 .25 .02c2.26-2.08 3.56-5.15 3.56-8.79" fill="var(--svg-fill-4285F4)"/><path d="M11.96 23.93c3.23 0 5.94-1.06 7.93-2.90l-3.77-2.92c-1.01 .70-2.36 1.19-4.14 1.19-3.16 0-5.85-2.08-6.82-4.98l-.14 .01-3.69 2.86-.05 .13C3.25 21.27 7.29 23.93 11.96 23.93" fill="var(--svg-fill-34A853)"/><path d="M5.15 14.31c-.25-.74-.40-1.54-.40-2.36 0-.82 .15-1.62 .39-2.36l-.01-.16L1.40 6.53l-.12 .06C.46 8.22 0 10.03 0 11.96s.46 3.75 1.27 5.36l3.88-2.99" fill="var(--svg-fill-FBBC05)"/><path d="M11.96 4.63c2.25 0 3.77 .97 4.68 1.78l3.37-3.29C17.92 1.18 15.18 0 11.96 0 7.29 0 3.25 2.68 1.27 6.59l3.87 2.99c.97-2.88 3.65-4.98 6.83-4.98" fill="var(--svg-fill-EB4335)"/></svg>',
    "gs-err-zip": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M2 9 V2.25 C2 0.25, 2 0.25, 4 0.25 H12 C 14 0.25, 14 0.25, 14 2.25 V9" stroke="var(--svg-stroke-822)" stroke-width="0.5" /><rect x="0" y="9.5" width="16" height="7" fill="var(--svg-fill-822)"/><g transform="translate(0.0625, -0.5)">	<path d="M7 4.25 C6.75 1.75 3.5 1.5 3.5 6 C3.5 8 5.5 9.5 7 7.5 V6.5 M12.125 4.125 C12 2 9.5 2 9.5 4 C9.5 5 10.5 5.25 11 5.5 C 11.75 5.75 12.25 6 12.25 7 C12.25 9 9.5 9 9.5 7" stroke="var(--svg-stroke-822)" stroke-width="1.5"  stroke-linejoin="round"/>	<path d="M7 7.5 V6.25 H5.5" stroke="var(--svg-stroke-822)" stroke-width="1.5"/></g><g transform="translate(-0.125, 0.25)">	<path d="M1.5 11 H 6 L 2 14 H6.5 M11 11 H13 C15 11 15 13 13 13 H11 M13 11 C14.25 11 14.25 13 13 13" stroke="var(--svg-stroke-FFFFFF)" stroke-width="1" stroke-linejoin="round"/>	<path d="M8.375 10.5 V14.5 M11 10.5 V14.5 " stroke="var(--svg-stroke-FFFFFF)" stroke-width="1.5" /></g></svg>',
    "gs-prob-zip": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M2 9 V2.25 C2 0.25, 2 0.25, 4 0.25 H12 C 14 0.25, 14 0.25, 14 2.25 V9" stroke="var(--svg-stroke-C89A00)" stroke-width="0.5" /><rect x="0" y="9.5" width="16" height="7" fill="var(--svg-fill-C89A00)"/><g transform="translate(0.0625, -0.5)"><path d=" M7 4.25  C6.75 1.75   3.5    1.5   3.5    6  C3.5   8   5.5   9.5   7 7.5  V6.5 M12.125 4.125  C12  2  9.5 2    9.5 4  C9.5 5 10.5 5.25 11  5.5  C 11.75 5.75 12.25  6 12.25 7 C12.25 9 9.5 9 9.5 7" stroke="var(--svg-stroke-C89A00)" stroke-width="1.5"  stroke-linejoin="round"/> <path d="M7 7.5 V6.25 H5.5" stroke="var(--svg-stroke-C89A00)" stroke-width="1.5"/> </g> <g transform="translate(-0.125, 0.25)"> <path d=" M1.5 11 H 6 L 2 14 H6.5 M11 11 H13 C15 11 15 13 13 13 H11 M13 11 C14.25 11 14.25 13 13 13" stroke="var(--svg-stroke-FFFFFF)" stroke-width="1"  stroke-linejoin="round"/><path d="M8.375 10.5 V14.5 M11 10.5 V14.5 " stroke="var(--svg-stroke-FFFFFF)" stroke-width="1.5" /> </g></svg>',
    "gs-zip": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M2 9 V2.25 C2 0.25, 2 0.25, 4 0.25 H12 C 14 0.25, 14 0.25, 14 2.25 V9" stroke="var(--svg-stroke-green)" stroke-width="0.5" /><rect x="0" y="9.5" width="16" height="7" fill="var(--svg-fill-green)"/><g transform="translate(0.0625, -0.5)"><path d=" M7 4.25  C6.75 1.75   3.5    1.5   3.5    6  C3.5   8   5.5   9.5   7 7.5  V6.5 M12.125 4.125  C12  2  9.5 2    9.5 4  C9.5 5 10.5 5.25 11  5.5  C 11.75 5.75 12.25  6 12.25 7 C12.25 9 9.5 9 9.5 7" stroke="var(--svg-stroke-green)" stroke-width="1.5"  stroke-linejoin="round"/> <path d="M7 7.5 V6.25 H5.5" stroke="var(--svg-stroke-green)" stroke-width="1.5"/> </g> <g transform="translate(-0.125, 0.25)"> <path d=" M1.5 11 H 6 L 2 14 H6.5 M11 11 H13 C15 11 15 13 13 13 H11 M13 11 C14.25 11 14.25 13 13 13" stroke="var(--svg-stroke-FFFFFF)" stroke-width="1"  stroke-linejoin="round"/><path d="M8.375 10.5 V14.5 M11 10.5 V14.5 " stroke="var(--svg-stroke-FFFFFF)" stroke-width="1.5" /> </g></svg>',
    "GSLogView": '<svg width="41" height="41" viewBox="0 0 41 41" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M 	27.5	8	27.5 	5C	27.5 2.5 25 1 22.5 	1H	5C	2.5 1 	1 	2.5 1 	5L	1 	30C	1 	32.5 2.5 35 5 35H	10" stroke="var(--svg-stroke-7F848D)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M5 9 23.5 9 M5 18 12 18 M5 27 12 27" stroke="var(--svg-stroke-7F848D)" stroke-width="4"/><path d="M38.2398 31.9496C40.8228 26.654 39.9378 20.0963 35.5458 15.7043C31.9565 12.115 26.9161 10.8695 22.3127 11.9406L15.26 13.0497C12.2532 13.5225 10.9492 17.1429 12.9611 19.4023C10.4389 24.6799 11.3404 31.1819 15.7043 35.5458C19.1072 38.9486 23.8161 40.2453 28.2178 39.4575L35.8953 38.2501C38.8791 37.7809 40.1861 34.2121 38.2398 31.9496Z" fill="var(--svg-fill-white)"/><path d="M22.2208 11.4494C26.9786 10.3498 32.1879 11.6391 35.8995 15.3508C40.3687 19.8201 41.3255 26.451 38.8224 31.8791C40.7234 34.4448 39.2308 38.232 35.9728 38.7443L28.295 39.9514L28.2941 39.9504C23.7426 40.7613 18.8717 39.4205 15.3507 35.8996C10.9111 31.46 9.93552 24.8863 12.3761 19.4787C10.409 16.9128 11.9004 13.072 15.1827 12.5558L22.2208 11.4494Z" stroke="var(--svg-stroke-black)" stroke-opacity="0.12"/><path d="M27.0914 18.2097C28.5086 18.5027 29.8571 19.1977 30.9548 20.2953C33.5225 22.863 33.8869 26.8036 32.0551 29.7836L31.6688 28.6543C31.594 28.4357 31.4704 28.2373 31.3072 28.0741C30.4269 27.1933 28.9135 27.6926 28.7194 28.9278L27.4194 37.1985L35.6944 35.8966C36.9256 35.7029 37.4232 34.1931 36.5454 33.3148C36.3784 33.1477 36.1745 33.0223 35.95 32.9483L35.0718 32.6592C38.4229 28.0212 38.0285 21.5268 33.8759 17.3742C32.1443 15.6426 30.0055 14.5645 27.7639 14.139C24.245 13.7791 23.9875 17.8343 27.1203 18.2046L27.0914 18.2097Z" fill="url(#paint1_linear_202_1616)"/><path d="M22.4111 22.0144L23.6823 13.931L15.5906 15.2034C14.3867 15.3927 13.9001 16.8684 14.7585 17.7268C14.9218 17.8901 15.1211 18.0127 15.3407 18.085L16.3148 18.4055C12.8172 23.0545 13.1659 29.6676 17.3741 33.8757C19.0829 35.5845 21.1883 36.6569 23.3976 37.0938C26.715 37.2738 26.8999 33.3744 23.8307 33.0117L23.9413 32.992C22.6039 32.675 21.3366 31.996 20.2952 30.9546C17.7116 28.3711 17.3586 24.3976 19.2291 21.4112L19.527 22.2817C19.6002 22.4954 19.7211 22.6894 19.8806 22.8489C20.7414 23.7097 22.2213 23.2217 22.4111 22.0144Z" fill="url(#paint2_linear_202_1616)"/><defs><linearGradient id="paint1_linear_202_1616" x1="31.1278" y1="14.2632" x2="31.1705" y2="35.9341" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-1DC9FF)"/><stop offset="1" stop-color="var(--svg-stop-color-0047FF)"/></linearGradient><linearGradient id="paint2_linear_202_1616" x1="16.5821" y1="20.1874" x2="26.6534" y2="33.5674" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-FF4D4D)"/><stop offset="1" stop-color="var(--svg-stop-color-D4276F)"/></linearGradient></defs></svg>',
    "hide-medium": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M11.9998 5.29707C9.58485 5.29707 7.53048 6.3231 5.90473 7.68172L8.9212 9.44627C9.65491 8.56272 10.7617 8.0001 12 8.0001C14.2091 8.0001 16 9.79096 16 12.0001C16 12.5049 15.9064 12.9879 15.7358 13.4326L19.0899 15.3947C20.241 14.2166 21.0778 12.9488 21.5601 11.9994C20.9781 10.8535 19.881 9.24656 18.3405 7.89237C16.6767 6.42971 14.5378 5.29707 11.9998 5.29707ZM11.9998 3.99707C9.00948 3.99707 6.55042 5.3541 4.71924 6.98823L2.04464 5.42366C1.73478 5.2424 1.33665 5.34665 1.15538 5.65651C0.974123 5.96638 1.07837 6.36451 1.38824 6.54577L21.955 18.5768C22.2648 18.758 22.663 18.6538 22.8442 18.3439C23.0255 18.0341 22.9212 17.6359 22.6114 17.4547L20.2434 16.0695C21.5005 14.7283 22.3906 13.3073 22.8723 12.274L23.0003 11.9994L22.8723 11.7247C22.2671 10.4266 21.0157 8.51314 19.1988 6.91599C17.3778 5.31519 14.9462 3.99707 11.9998 3.99707ZM3.37365 9.34829C3.6642 9.55912 3.72883 9.96557 3.518 10.2561C3.05825 10.8897 2.6972 11.4921 2.43949 11.9994C3.02155 13.1452 4.11857 14.7522 5.65907 16.1063C7.32296 17.569 9.46177 18.7016 11.9998 18.7016C13.5721 18.7016 15.3847 18.1178 16.6459 17.4289C16.9609 17.2568 17.3558 17.3727 17.5279 17.6878C17.7 18.0028 17.5841 18.3977 17.2691 18.5698C15.8666 19.3359 13.8403 20.0016 11.9998 20.0016C9.05338 20.0016 6.62181 18.6835 4.80077 17.0827C2.98388 15.4856 1.73251 13.5721 1.12732 12.274L0.999268 11.9994L1.12732 11.7247C1.42509 11.086 1.87531 10.3064 2.46581 9.49264C2.67664 9.20208 3.08309 9.13746 3.37365 9.34829ZM7.99996 12.0001C7.99996 11.9514 8.00083 11.9028 8.00256 11.8545L14.0865 15.4134C13.479 15.7856 12.7645 16.0001 12 16.0001C9.79082 16.0001 7.99996 14.2092 7.99996 12.0001Z" fill="var(--svg-fill-black)" fill-opacity="0.54"/></svg>',
    "I_Dis_Del": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M11.2304 13.2929C11.6209 13.6834 12.2541 13.6834 12.6446 13.2929L13.2929 12.6446C13.6834 12.2541 13.6834 11.6209 13.2929 11.2304L10.0626 8L13.2929 4.76966C13.6834 4.37914 13.6834 3.74597 13.2929 3.35545L12.6446 2.70714C12.2541 2.31661 11.6209 2.31661 11.2304 2.70714L8.00003 5.93747L4.76966 2.70711C4.37914 2.31658 3.74597 2.31658 3.35545 2.70711L2.70713 3.35542C2.31661 3.74595 2.31661 4.37911 2.70713 4.76964L5.9375 8L2.70711 11.2304C2.31658 11.6209 2.31658 12.2541 2.70711 12.6446L3.35542 13.2929C3.74595 13.6834 4.37911 13.6834 4.76964 13.2929L8.00003 10.0625L11.2304 13.2929Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "I_Ena_Del": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M11.2304 13.2929C11.6209 13.6834 12.2541 13.6834 12.6446 13.2929L13.2929 12.6446C13.6834 12.2541 13.6834 11.6209 13.2929 11.2304L10.0626 8L13.2929 4.76966C13.6834 4.37914 13.6834 3.74597 13.2929 3.35545L12.6446 2.70714C12.2541 2.31661 11.6209 2.31661 11.2304 2.70714L8.00003 5.93747L4.76966 2.70711C4.37914 2.31658 3.74597 2.31658 3.35545 2.70711L2.70713 3.35542C2.31661 3.74595 2.31661 4.37911 2.70713 4.76964L5.9375 8L2.70711 11.2304C2.31658 11.6209 2.31658 12.2541 2.70711 12.6446L3.35542 13.2929C3.74595 13.6834 4.37911 13.6834 4.76964 13.2929L8.00003 10.0625L11.2304 13.2929Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "job-backup-init16-1": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M5.01381 3.53085C5.89773 2.94024 6.93693 2.625 8 2.625C9.51188 2.625 10.9627 3.22432 12.0559 4.27307L12.4911 4.70833H10.6665C10.3213 4.70833 10.0415 4.98816 10.0415 5.33333C10.0415 5.67851 10.3213 5.95833 10.6665 5.95833H13.9998C14.0086 5.95834 14.0173 5.95816 14.026 5.9578C14.0755 5.95575 14.1248 5.94785 14.1728 5.93409C14.2713 5.90584 14.3643 5.85291 14.4419 5.77528C14.5677 5.64957 14.6286 5.48363 14.6248 5.31891V2C14.6248 1.65482 14.345 1.375 13.9998 1.375C13.6547 1.375 13.3748 1.65482 13.3748 2V3.82428L12.9353 3.38472L12.9354 3.38464L12.9265 3.3761C11.6068 2.10742 9.84612 1.375 8 1.375C6.6897 1.375 5.40883 1.76355 4.31935 2.49151C3.22987 3.21948 2.38073 4.25416 1.8793 5.46472C1.37787 6.67528 1.24667 8.00735 1.5023 9.29247C1.75793 10.5776 2.3889 11.7581 3.31542 12.6846C4.24194 13.6111 5.42241 14.2421 6.70753 14.4977C7.99265 14.7533 9.32472 14.6221 10.5353 14.1207C11.7458 13.6193 12.7805 12.7701 13.5085 11.6807C14.2365 10.5912 14.625 9.3103 14.625 8C14.625 7.65482 14.3452 7.375 14 7.375C13.6548 7.375 13.375 7.65482 13.375 8C13.375 9.06307 13.0598 10.1023 12.4692 10.9862C11.8785 11.8701 11.0391 12.559 10.0569 12.9659C9.07477 13.3727 7.99404 13.4791 6.95139 13.2717C5.90875 13.0643 4.95101 12.5524 4.1993 11.8007C3.4476 11.049 2.93568 10.0913 2.72828 9.04861C2.52089 8.00596 2.62733 6.92523 3.03415 5.94308C3.44097 4.96092 4.1299 4.12146 5.01381 3.53085Z" fill="var(--svg-fill-31A629)"/></svg>',
    "job-backup-init16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M5.01381 3.53085C5.89773 2.94024 6.93693 2.625 8 2.625C9.51188 2.625 10.9627 3.22432 12.0559 4.27307L12.4911 4.70833H10.6665C10.3213 4.70833 10.0415 4.98816 10.0415 5.33333C10.0415 5.67851 10.3213 5.95833 10.6665 5.95833H13.9998C14.0086 5.95834 14.0173 5.95816 14.026 5.9578C14.0755 5.95575 14.1248 5.94785 14.1728 5.93409C14.2713 5.90584 14.3643 5.85291 14.4419 5.77528C14.5677 5.64957 14.6286 5.48363 14.6248 5.31891V2C14.6248 1.65482 14.345 1.375 13.9998 1.375C13.6547 1.375 13.3748 1.65482 13.3748 2V3.82428L12.9353 3.38472L12.9354 3.38464L12.9265 3.3761C11.6068 2.10742 9.84612 1.375 8 1.375C6.6897 1.375 5.40883 1.76355 4.31935 2.49151C3.22987 3.21948 2.38073 4.25416 1.8793 5.46472C1.37787 6.67528 1.24667 8.00735 1.5023 9.29247C1.75793 10.5776 2.3889 11.7581 3.31542 12.6846C4.24194 13.6111 5.42241 14.2421 6.70753 14.4977C7.99265 14.7533 9.32472 14.6221 10.5353 14.1207C11.7458 13.6193 12.7805 12.7701 13.5085 11.6807C14.2365 10.5912 14.625 9.3103 14.625 8C14.625 7.65482 14.3452 7.375 14 7.375C13.6548 7.375 13.375 7.65482 13.375 8C13.375 9.06307 13.0598 10.1023 12.4692 10.9862C11.8785 11.8701 11.0391 12.559 10.0569 12.9659C9.07477 13.3727 7.99404 13.4791 6.95139 13.2717C5.90875 13.0643 4.95101 12.5524 4.1993 11.8007C3.4476 11.049 2.93568 10.0913 2.72828 9.04861C2.52089 8.00596 2.62733 6.92523 3.03415 5.94308C3.44097 4.96092 4.1299 4.12146 5.01381 3.53085Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "job-sync-init16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M4.1993 4.1993C5.20703 3.19157 6.57371 2.62531 7.99882 2.625C9.51276 2.631 10.9659 3.2212 12.0552 4.27242L12.4911 4.70833H10.6667C10.3216 4.70833 10.0417 4.98816 10.0417 5.33333C10.0417 5.67851 10.3216 5.95833 10.6667 5.95833H14H14.0001C14.1031 5.95833 14.2003 5.93342 14.2859 5.88928C14.3131 5.8753 14.3395 5.85918 14.3648 5.84095C14.5224 5.72748 14.6251 5.5424 14.6251 5.33333V2C14.6251 1.65482 14.3453 1.375 14.0001 1.375C13.6549 1.375 13.3751 1.65482 13.3751 2V3.82453L12.9353 3.38472L12.9353 3.38466L12.9277 3.37731C11.6058 2.09936 9.841 1.38192 8.00235 1.375V1.375H8C6.24294 1.375 4.55785 2.07299 3.31542 3.31542C2.07299 4.55785 1.375 6.24294 1.375 8C1.375 8.34518 1.65482 8.625 2 8.625C2.34518 8.625 2.625 8.34518 2.625 8C2.625 6.57446 3.19129 5.20731 4.1993 4.1993ZM14 7.375C14.3452 7.375 14.625 7.65482 14.625 8C14.625 9.75706 13.927 11.4422 12.6846 12.6846C11.4422 13.927 9.75706 14.625 8 14.625H7.99765C6.159 14.6181 4.3942 13.9006 3.07226 12.6227L3.06466 12.6153L3.06473 12.6153L2.625 12.1756V13.9998C2.625 14.345 2.34518 14.6248 2 14.6248C1.65482 14.6248 1.375 14.345 1.375 13.9998V10.6667V10.6665C1.375 10.3213 1.65482 10.0415 2 10.0415H5.33333C5.67851 10.0415 5.95833 10.3213 5.95833 10.6665C5.95833 11.0117 5.67851 11.2915 5.33333 11.2915H3.50872L3.94477 11.7276C5.03408 12.7788 6.48718 13.369 8.00109 13.375C9.42624 13.3747 10.7929 12.8084 11.8007 11.8007C12.8087 10.7927 13.375 9.42554 13.375 8C13.375 7.65482 13.6548 7.375 14 7.375Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "job_analyzed_no_changes": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" y="2" width="12" height="5" rx="2" fill="var(--svg-fill-31A629)"/><rect x="2.5" y="9.5" width="12" height="5" rx="2" fill="var(--svg-fill-31A629)"/></svg>',
    "job_conflicts": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M4 5 A 3.5 3.5 1 1 1 11 5 C11 8 8 7.5 8 10.5" transform="scale(1, 0.8) translate(0, 1)" stroke="var(--svg-stroke-F0483F)" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"/><circle cx="8" cy="13" r="1.75" fill="var(--svg-fill-F0483F)" /></svg>',
    "job_error": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8 3 V8.5"  stroke="var(--svg-stroke-F0483F)" stroke-width="3.5" stroke-linecap="round" stroke-linejoin="round"/><circle cx="8" cy="13" r="2" fill="var(--svg-fill-F0483F)" /></svg>',
    "job_in_backup_blue": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd"     d="M12 24C17.946 24 22.8819 19.6754 23.8341 14H20.777C19.8675 18.008 16.2832 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C14.9887 3 17.6372 4.4568 19.274 6.69905L16 9.95438L20.773 9.98262C20.7743 9.98841 20.7757 9.9942 20.777 10H23.7106H23.8341H24V2L21.42 4.56528C19.2223 1.78451 15.8195 0 12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24Z"     fill="var(--svg-fill-5884D0)"/></svg>',
    "job_syncing_red": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M12.0001 24C17.9461 24 22.882 19.6754 23.8342 14H20.7771C19.8676 18.008 16.2833 21 12.0001 21C9.01136 21 6.36289 19.5432 4.72605 17.3009L8 14.0456L3.22708 14.0174C3.22575 14.0116 3.22443 14.0058 3.22312 14H0V22L2.58004 19.4347C4.77775 22.2155 8.18053 24 12.0001 24Z"     fill="var(--svg-fill-F6412D)"/><path d="M12.0001 0C15.8196 0 19.2224 1.78448 21.4201 4.56522L24 2V10H20.7771C20.7758 9.9942 20.7744 9.98841 20.7731 9.98262L16 9.95438L19.2741 6.69899C17.6372 4.45678 14.9888 3 12.0001 3C7.71692 3 4.13257 5.99202 3.22312 10H0.166016C1.11817 4.32457 6.05411 0 12.0001 0Z"     fill="var(--svg-fill-F6412D)"/></svg>',
    "job_syncing_red_blue": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M12.0001 24C17.9461 24 22.882 19.6754 23.8342 14H20.7771C19.8676 18.008 16.2833 21 12.0001 21C9.01136 21 6.36289 19.5432 4.72605 17.3009L8 14.0456L3.22708 14.0174C3.22575 14.0116 3.22443 14.0058 3.22312 14H0V22L2.58004 19.4347C4.77775 22.2155 8.18053 24 12.0001 24Z"     fill="var(--svg-fill-F6412D)"/><path d="M12.0001 0C15.8196 0 19.2224 1.78448 21.4201 4.56522L24 2V10H20.7771C20.7758 9.9942 20.7744 9.98841 20.7731 9.98262L16 9.95438L19.2741 6.69899C17.6372 4.45678 14.9888 3 12.0001 3C7.71692 3 4.13257 5.99202 3.22312 10H0.166016C1.11817 4.32457 6.05411 0 12.0001 0Z"     fill="var(--svg-fill-5884D0)"/></svg>',
    "license-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M1.04147 12.2823L3.10683 9.22024L6.78196 12.0054L4.85859 14.8569L3.71636 12.4387L1.04147 12.2823Z" fill="var(--svg-fill-C23056)"/><path d="M14.9585 12.2823L12.8932 9.22024L9.21804 12.0054L11.1414 14.8569L12.2836 12.4387L14.9585 12.2823Z" fill="var(--svg-fill-C23056)"/><path d="M9.35485 2.33605C9.46483 2.43927 9.61554 2.48732 9.76498 2.46682L10.5357 2.36106C11.1568 2.27583 11.7138 2.68482 11.8163 3.25199L11.9508 3.99574C11.9785 4.14875 12.0757 4.28018 12.214 4.35134L12.9016 4.70525C13.4445 4.9847 13.6473 5.61814 13.387 6.13478L13.0643 6.775C12.993 6.91653 12.993 7.08347 13.0643 7.225L13.387 7.86522C13.6473 8.38186 13.4445 9.0153 12.9016 9.29475L12.214 9.64866C12.0757 9.71982 11.9785 9.85125 11.9508 10.0043L11.8163 10.748C11.7138 11.3152 11.1568 11.7242 10.5357 11.6389L9.76498 11.5332C9.61554 11.5127 9.46483 11.5607 9.35485 11.664L8.79541 12.189C8.35352 12.6037 7.64648 12.6037 7.20459 12.189L6.64515 11.664C6.53517 11.5607 6.38446 11.5127 6.23502 11.5332L5.46432 11.6389C4.84318 11.7242 4.28624 11.3152 4.18368 10.748L4.0492 10.0043C4.02153 9.85125 3.92425 9.71982 3.786 9.64866L3.09841 9.29475C2.55548 9.0153 2.35271 8.38186 2.61305 7.86521L2.93565 7.225C3.00696 7.08347 3.00696 6.91653 2.93565 6.775L2.61305 6.13479C2.35271 5.61814 2.55548 4.9847 3.09841 4.70525L3.786 4.35134C3.92425 4.28018 4.02153 4.14875 4.0492 3.99574L4.18368 3.25199C4.28624 2.68482 4.84318 2.27583 5.46432 2.36106L6.23502 2.46682C6.38446 2.48732 6.53517 2.43927 6.64515 2.33605L7.20459 1.81103C7.64648 1.39632 8.35352 1.39632 8.79541 1.81103L9.35485 2.33605Z" fill="var(--svg-fill-FFDC5B)" stroke="var(--svg-stroke-C89A00)" stroke-linejoin="round"/><circle cx="7.99996" cy="6.99984" r="1.83333" stroke="var(--svg-stroke-C89A00)"/></svg>',
    "linux": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6217_807)"><path d="M7.68439 0C7.30939 0 6.93314 0.07375 6.59314 0.2575C6.23189 0.451875 5.93564 0.763125 5.75376 1.13063C5.57126 1.49813 5.50001 1.89062 5.48876 2.32312C5.46814 3.14437 5.50751 4.00563 5.56939 4.78625C5.58564 5.02375 5.61564 5.1625 5.58501 5.40688C5.48376 5.92563 5.03001 6.27437 4.78751 6.73C4.52064 7.2325 4.40814 7.80062 4.20689 8.33313C4.02251 8.82 3.76376 9.27687 3.58939 9.7675C3.34501 10.4531 3.27189 11.2069 3.43314 11.9169C3.55626 12.4581 3.81314 12.9656 4.15939 13.4C4.10939 13.49 4.06064 13.5819 4.00939 13.6713C3.84876 13.9481 3.65251 14.2112 3.56126 14.5181C3.51564 14.6712 3.49751 14.835 3.52689 14.9925C3.55626 15.15 3.63626 15.3006 3.76126 15.4006C3.84314 15.4656 3.94251 15.5081 4.04439 15.5319C4.14626 15.555 4.25189 15.5606 4.35689 15.5588C4.75501 15.55 5.14126 15.4294 5.52626 15.3281C5.75501 15.2681 5.98501 15.215 6.21564 15.1669C7.03689 14.9987 7.95314 15.0663 8.71501 15.1763C8.97314 15.2156 9.22939 15.2662 9.48314 15.3281C9.88064 15.4244 10.2763 15.5469 10.685 15.5588C10.7925 15.5619 10.9013 15.5569 11.0063 15.5337C11.1113 15.51 11.2131 15.4675 11.2969 15.4006C11.4225 15.3006 11.5025 15.1494 11.5319 14.9919C11.5613 14.8344 11.5431 14.67 11.4969 14.5162C11.4044 14.2087 11.2063 13.9469 11.0425 13.6713C10.9775 13.5619 10.9175 13.4506 10.8531 13.3413C11.3469 12.7869 11.7444 12.1456 11.9744 11.4412C12.225 10.6725 12.2713 9.84437 12.1656 9.0425C12.06 8.24062 11.8056 7.46312 11.4713 6.72687C11.0513 5.80437 10.6981 5.47062 10.4419 4.66C10.1656 3.78375 10.3938 2.74688 10.1881 1.9525C10.115 1.6825 9.99814 1.42438 9.84751 1.18813C9.67126 0.91125 9.44752 0.66375 9.18189 0.47125C8.75814 0.16375 8.22564 0 7.68439 0Z" fill="var(--svg-fill-020204)"/><path d="M6.19567 4.62511C6.13942 4.69573 6.10317 4.78073 6.08067 4.86823C6.0588 4.95573 6.05067 5.04636 6.04692 5.13698C6.04005 5.31761 6.0513 5.50136 6.00317 5.67573C5.95192 5.86198 5.83755 6.02386 5.72567 6.18073C5.5313 6.45323 5.33505 6.73323 5.23942 7.05386C5.1813 7.24761 5.16192 7.45323 5.18255 7.65511C4.96567 7.97386 4.77755 8.31323 4.6213 8.66636C4.38505 9.20198 4.22317 9.77198 4.1663 10.3545C4.0963 11.0676 4.18755 11.8014 4.46942 12.4601C4.67255 12.937 4.9763 13.3726 5.36817 13.7126C5.56692 13.8851 5.78817 14.032 6.02442 14.1482C6.8438 14.5514 7.8563 14.552 8.66192 14.1226C9.08317 13.8982 9.4388 13.5701 9.7813 13.2382C9.98755 13.0382 10.1932 12.8332 10.3507 12.5932C10.6538 12.1301 10.7594 11.5676 10.825 11.0182C10.9394 10.0582 10.9432 9.04323 10.5219 8.17261C10.3769 7.87261 10.1838 7.59636 9.95192 7.35698C9.89067 6.93823 9.7688 6.52761 9.59192 6.14323C9.4638 5.86511 9.30817 5.60073 9.18942 5.31948C9.14067 5.20386 9.09817 5.08511 9.04442 4.97198C8.99005 4.85886 8.9238 4.75011 8.83255 4.66323C8.74005 4.57448 8.62442 4.51136 8.50255 4.47136C8.38067 4.43073 8.25192 4.41261 8.1238 4.40636C7.86692 4.39323 7.61005 4.42698 7.35317 4.41636C7.1488 4.40823 6.94505 4.37261 6.74067 4.38448C6.6388 4.39073 6.53692 4.40886 6.44192 4.44761C6.34692 4.48573 6.25942 4.54511 6.19567 4.62511Z" fill="var(--svg-fill-FDFDFB)"/><path d="M4.99877 6.30687C4.61752 6.73937 4.22564 7.15874 4.01064 7.62687C3.90377 7.86437 3.85377 8.12249 3.78064 8.37249C3.69814 8.65624 3.58564 8.93124 3.45939 9.19874C3.34252 9.44562 3.21377 9.68687 3.08564 9.92749C2.99189 10.1031 2.89689 10.2819 2.86439 10.4781C2.83877 10.6331 2.85314 10.7931 2.89314 10.945C2.93252 11.0969 2.99564 11.2419 3.06752 11.3812C3.37252 11.9781 3.83064 12.4919 4.37314 12.8856C4.61939 13.0637 4.88252 13.2181 5.15939 13.345C5.30939 13.4131 5.46689 13.4744 5.63189 13.4769C5.71439 13.4787 5.79752 13.465 5.87314 13.4319C5.94814 13.3987 6.01564 13.3456 6.06064 13.2762C6.11564 13.1912 6.13439 13.0856 6.12314 12.985C6.11189 12.8844 6.07252 12.7881 6.02002 12.7019C5.89127 12.4906 5.68814 12.3375 5.49252 12.1862C5.07002 11.8594 4.66189 11.5137 4.27064 11.15C4.16064 11.0469 4.05002 10.9412 3.97314 10.8112C3.89814 10.685 3.85752 10.5412 3.83002 10.3969C3.75439 10.0012 3.77377 9.58499 3.90814 9.20499C3.96127 9.05624 4.03064 8.91437 4.09814 8.77187C4.21439 8.52499 4.32439 8.27312 4.47752 8.04687C4.66814 7.76499 4.92314 7.52624 5.07814 7.22374C5.20939 6.96812 5.26252 6.68124 5.31314 6.39874C5.35314 6.17749 5.42877 5.96124 5.46752 5.73999C5.39189 5.88374 5.14814 6.11937 4.99877 6.30687Z" fill="var(--svg-fill-020204)"/><path d="M11.1724 7.94492C11.4999 8.20867 11.708 8.60679 11.7724 9.02242C11.8224 9.34617 11.7899 9.67929 11.7168 9.99867C11.6436 10.3187 11.5311 10.6274 11.4186 10.9362C11.3743 11.0587 11.3293 11.183 11.3118 11.3124C11.2936 11.4424 11.3049 11.5793 11.3674 11.6943C11.4393 11.8262 11.573 11.9168 11.7168 11.9593C11.8586 12.0018 12.0118 12.0005 12.1555 11.9649C12.2993 11.9293 12.5411 11.883 12.658 11.7918C12.9549 11.5612 13.0255 11.1605 13.0961 10.8093C13.1693 10.4424 13.1336 10.058 13.0693 9.68742C12.9811 9.18179 12.833 8.68805 12.6449 8.21117C12.5061 7.85992 12.3286 7.52492 12.1174 7.21367C11.9099 6.90804 11.6161 6.66992 11.3986 6.37117C11.323 6.26742 11.2324 6.15992 11.1586 6.05492C10.9986 5.82867 11.0349 5.87117 10.9355 5.72429C10.8636 5.61804 10.7499 5.58179 10.6305 5.53554C10.5105 5.48929 10.3768 5.47554 10.253 5.50992C10.0905 5.55554 9.9574 5.68429 9.88677 5.83742C9.81615 5.99117 9.80365 6.16742 9.83115 6.33429C9.86677 6.54929 9.96489 6.74929 10.0761 6.93679C10.2011 7.14867 10.3461 7.35304 10.5355 7.51054C10.733 7.67492 10.9718 7.78367 11.1724 7.94492Z" fill="var(--svg-fill-020204)"/><path d="M3.18625 10.9582C3.2725 10.9226 3.36937 10.9157 3.46062 10.9326C3.5525 10.9495 3.63937 10.9895 3.71625 11.0414C3.87063 11.1464 3.985 11.2989 4.09437 11.4501C4.34625 11.7964 4.58812 12.1501 4.80813 12.5176C4.98625 12.8164 5.14937 13.1245 5.35563 13.4039C5.49 13.587 5.64125 13.7564 5.77625 13.9382C5.91125 14.1207 6.03062 14.3182 6.09062 14.537C6.16875 14.8214 6.13813 15.1345 6.00313 15.3964C5.90813 15.5807 5.76187 15.7389 5.58437 15.8457C5.40688 15.9526 5.22 16.0001 5.0125 16.0001C4.68312 16.0001 4.36125 15.8232 4.055 15.7014C3.43125 15.4526 2.75375 15.3751 2.11063 15.1814C1.91313 15.122 1.71875 15.0514 1.52 14.997C1.43125 14.9726 1.34188 14.9514 1.25813 14.9132C1.17437 14.8757 1.09625 14.8189 1.05 14.7401C1.01438 14.6789 1 14.607 1 14.5364C1 14.4651 1.0175 14.3951 1.04188 14.3289C1.09 14.1957 1.16813 14.0751 1.22062 13.9432C1.30625 13.7282 1.32188 13.4914 1.31 13.2601C1.29875 13.0295 1.26125 12.8001 1.24563 12.5695C1.23813 12.4664 1.23563 12.362 1.25563 12.2601C1.275 12.1589 1.31875 12.0595 1.39312 11.9882C1.46187 11.922 1.5525 11.8826 1.64625 11.8632C1.73937 11.8439 1.83563 11.8432 1.93063 11.8451C2.02562 11.847 2.12125 11.8526 2.21625 11.8445C2.31125 11.837 2.40688 11.8157 2.48937 11.7682C2.56813 11.7232 2.6325 11.6564 2.68562 11.5832C2.73875 11.5101 2.78188 11.4301 2.82625 11.3507C2.87 11.272 2.91562 11.1932 2.97375 11.1232C3.03125 11.0532 3.1025 10.9926 3.18625 10.9582Z" fill="url(#paint0_linear_6217_807)"/><path d="M3.18625 10.9582C3.2725 10.9226 3.36937 10.9157 3.46062 10.9326C3.5525 10.9495 3.63937 10.9895 3.71625 11.0414C3.87063 11.1464 3.985 11.2989 4.09437 11.4501C4.34625 11.7964 4.58812 12.1501 4.80813 12.5176C4.98625 12.8164 5.14937 13.1245 5.35563 13.4039C5.49 13.587 5.64125 13.7564 5.77625 13.9382C5.91125 14.1207 6.03062 14.3182 6.09062 14.537C6.16875 14.8214 6.13813 15.1345 6.00313 15.3964C5.90813 15.5807 5.76187 15.7389 5.58437 15.8457C5.40688 15.9526 5.22 16.0001 5.0125 16.0001C4.68312 16.0001 4.36125 15.8232 4.055 15.7014C3.43125 15.4526 2.75375 15.3751 2.11063 15.1814C1.91313 15.122 1.71875 15.0514 1.52 14.997C1.43125 14.9726 1.34188 14.9514 1.25813 14.9132C1.17437 14.8757 1.09625 14.8189 1.05 14.7401C1.01438 14.6789 1 14.607 1 14.5364C1 14.4651 1.0175 14.3951 1.04188 14.3289C1.09 14.1957 1.16813 14.0751 1.22062 13.9432C1.30625 13.7282 1.32188 13.4914 1.31 13.2601C1.29875 13.0295 1.26125 12.8001 1.24563 12.5695C1.23813 12.4664 1.23563 12.362 1.25563 12.2601C1.275 12.1589 1.31875 12.0595 1.39312 11.9882C1.46187 11.922 1.5525 11.8826 1.64625 11.8632C1.73937 11.8439 1.83563 11.8432 1.93063 11.8451C2.02562 11.847 2.12125 11.8526 2.21625 11.8445C2.31125 11.837 2.40688 11.8157 2.48937 11.7682C2.56813 11.7232 2.6325 11.6564 2.68562 11.5832C2.73875 11.5101 2.78188 11.4301 2.82625 11.3507C2.87 11.272 2.91562 11.1932 2.97375 11.1232C3.03125 11.0532 3.1025 10.9926 3.18625 10.9582Z" fill="var(--svg-fill-D5A00B)"/><path d="M14.3419 13.9326C14.2006 14.1001 14.0044 14.2107 13.8087 14.3107C13.4756 14.4801 13.13 14.6295 12.8169 14.8338C12.6069 14.9707 12.4131 15.1313 12.2319 15.3045C12.0769 15.4526 11.93 15.6107 11.7562 15.7364C11.5806 15.8632 11.3781 15.9551 11.1637 15.987C11.1043 15.9957 11.045 16.0001 10.985 16.0001C10.7825 16.0001 10.58 15.9514 10.3937 15.8701C10.225 15.797 10.0625 15.6913 9.96498 15.5351C9.86748 15.3776 9.84498 15.1857 9.84498 15.0001C9.84435 14.6732 9.90498 14.3495 9.96185 14.027C10.0094 13.7588 10.0544 13.4907 10.0837 13.2201C10.1368 12.7289 10.1362 12.232 10.1012 11.7382C10.095 11.6557 10.0881 11.5726 10.1006 11.4907C10.1131 11.4089 10.1469 11.327 10.2094 11.2732C10.2675 11.2232 10.345 11.2007 10.4219 11.197C10.4981 11.1926 10.5743 11.2045 10.65 11.2157C10.8281 11.242 11.0081 11.262 11.1825 11.3082C11.2925 11.337 11.4 11.3757 11.5093 11.4057C11.6931 11.4551 11.885 11.4788 12.0731 11.457C12.2762 11.4332 12.4737 11.357 12.6781 11.362C12.7619 11.3638 12.845 11.3795 12.925 11.4051C13.0062 11.4307 13.0869 11.4676 13.1469 11.5289C13.1925 11.5751 13.2244 11.6332 13.2481 11.6939C13.2837 11.7839 13.3031 11.8801 13.3112 11.9763C13.3181 12.062 13.3169 12.1488 13.3331 12.2332C13.36 12.3713 13.4331 12.4982 13.5231 12.6063C13.6137 12.7151 13.7219 12.807 13.83 12.8976C13.9381 12.9882 14.0462 13.0782 14.1625 13.1576C14.2169 13.1951 14.2731 13.2301 14.325 13.2707C14.3769 13.312 14.4244 13.3595 14.4569 13.417C14.485 13.4676 14.5 13.5245 14.5 13.5826C14.5 13.6151 14.4956 13.6476 14.4856 13.6801C14.4575 13.7695 14.4056 13.8563 14.3419 13.9326Z" fill="url(#paint1_linear_6217_807)"/><path d="M14.3419 13.9326C14.2006 14.1001 14.0044 14.2107 13.8087 14.3107C13.4756 14.4801 13.13 14.6295 12.8169 14.8338C12.6069 14.9707 12.4131 15.1313 12.2319 15.3045C12.0769 15.4526 11.93 15.6107 11.7562 15.7364C11.5806 15.8632 11.3781 15.9551 11.1637 15.987C11.1043 15.9957 11.045 16.0001 10.985 16.0001C10.7825 16.0001 10.58 15.9514 10.3937 15.8701C10.225 15.797 10.0625 15.6913 9.96498 15.5351C9.86748 15.3776 9.84498 15.1857 9.84498 15.0001C9.84435 14.6732 9.90498 14.3495 9.96185 14.027C10.0094 13.7588 10.0544 13.4907 10.0837 13.2201C10.1368 12.7289 10.1362 12.232 10.1012 11.7382C10.095 11.6557 10.0881 11.5726 10.1006 11.4907C10.1131 11.4089 10.1469 11.327 10.2094 11.2732C10.2675 11.2232 10.345 11.2007 10.4219 11.197C10.4981 11.1926 10.5743 11.2045 10.65 11.2157C10.8281 11.242 11.0081 11.262 11.1825 11.3082C11.2925 11.337 11.4 11.3757 11.5093 11.4057C11.6931 11.4551 11.885 11.4788 12.0731 11.457C12.2762 11.4332 12.4737 11.357 12.6781 11.362C12.7619 11.3638 12.845 11.3795 12.925 11.4051C13.0062 11.4307 13.0869 11.4676 13.1469 11.5289C13.1925 11.5751 13.2244 11.6332 13.2481 11.6939C13.2837 11.7839 13.3031 11.8801 13.3112 11.9763C13.3181 12.062 13.3169 12.1488 13.3331 12.2332C13.36 12.3713 13.4331 12.4982 13.5231 12.6063C13.6137 12.7151 13.7219 12.807 13.83 12.8976C13.9381 12.9882 14.0462 13.0782 14.1625 13.1576C14.2169 13.1951 14.2731 13.2301 14.325 13.2707C14.3769 13.312 14.4244 13.3595 14.4569 13.417C14.485 13.4676 14.5 13.5245 14.5 13.5826C14.5 13.6151 14.4956 13.6476 14.4856 13.6801C14.4575 13.7695 14.4056 13.8563 14.3419 13.9326Z" fill="var(--svg-fill-D5A00B)"/><path d="M12.8468 11.17C12.8249 11.1107 12.7862 11.0582 12.7393 11.0157C12.6924 10.9732 12.6368 10.9407 12.5787 10.9157C12.4624 10.8663 12.3356 10.8475 12.2106 10.8244C12.0937 10.8025 11.9768 10.7757 11.8593 10.7557C11.7368 10.735 11.6106 10.7213 11.4893 10.7488C11.3837 10.7725 11.2856 10.8275 11.2056 10.9007C11.1256 10.9738 11.0631 11.065 11.0181 11.1638C10.9387 11.3382 10.9137 11.5338 10.9287 11.7244C10.9399 11.8663 10.9762 12.0125 11.0693 12.1194C11.1449 12.2063 11.2518 12.2607 11.3618 12.2932C11.5518 12.3494 11.7587 12.3463 11.9468 12.285C12.2574 12.1807 12.5324 11.9738 12.7187 11.7044C12.7799 11.615 12.8324 11.5182 12.8562 11.4132C12.8743 11.3332 12.8749 11.2469 12.8468 11.17Z" fill="var(--svg-fill-020204)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.97565 2.39237C7.82627 2.49549 7.70065 2.63862 7.6394 2.80987C7.58561 2.95952 7.5833 3.12152 7.612 3.27894C7.64463 3.3208 7.67149 3.36741 7.69445 3.41541C7.70239 3.43204 7.70993 3.44889 7.71747 3.46572C7.74138 3.51909 7.76521 3.5723 7.80132 3.61791C7.83904 3.66541 7.88785 3.70145 7.93691 3.73768C7.95371 3.75008 7.97053 3.7625 7.98695 3.77541C8.01882 3.80041 8.05007 3.82729 8.07507 3.85916C8.1007 3.89104 8.12007 3.92791 8.12882 3.96791C8.13662 4.0069 8.1329 4.04762 8.12044 4.08509C8.20283 4.13235 8.29406 4.16436 8.38815 4.17549C8.50502 4.18924 8.62565 4.16987 8.73002 4.11612C8.85627 4.04987 8.95315 3.93424 9.01315 3.80487C9.07315 3.67487 9.09877 3.53174 9.1069 3.38862C9.1169 3.20737 9.0994 3.02237 9.0394 2.85049C8.9744 2.66362 8.8569 2.49112 8.69065 2.38362C8.60815 2.32987 8.51377 2.29299 8.41565 2.27924C8.31752 2.26549 8.21627 2.27612 8.12377 2.31174C8.07127 2.33237 8.02252 2.36049 7.97565 2.39237ZM8.32116 2.84481C8.26491 2.84856 8.20991 2.86794 8.16178 2.89794C8.11428 2.92794 8.07366 2.96856 8.04179 3.01544C7.97741 3.10856 7.94929 3.22231 7.94491 3.33544C7.94179 3.41981 7.95116 3.50544 7.97929 3.58544C8.00741 3.66544 8.05429 3.73981 8.11991 3.79356C8.18678 3.84919 8.27116 3.88231 8.35804 3.88669C8.44491 3.89044 8.53241 3.86544 8.60366 3.81606C8.66054 3.77669 8.70616 3.72231 8.73866 3.66106C8.77116 3.60044 8.79116 3.53294 8.79991 3.46419C8.81554 3.34356 8.79804 3.21731 8.74179 3.10856C8.68616 2.99981 8.59116 2.91044 8.47678 2.86856C8.42678 2.85044 8.37366 2.84106 8.32116 2.84481Z" fill="var(--svg-fill-white)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.51885 4.17797C6.4442 4.1995 6.36326 4.20207 6.28803 4.18296C6.20365 4.16233 6.12678 4.11421 6.06615 4.05233C6.00553 3.98983 5.9599 3.91421 5.9274 3.83296C5.8624 3.67171 5.84928 3.49483 5.83678 3.32171C5.82303 3.12983 5.80928 2.93233 5.8699 2.74983C5.90053 2.65921 5.9499 2.57296 6.02053 2.50733C6.09053 2.44171 6.1824 2.39733 6.27803 2.39233C6.3499 2.38858 6.4224 2.40671 6.4874 2.43858C6.55178 2.47046 6.60928 2.51546 6.65928 2.56733C6.76303 2.67421 6.8374 2.80796 6.88428 2.94921C6.92628 3.0775 6.94612 3.2125 6.95128 3.34764C6.92096 3.38777 6.89312 3.42985 6.86527 3.47193C6.82275 3.53619 6.78021 3.60048 6.72882 3.65791C6.70521 3.68458 6.67987 3.70952 6.65455 3.73444C6.62291 3.76557 6.59132 3.79667 6.5632 3.83104C6.5382 3.86229 6.5157 3.89541 6.50007 3.93229C6.48382 3.96854 6.47445 4.00854 6.4757 4.04854C6.47757 4.09041 6.4907 4.13166 6.51195 4.16729C6.51417 4.1709 6.51647 4.17446 6.51885 4.17797ZM6.06735 3.54986C6.0261 3.43486 6.02673 3.30799 6.04673 3.18674C6.0561 3.13174 6.06923 3.07674 6.09485 3.02736C6.12048 2.97799 6.15985 2.93424 6.21048 2.91111C6.2561 2.89049 6.30923 2.88736 6.35798 2.89924C6.40673 2.91049 6.45173 2.93611 6.49048 2.96861C6.57048 3.03611 6.62235 3.13299 6.65298 3.23361C6.6961 3.37174 6.70298 3.52236 6.65985 3.66049C6.64548 3.70736 6.62485 3.75299 6.59423 3.79111C6.5636 3.82924 6.52235 3.85986 6.47485 3.87174C6.42298 3.88424 6.36798 3.87486 6.31985 3.85174C6.27235 3.82861 6.2311 3.79361 6.19548 3.75486C6.14048 3.69549 6.09485 3.62611 6.06735 3.54986Z" fill="var(--svg-fill-white)"/><path d="M5.82129 4.69062C5.82504 4.70687 5.83066 4.72187 5.83879 4.73625C5.85316 4.76 5.87441 4.77937 5.89691 4.79562C5.91941 4.8125 5.94379 4.82625 5.96754 4.84062C6.09316 4.92 6.19566 5.03062 6.28691 5.14812C6.40879 5.30562 6.51691 5.48 6.68004 5.59437C6.79504 5.67562 6.93254 5.72125 7.07254 5.73562C7.23691 5.75187 7.40316 5.72562 7.56191 5.67875C7.70879 5.63562 7.85066 5.575 7.98066 5.49437C8.22879 5.34187 8.43566 5.11812 8.70879 5.0175C8.76816 4.99562 8.83004 4.98 8.88754 4.95312C8.94504 4.92562 8.99941 4.88562 9.02691 4.82812C9.05316 4.77312 9.05191 4.70937 9.06066 4.64875C9.07004 4.58437 9.09066 4.52187 9.10191 4.4575C9.11316 4.39312 9.11441 4.32437 9.08691 4.265C9.06379 4.21625 9.02191 4.1775 8.97379 4.15312C8.92566 4.12812 8.87129 4.11687 8.81691 4.11437C8.70941 4.10937 8.60254 4.13687 8.49441 4.14687C8.35191 4.16 8.20816 4.14125 8.06504 4.14562C7.88691 4.15125 7.71129 4.19125 7.53316 4.2C7.33004 4.20937 7.12754 4.17812 6.92441 4.17C6.83629 4.16625 6.74754 4.1675 6.66066 4.1825C6.57379 4.19687 6.48879 4.22687 6.41629 4.27687C6.34566 4.32562 6.28941 4.39187 6.22441 4.44812C6.19191 4.47625 6.15691 4.50187 6.11816 4.52062C6.08004 4.53937 6.03754 4.55125 5.99441 4.55C5.97254 4.54937 5.94941 4.54625 5.92879 4.5525C5.91566 4.55687 5.90379 4.565 5.89379 4.57437C5.88379 4.58437 5.87566 4.59562 5.86816 4.60687C5.85004 4.63312 5.83441 4.66125 5.82129 4.69062Z" fill="url(#paint2_radial_6217_807)"/><path d="M6.24622 3.9969C6.14247 4.0669 6.04872 4.15252 5.96934 4.2494C5.92434 4.30502 5.88309 4.36565 5.86059 4.43315C5.84247 4.4869 5.83622 4.54315 5.82497 4.59877C5.82059 4.6194 5.81559 4.64002 5.81622 4.66127C5.81622 4.67127 5.81747 4.6819 5.82059 4.69252C5.82372 4.70252 5.82934 4.7119 5.83622 4.7194C5.84872 4.7319 5.86559 4.73877 5.88247 4.74252C5.89997 4.74565 5.91747 4.74627 5.93497 4.74815C6.01309 4.75752 6.08497 4.79502 6.14997 4.84002C6.21497 4.8844 6.27497 4.9369 6.34184 4.97877C6.48872 5.0719 6.66434 5.11315 6.83872 5.12002C7.01247 5.1269 7.18622 5.10065 7.35747 5.06627C7.49309 5.0394 7.62809 5.0069 7.75684 4.95627C7.95434 4.87815 8.13247 4.75877 8.30184 4.6319C8.37934 4.5744 8.45559 4.51502 8.52497 4.44815C8.54809 4.42502 8.57122 4.4019 8.59622 4.38065C8.62122 4.36002 8.64934 4.3419 8.68059 4.3319C8.72809 4.3169 8.77934 4.32127 8.82872 4.3294C8.86559 4.33565 8.90247 4.34377 8.93997 4.34252C8.95872 4.34127 8.97747 4.33815 8.99497 4.33127C9.01247 4.3244 9.02872 4.31377 9.04059 4.29877C9.05622 4.28002 9.06434 4.25502 9.06434 4.23065C9.06434 4.20565 9.05684 4.18127 9.04434 4.16002C9.01934 4.11752 8.97622 4.08877 8.93122 4.06877C8.86934 4.04127 8.80247 4.02815 8.73684 4.0119C8.53497 3.96315 8.33872 3.89127 8.15309 3.79877C8.06059 3.75315 7.97059 3.70252 7.87997 3.65377C7.78622 3.60377 7.69122 3.55565 7.58997 3.5244C7.36247 3.45565 7.11497 3.47815 6.89059 3.55627C6.64184 3.64252 6.41684 3.79627 6.24622 3.9969Z" fill="url(#paint3_linear_6217_807)"/></g><defs><linearGradient id="paint0_linear_6217_807" x1="2.44875" y1="12.0632" x2="5.01938" y2="16.3764" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-B98309)"/><stop offset="1" stop-color="var(--svg-stop-color-382605)"/></linearGradient><linearGradient id="paint1_linear_6217_807" x1="10.4687" y1="15.8138" x2="13.0587" y2="11.6151" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-3E2A06)"/><stop offset="1" stop-color="var(--svg-stop-color-AD780A)"/></linearGradient><radialGradient id="paint2_radial_6217_807" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(7.86066 4.41312) rotate(-22.4) scale(1.69688 1.19187)"><stop stop-color="var(--svg-stop-color-D2940A)"/><stop offset="0.75" stop-color="var(--svg-stop-color-D89C08)"/><stop offset="0.87" stop-color="var(--svg-stop-color-B67E07)"/><stop offset="1" stop-color="var(--svg-stop-color-946106)"/></radialGradient><linearGradient id="paint3_linear_6217_807" x1="5.88059" y1="4.32877" x2="8.92309" y2="4.30502" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-AD780A)"/><stop offset="0.12" stop-color="var(--svg-stop-color-D89E08)"/><stop offset="0.25" stop-color="var(--svg-stop-color-EDB80B)"/><stop offset="0.39" stop-color="var(--svg-stop-color-EBC80D)"/><stop offset="0.53" stop-color="var(--svg-stop-color-F5D838)"/><stop offset="0.77" stop-color="var(--svg-stop-color-F6D811)"/><stop offset="1" stop-color="var(--svg-stop-color-F5CD31)"/></linearGradient><clipPath id="clip0_6217_807"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "list": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M5.33325 4H13.9999" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M5.33325 8H13.9999" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M5.33325 12H13.9999" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 4H2.00667" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 8H2.00667" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 12H2.00667" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "logs": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path d="M20 1.5C20.8284 1.5 21.5 2.17157 21.5 3L21.5 21C21.5 21.8284 20.8284 22.5 20 22.5L3.5 22.5L3.5 1.5L20 1.5Z M6 1 V23" stroke="var(--svg-stroke-7F848D)"/><path d="M9 7 H18.5 M9 11 H15" stroke="var(--svg-stroke-6890D9)" stroke-width="1.5" /></svg>',
    "L_Del_Arr_Fil": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M14.5001 7.80596C14.1003 7.89667 13.7204 8.09769 13.4091 8.40901L12.5001 9.31802L11.5911 8.40901C10.7124 7.53033 9.28777 7.53033 8.40909 8.40901C7.53041 9.28769 7.53041 10.7123 8.40909 11.591L8.50008 11.682V12.6294C8.50008 13.1525 7.87745 13.4251 7.49311 13.0703L2.4777 8.44072C2.22032 8.20314 2.22032 7.79653 2.4777 7.55896L7.49311 2.92935C7.87745 2.57457 8.50008 2.84718 8.50008 3.37023V5.49952H13.5001C14.0524 5.49952 14.5001 5.94723 14.5001 6.49952V7.80596Z" fill="var(--svg-fill-31A629)"/><path d="M14.5001 7.80596L14.6107 8.29356C14.8384 8.24189 15.0001 8.03947 15.0001 7.80596H14.5001ZM13.4091 8.40901L13.7626 8.76256L13.4091 8.40901ZM12.5001 9.31802L12.1465 9.67157C12.3418 9.86684 12.6584 9.86684 12.8536 9.67157L12.5001 9.31802ZM11.5911 8.40901L11.2375 8.76256L11.5911 8.40901ZM8.40909 8.40901L8.76264 8.76256L8.40909 8.40901ZM8.50008 11.682H9.00008C9.00008 11.5494 8.9474 11.4222 8.85363 11.3284L8.50008 11.682ZM7.49311 13.0703L7.83225 12.7029L7.83225 12.7029L7.49311 13.0703ZM2.4777 8.44072L2.13856 8.80812H2.13856L2.4777 8.44072ZM2.4777 7.55896L2.81684 7.92636H2.81684L2.4777 7.55896ZM7.49311 2.92935L7.15397 2.56194V2.56194L7.49311 2.92935ZM8.50008 5.49952H8.00008C8.00008 5.77566 8.22394 5.99952 8.50008 5.99952V5.49952ZM14.3894 7.31835C13.9003 7.42933 13.4355 7.6755 13.0555 8.05546L13.7626 8.76256C14.0053 8.51989 14.3002 8.36402 14.6107 8.29356L14.3894 7.31835ZM13.0555 8.05546L12.1465 8.96447L12.8536 9.67157L13.7626 8.76256L13.0555 8.05546ZM12.8536 8.96447L11.9446 8.05546L11.2375 8.76256L12.1465 9.67157L12.8536 8.96447ZM11.9446 8.05546C10.8707 6.98151 9.12948 6.98151 8.05553 8.05546L8.76264 8.76256C9.44606 8.07915 10.5541 8.07915 11.2375 8.76256L11.9446 8.05546ZM8.05553 8.05546C6.98159 9.1294 6.98159 10.8706 8.05553 11.9445L8.76264 11.2374C8.07922 10.554 8.07922 9.44598 8.76264 8.76256L8.05553 8.05546ZM8.05553 11.9445L8.14652 12.0355L8.85363 11.3284L8.76264 11.2374L8.05553 11.9445ZM8.00008 11.682V12.6294H9.00008V11.682H8.00008ZM8.00008 12.6294C8.00008 12.6577 7.99262 12.6742 7.98487 12.6855C7.97567 12.6988 7.96058 12.7121 7.94019 12.7211C7.91979 12.73 7.8998 12.7321 7.88374 12.7298C7.8702 12.7278 7.85301 12.7221 7.83225 12.7029L7.15397 13.4377C7.8586 14.0882 9.00008 13.5884 9.00008 12.6294H8.00008ZM7.83225 12.7029L2.81684 8.07332L2.13856 8.80812L7.15397 13.4377L7.83225 12.7029ZM2.81684 8.07332C2.77394 8.03372 2.77394 7.96596 2.81684 7.92636L2.13856 7.19156C1.66671 7.62711 1.6667 8.37256 2.13856 8.80812L2.81684 8.07332ZM2.81684 7.92636L7.83225 3.29675L7.15397 2.56194L2.13856 7.19156L2.81684 7.92636ZM7.83225 3.29675C7.85301 3.27759 7.8702 3.27187 7.88374 3.26992C7.8998 3.26761 7.91979 3.26969 7.94019 3.27862C7.96058 3.28755 7.97567 3.30083 7.98487 3.3142C7.99262 3.32547 8.00008 3.34198 8.00008 3.37023H9.00008C9.00008 2.4113 7.8586 1.91152 7.15397 2.56194L7.83225 3.29675ZM8.00008 3.37023V5.49952H9.00008V3.37023H8.00008ZM8.50008 5.99952H13.5001V4.99952H8.50008V5.99952ZM13.5001 5.99952C13.7762 5.99952 14.0001 6.22338 14.0001 6.49952H15.0001C15.0001 5.67109 14.3285 4.99952 13.5001 4.99952V5.99952ZM14.0001 6.49952V7.80596H15.0001V6.49952H14.0001Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M9.46967 14.4697C9.17678 14.7626 9.17678 15.2374 9.46967 15.5303C9.76256 15.8232 10.2374 15.8232 10.5303 15.5303L12.5 13.5607L14.4697 15.5303C14.7626 15.8232 15.2374 15.8232 15.5303 15.5303C15.8232 15.2374 15.8232 14.7626 15.5303 14.4697L13.5607 12.5L15.5303 10.5303C15.8232 10.2374 15.8232 9.76256 15.5303 9.46967C15.2374 9.17678 14.7626 9.17678 14.4697 9.46967L12.5 11.4393L10.5303 9.46967C10.2374 9.17678 9.76256 9.17678 9.46967 9.46967C9.17678 9.76256 9.17678 10.2374 9.46967 10.5303L11.4393 12.5L9.46967 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "L_Del_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.00008 3.37024C8.00008 3.34199 7.99262 3.32548 7.98487 3.31421C7.97567 3.30084 7.96058 3.28757 7.94019 3.27864C7.91979 3.2697 7.8998 3.26762 7.88374 3.26993C7.8702 3.27188 7.85301 3.2776 7.83225 3.29676L2.81684 7.92637C2.77394 7.96597 2.77394 8.03373 2.81684 8.07333L7.83225 12.7029C7.85301 12.7221 7.8702 12.7278 7.88374 12.7298C7.8998 12.7321 7.91979 12.73 7.94019 12.7211C7.96058 12.7121 7.97567 12.6989 7.98487 12.6855C7.99262 12.6742 8.00008 12.6577 8.00008 12.6295V11.5008C8.07011 11.5939 8.14749 11.6832 8.23223 11.7679L8.96447 12.5002L8.23223 13.2324C8.07947 13.3852 7.95061 13.5528 7.84565 13.7306C7.60405 13.72 7.36028 13.6282 7.15397 13.4377L2.13856 8.80813C1.6667 8.37257 1.66671 7.62712 2.13856 7.19157L7.15397 2.56196C7.8586 1.91153 9.00008 2.41131 9.00008 3.37024V4.99953H13.5001C14.3285 4.99953 15.0001 5.6711 15.0001 6.49953V7.50016C14.6591 7.50015 14.3181 7.56947 14.0001 7.70811V6.49953C14.0001 6.22339 13.7762 5.99953 13.5001 5.99953H8.50008C8.22394 5.99953 8.00008 5.77567 8.00008 5.49953V3.37024Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M9.46967 14.4697C9.17678 14.7626 9.17678 15.2374 9.46967 15.5303C9.76256 15.8232 10.2374 15.8232 10.5303 15.5303L12.5 13.5607L14.4697 15.5303C14.7626 15.8232 15.2374 15.8232 15.5303 15.5303C15.8232 15.2374 15.8232 14.7626 15.5303 14.4697L13.5607 12.5L15.5303 10.5303C15.8232 10.2374 15.8232 9.76256 15.5303 9.46967C15.2374 9.17678 14.7626 9.17678 14.4697 9.46967L12.5 11.4393L10.5303 9.46967C10.2374 9.17678 9.76256 9.17678 9.46967 9.46967C9.17678 9.76256 9.17678 10.2374 9.46967 10.5303L11.4393 12.5L9.46967 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "L_Del_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M10.1539 2.56196C10.8585 1.91153 12 2.41131 12 3.37024V4.99953H13.5C14.3284 4.99953 15 5.6711 15 6.49953V8.25C14.5521 8.25 14.1043 8.42085 13.7626 8.76256L12.5 10.0251L11.2374 8.76256C10.554 8.07915 9.44598 8.07915 8.76256 8.76256C8.07915 9.44598 8.07915 10.554 8.76256 11.2374L10.0251 12.5L9.59931 12.9258L5.13849 8.80813C4.66663 8.37257 4.66663 7.62712 5.13849 7.19157L10.1539 2.56196ZM7.35356 2.64646C7.1583 2.4512 6.84172 2.4512 6.64645 2.64646L2.07072 7.22219C1.64114 7.65177 1.64114 8.34825 2.07072 8.77783L6.64645 13.3536C6.84172 13.5488 7.1583 13.5488 7.35356 13.3536C7.54882 13.1583 7.54882 12.8417 7.35356 12.6465L2.77782 8.07072C2.73877 8.03167 2.73877 7.96835 2.77782 7.9293L7.35356 3.35356C7.54882 3.1583 7.54882 2.84172 7.35356 2.64646Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M9.46967 14.4697C9.17678 14.7626 9.17678 15.2374 9.46967 15.5303C9.76256 15.8232 10.2374 15.8232 10.5303 15.5303L12.5 13.5607L14.4697 15.5303C14.7626 15.8232 15.2374 15.8232 15.5303 15.5303C15.8232 15.2374 15.8232 14.7626 15.5303 14.4697L13.5607 12.5L15.5303 10.5303C15.8232 10.2374 15.8232 9.76256 15.5303 9.46967C15.2374 9.17678 14.7626 9.17678 14.4697 9.46967L12.5 11.4393L10.5303 9.46967C10.2374 9.17678 9.76256 9.17678 9.46967 9.46967C9.17678 9.76256 9.17678 10.2374 9.46967 10.5303L11.4393 12.5L9.46967 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "L_Del_Dbl_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M10.9848 3.31421C10.9926 3.32548 11 3.34199 11 3.37024V5.49953C11 5.77567 11.2239 5.99953 11.5 5.99953H13.5C13.7761 5.99953 14 6.22339 14 6.49953V8.56349C14.2995 8.3545 14.6497 8.25 15 8.25V6.49953C15 5.6711 14.3284 4.99953 13.5 4.99953H12V3.37024C12 2.41131 10.8585 1.91153 10.1539 2.56196L5.13849 7.19157C4.66663 7.62712 4.66663 8.37257 5.13849 8.80813L9.59931 12.9258L10.0251 12.5L8.76256 11.2374C8.51094 10.9858 8.35196 10.6766 8.28562 10.3523L5.81677 8.07333C5.77387 8.03373 5.77387 7.96597 5.81677 7.92637L10.8322 3.29676C10.8529 3.2776 10.8701 3.27188 10.8837 3.26993C10.8997 3.26762 10.9197 3.2697 10.9401 3.27864C10.9605 3.28757 10.9756 3.30084 10.9848 3.31421ZM12.4744 9.99953L12.5 10.0251L12.5256 9.99953H12.4744ZM7.35356 2.64646C7.1583 2.4512 6.84172 2.4512 6.64645 2.64646L2.07072 7.22219C1.64114 7.65177 1.64114 8.34825 2.07072 8.77783L6.64645 13.3536C6.84172 13.5488 7.1583 13.5488 7.35356 13.3536C7.54882 13.1583 7.54882 12.8417 7.35356 12.6465L2.77782 8.07072C2.73877 8.03167 2.73877 7.96835 2.77782 7.9293L7.35356 3.35356C7.54882 3.1583 7.54882 2.84172 7.35356 2.64646Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M9.46967 14.4697C9.17678 14.7626 9.17678 15.2374 9.46967 15.5303C9.76256 15.8232 10.2374 15.8232 10.5303 15.5303L12.5 13.5607L14.4697 15.5303C14.7626 15.8232 15.2374 15.8232 15.5303 15.5303C15.8232 15.2374 15.8232 14.7626 15.5303 14.4697L13.5607 12.5L15.5303 10.5303C15.8232 10.2374 15.8232 9.76256 15.5303 9.46967C15.2374 9.17678 14.7626 9.17678 14.4697 9.46967L12.5 11.4393L10.5303 9.46967C10.2374 9.17678 9.76256 9.17678 9.46967 9.46967C9.17678 9.76256 9.17678 10.2374 9.46967 10.5303L11.4393 12.5L9.46967 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "L_Dis_Arr_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M7.15385 2.56196C7.85848 1.91153 8.99996 2.41131 8.99996 3.37024V4.99953H13.5C14.3284 4.99953 15 5.6711 15 6.49953V9.49953C15 10.328 14.3284 10.9995 13.5 10.9995H8.99996V12.6295C8.99996 13.5884 7.85847 14.0882 7.15385 13.4377L2.13844 8.80813C1.66658 8.37257 1.66658 7.62712 2.13844 7.19157L7.15385 2.56196Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "L_Dis_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.5 10.4997H8C8 10.2235 8.22386 9.99968 8.5 9.99968V10.4997ZM7.49303 13.0705L7.83217 12.7031L7.83217 12.7031L7.49303 13.0705ZM2.47762 8.44088L2.13848 8.80828L2.47762 8.44088ZM2.47762 7.55912L2.81676 7.92652L2.47762 7.55912ZM7.49303 2.92951L7.15389 2.56211V2.56211L7.49303 2.92951ZM8.5 5.49968V5.99968C8.22386 5.99968 8 5.77582 8 5.49968H8.5ZM8 12.6296V10.4997H9V12.6296H8ZM7.83217 12.7031C7.85293 12.7222 7.87012 12.728 7.88366 12.7299C7.89972 12.7322 7.91971 12.7301 7.94011 12.7212C7.96051 12.7123 7.97559 12.699 7.98479 12.6856C7.99255 12.6744 8 12.6579 8 12.6296H9C9 13.5885 7.85852 14.0883 7.15389 13.4379L7.83217 12.7031ZM2.81676 8.07348L7.83217 12.7031L7.15389 13.4379L2.13848 8.80828L2.81676 8.07348ZM2.81676 7.92652C2.77387 7.96612 2.77387 8.03388 2.81676 8.07348L2.13848 8.80828C1.66663 8.37272 1.66663 7.62727 2.13848 7.19172L2.81676 7.92652ZM7.83217 3.29691L2.81676 7.92652L2.13848 7.19172L7.15389 2.56211L7.83217 3.29691ZM8 3.37039C8 3.34214 7.99255 3.32563 7.98479 3.31436C7.97559 3.30099 7.96051 3.28772 7.94011 3.27879C7.91971 3.26985 7.89972 3.26777 7.88366 3.27008C7.87012 3.27203 7.85293 3.27775 7.83217 3.29691L7.15389 2.56211C7.85852 1.91168 9 2.41146 9 3.37039H8ZM8 5.49968V3.37039H9V5.49968H8ZM13.5 5.99968H8.5V4.99968H13.5V5.99968ZM14 6.49968C14 6.22354 13.7761 5.99968 13.5 5.99968V4.99968C14.3284 4.99968 15 5.67125 15 6.49968H14ZM14 9.49968V6.49968H15V9.49968H14ZM13.5 9.99968C13.7761 9.99968 14 9.77582 14 9.49968H15C15 10.3281 14.3284 10.9997 13.5 10.9997V9.99968ZM8.5 9.99968H13.5V10.9997H8.5V9.99968Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "L_Dis_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M12 3.37024C12 2.41131 10.8585 1.91153 10.1539 2.56196L5.13849 7.19157C4.66663 7.62712 4.66663 8.37257 5.13849 8.80813L10.1539 13.4377C10.8585 14.0882 12 13.5884 12 12.6295V10.9995H13.5C14.3284 10.9995 15 10.328 15 9.49953V6.49953C15 5.6711 14.3284 4.99953 13.5 4.99953H12V3.37024ZM6.64645 2.64646C6.84172 2.4512 7.1583 2.4512 7.35356 2.64646C7.54882 2.84172 7.54882 3.1583 7.35356 3.35356L2.77782 7.9293C2.73877 7.96835 2.73877 8.03167 2.77782 8.07072L7.35356 12.6465C7.54882 12.8417 7.54882 13.1583 7.35356 13.3536C7.1583 13.5488 6.84172 13.5488 6.64645 13.3536L2.07072 8.77783C1.64114 8.34825 1.64114 7.65177 2.07072 7.22219L6.64645 2.64646Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "L_Dis_Dbl_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M11 3.37024C11 3.34199 10.9926 3.32548 10.9848 3.31421C10.9756 3.30084 10.9605 3.28757 10.9401 3.27864C10.9197 3.2697 10.8997 3.26762 10.8837 3.26993C10.8701 3.27188 10.8529 3.2776 10.8322 3.29676L5.81677 7.92637C5.77387 7.96597 5.77387 8.03373 5.81677 8.07333L10.8322 12.7029C10.8529 12.7221 10.8701 12.7278 10.8837 12.7298C10.8997 12.7321 10.9197 12.73 10.9401 12.7211C10.9605 12.7121 10.9756 12.6989 10.9848 12.6855C10.9926 12.6742 11 12.6577 11 12.6295V10.4995C11 10.2234 11.2239 9.99953 11.5 9.99953H13.5C13.7761 9.99953 14 9.77567 14 9.49953V6.49953C14 6.22339 13.7761 5.99953 13.5 5.99953H11.5C11.2239 5.99953 11 5.77567 11 5.49953V3.37024ZM10.1539 2.56196C10.8585 1.91153 12 2.41131 12 3.37024V4.99953H13.5C14.3284 4.99953 15 5.6711 15 6.49953V9.49953C15 10.328 14.3284 10.9995 13.5 10.9995H12V12.6295C12 13.5884 10.8585 14.0882 10.1539 13.4377L5.13849 8.80813C4.66663 8.37257 4.66663 7.62712 5.13849 7.19157L10.1539 2.56196ZM6.64645 2.64646C6.84172 2.4512 7.1583 2.4512 7.35356 2.64646C7.54882 2.84172 7.54882 3.1583 7.35356 3.35356L2.77782 7.9293C2.73877 7.96835 2.73877 8.03167 2.77782 8.07072L7.35356 12.6465C7.54882 12.8417 7.54882 13.1583 7.35356 13.3536C7.1583 13.5488 6.84172 13.5488 6.64645 13.3536L2.07072 8.77783C1.64114 8.34825 1.64114 7.65177 2.07072 7.22219L6.64645 2.64646Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "L_Ena_Arr_Aa_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.00008 3.37024C8.00008 3.34199 7.99262 3.32548 7.98487 3.31421C7.97567 3.30084 7.96058 3.28757 7.94019 3.27864C7.91979 3.2697 7.8998 3.26762 7.88374 3.26993C7.8702 3.27188 7.85301 3.2776 7.83225 3.29676L2.81684 7.92637C2.77394 7.96597 2.77394 8.03373 2.81684 8.07333L3.31367 8.53194L2.96936 9.57503L2.13856 8.80813C1.6667 8.37257 1.66671 7.62712 2.13856 7.19157L7.15397 2.56196C7.8586 1.91153 9.00008 2.41131 9.00008 3.37024V4.99953H13.5001C14.3285 4.99953 15.0001 5.6711 15.0001 6.49953V8.73438C14.8349 8.65991 14.663 8.59751 14.4858 8.54595C14.3278 8.4991 14.1658 8.46195 14.0001 8.43377V6.49953C14.0001 6.22339 13.7762 5.99953 13.5001 5.99953H8.50008C8.22394 5.99953 8.00008 5.77567 8.00008 5.49953V3.37024ZM11.1745 9.99953H13.5001C13.7762 9.99953 14.0001 9.77567 14.0001 9.49953V9.45251C14.0698 9.46808 14.1377 9.48571 14.2038 9.5054C14.4951 9.58989 14.7465 9.70613 14.9579 9.8541C14.8102 10.4636 14.2901 10.9277 13.6521 10.9919C13.6244 10.9389 13.5837 10.8937 13.5301 10.8565C13.419 10.7792 13.2766 10.7406 13.1027 10.7406C13.0799 10.7406 13.0576 10.7412 13.0358 10.7424L13.0163 10.7436L13.0018 10.7448L12.9929 10.7456C12.9451 10.7501 12.8998 10.7578 12.8571 10.7685C12.7734 10.7896 12.6995 10.8225 12.6354 10.8673C12.5841 10.903 12.5416 10.947 12.508 10.9995H10.6153C10.6646 10.7558 10.7609 10.527 10.9041 10.3131C10.919 10.291 10.9344 10.2691 10.9503 10.2477C11.0161 10.1591 11.0908 10.0764 11.1745 9.99953ZM9.92647 9.99953H9.28415L9.60566 10.9736C9.65399 10.6299 9.76185 10.3036 9.92647 9.99953ZM4.12081 9.27699L3.77651 10.3201L5.37298 11.7938L5.69428 10.7294L4.12081 9.27699ZM6.69912 11.657L7.83225 12.7029C7.85301 12.7221 7.8702 12.7278 7.88374 12.7298C7.8998 12.7321 7.91979 12.73 7.94019 12.7211C7.96058 12.7121 7.97567 12.6989 7.98487 12.6855C7.99262 12.6742 8.00008 12.6577 8.00008 12.6295V10.4995C8.00008 10.3134 8.10179 10.151 8.25267 10.0649L9.00008 12.3293V12.6295C9.00008 13.5884 7.8586 14.0882 7.15397 13.4377L5.67605 12.0735H6.82487L6.69912 11.657Z" fill="var(--svg-fill-31A629)"/><path d="M4.40523 15.0002H2.23193L4.68051 7.58203H7.43335L9.88193 15.0002H7.70864L6.08591 9.62493H6.02796L4.40523 15.0002ZM3.99955 12.0735H8.08534V13.5803H3.99955V12.0735Z" fill="var(--svg-fill-32A5FF)"/><path d="M12.1757 15.0871C11.8207 15.0871 11.5068 15.0292 11.2339 14.9133C10.9635 14.795 10.7509 14.6163 10.5964 14.3772C10.4419 14.1381 10.3646 13.8339 10.3646 13.4644C10.3646 13.1602 10.4165 12.9006 10.5203 12.6857C10.6242 12.4683 10.7691 12.2908 10.955 12.1532C11.1409 12.0156 11.3571 11.9105 11.6034 11.8381C11.8521 11.7656 12.1201 11.7185 12.4075 11.6968C12.719 11.6727 12.9689 11.6437 13.1573 11.6099C13.348 11.5737 13.4857 11.5241 13.5702 11.4614C13.6547 11.3962 13.697 11.3104 13.697 11.2042V11.1897C13.697 11.0448 13.6414 10.9337 13.5304 10.8565C13.4193 10.7792 13.2768 10.7406 13.1029 10.7406C12.9122 10.7406 12.7564 10.7828 12.6357 10.8673C12.5174 10.9494 12.4461 11.0762 12.422 11.2477H10.5819C10.6061 10.9096 10.7135 10.5981 10.9043 10.3131C11.0975 10.0258 11.3788 9.79638 11.7483 9.62493C12.1177 9.45107 12.5789 9.36413 13.1319 9.36413C13.5304 9.36413 13.8877 9.41122 14.2041 9.5054C14.5204 9.59716 14.7897 9.72635 15.0118 9.89297C15.234 10.0572 15.403 10.2504 15.5189 10.4725C15.6372 10.6923 15.6964 10.9313 15.6964 11.1897V15.0002H13.8274V14.2178H13.7839C13.6728 14.4255 13.5376 14.5933 13.3782 14.7213C13.2213 14.8493 13.0414 14.9423 12.8385 15.0002C12.6381 15.0582 12.4171 15.0871 12.1757 15.0871ZM12.8277 13.8266C12.9798 13.8266 13.1223 13.7952 13.2551 13.7325C13.3903 13.6697 13.5002 13.5791 13.5847 13.4608C13.6692 13.3425 13.7115 13.1988 13.7115 13.0298V12.5661C13.6583 12.5879 13.6016 12.6084 13.5412 12.6277C13.4833 12.647 13.4205 12.6651 13.3529 12.682C13.2877 12.6989 13.2176 12.7146 13.1428 12.7291C13.0703 12.7436 12.9943 12.7569 12.9146 12.769C12.76 12.7931 12.6333 12.833 12.5343 12.8885C12.4377 12.9416 12.3652 13.008 12.3169 13.0877C12.271 13.165 12.2481 13.2519 12.2481 13.3485C12.2481 13.5031 12.3024 13.6214 12.4111 13.7035C12.5198 13.7856 12.6586 13.8266 12.8277 13.8266Z" fill="var(--svg-fill-32A5FF)"/></svg>',
    "L_Ena_Arr_Fil": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.5 10.4997V12.6296C8.5 13.1527 7.87737 13.4253 7.49303 13.0705L2.47762 8.44088C2.22025 8.2033 2.22025 7.7967 2.47762 7.55912L7.49303 2.92951C7.87737 2.57473 8.5 2.84734 8.5 3.37039V5.49968H13.5C14.0523 5.49968 14.5 5.9474 14.5 6.49968V9.49968C14.5 10.052 14.0523 10.4997 13.5 10.4997H8.5Z" fill="var(--svg-fill-31A629)"/><path d="M8.5 10.4997H8C8 10.2235 8.22386 9.99968 8.5 9.99968V10.4997ZM7.49303 13.0705L7.83217 12.7031L7.83217 12.7031L7.49303 13.0705ZM2.47762 8.44088L2.13848 8.80828L2.47762 8.44088ZM2.47762 7.55912L2.81676 7.92652L2.47762 7.55912ZM7.49303 2.92951L7.15389 2.56211V2.56211L7.49303 2.92951ZM8.5 5.49968V5.99968C8.22386 5.99968 8 5.77582 8 5.49968H8.5ZM8 12.6296V10.4997H9V12.6296H8ZM7.83217 12.7031C7.85293 12.7222 7.87012 12.728 7.88366 12.7299C7.89972 12.7322 7.91971 12.7301 7.94011 12.7212C7.96051 12.7123 7.97559 12.699 7.98479 12.6856C7.99255 12.6744 8 12.6579 8 12.6296H9C9 13.5885 7.85852 14.0883 7.15389 13.4379L7.83217 12.7031ZM2.81676 8.07348L7.83217 12.7031L7.15389 13.4379L2.13848 8.80828L2.81676 8.07348ZM2.81676 7.92652C2.77387 7.96612 2.77387 8.03388 2.81676 8.07348L2.13848 8.80828C1.66663 8.37272 1.66663 7.62727 2.13848 7.19172L2.81676 7.92652ZM7.83217 3.29691L2.81676 7.92652L2.13848 7.19172L7.15389 2.56211L7.83217 3.29691ZM8 3.37039C8 3.34214 7.99255 3.32563 7.98479 3.31436C7.97559 3.30099 7.96051 3.28772 7.94011 3.27879C7.91971 3.26985 7.89972 3.26777 7.88366 3.27008C7.87012 3.27203 7.85293 3.27775 7.83217 3.29691L7.15389 2.56211C7.85852 1.91168 9 2.41146 9 3.37039H8ZM8 5.49968V3.37039H9V5.49968H8ZM13.5 5.99968H8.5V4.99968H13.5V5.99968ZM14 6.49968C14 6.22354 13.7761 5.99968 13.5 5.99968V4.99968C14.3284 4.99968 15 5.67125 15 6.49968H14ZM14 9.49968V6.49968H15V9.49968H14ZM13.5 9.99968C13.7761 9.99968 14 9.77582 14 9.49968H15C15 10.3281 14.3284 10.9997 13.5 10.9997V9.99968ZM8.5 9.99968H13.5V10.9997H8.5V9.99968Z" fill="var(--svg-fill-31A629)"/></svg>',
    "L_Ena_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.5 10.4995H8C8 10.2234 8.22386 9.99952 8.5 9.99952V10.4995ZM7.49303 13.0703L7.83217 12.7029H7.83217L7.49303 13.0703ZM2.47762 8.44072L2.13848 8.80812V8.80812L2.47762 8.44072ZM2.47762 7.55896L2.81676 7.92636L2.47762 7.55896ZM7.49303 2.92935L7.15389 2.56194V2.56194L7.49303 2.92935ZM8.5 5.49952V5.99952C8.22386 5.99952 8 5.77566 8 5.49952H8.5ZM8 12.6294V10.4995H9V12.6294H8ZM7.83217 12.7029C7.85293 12.7221 7.87012 12.7278 7.88366 12.7298C7.89972 12.7321 7.91971 12.73 7.94011 12.7211C7.96051 12.7121 7.97559 12.6988 7.98479 12.6855C7.99255 12.6742 8 12.6577 8 12.6294H9C9 13.5884 7.85852 14.0882 7.15389 13.4377L7.83217 12.7029ZM2.81676 8.07332L7.83217 12.7029L7.15389 13.4377L2.13848 8.80812L2.81676 8.07332ZM2.81676 7.92636C2.77387 7.96595 2.77387 8.03372 2.81676 8.07332L2.13848 8.80812C1.66663 8.37256 1.66663 7.62711 2.13848 7.19155L2.81676 7.92636ZM7.83217 3.29675L2.81676 7.92636L2.13848 7.19155L7.15389 2.56194L7.83217 3.29675ZM8 3.37023C8 3.34198 7.99255 3.32547 7.98479 3.3142C7.97559 3.30083 7.96051 3.28755 7.94011 3.27862C7.91971 3.26969 7.89972 3.26761 7.88366 3.26992C7.87012 3.27187 7.85293 3.27759 7.83217 3.29675L7.15389 2.56194C7.85852 1.91152 9 2.4113 9 3.37023H8ZM8 5.49952V3.37023H9V5.49952H8ZM13.5 5.99952H8.5V4.99952H13.5V5.99952ZM14 6.49952C14 6.22338 13.7761 5.99952 13.5 5.99952V4.99952C14.3284 4.99952 15 5.67109 15 6.49952H14ZM14 9.49952V6.49952H15V9.49952H14ZM13.5 9.99952C13.7761 9.99952 14 9.77566 14 9.49952H15C15 10.3279 14.3284 10.9995 13.5 10.9995V9.99952ZM8.5 9.99952H13.5V10.9995H8.5V9.99952Z" fill="var(--svg-fill-31A629)"/></svg>',
    "L_Ena_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M12 3.3704C12 2.41147 10.8585 1.91169 10.1539 2.56212L5.13849 7.19173C4.66663 7.62729 4.66663 8.37273 5.13849 8.80829L10.1539 13.4379C10.8585 14.0883 12 13.5886 12 12.6296V10.9997H13.5C14.3284 10.9997 15 10.3281 15 9.49969V6.49969C15 5.67127 14.3284 4.99969 13.5 4.99969H12V3.3704ZM6.64645 2.64646C6.84172 2.4512 7.1583 2.4512 7.35356 2.64646C7.54882 2.84172 7.54882 3.1583 7.35356 3.35356L2.77782 7.9293C2.73877 7.96835 2.73877 8.03167 2.77782 8.07072L7.35356 12.6465C7.54882 12.8417 7.54882 13.1583 7.35356 13.3536C7.1583 13.5488 6.84172 13.5488 6.64645 13.3536L2.07072 8.77783C1.64114 8.34825 1.64114 7.65177 2.07072 7.22219L6.64645 2.64646Z" fill="var(--svg-fill-31A629)"/></svg>',
    "L_Ena_Dbl_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M11 3.37024C11 3.34199 10.9926 3.32548 10.9848 3.31421C10.9756 3.30084 10.9605 3.28757 10.9401 3.27864C10.9197 3.2697 10.8997 3.26762 10.8837 3.26993C10.8701 3.27188 10.8529 3.2776 10.8322 3.29676L5.81677 7.92637C5.77387 7.96597 5.77387 8.03373 5.81677 8.07333L10.8322 12.7029C10.8529 12.7221 10.8701 12.7278 10.8837 12.7298C10.8997 12.7321 10.9197 12.73 10.9401 12.7211C10.9605 12.7121 10.9756 12.6989 10.9848 12.6855C10.9926 12.6742 11 12.6577 11 12.6295V10.4995C11 10.2234 11.2239 9.99953 11.5 9.99953H13.5C13.7761 9.99953 14 9.77567 14 9.49953V6.49953C14 6.22339 13.7761 5.99953 13.5 5.99953H11.5C11.2239 5.99953 11 5.77567 11 5.49953V3.37024ZM10.1539 2.56196C10.8585 1.91153 12 2.41131 12 3.37024V4.99953H13.5C14.3284 4.99953 15 5.6711 15 6.49953V9.49953C15 10.328 14.3284 10.9995 13.5 10.9995H12V12.6295C12 13.5884 10.8585 14.0882 10.1539 13.4377L5.13849 8.80813C4.66663 8.37257 4.66663 7.62712 5.13849 7.19157L10.1539 2.56196ZM6.64645 2.64646C6.84172 2.4512 7.1583 2.4512 7.35356 2.64646C7.54882 2.84172 7.54882 3.1583 7.35356 3.35356L2.77782 7.9293C2.73877 7.96835 2.73877 8.03167 2.77782 8.07072L7.35356 12.6465C7.54882 12.8417 7.54882 13.1583 7.35356 13.3536C7.1583 13.5488 6.84172 13.5488 6.64645 13.3536L2.07072 8.77783C1.64114 8.34825 1.64114 7.65177 2.07072 7.22219L6.64645 2.64646Z" fill="var(--svg-fill-31A629)"/></svg>',
    "L_Ena_Ss_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.00008 3.37024C8.00008 3.34199 7.99262 3.32548 7.98487 3.31421C7.97567 3.30084 7.96058 3.28757 7.94019 3.27864C7.91979 3.2697 7.8998 3.26762 7.88374 3.26993C7.8702 3.27188 7.85301 3.2776 7.83225 3.29676L2.81684 7.92637C2.77394 7.96597 2.77394 8.03373 2.81684 8.07333L7.83225 12.7029C7.85301 12.7221 7.8702 12.7278 7.88374 12.7298C7.8998 12.7321 7.91979 12.73 7.94019 12.7211C7.96058 12.7121 7.97567 12.6989 7.98487 12.6855C7.99262 12.6742 8.00008 12.6577 8.00008 12.6295V10.4995C8.00008 10.2338 8.20733 10.0165 8.469 10.0005C8.47592 10.5225 8.59975 11.0147 8.85915 11.4433H8.28015L8.28406 12.4472C8.2856 12.8436 8.33159 13.2286 8.43343 13.5917C8.04616 13.8049 7.53589 13.7903 7.15397 13.4377L2.13856 8.80813C1.6667 8.37257 1.66671 7.62712 2.13856 7.19157L7.15397 2.56196C7.8586 1.91153 9.00008 2.41131 9.00008 3.37024V4.99953H13.5001C14.3285 4.99953 15.0001 5.6711 15.0001 6.49953V7.39754C14.8006 7.2485 14.5828 7.12074 14.3493 7.01369C14.2354 6.96147 14.1189 6.91499 14.0001 6.874V6.49953C14.0001 6.22339 13.7762 5.99953 13.5001 5.99953H8.50008C8.22394 5.99953 8.00008 5.77567 8.00008 5.49953V3.37024Z" fill="var(--svg-fill-31A629)"/><path d="M13.3892 10.0001C13.3702 9.76335 13.2815 9.57869 13.1228 9.44611C12.9666 9.31354 12.7287 9.24725 12.4091 9.24725C12.2055 9.24725 12.0386 9.27211 11.9083 9.32182C11.7805 9.36917 11.6858 9.43427 11.6243 9.51713C11.5627 9.59999 11.5307 9.69469 11.5284 9.80123C11.5236 9.88882 11.539 9.96813 11.5745 10.0392C11.6124 10.1078 11.6716 10.1705 11.7521 10.2274C11.8326 10.2818 11.9356 10.3315 12.061 10.3765C12.1865 10.4215 12.3357 10.4617 12.5085 10.4972L13.1051 10.6251C13.5075 10.7103 13.852 10.8228 14.1385 10.9624C14.4249 11.1021 14.6593 11.2667 14.8416 11.4561C15.0239 11.6431 15.1576 11.8538 15.2429 12.0882C15.3305 12.3225 15.3754 12.5782 15.3778 12.8552C15.3754 13.3334 15.2559 13.7383 15.0191 14.0697C14.7824 14.4011 14.4439 14.6533 14.0035 14.8261C13.5655 14.9989 13.0388 15.0853 12.4233 15.0853C11.7912 15.0853 11.2396 14.9918 10.7684 14.8048C10.2997 14.6178 9.9351 14.3301 9.67468 13.9419C9.41663 13.5512 9.28643 13.0517 9.28406 12.4433H11.1591C11.1709 12.6658 11.2265 12.8528 11.326 13.0044C11.4254 13.1559 11.5651 13.2707 11.745 13.3488C11.9273 13.4269 12.1439 13.466 12.3949 13.466C12.6056 13.466 12.7819 13.44 12.924 13.3879C13.066 13.3358 13.1737 13.2636 13.2471 13.1713C13.3205 13.0789 13.3584 12.9736 13.3608 12.8552C13.3584 12.7439 13.3217 12.6469 13.2507 12.564C13.182 12.4788 13.0684 12.403 12.9098 12.3367C12.7512 12.2681 12.5369 12.2042 12.267 12.145L11.5426 11.9887C10.8986 11.849 10.3908 11.6159 10.0191 11.2892C9.64982 10.9601 9.46635 10.5115 9.46872 9.94327C9.46635 9.48162 9.58946 9.07798 9.83803 8.73233C10.089 8.38432 10.4358 8.11325 10.8785 7.91912C11.3236 7.72499 11.8338 7.62793 12.4091 7.62793C12.9962 7.62793 13.504 7.72618 13.9325 7.92267C14.361 8.11917 14.6913 8.39616 14.9233 8.75364C15.1576 9.10875 15.276 9.52424 15.2784 10.0001H13.3892Z" fill="var(--svg-fill-32A5FF)"/></svg>',
    "L_Ena_Ts_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.00008 3.37024C8.00008 3.34199 7.99262 3.32548 7.98487 3.31421C7.97567 3.30084 7.96058 3.28757 7.94019 3.27864C7.91979 3.2697 7.8998 3.26762 7.88374 3.26993C7.8702 3.27188 7.85301 3.2776 7.83225 3.29676L2.81684 7.92637C2.77394 7.96597 2.77394 8.03373 2.81684 8.07333L7.83225 12.7029C7.85301 12.7221 7.8702 12.7278 7.88374 12.7298C7.8998 12.7321 7.91979 12.73 7.94019 12.7211C7.96058 12.7121 7.97567 12.6989 7.98487 12.6855C7.99262 12.6742 8.00008 12.6577 8.00008 12.6295V10.4995C8.00008 10.2234 8.22394 9.99953 8.50008 9.99953H9.17188V10.5625C9.17188 10.7192 9.20792 10.8675 9.27218 10.9995H9.00008V12.6295C9.00008 13.5884 7.8586 14.0882 7.15397 13.4377L2.13856 8.80813C1.6667 8.37257 1.66671 7.62712 2.13856 7.19157L7.15397 2.56196C7.8586 1.91153 9.00008 2.41131 9.00008 3.37024V4.99953H13.5001C14.3285 4.99953 15.0001 5.6711 15.0001 6.49953V8.51564C14.8295 8.20814 14.5016 8 14.125 8H14.0938V7.5625C14.0938 7.41126 14.0602 7.26787 14.0001 7.13936V6.49953C14.0001 6.22339 13.7762 5.99953 13.5001 5.99953H8.50008C8.22394 5.99953 8.00008 5.77567 8.00008 5.49953V3.37024Z" fill="var(--svg-fill-31A629)"/><path d="M14.125 9V10.5625H10.1719V9H14.125ZM10.9375 7.5625H13.0938V13.0703C13.0938 13.1536 13.1081 13.224 13.1367 13.2812C13.1654 13.3359 13.2096 13.3776 13.2695 13.4062C13.3294 13.4323 13.4063 13.4453 13.5 13.4453C13.5651 13.4453 13.6406 13.4375 13.7266 13.4219C13.8151 13.4062 13.8802 13.3932 13.9219 13.3828L14.2344 14.8984C14.138 14.9271 14 14.9622 13.8203 15.0039C13.6432 15.0456 13.4323 15.0729 13.1875 15.0859C12.6927 15.112 12.2773 15.0612 11.9414 14.9336C11.6055 14.8034 11.3529 14.599 11.1836 14.3203C11.0143 14.0417 10.9323 13.6927 10.9375 13.2734V7.5625Z" fill="var(--svg-fill-32A5FF)"/></svg>',
    "L_Err_Arr_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M8.5 10.4995V12.6294C8.5 13.1525 7.87737 13.4251 7.49303 13.0703L2.47762 8.44072C2.22025 8.20314 2.22025 7.79653 2.47762 7.55896L7.49303 2.92935C7.87737 2.57457 8.5 2.84718 8.5 3.37023V5.49952H13.5C14.0523 5.49952 14.5 5.94723 14.5 6.49952V9.49952C14.5 10.0518 14.0523 10.4995 13.5 10.4995H8.5Z" fill="var(--svg-fill-F0483F)"/><path d="M8.5 10.4995H8C8 10.2234 8.22386 9.99952 8.5 9.99952V10.4995ZM7.49303 13.0703L7.83217 12.7029H7.83217L7.49303 13.0703ZM2.47762 8.44072L2.13848 8.80812V8.80812L2.47762 8.44072ZM2.47762 7.55896L2.81676 7.92636L2.47762 7.55896ZM7.49303 2.92935L7.15389 2.56194V2.56194L7.49303 2.92935ZM8.5 5.49952V5.99952C8.22386 5.99952 8 5.77566 8 5.49952H8.5ZM8 12.6294V10.4995H9V12.6294H8ZM7.83217 12.7029C7.85293 12.7221 7.87012 12.7278 7.88366 12.7298C7.89972 12.7321 7.91971 12.73 7.94011 12.7211C7.96051 12.7121 7.97559 12.6988 7.98479 12.6855C7.99255 12.6742 8 12.6577 8 12.6294H9C9 13.5884 7.85852 14.0882 7.15389 13.4377L7.83217 12.7029ZM2.81676 8.07332L7.83217 12.7029L7.15389 13.4377L2.13848 8.80812L2.81676 8.07332ZM2.81676 7.92636C2.77387 7.96595 2.77387 8.03372 2.81676 8.07332L2.13848 8.80812C1.66663 8.37256 1.66663 7.62711 2.13848 7.19155L2.81676 7.92636ZM7.83217 3.29675L2.81676 7.92636L2.13848 7.19155L7.15389 2.56194L7.83217 3.29675ZM8 3.37023C8 3.34198 7.99255 3.32547 7.98479 3.3142C7.97559 3.30083 7.96051 3.28755 7.94011 3.27862C7.91971 3.26969 7.89972 3.26761 7.88366 3.26992C7.87012 3.27187 7.85293 3.27759 7.83217 3.29675L7.15389 2.56194C7.85852 1.91152 9 2.4113 9 3.37023H8ZM8 5.49952V3.37023H9V5.49952H8ZM13.5 5.99952H8.5V4.99952H13.5V5.99952ZM14 6.49952C14 6.22338 13.7761 5.99952 13.5 5.99952V4.99952C14.3284 4.99952 15 5.67109 15 6.49952H14ZM14 9.49952V6.49952H15V9.49952H14ZM13.5 9.99952C13.7761 9.99952 14 9.77566 14 9.49952H15C15 10.3279 14.3284 10.9995 13.5 10.9995V9.99952ZM8.5 9.99952H13.5V10.9995H8.5V9.99952Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "L_Err_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.5 10.4997H8C8 10.2235 8.22386 9.99968 8.5 9.99968V10.4997ZM7.49303 13.0705L7.83217 12.7031L7.83217 12.7031L7.49303 13.0705ZM2.47762 8.44088L2.13848 8.80828L2.47762 8.44088ZM2.47762 7.55912L2.81676 7.92652L2.47762 7.55912ZM7.49303 2.92951L7.15389 2.56211V2.56211L7.49303 2.92951ZM8.5 5.49968V5.99968C8.22386 5.99968 8 5.77582 8 5.49968H8.5ZM8 12.6296V10.4997H9V12.6296H8ZM7.83217 12.7031C7.85293 12.7222 7.87012 12.728 7.88366 12.7299C7.89972 12.7322 7.91971 12.7301 7.94011 12.7212C7.96051 12.7123 7.97559 12.699 7.98479 12.6856C7.99255 12.6744 8 12.6579 8 12.6296H9C9 13.5885 7.85852 14.0883 7.15389 13.4379L7.83217 12.7031ZM2.81676 8.07348L7.83217 12.7031L7.15389 13.4379L2.13848 8.80828L2.81676 8.07348ZM2.81676 7.92652C2.77387 7.96612 2.77387 8.03388 2.81676 8.07348L2.13848 8.80828C1.66663 8.37272 1.66663 7.62727 2.13848 7.19172L2.81676 7.92652ZM7.83217 3.29691L2.81676 7.92652L2.13848 7.19172L7.15389 2.56211L7.83217 3.29691ZM8 3.37039C8 3.34214 7.99255 3.32563 7.98479 3.31436C7.97559 3.30099 7.96051 3.28772 7.94011 3.27879C7.91971 3.26985 7.89972 3.26777 7.88366 3.27008C7.87012 3.27203 7.85293 3.27775 7.83217 3.29691L7.15389 2.56211C7.85852 1.91168 9 2.41146 9 3.37039H8ZM8 5.49968V3.37039H9V5.49968H8ZM13.5 5.99968H8.5V4.99968H13.5V5.99968ZM14 6.49968C14 6.22354 13.7761 5.99968 13.5 5.99968V4.99968C14.3284 4.99968 15 5.67125 15 6.49968H14ZM14 9.49968V6.49968H15V9.49968H14ZM13.5 9.99968C13.7761 9.99968 14 9.77582 14 9.49968H15C15 10.3281 14.3284 10.9997 13.5 10.9997V9.99968ZM8.5 9.99968H13.5V10.9997H8.5V9.99968Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "L_Err_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M12 3.37024C12 2.41131 10.8585 1.91153 10.1539 2.56196L5.13849 7.19157C4.66663 7.62712 4.66663 8.37257 5.13849 8.80813L10.1539 13.4377C10.8585 14.0882 12 13.5884 12 12.6295V10.9995H13.5C14.3284 10.9995 15 10.328 15 9.49953V6.49953C15 5.6711 14.3284 4.99953 13.5 4.99953H12V3.37024ZM6.64645 2.64646C6.84172 2.4512 7.1583 2.4512 7.35356 2.64646C7.54882 2.84172 7.54882 3.1583 7.35356 3.35356L2.77782 7.9293C2.73877 7.96835 2.73877 8.03167 2.77782 8.07072L7.35356 12.6465C7.54882 12.8417 7.54882 13.1583 7.35356 13.3536C7.1583 13.5488 6.84172 13.5488 6.64645 13.3536L2.07072 8.77783C1.64114 8.34825 1.64114 7.65177 2.07072 7.22219L6.64645 2.64646Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "L_Err_Dbl_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M11 3.37024C11 3.34199 10.9926 3.32548 10.9848 3.31421C10.9756 3.30084 10.9605 3.28757 10.9401 3.27864C10.9197 3.2697 10.8997 3.26762 10.8837 3.26993C10.8701 3.27188 10.8529 3.2776 10.8322 3.29676L5.81677 7.92637C5.77387 7.96597 5.77387 8.03373 5.81677 8.07333L10.8322 12.7029C10.8529 12.7221 10.8701 12.7278 10.8837 12.7298C10.8997 12.7321 10.9197 12.73 10.9401 12.7211C10.9605 12.7121 10.9756 12.6989 10.9848 12.6855C10.9926 12.6742 11 12.6577 11 12.6295V10.4995C11 10.2234 11.2239 9.99953 11.5 9.99953H13.5C13.7761 9.99953 14 9.77567 14 9.49953V6.49953C14 6.22339 13.7761 5.99953 13.5 5.99953H11.5C11.2239 5.99953 11 5.77567 11 5.49953V3.37024ZM10.1539 2.56196C10.8585 1.91153 12 2.41131 12 3.37024V4.99953H13.5C14.3284 4.99953 15 5.6711 15 6.49953V9.49953C15 10.328 14.3284 10.9995 13.5 10.9995H12V12.6295C12 13.5884 10.8585 14.0882 10.1539 13.4377L5.13849 8.80813C4.66663 8.37257 4.66663 7.62712 5.13849 7.19157L10.1539 2.56196ZM6.64645 2.64646C6.84172 2.4512 7.1583 2.4512 7.35356 2.64646C7.54882 2.84172 7.54882 3.1583 7.35356 3.35356L2.77782 7.9293C2.73877 7.96835 2.73877 8.03167 2.77782 8.07072L7.35356 12.6465L6.64645 13.3536L2.07072 8.77783C1.64114 8.34825 1.64114 7.65177 2.07072 7.22219L6.64645 2.64646Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "mail-1": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M1 5 8 8.5 15 5 M1 10 6.5 7.5 M10 7.5 15 10" stroke="var(--svg-stroke-6890D9)"  stroke-width="0.75"/><rect x="1" y="4" width="14" height="7" rx="1" ry="1" stroke="var(--svg-stroke-7F848D)" stroke-width="0.75" /></svg>',
    "manage-account-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M7.98284 8.99996C8.03815 8.90942 8.10487 8.82406 8.18291 8.74603L8.74603 8.18291C9.16609 7.76285 9.7981 7.67064 10.3112 7.9228C10.4809 7.42508 10.9278 7.06222 11.4607 7.00725C11.8036 6.41727 12 5.73157 12 5C12 2.79086 10.2091 1 8 1C5.79086 1 4 2.79086 4 5C4 7.20342 5.7816 8.99072 7.98284 8.99996ZM7.81447 10H6C3.23858 10 1 12.2386 1 15H7.98282C7.74047 14.6032 7.71749 14.1066 7.9228 13.6888C7.38171 13.5043 7 12.9922 7 12.3982V11.6018C7 11.0078 7.38171 10.4957 7.9228 10.3112C7.87364 10.2112 7.83757 10.1066 7.81447 10ZM11.9091 12C11.9091 11.9498 11.9498 11.9091 12 11.9091C12.0502 11.9091 12.0909 11.9498 12.0909 12C12.0909 12.0502 12.0502 12.0909 12 12.0909C11.9498 12.0909 11.9091 12.0502 11.9091 12Z" fill="var(--svg-fill-689DDE)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M11.4607 7.00725C11.8036 6.41727 12 5.73157 12 5C12 2.79086 10.2091 1 8 1C5.79086 1 4 2.79086 4 5C4 7.20342 5.7816 8.99072 7.98284 8.99996C8.03815 8.90942 8.10487 8.82406 8.18291 8.74603L8.74603 8.18291C9.16609 7.76285 9.7981 7.67064 10.3112 7.9228C10.4809 7.42508 10.9278 7.06222 11.4607 7.00725ZM7.81447 10H6C3.58104 10 1.56329 11.7178 1.10002 14C1.03443 14.3231 1 14.6575 1 15H7.98282C7.7985 14.6982 7.74107 14.3386 7.81447 14H2.12602C2.57006 12.2748 4.13616 11 6 11H7.13978C7.29756 10.6796 7.57778 10.4288 7.9228 10.3112C7.87364 10.2112 7.83757 10.1066 7.81447 10ZM8 8C9.65685 8 11 6.65685 11 5C11 3.34315 9.65685 2 8 2C6.34315 2 5 3.34315 5 5C5 6.65685 6.34315 8 8 8Z" fill="var(--svg-fill-225BA1)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M11.6018 8C11.415 8 11.2586 8.14156 11.24 8.32745L11.1511 9.21673C10.97 9.27187 10.7965 9.34418 10.6324 9.43177L9.94053 8.8657C9.79594 8.7474 9.58523 8.75791 9.45313 8.89001L8.89001 9.45313C8.75791 9.58523 8.7474 9.79594 8.8657 9.94053L9.43177 10.6324C9.34418 10.7965 9.27187 10.97 9.21673 11.1511L8.32745 11.24C8.14156 11.2586 8 11.415 8 11.6018V12.3982C8 12.585 8.14156 12.7414 8.32745 12.76L9.21673 12.8489C9.27187 13.03 9.34418 13.2035 9.43177 13.3676L8.8657 14.0595C8.7474 14.2041 8.75791 14.4148 8.89001 14.5469L9.45313 15.11C9.58523 15.2421 9.79594 15.2526 9.94053 15.1343L10.6324 14.5682C10.7965 14.6558 10.97 14.7281 11.1511 14.7833L11.24 15.6725C11.2586 15.8584 11.415 16 11.6018 16H12.3982C12.585 16 12.7414 15.8584 12.76 15.6725L12.8489 14.7833C13.03 14.7281 13.2035 14.6558 13.3676 14.5682L14.0595 15.1343C14.2041 15.2526 14.4148 15.2421 14.5469 15.11L15.11 14.5469C15.2421 14.4148 15.2526 14.2041 15.1343 14.0595L14.5682 13.3676C14.6558 13.2035 14.7281 13.03 14.7833 12.8489L15.6725 12.76C15.8584 12.7414 16 12.585 16 12.3982V11.6018C16 11.415 15.8584 11.2586 15.6725 11.24L14.7833 11.1511C14.7281 10.97 14.6558 10.7965 14.5682 10.6324L15.1343 9.94053C15.2526 9.79594 15.2421 9.58523 15.11 9.45313L14.5469 8.89001C14.4148 8.75791 14.2041 8.7474 14.0595 8.8657L13.3676 9.43177C13.2035 9.34418 13.03 9.27187 12.8489 9.21673L12.76 8.32745C12.7414 8.14156 12.585 8 12.3982 8H11.6018ZM12 13.0909C12.6025 13.0909 13.0909 12.6025 13.0909 12C13.0909 11.3975 12.6025 10.9091 12 10.9091C11.3975 10.9091 10.9091 11.3975 10.9091 12C10.9091 12.6025 11.3975 13.0909 12 13.0909Z" fill="var(--svg-fill-6F6F6F)"/></svg>',
    "menu": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="var(--svg-stroke-7F848D)"><path d="M3 4 H13 M3 8H13M3 12H13" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>*</svg>',
    "microsoft": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M0 0 H7.58391V7.58368H0V0Z" fill="var(--svg-fill-F6412D)"/><path d="M8.41609 0 H16V7.58368H8.41609V0Z" fill="var(--svg-fill-31A629)"/><path d="M7.58391 8.41632 H0 V16H7.58391V8.41632Z" fill="var(--svg-fill-32A5FF)"/><path d="M8.41602 8.41632H15.9999 V16 H8.41602V8.41632Z" fill="var(--svg-fill-FFB800)"/></svg>',
    "minus-add-line": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6432_1181)"><path fill-rule="evenodd" clip-rule="evenodd" d="M15 8C15 11.866 11.866 15 8 15C4.13401 15 1 11.866 1 8C1 4.13401 4.13401 1 8 1C11.866 1 15 4.13401 15 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM12 8.5C12.2761 8.5 12.5 8.27614 12.5 8C12.5 7.72386 12.2761 7.5 12 7.5L4 7.5C3.72386 7.5 3.5 7.72386 3.5 8C3.5 8.27614 3.72386 8.5 4 8.5H12Z" fill="var(--svg-fill-F0483F)"/></g><defs><clipPath id="clip0_6432_1181"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "mounted": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6228_132)"><path d="M5.50073 5C5.50073 5.55228 5.05302 6 4.50073 6C3.94845 6 3.50073 5.55228 3.50073 5C3.50073 4.44772 3.94845 4 4.50073 4C5.05302 4 5.50073 4.44772 5.50073 5Z" fill="var(--svg-fill-31A629)"/><path d="M13.0007 2H3.00073C2.44845 2 2.00073 2.44772 2.00073 3V7C2.00073 7.55228 2.44845 8 3.00073 8H9.00073L8.50073 9H3.00073C1.89616 9 1.00073 8.10457 1.00073 7V3C1.00073 1.89543 1.89616 1 3.00073 1H13.0007C14.1053 1 15.0007 1.89543 15.0007 3V7C15.0007 7.28219 14.9423 7.55073 14.8369 7.79417L14.0007 7V3C14.0007 2.44772 13.553 2 13.0007 2Z" fill="var(--svg-fill-686A6D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.50073 9V14.5H16.5007V15.5H-0.499268V14.5H5.50073V9H6.50073Z" fill="var(--svg-fill-686A6D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.50073 12.5V14.5H8.50073V15.5H3.50073V14.5H5.50073V12.5H6.50073Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M12.0007 14C14.2099 14 16.0007 12.2091 16.0007 10C16.0007 7.79086 14.2099 6 12.0007 6C9.79159 6 8.00073 7.79086 8.00073 10C8.00073 12.2091 9.79159 14 12.0007 14ZM14.0607 9.20173C14.266 9.017 14.2826 8.70086 14.0979 8.4956C13.9132 8.29034 13.597 8.27371 13.3918 8.45844L11.3868 10.3368L10.5952 9.66456C10.39 9.47983 10.0738 9.49647 9.8891 9.70173C9.70437 9.90698 9.72101 10.2231 9.92627 10.4079L11.3868 11.6821L14.0607 9.20173Z" fill="var(--svg-fill-31A629)"/><line x1="7" y1="5" x2="12" y2="5" stroke="var(--svg-stroke-686A6D)"/></g><defs><clipPath id="clip0_6228_132"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "mounting": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6228_155)"><path d="M5.50073 5C5.50073 5.55228 5.05302 6 4.50073 6C3.94845 6 3.50073 5.55228 3.50073 5C3.50073 4.44772 3.94845 4 4.50073 4C5.05302 4 5.50073 4.44772 5.50073 5Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M3.00073 2H13.0007C13.553 2 14.0007 2.44772 14.0007 3V5.41635C14.3577 5.5724 14.693 5.76894 15.0007 6.00016V3C15.0007 1.89543 14.1053 1 13.0007 1H3.00073C1.89616 1 1.00073 1.89543 1.00073 3V7C1.00073 8.10457 1.89616 9 3.00073 9H7.10002C7.17062 8.6522 7.27732 8.3175 7.41604 8H3.00073C2.44845 8 2.00073 7.55228 2.00073 7V3C2.00073 2.44772 2.44845 2 3.00073 2Z" fill="var(--svg-fill-686A6D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.50073 9V14.5H16.5007V15.5H-0.499268V14.5H5.50073V9H6.50073Z" fill="var(--svg-fill-686A6D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M6.50073 12.5V14.5H8.50073V15.5H3.50073V14.5H5.50073V12.5H6.50073Z" fill="var(--svg-fill-31A629)"/><line x1="7" y1="5" x2="12" y2="5" stroke="var(--svg-stroke-686A6D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M12 14C13.8638 14 15.4299 12.7252 15.874 11H14.292C13.9062 11.883 13.0252 12.5 12 12.5C10.6193 12.5 9.5 11.3807 9.5 10C9.5 8.61929 10.6193 7.5 12 7.5C12.6904 7.5 13.3154 7.77982 13.7678 8.23223L12.5 9.5H16V6L14.8284 7.17157C14.1046 6.44772 13.1046 6 12 6C9.79086 6 8 7.79086 8 10C8 12.2091 9.79086 14 12 14Z" fill="var(--svg-fill-C8A225)"/></g><defs><clipPath id="clip0_6228_155"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "move-left": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M4.00004 5.3335L1.33337 8.00016L4.00004 10.6668" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M1.33337 8H14.6667" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "move-right": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M12 5.3335L14.6667 8.00016L12 10.6668" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/><path d="M1.33337 8H14.6667" stroke="var(--svg-stroke-7F848D)" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "move-up": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M12 12 H4 V4 M1 7 4 4 7 7" stroke="var(--svg-stroke-7F848D)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "mycloud-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="5.5" y="0.5" width="6" height="15" rx="1.5" fill="url(#paint0_linear_6202_13744)" stroke="url(#paint1_linear_6202_13744)"/><rect x="5" y="8" width="7" height="5" fill="var(--svg-fill-797C80)"/><rect x="9" y="10" width="2" height="1" fill="var(--svg-fill-33D5FF)"/><defs><linearGradient id="paint0_linear_6202_13744" x1="5" y1="8.66667" x2="12" y2="8.66667" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-D0D1D5)"/><stop offset="0.369792" stop-color="var(--svg-stop-color-EDEEF2)"/><stop offset="0.692708" stop-color="var(--svg-stop-color-EDEEF2)"/><stop offset="1" stop-color="var(--svg-stop-color-D7D8DC)"/></linearGradient><linearGradient id="paint1_linear_6202_13744" x1="8.5" y1="0" x2="8.5" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-9EA0A2)"/><stop offset="1" stop-color="var(--svg-stop-color-6E7175)"/></linearGradient></defs></svg>',
    "mycloud-mirror-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="3.33337" width="9.33333" height="16" rx="2" fill="var(--svg-fill-3F3F40)"/><rect x="3.33337" width="9.33333" height="16" rx="2" fill="url(#paint0_linear_6202_13742)"/><rect x="4.66663" y="10.6667" width="8" height="2.66667" fill="var(--svg-fill-1B1F25)"/><rect x="5.33337" y="11.3333" width="1.33333" height="0.666667" fill="var(--svg-fill-999A9C)"/><rect x="10" y="11.3333" width="1.33333" height="0.666667" fill="var(--svg-fill-2B99CA)"/><rect x="10" y="12.6667" width="1.33333" height="0.666666" fill="var(--svg-fill-2B99CA)"/><rect x="3.5" y="0.5" width="9" height="15" rx="1.5" fill="url(#paint1_linear_6202_13742)" stroke="url(#paint2_linear_6202_13742)"/><rect x="4" y="8" width="9" height="5" fill="var(--svg-fill-797C80)"/><rect x="5" y="9" width="2" height="1" fill="var(--svg-fill-EDEEF2)"/><rect x="10" y="9" width="2" height="1" fill="var(--svg-fill-33D5FF)"/><rect x="10" y="11" width="2" height="1" fill="var(--svg-fill-33D5FF)"/><defs><linearGradient id="paint0_linear_6202_13742" x1="3.33337" y1="6.66667" x2="12.6667" y2="6.66667" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-090B0E)"/><stop offset="0.578125" stop-color="var(--svg-stop-color-353B45)"/><stop offset="0.776042" stop-color="var(--svg-stop-color-22252C)"/><stop offset="0.869792" stop-color="var(--svg-stop-color-4A4E59)"/><stop offset="1" stop-color="var(--svg-stop-color-181C22)"/></linearGradient><linearGradient id="paint1_linear_6202_13742" x1="3" y1="8.66667" x2="13" y2="8.66667" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-D0D1D5)"/><stop offset="0.369792" stop-color="var(--svg-stop-color-EDEEF2)"/><stop offset="0.692708" stop-color="var(--svg-stop-color-EDEEF2)"/><stop offset="1" stop-color="var(--svg-stop-color-D7D8DC)"/></linearGradient><linearGradient id="paint2_linear_6202_13742" x1="8" y1="0" x2="8" y2="16" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-9EA0A2)"/><stop offset="1" stop-color="var(--svg-stop-color-6E7175)"/></linearGradient></defs></svg>',
    "new-account-16": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="16" cy="8" r="7" fill="var(--svg-fill-6890D9)" stroke="var(--svg-stroke-2D4F97)" stroke-width="2"/><path d="M1 31 V30 C1 24 6 19 12 19 H15.8 A10 10 0 0 0 16 30 V31 Z" fill="var(--svg-fill-6890D9)"/><path d="M16 31 H1 V30 C1 24 6 19 12 19 H15" stroke="var(--svg-stroke-2D4F97)" stroke-width="2" stroke-linecap="round"/><path d="M24 18 V30" stroke="var(--svg-stroke-2D4F97)" stroke-width="3" stroke-linecap="round"/><path d="M18 24 H30" stroke="var(--svg-stroke-2D4F97)" stroke-width="3" stroke-linecap="round"/></svg>',
    "new-folder": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6202_5192)"><path fill-rule="evenodd" clip-rule="evenodd" d="M2.66671 1.375C2.14733 1.375 1.64922 1.58132 1.28196 1.94858C0.914698 2.31584 0.708374 2.81395 0.708374 3.33333V12C0.708374 12.5194 0.914698 13.0175 1.28196 13.3848C1.64922 13.752 2.14732 13.9583 2.66671 13.9583H5.99997V12.7083H2.66671C2.47885 12.7083 2.29868 12.6337 2.16584 12.5009C2.033 12.368 1.95837 12.1879 1.95837 12V3.33333C1.95837 3.14547 2.033 2.9653 2.16584 2.83247C2.29868 2.69963 2.47885 2.625 2.66671 2.625H5.2866H5.28671C5.40394 2.62504 5.51933 2.65417 5.62253 2.70979C5.72576 2.76542 5.81357 2.84581 5.87806 2.94375L5.87803 2.94377L5.88201 2.94967L6.4202 3.74698C6.60013 4.01906 6.84519 4.24189 7.13313 4.39524C7.42124 4.54867 7.74311 4.62764 8.06948 4.625H13.3334C13.5212 4.625 13.7014 4.69963 13.8342 4.83247C13.9671 4.9653 14.0417 5.14547 14.0417 5.33333V9.84619H15.0355C15.1226 9.84619 15.2081 9.85254 15.2917 9.86481V5.33333C15.2917 4.81395 15.0854 4.31584 14.7181 3.94858C14.3509 3.58132 13.8528 3.375 13.3334 3.375H8.06671V3.37497L8.06058 3.37503C7.94212 3.37619 7.82525 3.34762 7.72069 3.29194C7.61612 3.23625 7.52719 3.15523 7.46204 3.05628L7.46207 3.05626L7.45807 3.05033L6.91986 2.25299C6.74175 1.98369 6.4998 1.7626 6.21555 1.60941C5.93015 1.4556 5.61102 1.37505 5.28681 1.375H5.28671H2.66671Z" fill="var(--svg-fill-6A6F77)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M10.7856 15.0711C10.7856 15.4853 11.1214 15.8211 11.5356 15.8211C11.9498 15.8211 12.2856 15.4853 12.2856 15.0711L12.2856 12.2857L15.0711 12.2857C15.4853 12.2857 15.8211 11.9499 15.8211 11.5357C15.8211 11.1215 15.4853 10.7857 15.0711 10.7857H12.2856L12.2856 8.00005C12.2856 7.58584 11.9498 7.25005 11.5356 7.25005C11.1214 7.25005 10.7856 7.58584 10.7856 8.00005L10.7856 10.7857L8.00004 10.7857C7.58583 10.7857 7.25004 11.1215 7.25004 11.5357C7.25004 11.9499 7.58583 12.2857 8.00004 12.2857L10.7856 12.2857L10.7856 15.0711Z" fill="var(--svg-fill-6A6F77)"/></g><defs><clipPath id="clip0_6202_5192"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "newer_file_wins": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M12 24C18.6274 24 24 18.6274 24 12C24 5.37258 18.6274 0 12 0C5.37258 0 0 5.37258 0 12C0 18.6274 5.37258 24 12 24ZM12 21C16.9706 21 21 16.9706 21 12C21 7.02944 16.9706 3 12 3C7.02944 3 3 7.02944 3 12C3 16.9706 7.02944 21 12 21Z" fill="var(--svg-fill-4FB633)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M10 6H13V11.719L17.3602 14.7712L15.6398 17.2288L10 13.281V6Z" fill="var(--svg-fill-4FB633)"/></svg>',
    "new_group": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><circle cx="20" cy="16" r="12" fill="var(--svg-fill-white)"/><circle cx="12" cy="16" r="12" fill="var(--svg-fill-white)"/><circle cx="20" cy="16" r="10.5" fill="var(--svg-fill-5884D0)" stroke="var(--svg-stroke-B8B8B8)"/><circle cx="12" cy="16" r="10.5" fill="var(--svg-fill-white)" stroke="var(--svg-stroke-B8B8B8)"/><mask id="path-5-outside-1_4413_20036" maskUnits="userSpaceOnUse" x="18.5" y="17.5" width="13" height="13" fill="var(--svg-fill-black)"><rect fill="var(--svg-fill-white)" x="18.5" y="17.5" width="13" height="13"/><path fill-rule="evenodd" clip-rule="evenodd" d="M26.5 18.5H23.5V22.5H19.5L19.5 25.5H23.5V29.5H26.5V25.5H30.5V22.5H26.5V18.5Z"/></mask><path fill-rule="evenodd" clip-rule="evenodd" d="M26.5 18.5H23.5V22.5H19.5L19.5 25.5H23.5V29.5H26.5V25.5H30.5V22.5H26.5V18.5Z" fill="var(--svg-fill-747474)"/><path d="M23.5 18.5V17.5H22.5V18.5H23.5ZM26.5 18.5H27.5V17.5H26.5V18.5ZM23.5 22.5V23.5H24.5V22.5H23.5ZM19.5 22.5V21.5H18.5V22.5H19.5ZM19.5 25.5H18.5L18.5 26.5H19.5V25.5ZM23.5 25.5H24.5V24.5H23.5V25.5ZM23.5 29.5H22.5V30.5H23.5V29.5ZM26.5 29.5V30.5H27.5V29.5H26.5ZM26.5 25.5V24.5H25.5V25.5H26.5ZM30.5 25.5V26.5H31.5V25.5H30.5ZM30.5 22.5H31.5V21.5H30.5V22.5ZM26.5 22.5H25.5V23.5H26.5V22.5ZM23.5 19.5H26.5V17.5H23.5V19.5ZM24.5 22.5V18.5H22.5V22.5H24.5ZM19.5 23.5H23.5V21.5H19.5V23.5ZM20.5 25.5L20.5 22.5H18.5L18.5 25.5H20.5ZM23.5 24.5H19.5V26.5H23.5V24.5ZM24.5 29.5V25.5H22.5V29.5H24.5ZM26.5 28.5H23.5V30.5H26.5V28.5ZM25.5 25.5V29.5H27.5V25.5H25.5ZM30.5 24.5H26.5V26.5H30.5V24.5ZM29.5 22.5V25.5H31.5V22.5H29.5ZM26.5 23.5H30.5V21.5H26.5V23.5ZM25.5 18.5V22.5H27.5V18.5H25.5Z" fill="var(--svg-fill-white)" mask="url(#path-5-outside-1_4413_20036)"/></svg>',
    "new_job": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><g clip-path="url(#clip0_4413_20027)"><circle cx="16" cy="16" r="15.5" fill="var(--svg-fill-5884D0)" stroke="var(--svg-stroke-white)"/><rect x="14" y="7" width="4" height="18" fill="var(--svg-fill-white)"/><rect x="7" y="18" width="4" height="18" transform="rotate(-90 7 18)" fill="var(--svg-fill-white)"/></g><defs><clipPath id="clip0_4413_20027"><rect width="32" height="32" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "one_tree": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><rect x="1" y="1" width="22" height="22" rx="2" ry="2" stroke="var(--svg-stroke-7F848D)" stroke-width="1" /><path d="M4.5 4.5  h11 M4.5 9.5  h11 M8.5 14.5 h11 M4.5 19.5 h11 " stroke="var(--svg-stroke-6890D9)" stroke-width="2.5" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "paste": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M6.75 15.5 H2.5 C1 15.5, 0.5 15, 0.5 14 V3 C0.5 2.5, 1 1.5, 2 1.5 H3.5 M9.5 1.5 H11 C 12 1.5, 12.5 2, 12.5 3 V4.5" stroke="var(--svg-stroke-7F848D)" stroke-width="1" /><rect x="3.5" y="0.5" width="6" height="2" rx="0.75" ry="0.75" stroke="var(--svg-stroke-7F848D)" stroke-width="1" /><rect x="7.5" y="5.5" width="8" height="10" rx="1.5" ry="1.5" stroke="var(--svg-stroke-6890D9)" stroke-width="1" /></svg>',
    "pause": '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M5.625 4.16683C5.625 4.05177 5.71827 3.9585 5.83333 3.9585H7.5C7.61506 3.9585 7.70833 4.05177 7.70833 4.16683V15.8335C7.70833 15.9486 7.61506 16.0418 7.5 16.0418H5.83333C5.71827 16.0418 5.625 15.9486 5.625 15.8335V4.16683ZM5.83333 2.7085C5.02792 2.7085 4.375 3.36141 4.375 4.16683V15.8335C4.375 16.6389 5.02792 17.2918 5.83333 17.2918H7.5C8.30542 17.2918 8.95833 16.6389 8.95833 15.8335V4.16683C8.95833 3.36141 8.30542 2.7085 7.5 2.7085H5.83333ZM12.2917 4.16683C12.2917 4.05177 12.385 3.9585 12.5001 3.9585H14.1667C14.2818 3.9585 14.3751 4.05177 14.3751 4.16683V15.8335C14.3751 15.9486 14.2818 16.0418 14.1667 16.0418H12.5001C12.385 16.0418 12.2917 15.9486 12.2917 15.8335V4.16683ZM12.5001 2.7085C11.6947 2.7085 11.0417 3.36141 11.0417 4.16683V15.8335C11.0417 16.6389 11.6947 17.2918 12.5001 17.2918H14.1667C14.9722 17.2918 15.6251 16.6389 15.6251 15.8335V4.16683C15.6251 3.36141 14.9722 2.7085 14.1667 2.7085H12.5001Z" fill="var(--svg-fill-6890D9)"/></svg>',
    "plus-add-line": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6432_1165)"><path fill-rule="evenodd" clip-rule="evenodd" d="M15 8C15 11.866 11.866 15 8 15C4.13401 15 1 11.866 1 8C1 4.13401 4.13401 1 8 1C11.866 1 15 4.13401 15 8ZM16 8C16 12.4183 12.4183 16 8 16C3.58172 16 0 12.4183 0 8C0 3.58172 3.58172 0 8 0C12.4183 0 16 3.58172 16 8ZM8 3.5C8.27614 3.5 8.5 3.72386 8.5 4V7.5H12C12.2761 7.5 12.5 7.72386 12.5 8C12.5 8.27614 12.2761 8.5 12 8.5H8.5V12C8.5 12.2761 8.27614 12.5 8 12.5C7.72386 12.5 7.5 12.2761 7.5 12V8.5H4C3.72386 8.5 3.5 8.27614 3.5 8C3.5 7.72386 3.72386 7.5 4 7.5H7.5V4C7.5 3.72386 7.72386 3.5 8 3.5Z" fill="var(--svg-fill-31A629)"/></g><defs><clipPath id="clip0_6432_1165"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "pr2100-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-3F3F40)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="url(#paint0_linear_6202_13748)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-white)" fill-opacity="0.3"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-6E747E)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" stroke="var(--svg-stroke-black)"/><rect x="2" y="2" width="11" height="12" fill="var(--svg-fill-4B525C)"/><rect x="9" y="2" width="3" height="11" fill="var(--svg-fill-999FA9)"/><rect x="5" y="2" width="3" height="11" fill="var(--svg-fill-999FA9)"/><rect x="6" y="7" width="1" height="6" fill="var(--svg-fill-6E747E)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 6 7)" fill="var(--svg-fill-393939)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 6 7)" fill="url(#paint1_linear_6202_13748)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 10 7)" fill="var(--svg-fill-393939)"/><rect width="1" height="2" transform="matrix(1 0 0 -1 10 7)" fill="url(#paint2_linear_6202_13748)"/><rect x="10" y="7" width="1" height="6" fill="var(--svg-fill-6E747E)"/><circle cx="3.5" cy="5.5" r="0.5" fill="var(--svg-fill-00B0FF)"/><circle cx="3.5" cy="12.5" r="0.5" fill="var(--svg-fill-00B0FF)"/><rect x="7" y="14" width="1" height="1" fill="var(--svg-fill-00B0FF)"/><rect x="10" y="14" width="1" height="1" fill="var(--svg-fill-00B0FF)"/><rect opacity="0.54" x="3" y="2" width="1" height="1" fill="var(--svg-fill-white)"/><defs><linearGradient id="paint0_linear_6202_13748" x1="2" y1="5.25" x2="14" y2="5.25" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-131313)"/><stop offset="0.182292" stop-color="var(--svg-stop-color-333335)"/><stop offset="0.875" stop-color="var(--svg-stop-color-3D3D3F)"/><stop offset="0.9375" stop-color="var(--svg-stop-color-737375)"/><stop offset="1" stop-color="var(--svg-stop-color-323234)"/></linearGradient><linearGradient id="paint1_linear_6202_13748" x1="0.5" y1="0" x2="0.5" y2="2" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-858B97)"/><stop offset="1" stop-color="var(--svg-stop-color-B2B5BB)"/></linearGradient><linearGradient id="paint2_linear_6202_13748" x1="0.5" y1="0" x2="0.5" y2="2" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-858B97)"/><stop offset="1" stop-color="var(--svg-stop-color-B2B5BB)"/></linearGradient></defs></svg>',
    "pr4100-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-3F3F40)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="url(#paint0_linear_6202_13746)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-white)" fill-opacity="0.3"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" fill="var(--svg-fill-6E747E)"/><rect x="2.5" y="0.5" width="11" height="15" rx="1.5" stroke="var(--svg-stroke-black)"/><rect x="5" y="4" width="8" height="10" fill="var(--svg-fill-171717)"/><rect x="5" y="4" width="8" height="10" fill="var(--svg-fill-4B525C)"/><rect x="7" y="5" width="2" height="9" fill="var(--svg-fill-999FA9)"/><rect x="5" y="5" width="2" height="9" fill="var(--svg-fill-999FA9)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 6 9)" fill="var(--svg-fill-393939)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 6 9)" fill="var(--svg-fill-AFB2B9)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 8 9)" fill="var(--svg-fill-393939)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 8 9)" fill="var(--svg-fill-AFB2B9)"/><rect x="9" y="5" width="2" height="9" fill="var(--svg-fill-999FA9)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 10 9)" fill="var(--svg-fill-393939)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 10 9)" fill="var(--svg-fill-AFB2B9)"/><rect x="11" y="5" width="2" height="9" fill="var(--svg-fill-999FA9)"/><circle cx="4" cy="6" r="1" fill="var(--svg-fill-2B99CA)"/><circle cx="3.5" cy="12.5" r="0.5" fill="var(--svg-fill-2B99CA)"/><rect x="10" y="14" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="8" y="14" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="6" y="14" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="12" y="14" width="1" height="1" fill="var(--svg-fill-2B99CA)"/><rect x="5" y="2" width="6" height="2" fill="var(--svg-fill-0066FF)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 12 9)" fill="var(--svg-fill-393939)"/><rect width="1" height="3" transform="matrix(1 0 0 -1 12 9)" fill="var(--svg-fill-AFB2B9)"/><rect x="6" y="9" width="1" height="5" fill="var(--svg-fill-393939)"/><rect x="6" y="9" width="1" height="5" fill="var(--svg-fill-6E747E)"/><rect x="8" y="9" width="1" height="5" fill="var(--svg-fill-393939)"/><rect x="8" y="9" width="1" height="5" fill="var(--svg-fill-6E747E)"/><rect x="10" y="9" width="1" height="5" fill="var(--svg-fill-393939)"/><rect x="10" y="9" width="1" height="5" fill="var(--svg-fill-6E747E)"/><rect x="12" y="9" width="1" height="5" fill="var(--svg-fill-393939)"/><rect x="12" y="9" width="1" height="5" fill="var(--svg-fill-6E747E)"/><defs><linearGradient id="paint0_linear_6202_13746" x1="2" y1="5.25" x2="14" y2="5.25" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-131313)"/><stop offset="0.182292" stop-color="var(--svg-stop-color-333335)"/><stop offset="0.875" stop-color="var(--svg-stop-color-3D3D3F)"/><stop offset="0.9375" stop-color="var(--svg-stop-color-737375)"/><stop offset="1" stop-color="var(--svg-stop-color-323234)"/></linearGradient></defs></svg>',
    "properties": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6202_5229)"><circle cx="8" cy="8" r="7.5" stroke="var(--svg-stroke-7F848D)"/><path d="M9.66732 4.00196C9.66732 4.17223 9.63458 4.32504 9.56909 4.46038C9.5036 4.59572 9.4141 4.7136 9.30059 4.81401C9.19144 4.91006 9.06047 4.98428 8.90766 5.03667C8.75922 5.08906 8.59769 5.11526 8.42305 5.11526C8.25715 5.11526 8.10216 5.09125 7.95809 5.04322C7.81838 4.99083 7.69614 4.92098 7.59136 4.83366C7.49094 4.74198 7.41017 4.63501 7.34905 4.51277C7.29229 4.39053 7.26392 4.25737 7.26392 4.11329C7.26392 3.94303 7.29448 3.79022 7.3556 3.65488C7.42109 3.51954 7.5084 3.40384 7.61755 3.30779C7.73106 3.20738 7.86422 3.13098 8.01703 3.07859C8.16983 3.0262 8.33573 3 8.51473 3C8.68064 3 8.83344 3.0262 8.97315 3.07859C9.11286 3.12661 9.23292 3.19646 9.33333 3.28815C9.43811 3.37546 9.51888 3.48024 9.57564 3.60249C9.63676 3.72473 9.66732 3.85789 9.66732 4.00196ZM8.98625 12.8101C8.90766 12.8319 8.81598 12.8537 8.7112 12.8756C8.61078 12.8974 8.50164 12.917 8.38376 12.9345C8.27025 12.9563 8.15019 12.9716 8.02358 12.9804C7.90133 12.9935 7.77909 13 7.65684 13C7.36433 13 7.11329 12.9607 6.90373 12.8821C6.69854 12.8079 6.52827 12.7031 6.39293 12.5678C6.25759 12.4281 6.15717 12.2644 6.09168 12.0766C6.03056 11.8845 6 11.675 6 11.4479C6 11.3519 6.00437 11.2449 6.0131 11.127C6.0262 11.0092 6.04148 10.8869 6.05894 10.7603C6.0764 10.6293 6.09605 10.4984 6.11788 10.3674C6.14407 10.232 6.17027 10.1033 6.19646 9.98101C6.21393 9.90679 6.24231 9.77145 6.2816 9.57498C6.32526 9.37415 6.37328 9.14495 6.42567 8.88736C6.48243 8.62978 6.54137 8.35909 6.60249 8.07531C6.66361 7.78716 6.72037 7.5143 6.77276 7.25671C6.82951 6.99913 6.87754 6.7721 6.91683 6.57564C6.96049 6.37481 6.99105 6.23728 7.00851 6.16306H9.10413L8.30517 9.93517C8.27025 10.088 8.23314 10.2604 8.19384 10.4525C8.15455 10.6403 8.13491 10.804 8.13491 10.9437C8.13491 11.1096 8.1873 11.2253 8.29208 11.2908C8.39686 11.3563 8.51692 11.389 8.65226 11.389C8.76577 11.389 8.87928 11.3781 8.9928 11.3563C9.11067 11.3301 9.21764 11.2973 9.31369 11.258C9.25693 11.52 9.20236 11.7797 9.14997 12.0373C9.09758 12.2905 9.043 12.5481 8.98625 12.8101Z" fill="var(--svg-fill-7F848D)"/></g><defs><clipPath id="clip0_6202_5229"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "refresh": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M2.22363 9.55664C2.22363 10.3997 2.37858 11.1882 2.68848 11.9219C3.00293 12.651 3.43587 13.2936 3.9873 13.8496C4.53874 14.401 5.17904 14.8317 5.9082 15.1416C6.64193 15.4515 7.42806 15.6064 8.2666 15.6064C9.10059 15.6064 9.88216 15.4515 10.6113 15.1416C11.3451 14.8317 11.9876 14.401 12.5391 13.8496C13.0951 13.2936 13.528 12.651 13.8379 11.9219C14.1478 11.1882 14.3027 10.3997 14.3027 9.55664C14.3027 9.39258 14.2503 9.25814 14.1455 9.15332C14.0407 9.04395 13.904 8.98926 13.7354 8.98926C13.5713 8.98926 13.4414 9.04395 13.3457 9.15332C13.25 9.25814 13.2021 9.39258 13.2021 9.55664C13.2021 10.2448 13.0745 10.8896 12.8193 11.4912C12.5641 12.0882 12.2109 12.6146 11.7598 13.0703C11.3086 13.5215 10.7845 13.8724 10.1875 14.123C9.59049 14.3783 8.9502 14.5059 8.2666 14.5059C7.57845 14.5059 6.93587 14.3783 6.33887 14.123C5.74186 13.8724 5.21777 13.5215 4.7666 13.0703C4.31543 12.6146 3.96224 12.0882 3.70703 11.4912C3.45182 10.8896 3.32422 10.2448 3.32422 9.55664C3.32422 8.87305 3.45182 8.23275 3.70703 7.63574C3.96224 7.03874 4.31543 6.51465 4.7666 6.06348C5.21777 5.6123 5.74186 5.25911 6.33887 5.00391C6.93587 4.7487 7.57845 4.62109 8.2666 4.62109C8.52637 4.62109 8.77474 4.63249 9.01172 4.65527C9.25326 4.67806 9.47428 4.71224 9.6748 4.75781L7.63086 6.78125C7.58073 6.83594 7.54199 6.89746 7.51465 6.96582C7.4873 7.02962 7.47363 7.09798 7.47363 7.1709C7.47363 7.32585 7.52604 7.45573 7.63086 7.56055C7.73568 7.66536 7.86328 7.71777 8.01367 7.71777C8.18229 7.71777 8.31445 7.66536 8.41016 7.56055L11.2266 4.73047C11.2858 4.67122 11.3291 4.60742 11.3564 4.53906C11.3838 4.4707 11.3975 4.39779 11.3975 4.32031C11.3975 4.16536 11.3405 4.02865 11.2266 3.91016L8.41016 1.05273C8.3099 0.943359 8.17773 0.888672 8.01367 0.888672C7.85872 0.888672 7.72884 0.943359 7.62402 1.05273C7.52376 1.15755 7.47363 1.28971 7.47363 1.44922C7.47363 1.51758 7.48503 1.58594 7.50781 1.6543C7.53516 1.72266 7.57389 1.78418 7.62402 1.83887L9.44238 3.63672C9.26465 3.60026 9.07552 3.57292 8.875 3.55469C8.67904 3.5319 8.47624 3.52051 8.2666 3.52051C7.42806 3.52051 6.64193 3.67773 5.9082 3.99219C5.17904 4.30208 4.53874 4.73275 3.9873 5.28418C3.43587 5.83561 3.00293 6.47819 2.68848 7.21191C2.37858 7.94108 2.22363 8.72266 2.22363 9.55664Z" fill="var(--svg-fill-6890D9)"/></svg>',
    "rename": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6202_5186)"><path fill-rule="evenodd" clip-rule="evenodd" d="M9 0H10H11H12V1H11V4H14C15.1046 4 16 4.89543 16 6V10C16 11.1046 15.1046 12 14 12H11V15H12V16H11H10H9V15H10V12H2C0.895431 12 0 11.1046 0 10V6C0 4.89543 0.895431 4 2 4H10V1H9V0ZM10 5H2C1.44772 5 1 5.44772 1 6V10C1 10.5523 1.44772 11 2 11H10V5ZM11 11V5H14C14.5523 5 15 5.44772 15 6V10C15 10.5523 14.5523 11 14 11H11Z" fill="var(--svg-fill-7F848D)"/><rect x="2" y="6" width="7" height="4" fill="var(--svg-fill-32A5FF)"/></g><defs><clipPath id="clip0_6202_5186"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "restore": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M6 5 V13 C6 15 6 15 8 15 H12 C14 15 14 15 14 13 V5 		M7 5.5 H9 M11 5.5 H13" stroke="var(--svg-stroke-7F848D)" stroke-width="1"/><path d="M8.5 7.5 V13 M11.5 7.5 V13 M5 5.5 H8.5 M11.5 5.5 H15" stroke="var(--svg-stroke-7F848D)" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/><path d="M0.48 8.5 8.5 0.48 M2 6 C1 5 1 5 2 4 L4 2 C5 1 5 1 6 2" stroke="var(--svg-stroke-6890D9)" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/><path d="M10 6 V4 C10 3 11 2 12 2 H14 M13.75 0.75 15 2 13.75 3.25" stroke="var(--svg-stroke-6890D9)" stroke-width="1.25" stroke-linecap="round" /></svg>',
    "rotate-cw": '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M6.18046 4.28365C7.31105 3.52821 8.64026 3.125 10 3.125C11.9319 3.125 13.7844 3.89098 15.1792 5.22971L15.9911 6.04167H13.3333C12.9881 6.04167 12.7083 6.32149 12.7083 6.66667C12.7083 7.01184 12.9881 7.29167 13.3333 7.29167H17.4999C17.5033 7.29167 17.5066 7.29164 17.51 7.29159C17.5762 7.29053 17.6422 7.27904 17.7054 7.25711C17.7918 7.22712 17.8729 7.17762 17.9419 7.10861C18.0666 6.98395 18.1276 6.81973 18.1249 6.65636V2.5C18.1249 2.15482 17.8451 1.875 17.4999 1.875C17.1547 1.875 16.8749 2.15482 16.8749 2.5V5.1577L16.0586 4.34139L16.0587 4.34131L16.0498 4.33276C14.4284 2.77409 12.2661 1.875 10 1.875C8.39303 1.875 6.82214 2.35152 5.486 3.24431C4.14985 4.1371 3.10844 5.40605 2.49348 6.8907C1.87852 8.37535 1.71762 10.009 2.03112 11.5851C2.34463 13.1612 3.11846 14.6089 4.25476 15.7452C5.39106 16.8815 6.8388 17.6554 8.4149 17.9689C9.99099 18.2824 11.6247 18.1215 13.1093 17.5065C14.594 16.8916 15.8629 15.8502 16.7557 14.514C17.6485 13.1779 18.125 11.607 18.125 10C18.125 9.65482 17.8452 9.375 17.5 9.375C17.1548 9.375 16.875 9.65482 16.875 10C16.875 11.3597 16.4718 12.689 15.7164 13.8195C14.9609 14.9501 13.8872 15.8313 12.631 16.3517C11.3747 16.872 9.99238 17.0082 8.65876 16.7429C7.32514 16.4776 6.10013 15.8228 5.13864 14.8614C4.17716 13.8999 3.52238 12.6749 3.2571 11.3412C2.99183 10.0076 3.12798 8.62529 3.64833 7.36905C4.16868 6.11281 5.04987 5.03908 6.18046 4.28365Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "R_Del_Arr_Fil": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M2.53459 7.80596C2.93441 7.89667 3.31426 8.09769 3.62558 8.40901L4.53459 9.31802L5.4436 8.40901C6.32228 7.53033 7.7469 7.53033 8.62558 8.40901C9.50426 9.28769 9.50426 10.7123 8.62558 11.591L8.53459 11.682V12.6294C8.53459 13.1525 9.15722 13.4251 9.54156 13.0703L14.557 8.44072C14.8143 8.20314 14.8143 7.79653 14.557 7.55896L9.54156 2.92935C9.15722 2.57457 8.53459 2.84718 8.53459 3.37023V5.49952H3.53459C2.9823 5.49952 2.53459 5.94723 2.53459 6.49952V7.80596Z" fill="var(--svg-fill-31A629)"/><path d="M2.53459 7.80596L2.42396 8.29356C2.19623 8.24189 2.03459 8.03947 2.03459 7.80596H2.53459ZM3.62558 8.40901L3.27203 8.76256L3.62558 8.40901ZM4.53459 9.31802L4.88814 9.67157C4.79437 9.76534 4.6672 9.81802 4.53459 9.81802C4.40198 9.81802 4.2748 9.76534 4.18104 9.67157L4.53459 9.31802ZM5.4436 8.40901L5.79715 8.76256L5.4436 8.40901ZM8.62558 8.40901L8.97913 8.05546L8.62558 8.40901ZM8.62558 11.591L8.27203 11.2374L8.27203 11.2374L8.62558 11.591ZM8.53459 11.682H8.03459C8.03459 11.5494 8.08727 11.4222 8.18104 11.3284L8.53459 11.682ZM9.54156 13.0703L9.20242 12.7029L9.20242 12.7029L9.54156 13.0703ZM14.557 8.44072L14.8961 8.80812H14.8961L14.557 8.44072ZM14.557 7.55896L14.2178 7.92636H14.2178L14.557 7.55896ZM9.54156 2.92935L9.8807 2.56194V2.56194L9.54156 2.92935ZM8.53459 5.49952H9.03459C9.03459 5.77566 8.81073 5.99952 8.53459 5.99952V5.49952ZM2.64522 7.31835C3.13434 7.42933 3.59918 7.6755 3.97913 8.05546L3.27203 8.76256C3.02935 8.51989 2.73448 8.36402 2.42396 8.29356L2.64522 7.31835ZM3.97913 8.05546L4.88814 8.96447L4.18104 9.67157L3.27203 8.76256L3.97913 8.05546ZM4.18104 8.96447L5.09005 8.05546L5.79715 8.76256L4.88814 9.67157L4.18104 8.96447ZM5.09005 8.05546C6.16399 6.98151 7.90519 6.98151 8.97913 8.05546L8.27203 8.76256C7.58861 8.07915 6.48057 8.07915 5.79715 8.76256L5.09005 8.05546ZM8.97913 8.05546C10.0531 9.1294 10.0531 10.8706 8.97913 11.9445L8.27203 11.2374C8.95544 10.554 8.95544 9.44598 8.27203 8.76256L8.97913 8.05546ZM8.97913 11.9445L8.88814 12.0355L8.18104 11.3284L8.27203 11.2374L8.97913 11.9445ZM9.03459 11.682V12.6294H8.03459V11.682H9.03459ZM9.03459 12.6294C9.03459 12.6577 9.04204 12.6742 9.0498 12.6855C9.059 12.6988 9.07408 12.7121 9.09448 12.7211C9.11488 12.73 9.13487 12.7321 9.15093 12.7298C9.16447 12.7278 9.18166 12.7221 9.20242 12.7029L9.8807 13.4377C9.17607 14.0882 8.03459 13.5884 8.03459 12.6294H9.03459ZM9.20242 12.7029L14.2178 8.07332L14.8961 8.80812L9.8807 13.4377L9.20242 12.7029ZM14.2178 8.07332C14.2607 8.03372 14.2607 7.96596 14.2178 7.92636L14.8961 7.19156C15.368 7.62711 15.368 8.37256 14.8961 8.80812L14.2178 8.07332ZM14.2178 7.92636L9.20242 3.29675L9.8807 2.56194L14.8961 7.19156L14.2178 7.92636ZM9.20242 3.29675C9.18166 3.27759 9.16447 3.27187 9.15093 3.26992C9.13487 3.26761 9.11488 3.26969 9.09448 3.27862C9.07408 3.28755 9.059 3.30083 9.0498 3.3142C9.04204 3.32547 9.03459 3.34198 9.03459 3.37023H8.03459C8.03459 2.4113 9.17607 1.91152 9.8807 2.56194L9.20242 3.29675ZM9.03459 3.37023V5.49952H8.03459V3.37023H9.03459ZM8.53459 5.99952H3.53459V4.99952H8.53459V5.99952ZM3.53459 5.99952C3.25845 5.99952 3.03459 6.22338 3.03459 6.49952H2.03459C2.03459 5.67109 2.70616 4.99952 3.53459 4.99952V5.99952ZM3.03459 6.49952V7.80596H2.03459V6.49952H3.03459Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.565 14.4697C7.85789 14.7626 7.85789 15.2374 7.565 15.5303C7.2721 15.8232 6.79723 15.8232 6.50434 15.5303L4.53467 13.5607L2.565 15.5303C2.2721 15.8232 1.79723 15.8232 1.50434 15.5303C1.21144 15.2374 1.21144 14.7626 1.50434 14.4697L3.47401 12.5L1.50434 10.5303C1.21144 10.2374 1.21144 9.76256 1.50434 9.46967C1.79723 9.17678 2.27211 9.17678 2.565 9.46967L4.53467 11.4393L6.50434 9.46967C6.79723 9.17678 7.2721 9.17678 7.565 9.46967C7.85789 9.76256 7.85789 10.2374 7.565 10.5303L5.59533 12.5L7.565 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "R_Del_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M9 3.37024C9 3.34199 9.00745 3.32548 9.01521 3.31421C9.02441 3.30084 9.03949 3.28757 9.05989 3.27864C9.08029 3.2697 9.10028 3.26762 9.11634 3.26993C9.12988 3.27188 9.14707 3.2776 9.16783 3.29676L14.1832 7.92637C14.2261 7.96597 14.2261 8.03373 14.1832 8.07333L9.16783 12.7029C9.14707 12.7221 9.12988 12.7278 9.11634 12.7298C9.10028 12.7321 9.08029 12.73 9.05989 12.7211C9.03949 12.7121 9.02441 12.6989 9.01521 12.6855C9.00745 12.6742 9 12.6577 9 12.6295V11.0964C8.90101 11.2737 8.77619 11.4404 8.62554 11.591L8 12.2165V12.6295C8 12.6864 8.00402 12.7417 8.01173 12.7952L8.62554 13.409C8.71918 13.5027 8.80283 13.6025 8.87651 13.7072C9.20124 13.7764 9.55975 13.7021 9.84611 13.4377L14.8615 8.80813C15.3334 8.37257 15.3334 7.62712 14.8615 7.19157L9.84611 2.56196C9.14148 1.91153 8 2.41131 8 3.37024V4.99953H3.5C2.67157 4.99953 2 5.6711 2 6.49953V7.75028C2.3419 7.74506 2.68476 7.8173 3 7.96699V6.49953C3 6.22339 3.22386 5.99953 3.5 5.99953H8.5C8.77614 5.99953 9 5.77567 9 5.49953V3.37024Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.565 14.4697C7.85789 14.7626 7.85789 15.2374 7.565 15.5303C7.2721 15.8232 6.79723 15.8232 6.50434 15.5303L4.53467 13.5607L2.565 15.5303C2.2721 15.8232 1.79723 15.8232 1.50434 15.5303C1.21144 15.2374 1.21144 14.7626 1.50434 14.4697L3.47401 12.5L1.50434 10.5303C1.21144 10.2374 1.21144 9.76256 1.50434 9.46967C1.79723 9.17678 2.27211 9.17678 2.565 9.46967L4.53467 11.4393L6.50434 9.46967C6.79723 9.17678 7.2721 9.17678 7.565 9.46967C7.85789 9.76256 7.85789 10.2374 7.565 10.5303L5.59533 12.5L7.565 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "R_Del_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M6.34464 2.56196C5.64001 1.91153 4.49853 2.41131 4.49853 3.37024V4.99953H2.99853C2.1701 4.99953 1.49853 5.6711 1.49853 6.49953V8.25C1.94639 8.25 2.39426 8.42085 2.73597 8.76256L3.99854 10.0251L5.2611 8.76256C5.94452 8.07915 7.05255 8.07915 7.73597 8.76256C8.41939 9.44598 8.41939 10.554 7.73597 11.2374L6.47341 12.5L6.89922 12.9258L11.36 8.80813C11.8319 8.37257 11.8319 7.62712 11.36 7.19157L6.34464 2.56196ZM9.14497 2.64646C9.34024 2.4512 9.65682 2.4512 9.85208 2.64646L14.4278 7.22219C14.8574 7.65177 14.8574 8.34825 14.4278 8.77783L9.85208 13.3536C9.65682 13.5488 9.34024 13.5488 9.14497 13.3536C8.94971 13.1583 8.94971 12.8417 9.14497 12.6465L13.7207 8.07072C13.7598 8.03167 13.7598 7.96835 13.7207 7.9293L9.14497 3.35356C8.94971 3.1583 8.94971 2.84172 9.14497 2.64646Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.02887 14.4697C7.32176 14.7626 7.32176 15.2374 7.02887 15.5303C6.73597 15.8232 6.2611 15.8232 5.96821 15.5303L3.99854 13.5607L2.02887 15.5303C1.73597 15.8232 1.2611 15.8232 0.968205 15.5303C0.675312 15.2374 0.675312 14.7626 0.968205 14.4697L2.93788 12.5L0.968205 10.5303C0.675312 10.2374 0.675312 9.76256 0.968205 9.46967C1.2611 9.17678 1.73597 9.17678 2.02887 9.46967L3.99854 11.4393L5.96821 9.46967C6.2611 9.17678 6.73597 9.17678 7.02887 9.46967C7.32176 9.76256 7.32176 10.2374 7.02887 10.5303L5.0592 12.5L7.02887 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "R_Del_Dbl_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M5.51374 3.31421C5.50598 3.32548 5.49853 3.34199 5.49853 3.37024V5.49953C5.49853 5.77567 5.27467 5.99953 4.99853 5.99953H2.99853C2.72239 5.99953 2.49853 6.22339 2.49853 6.49953V8.56349C2.19905 8.3545 1.84879 8.25 1.49853 8.25V6.49953C1.49853 5.6711 2.1701 4.99953 2.99853 4.99953H4.49853V3.37024C4.49853 2.41131 5.64001 1.91153 6.34464 2.56196L11.36 7.19157C11.8319 7.62712 11.8319 8.37257 11.36 8.80813L6.89922 12.9258L6.47341 12.5L7.73597 11.2374C7.98759 10.9858 8.14657 10.6766 8.21291 10.3523L10.6818 8.07333C10.7247 8.03373 10.7247 7.96597 10.6818 7.92637L5.66636 3.29676C5.6456 3.2776 5.62841 3.27188 5.61487 3.26993C5.5988 3.26762 5.57882 3.2697 5.55842 3.27864C5.53802 3.28757 5.52294 3.30084 5.51374 3.31421ZM4.02413 9.99953L3.99854 10.0251L3.97294 9.99953H4.02413ZM9.14497 2.64646C9.34024 2.4512 9.65682 2.4512 9.85208 2.64646L14.4278 7.22219C14.8574 7.65177 14.8574 8.34825 14.4278 8.77783L9.85208 13.3536C9.65682 13.5488 9.34024 13.5488 9.14497 13.3536C8.94971 13.1583 8.94971 12.8417 9.14497 12.6465L13.7207 8.07072C13.7598 8.03167 13.7598 7.96835 13.7207 7.9293L9.14497 3.35356C8.94971 3.1583 8.94971 2.84172 9.14497 2.64646Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M7.02887 14.4697C7.32176 14.7626 7.32176 15.2374 7.02887 15.5303C6.73597 15.8232 6.2611 15.8232 5.96821 15.5303L3.99854 13.5607L2.02887 15.5303C1.73597 15.8232 1.2611 15.8232 0.968205 15.5303C0.675312 15.2374 0.675312 14.7626 0.968205 14.4697L2.93788 12.5L0.968205 10.5303C0.675312 10.2374 0.675312 9.76256 0.968205 9.46967C1.2611 9.17678 1.73597 9.17678 2.02887 9.46967L3.99854 11.4393L5.96821 9.46967C6.2611 9.17678 6.73597 9.17678 7.02887 9.46967C7.32176 9.76256 7.32176 10.2374 7.02887 10.5303L5.0592 12.5L7.02887 14.4697Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "R_Dis_Arr_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M9.83065 2.56196C9.12602 1.91153 7.98454 2.41131 7.98454 3.37024V4.99953H3.48454C2.65611 4.99953 1.98454 5.6711 1.98454 6.49953V9.49953C1.98454 10.328 2.65611 10.9995 3.48454 10.9995H7.98454V12.6295C7.98454 13.5884 9.12602 14.0882 9.83065 13.4377L14.8461 8.80813C15.3179 8.37257 15.3179 7.62712 14.8461 7.19157L9.83065 2.56196Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "R_Dis_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.5 10.4995H9C9 10.2234 8.77614 9.99952 8.5 9.99952V10.4995ZM9.50697 13.0703L9.16783 12.7029H9.16783L9.50697 13.0703ZM14.5224 8.44072L14.8615 8.80812V8.80812L14.5224 8.44072ZM14.5224 7.55896L14.1832 7.92636L14.5224 7.55896ZM9.50697 2.92935L9.84611 2.56194V2.56194L9.50697 2.92935ZM8.5 5.49952V5.99952C8.77614 5.99952 9 5.77566 9 5.49952H8.5ZM9 12.6294V10.4995H8V12.6294H9ZM9.16783 12.7029C9.14707 12.7221 9.12988 12.7278 9.11634 12.7298C9.10028 12.7321 9.08029 12.73 9.05989 12.7211C9.03949 12.7121 9.02441 12.6988 9.01521 12.6855C9.00745 12.6742 9 12.6577 9 12.6294H8C8 13.5884 9.14148 14.0882 9.84611 13.4377L9.16783 12.7029ZM14.1832 8.07332L9.16783 12.7029L9.84611 13.4377L14.8615 8.80812L14.1832 8.07332ZM14.1832 7.92636C14.2261 7.96595 14.2261 8.03372 14.1832 8.07332L14.8615 8.80812C15.3334 8.37256 15.3334 7.62711 14.8615 7.19155L14.1832 7.92636ZM9.16783 3.29675L14.1832 7.92636L14.8615 7.19155L9.84611 2.56194L9.16783 3.29675ZM9 3.37023C9 3.34198 9.00745 3.32547 9.01521 3.3142C9.02441 3.30083 9.03949 3.28755 9.05989 3.27862C9.08029 3.26969 9.10028 3.26761 9.11634 3.26992C9.12988 3.27187 9.14707 3.27759 9.16783 3.29675L9.84611 2.56194C9.14148 1.91152 8 2.4113 8 3.37023H9ZM9 5.49952V3.37023H8V5.49952H9ZM3.5 5.99952H8.5V4.99952H3.5V5.99952ZM3 6.49952C3 6.22338 3.22386 5.99952 3.5 5.99952V4.99952C2.67157 4.99952 2 5.67109 2 6.49952H3ZM3 9.49952V6.49952H2V9.49952H3ZM3.5 9.99952C3.22386 9.99952 3 9.77566 3 9.49952H2C2 10.3279 2.67157 10.9995 3.5 10.9995V9.99952ZM8.5 9.99952H3.5V10.9995H8.5V9.99952Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "R_Dis_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M4 3.37024C4 2.41131 5.14148 1.91153 5.84611 2.56196L10.8615 7.19157C11.3334 7.62712 11.3334 8.37257 10.8615 8.80813L5.84611 13.4377C5.14148 14.0882 4 13.5884 4 12.6295V10.9995H2.5C1.67157 10.9995 1 10.328 1 9.49953V6.49953C1 5.6711 1.67157 4.99953 2.5 4.99953H4V3.37024ZM9.35355 2.64646C9.15829 2.4512 8.84171 2.4512 8.64645 2.64646C8.45118 2.84172 8.45118 3.1583 8.64645 3.35356L13.2222 7.9293C13.2612 7.96835 13.2612 8.03167 13.2222 8.07072L8.64645 12.6465C8.45118 12.8417 8.45118 13.1583 8.64645 13.3536C8.84171 13.5488 9.15829 13.5488 9.35355 13.3536L13.9293 8.77783C14.3589 8.34825 14.3589 7.65177 13.9293 7.22219L9.35355 2.64646Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "R_Dis_Dbl_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M5 3.37024C5 3.34199 5.00745 3.32548 5.01521 3.31421C5.02441 3.30084 5.03949 3.28757 5.05989 3.27864C5.08029 3.2697 5.10028 3.26762 5.11634 3.26993C5.12988 3.27188 5.14707 3.2776 5.16783 3.29676L10.1832 7.92637C10.2261 7.96597 10.2261 8.03373 10.1832 8.07333L5.16783 12.7029C5.14707 12.7221 5.12988 12.7278 5.11634 12.7298C5.10028 12.7321 5.08029 12.73 5.05989 12.7211C5.03949 12.7121 5.02441 12.6989 5.01521 12.6855C5.00745 12.6742 5 12.6577 5 12.6295V10.4995C5 10.2234 4.77614 9.99953 4.5 9.99953H2.5C2.22386 9.99953 2 9.77567 2 9.49953V6.49953C2 6.22339 2.22386 5.99953 2.5 5.99953H4.5C4.77614 5.99953 5 5.77567 5 5.49953V3.37024ZM5.84611 2.56196C5.14148 1.91153 4 2.41131 4 3.37024V4.99953H2.5C1.67157 4.99953 1 5.6711 1 6.49953V9.49953C1 10.328 1.67157 10.9995 2.5 10.9995H4V12.6295C4 13.5884 5.14148 14.0882 5.84611 13.4377L10.8615 8.80813C11.3334 8.37257 11.3334 7.62712 10.8615 7.19157L5.84611 2.56196ZM9.35355 2.64646C9.15829 2.4512 8.84171 2.4512 8.64645 2.64646C8.45118 2.84172 8.45118 3.1583 8.64645 3.35356L13.2222 7.9293C13.2612 7.96835 13.2612 8.03167 13.2222 8.07072L8.64645 12.6465C8.45118 12.8417 8.45118 13.1583 8.64645 13.3536C8.84171 13.5488 9.15829 13.5488 9.35355 13.3536L13.9293 8.77783C14.3589 8.34825 14.3589 7.65177 13.9293 7.22219L9.35355 2.64646Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "R_Ena_Arr_Aa_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M9 3.37024C9 3.34199 9.00745 3.32548 9.01521 3.31421C9.02441 3.30084 9.03949 3.28757 9.05989 3.27864C9.08029 3.2697 9.10028 3.26762 9.11634 3.26993C9.12988 3.27188 9.14707 3.2776 9.16783 3.29676L14.1832 7.92637C14.2261 7.96597 14.2261 8.03373 14.1832 8.07333L13.6246 8.58896C13.969 8.70224 14.2912 8.85907 14.579 9.0689L14.8615 8.80813C15.3334 8.37257 15.3334 7.62712 14.8615 7.19157L9.84611 2.56196C9.14148 1.91153 8 2.41131 8 3.37024V4.99953H3.5C2.67157 4.99953 2 5.6711 2 6.49953V9.48221L2.73067 7.26859C2.78491 7.10427 2.87896 6.96133 3 6.84905V6.49953C3 6.22339 3.22386 5.99953 3.5 5.99953H8.5C8.77614 5.99953 9 5.77567 9 5.49953V3.37024ZM3.0117 9.60755L2.64133 10.7296C2.88458 10.8997 3.18064 10.9995 3.5 10.9995H4.61275L4.91463 9.99953H3.5C3.26094 9.99953 3.06107 9.83176 3.0117 9.60755ZM5.19876 9.99953H7.23108L7.56116 10.9995H5.50065L5.19876 9.99953ZM8 12.329V12.6295C8 12.9756 8.14873 13.2619 8.37195 13.4559L8 12.329ZM13.8227 9.76702C13.6417 9.65976 13.4354 9.57256 13.2038 9.5054C13.0581 9.462 12.9036 9.4286 12.7404 9.4052L10.7444 11.2477H11.4217C11.4459 11.0762 11.5171 10.9494 11.6354 10.8673C11.6995 10.8225 11.7734 10.7896 11.8571 10.7685C11.8998 10.7578 11.9451 10.7501 11.9929 10.7456L12.0018 10.7448L12.0163 10.7436L12.0358 10.7424C12.0576 10.7412 12.0799 10.7406 12.1027 10.7406C12.2766 10.7406 12.419 10.7792 12.5301 10.8565C12.5519 10.8716 12.5715 10.8881 12.589 10.9058L13.8227 9.76702ZM11.7679 11.6637L9.84611 13.4377C9.70286 13.57 9.54155 13.6547 9.37545 13.6976C9.36805 13.623 9.36435 13.5453 9.36435 13.4644C9.36435 13.4047 9.36635 13.3466 9.37036 13.2903C9.38675 13.0599 9.43666 12.8584 9.5201 12.6857C9.60158 12.5151 9.70833 12.3691 9.84036 12.2477C9.87659 12.2143 9.91472 12.1828 9.95476 12.1532C10.1407 12.0156 10.3568 11.9105 10.6031 11.8381C10.8518 11.7656 11.1199 11.7185 11.4072 11.6968L11.4217 11.6957C11.5473 11.6858 11.6627 11.6752 11.7679 11.6637ZM8.85276 10.1452C8.72928 10.4071 8.64636 10.6842 8.60566 10.9736L8.28415 9.99953H8.5C8.63767 9.99953 8.76234 10.0552 8.85276 10.1452Z" fill="var(--svg-fill-31A629)"/><path d="M3.40511 15.0002H1.23181L3.68039 7.58203H6.43323L8.88181 15.0002H6.70852L5.08579 9.62493H5.02783L3.40511 15.0002ZM2.99943 12.0735H7.08522V13.5803H2.99943V12.0735Z" fill="var(--svg-fill-32A5FF)"/><path d="M11.1755 15.0871C10.8206 15.0871 10.5067 15.0292 10.2338 14.9133C9.96333 14.795 9.75083 14.6163 9.59628 14.3772C9.44174 14.1381 9.36446 13.8339 9.36446 13.4644C9.36446 13.1602 9.41638 12.9006 9.52022 12.6857C9.62405 12.4683 9.76894 12.2908 9.95488 12.1532C10.1408 12.0156 10.3569 11.9105 10.6032 11.8381C10.852 11.7656 11.12 11.7185 11.4074 11.6968C11.7189 11.6727 11.9688 11.6437 12.1571 11.6099C12.3479 11.5737 12.4856 11.5241 12.5701 11.4614C12.6546 11.3962 12.6969 11.3104 12.6969 11.2042V11.1897C12.6969 11.0448 12.6413 10.9337 12.5302 10.8565C12.4192 10.7792 12.2767 10.7406 12.1028 10.7406C11.912 10.7406 11.7563 10.7828 11.6356 10.8673C11.5172 10.9494 11.446 11.0762 11.4219 11.2477H9.58179C9.60594 10.9096 9.7134 10.5981 9.90417 10.3131C10.0973 10.0258 10.3787 9.79638 10.7481 9.62493C11.1176 9.45107 11.5788 9.36413 12.1318 9.36413C12.5302 9.36413 12.8876 9.41122 13.204 9.5054C13.5203 9.59716 13.7895 9.72635 14.0117 9.89297C14.2339 10.0572 14.4029 10.2504 14.5188 10.4725C14.6371 10.6923 14.6963 10.9313 14.6963 11.1897V15.0002H12.8272V14.2178H12.7838C12.6727 14.4255 12.5375 14.5933 12.3781 14.7213C12.2211 14.8493 12.0412 14.9423 11.8384 15.0002C11.638 15.0582 11.417 15.0871 11.1755 15.0871ZM11.8275 13.8266C11.9797 13.8266 12.1221 13.7952 12.2549 13.7325C12.3902 13.6697 12.5 13.5791 12.5846 13.4608C12.6691 13.3425 12.7113 13.1988 12.7113 13.0298V12.5661C12.6582 12.5879 12.6015 12.6084 12.5411 12.6277C12.4831 12.647 12.4204 12.6651 12.3527 12.682C12.2875 12.6989 12.2175 12.7146 12.1427 12.7291C12.0702 12.7436 11.9942 12.7569 11.9145 12.769C11.7599 12.7931 11.6331 12.833 11.5341 12.8885C11.4375 12.9416 11.3651 13.008 11.3168 13.0877C11.2709 13.165 11.248 13.2519 11.248 13.3485C11.248 13.5031 11.3023 13.6214 11.411 13.7035C11.5196 13.7856 11.6585 13.8266 11.8275 13.8266Z" fill="var(--svg-fill-32A5FF)"/></svg>',
    "R_Ena_Arr_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M9.83065 2.56196C9.12602 1.91153 7.98454 2.41131 7.98454 3.37024V4.99953H3.48454C2.65611 4.99953 1.98454 5.6711 1.98454 6.49953V9.49953C1.98454 10.328 2.65611 10.9995 3.48454 10.9995H7.98454V12.6295C7.98454 13.5884 9.12602 14.0882 9.83065 13.4377L14.8461 8.80813C15.3179 8.37257 15.3179 7.62712 14.8461 7.19157L9.83065 2.56196Z" fill="var(--svg-fill-31A629)"/></svg>',
    "R_Ena_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.5 10.4995H9C9 10.2234 8.77614 9.99952 8.5 9.99952V10.4995ZM9.50697 13.0703L9.16783 12.7029H9.16783L9.50697 13.0703ZM14.5224 8.44072L14.8615 8.80812V8.80812L14.5224 8.44072ZM14.5224 7.55896L14.1832 7.92636L14.5224 7.55896ZM9.50697 2.92935L9.84611 2.56194V2.56194L9.50697 2.92935ZM8.5 5.49952V5.99952C8.77614 5.99952 9 5.77566 9 5.49952H8.5ZM9 12.6294V10.4995H8V12.6294H9ZM9.16783 12.7029C9.14707 12.7221 9.12988 12.7278 9.11634 12.7298C9.10028 12.7321 9.08029 12.73 9.05989 12.7211C9.03949 12.7121 9.02441 12.6988 9.01521 12.6855C9.00745 12.6742 9 12.6577 9 12.6294H8C8 13.5884 9.14148 14.0882 9.84611 13.4377L9.16783 12.7029ZM14.1832 8.07332L9.16783 12.7029L9.84611 13.4377L14.8615 8.80812L14.1832 8.07332ZM14.1832 7.92636C14.2261 7.96595 14.2261 8.03372 14.1832 8.07332L14.8615 8.80812C15.3334 8.37256 15.3334 7.62711 14.8615 7.19155L14.1832 7.92636ZM9.16783 3.29675L14.1832 7.92636L14.8615 7.19155L9.84611 2.56194L9.16783 3.29675ZM9 3.37023C9 3.34198 9.00745 3.32547 9.01521 3.3142C9.02441 3.30083 9.03949 3.28755 9.05989 3.27862C9.08029 3.26969 9.10028 3.26761 9.11634 3.26992C9.12988 3.27187 9.14707 3.27759 9.16783 3.29675L9.84611 2.56194C9.14148 1.91152 8 2.4113 8 3.37023H9ZM9 5.49952V3.37023H8V5.49952H9ZM3.5 5.99952H8.5V4.99952H3.5V5.99952ZM3 6.49952C3 6.22338 3.22386 5.99952 3.5 5.99952V4.99952C2.67157 4.99952 2 5.67109 2 6.49952H3ZM3 9.49952V6.49952H2V9.49952H3ZM3.5 9.99952C3.22386 9.99952 3 9.77566 3 9.49952H2C2 10.3279 2.67157 10.9995 3.5 10.9995V9.99952ZM8.5 9.99952H3.5V10.9995H8.5V9.99952Z" fill="var(--svg-fill-31A629)"/></svg>',
    "R_Ena_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M4 3.37024C4 2.41131 5.14148 1.91153 5.84611 2.56196L10.8615 7.19157C11.3334 7.62712 11.3334 8.37257 10.8615 8.80813L5.84611 13.4377C5.14148 14.0882 4 13.5884 4 12.6295V10.9995H2.5C1.67157 10.9995 1 10.328 1 9.49953V6.49953C1 5.6711 1.67157 4.99953 2.5 4.99953H4V3.37024ZM9.35355 2.64646C9.15829 2.4512 8.84171 2.4512 8.64645 2.64646C8.45118 2.84172 8.45118 3.1583 8.64645 3.35356L13.2222 7.9293C13.2612 7.96835 13.2612 8.03167 13.2222 8.07072L8.64645 12.6465C8.45118 12.8417 8.45118 13.1583 8.64645 13.3536C8.84171 13.5488 9.15829 13.5488 9.35355 13.3536L13.9293 8.77783C14.3589 8.34825 14.3589 7.65177 13.9293 7.22219L9.35355 2.64646Z" fill="var(--svg-fill-31A629)"/></svg>',
    "R_Ena_Dbl_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M5 3.37024C5 3.34199 5.00745 3.32548 5.01521 3.31421C5.02441 3.30084 5.03949 3.28757 5.05989 3.27864C5.08029 3.2697 5.10028 3.26762 5.11634 3.26993C5.12988 3.27188 5.14707 3.2776 5.16783 3.29676L10.1832 7.92637C10.2261 7.96597 10.2261 8.03373 10.1832 8.07333L5.16783 12.7029C5.14707 12.7221 5.12988 12.7278 5.11634 12.7298C5.10028 12.7321 5.08029 12.73 5.05989 12.7211C5.03949 12.7121 5.02441 12.6989 5.01521 12.6855C5.00745 12.6742 5 12.6577 5 12.6295V10.4995C5 10.2234 4.77614 9.99953 4.5 9.99953H2.5C2.22386 9.99953 2 9.77567 2 9.49953V6.49953C2 6.22339 2.22386 5.99953 2.5 5.99953H4.5C4.77614 5.99953 5 5.77567 5 5.49953V3.37024ZM5.84611 2.56196C5.14148 1.91153 4 2.41131 4 3.37024V4.99953H2.5C1.67157 4.99953 1 5.6711 1 6.49953V9.49953C1 10.328 1.67157 10.9995 2.5 10.9995H4V12.6295C4 13.5884 5.14148 14.0882 5.84611 13.4377L10.8615 8.80813C11.3334 8.37257 11.3334 7.62712 10.8615 7.19157L5.84611 2.56196ZM9.35355 2.64646C9.15829 2.4512 8.84171 2.4512 8.64645 2.64646C8.45118 2.84172 8.45118 3.1583 8.64645 3.35356L13.2222 7.9293C13.2612 7.96835 13.2612 8.03167 13.2222 8.07072L8.64645 12.6465C8.45118 12.8417 8.45118 13.1583 8.64645 13.3536C8.84171 13.5488 9.15829 13.5488 9.35355 13.3536L13.9293 8.77783C14.3589 8.34825 14.3589 7.65177 13.9293 7.22219L9.35355 2.64646Z" fill="var(--svg-fill-31A629)"/></svg>',
    "R_Ena_Ss_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M9 3.37024C9 3.34199 9.00745 3.32548 9.01521 3.31421C9.02441 3.30084 9.03949 3.28757 9.05989 3.27864C9.08029 3.2697 9.10028 3.26762 9.11634 3.26993C9.12988 3.27188 9.14707 3.2776 9.16783 3.29676L14.1832 7.92637C14.2261 7.96597 14.2261 8.03373 14.1832 8.07333L9.16783 12.7029C9.14707 12.7221 9.12988 12.7278 9.11634 12.7298C9.10028 12.7321 9.08029 12.73 9.05989 12.7211C9.03949 12.7121 9.02441 12.6989 9.01521 12.6855C9.00745 12.6742 9 12.6577 9 12.6295V10.4995C9 10.2234 8.77614 9.99953 8.5 9.99953H7.99432L7.9993 10.9995H8V12.4806C8.0012 12.548 8.00133 12.615 8.00109 12.6806C8.04078 13.6059 9.15411 14.0765 9.84611 13.4377L14.8615 8.80813C15.3334 8.37257 15.3334 7.62712 14.8615 7.19157L9.84611 2.56196C9.14148 1.91153 8 2.41131 8 3.37024V4.99953H3.5C2.67157 4.99953 2 5.6711 2 6.49953V7.09388C2.06315 7.06217 2.12745 7.03199 2.19286 7.0033L2.19466 7.00252C2.45267 6.88998 2.72168 6.80441 3 6.74366V6.49953C3 6.22339 3.22386 5.99953 3.5 5.99953H8.5C8.77614 5.99953 9 5.77567 9 5.49953V3.37024Z" fill="var(--svg-fill-31A629)"/><path d="M5.10511 10.0001C5.08617 9.76335 4.9974 9.57869 4.83878 9.44611C4.68253 9.31354 4.4446 9.24725 4.125 9.24725C3.9214 9.24725 3.7545 9.27211 3.62429 9.32182C3.49645 9.36917 3.40175 9.43427 3.3402 9.51713C3.27865 9.59999 3.24669 9.69469 3.24432 9.80123C3.23958 9.88882 3.25497 9.96813 3.29048 10.0392C3.32836 10.1078 3.38755 10.1705 3.46804 10.2274C3.54853 10.2818 3.65152 10.3315 3.77699 10.3765C3.90246 10.4215 4.05161 10.4617 4.22443 10.4972L4.82102 10.6251C5.22348 10.7103 5.56795 10.8228 5.8544 10.9624C6.14086 11.1021 6.37524 11.2667 6.55753 11.4561C6.73982 11.6431 6.87358 11.8538 6.95881 12.0882C7.0464 12.3225 7.09138 12.5782 7.09375 12.8552C7.09138 13.3334 6.97183 13.7383 6.73509 14.0697C6.49834 14.4011 6.1598 14.6533 5.71946 14.8261C5.28149 14.9989 4.75473 15.0853 4.1392 15.0853C3.5071 15.0853 2.95549 14.9918 2.48438 14.8048C2.01563 14.6178 1.65104 14.3301 1.39063 13.9419C1.13258 13.5512 1.00237 13.0517 1 12.4433H2.875C2.88684 12.6658 2.94247 12.8528 3.0419 13.0044C3.14134 13.1559 3.28101 13.2707 3.46094 13.3488C3.64323 13.4269 3.85985 13.466 4.1108 13.466C4.3215 13.466 4.49787 13.44 4.63991 13.3879C4.78196 13.3358 4.88968 13.2636 4.96307 13.1713C5.03646 13.0789 5.07434 12.9736 5.0767 12.8552C5.07434 12.7439 5.03764 12.6469 4.96662 12.564C4.89796 12.4788 4.78433 12.403 4.62571 12.3367C4.46709 12.2681 4.25284 12.2042 3.98295 12.145L3.25852 11.9887C2.61458 11.849 2.10677 11.6159 1.73509 11.2892C1.36577 10.9601 1.18229 10.5115 1.18466 9.94327C1.18229 9.48162 1.3054 9.07798 1.55398 8.73233C1.80492 8.38432 2.15175 8.11325 2.59446 7.91912C3.03954 7.72499 3.54972 7.62793 4.125 7.62793C4.71212 7.62793 5.21993 7.72618 5.64844 7.92267C6.07694 8.11917 6.4072 8.39616 6.6392 8.75364C6.87358 9.10875 6.99195 9.52424 6.99432 10.0001H5.10511Z" fill="var(--svg-fill-32A5FF)"/></svg>',
    "R_Ena_Ts_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M9 3.37024C9 3.34199 9.00745 3.32548 9.01521 3.31421C9.02441 3.30084 9.03949 3.28757 9.05989 3.27864C9.08029 3.2697 9.10028 3.26762 9.11634 3.26993C9.12988 3.27188 9.14707 3.2776 9.16783 3.29676L14.1832 7.92637C14.2261 7.96597 14.2261 8.03373 14.1832 8.07333L9.16783 12.7029C9.14707 12.7221 9.12988 12.7278 9.11634 12.7298C9.10028 12.7321 9.08029 12.73 9.05989 12.7211C9.03949 12.7121 9.02441 12.6989 9.01521 12.6855C9.00745 12.6742 9 12.6577 9 12.6295V10.4995C9 10.2234 8.77614 9.99953 8.5 9.99953H7.125V10.5625C7.125 10.7192 7.08895 10.8675 7.0247 10.9995H8V12.6295C8 13.5884 9.14148 14.0882 9.84611 13.4377L14.8615 8.80813C15.3334 8.37257 15.3334 7.62712 14.8615 7.19157L9.84611 2.56196C9.14148 1.91153 8 2.41131 8 3.37024V4.99953H3.5C2.67157 4.99953 2 5.6711 2 6.49953V7.21374C2.14154 6.83342 2.50788 6.5625 2.9375 6.5625H3V6.49953C3 6.22339 3.22386 5.99953 3.5 5.99953H8.5C8.77614 5.99953 9 5.77567 9 5.49953V3.37024Z" fill="var(--svg-fill-31A629)"/><path d="M6.125 9V10.5625H2.17188V9H6.125ZM2.9375 7.5625H5.09375V13.0703C5.09375 13.1536 5.10807 13.224 5.13672 13.2812C5.16536 13.3359 5.20964 13.3776 5.26953 13.4062C5.32943 13.4323 5.40625 13.4453 5.5 13.4453C5.5651 13.4453 5.64062 13.4375 5.72656 13.4219C5.8151 13.4062 5.88021 13.3932 5.92188 13.3828L6.23438 14.8984C6.13802 14.9271 6 14.9622 5.82031 15.0039C5.64323 15.0456 5.43229 15.0729 5.1875 15.0859C4.69271 15.112 4.27734 15.0612 3.94141 14.9336C3.60547 14.8034 3.35286 14.599 3.18359 14.3203C3.01432 14.0417 2.93229 13.6927 2.9375 13.2734V7.5625Z" fill="var(--svg-fill-32A5FF)"/></svg>',
    "R_Err_Arr_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M9.83065 2.56196C9.12602 1.91153 7.98454 2.41131 7.98454 3.37024V4.99953H3.48454C2.65611 4.99953 1.98454 5.6711 1.98454 6.49953V9.49953C1.98454 10.328 2.65611 10.9995 3.48454 10.9995H7.98454V12.6295C7.98454 13.5884 9.12602 14.0882 9.83065 13.4377L14.8461 8.80813C15.3179 8.37257 15.3179 7.62712 14.8461 7.19157L9.83065 2.56196Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "R_Err_Arr_Nofl": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M8.5 10.4995H9C9 10.2234 8.77614 9.99952 8.5 9.99952V10.4995ZM9.50697 13.0703L9.16783 12.7029H9.16783L9.50697 13.0703ZM14.5224 8.44072L14.8615 8.80812V8.80812L14.5224 8.44072ZM14.5224 7.55896L14.1832 7.92636L14.5224 7.55896ZM9.50697 2.92935L9.84611 2.56194V2.56194L9.50697 2.92935ZM8.5 5.49952V5.99952C8.77614 5.99952 9 5.77566 9 5.49952H8.5ZM9 12.6294V10.4995H8V12.6294H9ZM9.16783 12.7029C9.14707 12.7221 9.12988 12.7278 9.11634 12.7298C9.10028 12.7321 9.08029 12.73 9.05989 12.7211C9.03949 12.7121 9.02441 12.6988 9.01521 12.6855C9.00745 12.6742 9 12.6577 9 12.6294H8C8 13.5884 9.14148 14.0882 9.84611 13.4377L9.16783 12.7029ZM14.1832 8.07332L9.16783 12.7029L9.84611 13.4377L14.8615 8.80812L14.1832 8.07332ZM14.1832 7.92636C14.2261 7.96595 14.2261 8.03372 14.1832 8.07332L14.8615 8.80812C15.3334 8.37256 15.3334 7.62711 14.8615 7.19155L14.1832 7.92636ZM9.16783 3.29675L14.1832 7.92636L14.8615 7.19155L9.84611 2.56194L9.16783 3.29675ZM9 3.37023C9 3.34198 9.00745 3.32547 9.01521 3.3142C9.02441 3.30083 9.03949 3.28755 9.05989 3.27862C9.08029 3.26969 9.10028 3.26761 9.11634 3.26992C9.12988 3.27187 9.14707 3.27759 9.16783 3.29675L9.84611 2.56194C9.14148 1.91152 8 2.4113 8 3.37023H9ZM9 5.49952V3.37023H8V5.49952H9ZM3.5 5.99952H8.5V4.99952H3.5V5.99952ZM3 6.49952C3 6.22338 3.22386 5.99952 3.5 5.99952V4.99952C2.67157 4.99952 2 5.67109 2 6.49952H3ZM3 9.49952V6.49952H2V9.49952H3ZM3.5 9.99952C3.22386 9.99952 3 9.77566 3 9.49952H2C2 10.3279 2.67157 10.9995 3.5 10.9995V9.99952ZM8.5 9.99952H3.5V10.9995H8.5V9.99952Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "R_Err_Dbl_Fill": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M4 3.37024C4 2.41131 5.14148 1.91153 5.84611 2.56196L10.8615 7.19157C11.3334 7.62712 11.3334 8.37257 10.8615 8.80813L5.84611 13.4377C5.14148 14.0882 4 13.5884 4 12.6295V10.9995H2.5C1.67157 10.9995 1 10.328 1 9.49953V6.49953C1 5.6711 1.67157 4.99953 2.5 4.99953H4V3.37024ZM9.35355 2.64646C9.15829 2.4512 8.84171 2.4512 8.64645 2.64646C8.45118 2.84172 8.45118 3.1583 8.64645 3.35356L13.2222 7.9293C13.2612 7.96835 13.2612 8.03167 13.2222 8.07072L8.64645 12.6465C8.45118 12.8417 8.45118 13.1583 8.64645 13.3536C8.84171 13.5488 9.15829 13.5488 9.35355 13.3536L13.9293 8.77783C14.3589 8.34825 14.3589 7.65177 13.9293 7.22219L9.35355 2.64646Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "scroll": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M2.66659 1.375C2.1472 1.375 1.64909 1.58132 1.28183 1.94858C0.914576 2.31584 0.708252 2.81395 0.708252 3.33333V4.66667C0.708252 5.00924 0.844338 5.33778 1.08657 5.58001C1.32881 5.82225 1.65735 5.95833 1.99992 5.95833H3.37492V12.6667C3.37492 13.186 3.58124 13.6842 3.9485 14.0514C4.31576 14.4187 4.81387 14.625 5.33325 14.625H13.3333C13.8526 14.625 14.3507 14.4187 14.718 14.0514C15.0853 13.6842 15.2916 13.186 15.2916 12.6667V12C15.2916 11.6574 15.1555 11.3289 14.9133 11.0867C14.671 10.8444 14.3425 10.7083 13.9999 10.7083H13.2917V3.33333C13.2917 2.81395 13.0854 2.31584 12.7182 1.94858C12.3509 1.58132 11.8528 1.375 11.3334 1.375H2.71094C2.70556 1.375 2.70018 1.37507 2.69481 1.3752C2.68541 1.37507 2.676 1.375 2.66659 1.375ZM4.49233 2.625C4.57914 2.84876 4.62492 3.08869 4.62492 3.33333V12.6667C4.62492 12.8545 4.69955 13.0347 4.83238 13.1675C4.96522 13.3004 5.14539 13.375 5.33325 13.375C5.52111 13.375 5.70128 13.3004 5.83412 13.1675C5.96696 13.0347 6.04159 12.8545 6.04159 12.6667V12C6.04159 11.6574 6.17767 11.3289 6.41991 11.0867C6.66214 10.8444 6.99068 10.7083 7.33325 10.7083H12.0417V3.33333C12.0417 3.14547 11.9671 2.9653 11.8343 2.83247C11.7014 2.69963 11.5213 2.625 11.3334 2.625H4.49233ZM12.6667 11.9583H7.33325C7.3222 11.9583 7.3116 11.9627 7.30379 11.9705C7.29598 11.9784 7.29159 11.9889 7.29159 12V12.6667C7.29159 12.9113 7.24581 13.1512 7.15899 13.375H13.3333C13.5211 13.375 13.7013 13.3004 13.8341 13.1675C13.967 13.0347 14.0416 12.8545 14.0416 12.6667V12C14.0416 11.9889 14.0372 11.9783 14.0294 11.9705C14.0216 11.9627 14.011 11.9583 13.9999 11.9583H12.6667ZM3.37492 3.33333V4.70833H1.99992C1.98887 4.70833 1.97827 4.70394 1.97046 4.69613C1.96264 4.68832 1.95825 4.67772 1.95825 4.66667V3.33333C1.95825 3.14547 2.03288 2.9653 2.16572 2.83247C2.29856 2.69963 2.47872 2.625 2.66659 2.625C2.85445 2.625 3.03461 2.69963 3.16745 2.83247C3.30029 2.9653 3.37492 3.14547 3.37492 3.33333Z" fill="var(--svg-fill-7F848D)"/><path d="M6 6 H 11" stroke="var(--svg-stroke-6890D9)" stroke-width="1.25"/><path d="M6 9 H 11" stroke="var(--svg-stroke-6890D9)" stroke-width="1.25"/></svg>',
    "settings-1": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M1 4 H2.5 M7.5 4 H15 M1 12 H8 M13 12 H15" stroke="var(--svg-stroke-7F848D)" stroke-width="1.75" stroke-linecap="round" stroke-linejoin="round" /><circle cx="5" cy="4" r="2" stroke="var(--svg-stroke-6890D9)" stroke-width="1.25"/><circle cx="10.5" cy="12" r="2" stroke="var(--svg-stroke-6890D9)" stroke-width="1.25"/></svg>',
    "settings": '<svg width="32" height="32" viewBox="0 0 32 32" fill="none" ><g clip-path="url(#clip0_4414_20173)"><rect x="20" y="11" width="11" height="21" fill="var(--svg-fill-white)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14.9204 3.97918C16.4953 2.40422 19.6743 1.4289 22.6986 1.7617V3.27208L19.8701 6.1005L20.5772 11.0503L25.527 11.7574L28.3554 8.92896L29.8487 8.92896C30.1747 11.9696 29.1899 15.1655 27.6483 16.7071C26.0946 18.2608 23.6967 18.4129 21.2573 17.4413L9.61708 29.0815C7.66446 31.0341 4.49863 31.0341 2.54601 29.0815C0.593392 27.1289 0.593392 23.963 2.54601 22.0104L14.1712 10.3853C13.1876 7.95777 13.3304 5.56914 14.9204 3.97918ZM6.4351 26.6066C6.04458 26.9971 5.41141 26.9971 5.02089 26.6066C4.63036 26.2161 4.63036 25.5829 5.02089 25.1924C5.41141 24.8019 6.04458 24.8019 6.4351 25.1924C6.82562 25.5829 6.82562 26.2161 6.4351 26.6066Z" fill="var(--svg-fill-757575)"/><path d="M22.6986 1.7617H23.1986V1.3137L22.7533 1.2647L22.6986 1.7617ZM22.6986 3.27208L23.0521 3.62563L23.1986 3.47918V3.27208H22.6986ZM19.8701 6.1005L19.5166 5.74695L19.3398 5.92373L19.3752 6.17122L19.8701 6.1005ZM20.5772 11.0503L20.0823 11.121L20.1353 11.4922L20.5065 11.5452L20.5772 11.0503ZM25.527 11.7574L25.4563 12.2523L25.7038 12.2877L25.8805 12.1109L25.527 11.7574ZM28.3554 8.92896L28.3554 8.42896L28.1483 8.42896L28.0018 8.57541L28.3554 8.92896ZM29.8487 8.92896L30.3459 8.87566L30.298 8.42896L29.8487 8.42896L29.8487 8.92896ZM21.2573 17.4413L21.4423 16.9767L21.1365 16.8549L20.9037 17.0877L21.2573 17.4413ZM14.1712 10.3853L14.5247 10.7388L14.759 10.5046L14.6346 10.1975L14.1712 10.3853ZM22.7533 1.2647C19.6204 0.919944 16.2759 1.9166 14.5668 3.62563L15.2739 4.33274C16.7148 2.89185 19.7282 1.93785 22.6439 2.2587L22.7533 1.2647ZM23.1986 3.27208V1.7617H22.1986V3.27208H23.1986ZM20.2237 6.45406L23.0521 3.62563L22.345 2.91852L19.5166 5.74695L20.2237 6.45406ZM21.0722 10.9795L20.3651 6.02979L19.3752 6.17122L20.0823 11.121L21.0722 10.9795ZM25.5977 11.2624L20.6479 10.5553L20.5065 11.5452L25.4563 12.2523L25.5977 11.2624ZM28.0018 8.57541L25.1734 11.4038L25.8805 12.1109L28.7089 9.28252L28.0018 8.57541ZM29.8487 8.42896L28.3554 8.42896L28.3554 9.42896L29.8487 9.42896L29.8487 8.42896ZM28.0019 17.0607C28.85 16.2125 29.5156 14.9441 29.9291 13.5195C30.3442 12.0891 30.5162 10.4645 30.3459 8.87566L29.3516 8.98227C29.5072 10.434 29.3498 11.9277 28.9687 13.2408C28.5859 14.5597 27.9882 15.6601 27.2948 16.3536L28.0019 17.0607ZM21.0723 17.9058C23.6153 18.9187 26.2536 18.8089 28.0019 17.0607L27.2948 16.3536C25.9357 17.7126 23.7781 17.9071 21.4423 16.9767L21.0723 17.9058ZM9.97063 29.435L21.6109 17.7948L20.9037 17.0877L9.26353 28.7279L9.97063 29.435ZM2.19246 29.435C4.34034 31.5829 7.82275 31.5829 9.97063 29.435L9.26353 28.7279C7.50617 30.4853 4.65693 30.4853 2.89957 28.7279L2.19246 29.435ZM2.19246 21.6569C0.0445767 23.8047 0.0445764 27.2871 2.19246 29.435L2.89957 28.7279C1.14221 26.9706 1.14221 24.1213 2.89957 22.364L2.19246 21.6569ZM13.8176 10.0317L2.19246 21.6569L2.89957 22.364L14.5247 10.7388L13.8176 10.0317ZM14.5668 3.62563C12.7831 5.40936 12.6807 8.03826 13.7077 10.573L14.6346 10.1975C13.6945 7.87728 13.8778 5.72891 15.2739 4.33274L14.5668 3.62563ZM4.66733 26.9602C5.25312 27.5459 6.20287 27.5459 6.78865 26.9602L6.08155 26.253C5.88629 26.4483 5.5697 26.4483 5.37444 26.253L4.66733 26.9602ZM4.66733 24.8388C4.08155 25.4246 4.08155 26.3744 4.66733 26.9602L5.37444 26.253C5.17918 26.0578 5.17918 25.7412 5.37444 25.5459L4.66733 24.8388ZM6.78865 24.8388C6.20287 24.253 5.25312 24.253 4.66733 24.8388L5.37444 25.5459C5.5697 25.3507 5.88629 25.3507 6.08155 25.5459L6.78865 24.8388ZM6.78865 26.9602C7.37444 26.3744 7.37444 25.4246 6.78865 24.8388L6.08155 25.5459C6.27681 25.7412 6.27681 26.0578 6.08155 26.253L6.78865 26.9602Z" fill="var(--svg-fill-white)"/><rect x="16.3346" y="12.4645" width="4" height="14" rx="2" transform="rotate(45 16.3346 12.4645)" fill="var(--svg-fill-C5C5C5)"/><rect x="21.5" y="22.5" width="8" height="8" fill="var(--svg-fill-white)" stroke="var(--svg-stroke-757575)"/><path d="M23.5 25.5L26 28L30 24" stroke="var(--svg-stroke-2C2C2C)" stroke-width="1.5"/><rect x="21.5" y="12.5" width="8" height="8" fill="var(--svg-fill-white)" stroke="var(--svg-stroke-757575)"/><path d="M23.5 15.5L26 18L30 14" stroke="var(--svg-stroke-2C2C2C)" stroke-width="1.5"/></g><defs><clipPath id="clip0_4414_20173"><rect width="32" height="32" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "Show-All": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" stroke="var(--svg-stroke-31A629)"><path d="M5.5 4 H14 M5.5 8H14M5.5 12H14" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><path d="M2 4 H2.001 M2 8 H2.001 M2 12 H2.001" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "sign-out-16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M2 2H9C9.55228 2 10 2.44772 10 3V6.50355H11V3C11 1.89543 10.1046 1 9 1H2C0.895431 1 0 1.89543 0 3V13C0 14.1046 0.895431 15 2 15H9C10.1046 15 11 14.1046 11 13V9.50355H10V13C10 13.5523 9.55229 14 9 14H2C1.44772 14 1 13.5523 1 13V3C1 2.44772 1.44772 2 2 2Z" fill="var(--svg-fill-7F848D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M12.0858 4.79635C12.281 4.60109 12.5976 4.60109 12.7929 4.79635L15.6464 7.64991L16 8.00346L15.6464 8.35702L12.7929 11.2106C12.5976 11.4058 12.281 11.4058 12.0858 11.2106C11.8905 11.0153 11.8905 10.6987 12.0858 10.5035L14.0858 8.50346H5.5C5.22386 8.50346 5 8.27961 5 8.00346C5 7.72732 5.22386 7.50346 5.5 7.50346H14.0858L12.0858 5.50346C11.8905 5.30819 11.8905 4.99161 12.0858 4.79635Z" fill="var(--svg-fill-6890D9)"/></svg>',
    "speed": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><g clip-path="url(#clip0_6574_1252)"><path d="M23.5 12C23.5 9.7452 22.8494 7.63888 21.7268 5.86268L23.1155 3.64046C23.609 2.85072 23.4922 1.82486 22.8336 1.16635C22.1751 0.507848 21.1493 0.390983 20.3595 0.884506L18.1373 2.2732C16.3611 1.15059 14.2548 0.5 12 0.5C5.64873 0.5 0.5 5.64873 0.5 12C0.5 18.3513 5.64873 23.5 12 23.5C18.3513 23.5 23.5 18.3513 23.5 12Z" fill="var(--svg-fill-white)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M16.7575 3.89086C13.1553 1.77419 8.44532 2.26179 5.35346 5.35364C1.68272 9.02439 1.68272 14.9758 5.35346 18.6466C5.54872 18.8418 5.54872 19.1584 5.35346 19.3537C5.1582 19.549 4.84162 19.549 4.64635 19.3537C0.585086 15.2924 0.585086 8.70781 4.64635 4.64654C8.21785 1.07504 13.7408 0.644334 17.7829 3.35441L16.7575 3.89086ZM20.1092 7.24258C22.2259 10.8448 21.7383 15.5547 18.6464 18.6466C18.4511 18.8418 18.4511 19.1584 18.6464 19.3537C18.8417 19.549 19.1582 19.549 19.3535 19.3537C22.925 15.7822 23.3557 10.2593 20.6456 6.21711L20.1092 7.24258Z" fill="var(--svg-fill-7F848D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M14.6268 13.4502C14.1156 14.3743 13.1309 15 12 15C10.3431 15 9 13.6569 9 12C9 10.8691 9.62572 9.88441 10.5498 9.37316L21.4194 2.58057L14.6268 13.4502Z" fill="var(--svg-fill-6890D9)"/></g><defs><clipPath id="clip0_6574_1252"><rect width="24" height="24" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "spop-done16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6202_6215)"><path d="M13.9469 2.08072L12.5327 0.666504L6.51881 6.6804L3.41421 3.5758L2 4.99002L6.52548 9.5155L13.9469 2.08072Z" fill="var(--svg-fill-31A629)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M3.99996 13.6667C3.99996 14.5871 3.25377 15.3333 2.33329 15.3333C1.41282 15.3333 0.666626 14.5871 0.666626 13.6667C0.666626 12.7462 1.41282 12 2.33329 12C3.25377 12 3.99996 12.7462 3.99996 13.6667ZM9.66663 13.6667C9.66663 14.5871 8.92043 15.3333 7.99996 15.3333C7.07948 15.3333 6.33329 14.5871 6.33329 13.6667C6.33329 12.7462 7.07948 12 7.99996 12C8.92043 12 9.66663 12.7462 9.66663 13.6667ZM13.6666 15.3333C14.5871 15.3333 15.3333 14.5871 15.3333 13.6667C15.3333 12.7462 14.5871 12 13.6666 12C12.7462 12 12 12.7462 12 13.6667C12 14.5871 12.7462 15.3333 13.6666 15.3333Z" fill="var(--svg-fill-31A629)"/></g><defs><clipPath id="clip0_6202_6215"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "spop-running16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M3.99996 7.66667C3.99996 8.58714 3.25377 9.33333 2.33329 9.33333C1.41282 9.33333 0.666626 8.58714 0.666626 7.66667C0.666626 6.74619 1.41282 6 2.33329 6C3.25377 6 3.99996 6.74619 3.99996 7.66667ZM9.66663 7.66667C9.66663 8.58714 8.92043 9.33333 7.99996 9.33333C7.07948 9.33333 6.33329 8.58714 6.33329 7.66667C6.33329 6.74619 7.07948 6 7.99996 6C8.92043 6 9.66663 6.74619 9.66663 7.66667ZM13.6666 9.33333C14.5871 9.33333 15.3333 8.58714 15.3333 7.66667C15.3333 6.74619 14.5871 6 13.6666 6C12.7462 6 12 6.74619 12 7.66667C12 8.58714 12.7462 9.33333 13.6666 9.33333Z" fill="var(--svg-fill-31A629)"/></svg>',
    "stop": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M11.2304 13.2929C11.6209 13.6834 12.2541 13.6834 12.6446 13.2929L13.2929 12.6446C13.6834 12.2541 13.6834 11.6209 13.2929 11.2304L10.0626 8L13.2929 4.76966C13.6834 4.37914 13.6834 3.74597 13.2929 3.35545L12.6446 2.70714C12.2541 2.31661 11.6209 2.31661 11.2304 2.70714L8.00003 5.93747L4.76966 2.70711C4.37914 2.31658 3.74597 2.31658 3.35545 2.70711L2.70713 3.35542C2.31661 3.74595 2.31661 4.37911 2.70713 4.76964L5.9375 8L2.70711 11.2304C2.31658 11.6209 2.31658 12.2541 2.70711 12.6446L3.35542 13.2929C3.74595 13.6834 4.37911 13.6834 4.76964 13.2929L8.00003 10.0625L11.2304 13.2929Z" fill="var(--svg-fill-F0483F)"/></svg>',
    "stop16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><g clip-path="url(#clip0_6202_6212)"><circle cx="8" cy="8" r="8" fill="var(--svg-fill-F0483F)"/><rect x="5" y="5" width="6" height="6" fill="var(--svg-fill-white)"/></g><defs><clipPath id="clip0_6202_6212"><rect width="16" height="16" fill="var(--svg-fill-white)"/></clipPath></defs></svg>',
    "success": '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" ><path d="M10 18C14.4183 18 18 14.4183 18 10C18 5.58172 14.4183 2 10 2C5.58172 2 2 5.58172 2 10C2 14.4183 5.58172 18 10 18Z" fill="var(--svg-fill-31A629)"/><path d="M6 10L9 13L14 8" stroke="var(--svg-stroke-white)" stroke-width="1.25" stroke-linecap="round"/></svg>',
    "Summary": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="5" y="2" width="6" height="2" fill="var(--svg-fill-7F848D)"/><rect x="6.5" y="0.5" width="3" height="3" rx="1.5" stroke="var(--svg-stroke-7F848D)"/><path fill-rule="evenodd" clip-rule="evenodd" d="M4 3H3C2.44772 3 2 3.44772 2 4V15C2 15.5523 2.44772 16 3 16H13C13.5523 16 14 15.5523 14 15V4C14 3.44772 13.5523 3 13 3H12V4H13V15H3L3 4H4V3Z" fill="var(--svg-fill-7F848D)"/><rect x="5" y="6" width="6" height="1" fill="var(--svg-fill-7F848D)"/><rect x="5" y="9" width="6" height="1" fill="var(--svg-fill-7F848D)"/><rect x="5" y="12" width="6" height="1" fill="var(--svg-fill-7F848D)"/></svg>',
    "synced16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M1 8 L5 12 L11 3 M8.5 11.5 L9 12 L15 3" stroke="var(--svg-stroke-31A629)" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/><circle cx="4.5" cy="8" r="1" fill="var(--svg-fill-31A629)"/></svg>',
    "syncing16": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M4.1993 4.1993C5.20703 3.19157 6.57371 2.62531 7.99882 2.625C9.51276 2.631 10.9659 3.2212 12.0552 4.27242L12.4911 4.70833H10.6667C10.3216 4.70833 10.0417 4.98816 10.0417 5.33333C10.0417 5.67851 10.3216 5.95833 10.6667 5.95833H14H14.0001C14.1031 5.95833 14.2003 5.93342 14.2859 5.88928C14.3131 5.8753 14.3395 5.85918 14.3648 5.84095C14.5224 5.72748 14.6251 5.5424 14.6251 5.33333V2C14.6251 1.65482 14.3453 1.375 14.0001 1.375C13.6549 1.375 13.3751 1.65482 13.3751 2V3.82453L12.9353 3.38472L12.9353 3.38466L12.9277 3.37731C11.6058 2.09936 9.841 1.38192 8.00235 1.375V1.375H8C6.24294 1.375 4.55785 2.07299 3.31542 3.31542C2.07299 4.55785 1.375 6.24294 1.375 8C1.375 8.34518 1.65482 8.625 2 8.625C2.34518 8.625 2.625 8.34518 2.625 8C2.625 6.57446 3.19129 5.20731 4.1993 4.1993ZM14 7.375C14.3452 7.375 14.625 7.65482 14.625 8C14.625 9.75706 13.927 11.4422 12.6846 12.6846C11.4422 13.927 9.75706 14.625 8 14.625H7.99765C6.159 14.6181 4.3942 13.9006 3.07226 12.6227L3.06466 12.6153L3.06473 12.6153L2.625 12.1756V13.9998C2.625 14.345 2.34518 14.6248 2 14.6248C1.65482 14.6248 1.375 14.345 1.375 13.9998V10.6667V10.6665C1.375 10.3213 1.65482 10.0415 2 10.0415H5.33333C5.67851 10.0415 5.95833 10.3213 5.95833 10.6665C5.95833 11.0117 5.67851 11.2915 5.33333 11.2915H3.50872L3.94477 11.7276C5.03408 12.7788 6.48718 13.369 8.00109 13.375C9.42624 13.3747 10.7929 12.8084 11.8007 11.8007C12.8087 10.7927 13.375 9.42554 13.375 8C13.375 7.65482 13.6548 7.375 14 7.375Z" fill="var(--svg-fill-31A629)"/></svg>',
    "two_tree": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><rect x="1" y="1" width="22" height="22" rx="2" ry="2" stroke="var(--svg-stroke-7F848D)" stroke-width="1" /><path d="M12 2 V22" stroke="var(--svg-stroke-7F848D)" stroke-width="1"/><path d="M4 4.5  h5 M4 9.5  h5 M4 14.5 h5 M4 19.5 h5 M15 4.5  h5 M15 9.5  h5 M15 14.5 h5 " stroke="var(--svg-stroke-6890D9)" stroke-width="2.5"  stroke-linecap="round" stroke-linejoin="round"/></svg>',
    "unknown-os": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><rect x="2" width="12" height="16" rx="2" fill="var(--svg-fill-3F3F40)"/><rect x="2" width="12" height="16" rx="2" fill="url(#paint0_linear_6219_116)"/><rect x="2" width="12" height="16" rx="2" fill="var(--svg-fill-white)" fill-opacity="0.3"/><rect x="2" width="12" height="16" rx="2" fill="var(--svg-fill-505050)"/><rect x="6" y="2" width="7" height="2" fill="var(--svg-fill-white)"/><rect x="6" y="6" width="7" height="2" fill="var(--svg-fill-white)"/><rect x="3" y="2" width="2" height="2" fill="var(--svg-fill-white)"/><rect x="3" y="6" width="2" height="2" fill="var(--svg-fill-white)"/><rect x="7" y="10" width="2" height="1" fill="var(--svg-fill-white)"/><rect x="7" y="12" width="2" height="2" fill="var(--svg-fill-white)"/><defs><linearGradient id="paint0_linear_6219_116" x1="2" y1="5.25" x2="14" y2="5.25" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-131313)"/><stop offset="0.182292" stop-color="var(--svg-stop-color-333335)"/><stop offset="0.875" stop-color="var(--svg-stop-color-3D3D3F)"/><stop offset="0.9375" stop-color="var(--svg-stop-color-737375)"/><stop offset="1" stop-color="var(--svg-stop-color-323234)"/></linearGradient></defs></svg>',
    "unknown_folder": '<svg width="64" height="64" viewBox="0 0 64 64" fill="none" ><path d="M54.4 16H32L23.6 8H9.6C6.52 8 4 11 4 14.6667V40H60V22.6667C60 19 57.48 16 54.4 16Z" fill="var(--svg-fill-AAAFB8)"/><path d="M54.4 20H32L28 24H9.6C6.52 24 4 26.5714 4 29.7143V50.2857C4 53.4286 6.52 56 9.6 56H54.4C57.48 56 60 53.4286 60 50.2857V25.7143C60 22.5714 57.48 20 54.4 20Z" fill="url(#paint0_linear_6462_1104)"/><path opacity="0.5" fill-rule="evenodd" clip-rule="evenodd" d="M4 49.2856V50.2858C4 53.4287 6.52 56.0001 9.6 56.0001H54.4C57.48 56.0001 60 53.4287 60 50.2858V49.2856C60 52.4285 57.48 54.9999 54.4 54.9999H9.6C6.52 54.9999 4 52.4285 4 49.2856Z" fill="var(--svg-fill-7F848D)"/><path d="M29.8672 41.0273L29.8555 40.3477C29.7383 38.6836 30.3477 37.6172 31.9648 36.668C33.4766 35.7656 33.9336 35.1797 33.9336 34.0898V34.0781C33.9336 32.9531 33.0312 32.1562 31.707 32.1562C30.3594 32.1562 29.4805 33.0352 29.4102 34.2422L29.3984 34.3359H26.2227V34.2188C26.3164 31.4648 28.3203 29.4375 31.918 29.4375C35.2578 29.4375 37.4844 31.2891 37.4844 33.9727V33.9844C37.4844 35.7422 36.6289 36.9727 34.9766 37.9453C33.418 38.8477 32.9844 39.4336 32.9844 40.5469V41.0273H29.8672ZM31.4727 46.6406C30.418 46.6406 29.5625 45.832 29.5625 44.8008C29.5625 43.7695 30.418 42.9609 31.4727 42.9609C32.5391 42.9609 33.3945 43.7695 33.3945 44.8008C33.3945 45.832 32.5391 46.6406 31.4727 46.6406Z" fill="var(--svg-fill-7F848D)"/><defs><linearGradient id="paint0_linear_6462_1104" x1="32" y1="20" x2="32" y2="56" gradientUnits="userSpaceOnUse"><stop stop-color="var(--svg-stop-color-E5E7EE)"/><stop offset="1" stop-color="var(--svg-stop-color-AAAFB8)"/></linearGradient></defs></svg>',
    "upload": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M2 10V13C2 14.1046 2.89543 15 4 15H12C13.1046 15 14 14.1046 14 13V10" stroke="var(--svg-stroke-7F848D)" stroke-linecap="round"/><rect x="7" y="4" width="2" height="8" rx="1" fill="var(--svg-fill-32A5FF)"/><path d="M4 7L8 3L12 7" stroke="var(--svg-stroke-32A5FF)" stroke-width="2" stroke-linecap="round"/></svg>',
    "view-medium": '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M12 4C19.5 4 23 12 23 12C23 12 18.5 20 12 20C5.5 20 1 12 1 12C1 12 4.5 4 12 4ZM2.4862 11.9349C2.56784 11.7838 2.66636 11.6083 2.78187 11.4137C3.19495 10.718 3.81697 9.79305 4.65078 8.87297C6.32734 7.02299 8.75435 5.3 12 5.3C15.2457 5.3 17.6727 7.02299 19.3492 8.87297C20.183 9.79305 20.8051 10.718 21.2181 11.4137C21.3336 11.6083 21.4322 11.7838 21.5138 11.9349C21.408 12.0981 21.2795 12.2908 21.1293 12.506C20.634 13.2156 19.9119 14.158 19.0038 15.0955C17.1472 17.012 14.717 18.7 12 18.7C9.28299 18.7 6.85282 17.012 4.99621 15.0955C4.08807 14.158 3.36599 13.2156 2.87073 12.506C2.72053 12.2908 2.59198 12.0981 2.4862 11.9349ZM12 16C14.2091 16 16 14.2091 16 12C16 9.79086 14.2091 8 12 8C9.79086 8 8 9.79086 8 12C8 14.2091 9.79086 16 12 16Z" fill="var(--svg-fill-black)" fill-opacity="0.54"/></svg>',
    "Views": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M3.01556 5L8 2.15175L12.9844 5L8 7.84825L3.01556 5ZM8 1L13.9922 4.42412L15 5L13.9922 5.57588L12.375 6.5L13.9922 7.42412L15 8L13.9922 8.57588L12.375 9.5L13.9922 10.4241L15 11L13.9922 11.5759L8 15L2.00778 11.5759L1 11L2.00778 10.4241L3.625 9.5L2.00778 8.57588L1 8L2.00778 7.42412L3.625 6.5L2.00778 5.57588L1 5L2.00778 4.42412L8 1ZM4.63278 7.07588L3.01556 8L8 10.8482L12.9844 8L11.3672 7.07588L8 9L4.63278 7.07588ZM3.01556 11L4.63278 10.0759L8 12L11.3672 10.0759L12.9844 11L8 13.8482L3.01556 11Z" fill="var(--svg-fill-7F848D)"/></svg>',
    "views_green": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path fill-rule="evenodd" clip-rule="evenodd" d="M3.01556 5L8 2.15175L12.9844 5L8 7.84825L3.01556 5ZM8 1L13.9922 4.42412L15 5L13.9922 5.57588L12.375 6.5L13.9922 7.42412L15 8L13.9922 8.57588L12.375 9.5L13.9922 10.4241L15 11L13.9922 11.5759L8 15L2.00778 11.5759L1 11L2.00778 10.4241L3.625 9.5L2.00778 8.57588L1 8L2.00778 7.42412L3.625 6.5L2.00778 5.57588L1 5L2.00778 4.42412L8 1ZM4.63278 7.07588L3.01556 8L8 10.8482L12.9844 8L11.3672 7.07588L8 9L4.63278 7.07588ZM3.01556 11L4.63278 10.0759L8 12L11.3672 10.0759L12.9844 11L8 13.8482L3.01556 11Z" fill="var(--svg-fill-31A629)"/></svg>',
    "warning": '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" ><path d="M1.69951 18C0.93703 18 0.455062 17.1809 0.825357 16.5144L9.12584 1.57348C9.50685 0.887674 10.4932 0.887674 10.8742 1.57348L19.1746 16.5144C19.5449 17.1809 19.063 18 18.3005 18L1.69951 18Z" fill="var(--svg-fill-FFDC5B)" stroke="var(--svg-stroke-7F848D)" stroke-width="1"/><path d="M10 7 V12" stroke="var(--svg-stroke-7F848D)" stroke-width="1.75" stroke-linecap="round" stroke-linejoin="round"/><circle cx="10" cy="15" r="1" fill="var(--svg-fill-7F848D)"/></svg>',
    "windows": '<svg width="16" height="16" viewBox="0 0 16 16" fill="none" ><path d="M0 0H7.58391V7.58368H0V0Z" fill="var(--svg-fill-0078D4)"/><path d="M8.41609 0H16V7.58368H8.41609V0Z" fill="var(--svg-fill-0078D4)"/><path d="M7.58391 8.41632H0V16H7.58391V8.41632Z" fill="var(--svg-fill-0078D4)"/><path d="M8.41602 8.41632H15.9999V16H8.41602V8.41632Z" fill="var(--svg-fill-0078D4)"/></svg>',
};
