"use strict";
let bAutoShowDropMenu = false;
let oLastButton = null;
function UpAnDownKeyProc(e) {
}
function SetMainMenu(dom, js, bDontClear) {
    if (!bDontClear)
        dom.innerHTML = "";
    for (let i = 0; i < js.length; i++) {
        let btn = document.createElement('button');
        btn.className = "img_btn_bar nonselect";
        btn.innerHTML = GetLocaleText(js[i].title);
        let drop_menu = js[i].cont;
        btn.addEventListener('click', function (e) {
            if (!drop_menu)
                return;
            e.stopPropagation();
            e.preventDefault();
            ShowDropMenu(this, drop_menu, js[i].title);
            return false;
        });
        btn.addEventListener('mouseenter', function () {
            if (!bAutoShowDropMenu || !drop_menu)
                return;
            ShowDropMenu(this, drop_menu, js[i].title);
        });
        dom.append(btn);
    }
}
function ShowDropMenu(button, jsMenuItems, sTitle) {
    DeleteAllDropMenu();
    bAutoShowDropMenu = true;
    button.className = "hi_menu_sel";
    if (oLastButton)
        oLastButton.className = "img_btn_bar nonselect";
    oLastButton = button;
    const rect = button.getBoundingClientRect();
    if (sTitle && sTitle == "Menu_Job") {
        JobContextMenu(jsMenuItems, rect.left, rect.bottom + document.documentElement.scrollTop, rect.right, button);
    }
    else {
        CreateDropMenuItems(jsMenuItems, rect.left, rect.bottom + document.documentElement.scrollTop, rect.right, button);
    }
}
function CreateDropMenu(jsMenuItems, x, y, x1, el, oParams) {
    CreateDropMenuItems(jsMenuItems, x, y, x1, el, oParams.bAsButton, oParams.xAddArgs, oParams.fOnClose, oParams.class);
}
function CreateDropMenuItems(jsMenuItems, x, y, x1, el, bAsButton, xAddArgs, fOnClose, sClass) {
    if (!jsMenuItems)
        return;
    const zInd = GetZIndex(el) + 2;
    let domDropMenuPanel = document.createElement('div');
    domDropMenuPanel.className = "drop_menu";
    domDropMenuPanel.style.zIndex = "" + zInd;
    domDropMenuPanel.el = el;
    if (fOnClose) {
        domDropMenuPanel.fOnClose = function () {
            fOnClose(domDropMenuPanel);
        };
    }
    domDropMenuPanel.fRemoveSubmenu = function () {
        if (domDropMenuPanel.submenu) {
            if (domDropMenuPanel.submenu.fRemoveSubmenu) {
                domDropMenuPanel.submenu.fRemoveSubmenu();
            }
            domDropMenuPanel.submenu.remove();
            domDropMenuPanel.submenu = null;
        }
    };
    domDropMenuPanel.prevActive = true;
    domDropMenuPanel.bAsButton = bAsButton;
    aDropMenus.push(domDropMenuPanel);
    const table = document.createElement('table');
    if (sClass) {
        table.className = sClass;
    }
    for (let i = 0; i < jsMenuItems.length; i++) {
        const iMenuItem = jsMenuItems[i];
        if (iMenuItem.disable && eval(iMenuItem.disable)) {
            continue;
        }
        let row = table.insertRow(-1);
        row.style.position = "relative";
        let bNotActive = iMenuItem.noactive;
        if ("active_cond" in iMenuItem && iMenuItem.active_cond != "") {
            bNotActive = !(eval(iMenuItem.active_cond));
        }
        row.className = "drpmn_row" + (bNotActive ? " drp_non_active_item" : "") + (bAsButton ? " drp_menu_btn" : "");
        if (iMenuItem.hint) {
            row.title = GetLocaleText(iMenuItem.hint);
        }
        let cell = row.insertCell(-1);
        if (iMenuItem.separator) {
            cell.colSpan = 4;
            cell.innerHTML = "<hr style = 'width: 90%; height: 0px; border-color: #dddddd'>";
            row.addEventListener('mouseenter', function () {
                SetStyleSelectItem(domDropMenuPanel, null);
            });
            continue;
        }
        else if (iMenuItem.note) {
            cell.colSpan = 4;
            cell.innerText = iMenuItem.title;
            cell.style.color = "#888888";
            row.addEventListener('mouseenter', function () {
                SetStyleSelectItem(domDropMenuPanel, null);
            });
            cell.className = "drpmn_col1";
            continue;
        }
        cell.className = "drpmn_col1";
        row.classList.add("real_item");
        if (iMenuItem.img) {
            cell.style.verticalAlign = "middle";
            let sImg = iMenuItem.img;
            if (sImg.includes("?")) {
                sImg = eval(sImg);
            }
            let img = SetImg(sImg, "var(--drop-menu-img)");
            if (img) {
                img.classList.add("img_drop_menu");
                cell.append(img);
                if (bNotActive) {
                    img.classList.add("dead_img");
                }
            }
        }
        else if (iMenuItem.checkbox) {
            const checked = eval(iMenuItem.checkbox);
            let img = undefined;
            if (checked) {
                img = SetImg("checkbox-true", "var(--drop-menu-img)");
            }
            else {
                img = SetImg("checkbox-false", "var(--drop-menu-img)");
            }
            if (img) {
                img.classList.add("img_drop_menu");
                cell.append(img);
            }
        }
        cell = row.insertCell(-1);
        cell.className = "drpmn_col2";
        let aArgs = [];
        if (iMenuItem.text_args) {
            for (let item of iMenuItem.text_args) {
                aArgs.push(GetArg(item, xAddArgs));
            }
        }
        let sTitle = iMenuItem.title;
        if (sTitle.includes("GetLocaleText")) {
            sTitle = eval(iMenuItem.title);
            cell.innerHTML = sTitle;
        }
        else {
            cell.innerHTML = GetLocaleText(iMenuItem.title, aArgs);
        }
        let j = 0;
        if (iMenuItem.data) {
            const sData = "<span class='img_btn_data' id='" + ((iMenuItem.id) ? iMenuItem.id + "_data" : (j++) + "_data") + "'></span>";
            let pos = -1;
            if (iMenuItem.data.before) {
                pos = cell.innerHTML.indexOf(iMenuItem.data.before);
            }
            else if (iMenuItem.data.after) {
                pos = cell.innerHTML.indexOf(iMenuItem.data.after);
                if (pos >= 0) {
                    pos += iMenuItem.data.after.length;
                }
            }
            else if (iMenuItem.data.instad) {
                pos = cell.innerHTML.indexOf(iMenuItem.data.instad);
                cell.innerHTML = cell.innerHTML.replace(iMenuItem.data.instad, "");
            }
            if (pos < 0) {
                cell.innerHTML += sData;
            }
            else {
                cell.innerHTML = cell.innerHTML.substring(0, pos) + sData + cell.innerHTML.substring(pos);
            }
        }
        cell = row.insertCell(-1);
        cell.className = "drpmn_col3";
        if (iMenuItem.hot_keys_)
            cell.innerText = iMenuItem.hot_keys_;
        cell = row.insertCell(-1);
        cell.className = "drpmn_col4";
        if (!iMenuItem.submenu) {
            row.addEventListener('mouseenter', function () {
                SetStyleSelectItem(domDropMenuPanel, this);
            });
        }
        else {
            const img = SetImg("chevron-right", "1rem", true);
            if (img) {
                cell.style.position = 'relative';
                cell.style.paddingRight = '0.5rem';
                cell.append(img);
            }
            else {
                cell.innerHTML += " &#10095;";
            }
        }
        if (!bNotActive) {
            if (iMenuItem.checkbox) {
                row.onclick = function () {
                    eval(iMenuItem.checkbox + " = !" + iMenuItem.checkbox);
                    if (iMenuItem.localStorage) {
                        const obj = eval(iMenuItem.localStorage);
                        localStorage.setItem(iMenuItem.localStorage, JSON.stringify(obj));
                    }
                };
                row.fKeyDown = function (e) {
                    if (e.code == "Enter") {
                        eval(iMenuItem.checkbox + " = !" + iMenuItem.checkbox);
                    }
                    else if (e.code == "ArrowUp" || e.code == "ArrowDown") {
                        e.stopPropagation();
                    }
                };
            }
            else if (iMenuItem.command) {
                let text = iMenuItem.title;
                let hot_keys = iMenuItem.hot_keys_;
                row.onclick = function () {
                    eval(iMenuItem.command);
                };
                row.fKeyDown = function (e) {
                    if (e.code == "Enter") {
                        eval(iMenuItem.command);
                        DeleteAllDropMenu();
                        e.preventDefault();
                    }
                };
            }
            else if (iMenuItem.submenu) {
                row.onclick = function (e) {
                    e.stopPropagation();
                    e.preventDefault();
                };
                row.addEventListener('mouseenter', function () {
                    SetStyleSelectItem(domDropMenuPanel, this);
                    let rect = row.getBoundingClientRect();
                    const tmp = CreateDropMenuItems(iMenuItem.submenu, rect.right - 5, rect.top + document.documentElement.scrollTop, rect.left + 5, el, bAsButton, xAddArgs);
                    if (tmp) {
                        domDropMenuPanel.submenu = tmp;
                    }
                });
                row.fKeyDown = function (e) {
                    if (e.code == "Enter") {
                        let rect = row.getBoundingClientRect();
                        const tmp = CreateDropMenuItems(iMenuItem.submenu, rect.right + 5, rect.top + document.documentElement.scrollTop, rect.left, el, bAsButton, xAddArgs);
                        if (tmp) {
                            domDropMenuPanel.submenu = tmp;
                        }
                        e.preventDefault();
                    }
                };
            }
        }
    }
    if (table.children.length === 0) {
        return null;
    }
    domDropMenuPanel.append(table);
    document.body.append(domDropMenuPanel);
    if (x < 0) {
        x = 0;
    }
    else if (x + domDropMenuPanel.clientWidth >= document.documentElement.clientWidth) {
        x = x1 - domDropMenuPanel.clientWidth;
    }
    domDropMenuPanel.style.left = x + "px";
    if (y + domDropMenuPanel.clientHeight >= document.documentElement.clientHeight) {
        y = document.documentElement.clientHeight - domDropMenuPanel.clientHeight - 5;
    }
    domDropMenuPanel.style.top = y + "px";
    domDropMenuPanel.fKeyDown = (e) => {
        if (domDropMenuPanel.nItem === undefined) {
            DeleteAllDropMenu();
            e.preventDefault();
            return;
        }
        const aDropMenu = domDropMenuPanel.children[0].children[0].children;
        if (domDropMenuPanel.nItem >= 0 && domDropMenuPanel.nItem < aDropMenu.length
            && IsActiveItem(aDropMenu[domDropMenuPanel.nItem])
            && 'fKeyDown' in aDropMenu[domDropMenuPanel.nItem]) {
            aDropMenu[domDropMenuPanel.nItem].fKeyDown(e);
            return;
        }
        DeleteAllDropMenu();
        e.preventDefault();
    };
    domDropMenuPanel.fUpAndDown = (e) => {
        const aDropMenu = domDropMenuPanel.children[0].children[0].children;
        if (e.code == "ArrowDown") {
            let i = 0;
            if (domDropMenuPanel.nItem !== undefined) {
                i = domDropMenuPanel.nItem + 1;
            }
            while (i < aDropMenu.length) {
                if (IsActiveItem(aDropMenu[i]))
                    break;
                i++;
            }
            if (i >= aDropMenu.length)
                return;
            domDropMenuPanel.nItem = i;
            SetStyleSelectItem(domDropMenuPanel, domDropMenuPanel.children[0].children[0].children[i]);
        }
        else {
            let i = aDropMenu.length - 1;
            if (domDropMenuPanel.nItem !== undefined) {
                i = domDropMenuPanel.nItem - 1;
            }
            while (i >= 0) {
                if (IsActiveItem(aDropMenu[i]))
                    break;
                i--;
            }
            if (i < 0)
                return;
            domDropMenuPanel.nItem = i;
            SetStyleSelectItem(domDropMenuPanel, domDropMenuPanel.children[0].children[0].children[i]);
        }
    };
    return domDropMenuPanel;
}
function IsActiveItem(el) {
    return !el.classList.contains("drp_non_active_item") && el.classList.contains("real_item");
}
function GetArg(xAct, xAddArgs) {
    return eval(xAct + "(xAddArgs)");
}
function SetStyleSelectItem(domDropMenuPanel, t) {
    if (t) {
        t.classList.add("drp_selected_item");
    }
    if (domDropMenuPanel.prevRow) {
        domDropMenuPanel.prevRow.classList.remove("drp_selected_item");
    }
    domDropMenuPanel.prevRow = t;
    if (domDropMenuPanel.submenu) {
        domDropMenuPanel.submenu.fRemoveSubmenu();
        domDropMenuPanel.submenu.remove();
    }
}
function DeleteDropMenuDuringScroll() {
    let dmArr = document.getElementsByClassName("drop_menu");
    for (let i = dmArr.length - 1; i >= 0; i--) {
        const domDM = dmArr[i];
        if (domDM.el) {
            const rect1 = domDM.getBoundingClientRect();
            const rect2 = domDM.el.getBoundingClientRect();
            if (MaxDistance(rect1, rect2, 5)) {
                dmArr[i].remove();
            }
        }
    }
}
function DeleteAllDropMenu() {
    DeleteAllClassEl("drop_menu");
    aDropMenus.splice(0);
}
