"use strict";
const jsPictTable = {
    "fs_zip_dark": "/web-ui/svg/fs_zip_dark.svg",
    "fs_azure": "/web-ui/svg/fs_azure.svg",
    "fs_backblaze": "/web-ui/svg/fs_backblaze.svg",
    "fs_boxcom": "/web-ui/svg/fs_boxcom.svg",
    "fs_dav": "/web-ui/svg/fs_dav.svg",
    "fs_dropbox": "/web-ui/svg/fs_dropbox.svg",
    "fs_encr": "/web-ui/svg/fs_encr.svg",
    "fs_encr_dark": "/web-ui/svg/fs_encr_dark.svg",
    "fs_encr_touchbar": "/web-ui/svg/fs_encr_touchbar.svg",
    "fs_ftp": "/web-ui/svg/fs_ftp.svg",
    "fs_gcloud": "/web-ui/svg/fs_gcloud.svg",
    "fs_gdrive3": "/web-ui/svg/fs_gdrive3.svg",
    "fs_gphotos": "/web-ui/svg/fs_gphotos.svg",
    "fs_gstp": "/web-ui/svg/fs_gstp.svg",
    "fs_gteamdrive": "/web-ui/svg/fs_gteamdrive.svg",
    "fs_icloud": "/web-ui/svg/fs_icloud.svg",
    "fs_iphotos": "/web-ui/svg/fs_iphotos.svg",
    "fs_mega": "/web-ui/svg/fs_mega.svg",
    "fs_msgraph": "/web-ui/svg/fs_msgraph.svg",
    "fs_mtp": "/web-ui/svg/fs_mtp.svg",
    "fs_onefile": "/web-ui/svg/fs_onefile.svg",
    "fs_pcloud": "/web-ui/svg/fs_pcloud.svg",
    "fs_remote": "/web-ui/svg/fs_remote.svg",
    "fs_s3": "/web-ui/svg/fs_s3.svg",
    "fs_sftp": "/web-ui/svg/fs_sftp.svg",
    "fs_sibafp": "/web-ui/svg/fs_sibafp.svg",
    "fs_smbd": "/web-ui/svg/fs_smbd.svg",
    "fs_wdnas": "/web-ui/svg/fs_wdnas.svg",
    "fs_winfilesys": "/web-ui/svg/fs_winfilesys.svg",
    "fs_winnet": "/web-ui/svg/fs_winnet.svg",
    "fs_zip": "/web-ui/svg/fs_zip.svg",
    "job_syncing_red_blue": "/web-ui/svg/job_syncing_red_blue.svg",
    "job_syncing_red_blue_star": "/web-ui/svg/job_syncing_red_blue_star.svg",
    "new-job": "/web-ui/svg/new-job.svg",
    "new-group": "/web-ui/svg/new-group.svg",
    "job_stopped": "/web-ui/svg/job_stopped.svg",
    "job_paused": "/web-ui/svg/job_paused.svg",
    "old_auto": "/web-ui/svg/old_auto.svg",
    "old_auto_on": "/web-ui/svg/old_auto_on.svg",
    "old_analyze": "/web-ui/svg/old_analyze.svg",
    "General-v2": "/web-ui/svg/General-v2.svg",
    "options": "/web-ui/svg/options.svg",
    "shared_by_me": "/web-ui/svg/shared_by_me.svg",
    "logs": "/web-ui/svg/Journals.svg",
    "mail": "/web-ui/svg/mail.svg",
};
const jsLeftImgMenu = [
    { title: "Btn_CreateNewJob", img: "new_job", command: "CreateNewJob()" },
    { title: "Btn_CreateNewGroup", img: "new_group", command: "CreateNewGroup()" },
    { title: "Btn_AccountSync_On", img: "account-sync-on", command: "AccountSyncAuto(false)", group: "account_sync_on" },
    { title: "Btn_AccountSync_Off", img: "account-sync-off", command: "AccountSyncAuto(true)", group: "account_sync_off" },
    { title: "Cmd_EnableAuto", img: "auto-run-on", command: "SetCommonAutoRun(true)", group: "common_auto_on" },
    { title: "Cmd_SuspendAuto", img: "auto-run-off", command: "SetCommonAutoRun(false)", group: "common_auto_off" },
];
const jsGroupImgMenu = [
    { title: "Btn_Analyze", img: "analyze", command: "StartGroupButton(this, JOB_COMMAND_ANALIZE)" },
    { title: "Btn_SyncRun", img: "job_syncing_red_blue", command: "StartGroupButton(this, JOB_COMMAND_SYNC)" },
];
const jsRightLeftImgMenu = [
    { title: "Btn_Analyze", img: "analyze", group: "btn_sync_and_analize btn_analize", command: "StartJobBigButton(this, JOB_COMMAND_ANALIZE)" },
    { title: "Btn_SyncRun", img: "job_syncing_red_blue", group: "btn_sync_and_analize btn_sync", command: "StartJobBigButton(this, JOB_COMMAND_SYNC)" },
    { title: "Btn_Stop", img: "job_stopped", group: "btn_stop_job", command: "StopJob()" },
];
const jsRightRightImgMenu = [
    { title: "Btn_ShowJobOptions", img: "settings", group: "settings_btn", command: "GetAndShowJobOptions()" },
    { title: "Btn_Auto", img: "auto-off", group: "settings_btn auto_off", command: "GetAndShowJobOptions('Title_Auto')" },
    { title: "Btn_Auto", img: "auto-on", group: "settings_btn auto_on", command: "GetAndShowJobOptions('Title_Auto')" },
];
const jsConflictResolveImgMenu = [
    { title: "Str_LeftSideWins", img: "R_Ena_Arr_Fill", command: "ConflictResolve(SpOp_ResolveConflicts_LeftToRight)" },
    { title: "Str_RightSideWins", img: "L_Ena_Arr_Fil", command: "ConflictResolve(SpOp_ResolveConflicts_RightToLeft)" },
    { title: "Str_NewerFileWins", img: "newer_file_wins", command: "ConflictResolve(SpOp_ResolveConflicts_NewerWins)" },
];
const aLanguages = GetLangArray();
const jsFloatMenu = {
    "JobOptions": { title: "Str_Options", "vert_win": true, "help_url": "https://www.goodsync.com/manual#general_job_options",
        "bottom_box": [
            { title: "Save", close: true, command: "upload", default: true },
            { title: "Cancel", close: true }
        ],
        cont: [
            { title: "Title_JobGeneral", "icon": "settings", "help_url": "https://www.goodsync.com/manual#general_job_options", cont: [
                    { type: "option_group", title: "Options_job_type", cont: [
                            { type: "droplist", title: "Label_JobType", value: "eJobDirection", "list": ["Str_JobType_TwoWay", "Str_JobType_LeftToRight", "Str_JobType_RightToLeft"], id: "jobDir" },
                            { type: "checkbox", title: "Chk_DelPropagate", value: "bPropagateDels", control: { disable: "ID#[jobDir] == 0" } },
                            { type: "checkbox", title: "Chk_CreateNewFolder", value: "bCreateFolderIfNotFound" },
                        ] },
                    { type: "option_group", title: "Str_Advanced", cont: [
                            { type: "checkbox", title: "Chk_Fast1WayNoState", value: "bFastNoState1way", id: "Fast1WayNoState", confirm: "Fast1WayNoStateConfirm('Ask_Fast1WayDelete', checked)",
                                control: { disable: "ID#[jobDir] == 0", reset: "ID#[jobDir] == 0" }
                            },
                            { type: "checkbox", title: "Chk_IgnoreChangesOnDestSide", value: "bIgnoreChangesOnDestSide",
                                control: { disable: "ID#[jobDir] == 0 || ID#[Fast1WayNoState]", reset: "ID#[jobDir] == 0 || ID#[Fast1WayNoState]" }
                            },
                            { type: "checkbox", title: "Radio_OneWayDeleteSource", value: "bMoveMode_DeleteSourceAfterCopy", id: "OneWayDeleteSource",
                                control: { disable: "ID#[jobDir] == 0", reset: "ID#[jobDir] == 0" }
                            },
                            { type: "checkbox", title: "Check_DeleteEmptyFolders", value: "bMoveMode_DeleteEmptyFolders",
                                control: { hide: "!ID#[OneWayDeleteSource]", reset: "!ID#[OneWayDeleteSource]" }
                            },
                        ] },
                    { type: "option_group", title: "Str_Snapshots", cont: [
                            { type: "checkbox", title: "Chk_CopyLocked", value: "bCopyLockedFiles" },
                            { type: "checkbox", title: "Chk_SnapshotBeforeSync", value: "bSnapshotBeforeSync" },
                        ] },
                ] },
            { title: "Title_Filters", "icon": "filter", "help_url": "https://www.goodsync.com/manual#filters", cont: [
                    { type: "text", title: "Str_FiltersChooseFiles", },
                    { type: "row", cont: [
                            { type: "text", title: "Str_FilterIncludedFull", class: "flex_1_1" },
                            { type: "button", img: "copy", command: "ExternCopyAll('Included')+", onDown: true, hint: "Hint_CopyAllOrSelected" },
                            { type: "button", img: "paste", command: "ExternPaste('Included')+", onDown: true, hint: "Hint_PasteRowsToTable" },
                            { type: "button", img: "plus-add-line", command: "ExternAddDinTableRow('Included')+" },
                            { type: "button", img: "minus-add-line", command: "ExternDelDinTableRow('Included')+", onDown: true },
                        ] },
                    { type: "mtable", "id": "Included", value: "Filter.Included", "h": 120, editable: true, el_class: "cell_low_border" },
                    { type: "row", "h": "10px", cont: [] },
                    { type: "row", cont: [
                            { type: "text", title: "Str_FilterExcludedFull", class: "flex_1_1" },
                            { type: "button", img: "copy", command: "ExternCopyAll('Excluded')+", onDown: true, hint: "Hint_CopyAllOrSelected" },
                            { type: "button", img: "paste", command: "ExternPaste('Excluded')+", onDown: true, hint: "Hint_PasteRowsToTable" },
                            { type: "button", img: "plus-add-line", command: "ExternAddDinTableRow('Excluded')+" },
                            { type: "button", img: "minus-add-line", command: "ExternDelDinTableRow('Excluded')+", onDown: true },
                        ] },
                    { type: "mtable", "id": "Excluded", value: "Filter.Excluded", "h": 120, editable: true, el_class: "cell_low_border" },
                    { type: "row", "h": "10px", cont: [] },
                    { type: "checkbox", title: "Chk_ExcludeEmptyFolders", value: "Filter.bExcludeEmptyFolders" },
                    { type: "checkbox", title: "Chk_ExcludeHidden", value: "Filter.bExcludeHidden" },
                    { type: "checkbox", title: "Chk_ExcludeSystem", value: "Filter.bExcludeSystem" },
                    { type: "checkbox", title: "Chk_ExcludeTemp", value: "Filter.bExcludeTemp" },
                ] },
            { title: "Title_Auto", "icon": "clock", "help_url": "https://www.goodsync.com/manual#auto_job_options", cont: [
                    { type: "option_group", title: "JobAutoAnalAndSync", cont: [
                            { type: "row", title: "Dsbl_DoOnFoldersConnect", cont: [
                                    { type: "checkbox", title: "Chk_DoOnFileChange", value: "atOnFileChange", id: "DoOnFileChange" },
                                    { type: "space", w: "100%" },
                                    { type: "text", title: "Str_Delay" },
                                    { type: "numberfield", value: "nOnFileChangeDelay", "min": 0 },
                                    { type: "text", title: "Str_Sec", w: "20px" }
                                ] },
                            { type: "checkbox", title: "Chk_DoOnFoldersConnect", value: "atOnFolderConnect",
                                control: { disable: "ID#[DoOnFileChange]", reset: "ID#[DoOnFileChange]" }
                            },
                            { type: "row", cont: [
                                    { type: "checkbox", title: "Chk_DoOnGsStart", value: "atOnStart",
                                        control: { disable: "ID#[DoOnFileChange]", reset: "ID#[DoOnFileChange]" }
                                    },
                                    { type: "space", w: "100%" },
                                    { type: "text", title: "Str_Delay" },
                                    { type: "numberfield", value: "nAutoStartDelay", "min": 0 },
                                    { type: "text", title: "Str_Sec", w: "20px" }
                                ] },
                            { type: "row", cont: [
                                    { title: "Chk_DoPeriodically", type: "checkbox", value: "atOnTimer", hint: "Help_DoPeriodically1" },
                                    { type: "space", w: "100%" },
                                    { type: "numberfield", value: "iEveryHour", "size": 10, "min": 0, id: "hours", valid: "PeriodValidate('hours')+" },
                                    { title: "Str_Hour", type: "text" },
                                    { type: "space", w: "5px" },
                                    { type: "numberfield", value: "iEveryMinute", "size": 2, "min": -1, "max": 60, id: "minutes", valid: "PeriodValidate('minutes')+" },
                                    { title: "Str_Min", type: "text", w: "20px" }
                                ] },
                            { type: "checkbox", title: "Chk_DoBeforeLogout", value: "atOnLogout" },
                            { type: "row", "h": "5px", cont: [] },
                            { type: "row", cont: [
                                    { title: "Str_DoOnSchedule", type: "checkbox", value: "atOnSchedule" },
                                    { type: "space", w: "100%" },
                                    { type: "button", title: "Str_SchedConfig", command: "OpenSchedulSets()" }
                                ] },
                        ] },
                    { title: "AdvancedAuto", type: "option_group", cont: [
                            { type: "row", cont: [
                                    { title: "Str_LimitChanges", type: "checkbox", value: "bLimitChanges" },
                                    { type: "space", w: "100%" },
                                    { type: "numberfield", value: "iLimitChanges", "min": 0, "max": 32767 },
                                    { title: "%", type: "text", w: "20px" }
                                ] },
                            { type: "row", cont: [
                                    { title: "Chk_WaitForLocks", type: "checkbox", value: "bWaitForLocks" },
                                    { type: "space", w: "100%" },
                                    { type: "numberfield", value: "nWaitForLocksMinutes", "min": 0, "max": 32767 }
                                ] },
                            { title: "Str_AutoClear", type: "checkbox", value: "bAutoClear" },
                        ] },
                ] },
            { title: "Str_ColumnAnalyze", "icon": "analyze", "help_url": "https://www.goodsync.com/manual#analyze_job_options", cont: [
                    { type: "option_group", title: "LinksOption", cont: [
                            { type: "radio", value: "eLinksOpt", id: "idLinksOption",
                                list: ["Radio_Ignore", "Radio_CopyAsIs", "Radio_DrillDown"],
                                helps: ["Help_Links_Ignore", "Help_Links_CopyAsIs", "Help_Links_DrillDown"] },
                        ] },
                    { type: "option_group", title: "Str_ColumnAnalyze", cont: [
                            { type: "checkbox", title: "Chk_DetectsMovesRenames", value: "bDetectMovesAndRenames" },
                            { type: "checkbox", title: "Chk_UseRecursiveList", value: "bUseRecursiveListDir" },
                            { type: "checkbox", title: "Chk_CalcReqSpace", value: "bEstimateReqSpace" },
                            { type: "checkbox", title: "Chk_CompareCheckSumAll", value: "bCompareAllUsingCheckSums" },
                        ] },
                ] },
            { title: "Str_ColumnSync", "icon": "job_syncing_red_blue", "help_url": "https://www.goodsync.com/manual#sync_job_options", cont: [
                    { type: "option_group", title: "Str_FileDetails", cont: [
                            { type: "checkbox", title: "Chk_CopyCreateTime", value: "bCopyCreateTime" },
                            { type: "checkbox", title: "Chk_CopyAttrs", value: "bCopyAttrs" },
                            { type: "checkbox", title: "Copy Extended Attributes", value: "bCopyExtendedAttrs" },
                            { type: "checkbox", title: "Chk_CopyOwner", value: "bCopyOwner" },
                            { type: "checkbox", title: "Chk_CopyACL", value: "bCopyExtendedAttrs" },
                        ] },
                    { type: "option_group", title: "Str_ChangedAgain", cont: [
                            { type: "checkbox", title: "Chk_DoNotSyncChangedFiles", value: "DoNotSyncChangedFiles" },
                            { type: "numberfield", title: "Str_WaitSyncAfterAnalyzeSec", value: "WaitSyncAfterAnalyzeSec" },
                        ], },
                    { type: "option_group", title: "Str_Advanced", cont: [
                            { type: "checkbox", title: "Chk_UberUnlockedUploads", value: "bUberUnlockedRead" },
                            { type: "checkbox", title: "Str_ShutdownOnFinish", value: "bShutdownAfterRun" },
                        ] },
                ] },
            { title: "Str_Recycled_History", "icon": "delete", "help_url": "https://www.goodsync.com/manual#history_job_options", cont: [
                    { type: "option_group", title: "Str_Recycled_History", cont: [
                            { type: "checkbox", title: "Chk_SaveBakFiles", value: "bRecycleTo_RecycleBin", id: "SaveBakFiles",
                                control: { disable: "ID#[Fast1WayNoState]", reset: "ID#[SavePastVersions]" }
                            },
                            { type: "row", cont: [
                                    { type: "space", w: "20px" },
                                    { type: "checkbox", title: "Chk_CleanupBakFiles", value: "bCleanup_RecycleBin" },
                                    { type: "space", w: "100%" },
                                    { type: "numberfield", value: "nSaveDays_RecycleBin", "min": 0 }
                                ] },
                            { type: "checkbox", title: "Chk_SavePastVersions", value: "bRecycleTo_History", id: "SavePastVersions",
                                control: { disable: "ID#[Fast1WayNoState]", reset: "ID#[SaveBakFiles]" }
                            },
                            { type: "row", cont: [
                                    { type: "space", w: "20px" },
                                    { type: "checkbox", title: "Chk_CleanupPastVersions", value: "bCleanup_History" },
                                    { type: "space", w: "100%" },
                                    { type: "numberfield", value: "nSaveDays_History", "min": 0 }
                                ] },
                        ] },
                ] },
            { title: "SpeedLimit", "icon": "speed", "help_url": "https://www.goodsync.com/manual#speed_and_limits_job_options", cont: [
                    { type: "option_group", title: "Str_limits", cont: [
                            { type: "row", cont: [
                                    { title: "Str_WorkerThreads", type: "checkbox", value: "bRunParallelThreads" },
                                    { type: "space", w: "100%" },
                                    { type: "numberfield", value: "nWorkerThreads", "min": 0 }
                                ] },
                            { type: "numberfield", title: "Str_ReconnectSeconds", value: "nReconnectSeconds", "min": 0 },
                            { title: "Str_SpeedLimit", type: "numberfield", value: "nXferSpeedLimit", "min": 0 },
                            { type: "row", cont: [
                                    { title: "Str_MaxRunTime", type: "checkbox", value: "bLimitRunTime" },
                                    { type: "space", w: "100%" },
                                    { type: "numberfield", value: "nMaxTimeToRun", "min": 0, "max": 32767 }
                                ] },
                        ] },
                ] },
            { title: "Cmd_ShowConflict", "icon": "warning", "help_url": "https://www.goodsync.com/manual#errors_conflicts_job_options", cont: [
                    { type: "option_group", title: "Str_Notifications", cont: [
                            { type: "droplist", title: "Str_ShowBalloon", value: "eShowBalloon", "list": ["Str_DoNotShowBalloon", "Str_ShowBalloonAlways", "Str_ShowBalloonOnError"]
                            },
                        ] },
                    { type: "option_group", title: "Str_Conflict_Resolution", cont: [
                            { type: "checkbox", title: "Str_ResolveWeakConflicts", value: "bResolveWeakConflicts" },
                            { type: "droplist", title: "Str_ResolveConflictsStrong", value: "eAutoResolveConflicts",
                                "list": ["Str_DoNotCopy", "Str_LeftSideWins", "Str_RightSideWins", "Str_NewerFileWins", "Str_StopSync"]
                            },
                            { type: "checkbox", title: "Str_RenameLosingFile", value: "bRenamesLosingFile" },
                        ] },
                ] },
            { title: "Title_Script", "icon": "scroll", "help_url": "https://www.goodsync.com/manual#scripts_job_options", cont: [
                    { type: "option_group", title: "Str_CallingProgramEmail", cont: [
                            { type: "textfield", title: "Str_PreAnalyze_Action", value: "sPreAnalyzeProgram", title_width_group: "1" },
                            { type: "textfield", title: "Str_PostAnalyze_Action", value: "sPostAnalyzeEmailOrProgram", title_width_group: "1" },
                            { type: "textfield", title: "Str_PostSync_Action", value: "sPostSyncEmailOrProgram", title_width_group: "1" },
                            { type: "text", title: "Str_ScriptOptLegend", lineHeight: "1.5" },
                            { type: "row", "h": "10px", cont: [] },
                            { type: "text", title: "Str_Variables", lineHeight: "1.5" },
                            { type: "row", "h": "5px", cont: [] },
                            { type: "text", title: "Str_VarOptLegend", lineHeight: "1.5" },
                        ] },
                ] },
            { title: "Title_JobLeftSide", "icon": "folder-left", "help_url": "https://www.goodsync.com/manual#left_right_side_job_options", cont: [
                    { type: "option_group", title: "Str_Side_Analyze", cont: [
                            { type: "checkbox", title: "Chk_CompareCheckSumSide", value: "side_opts[0].bCompareCheckSums" },
                            { type: "checkbox", title: "Chk_CompareAttrs", value: "side_opts[0].bCompareAttrs" },
                            { type: "checkbox", title: "Compare Extended Attributes", value: "side_opts[0].bCompareExtendedAttrs" },
                            { type: "checkbox", title: "Chk_CompareOwner", value: "side_opts[0].bCompareOwner" },
                            { type: "checkbox", title: "Chk_CompareACL", value: "side_opts[0].bCompareACL" },
                        ] },
                    { type: "option_group", title: "Str_Side_Exotic", cont: [
                            { type: "checkbox", title: "Chk_UseSafeCopy", value: "side_opts[0].bUseTmpDestFile" },
                        ] },
                    { type: "option_group", title: "Explorer_FolderOptions", cont: [
                            { type: "row", cont: [
                                    { type: "text", title: "Str_FolderOptionsCommand", w: "100%", w_s: "normal" },
                                    { type: "button", title: "Btn_FolderOptions", command: "FolderOptionsRequest(0)" }
                                ] },
                        ] },
                ] },
            { title: "Title_JobRightSide", "icon": "folder-right", "help_url": "https://www.goodsync.com/manual#left_right_side_job_options", cont: [
                    { type: "option_group", title: "Str_Side_Analyze", cont: [
                            { type: "checkbox", title: "Chk_CompareCheckSumSide", value: "side_opts[1].bCompareCheckSums" },
                            { type: "checkbox", title: "Chk_CompareAttrs", value: "side_opts[1].bCompareAttrs" },
                            { type: "checkbox", title: "Compare Extended Attributes", value: "side_opts[1].bCompareExtendedAttrs" },
                            { type: "checkbox", title: "Chk_CompareOwner", value: "side_opts[1].bCompareOwner" },
                            { type: "checkbox", title: "Chk_CompareACL", value: "side_opts[1].bCompareACL" },
                        ] },
                    { type: "option_group", title: "Str_Side_Exotic", cont: [
                            { type: "checkbox", title: "Chk_UseSafeCopy", value: "side_opts[1].bUseTmpDestFile" },
                        ] },
                    { type: "option_group", title: "Explorer_FolderOptions", cont: [
                            { type: "row", cont: [
                                    { type: "text", title: "Str_FolderOptionsCommand", w: "100%", w_s: "normal" },
                                    { type: "button", title: "Btn_FolderOptions", command: "FolderOptionsRequest(1)" }
                                ] },
                        ] },
                ] },
        ]
    },
    "ScheduleOptions": { title: "Str_ScheduleFor",
        "bottom_box": [
            { title: "Test", nofinal: true, command: "ScheduleTest", id: "test_btn" },
            { title: "", space: true },
            { title: "OK", close: true, command: "save", default: true, id: "save_btn" },
            { title: "Cancel", close: true },
        ], cont: [
            { title: "", cont: [
                    { type: "text", title: "Str_Schedule_Line1" },
                    { type: "row", cont: [
                            { type: "text", title: "Str_Schedule_Minute", title_width_group: "80", class: "fltmn_short_text" },
                            { type: "textfield", "size": 5, get: "GetSchedule", put: "PutSchedule", value: "rMinute", id: "Minute",
                                valid: "ScheduleTextValidate(el.value, {min:0,max:59},'Minute')+"
                            },
                            { type: "text", title: "(0 .. 59)", title_width_group: "85", class: "fltmn_short_text" },
                        ] },
                    { type: "row", cont: [
                            { type: "text", title: "Str_Schedule_Hour", title_width_group: "80", class: "fltmn_short_text" },
                            { type: "textfield", "size": 5, get: "GetSchedule", put: "PutSchedule", value: "rHour", id: "Hour",
                                valid: "ScheduleTextValidate(el.value, {min:0,max:23}, 'Hour')+"
                            },
                            { type: "text", title: "(0 .. 23)", title_width_group: "85", class: "fltmn_short_text" },
                        ] },
                    { type: "row", cont: [
                            { type: "text", title: "Str_Schedule_DOW", title_width_group: "80", class: "fltmn_short_text" },
                            { type: "textfield", "size": 5, get: "GetSchedule", put: "PutSchedule", value: "rDayOfWeek", id: "DayOfWeek",
                                valid: "ScheduleTextValidate(el.value, {min:0,max:6}, 'DayOfWeek')+"
                            },
                            { type: "text", title: "Str_WeekDaysForSchedule", title_width_group: "85", class: "fltmn_short_text" },
                        ] },
                    { type: "row", cont: [
                            { type: "text", title: "Str_Schedule_DOM", title_width_group: "80", class: "fltmn_short_text" },
                            { type: "textfield", "size": 5, get: "GetSchedule", put: "PutSchedule", value: "rDayOfMonth", id: "DayOfMonth",
                                valid: "ScheduleTextValidate(el.value, {min:1,max:31}, 'DayOfMonth')+"
                            },
                            { type: "text", title: "(1 .. 31)", title_width_group: "85", class: "fltmn_short_text" },
                        ] },
                    { type: "row", cont: [
                            { type: "text", title: "Str_Schedule_Month", title_width_group: "80", class: "fltmn_short_text" },
                            { type: "textfield", "size": 5, get: "GetSchedule", put: "PutSchedule", value: "rMonth", id: "Month",
                                valid: "ScheduleTextValidate(el.value, {min:1,max:12}, 'Month')+"
                            },
                            { type: "text", title: "(1 .. 12)", title_width_group: "85", class: "fltmn_short_text" },
                        ] },
                    { type: "text", title: "Str_Schedule_Explain" },
                    { type: "row", "h": "5px", cont: [] },
                ] }
        ]
    },
    "ChoosingLogLevels": { title: "Str_LocalSettingsWebUI",
        "bottom_box": [
            { title: "OK", close: true, command: "save and exec", "default": true },
            { title: "Cancel", close: true },
        ], cont: [
            { title: "", cont: [
                    { type: "checkbox", title: "Str_LogCritical", value: "bShowLogCritical" },
                    { type: "checkbox", title: "Str_LogError", value: "bShowLogError" },
                    { type: "checkbox", title: "Str_LogInfo", value: "bShowLogInfo" },
                    { type: "checkbox", title: "Str_LogDetails", value: "bShowLogDetails" },
                    { type: "numberfield", title: "Str_NumberLogStringsInLogWindow", value: "nNumberLogStringsInLogWindow", "min": 100, "max": 10000 },
                ] }
        ]
    },
    "BrowseDialog": { title: "Str_BrowseDialog",
        "bottom_box": [
            { title: "Btn_Select", close: true, command: "save", "default": true, id: "Btn_Select" },
            { title: "Btn_Cancel", close: true },
        ], cont: [
            { title: "", cont: [
                    { type: "textfield", value: "sUrlForChange", el_class: "url_for_change", id: "UrlForChange", put: "SeatchPathInBrowseDialog" },
                    { type: "place", title: "", id: "resume" },
                    { type: "table", title: "", dynTable: "oDTP", h: "100%", class: "browse_dialog_table" },
                ] }
        ]
    },
    "ExploreDialog": { title: "WebGS Explorer", "bottom_box": [], cont: [{ title: "", cont: [
                    { type: "row", cont: [
                            { type: "button", img: "one_tree", title: "Explorer_1Tree", class: "img_btn_gor_wo_border chb_btn_gor_sel", command: "SwitchExplorerTo1Tree(oMenu)", id: "btnExplorer_1Tree" },
                            { type: "button", img: "two_tree", title: "Explorer_2Trees", class: "img_btn_gor_wo_border chb_btn_gor_sel", command: "SwitchExplorerTo2Tree(oMenu)", id: "btnExplorer_2Tree" },
                        ] },
                    { type: "row", class: "flex_1_1_100 overflow_y_auto flex_gor", cont: [
                            { type: "column", id: "first_tree", cont: [
                                    { type: "textfield", value: "sUrlForChange", id: "UrlForChange", el_class: "url_for_explore", put: "SeatchPathInBrowseDialog" },
                                    { type: "table", title: "", dynTable: "oDTP", h: "100%", class: "browse_dialog_table" },
                                ] },
                            { type: "column", id: "second_tree", cont: [
                                    { type: "textfield", value: "sUrl2", id: "Url2", el_class: "url_for_explore", put: "SeatchPathInBrowseDialog" },
                                    { type: "table", title: "", dynTable: "oDTP2", h: "100%", class: "browse_dialog_table" },
                                ] },
                        ] },
                ] }] },
    "MsExplore": { title: "WebGS Explorer", "bottom_box": [], cont: [{ title: "", cont: [
                    { type: "row", cont: [
                            { type: "button", img: "one_tree", title: "Explorer_1Tree", class: "img_btn_gor_wo_border chb_btn_gor_sel", command: "SwitchExplorerTo1Tree(oMenu)", id: "btnExplorer_1Tree" },
                            { type: "button", img: "two_tree", title: "Explorer_2Trees", class: "img_btn_gor_wo_border chb_btn_gor_sel", command: "SwitchExplorerTo2Tree(oMenu)", id: "btnExplorer_2Tree" },
                            { type: "space", w: "100%" },
                            { type: "button", img: "checkbox-true", title: "Btn_ExplorerAsWin", class: "img_btn_gor_wo_border ExplorerAsWinEn chb_btn_gor_sel", command: "ChangeExplorerMode(oMenu)" },
                            { type: "button", img: "checkbox-false", title: "Btn_ExplorerAsWin", class: "img_btn_gor_wo_border ExplorerAsWinDis chb_btn_gor_sel", command: "ChangeExplorerMode(oMenu)" },
                        ] },
                    { type: "row", class: "flex_1_1_100 overflow_y_auto flex_gor", cont: [
                            { type: "column", id: "first_tree", cont: [
                                    { type: "textfield", value: "sUrlForChange", id: "UrlForChange", el_class: "url_for_explore", put: "SeatchPathInBrowseDialog" },
                                    { type: "row", class: "flex_1_1_100 overflow_y_auto flex_gor", cont: [
                                            { type: "table", title: "", dynTable: "oDTP", h: "100%", w: "40%", class: "browse_dialog_table stretch_x" },
                                            { type: "table", title: "", id: "FolderContTable", dynTable: "oFolderContTable", h: "100%", class: "browse_dialog_table folder_cont_place" },
                                        ] },
                                ] },
                            { type: "column", id: "second_tree", cont: [
                                    { type: "textfield", value: "sUrl2", id: "Url2", el_class: "url_for_explore", put: "SeatchPathInBrowseDialog" },
                                    { type: "table", title: "", dynTable: "oDTP2", h: "100%", class: "browse_dialog_table" },
                                ] },
                        ] },
                ] }] },
    "ChoiceFileDialog": { title: "WebGS Explorer", "bottom_box": [
            { title: "Btn_Select", close: true, command: "save", "default": true, id: "Btn_Select" },
            { title: "Btn_Cancel", close: true },
        ], cont: [{ title: "", cont: [
                    { type: "textfield", value: "sUrlForChange", id: "UrlForChange", el_class: "url_for_explore", put: "SeatchPathInBrowseDialog" },
                    { type: "table", title: "", dynTable: "oDTP", h: "100%", class: "browse_dialog_table" },
                ] }] },
    "ChoosingJobDirection": { title: "Str_BrowseDialog",
        "bottom_box": [
            { title: "Btn_Select", close: true, command: "save and exec", "default": true },
            { title: "Btn_Cancel", close: true },
        ], cont: [
            { title: "", cont: [
                    { type: "radio", value: "eJobDirection", listImg: [{ text: "Str_JobType_TwoWay", img: "arrow-left-right" },
                            { text: "Str_JobType_LeftToRight", img: "move-right" },
                            { text: "Str_JobType_RightToLeft", img: "move-left" }] },
                ] }
        ]
    },
    "RenameJobDialog": { title: "Title_RenameJob",
        "bottom_box": [
            { title: "OK", close: true, command: "create", "default": true, },
            { title: "Cancel", close: true },
        ], cont: [
            { title: "", cont: [
                    { type: "row", "h": "5px", cont: [] },
                    { type: "textfield", title: "Str_JobName", value: "sNewJobName" },
                ] }
        ]
    },
    "FolderOptions": { title: "Btn_FolderOptions", bottom_box: [
            { title: "Save", close: true, command: "save", id: "save_btn", default: true },
            { title: "Cancel", close: true, }
        ], cont: [
            { title: "", cont: [
                    { type: "option_group", title: "Str_Side_Encryption", cont: [
                            { type: "droplist", title: "Str_Side_Settings_Title", lineHeight: "2", value: "nCompressType", id: "side_enc",
                                "list": ["Str_Side_Settings_Mode_NotUse", "Chk_Encrypt_FileAll", "Str_Side_Settings_Mode_CompEncr"]
                            },
                            { type: "droplist", title: "Str_Side_Cipher_Title", value: "nCipherType", id: "enc_method",
                                "list": ["Str_Side_Cipher_NotUse", "ZipCrypto", "AES-256"], control: { hide: "ID#[side_enc] !== 2" }
                            },
                            { type: "column", title: "EncMetod", control: { hide: "ID#[side_enc] === 0 || ID#[side_enc] === 2 && ID#[enc_method] === 0" }, cont: [
                                    { type: "password", title: "Chk_Encrypt_Password", value: "sRawPasswd", title_width: "200px", id: "psw1", same: { id: "psw2", disable: ["save_btn"] } },
                                    { type: "password", title: "Chk_Encrypt_Password2", value: "sRepPasswd", title_width: "200px", id: "psw2", same: { id: "psw1", disable: ["save_btn"] } },
                                ] },
                            { type: "checkbox", title: "Chk_Encrypt_FilePaths", value: "bEncryptPaths", noControl: true, control: { hide: "ID#[side_enc] !== 2 || ID#[enc_method] === 0" } },
                            { type: "row", "h": "0.5rem", cont: [] },
                            { type: "row", control: { hide: "ID#[side_enc] === 0" }, cont: [
                                    { type: "button", title: "Btn_Encrypt_Test", command: "BtnEncryptTest(jsFloatMenuDescr, oMenu)", control: { disable: "(ID#[side_enc] !== 2 || ID#[enc_method] === 0) && ID#[side_enc] !== 1" } },
                                    { type: "button", title: "Btn_Encrypt_EmptyFolder", command: "RemoveFolderCont(oMenu)" },
                                ] },
                            { type: "row", "h": "0.5rem", cont: [] },
                        ] },
                    { type: "checkbox", title: "Chk_NoGsData_Side", value: "bNoGsData", },
                ] }
        ]
    },
    "BookmarkZipOptions": { title: "Title_SetCompressEncryptParam", bottom_box: [
            { title: "Save", close: true, command: "save", id: "save_btn", default: true },
            { title: "Cancel", close: true, }
        ], cont: [
            { title: "", cont: [
                    { type: "droplist", title: "Str_Side_Cipher_Title", value: "nCipherType", id: "enc_method", "list": ["Str_Side_Cipher_NotUse", "ZipCrypto", "AES-256"] },
                    { type: "password", title: "Chk_Encrypt_Password", value: "sRawPasswd", control: { disable: "ID#[enc_method] === 0" } },
                    { type: "checkbox", title: "Chk_Encrypt_FilePaths", value: "bEncryptPaths", noControl: true, control: { disable: "ID#[enc_method] === 0" } },
                    { type: "row", "h": "0.5rem", cont: [] },
                    { type: "button", title: "Btn_Encrypt_Test", command: "BtnEncryptTest(jsFloatMenuDescr, oMenu, true)", control: { disable: "ID#[enc_method] === 0" } },
                ] }
        ]
    },
    "BookmarkEncOptions": { title: "Title_SetEncryptParam", bottom_box: [
            { title: "Save", close: true, command: "save", id: "save_btn", default: true },
            { title: "Cancel", close: true, }
        ], cont: [
            { title: "", cont: [
                    { type: "password", title: "Chk_Encrypt_Password", value: "sRawPasswd" },
                    { type: "row", "h": "0.5rem", cont: [] },
                    { type: "button", title: "Btn_Encrypt_Test", command: "BtnEncryptTest(jsFloatMenuDescr, oMenu, true)" },
                ] }
        ]
    },
    "CodeFor2FA": { title: "Title_CodeFor2FA", bottom_box: [
            { title: "Btn_Send", close: true, command: "save", default: true },
            { title: "Btn_Cancel", close: true, }
        ], cont: [
            { title: "", cont: [
                    { type: "textfield", title: "", value: "sPrompt", readOnly: true },
                    { type: "textfield", title: "", value: "s2FACode", },
                ] }
        ]
    },
    "ProgramOptions": { title: "Program Options - GoodSync", "vert_win": true, "help_url": "https://www.goodsync.com/manual#program-general-tab",
        "bottom_box": [
            { title: "Btn_Save", "close": true, command: "save and upload", "default": true },
            { title: "Btn_Cancel", "close": true }
        ],
        cont: [
            { title: "Title_General", "icon": "settings", "help_url": "https://www.goodsync.com/manual#program-general-tab", cont: [
                    { type: "option_group", title: "Str_UserInterface", cont: [
                            { type: "droplist", title: "Str_Lang", str: true, value: "webGuiOptions.sLanguage", list: aLanguages },
                            { type: "droplist", title: "Str_TreeDisplayDensity", value: "webGuiOptions.eTreeDisplayDensity", list: ["Low", "Medium", "High"] },
                            { type: "checkbox", title: "Chk_ShowSystemGroups", value: "webGuiOptions.bShowBackupSyncGroups" },
                        ] },
                    { title: "Str_Miscellaneous", type: "option_group", cont: [
                            { type: "checkbox", title: "Chk_Warn_TimeOutOfRange", value: "CProgramOptionsGlobal.m_bWarn_TimeOutOfRange" },
                            { type: "text", title: "Str_CompareProg" },
                            { type: "row", cont: [
                                    { type: "textfield", title: "", value: "CProgramOptionsLocalOnly.sCompareProgram", id: "compare_program_url" },
                                    { type: "button", title: "Browse", command: "SetCompareProgram(oMenu, 'compare_program_url')" }
                                ] },
                            { type: "text", title: "Str_MirrorFolder" },
                            { type: "row", cont: [
                                    { type: "textfield", title: "", value: "CProgramOptionsLocalOnly.sMirrorFolderPath", id: "mirror_folder_url" },
                                    { type: "button", title: "Browse", command: "SetCompareProgram(oMenu, 'mirror_folder_url')" }
                                ] }
                        ] },
                ] },
            { title: "Title_Account", "icon": "account-16", "help_url": "https://www.goodsync.com/manual#program-general-tab", cont: [
                    { title: "Title_Account", type: "option_group", class: "line_height_medium", cont: [
                            { type: "textfield", title: "Str_UserName", value: "JobServerUserInformation.display_name", readOnly: true, title_width_group: "1" },
                            { type: "textfield", title: "Str_EMail", value: "JobServerUserInformation.email", readOnly: true, title_width_group: "1" },
                            { type: "textfield", title: "Str_UserID", value: "JobServerUserInformation.id", readOnly: true, title_width_group: "1" },
                        ] },
                ] },
            { title: "Title_Auto", "icon": "clock", "help_url": "https://www.goodsync.com/manual#program-auto-tab", cont: [
                    { title: "Title_Auto", type: "option_group", cont: [
                            { type: "numberfield", title: "Str_ParallelAutoJobs", value: "CProgramOptionsGlobal.m_nParallelAutoJobs", "min": 0, "max": 100 },
                            { type: "numberfield", title: "Str_AutoJobsQuant", value: "CProgramOptionsGlobal.m_nAutoJobQuantSec", "min": 0, "max": 100 },
                        ] },
                    { title: "Str_FileHistory", type: "option_group", cont: [
                            { type: "numberfield", title: "Chk_CleanupOldGens", value: "CProgramOptionsGlobal.m_nSaveMonths_OldGens", "min": 0, "max": 100 },
                        ] },
                ] },
            { title: "Title_SMTP", "icon": "mail-1", "help_url": "https://www.goodsync.com/manual#program-smtp-tab", cont: [
                    { title: "Str_SMTP_Settings", type: "option_group", cont: [
                            { type: "checkbox", title: "Str_SMTP_Enable", value: "CProgramOptionsGlobal.m_bUseSmtpToEmail", id: "SMTP_Enable" },
                            { type: "text", title: "Str_SMTP_AuthMethod" },
                            { type: "radio", value: "CProgramOptionsGlobal.m_SmtpServer.m_OAuthProvider", id: "id_auth_metod",
                                list: ["Str_SMTP_Auth_Basic", "Gmail (OAuth2)", "Outlook(OAuth2)"] },
                            { type: "column", class: "el_with_help", cont: [
                                    { type: "text", title: "Str_SMTP_Host", class: "text_above_field", control: { disable: "!ID#[SMTP_Enable]" } },
                                    { type: "row", cont: [
                                            { type: "textfield", title: "", value: "CProgramOptionsGlobal.m_SmtpServer.m_sHostA", control: { disable: "!ID#[SMTP_Enable]" }, },
                                            { type: "numberfield", title: "Port", value: "CProgramOptionsGlobal.m_SmtpServer.m_nPort", min: 0, max: 65535, w: "100px", control: { disable: "!ID#[SMTP_Enable]" } },
                                        ] },
                                    { type: "text", title: "Str_SMTP_UserID", class: "text_above_field", control: { disable: "!ID#[SMTP_Enable]" } },
                                    { type: "textfield", title: "", value: "CProgramOptionsGlobal.m_SmtpServer.m_sUserIdA", control: { disable: "!ID#[SMTP_Enable]" }, },
                                    { type: "text", title: "Str_SMTP_Passwd", class: "text_above_field", control: { disable: "!ID#[SMTP_Enable]" } },
                                    { type: "password", title: "", value: "sPassword", control: { disable: "!ID#[SMTP_Enable]" }, },
                                    { type: "text", title: "Str_SMTP_SenderEmail", class: "text_above_field", control: { disable: "!ID#[SMTP_Enable]" } },
                                    { type: "textfield", title: "", value: "CProgramOptionsGlobal.m_SmtpServer.m_sSenderStrA", control: { disable: "!ID#[SMTP_Enable]" }, },
                                    { type: "checkbox", title: "Str_SMTP_StartTls", id: "SMTP_StartTls", value: "CProgramOptionsGlobal.m_SmtpServer.m_bStartTls", control: { disable: "!ID#[SMTP_Enable]", reset: "ID#[SMTP_Secure]" } },
                                    { type: "checkbox", title: "Str_SMTP_Secure", id: "SMTP_Secure", value: "CProgramOptionsGlobal.m_SmtpServer.m_bSSL", control: { disable: "!ID#[SMTP_Enable]", reset: "ID#[SMTP_StartTls]" } },
                                ], control: { hide: "ID#[id_auth_metod] !== 0" } },
                            { type: "column", class: "el_with_help", cont: [
                                    { type: "row", h: "0.5rem" },
                                    { type: "textfield", title: "Signed in as: ", value: "CProgramOptionsGlobal.m_SmtpServer.m_sOAuthUserIdA",
                                        el_class: "bold_text", id: "user_id", readOnly: true, control: { disable: "!ID#[SMTP_Enable]" },
                                    },
                                    { type: "textfield", title: "Your E-mail address", value: "CProgramOptionsGlobal.m_SmtpServer.m_sOAuthEmail",
                                        id: "e_mail", control: { disable: "!ID#[SMTP_Enable]" },
                                    },
                                    { type: "button", img: "google-logo", title: "Sign in with Google", command: "SmtpOAuth('gmail://')++",
                                        control: { disable: "!ID#[SMTP_Enable]", hide: "ID#[id_auth_metod] !== 1" }
                                    },
                                    { type: "button", img: "microsoft", title: "Sign in with Microsoft", command: "SmtpOAuth('outlook://')++",
                                        control: { disable: "!ID#[SMTP_Enable]", hide: "ID#[id_auth_metod] === 1" }
                                    },
                                    { type: "button", title: "Sign out", command: "", control: { disable: "!ID#[SMTP_Enable]" } }
                                ], control: { hide: "ID#[id_auth_metod] === 0" } },
                            { type: "row", cont: [
                                    { type: "space", class: "flex_1_1" },
                                    { type: "button", title: "Cmd_Test", command: "SmtpTest(oMenu)", control: { disable: "!ID#[SMTP_Enable]" } }
                                ] }
                        ] },
                ] },
            { title: "Title_Filters", "icon": "filter", "help_url": "https://www.goodsync.com/manual#program-filters-tab", cont: [
                    { type: "text", title: "Str_FiltersChooseFiles", class: "big_text" },
                    { type: "row", cont: [
                            { type: "text", title: "Str_FilterIncludedFull", class: "flex_1_1" },
                            { type: "button", img: "copy", command: "ExternCopyAll('ProgOpIncluded')+", onDown: true, hint: "Hint_CopyAllOrSelected" },
                            { type: "button", img: "paste", command: "ExternPaste('ProgOpIncluded')+", onDown: true, hint: "Hint_PasteRowsToTable" },
                            { type: "button", img: "plus-add-line", command: "ExternAddDinTableRow('ProgOpIncluded')+" },
                            { type: "button", img: "minus-add-line", command: "ExternDelDinTableRow('ProgOpIncluded')+", onDown: true },
                        ] },
                    { type: "mtable", "id": "ProgOpIncluded", value: "CProgramOptionsGlobal.m_GlobFilter.Included", "h": 150, editable: true, el_class: "cell_low_border" },
                    { type: "row", "h": "10px", cont: [] },
                    { type: "row", cont: [
                            { type: "text", title: "Str_FilterExcludedFull", class: "flex_1_1" },
                            { type: "button", img: "copy", command: "ExternCopyAll('ProgOpExcluded')+", onDown: true, hint: "Hint_CopyAllOrSelected" },
                            { type: "button", img: "paste", command: "ExternPaste('ProgOpExcluded')+", onDown: true, hint: "Hint_PasteRowsToTable" },
                            { type: "button", img: "plus-add-line", command: "ExternAddDinTableRow('ProgOpExcluded')+" },
                            { type: "button", img: "minus-add-line", command: "ExternDelDinTableRow('ProgOpExcluded')+", onDown: true },
                        ] },
                    { type: "mtable", "id": "ProgOpExcluded", value: "CProgramOptionsGlobal.m_GlobFilter.Excluded", "h": 150, editable: true, el_class: "cell_low_border" },
                ] },
            { title: "Str_Logs", "icon": "logs", "help_url": "https://www.goodsync.com/manual#program-auto-tab", cont: [
                    { title: "Str_Logs", type: "option_group", cont: [
                            { type: "droplist", title: "Str_LogDetailLevel", value: "CProgramOptionsLocalOnly.llLogLevel", list: [
                                    GetLocaleText("Str_LogCritical"),
                                    GetLocaleText("Str_LogError"),
                                    GetLocaleText("Str_LogInfo"),
                                    GetLocaleText("Str_LogDetails"),
                                ] },
                            { type: "numberfield", title: "Str_LogRetainDays", value: "CProgramOptionsGlobal.m_nRetainLogsDays", "min": 0, "max": 100 },
                            { type: "row", cont: [
                                    { type: "textfield", title: "Str_LogFolderGlobal", value: "CProgramOptionsLocalOnly.sLogFolder", id: "log_folder_url" },
                                    { type: "button", title: "Browse", command: "SetCompareProgram(oMenu, 'log_folder_url')" }
                                ] },
                        ] },
                ] },
        ]
    },
};
const jsWaitingBox = {
    title: "WaitingBox", bottom_box: [], cont: [
        { title: "text", cont: [
                { type: "text", title: "Waiting for auth Oauth2" },
                { type: "place", title: "Test Results", id: "test_results", class: "test_account_results" },
            ] }
    ]
};
const jsLogMenu = [
    { title: "TT_ClearLogs", img: "clear", command: "ClearLog()" },
    { title: "Str_CopyLogToClipBoard", img: "copy", command: "CopyLogToClipBoard()" },
    { title: "TT_CloseLogs", active_cond: "IsLogWindowOpen()", command: "CloseLog()" },
    { title: "TT_OpenLogs", active_cond: "!IsLogWindowOpen()", command: "OpenLog()" },
    { title: "Str_LocalSettingsWebUI", img: "manage-account-16", command: "ShowMenuOfChoosingLogLevels()" },
];
const jsLogPageMenu = [
    { title: "Str_ClearOldLogPages", img: "clear", command: "ClearOldLogPages(xAddArgs)" },
    { title: "Str_CopyLogToClipBoard", img: "copy", command: "CopyLogToClipBoard()" },
];
const jsBrowseDialogFsMenu = [
    { title: "Cmd_Refresh", img: "refresh", command: "RefreshBrowseBranch('', xAddArgs)", disable: "IsFs(xAddArgs, ['mtp://'])" },
    { title: "Cmd_NewAccount", img: "new-account-16", command: "CreateNewAccount(xAddArgs)", disable: "IsFs(xAddArgs, ['file://','mtp://'])" },
];
const jsBrowseDialogAccMenu = [
    { title: "Cmd_Refresh", img: "refresh", command: "RefreshBrowseBranch('', xAddArgs)", disable: "xAddArgs.length > 1 || IsBookmarkInFolder(xAddArgs) !== 0", },
    { title: "Cmd_RefreshAsNormal", img: "refresh", command: "RefreshBrowseBranch('Normal', xAddArgs)", disable: "IsBookmarkInFolder(xAddArgs) === 0", },
    { title: "Cmd_RefreshAsEncrypt", img: "refresh", command: "RefreshBrowseBranch('Encrypt', xAddArgs)", disable: "IsBookmarkInFolder(xAddArgs) === 0", },
    { title: "Cmd_Properties", img: "properties", command: "BrowsDialogAccountInfoRequest(xAddArgs)", active_cond: "!IsAccReadOnly(xAddArgs)" },
    { title: "Cmd_JobDelete", img: "delete", command: "DeleteAccount(xAddArgs)", active_cond: "!IsAccReadOnly(xAddArgs)", },
    { title: "Str_ChangeAccountName", img: "rename", command: "RenameAccount(xAddArgs)", active_cond: "!IsAccReadOnly(xAddArgs)", },
    { title: "Cmd_NewFolder", img: "new-folder", command: "NewFolder(xAddArgs)", disable: "IsAccHaveServerList(xAddArgs)", active_cond: "CanCreateFolder(xAddArgs)" }
];
const jsBrowseDialogServerMenu = [
    { title: "Cmd_Refresh", img: "refresh", command: "RefreshBrowseBranch('', xAddArgs)", disable: "xAddArgs.length > 1" },
    { title: "Cmd_Properties", img: "properties", command: "BrowsDialogInfoRequest(xAddArgs)" },
    { title: "Cmd_NewFolder", img: "new-folder", command: "NewFolder(xAddArgs)", active_cond: "CanCreateFolder(xAddArgs)" }
];
const jsBrowseDialogFolderMenu = [
    { title: "Cmd_Refresh", img: "refresh", command: "RefreshBrowseBranch('', xAddArgs)", disable: "TableSelRoweNum(xAddArgs) != 1 || IsBookmarkInFolder(xAddArgs) !== 0" },
    { title: "Cmd_RefreshAsNormal", img: "refresh", command: "RefreshBrowseBranch('Normal',xAddArgs)", disable: "TableSelRoweNum(xAddArgs) != 1 || IsBookmarkInFolder(xAddArgs) === 0" },
    { title: "Cmd_RefreshAsEncrypt", img: "refresh", command: "RefreshBrowseBranch('Encrypt', xAddArgs)", disable: "TableSelRoweNum(xAddArgs) != 1 || IsBookmarkInFolder(xAddArgs) === 0" },
    { title: "Cmd_Properties", img: "properties", command: "BrowsDialogInfoRequest(xAddArgs)", disable: "TableSelRoweNum(xAddArgs) != 1" },
    { title: "Cmd_NewFolder", img: "new-folder", command: "NewFolder(xAddArgs)", disable: "TableSelRoweNum(xAddArgs) != 1", },
    { title: "<button class='StreamDownloadBtn' onclick='StreamDownloadFolderForSavingToDisk()'>Download</button>", img: "download", disable: "!('showSaveFilePicker' in window)" },
    { title: "Cmd_OpenInBrowser", img: "GoodSync Explorer", command: "OpenInBrowser(xAddArgs)", disable: "IsItBrowser() || TableSelRoweNum(xAddArgs) != 1" },
    { title: "Cmd_Delete", img: "delete", command: "ExplorerDeleteFile(xAddArgs)", disable: "!IsItBrowser()" },
];
const jsBrowseDialogFileMenu = [
    { title: "Cmd_Properties", img: "properties", command: "BrowsDialogInfoRequest(xAddArgs)", disable: "TableSelRoweNum(xAddArgs) != 1" },
    { title: "Str_DowloadFileWithStar", img: "download", command: "DowloadFileForSavingToDisk(xAddArgs)", disable: "('showSaveFilePicker' in window) || TableSelRoweNum(xAddArgs) != 1", hint: "Hint_LargeFileDownload" },
    { title: "<button class='StreamDownloadBtn' onclick='StreamDownloadFileForSavingToDisk()'>Download</button>", img: "download", disable: "!('showSaveFilePicker' in window)" },
    { title: "Cmd_Delete", img: "delete", command: "ExplorerDeleteFile(xAddArgs)" },
];
const jsWinExplorerMenu = [
    { title: "Cmd_Properties", img: "properties", command: "WinExplprerInfoRequest(xAddArgs)", disable: "TableSelRoweNum(xAddArgs) != 1" },
    { title: "Str_DowloadFileWithStar", img: "download", command: "DowloadFileForSavingToDisk(xAddArgs)",
        disable: "('showSaveFilePicker' in window) || TableSelRoweNum(xAddArgs) != 1 || !IsFile(xAddArgs)", hint: "Hint_LargeFileDownload" },
    { title: "<button class='StreamDownloadBtn' onclick='StreamDownloadFileForSavingToDisk()'>Download</button>", img: "download",
        disable: "!('showSaveFilePicker' in window) || !IsFile(xAddArgs)" },
    { title: "<button class='StreamDownloadBtn' onclick='StreamDownloadFolderForSavingToDisk()'>Download</button>", img: "download",
        disable: "!('showSaveFilePicker' in window) || IsFile(xAddArgs)" },
    { title: "Cmd_Delete", img: "delete", command: "WinExplorerDeleteFile(xAddArgs)", disable: "!IsFile(xAddArgs)" },
];
const jsUserActsMenu = {
    file: [
        { title: "Cmd_ItemLDelete", img: "I_Ena_Del", command: "SpOpRequestConfirm(text, xAddArgs)", disable: "!xAddArgs.left_is" },
        { title: "Cmd_ItemRDelete", img: "I_Ena_Del", command: "SpOpRequestConfirm(text, xAddArgs)", disable: "!xAddArgs.right_is" },
        { title: "Cmd_ItemDeleteBoth", img: "I_Ena_Del", command: "SpOpRequestConfirm(text, xAddArgs)", disable: "!xAddArgs.right_is || !xAddArgs.left_is" },
        { "separator": true, title: "" },
        { title: "Cmd_ItemExcludeFile1", img: "Filters_minus", "text_args": ["GetItemPath",], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemExcludeAllFiles1", img: "Filters_minus", "text_args": ["GetItemName",], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemExcludeAllMask1", img: "Filters_minus", "text_args": ["GetItemExt",], command: "SpOpRequest(text, xAddArgs)", disable: "!GetOnlyExtention(xAddArgs.path_arr[0])" },
        { title: "Cmd_ItemIncludeFile1", img: "Filters_plus", "text_args": ["GetItemPath",], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemIncludeAllMask1", img: "Filters_plus", "text_args": ["GetItemExt",], command: "SpOpRequest(text, xAddArgs)", disable: "!GetOnlyExtention(xAddArgs.path_arr[0])" },
        { "separator": true, title: "", disable: "xAddArgs.equal" },
        { title: "ChangeDirectionTo", img: "", disable: "xAddArgs.equal", "submenu": [
                { img: "", title: "Cmd_Recommended", command: "SpOpRequest(text, xAddArgs)" },
                { img: "L_Ena_Arr_Fil", title: "Cmd_CopyRightToLeft", command: "SpOpRequest(text, xAddArgs)" },
                { img: "R_Ena_Arr_Fill", title: "Cmd_CopyLeftToRight", command: "SpOpRequest(text, xAddArgs)" },
                { img: "C_Ena_Cir", title: "Cmd_DoNotCopy", command: "SpOpRequest(text, xAddArgs)" },
                { img: "", title: "Cmd_CopyTimeLeftToRight", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_time" },
                { img: "", title: "Cmd_CopyTimeRightToLeft", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_time" },
                { img: "", title: "Cmd_NameCaseLeftToRight", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_reg" },
                { img: "", title: "Cmd_NameCaseRightToLeft", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_reg" },
            ] },
        { "separator": true, title: "" },
        { title: "Cmd_Properties", img: "properties", command: "GetTreeItemProps(xAddArgs)" },
    ],
    folder: [
        { title: "Cmd_OpenLFolder", img: "GoodSync Explorer", command: "OpenInBrowser(xAddArgs, text)", active_cond: "xAddArgs.left_is" },
        { title: "Cmd_OpenRFolder", img: "GoodSync Explorer", command: "OpenInBrowser(xAddArgs, text)", active_cond: "xAddArgs.right_is" },
        { title: "Cmd_DeleteLFolder", img: "I_Ena_Del", command: "SpOpRequestConfirm(text, xAddArgs)", disable: "!xAddArgs.left_is" },
        { title: "Cmd_DeleteRFolder", img: "I_Ena_Del", command: "SpOpRequestConfirm(text, xAddArgs)", disable: "!xAddArgs.right_is" },
        { title: "Cmd_DeleteBothFolders", img: "I_Ena_Del", command: "SpOpRequestConfirm(text, xAddArgs)", disable: "!xAddArgs.right_is || !xAddArgs.left_is" },
        { "separator": true, title: "" },
        { title: "Cmd_ItemExcludeFolder1", img: "Filters_minus", "text_args": ["GetItemPath"], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemExcludeAllFolders1", img: "Filters_minus", "text_args": ["GetItemName"], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemIncludeFolder1", img: "Filters_plus", "text_args": ["GetItemPath"], command: "SpOpRequest(text, xAddArgs)" },
        { "separator": true, title: "", disable: "xAddArgs.equal" },
        { title: "ChangeDirectionTo", img: "", disable: "xAddArgs.equal", "submenu": [
                { img: "", title: "Cmd_Recommended", command: "SpOpRequest(text, xAddArgs)" },
                { img: "L_Ena_Arr_Fil", title: "Cmd_CopyRightToLeft", command: "SpOpRequest(text, xAddArgs)" },
                { img: "R_Ena_Arr_Fill", title: "Cmd_CopyLeftToRight", command: "SpOpRequest(text, xAddArgs)" },
                { img: "C_Ena_Cir", title: "Cmd_DoNotCopy", command: "SpOpRequest(text, xAddArgs)" },
                { img: "", title: "Cmd_CopyTimeLeftToRight", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_time" },
                { img: "", title: "Cmd_CopyTimeRightToLeft", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_time" },
                { img: "", title: "Cmd_NameCaseLeftToRight", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_reg" },
                { img: "", title: "Cmd_NameCaseRightToLeft", command: "SpOpRequest(text, xAddArgs)", disable: "!xAddArgs.diff_reg" },
            ] },
        { "separator": true, title: "" },
        { title: "Cmd_Properties", img: "properties", command: "GetTreeItemProps(xAddArgs)" },
        { title: "Cmd_Refresh", img: "refresh", command: "RefreshJobTreeBranch(xAddArgs)" },
    ],
    multy: [
        { title: "Cmd_OpenLFolder", img: "", command: "OpenFolderInExplorer(text, xAddArgs)", noactive: true },
        { title: "Cmd_OpenRFolder", img: "", command: "OpenFolderInExplorer(text, xAddArgs)", noactive: true },
        { title: "Cmd_ItemLDeleteMul1", img: "I_Ena_Del", "text_args": ["GetItemNumb"], command: "SpOpRequestConfirm(text, xAddArgs)" },
        { title: "Cmd_ItemRDeleteMul1", img: "I_Ena_Del", "text_args": ["GetItemNumb"], command: "SpOpRequestConfirm(text, xAddArgs)" },
        { title: "Cmd_ItemBDeleteMul1", img: "I_Ena_Del", "text_args": ["GetItemNumb"], command: "SpOpRequestConfirm(text, xAddArgs)" },
        { "separator": true, title: "" },
        { title: "Cmd_ItemExcludeMulti1", img: "Filters_minus", "text_args": ["GetItemNumb"], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemExcludeAllMulti1", img: "Filters_minus", "text_args": ["GetItemNumb"], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemExcludeAllMaskMulti1", img: "Filters_minus", "text_args": ["GetItemNumb"], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemIncludeMulti1", img: "Filters_plus", "text_args": ["GetItemNumb"], command: "SpOpRequest(text, xAddArgs)" },
        { title: "Cmd_ItemIncludeAllMaskMulti2", img: "Filters_plus", "text_args": ["GetItemNumb"], command: "SpOpRequest(text, xAddArgs)" },
        { "separator": true, title: "" },
        { title: "ChangeDirectionTo", img: "", "submenu": [
                { img: "", title: "Cmd_Recommended", command: "SpOpRequest(text, xAddArgs)" },
                { img: "L_Ena_Arr_Fil", title: "Cmd_CopyRightToLeft", command: "SpOpRequest(text, xAddArgs)" },
                { img: "R_Ena_Arr_Fill", title: "Cmd_CopyLeftToRight", command: "SpOpRequest(text, xAddArgs)" },
                { img: "C_Ena_Cir", title: "Cmd_DoNotCopy", command: "SpOpRequest(text, xAddArgs)" },
                { img: "", title: "Cmd_CopyTimeLeftToRight", command: "SpOpRequest(text, xAddArgs)" },
                { img: "", title: "Cmd_CopyTimeRightToLeft", command: "SpOpRequest(text, xAddArgs)" },
                { img: "", title: "Cmd_NameCaseLeftToRight", command: "SpOpRequest(text, xAddArgs)" },
                { img: "", title: "Cmd_NameCaseRightToLeft", command: "SpOpRequest(text, xAddArgs)" },
            ] },
        { "separator": true, title: "" },
        { title: "Cmd_Properties", img: "properties", command: "GetTreeItemProps(xAddArgs)" },
    ],
};
const jsGroupMenu = [
    { img: "analyze", title: "Cmd_Analyze", "hot_keys": "Alt+A, F5", command: "StartJobFromDropMenuGroup(JOB_COMMAND_ANALIZE, xAddArgs)" },
    { img: "job_syncing_red_blue", title: "Cmd_Sync", "hot_keys": "Alt+S, F7", command: "StartJobFromDropMenuGroup(JOB_COMMAND_SYNC, xAddArgs)" },
    { img: "delete", title: "Cmd_DeleteGroup", command: "DeleteGroup(xAddArgs)", disable: "!IsUserGroup(xAddArgs)" }
];
const jsFolderMenu = [
    { img: "folder", title: "Cmd_Browse", command: "SetFolderOptFromJobDetails(xAddArgs)" },
    { img: "GoodSync Explorer", title: "Cmd_OpenFolderInExplorer", command: "OpenInBrowser(xAddArgs)" },
    { img: "settings-1", title: "Str_ChangeFolderOptions", command: "GetAndShowOptionsFromJobDetails(xAddArgs)" },
    { img: "copy", title: "Str_CopyPathToClipboard", command: "CopyPathToClipboard(xAddArgs)" }
];
const jsJobMenu = [
    { img: "analyze", title: "Cmd_Analyze", "hot_keys": "Alt+A, F5", command: "StartJobFromDropMenu(JOB_COMMAND_ANALIZE, xAddArgs)", active_cond: "IsJobReadyToAnalize(xAddArgs)" },
    { img: "job_syncing_red_blue", title: "Cmd_Sync", "hot_keys": "Alt+S, F7", command: "StartJobFromDropMenu(JOB_COMMAND_SYNC, xAddArgs)", active_cond: "IsJobReadyToSync(xAddArgs)" },
    { img: "analyze_and_sync", title: "Cmd_AnalyzeAndSyncThis", command: "StartJobFromDropMenu(JOB_COMMAND_ANALIZE_AND_SYNC, xAddArgs)", active_cond: "IsJobReadyToAnalize(xAddArgs)" },
    { img: "clear", title: "Btn_Clear", command: "ClearJob(xAddArgs)", active_cond: "IsJobCanBeCleaned(xAddArgs)" },
    { img: "pause", title: "Cmd_Pause", command: "PauseJob(xAddArgs)", active_cond: "IsJobActive(xAddArgs)" },
    { img: "stop", title: "Cmd_Stop", command: "StopJob(xAddArgs)", active_cond: "IsJobActive(xAddArgs)" },
    { "separator": true, title: "" },
    { img: "settings", title: "Cmd_JobOptions", command: "GetAndShowJobOptions(xAddArgs)", "hot_keys": "Alt+O", active_cond: "OnlyOneSelectedJob(xAddArgs)" },
    { img: "GSLogView", title: "Cmd_JobOpenLogLeft", command: "OpenLogInSide('left')", "hot_keys": "Alt+L" },
    { img: "GSLogView", title: "Cmd_JobOpenLogRight", command: "OpenLogInSide('right')", "hot_keys": "Alt+R" },
    { "separator": true, title: "" },
    { img: "", title: "Str_AddToGroup", "hot_keys": "", "noactive": true, "submenu": [] },
    { img: "", title: "Str_RemoveFromGroup", "hot_keys": "", disable: "true" },
    { "separator": true, title: "" },
    { img: "delete", title: "Cmd_JobDelete", command: "DeleteJob(xAddArgs)", active_cond: "OnlyOneSelectedJob(xAddArgs)" },
    { img: "rename", title: "Cmd_JobRename", "hot_keys": "", command: "RenameJob(xAddArgs)" },
    { "separator": true, title: "" },
    { img: "", title: "Str_JobMenuAdvanced", active_cond: "sCurrJob != ''", submenu: [
            { img: "", title: "Cmd_JobResetState", command: "SpOpRequestFromJobsList(text, xAddArgs)", active_cond: "OnlyOneSelectedJob(xAddArgs) && !IsJobActive(xAddArgs)" },
            { img: "", title: "Cmd_JobDeleteBackup", command: "SpOpRequestFromJobsList(text, xAddArgs)", active_cond: "OnlyOneSelectedJob(xAddArgs) && !IsJobActive(xAddArgs)" },
            { img: "", title: "Cmd_JobDeleteGsData", command: "SpOpRequestFromJobsList(text, xAddArgs)", active_cond: "OnlyOneSelectedJob(xAddArgs) && !IsJobActive(xAddArgs)" },
            { img: "", title: "Cmd_JobCleanupRecycled", command: "SpOpRequestFromJobsList(text, xAddArgs)", active_cond: "OnlyOneSelectedJob(xAddArgs) && !IsJobActive(xAddArgs)" },
        ] },
    { "separator": true, title: "" },
    { img: "refresh", title: "Cmd_Refresh", "hot_keys": "", command: "RefreshJobTreeRequest(xAddArgs.Branch.pathEl)", active_cond: "sCurrJob != ''" },
];
const jsDirectChangeDropMenu = [
    { img: "arrow-left-right", title: "Str_JobType_TwoWay", command: "ChangeJobDirection(JS_TWO_WAY)" },
    { img: "move-right", title: "Str_JobType_LeftToRight", command: "ChangeJobDirection(JS_LEFT_TO_RIGHT)" },
    { img: "move-left", title: "Str_JobType_RightToLeft", command: "ChangeJobDirection(JS_RIGHT_TO_LEFT)" },
];
const jsMainMenu = [
    { title: "Menu_Job", cont: jsJobMenu },
    { title: "Cmd_View", cont: [
            { title: "TT_CloseLogs", active_cond: "IsLogWindowOpen()", command: "CloseLog()" },
            { title: "TT_OpenLogs", active_cond: "!IsLogWindowOpen()", command: "OpenLog()" },
            { title: "Str_FollowTheSync", checkbox: "bFollowTheSync" },
            { title: "Str_ExpandTree", checkbox: "oAutoDeploy.JobTreeAutoDeploy" },
        ] },
    { title: "Cmd_Tools", cont: [
            { title: "Cmd_ProgOptions", img: "settings-1", command: "ShowProgramOptions()" },
            { title: "Cmd_ServerControlPanel", img: "settings", command: "LinkToServerOptions()", active_cond: "bIsLocalhost" },
            { "separator": true, title: "" },
            { title: "Str_LocalSettingsWebUI", img: "manage-account-16", command: "ShowMenuOfChoosingLogLevels()" },
            { title: "Str_RequestAccountSync", img: "account-sync-req", command: "AccountSyncRequest()", active_cond: "bAutoAccSyncOn" },
            { "separator": true, title: "" },
            { title: "Cmd_Logout", img: "sign-out-16", command: "Logout()", active_cond: "!(!sBearerToken)" },
        ] },
    { title: "Cmd_Help", cont: [
            { title: "Cmd_CreateTicket", img: "", command: "CreateSupportTicket()" },
            { title: "Cmd_About", img: "About", command: "GetAbout()" }
        ] },
];
const jsFloatMenuTableHeads = {
    Shared_by_my: [
        { field_name: "from_computer", col_name: "From computer", auto_ext: 33 },
        { field_name: "to_computer", col_name: "To computer", auto_ext: 33 },
        { field_name: "to_user", col_name: "To user", auto_ext: 33 },
        { field_name: "read_only", col_name: "Read-only", bool: true }
    ],
    BrowseDialogTableHead: [
        { field_name: "display_name", col_name: "Name", icon: "icon", auto_ext: 30 },
        { field_name: "menu", col_name: "", img: true, class: "hide_explorer_menu", button: "CallRowDropMenu" },
        { field_name: "comment", col_name: "Comments", auto_ext: 70 },
    ],
    ExploreTableHead: [
        { field_name: "display_name", col_name: "Name", icon: "icon", auto_ext: 30 },
        { field_name: "menu", col_name: "", img: true, class: "hide_explorer_menu", button: "CallRowDropMenu" },
        { field_name: "size", col_name: "Size", align: "right", locale_number: "en-US", auto_ext: 20 },
        { field_name: "tMod_s", col_name: "Modifed", align: "center", time: true, auto_ext: 20 },
        { field_name: "comment", col_name: "Comments", auto_ext: 70 },
    ],
    WinExploreTreeHead: [
        { field_name: "display_name", col_name: "Name", icon: "icon" },
    ],
    WinExploreTableHead: [
        { field_name: "display_name", col_name: "Name", icon: "icon", auto_ext: 30 },
        { field_name: "size", col_name: "Size", align: "right", locale_number: "en-US", auto_ext: 20 },
        { field_name: "tMod_s", col_name: "Modifed", align: "center", time: true, auto_ext: 20 },
        { field_name: "comment", col_name: "Comments", auto_ext: 70 },
    ],
};
const jsJobTreeTableHead = [
    { field_name: "name", col_name: "Item", icon: "job_icon", auto_ext: 40 },
    { field_name: "lsize", col_name: "L Size", align: "right", locale_number: "en-US", "progressbar": true, auto_ext: 10 },
    { field_name: "ldate", col_name: "L Date", align: "right", time: true, auto_ext: 20 },
    { field_name: "l_number", col_name: "L", align: "center" },
    { field_name: "l", col_name: "&nbsp;", img: true, button: "UserActButton" },
    { field_name: "c", col_name: "&nbsp;", img: true, button: "UserActButton" },
    { field_name: "r", col_name: "&nbsp;", img: true, button: "UserActButton" },
    { field_name: "r_number", col_name: "R", align: "center" },
    { field_name: "rsize", col_name: "R Size", align: "right", locale_number: "en-US", "progressbar": true, auto_ext: 10 },
    { field_name: "rdate", col_name: "R Date", align: "right", time: true, auto_ext: 20 },
    { field_name: "status", col_name: "Status" }
];
const jsFileTypeColors = {
    "img": "#088",
    "video": "#808",
    "audio": "#008",
    "archive": "#ff8040",
    "e-doc": "#e00",
    "table": "#080",
    "cod": "#000",
    "text": "#08f",
    "*": "#888",
};
const jsFileExtensionMap = {
    "*": "*",
    "ZIP": "archive",
    "RAR": "archive",
    "TG": "archive",
    "7Z": "archive",
    "PDF": "e-doc",
    "FB2": "e-doc",
    "XLS": "table",
    "XLSX": "table",
    "ODS": "table",
    "CSV": "table",
    "TSV": "table",
    "C": "cod",
    "CPP": "cod",
    "H": "cod",
    "JS": "cod",
    "PHP": "cod",
    "3GP": "video",
    "3G2": "video",
    "H261": "video",
    "H263": "video",
    "H264": "video",
    "JPGV": "video",
    "JPM": "video",
    "MJ2": "video",
    "MP4": "video",
    "MPEG": "video",
    "OGV": "video",
    "QT": "video",
    "UVH": "video",
    "UVM": "video",
    "UVP": "video",
    "UVS": "video",
    "UVV": "video",
    "FVT": "video",
    "MXU": "video",
    "PYV": "video",
    "UVU": "video",
    "VIV": "video",
    "WEBM": "video",
    "F4V": "video",
    "FLI": "video",
    "FLV": "video",
    "M4V": "video",
    "ASF": "video",
    "WM": "video",
    "WMV": "video",
    "WMX": "video",
    "WVX": "video",
    "AVI": "video",
    "MOVIE": "video",
    "MOV": "video",
    "BMP": "img",
    "CGM": "img",
    "G3": "img",
    "GIF": "img",
    "IEF": "img",
    "KTX": "img",
    "PJPEG": "img",
    "PNG": "img",
    "BTIF": "img",
    "SVG": "img",
    "TIFF": "img",
    "PSD": "img",
    "UVI": "img",
    "DJVU": "img",
    "SUB": "img",
    "DWG": "img",
    "DXF": "img",
    "FBS": "img",
    "FPX": "img",
    "FST": "img",
    "MMR": "img",
    "RLC": "img",
    "MDI": "img",
    "NPX": "img",
    "WBMP": "img",
    "XIF": "img",
    "WEBP": "img",
    "JPEG": "img",
    "JPG": "img",
    "RAS": "img",
    "CMX": "img",
    "FH": "img",
    "ICO": "img",
    "PCX": "img",
    "PIC": "img",
    "PNM": "img",
    "PBM": "img",
    "PGM": "img",
    "PPM": "img",
    "RGB": "img",
    "XBM": "img",
    "XPM": "img",
    "XWD": "img",
    "ADP": "audio",
    "AU": "audio",
    "MID": "audio",
    "MP4A": "audio",
    "MPGA": "audio",
    "MP3": "audio",
    "OGA": "audio",
    "UVA": "audio",
    "EOL": "audio",
    "DRA": "audio",
    "DTS": "audio",
    "DTSHD": "audio",
    "LVP": "audio",
    "PYA": "audio",
    "ECELP4800": "audio",
    "ECELP7470": "audio",
    "ECELP9600": "audio",
    "RIP": "audio",
    "WEBA": "audio",
    "AAC": "audio",
    "AIF": "audio",
    "M3U": "audio",
    "WAX": "audio",
    "WMA": "audio",
    "RAM": "audio",
    "RMP": "audio",
    "WAV": "audio",
    "ICS": "text",
    "CSS": "text",
    "HTML": "text",
    "HTM": "text",
    "N3": "text",
    "TXT": "text",
    "PAR": "text",
    "DSC": "text",
    "RTX": "text",
    "SGML": "text",
    "T": "text",
    "TTL": "text",
    "URI": "text",
    "CURL": "text",
    "DCURL": "text",
    "MCURL": "text",
    "SCURL": "text",
    "FLY": "text",
    "FLX": "text",
    "GV": "text",
    "3DML": "text",
    "SPOT": "text",
    "JAD": "text",
    "WML": "text",
    "WMLS": "text",
    "S": "text",
    "F": "text",
    "JAVA": "text",
    "P": "text",
    "ETX": "text",
    "UU": "text",
    "VCS": "text",
    "VCF": "text",
    "YAML": "text",
    "DOC": "text",
    "DOCX": "text",
    "LOG": "text",
};
const jsRightWinowsTableHead = [
    { field_name: "job_icon", col_name: "", img: true },
    { field_name: "name", col_name: "Title_TaskName", auto_ext: 10, },
    { field_name: "status", col_name: "Str_ColumnStatus", auto_ext: 10, progressbar: true },
    { field_name: "auto", col_name: "Title_Auto", auto_ext: 10, },
    { field_name: "left_url", col_name: "Str_ColumnLPath", auto_ext: 10, },
    { field_name: "direct", col_name: "", img: true },
    { field_name: "right_url", col_name: "Str_ColumnRPath", auto_ext: 10, },
    { field_name: "nLastRunTime", col_name: "Title_LastRunTime", auto_ext: 10, time: true }
];
const aPreferredRegion = [
    "Default (us-east-1)",
    "af-south-1",
    "ap-east-1",
    "ap-northeast-1",
    "ap-northeast-2",
    "ap-northeast-3",
    "ap-south-1",
    "ap-south-2",
    "ap-southeast-1",
    "ap-southeast-2",
    "ap-southeast-3",
    "ca-central-1",
    "cn-north-1",
    "cn-northwest-1",
    "EU",
    "eu-central-1",
    "eu-central-2",
    "eu-north-1",
    "eu-south-1",
    "eu-south-2",
    "eu-west-1",
    "eu-west-2",
    "eu-west-3",
    "me-south-1",
    "sa-east-1",
    "us-east-1",
    "us-east-2",
    "us-gov-east-1",
    "us-gov-west-1",
    "us-west-1",
    "us-west-2"
];
const aStorageClass = [
    "Default",
    "S3 Standard",
    "S3 Standard Infrequent Access",
    "S3 Glacier Immediate Retrieval",
    "S3 Glacier Flexible Retrieval",
    "S3 Glacier Deep Archive",
    "S3 Intelligent - Tiering",
    "S3 One Zone Infrequent Access",
    "S3 Express One Zone",
    "Reduced Redundancy (not recommended)",
    "Outposts",
    "Snow"
];
