"use strict";
class TStretchGlobData {
    constructor() {
        this.globX = -1;
        this.globY = -1;
        this.baseWidth = -1;
        this.baseHeight = -1;
        this.pad = 0;
    }
}
const sgd = new TStretchGlobData;
function IsItFlex(el) {
    return getComputedStyle(el).flexBasis !== "auto";
}
function StretchElX(el, nClientX) {
    const tmpSize = sgd.baseWidth + nClientX - sgd.globX;
    let lim;
    if (el.domLimEl) {
        lim = el.domLimEl.getBoundingClientRect().right;
    }
    else {
        lim = el.parentElement.getBoundingClientRect().right;
    }
    if ((el.getBoundingClientRect().left + tmpSize + sgd.pad + (el.offsetX || 0)) <= lim) {
        if (IsItFlex(el)) {
            el.style.flex = "0 0 " + tmpSize + "px";
        }
        else {
            el.style.width = tmpSize + "px";
            if (el.sDriven)
                SetClassWidth(el.sDriven, tmpSize + "px");
            if (el.oFeedback) {
                el.oFeedback.arr[el.oFeedback.i] = tmpSize;
            }
        }
    }
    if ("nResizeX" in el) {
        el.nResizeX = nClientX - sgd.globX;
        el.nResizeY = 0;
    }
}
function StretchElY(el, nClientY) {
    let tmpSize = sgd.baseHeight + nClientY - sgd.globY;
    let lim;
    if (el.domLimEl) {
        lim = el.domLimEl.getBoundingClientRect().bottom;
    }
    else {
        lim = el.parentElement.getBoundingClientRect().bottom;
    }
    if ((el.getBoundingClientRect().top + tmpSize + sgd.pad + 0) <= lim) {
        if (IsItFlex(el)) {
            el.style.flexBasis = tmpSize + "px";
        }
        else {
            el.style.height = tmpSize + "px";
        }
    }
    if ("nResizeY" in el) {
        el.nResizeY = nClientY - sgd.globY;
        el.nResizeX = 0;
    }
}
function DrawDrag() {
    let aDragX = document.getElementsByClassName("dragX");
    for (let item of aDragX) {
        const el = item;
        if (!el.draggableEl)
            continue;
        let rect = el.draggableEl.getBoundingClientRect();
        let contRect;
        if (el.draggableEl.domLimEl) {
            contRect = el.draggableEl.domLimEl.getBoundingClientRect();
        }
        else if (el.draggableEl.parentElement) {
            contRect = el.draggableEl.parentElement.getBoundingClientRect();
        }
        else {
            contRect = document.body.getBoundingClientRect();
        }
        el.style.left = (rect.right + DRAG_OFFSET) + "px";
        el.style.top = rect.top + "px";
        el.style.height = rect.height + "px";
        if ((rect.right > (contRect.right + el.clientWidth)) || (rect.right < (contRect.left - el.clientWidth))) {
            el.style.display = "none";
        }
        else
            el.style.display = "";
    }
    let aDragY = document.getElementsByClassName("dragY");
    for (let item of aDragY) {
        const el = item;
        if (!el.draggableEl)
            continue;
        const rect = el.draggableEl.getBoundingClientRect();
        let contRect;
        if (el.draggableEl.domLimEl) {
            contRect = el.draggableEl.domLimEl.getBoundingClientRect();
        }
        else if (el.draggableEl.parentElement) {
            contRect = el.draggableEl.parentElement.getBoundingClientRect();
        }
        else {
            contRect = document.body.getBoundingClientRect();
        }
        el.style.top = (rect.bottom + DRAG_OFFSET - 0) + "px";
        el.style.left = rect.left + "px";
        el.style.width = rect.width + "px";
        if ((rect.bottom > (contRect.bottom + el.clientHeight)) || (rect.bottom < (contRect.top - el.clientHeight))) {
            el.style.display = "none";
        }
        else
            el.style.display = "";
    }
}
function GetZIndex(el) {
    if (!el || !el.style)
        return 0;
    if (el.style.zIndex)
        return Number(el.style.zIndex);
    if (el.parentElement)
        return GetZIndex(el.parentElement);
    return 0;
}
function SetStretchEl() {
    DeleteAllClassEl("dragX");
    DeleteAllClassEl("dragY");
    let aClass = document.getElementsByClassName("stretch_x");
    for (let item of aClass) {
        const el = item;
        let zIndOfEl = GetZIndex(el);
        if (isNaN(zIndOfEl)) {
            zIndOfEl = 0;
        }
        const rect = el.getBoundingClientRect();
        const div = document.createElement('div');
        div.className = "dragX nonselect";
        div.style.height = rect.height + "px";
        div.style.top = rect.top + "px";
        div.style.left = (rect.right + DRAG_OFFSET) + "px";
        div.style.zIndex = (zIndOfEl + 1) + "";
        div["draggableEl"] = el;
        div.onmousedown = function (e) {
            e.stopPropagation();
            DeleteAllDropMenu();
            sgd.globX = e.clientX;
            sgd.baseWidth = el.getBoundingClientRect().width;
            sgd.pad = 0;
            document.body.style.cursor = "col-resize";
            document.onmousemove = function (e) {
                StretchElX(el, e.clientX);
            };
            document.onmouseup = function (e) {
                CursorReset(e);
                if (el.oFeedback && el.oFeedback.oControl && el.oFeedback.oControl.fSaveColsSize) {
                    el.oFeedback.oControl.fSaveColsSize(el.oFeedback.arr);
                }
            };
        };
        div.onmouseup = function (e) {
            CursorReset(e);
        };
        document.body.append(div);
    }
    aClass = document.getElementsByClassName("stretch_y");
    for (let item of aClass) {
        const el = item;
        let zIndOfEl = GetZIndex(el);
        if (isNaN(zIndOfEl)) {
            zIndOfEl = 0;
        }
        const rect = el.getBoundingClientRect();
        const div = document.createElement('div');
        div.className = "dragY nonselect";
        div.style.width = rect.width + "px";
        div.style.top = (rect.bottom + DRAG_OFFSET - 0) + "px";
        div.style.left = rect.left + "px";
        div.style.zIndex = (zIndOfEl + 1) + "";
        div["draggableEl"] = el;
        div.onmousedown = function (e) {
            e.stopPropagation();
            DeleteAllDropMenu();
            sgd.globY = e.clientY;
            if (IsItFlex(el)) {
                sgd.baseHeight = Number(el.style.flexBasis.slice(0, -2));
                sgd.pad = el.getBoundingClientRect().height - sgd.baseHeight;
            }
            else {
                sgd.baseHeight = el.getBoundingClientRect().height;
                sgd.pad = 0;
            }
            document.body.style.cursor = "row-resize";
            document.onmousemove = function (e) {
                StretchElY(el, e.clientY);
            };
            document.onmouseup = function (e) {
                CursorReset(e);
            };
        };
        div.onmouseup = function (e) {
            CursorReset(e);
        };
        document.body.append(div);
    }
}
function CursorReset(e) {
    document.onmousemove = null;
    document.onmouseup = BaseMouseUp;
    document.body.style.cursor = "default";
    SetStretchEl();
    BaseMouseUp(e);
}
let nScrollTimeoutId = 0;
function DrawDragAfterScrolling() {
    if (nScrollTimeoutId > 0)
        clearTimeout(nScrollTimeoutId);
    nScrollTimeoutId = setTimeout(DrawDrag, 500);
}
class TDrawDragNeedObserver {
    constructor() {
        this.nResizeObserverCnt = null;
        this.resizeObserver = new ResizeObserver(() => {
            if (this.nResizeObserverCnt) {
                clearTimeout(this.nResizeObserverCnt);
            }
            this.nResizeObserverCnt = setTimeout(this.DrawDragAct, 1000);
        });
    }
    add(el) {
        this.resizeObserver.observe(el);
    }
    DrawDragAct() {
        this.nResizeObserverCnt = null;
        DrawDrag();
    }
}
const oDDNO = new TDrawDragNeedObserver;
