"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
function FillRightWindow(bNewIcons) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!domRightTableWindow)
            return;
        domRightTableWindow.innerHTML = "";
        domRightTableWindow.tabIndex = -1;
        domRightTableWindow.classList.remove("dt_lim_window");
        if (sCurrJob) {
            let oJobInList = aGlobJobArray.find(item => item.name == sCurrJob);
            if (!oJobInList)
                return;
            if (!oJobInList.oSideCoords || !oJobInList.oSideCoords[0].opts) {
                try {
                    const oJobData = yield AsyncUnicSendRecivePostApiWithRetry("GetJobByName", { "job_name": oJobInList.name });
                    SettingJobShortFields(oJobData.opt, oJobInList);
                }
                catch (_a) { }
            }
            pRightTableBody = null;
            domRightTableWindow.classList.remove("flex_gor");
            domRightTableWindow.classList.add("flex_vert");
            let errors = document.createElement("div");
            domRightTableWindow.append(errors);
            errors.className = "job_errors";
            errors.id = "job_error";
            errors.style.display = "none";
            let domJobShortInfo = document.createElement("div");
            domJobShortInfo.id = "job_summary";
            domRightTableWindow.append(domJobShortInfo);
            const domAbove = document.createElement("div");
            domAbove.className = "flex_1_1_100";
            domJobShortInfo.append(domAbove);
            const domTopOfDomAbove = document.createElement("div");
            domTopOfDomAbove.className = "flex_gor";
            domTopOfDomAbove.id = "idTopOfDomAbove";
            domAbove.append(domTopOfDomAbove);
            let domSwtchTreeFltBtnPnl = document.createElement("div");
            domSwtchTreeFltBtnPnl.id = "idSwtchTreeFltBtnPnl";
            domSwtchTreeFltBtnPnl.className = "flex_gor_center gray_panel";
            domTopOfDomAbove.append(domSwtchTreeFltBtnPnl);
            const domJobTreeControls = document.createElement("div");
            domJobTreeControls.className = "flex_gor_center gray_panel in_flex_go_right";
            domJobTreeControls.id = "idJobTreeControls";
            domTopOfDomAbove.append(domJobTreeControls);
            let domRealSummaryInfo = document.createElement("div");
            domAbove.append(domRealSummaryInfo);
            domRealSummaryInfo.id = "real_summary_info";
            domRealSummaryInfo.style.display = "none";
            let label = document.createElement("span");
            domRealSummaryInfo.append(label);
            label.className = "debug_job_info";
            label.append(sCurrJob + ": ");
            let label2 = document.createElement("span");
            domRealSummaryInfo.append(label2);
            label2.className = "debug_job_info";
            label2.id = "job_status_info";
            if (oJobInList.isWaiting == JOB_COMMAND_ANALIZE)
                label2.innerHTML = GetLocaleText("str_analysis_request_sent");
            else if (oJobInList.status)
                label2.innerHTML = oJobInList.status;
            else
                label2.innerHTML = GetLocaleText("Hint_Click_Analyze");
            let detale = document.createElement("span");
            domRealSummaryInfo.append(detale);
            detale.className = "job_status_detale";
            detale.id = "job_status_detale_" + sCurrJob;
            detale.innerHTML = GetJobStatusString(oJobInList.oJobStatus);
            const domHugeTexi = document.createElement("div");
            domHugeTexi.id = "huge_text_label";
            domJobShortInfo.append(domHugeTexi);
            let pbBox = document.createElement("div");
            domJobShortInfo.append(pbBox);
            pbBox.className = "flex_0_0";
            pbBox.id = "main_progress_bar_box";
            pbBox.style.display = "none";
            let pb = document.createElement("div");
            pb.className = "progress_bar";
            pb.id = "progress_bar_" + sCurrJob;
            pbBox.append(pb);
            let domPercent = document.createElement("span");
            domPercent.className = "percent_num";
            domPercent.id = "sync_analie_percent_num";
            pbBox.append(domPercent);
            const domLeftMsg = document.createElement("div");
            domLeftMsg.id = "for_left_msg";
            const domRightMsg = document.createElement("div");
            domRightMsg.id = "for_right_msg";
            pbBox.append(domLeftMsg);
            pbBox.append(domRightMsg);
            const domBelow = document.createElement("div");
            domBelow.className = "flex_1_1_100";
            domJobShortInfo.append(domBelow);
            let domJobTreeBox = document.createElement("div");
            domJobTreeBox.id = "job_tree_window";
            domRightTableWindow.append(domJobTreeBox);
            pRightTableBody = null;
            SetStretchEl();
            const oDTP = jsJobsTables[sCurrJob];
            if (oDTP) {
                if (!oJobInList.aTotals) {
                    oJobInList.aTotals = [];
                }
                if (oJobInList.oJobStatus && oJobInList.oJobStatus.job_result != RUN_result_term_error) {
                    CreatePanelOfJobModeView(oJobInList.aTotals, oWebGuSettings.GetTreeMode(sCurrJob));
                }
                if (oDTP.fIsNotEmpty()) {
                    ShowTreeIfThisNeeds(sCurrJob, oDTP, oJobInList);
                }
                else {
                    yield ShowTextIfNoTree(oJobInList, true);
                }
            }
            else {
                if (oJobInList.oJobStatus && (oJobInList.oJobStatus.job_run_state == "sync_running" || oJobInList.oJobStatus.job_run_state == "sync_done")) {
                    JobTreeRequest();
                }
                else {
                    yield ShowTextIfNoTree(oJobInList, true);
                }
            }
        }
        FillCurrJobDetalesWindow(bNewIcons);
    });
}
function FillCurrJobDetalesWindow(bNewIcons) {
    return __awaiter(this, void 0, void 0, function* () {
        if (sCurrJob) {
            let oJobInList = aGlobJobArray.find(item => item.name == sCurrJob);
            if (!oJobInList) {
                return;
            }
            if (!oJobInList.oSideCoords) {
                const aJobSideCoords = yield JobListWithSmallDataRequest(aJobFieldsForSideCoords, [sCurrJob]);
                if (aJobSideCoords && aJobSideCoords.length === 1 && aJobSideCoords[0].opt) {
                    oJobInList.oSideCoords = aJobSideCoords[0].opt.side_coords;
                }
            }
            if (!oJobInList.oSideCoords) {
                return;
            }
            if (bNewIcons) {
                oJobInList.iconFsL = "";
                oJobInList.iconFsR = "";
            }
            SetSideDetailsInfo(domLeftUrl, domLeftSrcImg, oJobInList, 0, oJobInList.left_url, oJobInList.right_url, "left_side_details");
            SetSideDetailsInfo(domRightUrl, domRightSrcImg, oJobInList, 1, oJobInList.left_url, oJobInList.right_url, "right_side_details");
            let img = SetImg(oJobInList.direct, "var(--job-detale-img-size)", true);
            if (img) {
                domJobDirect.innerHTML = "";
                domJobDirect.append(img);
            }
        }
    });
}
function ChangeJobDirection(eDir) {
    oFCO.eJobDirection = eDir;
    if (!oFCO.bIsDialogOpen) {
        JobOptionsForChangeRequest();
    }
}
function LeftWindowLim(domLeftWindow, sWidth) {
    const nWidth = domLeftWindow.getBoundingClientRect().width;
    if (nWidth + 10 > document.documentElement.clientWidth) {
        return (document.documentElement.clientWidth - 10) + "px";
    }
    return sWidth;
}
function CreateLeftJobTable() {
    domLeftTreeWindow.innerHTML = "";
    if (pRightTableBody) {
        domRightTableWindow.innerHTML = "";
        pRightTableBody = null;
        domRightTableWindow.tabIndex = -1;
        domRightTableWindow.classList.remove("dt_lim_window");
    }
    domLeftWindow.style.flex = "0 0 " + LeftWindowLim(domLeftTreeWindow, oWebGuSettings.oJobTableParams.sLeftTableWidth);
    oWebGuSettings.oJobTableParams.bMoreInfoOpen = true;
    localStorage.setItem("oWebGuSettings", JSON.stringify(oWebGuSettings));
    domLeftImgMenu.classList.remove("panel_with_bottom_border");
    if (!sCurrJob && aGlobJobArray.length > 0) {
        ChangeCurrJob(aGlobJobArray[0].name, "");
    }
    const oLeftJobTableDTP = new TDynamicTableProperties();
    oLeftJobTableDTP.aHead = jsRightWinowsTableHead;
    oLeftJobTableDTP.domLimWindow = domLeftTreeWindow;
    oLeftJobTableDTP.bStriped = true;
    oLeftJobTableDTP.bNeedSort = true;
    oLeftJobTableDTP.fSaveColsSize = (arr) => {
        for (let i = 0; i < oLeftJobTableDTP.aTableColsWidth.length; i++) {
            if (arr[i] && arr[i] > 0) {
                oLeftJobTableDTP.aTableColsWidth[i] = arr[i];
            }
        }
        oWebGuSettings.aLeftJobTableColsSize = oLeftJobTableDTP.aTableColsWidth;
        localStorage.setItem("oWebGuSettings", JSON.stringify(oWebGuSettings));
    };
    oLeftJobTableDTP.fGetColsSizeFromLocStor = () => {
        if (oWebGuSettings.aLeftJobTableColsSize && oWebGuSettings.aLeftJobTableColsSize.length) {
            oLeftJobTableDTP.aTableColsWidth = oWebGuSettings.aLeftJobTableColsSize;
            return true;
        }
        return false;
    };
    oLeftJobTableDTP.fRowClick = function (oDepBr) {
        ChangeCurrJob(oDepBr.fGetData().name, "");
        FillRightWindow();
    };
    oLeftJobTableDTP.fRightBtn = function (e, nCurrRow, oDTP) {
        if (oDTP.aDeploedTable.length == 1) {
            ChangeCurrJob(oDTP.aDeploedTable[nCurrRow]._branch_.fGetData().name, "");
        }
        JobContextMenu(jsJobMenu, e.clientX, e.clientY, e.clientX, e.target, false, { Branch: oDTP.aDeploedTable[nCurrRow]._branch_, DTP: oDTP });
    };
    oLeftJobTableDTP.fDataProcessor = MainJobTableProc;
    oLeftJobTableDTP.root.fAddDataArr(aGlobJobArray, { sPathFieldName: "name", fDataProcessor: MainJobTableProc });
    let bIsSelRow = false;
    if (pJobListTable) {
        for (let i = 0; i < pJobListTable.fGetSelTabLen(); i++) {
            const oSelJob = oLeftJobTableDTP.root.cont.find(it => it.pathEl == pJobListTable.aDeploedTable[pJobListTable.fGetSelRowNum(i)]._branch_.pathEl);
            if (oSelJob) {
                oSelJob.bSelested = true;
                bIsSelRow = true;
            }
        }
        aOpenFoldersInJobListTable = pJobListTable.root.fGetOpenBranchFolderArr();
    }
    pJobListTable = null;
    pLeftTableBody = CreateTable(oLeftJobTableDTP);
    if (pLeftTableBody) {
        pLeftTableBody.ShowFirstSelectRow();
        if (!bIsSelRow && pLeftTableBody.root.cont) {
            if (!sCurrJob) {
                pLeftTableBody.root.cont[0].fMarkSelf(pLeftTableBody);
            }
            else {
                const oRow = pLeftTableBody.root.fFindEl(sCurrJob);
                if (oRow) {
                    oRow.fMarkSelf(pLeftTableBody);
                }
                else {
                    pLeftTableBody.root.cont[0].fMarkSelf(pLeftTableBody);
                }
            }
        }
    }
    let btnMoreInfo = document.getElementById("more_info");
    if (btnMoreInfo) {
        btnMoreInfo.innerHTML = 'Less <img src="web-ui/svg/L_Dis_Arr_Nofl.svg" alt="&#9204;" style="position:absolute; right:0; top:0; bottom:0; margin:auto">';
        btnMoreInfo.onclick = CreateLeftJobTree;
    }
    bJobTreeNarrowMode = true;
    if (sCurrJob && jsJobsTables[sCurrJob]) {
        jsJobsTables[sCurrJob].bWasStretch = false;
        jsJobsTables[sCurrJob].SetColsWidth();
    }
    MoveJobDetaleBox();
}
function SetLeftWindowWidth(sWindowName) {
    const sLeftTableWidth = domLeftWindow.style.flex.slice(4);
    if (sLeftTableWidth.endsWith("%")) {
        oWebGuSettings.oJobTableParams[sWindowName] = sLeftTableWidth;
    }
    else {
        const nWidth = Number(sLeftTableWidth.slice(0, -2));
        if (nWidth && document.documentElement.clientWidth && nWidth < document.documentElement.clientWidth) {
            oWebGuSettings.oJobTableParams[sWindowName] = (nWidth / document.documentElement.clientWidth * 100) + "%";
        }
    }
    localStorage.setItem("oWebGuSettings", JSON.stringify(oWebGuSettings));
}
function CreateLeftJobTree() {
    domLeftTreeWindow.innerHTML = "";
    domLeftWindow.style.flex = "0 0 " + LeftWindowLim(domLeftTreeWindow, oWebGuSettings.oJobTableParams.sJobListWidth);
    oWebGuSettings.oJobTableParams.bMoreInfoOpen = false;
    localStorage.setItem("oWebGuSettings", JSON.stringify(oWebGuSettings));
    domLeftImgMenu.classList.add("panel_with_bottom_border");
    if (pLeftTableBody) {
        const aSelJobs = [];
        for (let i = 0; i < pLeftTableBody.fGetSelTabLen(); i++) {
            aSelJobs.push(pLeftTableBody.aDeploedTable[pLeftTableBody.fGetSelRowNum(i)]._branch_.pathEl);
        }
        ShowMainJobTree(aSelJobs);
    }
    else {
        ShowMainJobTree();
    }
    if (pJobListTable) {
        pJobListTable.ShowFirstSelectRow();
    }
    pLeftTableBody = null;
    let btnMoreInfo = document.getElementById("more_info");
    if (btnMoreInfo) {
        btnMoreInfo.innerHTML = 'More <img src="web-ui/svg/R_Dis_Arr_Nofl.svg" alt="&#9205;" style="position:absolute; right:0; top:0; bottom:0; margin:auto">';
        btnMoreInfo.onclick = CreateLeftJobTable;
    }
    bJobTreeNarrowMode = false;
    if (sCurrJob && jsJobsTables[sCurrJob]) {
        jsJobsTables[sCurrJob].bWasStretch = false;
        jsJobsTables[sCurrJob].SetColsWidth();
    }
    MoveJobDetaleBox();
}
function SymbolsUnderline(s) {
    let i = s.indexOf("&");
    while (i >= 0) {
        if (i + 1 >= s.length) {
            return s;
        }
        switch (s.slice(i, i + 1)) {
            case ' ':
            case '\n':
            case '\t':
            case '\v':
            case '\f':
            case '\r':
            case '.':
            case ',':
            case ';': break;
            default: {
                s = s.slice(0, i) + s.slice(i + 1, i + 2) + s.slice(i + 2);
            }
        }
        i = s.indexOf("&", i + 1);
    }
    return s;
}
let domUserInfo = null;
function SetUserIdShow() {
    const sJWTToken = localStorage.getItem("sBearerToken");
    if (sJWTToken) {
        domUserInfo = document.createElement("div");
        domUserInfo.className = "user_comp_info";
        domUserAndCompInfo.appendChild(domUserInfo);
        const domUserImg = SetImg("account-16", "1.0rem");
        if (domUserImg) {
            domUserInfo.append(domUserImg);
        }
        const token_parts = sJWTToken.split(".");
        if (token_parts.length > 2) {
            token_parts.pop();
            let sTokenPayload = atob(token_parts.pop());
            ;
            try {
                const jwtTokenPayload = JSON.parse(sTokenPayload);
                if (jwtTokenPayload.loggedInAs) {
                    domUserInfo.append(jwtTokenPayload.loggedInAs.toLowerCase());
                }
            }
            catch (e) {
                console.log("Bad JWT Token payload", e);
            }
        }
    }
}
function MoveJobDetaleBox() {
    if (domCurrJobName.getBoundingClientRect().right > domUserAndCompInfo.getBoundingClientRect().left) {
        domLowBox.appendChild(domCurrJobInfo);
        domRightImgMenu.classList.remove("panel_with_bottom_border");
        domCurrJobInfo.classList.add("panel_with_bottom_border");
    }
    else {
        domUpperBox.appendChild(domCurrJobInfo);
        domRightImgMenu.classList.add("panel_with_bottom_border");
        domCurrJobInfo.classList.remove("panel_with_bottom_border");
    }
}
function SetLayout() {
    PreauthByCookieProcess();
    CreateImgButtonBar(jsLeftImgMenu, domLeftImgMenu, { bDontClearContainer: true, sImgSizeH: "2rem", sImgSizeW: "3rem", sClass: "big_button" });
    DisableClassEl("common_auto_off");
    DisableClassEl("common_auto_on");
    DisableClassEl("account_sync_off");
    DisableClassEl("account_sync_on");
    SetMainMenu(domMainMenu, jsMainMenu);
    const domHtmlErrPlace = document.createElement("div");
    domHtmlErrPlace.style.flex = "1 1 100%";
    domMainMenu.append(domHtmlErrPlace);
    const sGsComputerId = GetCookieByName("jscompid");
    if (sGsComputerId) {
        const domServerInfo = document.createElement("div");
        domServerInfo.className = "user_comp_info";
        domUserAndCompInfo.appendChild(domServerInfo);
        const domCompImg = SetImg("Connection", "1.2rem");
        if (domCompImg) {
            domServerInfo.append(domCompImg);
        }
        domServerInfo.append(sGsComputerId);
        DeleteCookie("jscompid");
    }
    DisableClassEl("accaunt_on");
    DisableClassEl("auto_run_on");
    CreateImgButtonBar(jsRightLeftImgMenu, domRightLeftImgMenu, { sImgSizeH: "1.75rem", sClass: "big_button" });
    CreateImgButtonBar(jsRightRightImgMenu, domRightRightImgMenu, { sImgSizeH: "1.75rem", sClass: "big_button" });
    CreateImgButtonBar(jsGroupImgMenu, domGroupBigButtons, { sImgSizeH: "1.75rem", sClass: "big_button" });
    DeactivateClassEl("settings_btn");
    DeactivateClassEl("btn_sync_and_analize");
    DisableClassEl("btn_path_change");
    DisableClassEl("btn_stop_job");
    DisableClassEl("auto_on");
    DisableClassEl("auto_off");
    NewsPolling();
    if (oWebGuSettings.oJobTableParams.bLogWinOpen) {
        OpenLog();
    }
    Authentication();
    ChangeCurrJob("", "");
    SetStretchEl();
    domLeftWindow.style.flex = "0 0 " + oWebGuSettings.oJobTableParams.sJobListWidth;
}
function SetLayoutWitLangPage(nDel = 100) {
    if (bLangPageDownloadFinished || nDel > 1000) {
        SetLayout();
    }
    else {
        setTimeout(() => {
            SetLayoutWitLangPage(nDel + 100);
        }, nDel);
    }
}
