"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
class TBookmark {
    constructor() {
        this.sServerDirA = "";
        this.sAcctKeyA = "";
        this.opts = new TOpts;
        this.BmkKey = "";
    }
}
class TConn {
    constructor() {
        this.sUrlA = "";
        this.sUserIdA = "";
        this.sPasswordEncMasterA = "";
        this.sPrivateKeyPath = "";
        this.sStorageClassA = "";
        this.sAccessPolicyA = "";
        this.sPrivateKeyEncMasterA = "";
        this.sRefreshTokenA = "";
        this.sRefreshTokenEncMasterA = "";
        this.sUserEmailA = "";
        this.sGeoLocationA = "";
        this.sDisplayNameA = "";
        this.sServerEncrKeyA = "";
        this.sOAuthClientIdA = "";
        this.sOAuthClientSecretA = "";
        this.sOAuthRedirectUriA = "";
        this.sCommentA = "";
        this.bActiveMode = false;
        this.bUseMDTM = false;
        this.bUseMLSD = false;
        this.bEncodeUTF8 = false;
        this.bIgnoreBadCerts = false;
        this.bImplicitMode = false;
        this.bHostBasedAddr = false;
        this.bUseProxy = false;
        this.bWinInet = false;
        this.bReducedRedundancy = false;
        this.bInfrequentAccess = false;
        this.bServerSideEncryption = false;
        this.bUseListLA = false;
        this.bMoveLevelOnly = false;
        this.bUsGovCloud = false;
        this.bDataConnSessionReuse = false;
        this.bGraphGroupReadPermissions = false;
        this.bGraphDirectoryReadPerms = false;
        this.bGstpPlainDirect = false;
        this.bRequireCheckSum = false;
        this.bCacheFileModTime = false;
        this.bUseEPSV = false;
        this.bCnICloud = false;
        this.bDirectOnlyServer = false;
        this.bExportNativeDocs = false;
        this.bGraphMultiTenantReadPerms = false;
        this.bHasCheckedIn = false;
        this.nUploadChunksThreads = 0;
        this.tLastSeen = 0;
    }
}
class TOpts {
    constructor() {
        this.bUseTmpDestFile = false;
        this.bTrustStateFile = false;
        this.bNoGsData = false;
        this.nCompressType = 0;
        this.nCipherType = 0;
        this.bEncryptBodies = false;
        this.bEncryptPaths = false;
        this.sEncryptionPasswdGarbledA = "";
        this.sEncryptionPasswdEncMasterA = "";
        this.bPreferCompressed = false;
        this.bPreferEncrypted = false;
        this.bFatLike = false;
        this.bUnMountOnDisconnect = false;
        this.bCompareCheckSums = false;
        this.bCompareAttrs = false;
        this.bCompareOwner = false;
        this.bCompareACL = false;
        this.bCompareExtendedAttrs = false;
        this.nFilePerms = 0;
        this.nFolderPerms = 0;
    }
}
class TFolderCoords {
    constructor() {
        this.conn = new TConn;
        this.sAcctKeyA = "";
    }
}
let sAuthentication = "";
let bStopNewsPolling = false;
let bShowHiddenFs = false;
let sBearerToken = localStorage.getItem("sBearerToken");
let sLocPathName = '/web-ui';
const bIsLocalhost = location.pathname === sLocPathName;
let request_url = bIsLocalhost ? location.origin : location.origin + location.pathname;
const aZInd = [];
let wasStretchEl = false;
let nFloatMenuX = 0, nFloatMenuY = 0;
const domModal = document.getElementById("my_modal");
let sCurrJob = "";
const aDropMenus = [];
const rem2px = parseFloat(getComputedStyle(document.documentElement).fontSize);
let bStopDeselect = false;
let bDebugMode = false;
let isMouseIntoLogWindow = false;
let isMouseIntoLeftWindow = false;
let isMouseIntoRightTableWindow = false;
let domBtnGoToLastLog = document.getElementById("go_to_last_log");
let domForSearching = null;
document.onclick = function () {
    bAutoShowDropMenu = false;
    if (oLastButton) {
        oLastButton.className = "img_btn_bar nonselect";
    }
    DeleteAllDropMenu();
};
document.onmousedown = function () {
    document.onmouseup = BaseMouseUp;
};
document.onmouseup = BaseMouseUp;
document.onmouseleave = BaseMouseUp;
function AllUserResize() {
    const aUserResizeEls = document.getElementsByClassName("I_have_user_resise");
    for (const it of aUserResizeEls) {
        const itWithUR = it;
        if (itWithUR.fUserResize)
            itWithUR.fUserResize();
    }
}
window.onresize = function () {
    AllUserResize();
    DeleteAllDropMenu();
    DrawDrag();
};
window.addEventListener("keydown", (e) => {
    if (e.ctrlKey && e.altKey) {
        switch (e.code) {
            case 'KeyL':
                {
                    const domJobSumm = document.getElementById("real_summary_info");
                    if (domJobSumm) {
                        if (domJobSumm.style.display == "none")
                            domJobSumm.style.display = "";
                        else
                            domJobSumm.style.display = "none";
                    }
                }
                break;
            case 'KeyD':
                {
                    bDebugMode = !bDebugMode;
                    if (!bDebugMode) {
                        debug_info.innerHTML = "";
                    }
                }
                break;
            case 'KeyS':
                {
                    bStopUpdateJobTable = !bStopUpdateJobTable;
                }
                break;
            case 'KeyP':
                {
                    bStopNewsPolling = !bStopNewsPolling;
                }
                break;
        }
    }
    else if (e.ctrlKey) {
        switch (e.code) {
            case "KeyF":
                {
                    const aDom = document.getElementsByClassName("text_for_searching");
                    if (aDom.length === 1 && "value" in aDom[0] && domForSearching) {
                        const sSel = GetSelectTextInElement(domForSearching);
                        if (sSel) {
                            aDom[0].value = sSel;
                        }
                        if (!aDom[0].value)
                            return;
                        if (oMenuRegister.IsSomeMenu()) {
                            const oLastMenu = oMenuRegister.GetPrevMenu();
                            if (oLastMenu.fFind) {
                                oLastMenu.fFind();
                            }
                        }
                        e.preventDefault();
                    }
                }
                break;
        }
    }
    else {
        switch (e.code) {
            case "Escape":
                {
                    if (aDropMenus.length > 1) {
                        aDropMenus[aDropMenus.length - 2].fRemoveSubmenu();
                        aDropMenus.splice(aDropMenus.length - 1);
                        e.preventDefault();
                    }
                    else if (aDropMenus.length > 0) {
                        DeleteAllDropMenu();
                        e.preventDefault();
                    }
                    else if (oMenuRegister.IsSomeMenu()) {
                        oMenuRegister.GetPrevMenu().fCloseMenu(true);
                        e.preventDefault();
                    }
                }
                break;
            case "Enter":
                {
                    const focusedElement = document.activeElement;
                    if (aDropMenus.length > 0) {
                        aDropMenus[aDropMenus.length - 1].fKeyDown(e);
                    }
                    else if (oMenuRegister.IsSomeMenu()) {
                        const oLastMenu = oMenuRegister.GetPrevMenu();
                        if (focusedElement && oLastMenu.contains(focusedElement)) {
                            if ("fKeyDown" in focusedElement && typeof focusedElement.fKeyDown == 'function') {
                                focusedElement.fKeyDown(e);
                                return;
                            }
                            if (focusedElement.tagName.toLowerCase() == 'button') {
                                focusedElement.dispatchEvent(new Event('click'));
                                e.preventDefault();
                                return;
                            }
                        }
                        if (oLastMenu.fUserKeyDown) {
                            oLastMenu.fUserKeyDown(e);
                        }
                    }
                    else if (focusedElement && "fKeyDown" in focusedElement && typeof focusedElement.fKeyDown == 'function') {
                        focusedElement.fKeyDown(e);
                    }
                }
                break;
            case "ArrowLeft":
            case "ArrowRight":
                {
                }
                break;
            case "ArrowUp":
            case "ArrowDown":
                {
                    const focusedElement = document.activeElement;
                    if (aDropMenus.length > 0) {
                        aDropMenus[aDropMenus.length - 1].fUpAndDown(e);
                    }
                    else if (oMenuRegister.IsSomeMenu()) {
                        const oLastMenu = oMenuRegister.GetPrevMenu();
                        if (focusedElement && oLastMenu.contains(focusedElement) && "fKeyDown" in focusedElement && typeof focusedElement.fKeyDown == 'function') {
                            focusedElement.fKeyDown(e);
                        }
                        else if (oLastMenu.domLeftWin && oLastMenu.domLeftWin.children.length > 1) {
                            if (e.code == "ArrowUp") {
                                oLastMenu.nVertItem--;
                                if (oLastMenu.nVertItem < 0) {
                                    oLastMenu.nVertItem = oLastMenu.domLeftWin.children.length - 2;
                                }
                            }
                            else {
                                oLastMenu.nVertItem++;
                                if (oLastMenu.nVertItem + 1 >= oLastMenu.domLeftWin.children.length) {
                                    oLastMenu.nVertItem = 0;
                                }
                            }
                            oLastMenu.domLeftWin.children[oLastMenu.nVertItem].dispatchEvent(new Event('click'));
                        }
                    }
                    else {
                        if (focusedElement && "fKeyDown" in focusedElement && typeof focusedElement.fKeyDown == 'function') {
                            focusedElement.fKeyDown(e);
                        }
                    }
                    e.preventDefault();
                }
                break;
            case "Tab":
                {
                    DeleteAllDropMenu();
                    if (oMenuRegister.IsSomeMenu()) {
                        e.preventDefault();
                        const oCurrMenu = oMenuRegister.GetPrevMenu();
                        let aFocusableEls = GetFocusableEls(oCurrMenu);
                        const focusedElement = document.activeElement;
                        let nFEIndex = -1;
                        if (focusedElement) {
                            nFEIndex = aFocusableEls.indexOf(focusedElement);
                        }
                        if (nFEIndex < 0) {
                            nFEIndex = 0;
                        }
                        else {
                            if (e.shiftKey) {
                                nFEIndex--;
                                if (nFEIndex < 0) {
                                    nFEIndex = aFocusableEls.length - 1;
                                }
                            }
                            else {
                                nFEIndex++;
                                if (nFEIndex >= aFocusableEls.length) {
                                    nFEIndex = 0;
                                }
                            }
                        }
                        aFocusableEls[nFEIndex].focus();
                    }
                }
                break;
            default: {
                if (isMouseIntoLogWindow) {
                    KeyIntercept(e, domRightBottomWindow);
                }
                else if (isMouseIntoLeftWindow) {
                    KeyIntercept(e, domLeftTreeWindow);
                }
                else if (isMouseIntoRightTableWindow) {
                    KeyIntercept(e, domRightTableWindow);
                }
            }
        }
    }
});
function BaseMouseUp(e) {
    ResetGlobData();
    let aWasResizeEl = document.getElementsByClassName("I_have_user_resise");
    for (let item of aWasResizeEl) {
        const oDomPlus = item;
        if (oDomPlus.fUserResize) {
            oDomPlus.fUserResize();
        }
    }
    if (bStopDeselect) {
        bStopDeselect = false;
    }
    else {
        const aDinTableBodys = document.getElementsByClassName("ResetSelectIfClickOut");
        for (const it of aDinTableBodys) {
            const table = it.pTable;
            if (table) {
                const rect = table.domLimWindow.getBoundingClientRect();
                if (e.clientX < rect.left || e.clientX > rect.right || e.clientY < rect.top || e.clientY > rect.bottom) {
                    table.fSelTabClean();
                    table.ShowRows();
                }
            }
        }
    }
}
function IsObject(obj) {
    return Object.prototype.toString.call(obj) === '[object Object]';
}
function SetClassFilexWidth(className, width) {
    let arr = document.getElementsByClassName(className);
    for (const item of arr) {
        const tmp = item;
        tmp.style.flex = "0 0 " + width;
    }
}
function SetClassWidth(className, width) {
    let arr = document.getElementsByClassName(className);
    for (let item of arr) {
        const tmp = item;
        tmp.style.width = width;
    }
}
function DeleteAllClassEl(sClassName) {
    let dmArr = document.getElementsByClassName(sClassName);
    for (let i = dmArr.length - 1; i >= 0; i--) {
        const fOnCloseFunc = dmArr[i].fOnClose;
        if (fOnCloseFunc)
            fOnCloseFunc();
        dmArr[i].remove();
    }
}
function ResizeFlexWindow(el, nResizeNum, parentSize) {
    let tmpSize = Number(el.style.flexBasis.slice(0, -2));
    if ((tmpSize + nResizeNum) < MIN_WIN_SIZE) {
        el.style.flexBasis = MIN_WIN_SIZE + "px";
    }
    else if ((tmpSize + nResizeNum + MIN_WIN_SIZE) > parentSize) {
        el.style.flexBasis = (parentSize - MIN_WIN_SIZE) + "px";
    }
    else {
        el.style.flexBasis = (tmpSize + nResizeNum) + "px";
    }
}
function Nothing() { }
;
function GetAttribute(sHtml, sAttributeName) {
    const regex = new RegExp(`${sAttributeName}="(.*?)"`, "i");
    const match = sHtml.match(regex);
    return match ? match[1] : "";
}
function GetDynamicSvg(s) {
    return DynamicSvg[s];
}
function SetImg(param, h, bAbsPos, w) {
    if (!param)
        param = "-";
    else if (DynamicSvg[param])
        param = DynamicSvg[param];
    else if (jsPictTable[param])
        param = jsPictTable[param];
    if (!w)
        w = h;
    if (param.slice(0, 1) == ".") {
        let svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        svg.setAttributeNS(null, 'width', "16px");
        svg.setAttributeNS(null, 'height', "16px");
        svg.setAttributeNS(null, 'style', `width:${w}; min-width:${w}; max-width:${w}; height:${h};`);
        svg.setAttributeNS(null, 'viewBox', '0 0 16 16');
        svg.innerHTML = GetFileTypeSvg(param.slice(1));
        if (bAbsPos) {
            svg.classList.add("abs_pos_img");
        }
        return svg;
    }
    else if (param.slice(0, 4) == "<svg") {
        const svgEnd = param.indexOf("</svg>");
        const innerSvgStart = param.indexOf("<", 4);
        const sSvgParams = param.slice(4, innerSvgStart);
        let wbStart = sSvgParams.indexOf("viewBox");
        wbStart = sSvgParams.indexOf("\"", wbStart + 7);
        let wbEnd = sSvgParams.indexOf("\"", wbStart + 1);
        const sVB = sSvgParams.slice(wbStart + 1, wbEnd);
        const values = sVB.split(' ');
        if (values.length !== 4) {
            return;
        }
        const width = values[2], height = values[3];
        const sFill = GetAttribute(sSvgParams, "fill");
        const sStroke = GetAttribute(sSvgParams, "stroke");
        let svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
        svg.setAttributeNS(null, 'width', width);
        svg.setAttributeNS(null, 'height', height);
        svg.setAttributeNS(null, 'viewBox', sVB);
        svg.setAttributeNS(null, 'style', `height:${h};min-width:${w};max-width:${w};`);
        if (sFill)
            svg.setAttributeNS(null, 'fill', sFill);
        if (sStroke)
            svg.setAttributeNS(null, 'stroke', sStroke);
        svg.innerHTML = param.slice(innerSvgStart, svgEnd);
        if (bAbsPos) {
            svg.classList.add("abs_pos_img");
        }
        return svg;
    }
    let img = document.createElement("img");
    img.style.height = h;
    img.style.minWidth = w;
    img.style.maxWidth = w;
    img.src = location.origin + param;
    img.alt = param;
    if (bAbsPos) {
        img.style.margin = 'auto';
        img.style.position = 'absolute';
        img.style.inset = "0";
    }
    return img;
}
function GetDTString(xTime, nFormat) {
    const nTime = Number(xTime);
    if (!Number.isInteger(nTime))
        return xTime + "";
    if (nTime == -1)
        return "";
    const time = new Date(nTime * 1000);
    switch (nFormat) {
        case "woTime": return time.toLocaleDateString(oWebGuSettings.sLocal, { year: 'numeric', month: 'numeric', day: 'numeric' });
        case "woDate": return time.toLocaleTimeString(oWebGuSettings.sLocal, { hour12: false });
        case "shortFull": return time.toLocaleDateString(oWebGuSettings.sLocal, { year: 'numeric', month: 'numeric', day: 'numeric' }) + ", "
            + time.toLocaleTimeString(oWebGuSettings.sLocal);
        default: return time.toLocaleDateString(oWebGuSettings.sLocal, { year: 'numeric', month: 'numeric', day: 'numeric' }) + ", "
            + time.toLocaleTimeString(oWebGuSettings.sLocal);
    }
}
function GetHmsWithMilliseconds(dt) {
    return dt.toLocaleTimeString('en-US', { hour12: false }) + "." + dt.getMilliseconds().toString().padStart(3, '0');
}
function GetJobStatusString(obj) {
    if (!obj)
        return "";
    return "last_run_time=<span class='mark_text'>" + GetDTString(obj.last_run_time) + "</span>" +
        ", sErr=\"<span class='mark_text'>" + obj.sErr + "</span>" +
        "\", sAttentionMsgA=\"<span class='mark_text'>" + obj.sAttentionMsgA + "</span>" +
        "\", nItemsSyncedOK=<span class='mark_text'>" + obj.nItemsSyncedOK + "</span>" +
        ", nChangesSyncedOK=<span class='mark_text'>" + obj.nChangesSyncedOK + "</span>" +
        ", nItemsChanged=<span class='mark_text'>" + obj.nItemsChanged + "</span>" +
        ", nItemsError=<span class='mark_text'>" + obj.nItemsError + "</span>" +
        ", nItemsConflict=<span class='mark_text'>" + obj.nItemsConflict + "</span>" +
        ", job_run_state=<span class='mark_text'>" + obj.job_run_state + "</span>" +
        ", job_result=<span class='mark_text'>" + obj.job_result + "</span>" +
        ", sCurrMsg_L=<span class='mark_text'>" + obj.sCurrMsg_L + "</span>" +
        ", sCurrMsg_R=<span class='mark_text'>" + obj.sCurrMsg_R + "</span>" +
        ", tree_tag=<span class='mark_text'>" + obj.tree_tag + "</span>";
}
function ChangeCurrJob(s, sGroupName) {
    const sPrevJob = sCurrJob;
    sCurrJob = s;
    if (bLastPrevSessionJobWasOpend) {
        oWebGuSettings.sCurrJob = s;
        oWebGuSettings.sCurrGroup = sGroupName;
        localStorage.setItem("oWebGuSettings", JSON.stringify(oWebGuSettings));
    }
    DisableClassEl("btn_stop_job");
    if (s == "") {
        domRightImgMenu.style.display = "none";
        domCurrJobInfo.style.display = "none";
        DeactivateClassEl("btn_sync_and_analize");
        DeactivateClassEl("settings_btn");
        DisableClassEl("auto_on");
        DisableClassEl("auto_off");
    }
    else {
        domRightImgMenu.style.display = "";
        domCurrJobInfo.style.display = "";
        domGroupTopMenu.style.display = "none";
        DeactivateClassEl("btn_sync");
        if (IsJobReadyToAnalize(s)) {
            ActivateClassEl("btn_analize");
        }
        else {
            DeactivateClassEl("btn_analize");
        }
        if (IsJobHaveAuto(s)) {
            DisableClassEl("auto_off");
            EnableClassEl("auto_on");
        }
        else {
            EnableClassEl("auto_off");
            DisableClassEl("auto_on");
        }
        ActivateClassEl("settings_btn");
    }
    if (sPrevJob != s) {
        domCurrJobName.innerHTML = sCurrJob;
        RewriteLogSettings();
    }
}
function KeyIntercept(e, domEl) {
    if (e.code == "Home") {
        domEl.scrollTop = 0;
        e.preventDefault();
    }
    else if (e.code == "End") {
        domEl.scrollTop = domEl.scrollHeight - domEl.clientHeight;
        e.preventDefault();
    }
    else if (e.code == "PageUp") {
        domEl.scrollTop -= domEl.clientHeight - 30;
        e.preventDefault();
    }
    else if (e.code == "PageDown") {
        domEl.scrollTop += domEl.clientHeight - 30;
        e.preventDefault();
    }
}
function ToLocaleNumber(n, sFormat) {
    if (n === "" || n === " " || typeof n != 'number' && !n)
        return "";
    if (isNaN(+n))
        return n;
    if (sFormat == "") {
        return Number(n).toLocaleString();
    }
    return Number(n).toLocaleString(sFormat);
}
function GetPercent(s) {
    if (typeof s != "string") {
        return null;
    }
    const aMatch = s.trim().match(/-?\d+\.?\d*%/);
    if (!aMatch || aMatch.length == 0) {
        return null;
    }
    let nProc = Number(aMatch[0].replace("%", ""));
    if (!Number.isNaN(nProc))
        return nProc;
    return null;
}
function compareNum(a, b) {
    if (a > b)
        return 1;
    if (a < b)
        return -1;
    return 0;
}
var eMyConfDefBtn;
(function (eMyConfDefBtn) {
    eMyConfDefBtn[eMyConfDefBtn["none"] = 0] = "none";
    eMyConfDefBtn[eMyConfDefBtn["ok"] = 1] = "ok";
    eMyConfDefBtn[eMyConfDefBtn["cancel"] = 2] = "cancel";
})(eMyConfDefBtn || (eMyConfDefBtn = {}));
;
function HtmlConfirm(sText, sTitle, nDefineButton, oParams) {
    return new Promise(function (resolve, reject) {
        if (!sTitle)
            sTitle = "";
        let sOk = "Btn_Ok";
        let sCancel = "Btn_Cancel";
        if (oParams && oParams.ok)
            sOk = oParams.ok;
        if (oParams && oParams.cancel)
            sCancel = oParams.cancel;
        let jsConfirm = {
            "title": sTitle,
            "bottom_box": [
                { "title": sOk, "close": true, "command": "save and exec" },
                { "title": sCancel, "close": true }
            ],
            cont: [
                { "title": "", cont: [
                        { type: "row", h: "5px" },
                        { type: "text", "title": sText, w_s: "normal" }
                    ] }
            ]
        };
        if (!oParams) {
            oParams = {};
        }
        if (nDefineButton == eMyConfDefBtn.ok) {
            jsConfirm.bottom_box[0].default = true;
        }
        else if (nDefineButton == eMyConfDefBtn.cancel) {
            jsConfirm.bottom_box[1].default = true;
        }
        let width = "30%";
        if (oParams.nWidth && oParams.nWidth > 0 && document.documentElement.clientWidth > 800) {
            let nScale = 100 * oParams.nWidth / document.documentElement.clientWidth;
            if (nScale > 80) {
                oParams.nWidth = document.documentElement.clientWidth - 100;
            }
            width = oParams.nWidth + "px";
        }
        const jsMFParams = {
            "fontSize": oParams.sFontSize,
            icon: oParams.icon,
            lineHeight: oParams.lineHeight,
            bCurrJobName: !oParams.bNoCurrJobName,
            class: oParams.class
        };
        if (!jsMFParams.lineHeight) {
            jsMFParams.lineHeight = "1.5";
        }
        CreateFloatMenu(jsConfirm, { top: "20%", width }, null, jsMFParams).promise
            .then(result => resolve(result.data)).catch(error => reject(error));
    });
}
function AsyncHtmlConfirm(sText, sTitle, nDefineButton, oParams) {
    return __awaiter(this, void 0, void 0, function* () {
        if (!sTitle)
            sTitle = "";
        let sOk = "Btn_Ok";
        let sCancel = "Btn_Cancel";
        if (oParams && oParams.ok)
            sOk = oParams.ok;
        if (oParams && oParams.cancel)
            sCancel = oParams.cancel;
        let jsConfirm = {
            "title": sTitle,
            "bottom_box": [
                { "title": sOk, "close": true, "command": "save and exec" },
                { "title": sCancel, "close": true }
            ],
            cont: [
                { "title": "", cont: [
                        { type: "row", h: "5px" },
                        { type: "text", "title": sText, w_s: "normal" }
                    ] }
            ]
        };
        if (!oParams) {
            oParams = {};
        }
        if (nDefineButton == eMyConfDefBtn.ok) {
            jsConfirm.bottom_box[0].default = true;
        }
        else if (nDefineButton == eMyConfDefBtn.cancel) {
            jsConfirm.bottom_box[1].default = true;
        }
        let width = "30%";
        if (oParams.nWidth && oParams.nWidth > 0 && document.documentElement.clientWidth > 800) {
            let nScale = 100 * oParams.nWidth / document.documentElement.clientWidth;
            if (nScale > 80) {
                oParams.nWidth = document.documentElement.clientWidth - 100;
            }
            width = oParams.nWidth + "px";
        }
        const jsMFParams = { "fontSize": oParams.sFontSize };
        jsMFParams.bCurrJobName = !oParams.bNoCurrJobName;
        if (oParams.icon) {
            jsMFParams.icon = oParams.icon;
        }
        if (oParams.lineHeight) {
            jsMFParams.lineHeight = oParams.lineHeight;
        }
        else {
            jsMFParams.lineHeight = "1.5";
        }
        try {
            yield CreateFloatMenu(jsConfirm, { top: "20%", width }, null, jsMFParams).promise;
        }
        catch (error) {
            throw "";
        }
    });
}
function HtmlMsgbox(sText, sTitle = "", oParams) {
    let jsConfirm = {
        "title": sTitle,
        "bottom_box": [
            { "title": "OK", "close": true, default: true },
        ],
        cont: [
            { "title": "", cont: [
                    { type: "row", cont: [
                            { type: "text", title: sText, w_s: "normal", lineHeight: "1.5" },
                        ] },
                ] }
        ]
    };
    if (!oParams) {
        oParams = {};
    }
    if (oParams.icon) {
        jsConfirm.cont[0].cont[0].cont.splice(0, 0, { type: "img", title: "", value: oParams.icon, w: "var(--img-for-msgbox-size)", class: "confirm_body_img" });
    }
    let width = "30%";
    if (oParams.nWidth && oParams.nWidth > 0 && document.documentElement.clientWidth > 800) {
        let nScale = 100 * oParams.nWidth / document.documentElement.clientWidth;
        if (nScale > 80) {
            oParams.nWidth = document.documentElement.clientWidth - 100;
        }
        width = oParams.nWidth + "px";
    }
    CreateFloatMenu(jsConfirm, { top: "20%", width }, null, { "fontSize": oParams.sFontSize, "bCurrJobName": !oParams.bNoCurrJobName, "class": oParams.class })
        .promise.then(() => { }).catch(() => { });
}
function ResetGlobData() {
    sgd.globX = -1;
    sgd.globY = -1;
    sgd.baseWidth = -1;
    sgd.baseHeight = -1;
    sgd.pad = 0;
    document.onmousemove = null;
    document.body.style.cursor = "default";
    SetStretchEl();
}
function GetWaitigEl() {
    return '<div class="waiting_clock"><div class="waiting_hand waiting_hour"></div><div class="waiting_hand waiting_minute"></div></div>';
}
function SetWaitingSimbols1(out, n) {
    n = n % 16;
    switch (n) {
        case 0:
            out.innerHTML = "&#9724;&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;";
            break;
        case 1:
            out.innerHTML = "&#9724;&#9724;&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;";
            break;
        case 2:
            out.innerHTML = "&#9724;&#9724;&#9724;&#9723;&#9723;&#9723;&#9723;&#9723;";
            break;
        case 3:
            out.innerHTML = "&#9724;&#9724;&#9724;&#9724;&#9723;&#9723;&#9723;&#9723;";
            break;
        case 4:
            out.innerHTML = "&#9724;&#9724;&#9724;&#9724;&#9724;&#9723;&#9723;&#9723;";
            break;
        case 5:
            out.innerHTML = "&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;&#9723;&#9723;";
            break;
        case 6:
            out.innerHTML = "&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;&#9723;";
            break;
        case 7:
            out.innerHTML = "&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;";
            break;
        case 8:
            out.innerHTML = "&#9723;&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;";
            break;
        case 9:
            out.innerHTML = "&#9723;&#9723;&#9724;&#9724;&#9724;&#9724;&#9724;&#9724;";
            break;
        case 10:
            out.innerHTML = "&#9723;&#9723;&#9723;&#9724;&#9724;&#9724;&#9724;&#9724;";
            break;
        case 11:
            out.innerHTML = "&#9723;&#9723;&#9723;&#9723;&#9724;&#9724;&#9724;&#9724;";
            break;
        case 12:
            out.innerHTML = "&#9723;&#9723;&#9723;&#9723;&#9723;&#9724;&#9724;&#9724;";
            break;
        case 13:
            out.innerHTML = "&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;&#9724;&#9724;";
            break;
        case 14:
            out.innerHTML = "&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;&#9724;";
            break;
        case 15:
            out.innerHTML = "&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;&#9723;";
            break;
    }
}
function IsClassElEnable(sClassName) {
    let aEls = document.getElementsByClassName(sClassName);
    for (const iBtn of aEls) {
        if (iBtn.style.display == "none")
            return false;
    }
    return true;
}
function DisableClassEl(sClassName) {
    let aEls = document.getElementsByClassName(sClassName);
    for (const iBtn of aEls) {
        iBtn.style.display = "none";
    }
}
function EnableClassEl(sClassName) {
    let aEls = document.getElementsByClassName(sClassName);
    for (const iBtn of aEls) {
        iBtn.style.display = "";
    }
}
function ActivateClassEl(sClassName) {
    let aEls = document.getElementsByClassName(sClassName);
    for (const iBtn of aEls) {
        iBtn.classList.remove("dead_btn");
        if ("disabled" in iBtn && iBtn.disabled) {
            iBtn.disabled = false;
        }
    }
}
function DeactivateClassEl(sClassName) {
    let aEls = document.getElementsByClassName(sClassName);
    for (const iBtn of aEls) {
        iBtn.classList.add("dead_btn");
        if ("disabled" in iBtn) {
            iBtn.disabled = true;
        }
    }
}
function ActivateElById(sId) {
    let el = document.getElementById(sId);
    if (el) {
        el.classList.remove("dead_btn");
        if ("disabled" in el && el.disabled) {
            el.disabled = false;
        }
    }
}
function DeactivateElById(sId) {
    let el = document.getElementById(sId);
    if (el) {
        el.classList.add("dead_btn");
        if ("disabled" in el) {
            el.disabled = true;
        }
    }
}
function IsClassElActive(sClassName) {
    let aEls = document.getElementsByClassName(sClassName);
    for (const iBtn of aEls) {
        if (iBtn.classList.contains("dead_btn"))
            return false;
    }
    return true;
}
function CopyObject(o) {
    const ret = {};
    for (let key in o) {
        if (IsObject(o[key])) {
            ret[key] = CopyObject(o[key]);
        }
        else if (Array.isArray(o[key])) {
            ret[key] = CopyArray(o[key]);
        }
        else {
            ret[key] = o[key];
        }
    }
    return ret;
}
function CopyArray(a) {
    const ret = [];
    for (let i = 0; i < a.length; i++) {
        if (IsObject(a[i])) {
            ret[i] = CopyObject(a[i]);
        }
        else if (Array.isArray(a[i])) {
            ret[i] = CopyArray(a[i]);
        }
        else {
            ret[i] = a[i];
        }
    }
    return ret;
}
function CopyEqSizeArray(src, dst) {
    for (let i = 0; i < src.length; i++) {
        dst[i] = src[i];
    }
}
var eSidePriority;
(function (eSidePriority) {
    eSidePriority[eSidePriority["left"] = 0] = "left";
    eSidePriority[eSidePriority["right"] = 1] = "right";
})(eSidePriority || (eSidePriority = {}));
function CompareObjs(obj1, obj2, aNames, nSidePriority) {
    if (obj1 === obj2) {
        return {};
    }
    if (aNames.length == 0) {
        aNames = ["obj1", "obj2"];
    }
    else if (aNames.length == 1) {
        aNames.push("obj2");
    }
    if (typeof obj1 !== typeof obj2 || (obj1 === null && obj2 !== null) || (obj1 !== null && obj2 === null)) {
        return { [aNames[0]]: obj1, [aNames[1]]: obj2 };
    }
    let keys1 = [];
    let keys2 = [];
    if (nSidePriority != eSidePriority.right) {
        keys1 = Object.keys(obj1);
    }
    if (nSidePriority != eSidePriority.left) {
        keys2 = Object.keys(obj2);
    }
    const allKeys = [...new Set([...keys1, ...keys2])];
    const result = {};
    for (const key of allKeys) {
        if (!(key in obj1)) {
            if (nSidePriority != eSidePriority.left) {
                result[key] = { [aNames[1]]: obj2[key] };
            }
        }
        else if (!(key in obj2)) {
            if (nSidePriority != eSidePriority.right) {
                result[key] = { [aNames[0]]: obj1[key] };
            }
        }
        else if (typeof obj1[key] === 'function' && typeof obj2[key] === 'function') {
            if (obj1[key].name !== obj2[key].name) {
                result[key] = { bIsFunction: true, [aNames[0]]: obj1[key].name, [aNames[1]]: obj2[key].name };
            }
        }
        else if (Array.isArray(obj1[key]) && Array.isArray(obj2[key])) {
            const arrayDiff = compareArrays(obj1[key], obj2[key], aNames, nSidePriority);
            if (Object.keys(arrayDiff).length > 0) {
                result[key] = arrayDiff;
            }
        }
        else if (typeof obj1[key] === 'object' && typeof obj2[key] === 'object') {
            const nestedDiff = CompareObjs(obj1[key], obj2[key], aNames, nSidePriority);
            if (Object.keys(nestedDiff).length > 0) {
                result[key] = nestedDiff;
            }
        }
        else if (obj1[key] !== obj2[key]) {
            result[key] = { [aNames[0]]: obj1[key], [aNames[1]]: obj2[key] };
        }
    }
    return result;
}
function compareArrays(arr1, arr2, aNames, nSidePriority) {
    const result = [];
    if (!aNames || aNames.length == 0) {
        aNames = ["obj1", "obj2"];
    }
    else if (aNames.length == 1) {
        aNames.push("obj2");
    }
    const nLim = (nSidePriority == eSidePriority.left) ? arr1.length : (nSidePriority == eSidePriority.right) ? arr2.length : Math.max(arr1.length, arr2.length);
    for (let i = 0; i < nLim; i++) {
        if (i >= arr1.length) {
            result.push({ "__ind__": i, [aNames[1]]: arr2[i] });
        }
        else if (i >= arr2.length) {
            result.push({ "__ind__": i, [aNames[0]]: arr1[i] });
        }
        else if (Array.isArray(arr1[i]) && Array.isArray(arr2[i])) {
            const nestedDiff = compareArrays(arr1[i], arr2[i], aNames, nSidePriority);
            if (Object.keys(nestedDiff).length > 0) {
                if (!("__ind__" in nestedDiff)) {
                    nestedDiff.__ind__ = i;
                }
                result.push(nestedDiff);
            }
        }
        else if (typeof arr1[i] === 'function' && typeof arr2[i] === 'function') {
            if (arr1[i].name !== arr2[i].name) {
                result.push({ "__ind__": i, [aNames[0]]: arr1[i].name, [aNames[1]]: arr2[i].name });
            }
        }
        else if (typeof arr1[i] === 'object' && typeof arr2[i] === 'object') {
            const nestedDiff = CompareObjs(arr1[i], arr2[i], aNames, nSidePriority);
            if (Object.keys(nestedDiff).length > 0) {
                if (!("__ind__" in nestedDiff)) {
                    nestedDiff.__ind__ = i;
                }
                result.push(nestedDiff);
            }
        }
        else if (arr1[i] !== arr2[i]) {
            result.push({ "__ind__": i, [aNames[0]]: arr1[i], [aNames[1]]: arr2[i] });
        }
    }
    return result;
}
function ConvertBytes(totalBytes, availableBytes) {
    const units = ['kB', 'MB', 'GB', 'TB',];
    const biMaxNum = BigInt(1000000);
    const biDivider = BigInt(1000);
    let nTotalSign = BigInt(1);
    let total = BigInt(totalBytes);
    if (total < 0) {
        nTotalSign = BigInt(-1);
        total *= BigInt(-1);
    }
    let i = 0;
    for (; total >= biMaxNum && i < units.length - 1; i++) {
        total /= biDivider;
    }
    if (availableBytes === undefined) {
        return { nSpace1: Number(total * nTotalSign) / 1000, nSpace2: NaN, unit: units[i] };
    }
    let nAvailSign = BigInt(1);
    let available = BigInt(availableBytes);
    if (available < 0) {
        nAvailSign = BigInt(-1);
        available *= BigInt(-1);
    }
    let j = 0;
    for (; available >= biMaxNum && j < units.length - 1; j++) {
        available /= biDivider;
    }
    if (total > BigInt(Number.MAX_SAFE_INTEGER) && available > BigInt(Number.MAX_SAFE_INTEGER)) {
        return { nSpace1: NaN, nSpace2: NaN, unit: "" };
    }
    else if (available > BigInt(Number.MAX_SAFE_INTEGER)) {
        return { nSpace1: Number(total * nTotalSign) / 1000, nSpace2: NaN, unit: units[i] };
    }
    else if (total > BigInt(Number.MAX_SAFE_INTEGER)) {
        return { nSpace1: NaN, nSpace2: Number(available * nAvailSign) / 1000, unit: units[j] };
    }
    return { nSpace1: Number(total * nTotalSign) / 1000, nSpace2: Number(available * nAvailSign) / (Math.pow(1000, i - j + 1)), unit: units[i] };
}
function RoundTo3Digits(numb) {
    if (typeof numb !== 'number' || isNaN(numb)) {
        return NaN;
    }
    let nRet;
    if (numb > 99.9) {
        nRet = Math.round(numb);
    }
    else {
        nRet = parseFloat(numb.toPrecision(3));
    }
    return nRet;
}
function IsMapElInObj(map, obj) {
    for (const item of map) {
        if (item[0] in obj) {
            if (item[1].has(obj[item[0]])) {
                return true;
            }
            else {
                return false;
            }
        }
    }
    return false;
}
function ExtractSubstring(str, startDelimiter, endDelimiter) {
    const regex = new RegExp(`${startDelimiter}(.*?)${endDelimiter}`);
    const match = str.match(regex);
    return match ? match[1] : null;
}
function CompareTextWithNumbers(cA, cB, nDirect = 1) {
    const posA = cA.search(/\d/);
    const posB = cB.search(/\d/);
    if (posA >= 0 && posA == posB && cA.substring(0, posA) == cB.substring(0, posB)) {
        const nA = +((cA.match(/\d+/))[0]);
        const nB = +((cB.match(/\d+/))[0]);
        if (nA == nB) {
            const posA2 = cA.substring(posA + 1).search(/\D/);
            const posB2 = cB.substring(posB + 1).search(/\D/);
            if (posA2 > 0 && posB2 > 0) {
                return CompareTextWithNumbers(cA.substring(posA + 1 + posA2), cB.substring(posB + 1 + posB2), nDirect);
            }
            return cA.toUpperCase().localeCompare(cB.toUpperCase()) * nDirect;
        }
        return (nA - nB) * nDirect;
    }
    return cA.toUpperCase().localeCompare(cB.toUpperCase()) * nDirect;
}
function SplitWithTrim(s, t) {
    if (!s)
        return [];
    const ret = s.split(t);
    while (ret.length > 0 && ret[0].trim() == "") {
        ret.splice(0, 1);
    }
    while (ret.length > 0 && ret[ret.length - 1].trim() == "") {
        ret.splice(ret.length - 1, 1);
    }
    return ret;
}
function SetDomDisplayAndInnerHtml(domId, sDisplay, els) {
    let dom = (typeof domId === 'string') ? document.getElementById(domId) : domId;
    if (dom) {
        if (typeof sDisplay === 'string') {
            dom.style.display = sDisplay;
        }
        if (els) {
            if (els.class) {
                if (Array.isArray(els.class)) {
                    for (const sClass of els.class) {
                        dom.classList.add(sClass);
                    }
                }
                else {
                    dom.className = els.class;
                }
            }
            if (els.delClass) {
                if (Array.isArray(els.delClass)) {
                    for (const sClass of els.delClass) {
                        dom.classList.remove(sClass);
                    }
                }
                else {
                    dom.classList.remove(els.delClass);
                }
            }
            if (els.text !== null) {
                dom.innerHTML = "";
            }
            if (els.img) {
                const img = SetImg(els.img, "1rem");
                if (img) {
                    img.style.margin = "0.25rem 0.5rem 0.25rem 0.25rem";
                    dom.append(img);
                    const msg = document.createElement("div");
                    dom.append(msg);
                    dom = msg;
                }
            }
            if (els.text) {
                dom.innerHTML += (els.text).replaceAll("\n", "<br>");
            }
        }
    }
    return dom;
}
function LoadTextToTextarea(id, sText) {
    const domTextArea = document.getElementById(id);
    if (!domTextArea || domTextArea.type != "textarea")
        return;
    domTextArea.value = sText;
    if (domTextArea.onchange)
        domTextArea.onchange();
}
function DeleteCookie(name) {
    document.cookie = name + '=; Expires=Thu, 01 Jan 1970 00:00:01 GMT; Path=/;';
}
function GetMaxZIndex() {
    const elements = document.querySelectorAll('*');
    let ret = -1;
    for (const el of elements) {
        if (el.style.zIndex && ret < Number(el.style.zIndex))
            ret = Number(el.style.zIndex);
    }
    return ret;
}
function SetSameObjFields(src, dst) {
    for (const key of Object.keys(src)) {
        if (key in dst) {
            if (IsObject(src[key])) {
                SetSameObjFields(src[key], dst[key]);
            }
            else {
                dst[key] = src[key];
            }
        }
    }
}
function SetObjFieldsFromAnotherObj(src, dst) {
    for (const key of Object.keys(src)) {
        dst[key] = src[key];
    }
}
function SetNotEmptyObjFieldsFromAnotherObj(src, dst) {
    for (const key of Object.keys(src)) {
        if (src[key]) {
            dst[key] = src[key];
        }
    }
}
function HtmlErrBox(sErrMsg, sTitle, oParams) {
    if (!oParams)
        oParams = {};
    oParams.icon = "error";
    HtmlMsgbox(sErrMsg, sTitle, oParams);
}
function splitValue(value) {
    const match = value.match(/^(\d+(\.\d+)?)([a-z%]+)$/i);
    if (!match) {
        return { number: -1, unit: "" };
    }
    const number = parseFloat(match[1]);
    const unit = match[3];
    return { number, unit };
}
function GetFileNameOfPath(sFilePath) {
    let iSlash = sFilePath.lastIndexOf('/');
    if (iSlash >= 0) {
        return sFilePath.slice(iSlash + 1);
    }
    else {
        return sFilePath;
    }
}
function MaxDistance(rect1, rect2, nMax) {
    const dx = Math.max(rect1.left - rect2.right, rect2.left - rect1.right, 0);
    const dy = Math.max(rect1.top - rect2.bottom, rect2.top - rect1.bottom, 0);
    return dx > nMax || dy > nMax;
}
function SetWaitingBox(dom, sText) {
    if (!dom)
        return;
    if (sText) {
        dom.innerHTML = sText + "<span class='waiting_box'></span>";
    }
    else {
        dom.classList.add('waiting_box');
    }
}
function ReetWaitingBox(dom, sText) {
    if (!dom)
        return;
    dom.classList.remove('waiting_box');
    if (sText) {
        dom.innerHTML = sText;
    }
    else {
        dom.innerHTML = "";
    }
}
function ParseUrl(url) {
    const oUrl = { hostname: "", pathname: "", port: "", protocol: "", user: "" };
    url = url.replace("%40", "@");
    let pos0 = url.search(/[\%\+\?]/);
    if (pos0 >= 0) {
        url = url.slice(0, pos0);
    }
    pos0 = 0;
    let pos1 = url.indexOf("\/\/");
    if (pos1 < 0) {
        oUrl.pathname = url;
        oUrl.protocol = "file://";
        return oUrl;
    }
    oUrl.protocol = url.slice(pos0, pos1 + 2).toLowerCase();
    pos0 = pos1 + 2;
    pos1 = url.indexOf("\/", pos0);
    if (pos1 < 0) {
        oUrl.hostname = url.slice(pos0);
    }
    else {
        oUrl.hostname = url.slice(pos0, pos1);
        oUrl.pathname = url.slice(pos1 + 1);
    }
    pos1 = oUrl.hostname.indexOf("@");
    if (pos1 >= 0) {
        oUrl.user = oUrl.hostname.slice(0, pos1);
        oUrl.hostname = oUrl.hostname.slice(pos1 + 1);
    }
    pos0 = oUrl.hostname.indexOf(":");
    if (pos0 >= 0) {
        oUrl.port = oUrl.hostname.slice(pos0);
        oUrl.hostname = oUrl.hostname.slice(0, pos0);
    }
    return oUrl;
}
function CutProtocol(sUrl) {
    let pos = sUrl.indexOf("://");
    if (pos < 0) {
        pos = 0;
    }
    else {
        pos += 3;
    }
    return sUrl.slice(pos);
}
function SelectPointBorder(container, width, height, position, r, color, bg) {
    const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
    svg.setAttribute("width", width.toString());
    svg.setAttribute("height", height.toString());
    svg.setAttribute("viewBox", "0 0 " + width + " " + height);
    svg.setAttribute("fill", "none");
    svg.setAttribute("style", `position:absolute; right:-2px; top:${position}px`);
    if (!bg) {
        bg = "white";
    }
    const rect = document.createElementNS("http://www.w3.org/2000/svg", "rect");
    rect.setAttribute("width", "3");
    rect.setAttribute("height", "" + height);
    rect.setAttribute("x", "" + (width - 3));
    rect.setAttribute("y", "0");
    rect.setAttribute("fill", bg);
    const path = document.createElementNS("http://www.w3.org/2000/svg", "path");
    path.setAttribute("d", `M${width - 2} 0 
        C ${width - 2} ${r}, ${width - 2 - r} ${2 * r}, ${width - 2 * r - 2} ${2 * r} 
        H ${2 * r} 
        C ${r} ${2 * r}, 1 ${3 * r}, 1 ${4 * r} 
        V ${height - 4 * r} 
        C 1 ${height - 3 * r}, ${r} ${height - 2 * r}, ${2 * r} ${height - 2 * r} 
        H ${width - 2 * r - 2} 
        C ${width - r - 2} ${height - 2 * r}, ${width - 2} ${height - r}, ${width - 2} ${height}`);
    path.setAttribute("fill", "none");
    path.setAttribute("stroke", color);
    path.setAttribute("stroke-width", "1");
    svg.appendChild(rect);
    svg.appendChild(path);
    container.appendChild(svg);
    return svg;
}
function SelectPointBorderMove(pos, svg) {
    if (!svg)
        return;
    svg.setAttribute("style", `position:absolute; right:-2px; top:${pos}px`);
}
function StringToTable(str) {
    const lines = str.split('<br/>');
    const tableData = [];
    for (const line of lines) {
        const parts = line.split('\t');
        if (parts.length === 2) {
            tableData.push({ key: parts[0], value: parts[1] });
        }
    }
    let tableHTML = '<table>';
    for (const row of tableData) {
        tableHTML += `<tr><td>${row.key}</td><td class='cell_int_fltmn_text_to_table'>${row.value}</td></tr>`;
    }
    tableHTML += '</table>';
    return tableHTML;
}
function GetWaitingSvg(h, r, color = "#7F848D") {
    const cx = h / 2;
    return `<svg width="${h}" height="${h}" viewBox="0 0 ${h} ${h}">
        <g class="dots">
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(0, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(30, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(60, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(90, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(120, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(150, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(180, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(210, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(240, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(270, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(300, ${cx} ${cx})"/>
            <circle cx="${cx}" cy="${r}" r="${r}" fill="${color}" transform="rotate(330, ${cx} ${cx})"/>
        </g>
    </svg>`;
}
function isParentFlexColumn(element) {
    const parent = element.parentNode;
    if (!parent) {
        return false;
    }
    return getComputedStyle(parent).flexDirection === 'column';
}
function GetFocusableEls(element) {
    const tabbableElements = [];
    function traverse(node) {
        if (node.nodeType !== Node.ELEMENT_NODE) {
            return;
        }
        const element = node;
        if (element.style.display == "none" || element.disabled) {
            return;
        }
        const tabindexValue = element.getAttribute('tabindex');
        let isTabbable = false;
        if (tabindexValue !== null) {
            const tabindex = parseInt(tabindexValue, 10);
            if (!isNaN(tabindex) && tabindex >= 0) {
                isTabbable = true;
            }
        }
        else {
            const tagName = element.tagName.toLowerCase();
            if (tagName === 'a' && element.hasAttribute('href')) {
                isTabbable = true;
            }
            else if (tagName === 'button' || tagName === 'input' || tagName === 'select' || tagName === 'textarea') {
                isTabbable = true;
            }
        }
        if (isTabbable) {
            tabbableElements.push(element);
        }
        for (let i = 0; i < element.children.length; i++) {
            traverse(element.children[i]);
        }
    }
    traverse(element);
    return tabbableElements;
}
function IsObjNotEmpty(obj) {
    for (const key of Object.keys(obj)) {
        if (obj[key] && obj[key] != "undefined") {
            return true;
        }
    }
    return false;
}
function replaceAllIgnoreCase(originalString, searchString, replacementString) {
    if (searchString === '') {
        return originalString;
    }
    return originalString.replace(new RegExp(searchString, 'gi'), replacementString);
}
function AddSpan(sText, sSelect) {
    let nPos = 0;
    for (;;) {
        nPos = sText.toLowerCase().indexOf(sSelect.toLowerCase(), nPos);
        if (nPos >= 0) {
            sText = sText.slice(0, nPos) + "<span>" + sText.slice(nPos, nPos + sSelect.length) + "</span>" + sText.slice(nPos + sSelect.length);
            nPos = nPos + sSelect.length + 13;
        }
        else {
            break;
        }
    }
    return sText;
}
function GetSelectTextInElement(targetElement) {
    if (!targetElement) {
        return "";
    }
    const selection = window.getSelection();
    if (!selection || selection.rangeCount === 0 || selection.isCollapsed) {
        return "";
    }
    const range = selection.getRangeAt(0);
    const commonAncestor = range.commonAncestorContainer;
    if (targetElement.contains(commonAncestor)) {
        return selection.toString();
    }
    return "";
}
function SetResetDisabledOfAllChildren(parentElement, disabledState) {
    if (!parentElement)
        return;
    const descendants = parentElement.querySelectorAll('*');
    descendants.forEach((element) => {
        if (element instanceof HTMLElement && 'disabled' in element) {
            try {
                element.disabled = disabledState;
                if (disabledState) {
                    element.classList.add("dead_btn");
                }
                else {
                    element.classList.remove("dead_btn");
                }
            }
            catch (e) { }
        }
    });
    const labels = parentElement.querySelectorAll('label');
    labels.forEach(element => {
        try {
            if (disabledState) {
                element.classList.add("dead_btn");
            }
            else {
                element.classList.remove("dead_btn");
            }
        }
        catch (e) { }
    });
}
function StrRightEqNoCaseRem(str1, str2, obj) {
    if (str1.endsWith(str2)) {
        obj.tail = str1.slice(0, str2.length);
        return true;
    }
    return false;
}
function StrLeftEqNoCaseRem(str1, str2, obj) {
    if (str1.startsWith(str2)) {
        obj.tail = str1.slice(str2.length);
        return true;
    }
    return false;
}
function StrSplitByChar(strA, c) {
    let nPos = strA.indexOf(c);
    if (nPos > 0) {
        return { str1: strA.slice(0, nPos), str2: strA.slice(nPos + c.length) };
    }
    return { str1: strA, str2: "" };
}
function GsGetPrefixOfUrlA(sUrlA) {
    let nPos = sUrlA.indexOf("://");
    if (nPos > 0) {
        return sUrlA.slice(0, nPos + 3);
    }
    return "";
}
function GsGetPrefixServerOfUrl(sUrlA) {
    let nPrefixPos = sUrlA.indexOf("://");
    if (nPrefixPos < 0) {
        nPrefixPos = 0;
    }
    let nDisPos = sUrlA.indexOf('/', nPrefixPos + 3);
    if (nDisPos >= 0) {
        return sUrlA.slice(0, nDisPos);
    }
    else {
        return sUrlA;
    }
}
function GsComposeUrlOfServerAcctPlusBmkKey(sServerAcctUrlA, sServerDirA) {
    const s = { tail: "" };
    if (StrLeftEqNoCaseRem(sServerAcctUrlA, "gstps://", s) ||
        StrLeftEqNoCaseRem(sServerAcctUrlA, "gstp://", s) ||
        StrLeftEqNoCaseRem(sServerAcctUrlA, "gstore://", s)) {
        const s1 = { tail: "" };
        if (StrRightEqNoCaseRem(s.tail, ".goodsync", s1)) {
            const oServAndDir = StrSplitByChar(sServerDirA, '/');
            return GsGetPrefixOfUrlA(sServerAcctUrlA) + oServAndDir.str1 + "." + s1.tail + ".goodsync/" + oServAndDir.str2;
        }
        if (StrRightEqNoCaseRem(s.tail, ".nokl", s1)) {
            const oServAndDir = StrSplitByChar(sServerDirA, '/');
            return GsGetPrefixOfUrlA(sServerAcctUrlA) + oServAndDir.str1 + "." + s1.tail + ".nokl/" + oServAndDir.str2;
        }
    }
    return sServerAcctUrlA + sServerDirA;
}
function GsDeComposeUrlIntoServerAcctPlusBmkKey(sUrlA, sUserIdA) {
    const s = { tail: "" };
    let sServerAcctUrlA = "";
    let sServerDirA = "";
    const oUrl = ParseUrl(sUrlA);
    if (StrLeftEqNoCaseRem(sUrlA, "gstps://", s) ||
        StrLeftEqNoCaseRem(sUrlA, "gstp://", s) ||
        StrLeftEqNoCaseRem(sUrlA, "gstore://", s)) {
        sServerAcctUrlA = oUrl.hostname;
        if (StrRightEqNoCaseRem(sServerAcctUrlA, ".goodsync", s)) {
            const oServAndUser = StrSplitByChar(s.tail, '.');
            if (!oServAndUser.str2) {
                sServerAcctUrlA = GsGetPrefixOfUrlA(sUrlA) + s.tail + ".goodsync";
                sServerDirA = "";
                return { sServerAcctUrlA, sServerDirA };
            }
            else {
                sServerAcctUrlA = GsGetPrefixOfUrlA(sUrlA) + oServAndUser.str2 + ".goodsync";
                sServerDirA = oServAndUser.str1 + oUrl.pathname;
                return { sServerAcctUrlA, sServerDirA };
            }
        }
        if (StrRightEqNoCaseRem(sServerAcctUrlA, ".nokl", s)) {
            const oServAndUser = StrSplitByChar(s.tail, '.');
            if (!oServAndUser.str2) {
                sServerAcctUrlA = GsGetPrefixOfUrlA(sUrlA) + s.tail + ".nokl";
                sServerDirA = "";
                return { sServerAcctUrlA, sServerDirA };
            }
            else {
                sServerAcctUrlA = GsGetPrefixOfUrlA(sUrlA) + oServAndUser.str2 + ".nokl";
                sServerDirA = oServAndUser.str1 + oUrl.pathname;
                return { sServerAcctUrlA, sServerDirA };
            }
        }
        sServerAcctUrlA = GsGetPrefixServerOfUrl(sUrlA);
        sServerDirA = oUrl.pathname;
        return { sServerAcctUrlA, sServerDirA };
    }
    if (StrLeftEqNoCaseRem(sUrlA, "smb://", s) ||
        StrLeftEqNoCaseRem(sUrlA, "smbd://", s) ||
        StrLeftEqNoCaseRem(sUrlA, "afp://", s) ||
        StrLeftEqNoCaseRem(sUrlA, "afpd://", s) ||
        StrLeftEqNoCaseRem(sUrlA, "wd://", s)) {
        if (!sUserIdA) {
            sServerAcctUrlA = GsGetPrefixOfUrlA(sUrlA);
            sServerDirA = oUrl.hostname + oUrl.pathname;
        }
        else {
            sServerAcctUrlA = GsGetPrefixServerOfUrl(sUrlA);
            sServerDirA = oUrl.pathname;
        }
    }
    else if (StrLeftEqNoCaseRem(sUrlA, "mtp://", s)) {
        sServerAcctUrlA = "mtp://";
        sServerDirA = oUrl.hostname + oUrl.pathname;
    }
    else {
        sServerAcctUrlA = GsGetPrefixServerOfUrl(sUrlA);
        sServerDirA = oUrl.pathname;
    }
    return { sServerAcctUrlA, sServerDirA };
}
function GetCurrTime() {
    return (new Date()).getTime();
}
function FormatTimeDifference(milliseconds, sH, sM, sS) {
    const totalSeconds = Math.floor(milliseconds / 1000);
    const hours = Math.floor(totalSeconds / 3600);
    const minutes = Math.floor((totalSeconds % 3600) / 60);
    const seconds = totalSeconds % 60;
    const pad = (num) => num.toString().padStart(2, '0');
    return `<b>${pad(hours)}</b>${sH}<b>${pad(minutes)}</b>${sM}<b>${pad(seconds)}</b>${sS}`;
}
function CreateWaitingBox(sTitle) {
    const jsWaitingBox = {
        "title": sTitle, bottom_box: [], cont: [
            { title: "", cont: [
                    { type: "place", title: "", class: "waiting_box" },
                ] }
        ]
    };
    const oWaitingBox = CreateFloatMenu(jsWaitingBox, { top: "20%", width: "300px" }, null);
    oWaitingBox.promise.then(() => { }).catch(() => { });
    return oWaitingBox.oMenu;
}
function WasResize(dom) {
    const oRect = dom.getBoundingClientRect();
    if (dom.nWidth === undefined || dom.nWidth !== oRect.width ||
        dom.nHeight === undefined || dom.nHeight !== oRect.height) {
        dom.nWidth = oRect.width;
        dom.nHeight = oRect.height;
        return true;
    }
}
function ParseSizeAndUnits(size) {
    if (!size)
        return null;
    const match = size.match(/^(-?\d*\.?\d+)(px|%|vw|vh|em|rem|cm|mm|in|pt|pc)$/);
    if (!match)
        return null;
    return {
        value: parseFloat(match[1]),
        unit: match[2]
    };
}
function GetBrowserWidthInUnits(unit) {
    switch (unit) {
        case 'px':
            return document.documentElement.clientWidth;
        case '%':
            return 100;
        case 'vw':
            return 100;
        case 'vh':
            return (document.documentElement.clientWidth / document.documentElement.clientHeight) * 100;
        case 'rem':
            return document.documentElement.clientWidth / parseFloat(window.getComputedStyle(document.documentElement).fontSize);
        case 'cm':
            return document.documentElement.clientWidth / 96 * 2.54;
        case 'mm':
            return document.documentElement.clientWidth / 96 * 25.4;
        case 'in':
            return document.documentElement.clientWidth / 96;
        case 'pt':
            return document.documentElement.clientWidth / 96 * 72;
        case 'pc':
            return document.documentElement.clientWidth / 16;
        default:
            return 0;
    }
}
function GetLangArray() {
    const arr = Object.keys(languageFiles);
    arr.sort();
    arr.unshift("English");
    return arr;
}
function GetLocaleText(sText, aArgs, oParams) {
    if (oRfs && sText in oRfs) {
        sText = oRfs[sText];
    }
    else if (sText in defaultRfs) {
        sText = defaultRfs[sText];
    }
    else if (sText in tmp_default_rfs) {
        sText = tmp_default_rfs[sText];
    }
    if (sText.includes('&')) {
        sText = SymbolsUnderline(sText);
    }
    if (aArgs) {
        if (oParams) {
            if (oParams.sTermSign) {
                for (let i = 0; i < (aArgs.length - 1); i++) {
                    if (aArgs[i].trim() && aArgs[i + 1].trim())
                        sText = sText.replaceAll("%" + (i + 1), "%" + (i + 1) + oParams.sTermSign);
                }
            }
            if (oParams.bBold) {
                for (let i = 0; i < aArgs.length; i++) {
                    if (aArgs[i].trim())
                        sText = sText.replaceAll("%" + (i + 1), "<b>" + "%" + (i + 1) + "</b>");
                }
            }
            if (oParams.sQuotes) {
                for (let i = 0; i < aArgs.length; i++) {
                    if (aArgs[i].trim())
                        sText = sText.replaceAll("%" + (i + 1), oParams.sQuotes + "%" + (i + 1) + oParams.sQuotes);
                }
            }
        }
        for (let i = 0; i < aArgs.length; i++) {
            sText = sText.replaceAll("%" + (i + 1), aArgs[i]);
        }
    }
    return sText;
}
function GetHelpText(sText0) {
    if (!sText0)
        return "";
    const pos1 = sText0.indexOf("_");
    if (pos1 < 0)
        return "";
    const sText = "Help" + sText0.slice(pos1);
    if (oRfs && sText in oRfs) {
        return oRfs[sText];
    }
    if (sText in defaultRfs) {
        return defaultRfs[sText];
    }
    if (sText in tmp_default_rfs) {
        return tmp_default_rfs[sText];
    }
    const pos2 = sText0.indexOf("_", pos1 + 1);
    if (pos2 > 0) {
        const sText = sText0.slice(0, pos1) + "_Tip" + sText0.slice(pos2);
        if (oRfs && sText in oRfs) {
            return oRfs[sText];
        }
        if (sText in defaultRfs) {
            return defaultRfs[sText];
        }
        if (sText in tmp_default_rfs) {
            return tmp_default_rfs[sText];
        }
    }
    return "";
}
function GetSmthgText(sText) {
    if (oRfs && sText in oRfs) {
        return oRfs[sText];
    }
    if (sText in defaultRfs) {
        return defaultRfs[sText];
    }
    if (sText in tmp_default_rfs) {
        return tmp_default_rfs[sText];
    }
    return "";
}
class TWebGuSettings {
    constructor() {
        this.bShowLogCritical = true;
        this.bShowLogError = true;
        this.bShowLogInfo = false;
        this.bShowLogDetails = true;
        this.bExplorerAsWin = false;
        this.nNumberLogStringsInLogWindow = 500;
        this.key = null;
        this.sequence = [];
        this.iv = [];
        this.oOpts = { eTreeDisplayDensity: 0, sLanguage: "", bSortJobNamesbyAlphabet: false, bShowBackupSyncGroups: true };
        this.sCurrJob = "";
        this.sCurrGroup = "";
        this.oJobTableParams = { sLeftTableWidth: "50%", sJobListWidth: "15%", nRightWinH: 0, bLogWinOpen: false, bMoreInfoOpen: false };
        this.aLeftJobTableColsSize = [];
        this.aRightJobTableColsSize = [];
        this.aJobTreeNarrowTableColsSize = [];
        this.aJobTreeWideTableColsSize = [];
        this.sLocal = 'en-US';
        this._oJobTreeMode = {};
    }
    GetTreeMode(name) {
        if (!name)
            return DEF_TREE_MODE;
        if (name in this._oJobTreeMode && this._oJobTreeMode[name] >= 0 && this._oJobTreeMode[name] <= MAX_TREE_MODE) {
            return this._oJobTreeMode[name];
        }
        this._oJobTreeMode[name] = DEF_TREE_MODE;
        return DEF_TREE_MODE;
    }
    SetTreeMode(name, nMode) {
        if (!name || nMode < 0 || nMode > MAX_TREE_MODE || nMode === undefined)
            return;
        this._oJobTreeMode[name] = nMode;
    }
}
const oWebGuSettings = new TWebGuSettings();
{
    const tmp = localStorage.getItem("oWebGuSettings");
    if (tmp) {
        try {
            const tmp2 = JSON.parse(tmp);
            if (tmp2 && IsObject(tmp2)) {
                SetSameObjFields(tmp2, oWebGuSettings);
            }
        }
        catch (_a) { }
    }
    localStorage.setItem("oWebGuSettings", JSON.stringify(oWebGuSettings));
    if (oWebGuSettings.sequence.length > 0) {
        crypto.subtle.importKey("raw", new Uint8Array(oWebGuSettings.sequence), { name: 'AES-CBC', length: 256 }, true, ['encrypt', 'decrypt']).then(key => {
            oWebGuSettings.key = key;
        });
    }
}
const sLangKey = oWebGuSettings.oOpts.sLanguage;
let oRfs = {};
let bLangPageDownloadFinished = false;
if (sLangKey) {
    const sFileName = languageFiles[sLangKey];
    if (sFileName) {
        const script = document.createElement("script");
        script.type = "text/javascript";
        script.src = "web-ui/static/" + sFileName;
        document.body.appendChild(script);
        script.onload = function () {
            oRfs = rfs;
            bLangPageDownloadFinished = true;
        };
        script.onerror = function () {
            ErrorMsgShow("", GetLocaleText("Err_LanguageFileLoadingFault"), "msgbox");
            bLangPageDownloadFinished = true;
        };
    }
    else {
        bLangPageDownloadFinished = true;
    }
}
else {
    bLangPageDownloadFinished = true;
}
const openUrlWithOptions = (url, options = {}) => {
    const { width = 800, height = 600, left = 100, top = 100 } = options;
    const features = `width=${width},height=${height},left=${left},top=${top},resizable=yes,scrollbars=yes,noopener,noreferrer`;
    return window.open(url, '_blank', features);
};
const nTab = 1;
function JsonToStrAsTree(obj, sEndl, sQuotes = '"', depth = nTab, bNoBracket) {
    if (obj === null || obj === undefined) {
        return "";
    }
    let ret = "";
    if (typeof obj === "object") {
        let sBrOp = "{", sBrCl = "}";
        if (bNoBracket) {
            sBrOp = "", sBrCl = "";
        }
        else if (Array.isArray(obj)) {
            sBrOp = "[", sBrCl = "]";
        }
        ret += sBrOp + sEndl;
        for (let key in obj) {
            if (key == "__ind__")
                continue;
            let sKey = sQuotes + key + sQuotes;
            if (typeof obj[key] === "object" && "__ind__" in obj[key]) {
                sKey = "[" + obj[key].__ind__ + "]";
            }
            ret += "<span style='margin-right:" + depth + "rem;'></span><b>" + GetLocaleText(sKey) + " : </b>" + JsonToStrAsTree(obj[key], sEndl, sQuotes, depth + nTab, bNoBracket) + sEndl;
        }
        ret += "<span style='margin-right:" + (depth - nTab) + "rem;'></span>" + sBrCl;
    }
    else {
        if (typeof obj === "function") {
            ret += obj.name;
        }
        else if (typeof obj === "string") {
            ret += sQuotes + obj + sQuotes;
        }
        else {
            ret += obj;
        }
    }
    return ret;
}
function GetCookieByName(sName) {
    const sCookie = "; " + document.cookie;
    const aParts = sCookie.split("; " + sName + "=");
    if (aParts.length === 2) {
        const nPos = aParts[1].indexOf(";");
        if (nPos < 0) {
            return aParts[1];
        }
        return aParts[1].slice(0, nPos);
    }
    return "";
}
