#ifndef TE_INLINER_INTERFACE_H
#define TE_INLINER_INTERFACE_H

#include <vector>

#include "llvm/IR/ModuleSummaryIndex.h"
#include "llvm/ADT/SmallString.h"
#include "llvm/Support/DynamicLibrary.h"
#include "llvm/Support/Process.h"
#include "llvm/LTO/LTO.h"

#define TE_LTO_ANALYSIS_FUNC "TeInlinerLTOAnalysis"
#define TE_SECTION_CHUNK_SORT_FUNC "TeInlinerSectionChunkSort"

namespace lld {
namespace coff {
  class Chunk;
}
}

namespace llvm {

struct TeChunkInfo {
  void* OriginalChunkPtr; // lld::coff::Chunk*
  StringRef Name;
  StringRef Path;
  uint32_t Alignment;
  size_t Size;
};

typedef void (*TeLTOAnalysisFunc)(ModuleSummaryIndex& CombinedIndex, const lto::Config& Conf,
  LLVMContext& Ctx, MapVector<StringRef, BitcodeModule>& ModuleMap);

typedef bool (*TeSectionChunkSortFunc)(StringRef SectionName, std::vector<TeChunkInfo>& chunks);

inline void* getTeInlinerFunc(const char* SymbolName) {
  return sys::DynamicLibrary::SearchForAddressOfSymbol(SymbolName);
}

}  // namespace llvm

#endif