/*
 *  LibXDiff by Davide Libenzi ( File Differential Library )
 *  Copyright (C) 2003  Davide Libenzi
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, see
 *  <http://www.gnu.org/licenses/>.
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */

#if !defined(XUTILS_H)
#define XUTILS_H



long xdl_bogosqrt(long n);
int xdl_emit_diffrec(wchar_t const *rec, long size, wchar_t const *pre, long psize,
		     xdemitcb_t *ecb);
int xdl_cha_init(chastore_t *cha, long isize, long icount);
void xdl_cha_free(chastore_t *cha);
void *xdl_cha_alloc(chastore_t *cha);
long xdl_guess_lines(mmfile_t *mf, long sample);
int xdl_blankline(const wchar_t *line, long size, long flags);
int xdl_recmatch(xdfile_t *xdf1, long nrec1, const wchar_t *l1, long s1,
				 xdfile_t *xdf2, long nrec2, const wchar_t *l2, long s2, 
				 xpparam_t const *xpp);
unsigned long xdl_hash_record(wchar_t const **data, wchar_t const *top, long flags);
unsigned int xdl_hashbits(unsigned int size);
int xdl_num_out(wchar_t *out, long val);
int xdl_emit_hunk_hdr(long s1, long c1, long s2, long c2,
		      const wchar_t *func, long funclen, xdemitcb_t *ecb);
int xdl_fall_back_diff(xdfenv_t *diff_env, xpparam_t const *xpp,
		       int line1, int count1, int line2, int count2);



#endif /* #if !defined(XUTILS_H) */
