/*
 *  LibXDiff by Davide Libenzi ( File Differential Library )
 *  Copyright (C) 2003  Davide Libenzi
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, see
 *  <http://www.gnu.org/licenses/>.
 *
 *  Davide Libenzi <davidel@xmailserver.org>
 *
 */

#if !defined(XDIFF_H)
#define XDIFF_H

#ifdef __cplusplus
extern "C" {
#endif /* #ifdef __cplusplus */

/* xpparm_t.flags */
#define XDF_NEED_MINIMAL (1 << 0)

#define XDF_IGNORE_WHITESPACE (1 << 1)
#define XDF_IGNORE_WHITESPACE_CHANGE (1 << 2)
#define XDF_IGNORE_WHITESPACE_AT_BOL (1 << 3)
#define XDF_IGNORE_WHITESPACE_AT_EOL (1 << 4)
#define XDF_IGNORE_CR_AT_EOL (1 << 5)
#define XDF_WHITESPACE_FLAGS (XDF_IGNORE_WHITESPACE | \
			      XDF_IGNORE_WHITESPACE_CHANGE | \
			      XDF_IGNORE_WHITESPACE_AT_EOL | \
			      XDF_IGNORE_CR_AT_EOL)

#define XDF_IGNORE_BLANK_LINES (1 << 7)

#define XDF_PATIENCE_DIFF (1 << 14)
#define XDF_HISTOGRAM_DIFF (1 << 15)
#define XDF_DIFF_ALGORITHM_MASK (XDF_PATIENCE_DIFF | XDF_HISTOGRAM_DIFF)
#define XDF_DIFF_ALG(x) ((x) & XDF_DIFF_ALGORITHM_MASK)

#define XDF_INDENT_HEURISTIC (1 << 23)

/* xdemitconf_t.flags */
#define XDL_EMIT_FUNCNAMES (1 << 0)
#define XDL_EMIT_FUNCCONTEXT (1 << 2)

/* merge simplification levels */
#define XDL_MERGE_MINIMAL 0
#define XDL_MERGE_EAGER 1
#define XDL_MERGE_ZEALOUS 2
#define XDL_MERGE_ZEALOUS_ALNUM 3

/* merge favor modes */
#define XDL_MERGE_FAVOR_OURS 1
#define XDL_MERGE_FAVOR_THEIRS 2
#define XDL_MERGE_FAVOR_UNION 3

/* merge output styles */
#define XDL_MERGE_DIFF3 1

typedef struct s_mmfile {
	wchar_t *ptr;
	long size;
} mmfile_t;

typedef struct s_mmbuffer {
	wchar_t *ptr;
	long size;
} mmbuffer_t;

typedef long (*xdl_pre_blank_record_count_func_t)(long nrec, void* priv_data);
typedef unsigned long (*xdl_hash_record_func_t)(wchar_t const **data, wchar_t const *top, long flags, long nrec, void* priv_data);
typedef int (*xdl_recmatch_func_t)(const wchar_t *l1, long s1, long nrec1, void* priv_data1, const wchar_t *l2, long s2, long nrec2, void* priv_data2, long flags);

typedef struct s_xpparam {
	unsigned long flags;

	/* See Documentation/diff-options.txt. */
	wchar_t **anchors;
	size_t anchors_nr;

	xdl_pre_blank_record_count_func_t pre_blank_record_count_func;
	xdl_hash_record_func_t hash_record_func;
	xdl_recmatch_func_t recmatch_func;
} xpparam_t;

typedef struct s_xdemitcb {
	void *priv;
	int (*out_hunk)(void *,
			long old_begin, long old_nr,
			long new_begin, long new_nr,
			const wchar_t *func, long funclen);
	int (*out_line)(void *, mmbuffer_t *, int);
} xdemitcb_t;

typedef long (*find_func_t)(const wchar_t *line, long line_len, wchar_t *buffer, long buffer_size, void *priv);

typedef int (*xdl_emit_hunk_consume_func_t)(long start_a, long count_a,
					    long start_b, long count_b,
					    void *cb_data);

typedef struct s_xdemitconf {
	long ctxlen;
	long interhunkctxlen;
	unsigned long flags;
	find_func_t find_func;
	void *find_func_priv;
	xdl_emit_hunk_consume_func_t hunk_func;
} xdemitconf_t;

typedef struct s_bdiffparam {
	long bsize;
} bdiffparam_t;


#define xdl_malloc(x) xmalloc(x)
#define xdl_free(ptr) free(ptr)
#define xdl_realloc(ptr,x) xrealloc(ptr,x)

void *xdl_mmfile_first(mmfile_t *mmf, long *size);
long xdl_mmfile_size(mmfile_t *mmf);

int xdl_diff(mmfile_t *mf1, mmfile_t *mf2, xpparam_t const *xpp,
	     xdemitconf_t const *xecfg, xdemitcb_t *ecb);

typedef struct s_xmparam {
	xpparam_t xpp;
	int marker_size;
	int level;
	int favor;
	int style;
	const wchar_t *ancestor;	/* label for orig */
	const wchar_t *file1;	/* label for mf1 */
	const wchar_t *file2;	/* label for mf2 */
} xmparam_t;

#define DEFAULT_CONFLICT_MARKER_SIZE 7

int xdl_merge(mmfile_t *orig, mmfile_t *mf1, mmfile_t *mf2,
		xmparam_t const *xmp, mmbuffer_t *result);

#ifdef __cplusplus
}
#endif /* #ifdef __cplusplus */

#endif /* #if !defined(XDIFF_H) */
