/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.material3;

import androidx.compose.material3.BaseDatePickerStateImpl;
import androidx.compose.material3.DatePickerState;
import androidx.compose.material3.DisplayMode;
import androidx.compose.material3.SelectableDates;
import androidx.compose.material3.internal.CalendarDate;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.saveable.ListSaverKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B?\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\u0010\f\u001a\u00060\rj\u0002`\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u00048V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Landroidx/compose/material3/DatePickerStateImpl;", "Landroidx/compose/material3/BaseDatePickerStateImpl;", "Landroidx/compose/material3/DatePickerState;", "initialSelectedDateMillis", "", "initialDisplayedMonthMillis", "yearRange", "Lkotlin/ranges/IntRange;", "initialDisplayMode", "Landroidx/compose/material3/DisplayMode;", "selectableDates", "Landroidx/compose/material3/SelectableDates;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "<init>", "(Ljava/lang/Long;Ljava/lang/Long;Lkotlin/ranges/IntRange;ILandroidx/compose/material3/SelectableDates;Ljava/util/Locale;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "_selectedDate", "Landroidx/compose/runtime/MutableState;", "Landroidx/compose/material3/internal/CalendarDate;", "dateMillis", "selectedDateMillis", "getSelectedDateMillis", "()Ljava/lang/Long;", "setSelectedDateMillis", "(Ljava/lang/Long;)V", "_displayMode", "displayMode", "getDisplayMode-jFl-4v0", "()I", "setDisplayMode-vCnGnXg", "(I)V", "Companion", "material3"})
@Stable
final class DatePickerStateImpl
extends BaseDatePickerStateImpl
implements DatePickerState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private MutableState<CalendarDate> _selectedDate;
    @NotNull
    private MutableState<DisplayMode> _displayMode;

    private DatePickerStateImpl(Long initialSelectedDateMillis, Long initialDisplayedMonthMillis, IntRange yearRange, int initialDisplayMode, SelectableDates selectableDates, Locale locale) {
        CalendarDate calendarDate;
        Intrinsics.checkNotNullParameter((Object)yearRange, (String)"yearRange");
        Intrinsics.checkNotNullParameter((Object)selectableDates, (String)"selectableDates");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        super(initialDisplayedMonthMillis, yearRange, selectableDates, locale);
        if (initialSelectedDateMillis != null) {
            CalendarDate date = this.getCalendarModel().getCanonicalDate(initialSelectedDateMillis);
            if (!yearRange.contains(date.getYear())) {
                DatePickerStateImpl datePickerStateImpl = this;
                boolean bl = false;
                DatePickerStateImpl datePickerStateImpl2 = datePickerStateImpl;
                String string = "The provided initial date's year (" + date.getYear() + ") is out of the years range of " + yearRange + ".";
                throw new IllegalArgumentException(string.toString());
            }
            calendarDate = date;
        } else {
            calendarDate = null;
        }
        this._selectedDate = SnapshotStateKt.mutableStateOf$default(calendarDate, null, (int)2, null);
        this._displayMode = SnapshotStateKt.mutableStateOf$default((Object)DisplayMode.box-impl(initialDisplayMode), null, (int)2, null);
    }

    @Override
    @Nullable
    public Long getSelectedDateMillis() {
        CalendarDate calendarDate = (CalendarDate)this._selectedDate.getValue();
        return calendarDate != null ? Long.valueOf(calendarDate.getUtcTimeMillis()) : null;
    }

    @Override
    public void setSelectedDateMillis(@Nullable Long dateMillis) {
        if (dateMillis != null) {
            CalendarDate date = this.getCalendarModel().getCanonicalDate(dateMillis);
            if (!this.getYearRange().contains(date.getYear())) {
                boolean bl = false;
                String string = "The provided date's year (" + date.getYear() + ") is out of the years range of " + this.getYearRange() + ".";
                throw new IllegalArgumentException(string.toString());
            }
            this._selectedDate.setValue((Object)date);
        } else {
            this._selectedDate.setValue(null);
        }
    }

    @Override
    public int getDisplayMode-jFl-4v0() {
        return ((DisplayMode)this._displayMode.getValue()).unbox-impl();
    }

    @Override
    public void setDisplayMode-vCnGnXg(int displayMode) {
        Long l = this.getSelectedDateMillis();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            this.setDisplayedMonthMillis(this.getCalendarModel().getMonth(it).getStartUtcTimeMillis());
        }
        this._displayMode.setValue((Object)DisplayMode.box-impl(displayMode));
    }

    public /* synthetic */ DatePickerStateImpl(Long initialSelectedDateMillis, Long initialDisplayedMonthMillis, IntRange yearRange, int initialDisplayMode, SelectableDates selectableDates, Locale locale, DefaultConstructorMarker $constructor_marker) {
        this(initialSelectedDateMillis, initialDisplayedMonthMillis, yearRange, initialDisplayMode, selectableDates, locale);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/compose/material3/DatePickerStateImpl$Companion;", "", "<init>", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/material3/DatePickerStateImpl;", "selectableDates", "Landroidx/compose/material3/SelectableDates;", "locale", "Ljava/util/Locale;", "Landroidx/compose/material3/CalendarLocale;", "(Landroidx/compose/material3/SelectableDates;Ljava/util/Locale;)Landroidx/compose/runtime/saveable/Saver;", "material3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<DatePickerStateImpl, Object> Saver(@NotNull SelectableDates selectableDates, @NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)selectableDates, (String)"selectableDates");
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            return ListSaverKt.listSaver(Companion::Saver$lambda$0, arg_0 -> Companion.Saver$lambda$1(selectableDates, locale, arg_0));
        }

        private static final List Saver$lambda$0(SaverScope $this$listSaver, DatePickerStateImpl it) {
            Intrinsics.checkNotNullParameter((Object)$this$listSaver, (String)"$this$listSaver");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Object[] objectArray = new Object[]{it.getSelectedDateMillis(), it.getDisplayedMonthMillis(), it.getYearRange().getFirst(), it.getYearRange().getLast(), it.getDisplayMode-jFl-4v0()};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private static final DatePickerStateImpl Saver$lambda$1(SelectableDates $selectableDates, Locale $locale, List value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Long l = (Long)value.get(0);
            Long l2 = (Long)value.get(1);
            Object e = value.get(2);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.Int");
            int n = (Integer)e;
            Object e2 = value.get(3);
            Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type kotlin.Int");
            IntRange intRange = new IntRange(n, ((Integer)e2).intValue());
            Object e3 = value.get(4);
            Intrinsics.checkNotNull(e3, (String)"null cannot be cast to non-null type kotlin.Int");
            return new DatePickerStateImpl(l, l2, intRange, DisplayMode.constructor-impl((Integer)e3), $selectableDates, $locale, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

