/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.db.task.ExecutionHistory;
import com.crosspaste.db.task.PasteTask;
import com.crosspaste.db.task.PasteTaskExtraInfo;
import com.crosspaste.net.clientapi.FailureResult;
import com.crosspaste.task.FailurePasteTaskResult;
import com.crosspaste.utils.DateUtils;
import com.crosspaste.utils.JsonUtils;
import com.crosspaste.utils.JsonUtils_desktopKt;
import io.github.oshai.kotlinlogging.KLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\n\u001a\u00028\u0000\"\b\b\u0000\u0010\u0005*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010JA\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u00162\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/crosspaste/utils/TaskUtils;", "", "<init>", "()V", "Lcom/crosspaste/db/task/PasteTaskExtraInfo;", "T", "Lcom/crosspaste/db/task/PasteTask;", "pasteTask", "Lkotlin/reflect/KClass;", "kclass", "getExtraInfo", "(Lcom/crosspaste/db/task/PasteTask;Lkotlin/reflect/KClass;)Lcom/crosspaste/db/task/PasteTaskExtraInfo;", "", "throwable", "", "createFailExtraInfo", "(Lcom/crosspaste/db/task/PasteTask;Ljava/lang/Throwable;)Ljava/lang/String;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lkotlin/Function0;", "", "retryHandler", "", "startTime", "", "Lcom/crosspaste/net/clientapi/FailureResult;", "fails", "extraInfo", "Lcom/crosspaste/task/FailurePasteTaskResult;", "createFailurePasteTaskResult", "(Lio/github/oshai/kotlinlogging/KLogger;Lkotlin/jvm/functions/Function0;JLjava/util/Collection;Lcom/crosspaste/db/task/PasteTaskExtraInfo;)Lcom/crosspaste/task/FailurePasteTaskResult;", "getStackTraceAsString", "(Ljava/lang/Throwable;)Ljava/lang/String;", "Lcom/crosspaste/utils/JsonUtils;", "jsonUtils", "Lcom/crosspaste/utils/JsonUtils;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nTaskUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskUtils.kt\ncom/crosspaste/utils/TaskUtils\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,95:1\n222#2:96\n205#2:97\n205#2:98\n*S KotlinDebug\n*F\n+ 1 TaskUtils.kt\ncom/crosspaste/utils/TaskUtils\n*L\n43#1:96\n55#1:97\n81#1:98\n*E\n"})
public final class TaskUtils {
    @NotNull
    public static final TaskUtils INSTANCE = new TaskUtils();
    @NotNull
    private static final JsonUtils jsonUtils = JsonUtils_desktopKt.getJsonUtils();
    public static final int $stable = 8;

    private TaskUtils() {
    }

    @NotNull
    public final <T extends PasteTaskExtraInfo> T getExtraInfo(@NotNull PasteTask pasteTask, @NotNull KClass<T> kclass) {
        Intrinsics.checkNotNullParameter((Object)pasteTask, (String)"pasteTask");
        Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
        KSerializer serializer2 = SerializersKt.serializer(kclass);
        return (T)((PasteTaskExtraInfo)jsonUtils.getJSON().decodeFromString((DeserializationStrategy)serializer2, pasteTask.getExtraInfo()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String createFailExtraInfo(@NotNull PasteTask pasteTask, @NotNull Throwable throwable) {
        void this_$iv;
        void this_$iv2;
        Intrinsics.checkNotNullParameter((Object)pasteTask, (String)"pasteTask");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        long currentTime = DateUtils.INSTANCE.nowEpochMilliseconds();
        long l = pasteTask.getModifyTime();
        String string2 = throwable.getMessage();
        if (string2 == null) {
            string2 = "Unknown error";
        }
        ExecutionHistory executionHistory = new ExecutionHistory(l, currentTime, 3, string2);
        Json json = jsonUtils.getJSON();
        String string$iv = pasteTask.getExtraInfo();
        boolean $i$f$decodeFromString22 = false;
        this_$iv2.getSerializersModule();
        JsonObject jsonObject = (JsonObject)this_$iv2.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), string$iv);
        Map mutableJsonObject = MapsKt.toMutableMap((Map)((Map)jsonObject));
        JsonElement jsonElement = jsonUtils.getJSON().encodeToJsonElement((SerializationStrategy)ExecutionHistory.Companion.serializer(), (Object)executionHistory);
        JsonElement jsonElement2 = (JsonElement)mutableJsonObject.get("executionHistories");
        if (jsonElement2 != null) {
            JsonElement it = jsonElement2;
            boolean bl = false;
            List list = CollectionsKt.toMutableList((Collection)((Collection)JsonElementKt.getJsonArray((JsonElement)it)));
            list.add(jsonElement);
            mutableJsonObject.put("executionHistories", new JsonArray(list));
        } else {
            TaskUtils $this$createFailExtraInfo_u24lambda_u241 = this;
            boolean bl = false;
            mutableJsonObject.put("executionHistories", new JsonArray(CollectionsKt.listOf((Object)jsonElement)));
        }
        Json $i$f$decodeFromString22 = jsonUtils.getJSON();
        JsonObject value$iv = new JsonObject(mutableJsonObject);
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FailurePasteTaskResult createFailurePasteTaskResult(@NotNull KLogger logger, @NotNull Function0<Boolean> retryHandler, long startTime, @NotNull Collection<FailureResult> fails, @NotNull PasteTaskExtraInfo extraInfo) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(retryHandler, (String)"retryHandler");
        Intrinsics.checkNotNullParameter(fails, (String)"fails");
        Intrinsics.checkNotNullParameter((Object)extraInfo, (String)"extraInfo");
        boolean needRetry = (Boolean)retryHandler.invoke();
        String failMessage = CollectionsKt.joinToString$default((Iterable)fails, (CharSequence)"\n", null, null, (int)3, null, TaskUtils::createFailurePasteTaskResult$lambda$2, (int)22, null);
        if (!needRetry) {
            logger.error(() -> TaskUtils.createFailurePasteTaskResult$lambda$3(failMessage));
        }
        extraInfo.getExecutionHistories().add(new ExecutionHistory(startTime, DateUtils.INSTANCE.nowEpochMilliseconds(), 3, failMessage));
        Json json = jsonUtils.getJSON();
        PasteTaskExtraInfo value$iv = extraInfo;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        return new FailurePasteTaskResult(this_$iv.encodeToString((SerializationStrategy)PasteTaskExtraInfo.Companion.serializer(), (Object)value$iv), needRetry);
    }

    private final String getStackTraceAsString(Throwable throwable) {
        List messages = new ArrayList();
        for (Throwable currentThrowable = throwable; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
            String message = Reflection.getOrCreateKotlinClass(currentThrowable.getClass()).getSimpleName() + ": " + currentThrowable.getMessage();
            messages.add(message);
        }
        return CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final CharSequence createFailurePasteTaskResult$lambda$2(FailureResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.getStackTraceAsString(it.getException());
    }

    private static final Object createFailurePasteTaskResult$lambda$3(String $failMessage) {
        return $failMessage;
    }
}

