/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001f\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0015R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/crosspaste/utils/FileNameNormalizer;", "", "<init>", "()V", "", "fileName", "", "replacement", "", "preserveExtension", "normalize", "(Ljava/lang/String;CZ)Ljava/lang/String;", "text", "", "maxBytes", "limitLength", "(Ljava/lang/String;I)Ljava/lang/String;", "isValid", "(Ljava/lang/String;)Z", "", "WINDOWS_RESERVED_NAMES", "Ljava/util/Set;", "ILLEGAL_CHARS", "CONTROL_CHARS", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nFileNameNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileNameNormalizer.kt\ncom/crosspaste/utils/FileNameNormalizer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1088#2,2:190\n1563#3:192\n1634#3,3:193\n*S KotlinDebug\n*F\n+ 1 FileNameNormalizer.kt\ncom/crosspaste/utils/FileNameNormalizer\n*L\n168#1:190,2\n52#1:192\n52#1:193,3\n*E\n"})
public final class FileNameNormalizer {
    @NotNull
    public static final FileNameNormalizer INSTANCE;
    @NotNull
    private static final Set<String> WINDOWS_RESERVED_NAMES;
    @NotNull
    private static final Set<Character> ILLEGAL_CHARS;
    @NotNull
    private static final Set<Character> CONTROL_CHARS;
    public static final int $stable;

    private FileNameNormalizer() {
    }

    @NotNull
    public final String normalize(@NotNull String fileName, char replacement, boolean preserveExtension) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (StringsKt.isBlank((CharSequence)fileName)) {
            return "unnamed";
        }
        int lastDotIdx = preserveExtension ? StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null) : -1;
        String baseName = null;
        String extension = null;
        if (preserveExtension && StringsKt.startsWith$default((CharSequence)fileName, (char)'.', (boolean)false, (int)2, null) && lastDotIdx == 0 && fileName.length() > 1) {
            baseName = "unnamed";
            extension = fileName;
        } else if (lastDotIdx > 0) {
            String string2 = fileName.substring(0, lastDotIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            baseName = string2;
            String string3 = fileName.substring(lastDotIdx);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            extension = string3;
        } else {
            baseName = fileName;
            extension = "";
        }
        Object object = new StringBuilder();
        StringBuilder $this$normalize_u24lambda_u241 = object;
        boolean bl = false;
        int n = baseName.length();
        for (int i = 0; i < n; ++i) {
            char ch = baseName.charAt(i);
            $this$normalize_u24lambda_u241.append(ILLEGAL_CHARS.contains(Character.valueOf(ch)) || CONTROL_CHARS.contains(Character.valueOf(ch)) || ch == '\u0000' ? replacement : ch);
        }
        Object normalized = ((StringBuilder)object).toString();
        String string4 = ((String)normalized).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
        if (WINDOWS_RESERVED_NAMES.contains(string4)) {
            normalized = (String)normalized + replacement;
        }
        object = new char[2];
        object[0] = 32;
        object[1] = 46;
        if (((CharSequence)(normalized = StringsKt.trim((String)normalized, (char[])object))).length() == 0) {
            normalized = "file";
        }
        int extBytes = StringsKt.encodeToByteArray((String)extension).length;
        int maxBaseNameBytes = Math.max(50, 255 - extBytes);
        normalized = this.limitLength((String)normalized, maxBaseNameBytes);
        if (preserveExtension && ((CharSequence)extension).length() > 0) {
            Object object2 = new StringBuilder();
            StringBuilder $this$normalize_u24lambda_u242 = object2;
            boolean bl2 = false;
            $this$normalize_u24lambda_u242.append('.');
            String string5 = StringsKt.drop((String)extension, (int)1);
            int n2 = string5.length();
            for (int i = 0; i < n2; ++i) {
                char ch = string5.charAt(i);
                $this$normalize_u24lambda_u242.append(ILLEGAL_CHARS.contains(Character.valueOf(ch)) || CONTROL_CHARS.contains(Character.valueOf(ch)) ? replacement : ch);
            }
            String string6 = ((StringBuilder)object2).toString();
            object2 = new char[2];
            object2[0] = 32;
            object2[1] = 46;
            String normalizedExt = StringsKt.trimEnd((String)string6, (char[])object2);
            return (String)normalized + normalizedExt;
        }
        return normalized;
    }

    public static /* synthetic */ String normalize$default(FileNameNormalizer fileNameNormalizer, String string2, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            c = (char)95;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return fileNameNormalizer.normalize(string2, c, bl);
    }

    private final String limitLength(String text, int maxBytes) {
        char ch;
        int chBytes;
        byte[] utf8 = StringsKt.encodeToByteArray((String)text);
        if (utf8.length <= maxBytes) {
            return text;
        }
        StringBuilder result2 = new StringBuilder();
        int byteCount = 0;
        int n = text.length();
        for (int i = 0; i < n && byteCount + (chBytes = StringsKt.encodeToByteArray((String)String.valueOf(ch = text.charAt(i))).length) <= maxBytes; ++i) {
            result2.append(ch);
            byteCount += chBytes;
        }
        String string2 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    public final boolean isValid(@NotNull String fileName) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            if (StringsKt.isBlank((CharSequence)fileName)) {
                return false;
            }
            CharSequence $this$any$iv = fileName;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(ILLEGAL_CHARS.contains(Character.valueOf(it)) || CONTROL_CHARS.contains(Character.valueOf(it)) || it == '\u0000')) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        String nameWithoutExt = StringsKt.substringBefore$default((String)fileName, (char)'.', null, (int)2, null);
        String string2 = nameWithoutExt.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (WINDOWS_RESERVED_NAMES.contains(string2)) {
            return false;
        }
        if (StringsKt.startsWith$default((CharSequence)fileName, (char)' ', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)fileName, (char)'.', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)fileName, (char)' ', (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)fileName, (char)'.', (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.encodeToByteArray((String)fileName).length <= 255;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new FileNameNormalizer();
        Object[] objectArray = new String[]{"CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"};
        WINDOWS_RESERVED_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Character[]{Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('\\'), Character.valueOf('/')};
        ILLEGAL_CHARS = SetsKt.setOf((Object[])objectArray);
        Iterable $this$map$iv = (Iterable)new IntRange(0, 31);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Character.valueOf((char)it));
        }
        CONTROL_CHARS = SetsKt.plus((Set)CollectionsKt.toSet((Iterable)((List)var3_3)), (Object)Character.valueOf('\u007f'));
        $stable = 8;
    }
}

