/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/crosspaste/utils/EncryptUtils;", "", "<init>", "()V", "Ljavax/crypto/SecretKey;", "generateAESKey", "()Ljavax/crypto/SecretKey;", "secretKey", "", "secretKeyToString", "(Ljavax/crypto/SecretKey;)Ljava/lang/String;", "encodedKey", "stringToSecretKey", "(Ljava/lang/String;)Ljavax/crypto/SecretKey;", "key", "", "data", "encryptData", "(Ljavax/crypto/SecretKey;[B)[B", "encryptedData", "decryptData", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "app"})
@StabilityInferred(parameters=0)
public final class EncryptUtils {
    @NotNull
    public static final EncryptUtils INSTANCE = new EncryptUtils();
    @NotNull
    private static final CodecsUtils codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
    public static final int $stable = 8;

    private EncryptUtils() {
    }

    @NotNull
    public final SecretKey generateAESKey() {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        SecretKey secretKey = keyGen.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
        return secretKey;
    }

    @NotNull
    public final String secretKeyToString(@NotNull SecretKey secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        byte[] encodedKey = secretKey.getEncoded();
        Intrinsics.checkNotNull((Object)encodedKey);
        return codecsUtils.base64Encode(encodedKey);
    }

    @NotNull
    public final SecretKey stringToSecretKey(@NotNull String encodedKey) {
        Intrinsics.checkNotNullParameter((Object)encodedKey, (String)"encodedKey");
        byte[] decodedKey = codecsUtils.base64Decode(encodedKey);
        return new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
    }

    @NotNull
    public final byte[] encryptData(@NotNull SecretKey key, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] ivBytes = new byte[cipher.getBlockSize()];
        new SecureRandom().nextBytes(ivBytes);
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        cipher.init(1, (Key)key, ivSpec);
        byte[] encrypted = cipher.doFinal(data);
        Intrinsics.checkNotNull((Object)encrypted);
        return ArraysKt.plus((byte[])ivBytes, (byte[])encrypted);
    }

    @NotNull
    public final byte[] decryptData(@NotNull SecretKey key, @NotNull byte[] encryptedData) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)encryptedData, (String)"encryptedData");
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        byte[] ivBytes = ArraysKt.copyOfRange((byte[])encryptedData, (int)0, (int)16);
        byte[] actualEncryptedData = ArraysKt.copyOfRange((byte[])encryptedData, (int)16, (int)encryptedData.length);
        IvParameterSpec ivSpec = new IvParameterSpec(ivBytes);
        cipher.init(2, (Key)key, ivSpec);
        byte[] byArray = cipher.doFinal(actualEncryptedData);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }
}

