/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.utils.LocaleUtils;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J\u000f\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\t\u0010\u0006J\u000f\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\n\u0010\u0006R\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/crosspaste/utils/DesktopLocaleUtils;", "Lcom/crosspaste/utils/LocaleUtils;", "<init>", "()V", "", "getCountry", "()Ljava/lang/String;", "getLanguage", "detectChineseVariant", "getLanguageTag", "getDisplayName", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "locale", "Ljava/util/Locale;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopLocaleUtils
implements LocaleUtils {
    @NotNull
    public static final DesktopLocaleUtils INSTANCE = new DesktopLocaleUtils();
    private static final Locale locale = Locale.getDefault();
    public static final int $stable = 8;

    private DesktopLocaleUtils() {
    }

    @Override
    @NotNull
    public String getCountry() {
        String string2 = locale.getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCountry(...)");
        return string2;
    }

    @Override
    @NotNull
    public String getLanguage() {
        String language = locale.getLanguage();
        Intrinsics.checkNotNull((Object)language);
        return !StringsKt.startsWith$default((String)language, (String)"zh", (boolean)false, (int)2, null) ? language : this.detectChineseVariant();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String detectChineseVariant() {
        Object $this$detectChineseVariant_u24lambda_u240;
        String string2 = locale.getCountry();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCountry(...)");
        String string3 = string2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String country = string3;
        Object object = country;
        switch (((String)object).hashCode()) {
            case 2466: {
                if (((String)object).equals("MO")) return "zh_hant";
                break;
            }
            case 2691: {
                if (((String)object).equals("TW")) return "zh_hant";
                break;
            }
            case 2307: {
                if (((String)object).equals("HK")) return "zh_hant";
                break;
            }
            case 2644: {
                if (((String)object).equals("SG")) return "zh";
                break;
            }
            case 2155: {
                if (!((String)object).equals("CN")) break;
                return "zh";
            }
        }
        object = this;
        try {
            String script;
            $this$detectChineseVariant_u24lambda_u240 = (DesktopLocaleUtils)object;
            boolean bl = false;
            String string4 = script = locale.getScript();
            if (Intrinsics.areEqual((Object)string4, (Object)"Hans")) {
                return "zh";
            }
            if (Intrinsics.areEqual((Object)string4, (Object)"Hant")) {
                return "zh_hant";
            }
            $this$detectChineseVariant_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            $this$detectChineseVariant_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        String languageTag = locale.toLanguageTag();
        Intrinsics.checkNotNull((Object)languageTag);
        if (StringsKt.contains$default((CharSequence)languageTag, (CharSequence)"Hans", (boolean)false, (int)2, null)) {
            return "zh";
        }
        if (StringsKt.contains$default((CharSequence)languageTag, (CharSequence)"Hant", (boolean)false, (int)2, null)) {
            return "zh_hant";
        }
        String variant = locale.getVariant();
        Intrinsics.checkNotNull((Object)variant);
        if (((CharSequence)variant).length() <= 0) return "zh";
        boolean bl = true;
        if (!bl) return "zh";
        String string5 = variant.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
        switch (string5) {
            case "TRAD": 
            case "TRADITIONAL": {
                return "zh_hant";
            }
            case "SIMPLIFIED": 
            case "SIMP": {
                return "zh";
            }
        }
        return "zh";
    }

    @Override
    @NotNull
    public String getLanguageTag() {
        String string2 = locale.toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLanguageTag(...)");
        return string2;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string2 = locale.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDisplayName(...)");
        return string2;
    }
}

