/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.platform.Platform;
import com.crosspaste.utils.DeviceUtils;
import com.crosspaste.utils.LinuxDeviceUtils;
import com.crosspaste.utils.MacosDeviceUtils;
import com.crosspaste.utils.WindowsDeviceUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\bJ\u000f\u0010\n\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/crosspaste/utils/DesktopDeviceUtils;", "Lcom/crosspaste/utils/DeviceUtils;", "Lcom/crosspaste/platform/Platform;", "platform", "<init>", "(Lcom/crosspaste/platform/Platform;)V", "", "createAppInstanceId", "()Ljava/lang/String;", "getDeviceId", "getDeviceName", "deviceUtils", "Lcom/crosspaste/utils/DeviceUtils;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopDeviceUtils
implements DeviceUtils {
    @NotNull
    private final DeviceUtils deviceUtils;
    public static final int $stable = 8;

    public DesktopDeviceUtils(@NotNull Platform platform) {
        DeviceUtils deviceUtils;
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (platform.isWindows()) {
            deviceUtils = WindowsDeviceUtils.INSTANCE;
        } else if (platform.isMacos()) {
            deviceUtils = MacosDeviceUtils.INSTANCE;
        } else if (platform.isLinux()) {
            deviceUtils = LinuxDeviceUtils.INSTANCE;
        } else {
            throw new IllegalStateException("Unknown platform: " + platform.getName());
        }
        this.deviceUtils = deviceUtils;
    }

    @NotNull
    public String createAppInstanceId() {
        return this.deviceUtils.createAppInstanceId();
    }

    @NotNull
    public String getDeviceId() {
        return this.deviceUtils.getDeviceId();
    }

    @NotNull
    public String getDeviceName() {
        return this.deviceUtils.getDeviceName();
    }
}

