/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import coil3.Image;
import coil3.Image_nonAndroidKt;
import com.crosspaste.utils.CoilUtils;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.Surface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ+\u0010\b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\b\u0010\rJ#\u0010\u0012\u001a\u00020\u00112\n\u0010\u000e\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/crosspaste/utils/DesktopCoilUtils;", "Lcom/crosspaste/utils/CoilUtils;", "<init>", "()V", "Lokio/Path;", "path", "Lorg/jetbrains/skia/Bitmap;", "Lcoil3/Bitmap;", "createBitmap", "(Lokio/Path;)Lorg/jetbrains/skia/Bitmap;", "", "width", "height", "(Lokio/Path;II)Lorg/jetbrains/skia/Bitmap;", "bitmap", "", "shareable", "Lcoil3/Image;", "asImage", "(Lorg/jetbrains/skia/Bitmap;Z)Lcoil3/Image;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "getFileUtils", "()Lcom/crosspaste/utils/FileUtils;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopCoilUtils
implements CoilUtils {
    @NotNull
    public static final DesktopCoilUtils INSTANCE = new DesktopCoilUtils();
    @NotNull
    private static final FileUtils fileUtils = FileUtils_desktopKt.getFileUtils();
    public static final int $stable = 8;

    private DesktopCoilUtils() {
    }

    @NotNull
    public final FileUtils getFileUtils() {
        return fileUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bitmap createBitmap(@NotNull Path path) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = new FileInputStream(path.toFile());
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            byte[] byArray = it.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            bitmap = SkiaImageAsset_skikoKt.asSkiaBitmap((ImageBitmap)SkiaImageAsset_skikoKt.toComposeImageBitmap((org.jetbrains.skia.Image)org.jetbrains.skia.Image.Companion.makeFromEncoded(byArray)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bitmap createBitmap(@NotNull Path path, int width, int height) {
        org.jetbrains.skia.Image image;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = new FileInputStream(path.toFile());
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream stream = (BufferedInputStream)closeable;
            boolean bl = false;
            byte[] byArray = stream.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            org.jetbrains.skia.Image originalImage = org.jetbrains.skia.Image.Companion.makeFromEncoded(byArray);
            int actualCropWidth = Math.min(width, originalImage.getWidth());
            int actualCropHeight = Math.min(height, originalImage.getHeight());
            Surface surface = Surface.Companion.makeRasterN32Premul(actualCropWidth, actualCropHeight);
            surface.getCanvas().drawImageRect(originalImage, Rect.Companion.makeXYWH(0.0f, 0.0f, (float)actualCropWidth, (float)actualCropHeight), Rect.Companion.makeWH((float)actualCropWidth, (float)actualCropHeight));
            image = surface.makeImageSnapshot();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return SkiaImageAsset_skikoKt.asSkiaBitmap((ImageBitmap)SkiaImageAsset_skikoKt.toComposeImageBitmap((org.jetbrains.skia.Image)image));
    }

    @Override
    @NotNull
    public Image asImage(@NotNull Bitmap bitmap, boolean shareable) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        return (Image)Image_nonAndroidKt.asImage((Bitmap)bitmap, (boolean)shareable);
    }

    @Override
    @NotNull
    public Image createImage(@NotNull Path path) {
        return CoilUtils.super.createImage(path);
    }

    @Override
    @NotNull
    public Image createImage(@NotNull Path path, int width, int height) {
        return CoilUtils.super.createImage(path, width, height);
    }
}

