/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.dto.secure.PairingRequest;
import com.crosspaste.dto.secure.PairingResponse;
import com.crosspaste.secure.SecureKeyPair;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.Digest;
import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.algorithms.ECDH;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.algorithms.SHA256;
import dev.whyoleg.cryptography.materials.key.KeyGenerator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J#\u0010\f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ+\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\n2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J%\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001d\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0014\u0010%\u001a\u00020$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R\u0014\u0010(\u001a\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)\u00a8\u0006*"}, d2={"Lcom/crosspaste/utils/CryptographyUtils;", "", "<init>", "()V", "Lcom/crosspaste/secure/SecureKeyPair;", "generateSecureKeyPair", "()Lcom/crosspaste/secure/SecureKeyPair;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "privateKey", "Lkotlin/Function0;", "", "createSignData", "signData", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;Lkotlin/jvm/functions/Function0;)[B", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "publicKey", "signature", "createVerifyData", "", "verifyData", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;[BLkotlin/jvm/functions/Function0;)Z", "Lcom/crosspaste/dto/secure/PairingRequest;", "pairingRequest", "signPairingRequest", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;Lcom/crosspaste/dto/secure/PairingRequest;)[B", "verifyPairingRequest", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;Lcom/crosspaste/dto/secure/PairingRequest;[B)Z", "Lcom/crosspaste/dto/secure/PairingResponse;", "pairingResponse", "signPairingResponse", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;Lcom/crosspaste/dto/secure/PairingResponse;)[B", "verifyPairingResponse", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;Lcom/crosspaste/dto/secure/PairingResponse;[B)Z", "Ldev/whyoleg/cryptography/CryptographyProvider;", "provider", "Ldev/whyoleg/cryptography/CryptographyProvider;", "Ldev/whyoleg/cryptography/algorithms/Digest;", "sha256", "Ldev/whyoleg/cryptography/algorithms/Digest;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "app"})
@StabilityInferred(parameters=0)
public final class CryptographyUtils {
    @NotNull
    public static final CryptographyUtils INSTANCE = new CryptographyUtils();
    @NotNull
    private static final CryptographyProvider provider = CryptographyProvider.Companion.getDefault();
    @NotNull
    private static final Digest sha256 = (Digest)provider.get((CryptographyAlgorithmId)SHA256.INSTANCE);
    @NotNull
    private static final CodecsUtils codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
    public static final int $stable = 8;

    private CryptographyUtils() {
    }

    @NotNull
    public final SecureKeyPair generateSecureKeyPair() {
        CryptographyProvider provider = CryptographyProvider.Companion.getDefault();
        ECDSA ecdsa = (ECDSA)provider.get((CryptographyAlgorithmId)ECDSA.Companion);
        ECDH ecdh = (ECDH)provider.get((CryptographyAlgorithmId)ECDH.Companion);
        KeyGenerator signKeyPairGenerator = ecdsa.keyPairGenerator-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk());
        ECDSA.KeyPair signKeyPair = (ECDSA.KeyPair)signKeyPairGenerator.generateKeyBlocking();
        KeyGenerator cryptKeyPairGenerator = ecdh.keyPairGenerator-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk());
        ECDH.KeyPair cryptKeyPair = (ECDH.KeyPair)cryptKeyPairGenerator.generateKeyBlocking();
        return new SecureKeyPair(signKeyPair, cryptKeyPair);
    }

    @NotNull
    public final byte[] signData(@NotNull ECDSA.PrivateKey privateKey, @NotNull Function0<byte[]> createSignData) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter(createSignData, (String)"createSignData");
        return privateKey.signatureGenerator(sha256.getId(), ECDSA.SignatureFormat.DER).generateSignatureBlocking((byte[])createSignData.invoke());
    }

    public final boolean verifyData(@NotNull ECDSA.PublicKey publicKey, @NotNull byte[] signature, @NotNull Function0<byte[]> createVerifyData) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Intrinsics.checkNotNullParameter(createVerifyData, (String)"createVerifyData");
        return publicKey.signatureVerifier(sha256.getId(), ECDSA.SignatureFormat.DER).tryVerifySignatureBlocking((byte[])createVerifyData.invoke(), signature);
    }

    @NotNull
    public final byte[] signPairingRequest(@NotNull ECDSA.PrivateKey privateKey, @NotNull PairingRequest pairingRequest) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)pairingRequest, (String)"pairingRequest");
        return this.signData(privateKey, (Function0<byte[]>)((Function0)() -> CryptographyUtils.signPairingRequest$lambda$1(pairingRequest)));
    }

    public final boolean verifyPairingRequest(@NotNull ECDSA.PublicKey publicKey, @NotNull PairingRequest pairingRequest, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)pairingRequest, (String)"pairingRequest");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return this.verifyData(publicKey, signature, (Function0<byte[]>)((Function0)() -> CryptographyUtils.verifyPairingRequest$lambda$3(pairingRequest)));
    }

    @NotNull
    public final byte[] signPairingResponse(@NotNull ECDSA.PrivateKey privateKey, @NotNull PairingResponse pairingResponse) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)pairingResponse, (String)"pairingResponse");
        return this.signData(privateKey, (Function0<byte[]>)((Function0)() -> CryptographyUtils.signPairingResponse$lambda$5(pairingResponse)));
    }

    public final boolean verifyPairingResponse(@NotNull ECDSA.PublicKey publicKey, @NotNull PairingResponse pairingResponse, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)pairingResponse, (String)"pairingResponse");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        return this.verifyData(publicKey, signature, (Function0<byte[]>)((Function0)() -> CryptographyUtils.verifyPairingResponse$lambda$7(pairingResponse)));
    }

    private static final byte[] signPairingRequest$lambda$1(PairingRequest $pairingRequest) {
        StringBuilder stringBuilder;
        StringBuilder $this$signPairingRequest_u24lambda_u241_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$signPairingRequest_u24lambda_u241_u24lambda_u240.append(codecsUtils.base64Encode($pairingRequest.getSignPublicKey()));
        $this$signPairingRequest_u24lambda_u241_u24lambda_u240.append(codecsUtils.base64Encode($pairingRequest.getCryptPublicKey()));
        $this$signPairingRequest_u24lambda_u241_u24lambda_u240.append($pairingRequest.getToken());
        $this$signPairingRequest_u24lambda_u241_u24lambda_u240.append($pairingRequest.getTimestamp());
        return StringsKt.encodeToByteArray((String)stringBuilder.toString());
    }

    private static final byte[] verifyPairingRequest$lambda$3(PairingRequest $pairingRequest) {
        StringBuilder stringBuilder;
        StringBuilder $this$verifyPairingRequest_u24lambda_u243_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$verifyPairingRequest_u24lambda_u243_u24lambda_u242.append(codecsUtils.base64Encode($pairingRequest.getSignPublicKey()));
        $this$verifyPairingRequest_u24lambda_u243_u24lambda_u242.append(codecsUtils.base64Encode($pairingRequest.getCryptPublicKey()));
        $this$verifyPairingRequest_u24lambda_u243_u24lambda_u242.append($pairingRequest.getToken());
        $this$verifyPairingRequest_u24lambda_u243_u24lambda_u242.append($pairingRequest.getTimestamp());
        return StringsKt.encodeToByteArray((String)stringBuilder.toString());
    }

    private static final byte[] signPairingResponse$lambda$5(PairingResponse $pairingResponse) {
        StringBuilder stringBuilder;
        StringBuilder $this$signPairingResponse_u24lambda_u245_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$signPairingResponse_u24lambda_u245_u24lambda_u244.append(codecsUtils.base64Encode($pairingResponse.getSignPublicKey()));
        $this$signPairingResponse_u24lambda_u245_u24lambda_u244.append(codecsUtils.base64Encode($pairingResponse.getCryptPublicKey()));
        $this$signPairingResponse_u24lambda_u245_u24lambda_u244.append($pairingResponse.getTimestamp());
        return StringsKt.encodeToByteArray((String)stringBuilder.toString());
    }

    private static final byte[] verifyPairingResponse$lambda$7(PairingResponse $pairingResponse) {
        StringBuilder stringBuilder;
        StringBuilder $this$verifyPairingResponse_u24lambda_u247_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$verifyPairingResponse_u24lambda_u247_u24lambda_u246.append(codecsUtils.base64Encode($pairingResponse.getSignPublicKey()));
        $this$verifyPairingResponse_u24lambda_u247_u24lambda_u246.append(codecsUtils.base64Encode($pairingResponse.getCryptPublicKey()));
        $this$verifyPairingResponse_u24lambda_u247_u24lambda_u246.append($pairingResponse.getTimestamp());
        return StringsKt.encodeToByteArray((String)stringBuilder.toString());
    }
}

