/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import com.crosspaste.utils.CssColor;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0010\u0014\n\u0002\b.\n\u0002\u0010\u0015\n\u0002\b&\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\fJ\u0015\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000e\u0010\fJ\u0015\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\fJ\u001f\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0011\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0014J\u0015\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u0017J\u0015\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u0017J\u0015\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013\u00a2\u0006\u0004\b\u001d\u0010\u001aJ%\u0010!\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b#\u0010$J%\u0010(\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0010\u00a2\u0006\u0004\b(\u0010\"J%\u0010*\u001a\u00020)2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0010\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b/\u00100J1\u0010\t\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00102\b\b\u0002\u00104\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b5\u00106J\u0017\u00107\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b7\u00100J\u0017\u00108\u001a\u00020\u00132\u0006\u0010,\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b8\u00100J\u0019\u0010:\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b9\u0010\bJ\u0019\u0010<\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b;\u0010\bJ\u0019\u0010>\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b=\u0010\bJ\u0019\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b?\u0010\bJ\u0017\u0010C\u001a\u0004\u0018\u00010\u00062\u0006\u0010A\u001a\u00020\u0004\u00a2\u0006\u0004\bB\u0010\bJ%\u0010I\u001a\u00020\u00062\u0006\u0010D\u001a\u00020\u00132\u0006\u0010E\u001a\u00020\u00132\u0006\u0010F\u001a\u00020\u0013\u00a2\u0006\u0004\bG\u0010HJ\u0011\u0010L\u001a\u00020)*\u00020\u0006\u00a2\u0006\u0004\bJ\u0010KJ1\u0010S\u001a\u00020\u00062\u0006\u0010M\u001a\u00020\u00062\u0006\u0010N\u001a\u00020\u00132\b\b\u0002\u0010O\u001a\u00020\u00132\b\b\u0002\u0010P\u001a\u00020\u0013\u00a2\u0006\u0004\bQ\u0010RJ%\u0010T\u001a\u00020)2\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010\u00a2\u0006\u0004\bT\u0010+J%\u0010U\u001a\u00020\n2\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010\u00a2\u0006\u0004\bU\u0010VJ%\u0010Y\u001a\u00020X2\u0006\u0010D\u001a\u00020\u00132\u0006\u0010E\u001a\u00020\u00132\u0006\u0010W\u001a\u00020\u0013\u00a2\u0006\u0004\bY\u0010ZJ\u0015\u0010^\u001a\u00020\n2\u0006\u0010[\u001a\u00020\u0006\u00a2\u0006\u0004\b\\\u0010]J\u0011\u0010a\u001a\u00020\u0004*\u00020\u0006\u00a2\u0006\u0004\b_\u0010`J\u0011\u0010c\u001a\u00020\u0004*\u00020\u0006\u00a2\u0006\u0004\bb\u0010`J\u0011\u0010f\u001a\u00020\u0006*\u00020\u0006\u00a2\u0006\u0004\bd\u0010eJ\u0013\u0010h\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a2\u0006\u0004\bg\u0010eJ\u001f\u0010m\u001a\u00020\u00132\u0006\u0010i\u001a\u00020\u00062\u0006\u0010j\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\bk\u0010lR\u0014\u0010n\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bn\u0010oR\u0014\u0010p\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bp\u0010oR\u0014\u0010q\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bq\u0010oR\u0014\u0010r\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\br\u0010oR\u0014\u0010s\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bs\u0010oR\u0014\u0010t\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bt\u0010oR\u0014\u0010u\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bu\u0010oR\u0014\u0010v\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bv\u0010oR\u0014\u0010w\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\bw\u0010xR\u0014\u0010y\u001a\u00020\u00138\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\by\u0010xR\u0014\u0010z\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bz\u0010{R\u0014\u0010|\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b|\u0010{R\u0014\u0010}\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b}\u0010{R\u0014\u0010~\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b~\u0010{R\u0017\u0010\u0080\u0001\u001a\u00020\u007f8\u0002X\u0082T\u00a2\u0006\b\n\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0016\u0010\u0082\u0001\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0007\n\u0005\b\u0082\u0001\u0010{R\u0016\u0010\u0083\u0001\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0007\n\u0005\b\u0083\u0001\u0010{R\u0016\u0010\u0084\u0001\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0007\n\u0005\b\u0084\u0001\u0010{R\u0016\u0010\u0085\u0001\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0007\n\u0005\b\u0085\u0001\u0010{R\u0016\u0010\u0086\u0001\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0007\n\u0005\b\u0086\u0001\u0010{R\u0016\u0010\u0087\u0001\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0007\n\u0005\b\u0087\u0001\u0010{R\u0018\u0010\u0089\u0001\u001a\u00030\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0089\u0001\u0010\u008a\u0001R\u0018\u0010\u008b\u0001\u001a\u00030\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008b\u0001\u0010\u008a\u0001R\u0018\u0010\u008c\u0001\u001a\u00030\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008c\u0001\u0010\u008a\u0001R\u0018\u0010\u008d\u0001\u001a\u00030\u0088\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u008d\u0001\u0010\u008a\u0001\u00a8\u0006\u008e\u0001"}, d2={"Lcom/crosspaste/utils/ColorUtils;", "", "<init>", "()V", "", "value", "Landroidx/compose/ui/graphics/Color;", "toColor-ijrfgN4", "(Ljava/lang/String;)Landroidx/compose/ui/graphics/Color;", "toColor", "", "isRGBColorValue", "(Ljava/lang/String;)Z", "isRGBAColorValue", "isHSLColorValue", "isHSLAColorValue", "", "mod", "(II)I", "", "(FI)F", "rgbPart", "getRGBValue", "(I)I", "opacity", "getOpacityToUse", "(F)F", "hslPart", "getHSLHueValue", "getHSLPercentageValue", "hue", "saturation", "lightness", "getHSLColorValue", "(III)Ljava/lang/String;", "getRGBPartAsHexString", "(I)Ljava/lang/String;", "red", "green", "blue", "getHexColorValue", "", "getRGBAsHSLValue", "(III)[F", "part", "parseRgbComponent", "(Ljava/lang/String;)I", "parseOpacity", "(Ljava/lang/String;)F", "r", "g", "b", "a", "toColor-wmQWz5c", "(IIIF)J", "parseHue", "parsePct01", "getParsedRGBColorValue-ijrfgN4", "getParsedRGBColorValue", "getParsedRGBAColorValue-ijrfgN4", "getParsedRGBAColorValue", "getParsedHSLColorValue-ijrfgN4", "getParsedHSLColorValue", "getParsedHSLAColorValue-ijrfgN4", "getParsedHSLAColorValue", "hex", "parseHexColor-ijrfgN4", "parseHexColor", "h", "s", "l", "hslToColor-XeAY9LY", "(FFF)J", "hslToColor", "toHSL-8_81llA", "(J)[F", "toHSL", "backgroundColor", "targetHue", "baseSaturation", "baseLightness", "getAdaptiveColor-eb82Cgs", "(JFFF)J", "getAdaptiveColor", "rgbToHsv", "isNearWhiteOrBlack", "(III)Z", "v", "", "hsvToRgb", "(FFF)[I", "color", "isDarkColor-8_81llA", "(J)Z", "isDarkColor", "toHexString-8_81llA", "(J)Ljava/lang/String;", "toHexString", "toRGBString-8_81llA", "toRGBString", "getBestTextColor-l2rxGTc", "(J)J", "getBestTextColor", "getEnhancedContrastColor-l2rxGTc", "getEnhancedContrastColor", "color1", "color2", "calculateContrast--OWjLjI", "(JJ)F", "calculateContrast", "RGB_MIN", "I", "RGB_MAX", "RGB_RANGE", "HSL_MIN", "HSL_MAX", "HSL_RANGE", "PERCENTAGE_MIN", "PERCENTAGE_MAX", "OPACITY_MIN", "F", "OPACITY_MAX", "PREFIX_RGB", "Ljava/lang/String;", "PREFIX_RGBA", "PREFIX_HSL", "PREFIX_HSLA", "", "PREFIX_HEX", "C", "PREFIX_HSL_OPEN", "SUFFIX_HSL_CLOSE", "TRANSPARENT", "PATTERN_PART_VALUE", "PATTERN_PART_PERCENTAGE", "PATTERN_PART_OPACITY", "Lkotlin/text/Regex;", "PATTERN_RGB", "Lkotlin/text/Regex;", "PATTERN_RGBA", "PATTERN_HSL", "PATTERN_HSLA", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nColorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorUtils.kt\ncom/crosspaste/utils/ColorUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,688:1\n1#2:689\n*E\n"})
public final class ColorUtils {
    @NotNull
    public static final ColorUtils INSTANCE = new ColorUtils();
    public static final int RGB_MIN = 0;
    public static final int RGB_MAX = 255;
    public static final int RGB_RANGE = 256;
    public static final int HSL_MIN = 0;
    public static final int HSL_MAX = 359;
    public static final int HSL_RANGE = 360;
    public static final int PERCENTAGE_MIN = 0;
    public static final int PERCENTAGE_MAX = 100;
    public static final float OPACITY_MIN = 0.0f;
    public static final float OPACITY_MAX = 1.0f;
    @NotNull
    private static final String PREFIX_RGB = "rgb";
    @NotNull
    private static final String PREFIX_RGBA = "rgba";
    @NotNull
    private static final String PREFIX_HSL = "hsl";
    @NotNull
    private static final String PREFIX_HSLA = "hsla";
    private static final char PREFIX_HEX = '#';
    @NotNull
    private static final String PREFIX_HSL_OPEN = "hsl(";
    @NotNull
    private static final String SUFFIX_HSL_CLOSE = ")";
    @NotNull
    private static final String TRANSPARENT = "transparent";
    @NotNull
    private static final String PATTERN_PART_VALUE = "((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)";
    @NotNull
    private static final String PATTERN_PART_PERCENTAGE = "((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))";
    @NotNull
    private static final String PATTERN_PART_OPACITY = "([0-9]*\\.[0-9]*|[0-9]+)";
    @NotNull
    private static final Regex PATTERN_RGB = new Regex("^rgb\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*\\)$");
    @NotNull
    private static final Regex PATTERN_RGBA = new Regex("^rgba\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$");
    @NotNull
    private static final Regex PATTERN_HSL = new Regex("^hsl\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*\\)$");
    @NotNull
    private static final Regex PATTERN_HSLA = new Regex("^hsla\\s*\\(\\s*((?:\\+|\\-)?(?:[0-9]*\\.[0-9]*|[0-9]+)%?)\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*((?:\\+|\\-)?(?:(?:[0-9]*\\.[0-9]*|[0-9]+)%|0))\\s*,\\s*([0-9]*\\.[0-9]*|[0-9]+)\\s*\\)$");
    public static final int $stable = 8;

    private ColorUtils() {
    }

    @Nullable
    public final Color toColor-ijrfgN4(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Color color = this.parseHexColor-ijrfgN4(value);
        if (color != null) {
            long color2 = color.unbox-impl();
            boolean bl = false;
            return Color.box-impl((long)color2);
        }
        if (this.isRGBColorValue(value)) {
            return this.getParsedRGBColorValue-ijrfgN4(value);
        }
        if (this.isRGBAColorValue(value)) {
            return this.getParsedRGBAColorValue-ijrfgN4(value);
        }
        if (this.isHSLColorValue(value)) {
            return this.getParsedHSLColorValue-ijrfgN4(value);
        }
        if (this.isHSLAColorValue(value)) {
            return this.getParsedHSLAColorValue-ijrfgN4(value);
        }
        if (CssColor.Companion.isCssColor(value)) {
            return CssColor.Companion.colorOf-6MYuD4A$default(CssColor.Companion, value, 0.0f, 2, null);
        }
        if (Intrinsics.areEqual((Object)value, (Object)TRANSPARENT)) {
            return Color.box-impl((long)ColorKt.Color$default((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, null, (int)16, null));
        }
        return null;
    }

    public final boolean isRGBColorValue(@Nullable String value) {
        String string2 = value;
        String realValue = string2 != null ? ((Object)StringsKt.trim((CharSequence)string2)).toString() : null;
        CharSequence charSequence = realValue;
        return !(charSequence == null || charSequence.length() == 0) && StringsKt.startsWith$default((String)realValue, (String)PREFIX_RGB, (boolean)false, (int)2, null) && PATTERN_RGB.matches((CharSequence)realValue);
    }

    public final boolean isRGBAColorValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String realValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        return StringsKt.startsWith$default((String)realValue, (String)PREFIX_RGBA, (boolean)false, (int)2, null) && PATTERN_RGBA.matches((CharSequence)realValue);
    }

    public final boolean isHSLColorValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String realValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        return StringsKt.startsWith$default((String)realValue, (String)PREFIX_HSL, (boolean)false, (int)2, null) && PATTERN_HSL.matches((CharSequence)realValue);
    }

    public final boolean isHSLAColorValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String realValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
        return StringsKt.startsWith$default((String)realValue, (String)PREFIX_HSLA, (boolean)false, (int)2, null) && PATTERN_HSLA.matches((CharSequence)realValue);
    }

    private final int mod(int value, int mod) {
        int positiveValue;
        for (positiveValue = value; positiveValue < 0; positiveValue += mod) {
        }
        return positiveValue % mod;
    }

    private final float mod(float value, int mod) {
        float positiveValue;
        for (positiveValue = value; positiveValue < 0.0f; positiveValue += (float)mod) {
        }
        return positiveValue % (float)mod;
    }

    public final int getRGBValue(int rgbPart) {
        return this.mod(rgbPart, 256);
    }

    public final float getOpacityToUse(float opacity) {
        return opacity < 0.0f ? 0.0f : (opacity > 1.0f ? 1.0f : opacity);
    }

    public final int getHSLHueValue(int hslPart) {
        return this.mod(hslPart, 360);
    }

    public final float getHSLHueValue(float hslPart) {
        return this.mod(hslPart, 360);
    }

    public final int getHSLPercentageValue(int hslPart) {
        return hslPart < 0 ? 0 : (hslPart > 100 ? 100 : hslPart);
    }

    public final float getHSLPercentageValue(float hslPart) {
        return hslPart < 0.0f ? 0.0f : (hslPart > 100.0f ? 100.0f : hslPart);
    }

    @NotNull
    public final String getHSLColorValue(int hue, int saturation, int lightness) {
        StringBuilder stringBuilder;
        StringBuilder $this$getHSLColorValue_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getHSLColorValue_u24lambda_u241.append(PREFIX_HSL_OPEN);
        $this$getHSLColorValue_u24lambda_u241.append(INSTANCE.getHSLHueValue(hue));
        $this$getHSLColorValue_u24lambda_u241.append(',');
        $this$getHSLColorValue_u24lambda_u241.append(INSTANCE.getHSLPercentageValue(saturation));
        $this$getHSLColorValue_u24lambda_u241.append("%,");
        $this$getHSLColorValue_u24lambda_u241.append(INSTANCE.getHSLPercentageValue(lightness));
        $this$getHSLColorValue_u24lambda_u241.append("%");
        $this$getHSLColorValue_u24lambda_u241.append(SUFFIX_HSL_CLOSE);
        return stringBuilder.toString();
    }

    private final String getRGBPartAsHexString(int rgbPart) {
        int value = this.getRGBValue(rgbPart);
        String string2 = Integer.toString(value, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = StringsKt.padStart((String)string2, (int)2, (char)'0').toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        return string3;
    }

    @NotNull
    public final String getHexColorValue(int red, int green, int blue) {
        StringBuilder stringBuilder;
        StringBuilder $this$getHexColorValue_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getHexColorValue_u24lambda_u242.append('#');
        $this$getHexColorValue_u24lambda_u242.append(INSTANCE.getRGBPartAsHexString(red));
        $this$getHexColorValue_u24lambda_u242.append(INSTANCE.getRGBPartAsHexString(green));
        $this$getHexColorValue_u24lambda_u242.append(INSTANCE.getRGBPartAsHexString(blue));
        return stringBuilder.toString();
    }

    @NotNull
    public final float[] getRGBAsHSLValue(int red, int green, int blue) {
        float f;
        int cmin;
        int cmax;
        int n = cmax = red > green ? red : green;
        if (blue > cmax) {
            cmax = blue;
        }
        int n2 = cmin = red < green ? red : green;
        if (blue < cmin) {
            cmin = blue;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            f = 0.0f;
        } else {
            float redc = (float)(cmax - red) / (float)(cmax - cmin);
            float greenc = (float)(cmax - green) / (float)(cmax - cmin);
            float bluec = (float)(cmax - blue) / (float)(cmax - cmin);
            int n3 = cmax;
            float h = n3 == red ? bluec - greenc : (n3 == green ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
            f = h;
        }
        float hue = f;
        float[] fArray = new float[]{hue * (float)359, saturation * (float)100, brightness * (float)100};
        return fArray;
    }

    private final int parseRgbComponent(String part) {
        int n;
        String s = ((Object)StringsKt.trim((CharSequence)part)).toString();
        if (StringsKt.endsWith$default((String)s, (String)"%", (boolean)false, (int)2, null)) {
            Float f = StringsKt.toFloatOrNull((String)StringsKt.dropLast((String)s, (int)1));
            float pct = f != null ? f.floatValue() : 0.0f;
            n = MathKt.roundToInt((float)(pct / 100.0f * (float)255));
        } else {
            Float f = StringsKt.toFloatOrNull((String)s);
            n = f != null ? MathKt.roundToInt((float)f.floatValue()) : 0;
        }
        int value = n;
        return RangesKt.coerceIn((int)value, (int)0, (int)255);
    }

    private final float parseOpacity(String part) {
        Float f = StringsKt.toFloatOrNull((String)((Object)StringsKt.trim((CharSequence)part)).toString());
        float f2 = f != null ? f.floatValue() : 1.0f;
        return this.getOpacityToUse(f2);
    }

    private final long toColor-wmQWz5c(int r, int g, int b, float a) {
        return ColorKt.Color$default((float)((float)RangesKt.coerceIn((int)r, (int)0, (int)255) / 255.0f), (float)((float)RangesKt.coerceIn((int)g, (int)0, (int)255) / 255.0f), (float)((float)RangesKt.coerceIn((int)b, (int)0, (int)255) / 255.0f), (float)this.getOpacityToUse(a), null, (int)16, null);
    }

    static /* synthetic */ long toColor-wmQWz5c$default(ColorUtils colorUtils, int n, int n2, int n3, float f, int n4, Object object) {
        if ((n4 & 8) != 0) {
            f = 1.0f;
        }
        return colorUtils.toColor-wmQWz5c(n, n2, n3, f);
    }

    private final float parseHue(String part) {
        float f;
        String s = ((Object)StringsKt.trim((CharSequence)part)).toString();
        if (StringsKt.endsWith$default((String)s, (String)"%", (boolean)false, (int)2, null)) {
            Float f2 = StringsKt.toFloatOrNull((String)StringsKt.dropLast((String)s, (int)1));
            f = (f2 != null ? f2.floatValue() : 0.0f) / 100.0f * (float)360;
        } else {
            Float f3 = StringsKt.toFloatOrNull((String)s);
            f = f3 != null ? f3.floatValue() : 0.0f;
        }
        float raw = f;
        return this.getHSLHueValue(raw);
    }

    private final float parsePct01(String part) {
        float f;
        String s = ((Object)StringsKt.trim((CharSequence)part)).toString();
        if (StringsKt.endsWith$default((String)s, (String)"%", (boolean)false, (int)2, null)) {
            Float f2 = StringsKt.toFloatOrNull((String)StringsKt.dropLast((String)s, (int)1));
            f = f2 != null ? f2.floatValue() : 0.0f;
        } else {
            Float f3 = StringsKt.toFloatOrNull((String)s);
            f = f3 != null ? f3.floatValue() : 0.0f;
        }
        float pct = f;
        return RangesKt.coerceIn((float)this.getHSLPercentageValue(pct), (float)0.0f, (float)100.0f) / 100.0f;
    }

    @Nullable
    public final Color getParsedRGBColorValue-ijrfgN4(@Nullable String value) {
        String string2 = value;
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            return null;
        }
        String real = string2;
        if (!StringsKt.startsWith((String)real, (String)PREFIX_RGB, (boolean)true)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)PATTERN_RGB, (CharSequence)real, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult m = matchResult;
        List it = m.getGroupValues();
        boolean bl = false;
        Triple triple = new Triple(it.get(1), it.get(2), it.get(3));
        String rStr = (String)triple.component1();
        String gStr = (String)triple.component2();
        String bStr = (String)triple.component3();
        int r = this.parseRgbComponent(rStr);
        int g = this.parseRgbComponent(gStr);
        int b = this.parseRgbComponent(bStr);
        return Color.box-impl((long)ColorUtils.toColor-wmQWz5c$default(this, r, g, b, 0.0f, 8, null));
    }

    @Nullable
    public final Color getParsedRGBAColorValue-ijrfgN4(@Nullable String value) {
        String string2 = value;
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            return null;
        }
        String real = string2;
        if (!StringsKt.startsWith((String)real, (String)PREFIX_RGBA, (boolean)true)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)PATTERN_RGBA, (CharSequence)real, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult m = matchResult;
        int r = this.parseRgbComponent((String)m.getGroupValues().get(1));
        int g = this.parseRgbComponent((String)m.getGroupValues().get(2));
        int b = this.parseRgbComponent((String)m.getGroupValues().get(3));
        float a = this.parseOpacity((String)m.getGroupValues().get(4));
        return Color.box-impl((long)this.toColor-wmQWz5c(r, g, b, a));
    }

    @Nullable
    public final Color getParsedHSLColorValue-ijrfgN4(@Nullable String value) {
        String string2 = value;
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            return null;
        }
        String real = string2;
        if (!StringsKt.startsWith((String)real, (String)PREFIX_HSL, (boolean)true)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)PATTERN_HSL, (CharSequence)real, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult m = matchResult;
        float h = this.parseHue((String)m.getGroupValues().get(1));
        float s01 = this.parsePct01((String)m.getGroupValues().get(2));
        float l01 = this.parsePct01((String)m.getGroupValues().get(3));
        return Color.box-impl((long)this.hslToColor-XeAY9LY(h / 360.0f, s01, l01));
    }

    @Nullable
    public final Color getParsedHSLAColorValue-ijrfgN4(@Nullable String value) {
        String string2 = value;
        if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) {
            return null;
        }
        String real = string2;
        if (!StringsKt.startsWith((String)real, (String)PREFIX_HSLA, (boolean)true)) {
            return null;
        }
        MatchResult matchResult = Regex.find$default((Regex)PATTERN_HSLA, (CharSequence)real, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult m = matchResult;
        float h = this.parseHue((String)m.getGroupValues().get(1));
        float s01 = this.parsePct01((String)m.getGroupValues().get(2));
        float l01 = this.parsePct01((String)m.getGroupValues().get(3));
        float a = this.parseOpacity((String)m.getGroupValues().get(4));
        long color = this.hslToColor-XeAY9LY(h / 360.0f, s01, l01);
        return Color.box-impl((long)Color.copy-wmQWz5c$default((long)color, (float)a, (float)0.0f, (float)0.0f, (float)0.0f, (int)14, null));
    }

    @Nullable
    public final Color parseHexColor-ijrfgN4(@NotNull String hex) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)hex, (String)"hex");
        String cleanHex = StringsKt.removePrefix((String)hex, (CharSequence)"#");
        switch (cleanHex.length()) {
            case 3: {
                Integer n = StringsKt.toIntOrNull((String)StringsKt.repeat((CharSequence)String.valueOf(cleanHex.charAt(0)), (int)2), (int)16);
                if (n == null) {
                    return null;
                }
                int r = n;
                Integer n2 = StringsKt.toIntOrNull((String)StringsKt.repeat((CharSequence)String.valueOf(cleanHex.charAt(1)), (int)2), (int)16);
                if (n2 == null) {
                    return null;
                }
                int g = n2;
                Integer n3 = StringsKt.toIntOrNull((String)StringsKt.repeat((CharSequence)String.valueOf(cleanHex.charAt(2)), (int)2), (int)16);
                if (n3 == null) {
                    return null;
                }
                int b = n3;
                color = Color.box-impl((long)ColorKt.Color$default((int)r, (int)g, (int)b, (int)0, (int)8, null));
                break;
            }
            case 4: {
                Integer n = StringsKt.toIntOrNull((String)StringsKt.repeat((CharSequence)String.valueOf(cleanHex.charAt(0)), (int)2), (int)16);
                if (n == null) {
                    return null;
                }
                int r = n;
                Integer n4 = StringsKt.toIntOrNull((String)StringsKt.repeat((CharSequence)String.valueOf(cleanHex.charAt(1)), (int)2), (int)16);
                if (n4 == null) {
                    return null;
                }
                int g = n4;
                Integer n5 = StringsKt.toIntOrNull((String)StringsKt.repeat((CharSequence)String.valueOf(cleanHex.charAt(2)), (int)2), (int)16);
                if (n5 == null) {
                    return null;
                }
                int b = n5;
                Integer n6 = StringsKt.toIntOrNull((String)StringsKt.repeat((CharSequence)String.valueOf(cleanHex.charAt(3)), (int)2), (int)16);
                if (n6 == null) {
                    return null;
                }
                int a = n6;
                color = Color.box-impl((long)ColorKt.Color((int)r, (int)g, (int)b, (int)a));
                break;
            }
            case 6: {
                Integer n = StringsKt.toIntOrNull((String)StringsKt.take((String)cleanHex, (int)2), (int)16);
                if (n == null) {
                    return null;
                }
                int r = n;
                String string2 = cleanHex.substring(2, 4);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Integer n7 = StringsKt.toIntOrNull((String)string2, (int)16);
                if (n7 == null) {
                    return null;
                }
                int g = n7;
                String string3 = cleanHex.substring(4, 6);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                Integer n8 = StringsKt.toIntOrNull((String)string3, (int)16);
                if (n8 == null) {
                    return null;
                }
                int b = n8;
                color = Color.box-impl((long)ColorKt.Color$default((int)r, (int)g, (int)b, (int)0, (int)8, null));
                break;
            }
            case 8: {
                Integer n = StringsKt.toIntOrNull((String)StringsKt.take((String)cleanHex, (int)2), (int)16);
                if (n == null) {
                    return null;
                }
                int r = n;
                String string4 = cleanHex.substring(2, 4);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                Integer n9 = StringsKt.toIntOrNull((String)string4, (int)16);
                if (n9 == null) {
                    return null;
                }
                int g = n9;
                String string5 = cleanHex.substring(4, 6);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                Integer n10 = StringsKt.toIntOrNull((String)string5, (int)16);
                if (n10 == null) {
                    return null;
                }
                int b = n10;
                String string6 = cleanHex.substring(6, 8);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                Integer n11 = StringsKt.toIntOrNull((String)string6, (int)16);
                if (n11 == null) {
                    return null;
                }
                int a = n11;
                color = Color.box-impl((long)ColorKt.Color((int)r, (int)g, (int)b, (int)a));
                break;
            }
            default: {
                color = null;
            }
        }
        return color;
    }

    public final long hslToColor-XeAY9LY(float h, float s, float l) {
        if (s == 0.0f) {
            int v = MathKt.roundToInt((float)(l * 255.0f));
            return ColorKt.Color$default((int)v, (int)v, (int)v, (int)0, (int)8, null);
        }
        float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
        float p = 2.0f * l - q;
        int r = MathKt.roundToInt((float)(ColorUtils.hslToColor_XeAY9LY$hue2rgb(p, q, h + 0.33333334f) * 255.0f));
        int g = MathKt.roundToInt((float)(ColorUtils.hslToColor_XeAY9LY$hue2rgb(p, q, h) * 255.0f));
        int b = MathKt.roundToInt((float)(ColorUtils.hslToColor_XeAY9LY$hue2rgb(p, q, h - 0.33333334f) * 255.0f));
        return ColorKt.Color$default((int)r, (int)g, (int)b, (int)0, (int)8, null);
    }

    @NotNull
    public final float[] toHSL-8_81llA(long $this$toHSL_u2d8_81llA) {
        float r = Color.getRed-impl((long)$this$toHSL_u2d8_81llA);
        float g = Color.getGreen-impl((long)$this$toHSL_u2d8_81llA);
        float b = Color.getBlue-impl((long)$this$toHSL_u2d8_81llA);
        float max = Math.max(Math.max(r, g), b);
        float min = Math.min(Math.min(r, g), b);
        float h = 0.0f;
        float s = 0.0f;
        float l = (max + min) / 2.0f;
        if (max == min) {
            h = 0.0f;
            s = 0.0f;
        } else {
            float d = max - min;
            s = l > 0.5f ? d / (2.0f - max - min) : d / (max + min);
            float f = max;
            h = f == r ? (g - b) / d + (g < b ? 6.0f : 0.0f) : (f == g ? (b - r) / d + 2.0f : (r - g) / d + 4.0f);
            h /= 6.0f;
        }
        float[] fArray = new float[]{h * (float)360, s * (float)100, l * (float)100};
        return fArray;
    }

    public final long getAdaptiveColor-eb82Cgs(long backgroundColor, float targetHue, float baseSaturation, float baseLightness) {
        float bgLuminance = ColorKt.luminance-8_81llA((long)backgroundColor);
        float[] bgHsl = this.toHSL-8_81llA(backgroundColor);
        float adjustedLightness = bgLuminance > 0.7f ? baseLightness - 20.0f : (bgLuminance < 0.3f ? baseLightness + 20.0f : baseLightness);
        float adjustedSaturation = bgHsl[1] > 70.0f ? baseSaturation - 20.0f : (bgHsl[1] < 30.0f ? baseSaturation + 10.0f : baseSaturation);
        return this.hslToColor-XeAY9LY(targetHue / 360.0f, adjustedSaturation / 100.0f, adjustedLightness / 100.0f);
    }

    public static /* synthetic */ long getAdaptiveColor-eb82Cgs$default(ColorUtils colorUtils, long l, float f, float f2, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            f2 = 70.0f;
        }
        if ((n & 8) != 0) {
            f3 = 60.0f;
        }
        return colorUtils.getAdaptiveColor-eb82Cgs(l, f, f2, f3);
    }

    @NotNull
    public final float[] rgbToHsv(int r, int g, int b) {
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float delta = max - min;
        float h = (delta == 0.0f ? 0.0f : (max == rf ? (gf - bf) / delta % (float)6 : (max == gf ? (bf - rf) / delta + (float)2 : (rf - gf) / delta + (float)4))) * (float)60;
        float s = max == 0.0f ? 0.0f : delta / max;
        float[] fArray = new float[]{h < 0.0f ? h + (float)360 : h, s, max};
        return fArray;
    }

    public final boolean isNearWhiteOrBlack(int r, int g, int b) {
        int brightness = (r + g + b) / 3;
        return !(30 <= brightness ? brightness < 226 : false);
    }

    @NotNull
    public final int[] hsvToRgb(float h, float s, float v) {
        float c = v * s;
        float x = c * (1.0f - Math.abs(h / (float)60 % (float)2 - 1.0f));
        float m = v - c;
        Triple triple = switch ((int)(h / (float)60)) {
            case 0 -> new Triple((Object)Float.valueOf(c), (Object)Float.valueOf(x), (Object)Float.valueOf(0.0f));
            case 1 -> new Triple((Object)Float.valueOf(x), (Object)Float.valueOf(c), (Object)Float.valueOf(0.0f));
            case 2 -> new Triple((Object)Float.valueOf(0.0f), (Object)Float.valueOf(c), (Object)Float.valueOf(x));
            case 3 -> new Triple((Object)Float.valueOf(0.0f), (Object)Float.valueOf(x), (Object)Float.valueOf(c));
            case 4 -> new Triple((Object)Float.valueOf(x), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(c));
            default -> new Triple((Object)Float.valueOf(c), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(x));
        };
        float r = ((Number)triple.component1()).floatValue();
        float g = ((Number)triple.component2()).floatValue();
        float b = ((Number)triple.component3()).floatValue();
        int[] nArray = new int[]{(int)((r + m) * (float)255), (int)((g + m) * (float)255), (int)((b + m) * (float)255)};
        return nArray;
    }

    public final boolean isDarkColor-8_81llA(long color) {
        return ColorKt.luminance-8_81llA((long)color) < 0.5f;
    }

    @NotNull
    public final String toHexString-8_81llA(long $this$toHexString_u2d8_81llA) {
        int alpha = (int)(Color.getAlpha-impl((long)$this$toHexString_u2d8_81llA) * (float)255);
        int red = (int)(Color.getRed-impl((long)$this$toHexString_u2d8_81llA) * (float)255);
        int green = (int)(Color.getGreen-impl((long)$this$toHexString_u2d8_81llA) * (float)255);
        int blue = (int)(Color.getBlue-impl((long)$this$toHexString_u2d8_81llA) * (float)255);
        String string2 = Integer.toString(alpha, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = StringsKt.padStart((String)string2, (int)2, (char)'0').toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        String string4 = Integer.toString(red, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String string5 = StringsKt.padStart((String)string4, (int)2, (char)'0').toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
        String string6 = Integer.toString(green, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toString(...)");
        String string7 = StringsKt.padStart((String)string6, (int)2, (char)'0').toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUpperCase(...)");
        String string8 = Integer.toString(blue, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
        String string9 = StringsKt.padStart((String)string8, (int)2, (char)'0').toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toUpperCase(...)");
        return "0x" + string3 + string5 + string7 + string9;
    }

    @NotNull
    public final String toRGBString-8_81llA(long $this$toRGBString_u2d8_81llA) {
        int argb = ColorKt.toArgb-8_81llA((long)$this$toRGBString_u2d8_81llA);
        float alpha = (float)(argb >> 24 & 0xFF) / 255.0f;
        int red = argb >> 16 & 0xFF;
        int green = argb >> 8 & 0xFF;
        int blue = argb & 0xFF;
        double alphaFormatted = (double)MathKt.roundToInt((float)(alpha * (float)100)) / 100.0;
        return "RGBA(" + red + ", " + green + ", " + blue + ", " + alphaFormatted + SUFFIX_HSL_CLOSE;
    }

    public final long getBestTextColor-l2rxGTc(long $this$getBestTextColor_u2dl2rxGTc) {
        long baseTextColor;
        float bgLuminance = ColorKt.luminance-8_81llA((long)$this$getBestTextColor_u2dl2rxGTc);
        long l = baseTextColor = bgLuminance > 0.5f ? Color.Companion.getBlack-0d7_KjU() : Color.Companion.getWhite-0d7_KjU();
        boolean bl = 0.4f <= bgLuminance ? bgLuminance <= 0.6f : false;
        if (bl) {
            float contrastWithBlack = this.calculateContrast--OWjLjI($this$getBestTextColor_u2dl2rxGTc, Color.Companion.getBlack-0d7_KjU());
            float contrastWithWhite = this.calculateContrast--OWjLjI($this$getBestTextColor_u2dl2rxGTc, Color.Companion.getWhite-0d7_KjU());
            float minContrast = 4.5f;
            return contrastWithBlack >= minContrast && contrastWithWhite >= minContrast ? (contrastWithBlack > contrastWithWhite ? Color.Companion.getBlack-0d7_KjU() : Color.Companion.getWhite-0d7_KjU()) : (contrastWithBlack >= minContrast ? Color.Companion.getBlack-0d7_KjU() : (contrastWithWhite >= minContrast ? Color.Companion.getWhite-0d7_KjU() : this.getEnhancedContrastColor-l2rxGTc($this$getBestTextColor_u2dl2rxGTc)));
        }
        return baseTextColor;
    }

    private final long getEnhancedContrastColor-l2rxGTc(long $this$getEnhancedContrastColor_u2dl2rxGTc) {
        float luminance = ColorKt.luminance-8_81llA((long)$this$getEnhancedContrastColor_u2dl2rxGTc);
        return luminance > 0.5f ? ColorKt.Color((long)0xFF1A1A1AL) : ColorKt.Color((long)0xFFF5F5F5L);
    }

    private final float calculateContrast--OWjLjI(long color1, long color2) {
        float lum1 = ColorKt.luminance-8_81llA((long)color1);
        float lum2 = ColorKt.luminance-8_81llA((long)color2);
        float brightest = Math.max(lum1, lum2);
        float darkest = Math.min(lum1, lum2);
        return (brightest + 0.05f) / (darkest + 0.05f);
    }

    private static final float hslToColor_XeAY9LY$hue2rgb(float pv, float qv, float t0) {
        float t = t0;
        if (t < 0.0f) {
            t += 1.0f;
        }
        if (t > 1.0f) {
            t -= 1.0f;
        }
        return t < 0.16666667f ? pv + (qv - pv) * 6.0f * t : (t < 0.5f ? qv : (t < 0.6666667f ? pv + (qv - pv) * (0.6666667f - t) * 6.0f : pv));
    }
}

