/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.ui.theme;

import androidx.compose.material3.ColorScheme;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.ui.theme.ColorContrast;
import com.crosspaste.ui.theme.CrossPasteTheme;
import com.crosspaste.ui.theme.ThemeColor;
import com.crosspaste.ui.theme.ThemeDetector;
import com.jthemedetecor.OsThemeDetector;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\u000f\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u001e\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001cR\u0019\u0010\u001f\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R \u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010#R \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010&\u001a\u0004\b*\u0010(R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00180!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010#R \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00180$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b,\u0010&\u001a\u0004\b-\u0010(R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010#R \u0010/\u001a\b\u0012\u0004\u0012\u00020\u00180$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b/\u0010&\u001a\u0004\b0\u0010(R+\u00107\u001a\u00020\b2\u0006\u00101\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u0010\n\"\u0004\b5\u00106R+\u0010;\u001a\u00020\b2\u0006\u00101\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b8\u00103\u001a\u0004\b9\u0010\n\"\u0004\b:\u00106R+\u0010?\u001a\u00020\b2\u0006\u00101\u001a\u00020\b8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b<\u00103\u001a\u0004\b=\u0010\n\"\u0004\b>\u00106\u00a8\u0006@"}, d2={"Lcom/crosspaste/ui/theme/DesktopThemeDetector;", "Lcom/crosspaste/ui/theme/ThemeDetector;", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "configManager", "<init>", "(Lcom/crosspaste/config/ConfigManager;)V", "", "isSystemInDark", "()Z", "isFollowSystem", "isUserInDark", "", "setThemeConfig", "(ZZ)V", "Lcom/crosspaste/ui/theme/ThemeColor;", "themeColor", "setThemeColor", "(Lcom/crosspaste/ui/theme/ThemeColor;)V", "Lcom/crosspaste/ui/theme/ColorContrast;", "colorContrast", "setColorContrast", "(Lcom/crosspaste/ui/theme/ColorContrast;)V", "Landroidx/compose/material3/ColorScheme;", "getLightColorSchema", "(Lcom/crosspaste/ui/theme/ThemeColor;)Landroidx/compose/material3/ColorScheme;", "getDarkColorSchema", "Lcom/crosspaste/config/ConfigManager;", "Lcom/jthemedetecor/OsThemeDetector;", "Lorg/jetbrains/annotations/NotNull;", "detector", "Lcom/jthemedetecor/OsThemeDetector;", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_currentThemeColor", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/coroutines/flow/StateFlow;", "currentThemeColor", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentThemeColor", "()Lkotlinx/coroutines/flow/StateFlow;", "_colorContrast", "getColorContrast", "_lightColorScheme", "lightColorScheme", "getLightColorScheme", "_darkColorScheme", "darkColorScheme", "getDarkColorScheme", "<set-?>", "_isFollowSystem$delegate", "Landroidx/compose/runtime/MutableState;", "get_isFollowSystem", "set_isFollowSystem", "(Z)V", "_isFollowSystem", "_isSystemInDark$delegate", "get_isSystemInDark", "set_isSystemInDark", "_isSystemInDark", "_isUserInDark$delegate", "get_isUserInDark", "set_isUserInDark", "_isUserInDark", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopThemeDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopThemeDetector.kt\ncom/crosspaste/ui/theme/DesktopThemeDetector\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,95:1\n85#2:96\n117#2,2:97\n85#2:99\n117#2,2:100\n85#2:102\n117#2,2:103\n*S KotlinDebug\n*F\n+ 1 DesktopThemeDetector.kt\ncom/crosspaste/ui/theme/DesktopThemeDetector\n*L\n36#1:96\n36#1:97,2\n40#1:99\n40#1:100,2\n42#1:102\n42#1:103,2\n*E\n"})
public final class DesktopThemeDetector
implements ThemeDetector {
    @NotNull
    private final ConfigManager<AppConfig> configManager;
    @NotNull
    private final OsThemeDetector detector;
    @NotNull
    private final MutableStateFlow<ThemeColor> _currentThemeColor;
    @NotNull
    private final StateFlow<ThemeColor> currentThemeColor;
    @NotNull
    private final MutableStateFlow<ColorContrast> _colorContrast;
    @NotNull
    private final StateFlow<ColorContrast> colorContrast;
    @NotNull
    private final MutableStateFlow<ColorScheme> _lightColorScheme;
    @NotNull
    private final StateFlow<ColorScheme> lightColorScheme;
    @NotNull
    private final MutableStateFlow<ColorScheme> _darkColorScheme;
    @NotNull
    private final StateFlow<ColorScheme> darkColorScheme;
    @NotNull
    private final MutableState _isFollowSystem$delegate;
    @NotNull
    private final MutableState _isSystemInDark$delegate;
    @NotNull
    private final MutableState _isUserInDark$delegate;
    public static final int $stable = 8;

    public DesktopThemeDetector(@NotNull ConfigManager<AppConfig> configManager) {
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        this.configManager = configManager;
        OsThemeDetector osThemeDetector = OsThemeDetector.getDetector();
        Intrinsics.checkNotNullExpressionValue((Object)osThemeDetector, (String)"getDetector(...)");
        this.detector = osThemeDetector;
        this._currentThemeColor = StateFlowKt.MutableStateFlow((Object)CrossPasteTheme.INSTANCE.getThemeColor(this.configManager.getCurrentConfig().getThemeColor()));
        this.currentThemeColor = (StateFlow)this._currentThemeColor;
        this._colorContrast = StateFlowKt.MutableStateFlow((Object)((Object)ColorContrast.valueOf(this.configManager.getCurrentConfig().getColorContrast())));
        this.colorContrast = (StateFlow)this._colorContrast;
        this._lightColorScheme = StateFlowKt.MutableStateFlow((Object)this.getLightColorSchema((ThemeColor)this.getCurrentThemeColor().getValue()));
        this.lightColorScheme = (StateFlow)this._lightColorScheme;
        this._darkColorScheme = StateFlowKt.MutableStateFlow((Object)this.getDarkColorSchema((ThemeColor)this.getCurrentThemeColor().getValue()));
        this.darkColorScheme = (StateFlow)this._darkColorScheme;
        this._isFollowSystem$delegate = SnapshotStateKt.mutableStateOf$default((Object)this.configManager.getCurrentConfig().isFollowSystemTheme(), null, (int)2, null);
        this._isSystemInDark$delegate = SnapshotStateKt.mutableStateOf$default((Object)this.detector.isDark(), null, (int)2, null);
        this._isUserInDark$delegate = SnapshotStateKt.mutableStateOf$default((Object)this.configManager.getCurrentConfig().isDarkTheme(), null, (int)2, null);
        this.detector.registerListener(arg_0 -> DesktopThemeDetector._init_$lambda$0(this, arg_0));
    }

    @Override
    @NotNull
    public StateFlow<ThemeColor> getCurrentThemeColor() {
        return this.currentThemeColor;
    }

    @Override
    @NotNull
    public StateFlow<ColorContrast> getColorContrast() {
        return this.colorContrast;
    }

    @Override
    @NotNull
    public StateFlow<ColorScheme> getLightColorScheme() {
        return this.lightColorScheme;
    }

    @Override
    @NotNull
    public StateFlow<ColorScheme> getDarkColorScheme() {
        return this.darkColorScheme;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean get_isFollowSystem() {
        void $this$getValue$iv;
        State state = (State)this._isFollowSystem$delegate;
        DesktopThemeDetector desktopThemeDetector = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_isFollowSystem(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this._isFollowSystem$delegate;
        DesktopThemeDetector desktopThemeDetector = this;
        Object var4_4 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean get_isSystemInDark() {
        void $this$getValue$iv;
        State state = (State)this._isSystemInDark$delegate;
        DesktopThemeDetector desktopThemeDetector = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_isSystemInDark(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this._isSystemInDark$delegate;
        DesktopThemeDetector desktopThemeDetector = this;
        Object var4_4 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean get_isUserInDark() {
        void $this$getValue$iv;
        State state = (State)this._isUserInDark$delegate;
        DesktopThemeDetector desktopThemeDetector = this;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (Boolean)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void set_isUserInDark(boolean bl) {
        void $this$setValue$iv;
        MutableState mutableState = this._isUserInDark$delegate;
        DesktopThemeDetector desktopThemeDetector = this;
        Object var4_4 = null;
        Boolean value$iv = bl;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    @Override
    public boolean isSystemInDark() {
        return this.get_isSystemInDark();
    }

    @Override
    public boolean isFollowSystem() {
        return this.get_isFollowSystem();
    }

    @Override
    public boolean isUserInDark() {
        return this.get_isUserInDark();
    }

    @Override
    public void setThemeConfig(boolean isFollowSystem, boolean isUserInDark) {
        this.set_isFollowSystem(isFollowSystem);
        this.set_isUserInDark(isUserInDark);
        Object[] objectArray = new String[]{"isFollowSystemTheme", "isDarkTheme"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Boolean[]{isFollowSystem, isUserInDark};
        this.configManager.updateConfig(list, CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    public void setThemeColor(@NotNull ThemeColor themeColor) {
        Intrinsics.checkNotNullParameter((Object)themeColor, (String)"themeColor");
        this._currentThemeColor.setValue((Object)themeColor);
        this._lightColorScheme.setValue((Object)this.getLightColorSchema(themeColor));
        this._darkColorScheme.setValue((Object)this.getDarkColorSchema(themeColor));
        this.configManager.updateConfig("themeColor", (Object)themeColor.getName());
    }

    @Override
    public void setColorContrast(@NotNull ColorContrast colorContrast) {
        Intrinsics.checkNotNullParameter((Object)((Object)colorContrast), (String)"colorContrast");
        this._colorContrast.setValue((Object)colorContrast);
        this._lightColorScheme.setValue((Object)this.getLightColorSchema((ThemeColor)this.getCurrentThemeColor().getValue()));
        this._darkColorScheme.setValue((Object)this.getDarkColorSchema((ThemeColor)this.getCurrentThemeColor().getValue()));
        this.configManager.updateConfig("colorContrast", (Object)colorContrast.name());
    }

    private final ColorScheme getLightColorSchema(ThemeColor themeColor) {
        return switch (WhenMappings.$EnumSwitchMapping$0[((ColorContrast)((Object)this.getColorContrast().getValue())).ordinal()]) {
            case 1 -> themeColor.getLightColorScheme();
            case 2 -> themeColor.getLightMediumContrastColorScheme();
            case 3 -> themeColor.getLightHighContrastColorScheme();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ColorScheme getDarkColorSchema(ThemeColor themeColor) {
        return switch (WhenMappings.$EnumSwitchMapping$0[((ColorContrast)((Object)this.getColorContrast().getValue())).ordinal()]) {
            case 1 -> themeColor.getDarkColorScheme();
            case 2 -> themeColor.getDarkMediumContrastColorScheme();
            case 3 -> themeColor.getDarkHighContrastColorScheme();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean isCurrentThemeDark() {
        return ThemeDetector.super.isCurrentThemeDark();
    }

    @Override
    @NotNull
    public StateFlow<ColorScheme> getCurrentColorScheme() {
        return ThemeDetector.super.getCurrentColorScheme();
    }

    private static final void _init_$lambda$0(DesktopThemeDetector this$0, boolean isDark) {
        this$0.set_isSystemInDark(isDark);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorContrast.values().length];
            try {
                nArray[ColorContrast.Standard.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorContrast.Medium.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorContrast.High.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

