/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.ui.base;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.awt.ComposeWindow;
import com.crosspaste.app.AppFileType;
import com.crosspaste.app.AppUrls;
import com.crosspaste.app.AppWindowManager;
import com.crosspaste.db.paste.PasteDao;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.notification.MessageType;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.paste.PasteData;
import com.crosspaste.paste.PasteType;
import com.crosspaste.paste.item.ColorPasteItem;
import com.crosspaste.paste.item.HtmlPasteItem;
import com.crosspaste.paste.item.PasteColor;
import com.crosspaste.paste.item.PasteFiles;
import com.crosspaste.paste.item.PasteItem;
import com.crosspaste.paste.item.PasteRtf;
import com.crosspaste.paste.item.UrlPasteItem;
import com.crosspaste.paste.plugin.type.ColorTypePlugin;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.platform.Platform;
import com.crosspaste.ui.PasteTextEdit;
import com.crosspaste.ui.base.UISupport;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.crosspaste.utils.HtmlUtils;
import com.crosspaste.utils.HtmlUtilsKt;
import com.crosspaste.utils.OkioPathExtensionKt;
import com.google.common.io.Files;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.swing.JColorChooser;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001d\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u0018J\u001f\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010%\u001a\u00020\u00162\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010)\u001a\u00020\u00162\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b.\u0010/J\u0017\u00101\u001a\u00020\u00162\u0006\u00100\u001a\u00020#H\u0016\u00a2\u0006\u0004\b1\u0010&J\u0017\u00102\u001a\u00020\u00162\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b2\u0010*J\u0017\u00103\u001a\u00020\u00162\u0006\u0010(\u001a\u00020'H\u0016\u00a2\u0006\u0004\b3\u0010*J\u001f\u00106\u001a\u00020\u00162\u0006\u0010(\u001a\u00020'2\u0006\u00105\u001a\u000204H\u0016\u00a2\u0006\u0004\b6\u00107J\u000f\u00108\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b8\u00109R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010:R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010;R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010<R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010=R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010>R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010?R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010@R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010AR\u0014\u0010C\u001a\u00020B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0014\u0010F\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0014\u0010I\u001a\u00020H8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010J\u00a8\u0006K"}, d2={"Lcom/crosspaste/ui/base/DesktopUISupport;", "Lcom/crosspaste/ui/base/UISupport;", "Lcom/crosspaste/app/AppUrls;", "appUrls", "Lcom/crosspaste/app/AppWindowManager;", "appWindowManager", "Lcom/crosspaste/paste/plugin/type/ColorTypePlugin;", "colorTypePlugin", "Lcom/crosspaste/i18n/GlobalCopywriter;", "copywriter", "Lcom/crosspaste/notification/NotificationManager;", "notificationManager", "Lcom/crosspaste/db/paste/PasteDao;", "pasteDao", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/app/AppUrls;Lcom/crosspaste/app/AppWindowManager;Lcom/crosspaste/paste/plugin/type/ColorTypePlugin;Lcom/crosspaste/i18n/GlobalCopywriter;Lcom/crosspaste/notification/NotificationManager;Lcom/crosspaste/db/paste/PasteDao;Lcom/crosspaste/platform/Platform;Lcom/crosspaste/path/UserDataPathProvider;)V", "", "url", "", "openUrlInBrowser", "(Ljava/lang/String;)V", "path", "getCrossPasteWebUrl", "(Ljava/lang/String;)Ljava/lang/String;", "email", "openEmailClient", "", "id", "html", "openHtml", "(JLjava/lang/String;)V", "Lokio/Path;", "filePath", "browseFile", "(Lokio/Path;)V", "Lcom/crosspaste/paste/PasteData;", "pasteData", "openColorPicker", "(Lcom/crosspaste/paste/PasteData;)V", "Ljava/io/File;", "file", "", "openFileInExplorer", "(Ljava/io/File;)Z", "imagePath", "openImage", "openText", "openRtf", "", "index", "openPasteData", "(Lcom/crosspaste/paste/PasteData;I)V", "jumpPrivacyAccessibility", "()V", "Lcom/crosspaste/app/AppUrls;", "Lcom/crosspaste/app/AppWindowManager;", "Lcom/crosspaste/paste/plugin/type/ColorTypePlugin;", "Lcom/crosspaste/i18n/GlobalCopywriter;", "Lcom/crosspaste/notification/NotificationManager;", "Lcom/crosspaste/db/paste/PasteDao;", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/path/UserDataPathProvider;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "Lcom/crosspaste/utils/HtmlUtils;", "htmlUtils", "Lcom/crosspaste/utils/HtmlUtils;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopUISupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopUISupport.kt\ncom/crosspaste/ui/base/DesktopUISupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,268:1\n1#2:269\n*E\n"})
public final class DesktopUISupport
implements UISupport {
    @NotNull
    private final AppUrls appUrls;
    @NotNull
    private final AppWindowManager appWindowManager;
    @NotNull
    private final ColorTypePlugin colorTypePlugin;
    @NotNull
    private final GlobalCopywriter copywriter;
    @NotNull
    private final NotificationManager notificationManager;
    @NotNull
    private final PasteDao pasteDao;
    @NotNull
    private final Platform platform;
    @NotNull
    private final UserDataPathProvider userDataPathProvider;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final HtmlUtils htmlUtils;
    public static final int $stable = 8;

    public DesktopUISupport(@NotNull AppUrls appUrls, @NotNull AppWindowManager appWindowManager, @NotNull ColorTypePlugin colorTypePlugin, @NotNull GlobalCopywriter copywriter, @NotNull NotificationManager notificationManager, @NotNull PasteDao pasteDao, @NotNull Platform platform, @NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)appUrls, (String)"appUrls");
        Intrinsics.checkNotNullParameter((Object)appWindowManager, (String)"appWindowManager");
        Intrinsics.checkNotNullParameter((Object)colorTypePlugin, (String)"colorTypePlugin");
        Intrinsics.checkNotNullParameter((Object)copywriter, (String)"copywriter");
        Intrinsics.checkNotNullParameter((Object)notificationManager, (String)"notificationManager");
        Intrinsics.checkNotNullParameter((Object)pasteDao, (String)"pasteDao");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.appUrls = appUrls;
        this.appWindowManager = appWindowManager;
        this.colorTypePlugin = colorTypePlugin;
        this.copywriter = copywriter;
        this.notificationManager = notificationManager;
        this.pasteDao = pasteDao;
        this.platform = platform;
        this.userDataPathProvider = userDataPathProvider;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopUISupport::logger$lambda$0);
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
        this.htmlUtils = HtmlUtilsKt.getHtmlUtils();
    }

    @Override
    public void openUrlInBrowser(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(new URI(url));
        } else {
            NotificationManager.sendNotification$default(this.notificationManager, DesktopUISupport::openUrlInBrowser$lambda$1, arg_0 -> DesktopUISupport.openUrlInBrowser$lambda$2(url, arg_0), MessageType.Error, null, 8, null);
        }
    }

    @Override
    @NotNull
    public String getCrossPasteWebUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String language = this.copywriter.language();
        String webPath = Intrinsics.areEqual((Object)language, (Object)"zh") ? path : language + "/" + path;
        return this.appUrls.getHomeUrl() + "/" + webPath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void openEmailClient(@Nullable String email) {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.MAIL)) {
            String string2 = email;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                String uriText = "mailto:" + email;
                URI mailURI = new URI(uriText);
                Desktop.getDesktop().mail(mailURI);
            } else {
                DesktopUISupport $this$openEmailClient_u24lambda_u244 = this;
                boolean bl = false;
                Desktop.getDesktop().mail();
            }
        } else {
            Function1 function1;
            NotificationManager notificationManager = this.notificationManager;
            Function1 function12 = DesktopUISupport::openEmailClient$lambda$5;
            String string3 = email;
            if (string3 != null) {
                void email2;
                String string4 = string3;
                Function1 function13 = function12;
                NotificationManager notificationManager2 = notificationManager;
                boolean bl = false;
                Function1 function14 = arg_0 -> DesktopUISupport.openEmailClient$lambda$7$lambda$6((String)email2, arg_0);
                notificationManager = notificationManager2;
                function12 = function13;
                function1 = function14;
            } else {
                function1 = null;
            }
            NotificationManager.sendNotification$default(notificationManager, function12, function1, MessageType.Error, null, 8, null);
        }
    }

    @Override
    public void openHtml(long id, @NotNull String html) {
        Intrinsics.checkNotNullParameter((Object)html, (String)"html");
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            String fileName = id + ".html";
            Path filePath = this.userDataPathProvider.resolve(fileName, AppFileType.TEMP);
            File file = filePath.toFile();
            if (!file.exists()) {
                String utf8Html = this.htmlUtils.ensureHtmlCharsetUtf8(html);
                Files.write((byte[])StringsKt.encodeToByteArray((String)utf8Html), (File)file);
            }
            Desktop.getDesktop().browse(file.toURI());
        } else {
            NotificationManager.sendNotification$default(this.notificationManager, DesktopUISupport::openHtml$lambda$8, null, MessageType.Error, null, 10, null);
        }
    }

    @Override
    public void browseFile(@NotNull Path filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (this.fileUtils.existFile(filePath)) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE_FILE_DIR)) {
                Desktop desktop = Desktop.getDesktop();
                desktop.browseFileDirectory(filePath.toFile());
            } else {
                if (this.platform.isWindows() && this.openFileInExplorer(filePath.toFile())) {
                    return;
                }
                NotificationManager.sendNotification$default(this.notificationManager, DesktopUISupport::browseFile$lambda$9, null, MessageType.Error, null, 10, null);
            }
        } else {
            NotificationManager.sendNotification$default(this.notificationManager, DesktopUISupport::browseFile$lambda$10, null, MessageType.Error, null, 10, null);
        }
    }

    @Override
    public void openColorPicker(@NotNull PasteData pasteData) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)pasteData, (String)"pasteData");
            PasteColor pasteColor = (PasteColor)pasteData.getPasteItem(Reflection.getOrCreateKotlinClass(PasteColor.class));
            if (pasteColor == null) break block0;
            PasteColor pasteColor2 = pasteColor;
            boolean bl = false;
            Color initialColor = new Color(pasteColor2.getColor());
            EventQueue.invokeLater(() -> DesktopUISupport.openColorPicker$lambda$13$lambda$12(initialColor, this, pasteData, pasteColor2));
        }
    }

    private final boolean openFileInExplorer(File file) {
        Object object;
        Object $this$openFileInExplorer_u24lambda_u2414;
        Object object2 = this;
        try {
            $this$openFileInExplorer_u24lambda_u2414 = object2;
            boolean bl = false;
            String filePath = file.getAbsolutePath();
            Object[] objectArray = new String[]{"explorer.exe", "/select,\"" + filePath + "\""};
            List command = CollectionsKt.listOf((Object[])objectArray);
            new ProcessBuilder(command).start();
            $this$openFileInExplorer_u24lambda_u2414 = Result.constructor-impl((Object)true);
        }
        catch (Throwable bl) {
            $this$openFileInExplorer_u24lambda_u2414 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$openFileInExplorer_u24lambda_u2414;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = $this$openFileInExplorer_u24lambda_u2414 = throwable;
            boolean bl = false;
            this.logger.error((Throwable)e, DesktopUISupport::openFileInExplorer$lambda$16$lambda$15);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    @Override
    public void openImage(@NotNull Path imagePath) {
        Intrinsics.checkNotNullParameter((Object)imagePath, (String)"imagePath");
        if (this.fileUtils.existFile(imagePath)) {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                Desktop.getDesktop().open(imagePath.toFile());
            } else {
                NotificationManager.sendNotification$default(this.notificationManager, DesktopUISupport::openImage$lambda$18, null, MessageType.Error, null, 10, null);
            }
        } else {
            NotificationManager.sendNotification$default(this.notificationManager, DesktopUISupport::openImage$lambda$19, null, MessageType.Error, null, 10, null);
        }
    }

    @Override
    public void openText(@NotNull PasteData pasteData) {
        Intrinsics.checkNotNullParameter((Object)pasteData, (String)"pasteData");
        this.appWindowManager.toScreen(PasteTextEdit.INSTANCE, pasteData);
    }

    @Override
    public void openRtf(@NotNull PasteData pasteData) {
        Intrinsics.checkNotNullParameter((Object)pasteData, (String)"pasteData");
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            String fileName = pasteData.getId() + ".rtf";
            Path filePath = this.userDataPathProvider.resolve(fileName, AppFileType.TEMP);
            File file = filePath.toFile();
            if (!file.exists()) {
                PasteRtf pasteRtf = (PasteRtf)pasteData.getPasteItem(Reflection.getOrCreateKotlinClass(PasteRtf.class));
                if (pasteRtf != null) {
                    PasteRtf it = pasteRtf;
                    boolean bl = false;
                    Files.write((byte[])StringsKt.encodeToByteArray((String)it.getRtf()), (File)file);
                }
            }
            Desktop.getDesktop().browse(file.toURI());
        } else {
            NotificationManager.sendNotification$default(this.notificationManager, DesktopUISupport::openRtf$lambda$21, null, MessageType.Error, null, 10, null);
        }
    }

    @Override
    public void openPasteData(@NotNull PasteData pasteData, int index) {
        block5: {
            PasteType pasteType;
            PasteItem item;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    Intrinsics.checkNotNullParameter((Object)pasteData, (String)"pasteData");
                                    PasteItem pasteItem = pasteData.getPasteAppearItem();
                                    if (pasteItem == null) break block5;
                                    item = pasteItem;
                                    boolean bl = false;
                                    PasteType pasteType2 = pasteData.getType();
                                    pasteType = pasteType2;
                                    if (!Intrinsics.areEqual((Object)pasteType, (Object)PasteType.Companion.getTEXT_TYPE())) break block6;
                                    this.openText(pasteData);
                                    break block5;
                                }
                                if (!Intrinsics.areEqual((Object)pasteType, (Object)PasteType.Companion.getCOLOR_TYPE())) break block7;
                                this.openColorPicker(pasteData);
                                break block5;
                            }
                            if (!Intrinsics.areEqual((Object)pasteType, (Object)PasteType.Companion.getURL_TYPE())) break block8;
                            this.openUrlInBrowser(((UrlPasteItem)item).getUrl());
                            break block5;
                        }
                        if (!Intrinsics.areEqual((Object)pasteType, (Object)PasteType.Companion.getHTML_TYPE())) break block9;
                        this.openHtml(pasteData.getId(), ((HtmlPasteItem)item).getHtml());
                        break block5;
                    }
                    if (!Intrinsics.areEqual((Object)pasteType, (Object)PasteType.Companion.getRTF_TYPE())) break block10;
                    this.openRtf(pasteData);
                    break block5;
                }
                if (!Intrinsics.areEqual((Object)pasteType, (Object)PasteType.Companion.getFILE_TYPE())) break block11;
                PasteFiles cfr_ignored_0 = (PasteFiles)item;
                List pathList = ((PasteFiles)item).getFilePaths(this.userDataPathProvider);
                if (!(!((Collection)pathList).isEmpty())) break block5;
                Path filepath = (Path)pathList.get(index);
                if (this.fileUtils.canPreviewImage(OkioPathExtensionKt.getExtension((Path)filepath))) {
                    this.openImage(filepath);
                } else {
                    this.browseFile(filepath);
                }
                break block5;
            }
            if (!Intrinsics.areEqual((Object)pasteType, (Object)PasteType.Companion.getIMAGE_TYPE())) break block5;
            PasteFiles cfr_ignored_1 = (PasteFiles)item;
            List pathList = ((PasteFiles)item).getFilePaths(this.userDataPathProvider);
            if (!((Collection)pathList).isEmpty()) {
                if (pathList.size() == 1) {
                    this.openImage((Path)pathList.get(0));
                } else {
                    this.browseFile((Path)pathList.get(index));
                }
            }
        }
    }

    @Override
    public void jumpPrivacyAccessibility() {
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Desktop.getDesktop().browse(new URI("x-apple.systempreferences:com.apple.preference.security?Privacy_Accessibility"));
        }
    }

    @Override
    public void openCrossPasteWebInBrowser(@NotNull String path) {
        UISupport.super.openCrossPasteWebInBrowser(path);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final String openUrlInBrowser$lambda$1(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("failed_to_open_browser", new Object[0]);
    }

    private static final String openUrlInBrowser$lambda$2(String $url, GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $url;
    }

    private static final String openEmailClient$lambda$5(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("cant_open_email_client", new Object[0]);
    }

    private static final String openEmailClient$lambda$7$lambda$6(String $email, GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $email;
    }

    private static final String openHtml$lambda$8(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("failed_to_open_html_pasteboard", new Object[0]);
    }

    private static final String browseFile$lambda$9(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("failed_to_browse_file_pasteboard", new Object[0]);
    }

    private static final String browseFile$lambda$10(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("file_not_found", new Object[0]);
    }

    private static final Object openColorPicker$lambda$13$lambda$12$lambda$11(int $rgbColor) {
        return "Selected color: " + $rgbColor;
    }

    private static final void openColorPicker$lambda$13$lambda$12(Color $initialColor, DesktopUISupport this$0, PasteData $pasteData, PasteColor $pasteColor) {
        new JColorChooser($initialColor);
        Color result2 = JColorChooser.showDialog((Component)new ComposeWindow(null, 1, null), this$0.copywriter.getText("color_picker", new Object[0]), $initialColor);
        if (result2 != null) {
            int rgbColor = result2.getRGB();
            int alpha = result2.getAlpha();
            long newColor = ((long)alpha & 0xFFL) << 24 | ((long)result2.getRed() & 0xFFL) << 16 | ((long)result2.getGreen() & 0xFFL) << 8 | (long)result2.getBlue() & 0xFFL;
            this$0.logger.info(() -> DesktopUISupport.openColorPicker$lambda$13$lambda$12$lambda$11(rgbColor));
            ColorTypePlugin colorTypePlugin = this$0.colorTypePlugin;
            Intrinsics.checkNotNull((Object)$pasteColor, (String)"null cannot be cast to non-null type com.crosspaste.paste.item.ColorPasteItem");
            colorTypePlugin.updateColor($pasteData, newColor, (PasteItem)((ColorPasteItem)$pasteColor), this$0.pasteDao);
        }
    }

    private static final Object openFileInExplorer$lambda$16$lambda$15() {
        return "Failed to open file in explorer";
    }

    private static final String openImage$lambda$18(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("failed_to_open_image_pasteboard", new Object[0]);
    }

    private static final String openImage$lambda$19(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("file_not_found", new Object[0]);
    }

    private static final String openRtf$lambda$21(GlobalCopywriter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getText("failed_to_open_rtf_pasteboard", new Object[0]);
    }
}

