/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.ui.base;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.window.Notification;
import com.crosspaste.app.DesktopAppWindowManager;
import com.crosspaste.i18n.GlobalCopywriter;
import com.crosspaste.notification.Message;
import com.crosspaste.notification.MessageType;
import com.crosspaste.notification.NotificationManager;
import com.crosspaste.notification.ToastManager;
import com.crosspaste.platform.Platform;
import com.crosspaste.sound.SoundService;
import com.crosspaste.ui.base.CrossPasteTrayState;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0018R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0019R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001aR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\u00a8\u0006&"}, d2={"Lcom/crosspaste/ui/base/DesktopNotificationManager;", "Lcom/crosspaste/notification/NotificationManager;", "Lcom/crosspaste/app/DesktopAppWindowManager;", "appWindowManager", "Lcom/crosspaste/i18n/GlobalCopywriter;", "copywriter", "Lcom/crosspaste/platform/Platform;", "platform", "Lcom/crosspaste/sound/SoundService;", "soundService", "Lcom/crosspaste/notification/ToastManager;", "toastManager", "<init>", "(Lcom/crosspaste/app/DesktopAppWindowManager;Lcom/crosspaste/i18n/GlobalCopywriter;Lcom/crosspaste/platform/Platform;Lcom/crosspaste/sound/SoundService;Lcom/crosspaste/notification/ToastManager;)V", "", "getMessageId", "()I", "Lcom/crosspaste/notification/Message;", "message", "", "doSendNotification", "(Lcom/crosspaste/notification/Message;)V", "notifyToast", "notifyTray", "Lcom/crosspaste/app/DesktopAppWindowManager;", "Lcom/crosspaste/platform/Platform;", "Lcom/crosspaste/sound/SoundService;", "Lcom/crosspaste/notification/ToastManager;", "Ljava/util/concurrent/atomic/AtomicInteger;", "idGenerator", "Ljava/util/concurrent/atomic/AtomicInteger;", "getIdGenerator", "()Ljava/util/concurrent/atomic/AtomicInteger;", "Lcom/crosspaste/ui/base/CrossPasteTrayState;", "trayState", "Lcom/crosspaste/ui/base/CrossPasteTrayState;", "getTrayState", "()Lcom/crosspaste/ui/base/CrossPasteTrayState;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopNotificationManager
extends NotificationManager {
    @NotNull
    private final DesktopAppWindowManager appWindowManager;
    @NotNull
    private final Platform platform;
    @NotNull
    private final SoundService soundService;
    @NotNull
    private final ToastManager toastManager;
    @NotNull
    private final AtomicInteger idGenerator;
    @NotNull
    private final CrossPasteTrayState trayState;
    public static final int $stable = 8;

    public DesktopNotificationManager(@NotNull DesktopAppWindowManager appWindowManager, @NotNull GlobalCopywriter copywriter, @NotNull Platform platform, @NotNull SoundService soundService, @NotNull ToastManager toastManager) {
        Intrinsics.checkNotNullParameter((Object)appWindowManager, (String)"appWindowManager");
        Intrinsics.checkNotNullParameter((Object)copywriter, (String)"copywriter");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)soundService, (String)"soundService");
        Intrinsics.checkNotNullParameter((Object)toastManager, (String)"toastManager");
        super(copywriter);
        this.appWindowManager = appWindowManager;
        this.platform = platform;
        this.soundService = soundService;
        this.toastManager = toastManager;
        this.idGenerator = new AtomicInteger(0);
        this.trayState = new CrossPasteTrayState();
    }

    @NotNull
    public final AtomicInteger getIdGenerator() {
        return this.idGenerator;
    }

    @NotNull
    public final CrossPasteTrayState getTrayState() {
        return this.trayState;
    }

    @Override
    public int getMessageId() {
        return this.idGenerator.incrementAndGet();
    }

    @Override
    public void doSendNotification(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (((Boolean)this.appWindowManager.getShowMainWindow().getValue()).booleanValue()) {
            this.notifyToast(message);
        } else if (this.platform.isLinux()) {
            this.sendNotification(message);
        } else {
            this.notifyTray(message);
        }
        if (message.getMessageType() == MessageType.Error) {
            this.soundService.errorSound();
        } else if (message.getMessageType() == MessageType.Success) {
            this.soundService.successSound();
        }
    }

    private final void notifyToast(Message message) {
        this.toastManager.pushToast(message);
    }

    private final void notifyTray(Message message) {
        String string2 = message.getTitle();
        String string3 = message.getMessage();
        if (string3 == null) {
            string3 = "";
        }
        this.trayState.sendNotification(new Notification(string2, string3, switch (WhenMappings.$EnumSwitchMapping$0[message.getMessageType().ordinal()]) {
            case 1 -> Notification.Type.Error;
            case 2 -> Notification.Type.Info;
            case 3 -> Notification.Type.None;
            case 4 -> Notification.Type.Warning;
            default -> throw new NoWhenBranchMatchedException();
        }));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.Error.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Info.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Success.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.Warning.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

