/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.ui.base;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.PixelMap;
import androidx.compose.ui.graphics.SkiaImageAsset_skikoKt;
import com.crosspaste.app.AppFileType;
import com.crosspaste.path.UserDataPathProvider;
import com.crosspaste.ui.base.IconStyle;
import com.crosspaste.utils.CoilUtils;
import com.crosspaste.utils.CoilUtils_desktopKt;
import com.crosspaste.utils.FileUtils;
import com.crosspaste.utils.FileUtils_desktopKt;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Bitmap;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/crosspaste/ui/base/DesktopIconStyle;", "Lcom/crosspaste/ui/base/IconStyle;", "Lcom/crosspaste/path/UserDataPathProvider;", "userDataPathProvider", "<init>", "(Lcom/crosspaste/path/UserDataPathProvider;)V", "", "source", "", "isMacStyleIcon", "(Ljava/lang/String;)Z", "", "refreshStyle", "(Ljava/lang/String;)V", "Landroidx/compose/ui/graphics/ImageBitmap;", "imageBitmap", "checkMacStyleIcon", "(Landroidx/compose/ui/graphics/ImageBitmap;)Z", "Lcom/crosspaste/utils/CoilUtils;", "coilUtils", "Lcom/crosspaste/utils/CoilUtils;", "Lcom/crosspaste/utils/FileUtils;", "fileUtils", "Lcom/crosspaste/utils/FileUtils;", "Lcom/google/common/cache/LoadingCache;", "iconStyleCache", "Lcom/google/common/cache/LoadingCache;", "app"})
@StabilityInferred(parameters=0)
public final class DesktopIconStyle
implements IconStyle {
    @NotNull
    private final CoilUtils coilUtils;
    @NotNull
    private final FileUtils fileUtils;
    @NotNull
    private final LoadingCache<String, Boolean> iconStyleCache;
    public static final int $stable = 8;

    public DesktopIconStyle(@NotNull UserDataPathProvider userDataPathProvider) {
        Intrinsics.checkNotNullParameter((Object)userDataPathProvider, (String)"userDataPathProvider");
        this.coilUtils = CoilUtils_desktopKt.getCoilUtils();
        this.fileUtils = FileUtils_desktopKt.getFileUtils();
        LoadingCache loadingCache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, Boolean>(userDataPathProvider, this){
            final /* synthetic */ UserDataPathProvider $userDataPathProvider;
            final /* synthetic */ DesktopIconStyle this$0;
            {
                this.$userDataPathProvider = $userDataPathProvider;
                this.this$0 = $receiver;
            }

            public Boolean load(String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Path iconPath = this.$userDataPathProvider.resolve(key + ".png", AppFileType.ICON);
                if (DesktopIconStyle.access$getFileUtils$p(this.this$0).existFile(iconPath)) {
                    ImageBitmap imageBitmap = SkiaImageAsset_skikoKt.asComposeImageBitmap((Bitmap)DesktopIconStyle.access$getCoilUtils$p(this.this$0).createBitmap(iconPath));
                    return DesktopIconStyle.access$checkMacStyleIcon(this.this$0, imageBitmap);
                }
                return false;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.iconStyleCache = loadingCache;
    }

    @Override
    public boolean isMacStyleIcon(@NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Object object = this.iconStyleCache.get((Object)source2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    @Override
    public void refreshStyle(@NotNull String source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        this.iconStyleCache.refresh((Object)source2);
    }

    private final boolean checkMacStyleIcon(ImageBitmap imageBitmap) {
        PixelMap pixelMap;
        int width = imageBitmap.getWidth();
        int height = imageBitmap.getHeight();
        int edgeWidth = width / 12;
        int sampleRate = Math.max(1, edgeWidth / 5);
        return DesktopIconStyle.checkMacStyleIcon$checkEdge(sampleRate, edgeWidth, height, width, pixelMap = ImageBitmapKt.toPixelMap$default((ImageBitmap)imageBitmap, (int)0, (int)0, (int)0, (int)0, null, (int)0, (int)0, (int)127, null), 0, width, true) && DesktopIconStyle.checkMacStyleIcon$checkEdge(sampleRate, edgeWidth, height, width, pixelMap, 0, height, false);
    }

    private static final boolean checkMacStyleIcon$isTransparent(PixelMap pixelMap, int x, int y) {
        long pixel = pixelMap.get-WaAFU9c(x, y);
        return Color.getAlpha-impl((long)pixel) <= 0.01f;
    }

    private static final boolean checkMacStyleIcon$checkEdge(int sampleRate, int edgeWidth, int height, int width, PixelMap pixelMap, int start2, int end, boolean isHorizontal) {
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)start2, (int)end)), (int)sampleRate);
        int i = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && i <= n || n2 < 0 && n <= i) {
            while (true) {
                if (isHorizontal) {
                    var12_12 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)edgeWidth)), (int)sampleRate);
                    int y = var12_12.getFirst();
                    var14_14 = var12_12.getLast();
                    var15_15 = var12_12.getStep();
                    if (var15_15 > 0 && y <= var14_14 || var15_15 < 0 && var14_14 <= y) {
                        while (true) {
                            if (!DesktopIconStyle.checkMacStyleIcon$isTransparent(pixelMap, i, y) || !DesktopIconStyle.checkMacStyleIcon$isTransparent(pixelMap, i, height - 1 - y)) {
                                return false;
                            }
                            if (y != var14_14) {
                                y += var15_15;
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    var12_12 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)edgeWidth)), (int)sampleRate);
                    int x = var12_12.getFirst();
                    var14_14 = var12_12.getLast();
                    var15_15 = var12_12.getStep();
                    if (var15_15 > 0 && x <= var14_14 || var15_15 < 0 && var14_14 <= x) {
                        while (true) {
                            if (!DesktopIconStyle.checkMacStyleIcon$isTransparent(pixelMap, x, i) || !DesktopIconStyle.checkMacStyleIcon$isTransparent(pixelMap, width - 1 - x, i)) {
                                return false;
                            }
                            if (x == var14_14) break;
                            x += var15_15;
                        }
                    }
                }
                if (i == n) break;
                i += n2;
            }
        }
        return true;
    }

    public static final /* synthetic */ FileUtils access$getFileUtils$p(DesktopIconStyle $this) {
        return $this.fileUtils;
    }

    public static final /* synthetic */ CoilUtils access$getCoilUtils$p(DesktopIconStyle $this) {
        return $this.coilUtils;
    }

    public static final /* synthetic */ boolean access$checkMacStyleIcon(DesktopIconStyle $this, ImageBitmap imageBitmap) {
        return $this.checkMacStyleIcon(imageBitmap);
    }
}

