/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.font.Font;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.font.FontFamilyKt;
import androidx.compose.ui.text.font.FontFamily_desktopKt;
import androidx.compose.ui.text.platform.FileFont;
import androidx.compose.ui.text.platform.ResourceFont;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.ui.base.FontInfo;
import com.crosspaste.ui.base.FontManager;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lcom/crosspaste/ui/DesktopFontManager;", "Lcom/crosspaste/ui/base/FontManager;", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "configManager", "<init>", "(Lcom/crosspaste/config/ConfigManager;)V", "", "uri", "Landroidx/compose/ui/text/font/FontFamily;", "getFontByUri", "(Ljava/lang/String;)Landroidx/compose/ui/text/font/FontFamily;", "", "Lcom/crosspaste/ui/base/FontInfo;", "getSystemFonts", "()Ljava/util/List;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDesktopFontManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopFontManager.kt\ncom/crosspaste/ui/DesktopFontManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1617#2,9:85\n1869#2:94\n1870#2:96\n1626#2:97\n1#3:95\n*S KotlinDebug\n*F\n+ 1 DesktopFontManager.kt\ncom/crosspaste/ui/DesktopFontManager\n*L\n33#1:85,9\n33#1:94\n33#1:96\n33#1:97\n33#1:95\n*E\n"})
public final class DesktopFontManager
extends FontManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KLogger logger;
    public static final int $stable = 8;

    public DesktopFontManager(@NotNull ConfigManager<AppConfig> configManager) {
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        super(configManager);
        this.logger = KotlinLogging.INSTANCE.logger(DesktopFontManager::logger$lambda$0);
    }

    @Override
    @Nullable
    public FontFamily getFontByUri(@NotNull String uri) {
        Object object;
        block2: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            object = this;
            try {
                DesktopFontManager $this$getFontByUri_u24lambda_u241 = object;
                boolean bl = false;
                URI uRI = URI.create(uri);
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                object2 = Result.constructor-impl((Object)DesktopFontManager.Companion.fromUri(uRI));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object e = object2 = throwable;
            boolean bl = false;
            this.logger.warn((Throwable)e, () -> DesktopFontManager.getFontByUri$lambda$3$lambda$2(uri));
        }
        return (FontFamily)(Result.isFailure-impl((Object)object) ? null : object);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FontInfo> getSystemFonts() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = Companion.getUsableFontFamilyNamesOfSystem();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            FontInfo it$iv$iv;
            String uri;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)new URI("system", it, null).toString(), (String)"toString(...)");
            FontFamily fontFamily = this.getFontByUri(uri);
            if ((fontFamily == null ? null : new FontInfo(uri, uri, it, fontFamily)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object getFontByUri$lambda$3$lambda$2(String $uri) {
        return "Could not load font " + $uri;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/crosspaste/ui/DesktopFontManager$Companion;", "", "<init>", "()V", "", "", "getUsableFontFamilyNamesOfSystem", "()Ljava/util/List;", "Ljava/net/URI;", "uri", "Landroidx/compose/ui/text/font/FontFamily;", "fromUri", "(Ljava/net/URI;)Landroidx/compose/ui/text/font/FontFamily;", "app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getUsableFontFamilyNamesOfSystem() {
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getAvailableFontFamilyNames(...)");
            return ArraysKt.toList((Object[])stringArray);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final FontFamily fromUri(URI uri) {
            String string2 = uri.getScheme();
            if (string2 == null) throw new IllegalArgumentException("Unsupported font URI scheme: " + uri.getScheme());
            int n = -1;
            switch (string2.hashCode()) {
                case 3143036: {
                    if (string2.equals("file")) {
                        n = 1;
                    }
                    break;
                }
                case -887328209: {
                    if (string2.equals("system")) {
                        n = 2;
                    }
                    break;
                }
                case -341064690: {
                    if (string2.equals("resource")) {
                        n = 3;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    Font[] fontArray = new Font[1];
                    Path path = Paths.get(uri);
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    File file = path.toFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                    fontArray[0] = new FileFont(file, null, 0, 6, null);
                    return FontFamilyKt.FontFamily((Font[])fontArray);
                }
                case 3: {
                    String path = uri.getSchemeSpecificPart();
                    Intrinsics.checkNotNull((Object)path);
                    if (!(((CharSequence)path).length() > 0)) {
                        String string3 = "Failed requirement.";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    Font[] fontArray = new Font[1];
                    String string4 = uri.getSchemeSpecificPart();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSchemeSpecificPart(...)");
                    fontArray[0] = new ResourceFont(string4, null, 0, 6, null);
                    FontFamily fontFamily = FontFamilyKt.FontFamily((Font[])fontArray);
                    return fontFamily;
                }
                case 2: {
                    String name = uri.getSchemeSpecificPart();
                    Intrinsics.checkNotNull((Object)name);
                    if (!(((CharSequence)name).length() > 0)) {
                        String string5 = "Failed requirement.";
                        throw new IllegalArgumentException(string5.toString());
                    }
                    FontFamily fontFamily = FontFamily_desktopKt.FontFamily((String)name);
                    return fontFamily;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported font URI scheme: " + uri.getScheme());
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

