/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.task;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.config.AppConfig;
import com.crosspaste.config.ConfigManager;
import com.crosspaste.db.task.PasteTask;
import com.crosspaste.db.task.PasteTaskExtraInfo;
import com.crosspaste.db.task.SwitchLanguageInfo;
import com.crosspaste.exception.ErrorCodeSupplier;
import com.crosspaste.exception.StandardErrorCode;
import com.crosspaste.net.clientapi.ClientApiResultKt;
import com.crosspaste.paste.GuidePasteDataService;
import com.crosspaste.task.PasteTaskResult;
import com.crosspaste.task.SingleTypeTaskExecutor;
import com.crosspaste.task.SuccessPasteTaskResult;
import com.crosspaste.utils.DateUtils;
import com.crosspaste.utils.TaskUtils;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0096@\u00a2\u0006\u0004\b\r\u0010\u000eJ)\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0002j\u0002`\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001d\u001a\u00020\u001c8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/crosspaste/task/SwitchLanguageTaskExecutor;", "Lcom/crosspaste/task/SingleTypeTaskExecutor;", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/config/AppConfig;", "Lcom/crosspaste/config/CommonConfigManager;", "configManager", "Lcom/crosspaste/paste/GuidePasteDataService;", "guidePasteDataService", "<init>", "(Lcom/crosspaste/config/ConfigManager;Lcom/crosspaste/paste/GuidePasteDataService;)V", "Lcom/crosspaste/db/task/PasteTask;", "pasteTask", "Lcom/crosspaste/task/PasteTaskResult;", "doExecuteTask", "(Lcom/crosspaste/db/task/PasteTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/crosspaste/db/task/SwitchLanguageInfo;", "switchLanguageInfo", "Lcom/crosspaste/exception/ErrorCodeSupplier;", "errorCodeSupplier", "", "errorMessage", "createFailurePasteTaskResult", "(Lcom/crosspaste/db/task/SwitchLanguageInfo;Lcom/crosspaste/exception/ErrorCodeSupplier;Ljava/lang/String;)Lcom/crosspaste/task/PasteTaskResult;", "Lcom/crosspaste/config/ConfigManager;", "Lcom/crosspaste/paste/GuidePasteDataService;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "", "taskType", "I", "getTaskType", "()I", "app"})
@StabilityInferred(parameters=0)
public final class SwitchLanguageTaskExecutor
implements SingleTypeTaskExecutor {
    @NotNull
    private final ConfigManager<AppConfig> configManager;
    @NotNull
    private final GuidePasteDataService guidePasteDataService;
    @NotNull
    private final KLogger logger;
    private final int taskType;
    public static final int $stable = 8;

    public SwitchLanguageTaskExecutor(@NotNull ConfigManager<AppConfig> configManager, @NotNull GuidePasteDataService guidePasteDataService) {
        Intrinsics.checkNotNullParameter(configManager, (String)"configManager");
        Intrinsics.checkNotNullParameter((Object)guidePasteDataService, (String)"guidePasteDataService");
        this.configManager = configManager;
        this.guidePasteDataService = guidePasteDataService;
        this.logger = KotlinLogging.INSTANCE.logger(SwitchLanguageTaskExecutor::logger$lambda$0);
        this.taskType = 8;
    }

    @Override
    public int getTaskType() {
        return this.taskType;
    }

    @Override
    @Nullable
    public Object doExecuteTask(@NotNull PasteTask pasteTask, @NotNull Continuation<? super PasteTaskResult> $completion) {
        Object object;
        Object $this$doExecuteTask_u24lambda_u242;
        SwitchLanguageInfo switchLanguageInfo = (SwitchLanguageInfo)TaskUtils.INSTANCE.getExtraInfo(pasteTask, Reflection.getOrCreateKotlinClass(SwitchLanguageInfo.class));
        String currentLanguage = this.configManager.getCurrentConfig().getLanguage();
        if (!Intrinsics.areEqual((Object)switchLanguageInfo.getLanguage(), (Object)currentLanguage)) {
            this.logger.info(() -> SwitchLanguageTaskExecutor.doExecuteTask$lambda$1(switchLanguageInfo, currentLanguage));
            return new SuccessPasteTaskResult(null, 1, null);
        }
        Object object2 = this;
        try {
            $this$doExecuteTask_u24lambda_u242 = object2;
            boolean bl = false;
            ((SwitchLanguageTaskExecutor)$this$doExecuteTask_u24lambda_u242).guidePasteDataService.updateData();
            $this$doExecuteTask_u24lambda_u242 = Result.constructor-impl((Object)new SuccessPasteTaskResult(null, 1, null));
        }
        catch (Throwable bl) {
            $this$doExecuteTask_u24lambda_u242 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$doExecuteTask_u24lambda_u242;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            object = SwitchLanguageTaskExecutor.createFailurePasteTaskResult$default(this, switchLanguageInfo, null, "switch fail: " + e.getMessage(), 2, null);
        }
        return object;
    }

    private final PasteTaskResult createFailurePasteTaskResult(SwitchLanguageInfo switchLanguageInfo, ErrorCodeSupplier errorCodeSupplier, String errorMessage) {
        return TaskUtils.INSTANCE.createFailurePasteTaskResult(this.logger, (Function0<Boolean>)((Function0)SwitchLanguageTaskExecutor::createFailurePasteTaskResult$lambda$4), DateUtils.INSTANCE.nowEpochMilliseconds(), CollectionsKt.listOf((Object)ClientApiResultKt.createFailureResult(errorCodeSupplier, errorMessage)), (PasteTaskExtraInfo)switchLanguageInfo);
    }

    static /* synthetic */ PasteTaskResult createFailurePasteTaskResult$default(SwitchLanguageTaskExecutor switchLanguageTaskExecutor, SwitchLanguageInfo switchLanguageInfo, ErrorCodeSupplier errorCodeSupplier, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            errorCodeSupplier = StandardErrorCode.SWITCH_LANGUAGE_TASK_FAIL;
        }
        return switchLanguageTaskExecutor.createFailurePasteTaskResult(switchLanguageInfo, errorCodeSupplier, string2);
    }

    @Override
    @Nullable
    public Object executeTask(@NotNull PasteTask pasteTask, @NotNull Function2<? super String, ? super Continuation<? super Unit>, ? extends Object> success, @NotNull Function3<? super String, ? super Boolean, ? super Continuation<? super Unit>, ? extends Object> fail2, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> retry, @NotNull Continuation<? super Unit> $completion) {
        return SingleTypeTaskExecutor.super.executeTask(pasteTask, success, fail2, retry, $completion);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object doExecuteTask$lambda$1(SwitchLanguageInfo $switchLanguageInfo, String $currentLanguage) {
        return "Skip switch to " + $switchLanguageInfo.getLanguage() + ", current language is " + $currentLanguage;
    }

    private static final boolean createFailurePasteTaskResult$lambda$4() {
        return false;
    }
}

