/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.task;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.db.task.BaseExtraInfo;
import com.crosspaste.db.task.PasteTask;
import com.crosspaste.db.task.PasteTaskExtraInfo;
import com.crosspaste.db.task.TaskDao;
import com.crosspaste.exception.ErrorCodeSupplier;
import com.crosspaste.exception.StandardErrorCode;
import com.crosspaste.net.clientapi.ClientApiResultKt;
import com.crosspaste.task.PasteTaskResult;
import com.crosspaste.task.SingleTypeTaskExecutor;
import com.crosspaste.task.SuccessPasteTaskResult;
import com.crosspaste.utils.DateUtils;
import com.crosspaste.utils.TaskUtils;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000bR\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u000f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/crosspaste/task/CleanTaskTaskExecutor;", "Lcom/crosspaste/task/SingleTypeTaskExecutor;", "Lcom/crosspaste/db/task/TaskDao;", "taskDao", "<init>", "(Lcom/crosspaste/db/task/TaskDao;)V", "Lcom/crosspaste/db/task/PasteTask;", "pasteTask", "Lcom/crosspaste/task/PasteTaskResult;", "doExecuteTask", "(Lcom/crosspaste/db/task/PasteTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/crosspaste/db/task/TaskDao;", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "", "taskType", "I", "getTaskType", "()I", "app"})
@StabilityInferred(parameters=0)
public final class CleanTaskTaskExecutor
implements SingleTypeTaskExecutor {
    @NotNull
    private final TaskDao taskDao;
    @NotNull
    private final KLogger logger;
    private final int taskType;
    public static final int $stable = 8;

    public CleanTaskTaskExecutor(@NotNull TaskDao taskDao) {
        Intrinsics.checkNotNullParameter((Object)taskDao, (String)"taskDao");
        this.taskDao = taskDao;
        this.logger = KotlinLogging.INSTANCE.logger(CleanTaskTaskExecutor::logger$lambda$0);
        this.taskType = 7;
    }

    @Override
    public int getTaskType() {
        return this.taskType;
    }

    @Override
    @Nullable
    public Object doExecuteTask(@NotNull PasteTask pasteTask, @NotNull Continuation<? super PasteTaskResult> $completion) {
        Object object;
        Object $this$doExecuteTask_u24lambda_u241;
        Object object2 = this;
        try {
            $this$doExecuteTask_u24lambda_u241 = object2;
            boolean bl = false;
            long twelveHours = DurationKt.toDuration((int)12, (DurationUnit)DurationUnit.HOURS);
            long prev12Hours = DateUtils.INSTANCE.nowInstant().minus-LRDsOJo(twelveHours).toEpochMilliseconds();
            ((CleanTaskTaskExecutor)$this$doExecuteTask_u24lambda_u241).taskDao.cleanSuccessTask(prev12Hours);
            long threeDays = DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.DAYS);
            long prev3Days = DateUtils.INSTANCE.nowInstant().minus-LRDsOJo(threeDays).toEpochMilliseconds();
            ((CleanTaskTaskExecutor)$this$doExecuteTask_u24lambda_u241).taskDao.cleanFailureTask(prev3Days);
            $this$doExecuteTask_u24lambda_u241 = Result.constructor-impl((Object)new SuccessPasteTaskResult(null, 1, null));
        }
        catch (Throwable bl) {
            $this$doExecuteTask_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$doExecuteTask_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object e = $this$doExecuteTask_u24lambda_u241 = throwable;
            boolean bl = false;
            this.logger.error((Throwable)e, CleanTaskTaskExecutor::doExecuteTask$lambda$3$lambda$2);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 == null) {
            object = object2;
        } else {
            Throwable it = throwable2;
            boolean bl = false;
            BaseExtraInfo baseExtraInfo = (BaseExtraInfo)TaskUtils.INSTANCE.getExtraInfo(pasteTask, Reflection.getOrCreateKotlinClass(BaseExtraInfo.class));
            object = TaskUtils.INSTANCE.createFailurePasteTaskResult(this.logger, (Function0<Boolean>)((Function0)() -> CleanTaskTaskExecutor.doExecuteTask$lambda$5$lambda$4(baseExtraInfo)), pasteTask.getModifyTime(), CollectionsKt.listOf((Object)ClientApiResultKt.createFailureResult((ErrorCodeSupplier)StandardErrorCode.CLEAN_TASK_FAIL, it)), (PasteTaskExtraInfo)baseExtraInfo);
        }
        return object;
    }

    @Override
    @Nullable
    public Object executeTask(@NotNull PasteTask pasteTask, @NotNull Function2<? super String, ? super Continuation<? super Unit>, ? extends Object> success, @NotNull Function3<? super String, ? super Boolean, ? super Continuation<? super Unit>, ? extends Object> fail2, @NotNull Function1<? super Continuation<? super Unit>, ? extends Object> retry, @NotNull Continuation<? super Unit> $completion) {
        return SingleTypeTaskExecutor.super.executeTask(pasteTask, success, fail2, retry, $completion);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object doExecuteTask$lambda$3$lambda$2() {
        return "Error while cleaning task";
    }

    private static final boolean doExecuteTask$lambda$5$lambda$4(BaseExtraInfo $baseExtraInfo) {
        return $baseExtraInfo.getExecutionHistories().size() < 2;
    }
}

