/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.sync;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.app.AppInfo;
import com.crosspaste.app.EndpointInfoFactory;
import com.crosspaste.dto.sync.EndpointInfo;
import com.crosspaste.dto.sync.SyncInfo;
import com.crosspaste.image.PlatformImage;
import com.crosspaste.net.NetworkInterfaceInfo;
import com.crosspaste.net.NetworkInterfaceService;
import com.crosspaste.utils.CodecsUtils;
import com.crosspaste.utils.CodecsUtils_desktopKt;
import com.crosspaste.utils.JsonUtils;
import com.crosspaste.utils.JsonUtils_desktopKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH&\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u001f\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J#\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001a\u001a\u00020\u000fH\u0004\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u001f\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0013\u0010!\u001a\u00020\u0015*\u00020\u0017H\u0002\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020)8\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lcom/crosspaste/sync/QRCodeGenerator;", "", "Lcom/crosspaste/app/AppInfo;", "appInfo", "Lcom/crosspaste/app/EndpointInfoFactory;", "endpointInfoFactory", "Lcom/crosspaste/net/NetworkInterfaceService;", "networkInterfaceService", "<init>", "(Lcom/crosspaste/app/AppInfo;Lcom/crosspaste/app/EndpointInfoFactory;Lcom/crosspaste/net/NetworkInterfaceService;)V", "", "token", "Lcom/crosspaste/image/PlatformImage;", "generateQRCode", "([C)Lcom/crosspaste/image/PlatformImage;", "", "buildQRCode", "([C)Ljava/lang/String;", "Lcom/crosspaste/dto/sync/SyncInfo;", "syncInfo", "(Lcom/crosspaste/dto/sync/SyncInfo;[C)Ljava/lang/String;", "", "syncInfoBytes", "", "encodeSyncInfo", "([BI)Ljava/lang/String;", "encodedString", "Lkotlin/Pair;", "decodeSyncInfo", "(Ljava/lang/String;)Lkotlin/Pair;", "offset", "rotate", "([BI)[B", "toByteArray", "(I)[B", "Lcom/crosspaste/app/AppInfo;", "Lcom/crosspaste/app/EndpointInfoFactory;", "Lcom/crosspaste/net/NetworkInterfaceService;", "Lcom/crosspaste/utils/CodecsUtils;", "codecsUtils", "Lcom/crosspaste/utils/CodecsUtils;", "Lcom/crosspaste/utils/JsonUtils;", "jsonUtils", "Lcom/crosspaste/utils/JsonUtils;", "getJsonUtils", "()Lcom/crosspaste/utils/JsonUtils;", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nQRCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QRCodeGenerator.kt\ncom/crosspaste/sync/QRCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,99:1\n1563#2:100\n1634#2,3:101\n205#3:104\n222#3:105\n*S KotlinDebug\n*F\n+ 1 QRCodeGenerator.kt\ncom/crosspaste/sync/QRCodeGenerator\n*L\n26#1:100\n26#1:101,3\n36#1:104\n75#1:105\n*E\n"})
public abstract class QRCodeGenerator {
    @NotNull
    private final AppInfo appInfo;
    @NotNull
    private final EndpointInfoFactory endpointInfoFactory;
    @NotNull
    private final NetworkInterfaceService networkInterfaceService;
    @NotNull
    private final CodecsUtils codecsUtils;
    @NotNull
    private final JsonUtils jsonUtils;
    public static final int $stable = 8;

    public QRCodeGenerator(@NotNull AppInfo appInfo, @NotNull EndpointInfoFactory endpointInfoFactory, @NotNull NetworkInterfaceService networkInterfaceService) {
        Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
        Intrinsics.checkNotNullParameter((Object)endpointInfoFactory, (String)"endpointInfoFactory");
        Intrinsics.checkNotNullParameter((Object)networkInterfaceService, (String)"networkInterfaceService");
        this.appInfo = appInfo;
        this.endpointInfoFactory = endpointInfoFactory;
        this.networkInterfaceService = networkInterfaceService;
        this.codecsUtils = CodecsUtils_desktopKt.getCodecsUtils();
        this.jsonUtils = JsonUtils_desktopKt.getJsonUtils();
    }

    @NotNull
    protected final JsonUtils getJsonUtils() {
        return this.jsonUtils;
    }

    @NotNull
    public abstract PlatformImage generateQRCode(@NotNull char[] var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String buildQRCode(@NotNull char[] token) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Iterable $this$map$iv = this.networkInterfaceService.getCurrentUseNetworkInterfaces();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NetworkInterfaceInfo networkInterfaceInfo = (NetworkInterfaceInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toHostInfo());
        }
        List hostInfoList = (List)destination$iv$iv;
        EndpointInfo endpointInfo = this.endpointInfoFactory.createEndpointInfo(hostInfoList);
        SyncInfo syncInfo2 = new SyncInfo(this.appInfo, endpointInfo);
        return this.buildQRCode(syncInfo2, token);
    }

    /*
     * WARNING - void declaration
     */
    private final String buildQRCode(SyncInfo syncInfo2, char[] token) {
        void this_$iv;
        Json json = this.jsonUtils.getJSON();
        SyncInfo value$iv = syncInfo2;
        boolean $i$f$encodeToString = false;
        this_$iv.getSerializersModule();
        String syncInfoJson = this_$iv.encodeToString((SerializationStrategy)SyncInfo.Companion.serializer(), (Object)value$iv);
        byte[] syncInfoBytes = StringsKt.encodeToByteArray((String)syncInfoJson);
        return this.encodeSyncInfo(syncInfoBytes, Integer.parseInt(StringsKt.concatToString((char[])token)));
    }

    private final String encodeSyncInfo(byte[] syncInfoBytes, int token) {
        int size = syncInfoBytes.length;
        int offset = token % size;
        byte[] rotatedBytes = this.rotate(syncInfoBytes, offset);
        byte[] saltedBytes = ArraysKt.plus((byte[])rotatedBytes, (byte[])this.toByteArray(token));
        return this.codecsUtils.base64Encode(saltedBytes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Pair<SyncInfo, Integer> decodeSyncInfo(@NotNull String encodedString) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)encodedString, (String)"encodedString");
        byte[] decodedBytes = this.codecsUtils.base64Decode(encodedString);
        if (decodedBytes.length < 4) {
            throw new IllegalArgumentException("Decoded bytes too short to contain token");
        }
        List bytes = ArraysKt.takeLast((byte[])decodedBytes, (int)4);
        boolean bl = false;
        int token = (((Number)bytes.get(0)).byteValue() & 0xFF) << 24 | (((Number)bytes.get(1)).byteValue() & 0xFF) << 16 | (((Number)bytes.get(2)).byteValue() & 0xFF) << 8 | ((Number)bytes.get(3)).byteValue() & 0xFF;
        byte[] syncInfoWithRotation = CollectionsKt.toByteArray((Collection)ArraysKt.dropLast((byte[])decodedBytes, (int)4));
        int size = syncInfoWithRotation.length;
        int offset = token % size;
        byte[] originalBytes = this.rotate(syncInfoWithRotation, (size - offset) % size);
        Json json = this.jsonUtils.getJSON();
        String string$iv = StringsKt.decodeToString((byte[])originalBytes);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        SyncInfo syncInfo2 = (SyncInfo)this_$iv.decodeFromString((DeserializationStrategy)SyncInfo.Companion.serializer(), string$iv);
        return new Pair((Object)syncInfo2, (Object)token);
    }

    private final byte[] rotate(byte[] $this$rotate, int offset) {
        byte[] byArray;
        int effectiveOffset = offset % $this$rotate.length;
        if (effectiveOffset == 0 || $this$rotate.length == 0) {
            byte[] byArray2 = Arrays.copyOf($this$rotate, $this$rotate.length);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"copyOf(...)");
        } else {
            int n = 0;
            int n2 = $this$rotate.length;
            byte[] byArray3 = new byte[n2];
            while (n < n2) {
                int n3 = n++;
                byArray3[n3] = $this$rotate[(n3 - effectiveOffset + $this$rotate.length) % $this$rotate.length];
            }
            byArray = byArray3;
        }
        return byArray;
    }

    private final byte[] toByteArray(int $this$toByteArray) {
        byte[] byArray = new byte[]{(byte)($this$toByteArray >> 24), (byte)($this$toByteArray >> 16), (byte)($this$toByteArray >> 8), (byte)$this$toByteArray};
        return byArray;
    }
}

