/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.exception.PasteException;
import com.crosspaste.exception.StandardErrorCode;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.AES;
import dev.whyoleg.cryptography.algorithms.ECDH;
import dev.whyoleg.cryptography.materials.key.Key;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/crosspaste/secure/SecureMessageProcessor;", "", "Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "privateKey", "Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "publicKey", "<init>", "(Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;)V", "", "data", "encrypt", "([B)[B", "decrypt", "Lio/github/oshai/kotlinlogging/KLogger;", "logger", "Lio/github/oshai/kotlinlogging/KLogger;", "Ldev/whyoleg/cryptography/CryptographyProvider;", "provider", "Ldev/whyoleg/cryptography/CryptographyProvider;", "Ldev/whyoleg/cryptography/algorithms/AES$IvCipher;", "cipher", "Ldev/whyoleg/cryptography/algorithms/AES$IvCipher;", "app"})
@StabilityInferred(parameters=0)
public final class SecureMessageProcessor {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final CryptographyProvider provider;
    @NotNull
    private final AES.IvCipher cipher;
    public static final int $stable = 8;

    public SecureMessageProcessor(@NotNull ECDH.PrivateKey privateKey, @NotNull ECDH.PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.logger = KotlinLogging.INSTANCE.logger(SecureMessageProcessor::logger$lambda$0);
        this.provider = CryptographyProvider.Companion.getDefault();
        AES.CBC aes = (AES.CBC)this.provider.get((CryptographyAlgorithmId)AES.CBC.Companion);
        byte[] bytes = privateKey.sharedSecretGenerator().generateSharedSecretToByteArrayBlocking((Key)publicKey);
        AES.CBC.Key key = (AES.CBC.Key)aes.keyDecoder().decodeFromByteArrayBlocking((KeyFormat)AES.Key.Format.RAW, bytes);
        this.cipher = AES.CBC.Key.cipher$default((AES.CBC.Key)key, (boolean)false, (int)1, null);
    }

    @NotNull
    public final byte[] encrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            return this.cipher.encryptBlocking(data);
        }
        catch (Throwable e) {
            this.logger.error(e, SecureMessageProcessor::encrypt$lambda$1);
            throw new PasteException(StandardErrorCode.ENCRYPT_FAIL.toErrorCode(), e);
        }
    }

    @NotNull
    public final byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            return this.cipher.decryptBlocking(data);
        }
        catch (Throwable e) {
            this.logger.error(e, SecureMessageProcessor::decrypt$lambda$2);
            throw new PasteException(StandardErrorCode.DECRYPT_FAIL.toErrorCode(), e);
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object encrypt$lambda$1() {
        return "Encrypt fail";
    }

    private static final Object decrypt$lambda$2() {
        return "Decrypt fail";
    }
}

