/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.secure.ECDHKeyPairImpl;
import com.crosspaste.secure.ECDSAKeyPairImpl;
import com.crosspaste.secure.SecureKeyPair;
import dev.whyoleg.cryptography.CryptographyAlgorithmId;
import dev.whyoleg.cryptography.CryptographyProvider;
import dev.whyoleg.cryptography.algorithms.EC;
import dev.whyoleg.cryptography.algorithms.ECDH;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import dev.whyoleg.cryptography.materials.key.KeyDecoder;
import dev.whyoleg.cryptography.materials.key.KeyFormat;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010 \u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b \u0010!J\u0015\u0010#\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\"\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b%\u0010&J\u0015\u0010(\u001a\u00020'2\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020'\u00a2\u0006\u0004\b*\u0010+J'\u00101\u001a\u0002002\u0006\u0010,\u001a\u00020\u00062\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-H\u0002\u00a2\u0006\u0004\b1\u00102J\u001f\u00104\u001a\u00020-2\u0006\u00103\u001a\u00020\u00062\u0006\u0010/\u001a\u00020-H\u0002\u00a2\u0006\u0004\b4\u00105R\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0014\u0010:\u001a\u0002098\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020<8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>R \u0010A\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u00040?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR \u0010D\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\f0?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010BR \u0010E\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u00020\u00180?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010BR \u0010F\u001a\u000e\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u001d0?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010B\u00a8\u0006G"}, d2={"Lcom/crosspaste/secure/SecureKeyPairSerializer;", "", "<init>", "()V", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "publicKey", "", "encodeSignPublicKey", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;)[B", "bytes", "decodeSignPublicKey", "([B)Ldev/whyoleg/cryptography/algorithms/ECDSA$PublicKey;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "privateKey", "encodeSignPrivateKey", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;)[B", "decodeSignPrivateKey", "([B)Ldev/whyoleg/cryptography/algorithms/ECDSA$PrivateKey;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;", "keyPair", "encodeSignKeyPair", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;)[B", "decodeSignKeyPair", "([B)Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "encodeCryptPublicKey", "(Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;)[B", "decodeCryptPublicKey", "([B)Ldev/whyoleg/cryptography/algorithms/ECDH$PublicKey;", "Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "encodeCryptPrivateKey", "(Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;)[B", "decodeCryptPrivateKey", "([B)Ldev/whyoleg/cryptography/algorithms/ECDH$PrivateKey;", "Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;", "encodeCryptKeyPair", "(Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;)[B", "decodeCryptKeyPair", "([B)Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;", "Lcom/crosspaste/secure/SecureKeyPair;", "decodeSecureKeyPair", "([B)Lcom/crosspaste/secure/SecureKeyPair;", "encodeSecureKeyPair", "(Lcom/crosspaste/secure/SecureKeyPair;)[B", "dest", "", "value", "offset", "", "writeIntToByteArray", "([BII)V", "src", "readIntFromByteArray", "([BI)I", "Ldev/whyoleg/cryptography/CryptographyProvider;", "provider", "Ldev/whyoleg/cryptography/CryptographyProvider;", "Ldev/whyoleg/cryptography/algorithms/ECDSA;", "ecdsa", "Ldev/whyoleg/cryptography/algorithms/ECDSA;", "Ldev/whyoleg/cryptography/algorithms/ECDH;", "ecdh", "Ldev/whyoleg/cryptography/algorithms/ECDH;", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/EC$PublicKey$Format;", "signPublicKeyDecoder", "Ldev/whyoleg/cryptography/materials/key/KeyDecoder;", "Ldev/whyoleg/cryptography/algorithms/EC$PrivateKey$Format;", "signPrivateKeyDecoder", "cryptPublicKeyDecoder", "cryptPrivateKeyDecoder", "app"})
@StabilityInferred(parameters=0)
public final class SecureKeyPairSerializer {
    @NotNull
    private final CryptographyProvider provider = CryptographyProvider.Companion.getDefault();
    @NotNull
    private final ECDSA ecdsa = (ECDSA)this.provider.get((CryptographyAlgorithmId)ECDSA.Companion);
    @NotNull
    private final ECDH ecdh = (ECDH)this.provider.get((CryptographyAlgorithmId)ECDH.Companion);
    @NotNull
    private final KeyDecoder<EC.PublicKey.Format, ECDSA.PublicKey> signPublicKeyDecoder = this.ecdsa.publicKeyDecoder-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk());
    @NotNull
    private final KeyDecoder<EC.PrivateKey.Format, ECDSA.PrivateKey> signPrivateKeyDecoder = this.ecdsa.privateKeyDecoder-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk());
    @NotNull
    private final KeyDecoder<EC.PublicKey.Format, ECDH.PublicKey> cryptPublicKeyDecoder = this.ecdh.publicKeyDecoder-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk());
    @NotNull
    private final KeyDecoder<EC.PrivateKey.Format, ECDH.PrivateKey> cryptPrivateKeyDecoder = this.ecdh.privateKeyDecoder-yfdS0HE(EC.Curve.Companion.getP256-pVITJAk());
    public static final int $stable = 8;

    @NotNull
    public final byte[] encodeSignPublicKey(@NotNull ECDSA.PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return publicKey.encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.DER.INSTANCE);
    }

    @NotNull
    public final ECDSA.PublicKey decodeSignPublicKey(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return (ECDSA.PublicKey)this.signPublicKeyDecoder.decodeFromByteArrayBlocking((KeyFormat)EC.PublicKey.Format.DER.INSTANCE, bytes);
    }

    @NotNull
    public final byte[] encodeSignPrivateKey(@NotNull ECDSA.PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return privateKey.encodeToByteArrayBlocking((KeyFormat)EC.PrivateKey.Format.DER.Generic);
    }

    @NotNull
    public final ECDSA.PrivateKey decodeSignPrivateKey(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return (ECDSA.PrivateKey)this.signPrivateKeyDecoder.decodeFromByteArrayBlocking((KeyFormat)EC.PrivateKey.Format.DER.Generic, bytes);
    }

    @NotNull
    public final byte[] encodeSignKeyPair(@NotNull ECDSA.KeyPair keyPair) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        byte[] publicKeyBytes = this.encodeSignPublicKey((ECDSA.PublicKey)keyPair.getPublicKey());
        byte[] privateKeyBytes = this.encodeSignPrivateKey((ECDSA.PrivateKey)keyPair.getPrivateKey());
        int totalSize = 4 + publicKeyBytes.length + 4 + privateKeyBytes.length;
        byte[] $this$encodeSignKeyPair_u24lambda_u240 = byArray = new byte[totalSize];
        boolean bl = false;
        int offset = 0;
        this.writeIntToByteArray($this$encodeSignKeyPair_u24lambda_u240, publicKeyBytes.length, offset);
        ArraysKt.copyInto$default((byte[])publicKeyBytes, (byte[])$this$encodeSignKeyPair_u24lambda_u240, (int)(offset += 4), (int)0, (int)0, (int)12, null);
        this.writeIntToByteArray($this$encodeSignKeyPair_u24lambda_u240, privateKeyBytes.length, offset += publicKeyBytes.length);
        ArraysKt.copyInto$default((byte[])privateKeyBytes, (byte[])$this$encodeSignKeyPair_u24lambda_u240, (int)(offset += 4), (int)0, (int)0, (int)12, null);
        return byArray;
    }

    @NotNull
    public final ECDSA.KeyPair decodeSignKeyPair(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset = 0;
        int publicKeySize = this.readIntFromByteArray(bytes, offset);
        byte[] publicKeyBytes = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)(offset += 4), (int)(offset + publicKeySize)));
        int privateKeySize = this.readIntFromByteArray(bytes, offset += publicKeySize);
        byte[] privateKeyBytes = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)(offset += 4), (int)(offset + privateKeySize)));
        return new ECDSAKeyPairImpl(this.decodeSignPublicKey(publicKeyBytes), this.decodeSignPrivateKey(privateKeyBytes));
    }

    @NotNull
    public final byte[] encodeCryptPublicKey(@NotNull ECDH.PublicKey publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        return publicKey.encodeToByteArrayBlocking((KeyFormat)EC.PublicKey.Format.DER.INSTANCE);
    }

    @NotNull
    public final ECDH.PublicKey decodeCryptPublicKey(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return (ECDH.PublicKey)this.cryptPublicKeyDecoder.decodeFromByteArrayBlocking((KeyFormat)EC.PublicKey.Format.DER.INSTANCE, bytes);
    }

    @NotNull
    public final byte[] encodeCryptPrivateKey(@NotNull ECDH.PrivateKey privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        return privateKey.encodeToByteArrayBlocking((KeyFormat)EC.PrivateKey.Format.DER.Generic);
    }

    @NotNull
    public final ECDH.PrivateKey decodeCryptPrivateKey(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return (ECDH.PrivateKey)this.cryptPrivateKeyDecoder.decodeFromByteArrayBlocking((KeyFormat)EC.PrivateKey.Format.DER.Generic, bytes);
    }

    @NotNull
    public final byte[] encodeCryptKeyPair(@NotNull ECDH.KeyPair keyPair) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        byte[] publicKeyBytes = this.encodeCryptPublicKey((ECDH.PublicKey)keyPair.getPublicKey());
        byte[] privateKeyBytes = this.encodeCryptPrivateKey((ECDH.PrivateKey)keyPair.getPrivateKey());
        int totalSize = 4 + publicKeyBytes.length + 4 + privateKeyBytes.length;
        byte[] $this$encodeCryptKeyPair_u24lambda_u241 = byArray = new byte[totalSize];
        boolean bl = false;
        int offset = 0;
        this.writeIntToByteArray($this$encodeCryptKeyPair_u24lambda_u241, publicKeyBytes.length, offset);
        ArraysKt.copyInto$default((byte[])publicKeyBytes, (byte[])$this$encodeCryptKeyPair_u24lambda_u241, (int)(offset += 4), (int)0, (int)0, (int)12, null);
        this.writeIntToByteArray($this$encodeCryptKeyPair_u24lambda_u241, privateKeyBytes.length, offset += publicKeyBytes.length);
        ArraysKt.copyInto$default((byte[])privateKeyBytes, (byte[])$this$encodeCryptKeyPair_u24lambda_u241, (int)(offset += 4), (int)0, (int)0, (int)12, null);
        return byArray;
    }

    @NotNull
    public final ECDH.KeyPair decodeCryptKeyPair(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset = 0;
        int publicKeySize = this.readIntFromByteArray(bytes, offset);
        byte[] publicKeyBytes = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)(offset += 4), (int)(offset + publicKeySize)));
        int privateKeySize = this.readIntFromByteArray(bytes, offset += publicKeySize);
        byte[] privateKeyBytes = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)(offset += 4), (int)(offset + privateKeySize)));
        return new ECDHKeyPairImpl(this.decodeCryptPublicKey(publicKeyBytes), this.decodeCryptPrivateKey(privateKeyBytes));
    }

    @NotNull
    public final SecureKeyPair decodeSecureKeyPair(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        int offset = 0;
        int signKeyPairSize = this.readIntFromByteArray(bytes, offset);
        byte[] signKeyPairBytes = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)(offset += 4), (int)(offset + signKeyPairSize)));
        int cryptKeyPairSize = this.readIntFromByteArray(bytes, offset += signKeyPairSize);
        byte[] cryptKeyPairBytes = ArraysKt.sliceArray((byte[])bytes, (IntRange)RangesKt.until((int)(offset += 4), (int)(offset + cryptKeyPairSize)));
        ECDSA.KeyPair signKeyPair = this.decodeSignKeyPair(signKeyPairBytes);
        ECDH.KeyPair cryptKeyPair = this.decodeCryptKeyPair(cryptKeyPairBytes);
        return new SecureKeyPair(signKeyPair, cryptKeyPair);
    }

    @NotNull
    public final byte[] encodeSecureKeyPair(@NotNull SecureKeyPair keyPair) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)keyPair, (String)"keyPair");
        byte[] signKeyPairBytes = this.encodeSignKeyPair(keyPair.getSignKeyPair());
        byte[] cryptKeyPairBytes = this.encodeCryptKeyPair(keyPair.getCryptKeyPair());
        int totalSize = 4 + signKeyPairBytes.length + 4 + cryptKeyPairBytes.length;
        byte[] $this$encodeSecureKeyPair_u24lambda_u242 = byArray = new byte[totalSize];
        boolean bl = false;
        int offset = 0;
        this.writeIntToByteArray($this$encodeSecureKeyPair_u24lambda_u242, signKeyPairBytes.length, offset);
        ArraysKt.copyInto$default((byte[])signKeyPairBytes, (byte[])$this$encodeSecureKeyPair_u24lambda_u242, (int)(offset += 4), (int)0, (int)0, (int)12, null);
        this.writeIntToByteArray($this$encodeSecureKeyPair_u24lambda_u242, cryptKeyPairBytes.length, offset += signKeyPairBytes.length);
        ArraysKt.copyInto$default((byte[])cryptKeyPairBytes, (byte[])$this$encodeSecureKeyPair_u24lambda_u242, (int)(offset += 4), (int)0, (int)0, (int)12, null);
        return byArray;
    }

    private final void writeIntToByteArray(byte[] dest, int value, int offset) {
        dest[offset] = (byte)(value >> 24);
        dest[offset + 1] = (byte)(value >> 16);
        dest[offset + 2] = (byte)(value >> 8);
        dest[offset + 3] = (byte)value;
    }

    private final int readIntFromByteArray(byte[] src, int offset) {
        return (src[offset] & 0xFF) << 24 | (src[offset + 1] & 0xFF) << 16 | (src[offset + 2] & 0xFF) << 8 | src[offset + 3] & 0xFF;
    }
}

