/*
 * Decompiled with CFR 0.152.
 */
package com.crosspaste.secure;

import androidx.compose.runtime.internal.StabilityInferred;
import com.crosspaste.secure.SecureKeyPairSerializer;
import dev.whyoleg.cryptography.algorithms.ECDH;
import dev.whyoleg.cryptography.algorithms.ECDSA;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\r\u0010\fJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J$\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010\u000fR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010 \u001a\u0004\b!\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/crosspaste/secure/SecureKeyPair;", "", "Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;", "signKeyPair", "Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;", "cryptKeyPair", "<init>", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;)V", "Lcom/crosspaste/secure/SecureKeyPairSerializer;", "secureKeyPairSerializer", "", "getSignPublicKeyBytes", "(Lcom/crosspaste/secure/SecureKeyPairSerializer;)[B", "getCryptPublicKeyBytes", "component1", "()Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;", "component2", "()Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;", "copy", "(Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;)Lcom/crosspaste/secure/SecureKeyPair;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ldev/whyoleg/cryptography/algorithms/ECDSA$KeyPair;", "getSignKeyPair", "Ldev/whyoleg/cryptography/algorithms/ECDH$KeyPair;", "getCryptKeyPair", "app"})
@StabilityInferred(parameters=0)
public final class SecureKeyPair {
    @NotNull
    private final ECDSA.KeyPair signKeyPair;
    @NotNull
    private final ECDH.KeyPair cryptKeyPair;
    public static final int $stable = 8;

    public SecureKeyPair(@NotNull ECDSA.KeyPair signKeyPair, @NotNull ECDH.KeyPair cryptKeyPair) {
        Intrinsics.checkNotNullParameter((Object)signKeyPair, (String)"signKeyPair");
        Intrinsics.checkNotNullParameter((Object)cryptKeyPair, (String)"cryptKeyPair");
        this.signKeyPair = signKeyPair;
        this.cryptKeyPair = cryptKeyPair;
    }

    @NotNull
    public final ECDSA.KeyPair getSignKeyPair() {
        return this.signKeyPair;
    }

    @NotNull
    public final ECDH.KeyPair getCryptKeyPair() {
        return this.cryptKeyPair;
    }

    @NotNull
    public final byte[] getSignPublicKeyBytes(@NotNull SecureKeyPairSerializer secureKeyPairSerializer) {
        Intrinsics.checkNotNullParameter((Object)secureKeyPairSerializer, (String)"secureKeyPairSerializer");
        return secureKeyPairSerializer.encodeSignPublicKey((ECDSA.PublicKey)this.signKeyPair.getPublicKey());
    }

    @NotNull
    public final byte[] getCryptPublicKeyBytes(@NotNull SecureKeyPairSerializer secureKeyPairSerializer) {
        Intrinsics.checkNotNullParameter((Object)secureKeyPairSerializer, (String)"secureKeyPairSerializer");
        return secureKeyPairSerializer.encodeCryptPublicKey((ECDH.PublicKey)this.cryptKeyPair.getPublicKey());
    }

    @NotNull
    public final ECDSA.KeyPair component1() {
        return this.signKeyPair;
    }

    @NotNull
    public final ECDH.KeyPair component2() {
        return this.cryptKeyPair;
    }

    @NotNull
    public final SecureKeyPair copy(@NotNull ECDSA.KeyPair signKeyPair, @NotNull ECDH.KeyPair cryptKeyPair) {
        Intrinsics.checkNotNullParameter((Object)signKeyPair, (String)"signKeyPair");
        Intrinsics.checkNotNullParameter((Object)cryptKeyPair, (String)"cryptKeyPair");
        return new SecureKeyPair(signKeyPair, cryptKeyPair);
    }

    public static /* synthetic */ SecureKeyPair copy$default(SecureKeyPair secureKeyPair, ECDSA.KeyPair keyPair, ECDH.KeyPair keyPair2, int n, Object object) {
        if ((n & 1) != 0) {
            keyPair = secureKeyPair.signKeyPair;
        }
        if ((n & 2) != 0) {
            keyPair2 = secureKeyPair.cryptKeyPair;
        }
        return secureKeyPair.copy(keyPair, keyPair2);
    }

    @NotNull
    public String toString() {
        return "SecureKeyPair(signKeyPair=" + this.signKeyPair + ", cryptKeyPair=" + this.cryptKeyPair + ")";
    }

    public int hashCode() {
        int result2 = this.signKeyPair.hashCode();
        result2 = result2 * 31 + this.cryptKeyPair.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SecureKeyPair)) {
            return false;
        }
        SecureKeyPair secureKeyPair = (SecureKeyPair)other;
        if (!Intrinsics.areEqual((Object)this.signKeyPair, (Object)secureKeyPair.signKeyPair)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cryptKeyPair, (Object)secureKeyPair.cryptKeyPair);
    }
}

